<?php
namespace __SystemLib {
// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://docs.hhvm.com/manual/en/class.exception.php )
 *
 * Exception is the base class for all Exceptions.
 *
 */
trait BaseException {
  require implements Throwable;

  protected $message = '';  // exception message
  private $string = '';     // php5 has this, we don't use it
  protected $code = 0;      // user defined exception code
  protected $file;          // source filename of exception
  protected $line;          // source line of exception
  private $trace;           // full stacktrace
  private $previous = null;

  private static $traceOpts = 0;

  /*
   * There is no constructor in this trait-- It should be possible to extend
   * Exception and add a PHP4 constructor, traits play poorly with PHP4
   * constructors.
   */

  /**
   * This cannot be implemented in __construct, because a derived class may
   * implement its own __construct, losing the stacktrace. The runtime has
   * special logic to call the __init__ method before
   * calling __construct just to make sure $this->trace is always populated.
   */
  final public function __init__() {
    if (isset($this->trace)) {
      return;
    }
    $this->initTrace();
  }

  private function __check_init($context) {
    if (!isset($this->trace)) {
      \trigger_error($context.': exception object not initialized', E_WARNING);
      return false;
    } else {
      return true;
    }
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.getmessage.php )
   *
   * Returns the Exception message.
   *
   * @return     mixed   Returns the Exception message as a string.
   */
  public function getMessage() {
    return $this->message;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.getprevious.php )
   *
   * Returns previous Exception (the third parameter of
   * Exception::__construct()).
   *
   * @return     mixed   Returns the previous Exception if available or NULL
   *                     otherwise.
   */
  final public function getPrevious() {
    return $this->previous;
  }

  final public function setPrevious(\__SystemLib\Throwable $previous) {
    $this->previous = $previous;
  }

  final public function setPreviousChain(\__SystemLib\Throwable $previous) {
    $cur = $this;
    $next = $cur->getPrevious();
    while ($next instanceof \__SystemLib\Throwable) {
      $cur = $next;
      $next = $cur->getPrevious();
    }
    $cur->setPrevious($previous);
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.getcode.php )
   *
   * Returns the Exception code.
   *
   * @return     mixed   Returns the exception code as integer in Exception
   *                     but possibly as other type in Exception descendants
   *                     (for example as string in PDOException).
   */
  public function getCode() {
    return $this->code;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.getfile.php )
   *
   * Get the name of the file the exception was created.
   *
   * @return     mixed   Returns the filename in which the exception was
   *                     created.
   */
  final public function getFile() {
    if (!$this->__check_init(__METHOD__)) {
      return null;
    }
    return $this->file;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.getline.php )
   *
   * Get line number where the exception was created.
   *
   * @return     mixed   Returns the line number where the exception was
   *                     created.
   */
  final public function getLine() {
    if (!$this->__check_init(__METHOD__)) {
      return null;
    }
    return $this->line;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.gettrace.php )
   *
   * Returns the Exception stack trace.
   *
   * @return     mixed   Returns the Exception stack trace as an array.
   */
  final public function getTrace() {
    if (!$this->__check_init(__METHOD__)) {
      return null;
    }
    return $this->trace;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.gettraceasstring.php )
   *
   * Returns the Exception stack trace as a string.
   *
   * @return     mixed   Returns the Exception stack trace as a string.
   */
  final public function getTraceAsString() {
    if (!$this->__check_init(__METHOD__)) {
      return null;
    }
    $i = 0;
    $s = "";
    foreach ($this->getTrace() as $frame) {
      if (!\is_array($frame)) continue;
      $s .= "#$i " .
        (isset($frame['file']) ? $frame['file'] : "") . "(" .
        (isset($frame['line']) ? $frame['line'] : "") . "): " .
        (isset($frame['class']) ? $frame['class'] . $frame['type'] : "") .
        $frame['function'] . "()\n";
      $i++;
    }
    $s .= "#$i {main}";
    return $s;
  }

  /* Overrideable */
  // formated string for display
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/exception.tostring.php )
   *
   * Returns the string representation of the exception.
   *
   * @return     mixed   Returns the string representation of the exception.
   */
  public function __toString() {
    $res = "";
    $lst = array();
    $ex = $this;
    while ($ex != null) {
      $lst[] = $ex;
      $ex = $ex->getPrevious();
    }
    $lst = \array_reverse($lst);
    foreach ($lst as $i => $ex) {
      if ($i > 0) {
        $res .= "\n\nNext ";
      }
      $cls = \get_class($ex);
      if (\substr($cls, 0, strlen("__SystemLib\\")) === "__SystemLib\\") {
        $cls = \substr($cls, strlen("__SystemLib\\"));
      }
      $res .= $ex instanceof Error
        ? $cls . ": " . $ex->getMessage()
        : "exception '" . $cls . "' with message '" . $ex->getMessage() . "'";
      $res .=  " in " . $ex->getFile() . ":" .
        $ex->getLine() . "\nStack trace:\n" . $ex->getTraceAsString();
    }
    return $res;
  }

  /**
   * Derived classes may override the methods below if different behavior
   * for initializing the trace is desired
   */
  protected function initTrace() {
    $this->trace = \debug_backtrace(static::getTraceOptions());
    // Remove top stack frames up to and including Exception::__init__,
    // set the 'file' and 'line' properties appropriately
    while (!empty($this->trace)) {
      $top = \array_shift($this->trace);
      if (isset($top['class']) && isset($top['function']) &&
          (\strcasecmp($top['class'], 'exception') === 0 ||
           \strcasecmp($top['class'], '__systemlib\error') === 0) &&
          \strcasecmp($top['function'], '__init__') === 0) {
        if (isset($top['file'])) $this->file = $top['file'];
        if (isset($top['line'])) $this->line = $top['line'];
        break;
      }
    }
    // Remove systemlib stack frames until we hit the user code.
    // Assume user code will contain the elements for file and line.
    if (($this->file === null) && ($this->line === null)) {
      while (!empty($this->trace)
        && !isset($this->trace[0]['file']) && !isset($this->trace[0]['line'])
      ) {
        \array_shift($this->trace);
      }
      if (isset($this->trace[0]['file'])) {
        $this->file = $this->trace[0]['file'];
      }
      if (isset($this->trace[0]['line'])) {
        $this->line = $this->trace[0]['line'];
      }
    }
  }

  public static function getTraceOptions() {
    return self::$traceOpts;
  }

  public static function setTraceOptions($opts) {
    self::$traceOpts = (int)$opts;
  }

  final private function __clone() {
    \trigger_error("Trying to clone an uncloneable object of class " .
                   \get_class($this), E_USER_ERROR);
  }
}
}
