------------------------------------------------
-- TECH MAPS
------------------------------------------------
-- a centralized collection of maps for use by TechRacer and other scripts.
-- hopefully keeps things a bit cleaner and makes cross-script editing easier.

--------------
-- TO DO
--------------
-- continue to fix/improve old/broken/incompatible maps, and add more maps.
-- add ufo fuel per map


HedgewarsScriptLoad("/Scripts/Tracker.lua")
HedgewarsScriptLoad("/Scripts/Utils.lua")

techX = {}
techY = {}
techCount = 1

function AddWayPoint(x,y)
	techX[techCount] = x
	techY[techCount] = y
	techCount = techCount +1
end

-- this handles interim lazy copypasta from HedgeEditor
-- while I'm still messing with things
function LoadSprite(pX, pY, pSprite, pFrame, pTint, p1, p2, p3, pLandFlags)
	PlaceSprite(pX, pY, pSprite, pFrame, pTint, p1, p2, p3, pLandFlags)
end
function PreviewWayPoint(x,y)
    AddPoint(x,y,20)
    AddPoint(x,y,19,true)
    for i = 0,100,50 do
        AddPoint(x-120,y+i,1,true)
        AddPoint(x+120,y-i)
        AddPoint(x-i,y+120,1,true)
        AddPoint(x+i,y-120)
    end
end

function PreviewGirder(x, y, f)
    if f == 0 then
        AddPoint(x-40,y,1)
        AddPoint(x+40,y)
    elseif f == 1 then
        AddPoint(x-29,y-29,1)
        AddPoint(x+29,y+29)
    elseif f == 2 then
        AddPoint(x,y-40,1)
        AddPoint(x,y+40)
    elseif f == 3 then
        AddPoint(x-29,y+29,1)
        AddPoint(x+29,y-29)
    elseif f == 4 then
        AddPoint(x-79,y,1)
        AddPoint(x+79,y)
    elseif f == 5 then
        AddPoint(x-54,y-54,1)
        AddPoint(x+54,y+54)
    elseif f == 6 then
        AddPoint(x,y-80,1)
        AddPoint(x,y+80)
    elseif f == 7 then
        AddPoint(x-54,y+54,1)
        AddPoint(x+54,y-54)
    end
end

function PreviewRubber(x, y, f)
	if f == 0 then
        AddPoint(x-79,y,1)
        AddPoint(x+79,y)
    elseif f == 1 then
        AddPoint(x-54,y-54,1)
        AddPoint(x+54,y+54)
    elseif f == 2 then
        AddPoint(x,y-80,1)
        AddPoint(x,y+80)
    elseif f == 3 then
        AddPoint(x-54,y+54,1)
        AddPoint(x+54,y-54)
    end
end

function PreviewPlacedGear(x, y)
	AddPoint(x,y,2)
end

function onPreviewInit()
	if HedgeEditor == true then
		return
	end

        if MapGen == mgDrawn then
	    eraseMap(false)
        else
	    MapGen = mgDrawn
        end

	if mapID == nil then
		mapID = 2 + GetRandom(7)
	end
	WriteLnToConsole("TechRacer preview: Using map #"..tostring(mapID-1).." (mapID="..tostring(mapID)..")")

    TemplateFilter = 0

    for x = 1, 16 do
        AddPoint(x*100,100,5)
    end

	if mapID == 1 then
			--
	elseif mapID == 2 then
			PreviewWayPoint(387, 621)
		PreviewWayPoint(215, 1748)
		PreviewWayPoint(1617, 1313)
		PreviewWayPoint(1642, 562)
		PreviewWayPoint(3318, 1102)
		PreviewWayPoint(3554, 684)
		PreviewWayPoint(2142, 1674)
		PreviewGirder(402, 1863, 0)
		PreviewGirder(442, 1863, 4)
		PreviewGirder(2067, 1945, 6)
		PreviewGirder(1943, 1653, 6)
		PreviewGirder(1999, 1504, 7)
		PreviewGirder(2143, 1445, 4)
		PreviewGirder(2432, 1565, 4)
		PreviewGirder(2593, 1565, 4)
		PreviewGirder(2752, 1565, 4)
		PreviewGirder(2206, 1949, 6)
		PreviewGirder(2262, 1800, 7)
		PreviewGirder(2407, 1745, 4)
		PreviewGirder(2569, 1745, 4)
		PreviewGirder(2005, 1797, 5)
		PreviewGirder(2288, 1503, 5)
		PreviewGirder(2715, 1802, 5)
		PreviewGirder(2898, 1624, 5)
		PreviewGirder(3014, 1740, 5)
		PreviewGirder(2830, 1919, 5)
		PreviewGirder(3131, 1856, 5)
		PreviewGirder(3191, 1968, 2)
		PreviewGirder(3264, 2021, 4)
		PreviewGirder(2840, 2006, 3)
		PreviewGirder(396, 665, 1)
		PreviewGirder(619, 665, 3)
		PreviewGirder(696, 635, 0)
		PreviewGirder(319, 637, 0)
		PreviewGirder(268, 604, 2)
		PreviewGirder(746, 603, 2)
		PreviewGirder(325, 495, 7)
		PreviewGirder(689, 493, 5)
		PreviewGirder(504, 422, 6)
		PreviewGirder(595, 422, 4)
		PreviewGirder(412, 422, 4)
		PreviewGirder(320, 696, 4)
		PreviewGirder(249, 786, 6)
		PreviewGirder(249, 948, 6)
		PreviewGirder(191, 785, 6)
		PreviewGirder(191, 946, 6)
		PreviewGirder(191, 1107, 6)
		PreviewGirder(249, 1109, 6)
		PreviewGirder(130, 1251, 7)
		PreviewGirder(306, 1251, 5)
		PreviewGirder(72, 1360, 2)
		PreviewGirder(364, 1360, 2)
		PreviewGirder(132, 1462, 5)
		PreviewGirder(304, 1463, 7)
		PreviewGirder(182, 1616, 6)
		PreviewGirder(255, 1613, 6)
		PreviewGirder(217, 1796, 4)
		PreviewGirder(221, 1381, 0)
		PreviewGirder(154, 669, 1)
		PreviewGirder(124, 553, 6)
		PreviewGirder(326, 467, 3)
		PreviewGirder(223, 592, 3)
		PreviewGirder(638, 791, 5)
		PreviewGirder(752, 907, 5)
		PreviewGirder(866, 1022, 5)
		PreviewGirder(1505, 395, 7)
		PreviewGirder(1445, 544, 6)
		PreviewGirder(1506, 686, 5)
		PreviewGirder(1650, 339, 4)
		PreviewGirder(1797, 397, 5)
		PreviewGirder(1857, 547, 6)
		PreviewGirder(1797, 688, 7)
		PreviewGirder(1652, 754, 4)
		PreviewGirder(3326, 863, 4)
		PreviewGirder(3474, 921, 5)
		PreviewGirder(3180, 921, 7)
		PreviewGirder(3120, 1071, 6)
		PreviewGirder(3183, 1214, 5)
		PreviewGirder(3536, 1071, 6)
		PreviewGirder(3480, 1214, 7)
		PreviewGirder(3330, 1279, 4)
		PreviewGirder(1481, 1133, 7)
		PreviewGirder(1626, 1078, 4)
		PreviewGirder(1772, 1135, 5)
		PreviewGirder(1422, 1280, 6)
		PreviewGirder(1831, 1286, 6)
		PreviewGirder(1773, 1429, 7)
		PreviewGirder(1627, 1492, 4)
		PreviewGirder(1482, 1427, 5)
		PreviewGirder(587, 855, 4)
		PreviewGirder(425, 855, 4)
		PreviewGirder(302, 822, 1)
		PreviewGirder(2502, 556, 7)
		PreviewGirder(2601, 634, 7)
		PreviewGirder(2616, 441, 7)
		PreviewGirder(2716, 519, 7)
		PreviewGirder(3469, 556, 7)
		PreviewGirder(3696, 763, 7)
		PreviewGirder(2756, 379, 4)
		PreviewGirder(2862, 466, 4)
		PreviewGirder(2918, 379, 4)
		PreviewGirder(3023, 467, 4)
		PreviewGirder(3080, 378, 4)
		PreviewGirder(3616, 503, 4)
		PreviewGirder(3552, 828, 4)
		PreviewGirder(3172, 527, 5)
		PreviewGirder(3232, 428, 5)
		PreviewGirder(3289, 647, 5)
		PreviewGirder(3350, 545, 5)
		PreviewGirder(3406, 764, 5)
		PreviewGirder(3708, 575, 6)
		PreviewGirder(3705, 680, 1)
		PreviewRubber(505, 708, 0)
		PreviewRubber(175, 451, 0)
		PreviewRubber(822, 1693, 0)
		PreviewRubber(982, 1691, 0)
		PreviewRubber(1142, 1688, 0)
		PreviewRubber(1302, 1684, 0)
		PreviewRubber(1450, 1750, 1)
		PreviewRubber(1566, 1860, 1)
		PreviewRubber(1680, 1973, 1)

		PreviewPlacedGear(324, 613)
		PreviewPlacedGear(2361, 1721)
		PreviewPlacedGear(2430, 1721)
		PreviewPlacedGear(2510, 1721)
		PreviewPlacedGear(2581, 1721)
		PreviewPlacedGear(405, 1839)
		PreviewPlacedGear(481, 1839)
		PreviewPlacedGear(696, 611)
		PreviewPlacedGear(825, 1664)
		PreviewPlacedGear(919, 1657)
		PreviewPlacedGear(1015, 1662)
		PreviewPlacedGear(1095, 1654)
		PreviewPlacedGear(1166, 1659)
		PreviewPlacedGear(1250, 1650)
		PreviewPlacedGear(1335, 1655)
	elseif mapID == 3 then
			PreviewWayPoint(3892, 478)
		PreviewWayPoint(1146, 413)
		PreviewWayPoint(934, 1459)
		PreviewWayPoint(2635, 1459)
		PreviewWayPoint(2656, 523)
		PreviewWayPoint(1958, 834)
		PreviewWayPoint(555, 864)
		PreviewGirder(3703, 157, 7)
		PreviewGirder(3846, 100, 4)
		PreviewGirder(3991, 162, 5)
		PreviewGirder(4049, 311, 6)
		PreviewGirder(3648, 308, 6)
		PreviewGirder(3988, 454, 7)
		PreviewGirder(3843, 515, 4)
		PreviewGirder(3616, 429, 3)
		PreviewGirder(3725, 548, 3)
		PreviewGirder(1155, 95, 6)
		PreviewGirder(1067, 167, 4)
		PreviewGirder(906, 167, 4)
		PreviewGirder(747, 167, 4)
		PreviewGirder(586, 167, 4)
		PreviewGirder(426, 167, 4)
		PreviewGirder(266, 166, 4)
		PreviewGirder(105, 166, 4)

		PreviewPlacedGear(3801, 491)
		PreviewPlacedGear(3803, 460)
		PreviewPlacedGear(3799, 429)
		PreviewPlacedGear(3846, 491)
		PreviewPlacedGear(3845, 460)
		PreviewPlacedGear(3845, 429)
		PreviewPlacedGear(3684, 595)
		PreviewPlacedGear(3648, 641)
		PreviewPlacedGear(3613, 695)
		PreviewPlacedGear(3575, 733)
		PreviewPlacedGear(3537, 781)
		PreviewPlacedGear(3505, 829)
		PreviewPlacedGear(3476, 881)
		PreviewPlacedGear(3447, 930)
		PreviewPlacedGear(3418, 979)
		PreviewPlacedGear(3388, 1021)
		PreviewPlacedGear(3356, 1072)
		PreviewPlacedGear(3561, 469)
		PreviewPlacedGear(3528, 500)
		PreviewPlacedGear(3496, 545)
		PreviewPlacedGear(3467, 584)
		PreviewPlacedGear(3444, 619)
		PreviewPlacedGear(3404, 656)
		PreviewPlacedGear(3373, 693)
		PreviewPlacedGear(3351, 726)
		PreviewPlacedGear(3329, 756)
		PreviewPlacedGear(3306, 798)
		PreviewPlacedGear(3339, 1115)
		PreviewPlacedGear(3321, 1163)
		PreviewPlacedGear(3298, 1206)
		PreviewPlacedGear(3281, 1250)
		PreviewPlacedGear(3259, 1302)
		PreviewPlacedGear(3238, 1343)
		PreviewPlacedGear(3220, 1397)
		PreviewPlacedGear(3269, 810)
		PreviewPlacedGear(3225, 788)
		PreviewPlacedGear(3188, 762)
		PreviewPlacedGear(3149, 735)
		PreviewPlacedGear(3106, 709)
		PreviewPlacedGear(3064, 682)
		PreviewPlacedGear(3023, 652)
		PreviewPlacedGear(2983, 619)
		PreviewPlacedGear(3135, 980)
		PreviewPlacedGear(3143, 1029)
		PreviewPlacedGear(3130, 1077)
		PreviewPlacedGear(3122, 1127)
		PreviewPlacedGear(3100, 1174)
		PreviewPlacedGear(3069, 1226)
		PreviewPlacedGear(3042, 1287)
		PreviewPlacedGear(3178, 1440)
		PreviewPlacedGear(3125, 1480)
		PreviewPlacedGear(3088, 1521)
		PreviewPlacedGear(2988, 1326)
		PreviewPlacedGear(2944, 1357)
		PreviewPlacedGear(2884, 1356)
		PreviewPlacedGear(2813, 1356)
		PreviewPlacedGear(2755, 1356)
		PreviewPlacedGear(2677, 1347)
		PreviewPlacedGear(2610, 1356)
		PreviewPlacedGear(2532, 1354)
		PreviewPlacedGear(3045, 1553)
		PreviewPlacedGear(2974, 1588)
		PreviewPlacedGear(2901, 1584)
		PreviewPlacedGear(2850, 1569)
		PreviewPlacedGear(2782, 1570)
		PreviewPlacedGear(2708, 1577)
		PreviewPlacedGear(2648, 1579)
		PreviewPlacedGear(2585, 1576)
		PreviewPlacedGear(2525, 1581)
		PreviewPlacedGear(2490, 1338)
		PreviewPlacedGear(2435, 1306)
		PreviewPlacedGear(2386, 1283)
		PreviewPlacedGear(2344, 1242)
		PreviewPlacedGear(3126, 942)
		PreviewPlacedGear(3070, 919)
		PreviewPlacedGear(3005, 897)
		PreviewPlacedGear(2962, 865)
		PreviewPlacedGear(2907, 838)
		PreviewPlacedGear(2858, 803)
		PreviewPlacedGear(2807, 769)
		PreviewPlacedGear(2764, 741)
		PreviewPlacedGear(2714, 703)
		PreviewPlacedGear(2665, 671)
		PreviewPlacedGear(2613, 629)
		PreviewPlacedGear(2557, 591)
		PreviewPlacedGear(2513, 545)
		PreviewPlacedGear(2450, 537)
		PreviewPlacedGear(2390, 569)
		PreviewPlacedGear(2341, 603)
		PreviewPlacedGear(2299, 649)
		PreviewPlacedGear(2255, 684)
		PreviewPlacedGear(2218, 714)
		PreviewPlacedGear(2173, 756)
		PreviewPlacedGear(2125, 801)
		PreviewPlacedGear(2084, 864)
		PreviewPlacedGear(2113, 933)
		PreviewPlacedGear(2154, 974)
		PreviewPlacedGear(2191, 1016)
		PreviewPlacedGear(2223, 1061)
		PreviewPlacedGear(2257, 1113)
		PreviewPlacedGear(2283, 1153)
		PreviewPlacedGear(2316, 1202)
		PreviewPlacedGear(2479, 1553)
		PreviewPlacedGear(2422, 1513)
		PreviewPlacedGear(2363, 1477)
		PreviewPlacedGear(2302, 1446)
		PreviewPlacedGear(2243, 1388)
		PreviewPlacedGear(2188, 1335)
		PreviewPlacedGear(2136, 1273)
		PreviewPlacedGear(2086, 1204)
		PreviewPlacedGear(2033, 1132)
		PreviewPlacedGear(1992, 1085)
		PreviewPlacedGear(1967, 1022)
		PreviewPlacedGear(2943, 560)
		PreviewPlacedGear(2890, 511)
		PreviewPlacedGear(2834, 477)
		PreviewPlacedGear(2774, 451)
		PreviewPlacedGear(2710, 428)
		PreviewPlacedGear(2652, 410)
		PreviewPlacedGear(2578, 375)
		PreviewPlacedGear(2482, 342)
		PreviewPlacedGear(2380, 335)
		PreviewPlacedGear(2302, 359)
		PreviewPlacedGear(2256, 409)
		PreviewPlacedGear(2183, 469)
		PreviewPlacedGear(2111, 513)
		PreviewPlacedGear(2049, 558)
		PreviewPlacedGear(1986, 586)
		PreviewPlacedGear(1742, 412)
		PreviewPlacedGear(1684, 376)
		PreviewPlacedGear(1627, 344)
		PreviewPlacedGear(1566, 325)
		PreviewPlacedGear(1505, 298)
		PreviewPlacedGear(1727, 695)
		PreviewPlacedGear(1917, 1067)
		PreviewPlacedGear(1874, 1122)
		PreviewPlacedGear(1923, 557)
		PreviewPlacedGear(1863, 501)
		PreviewPlacedGear(1796, 447)
		PreviewPlacedGear(1829, 1158)
		PreviewPlacedGear(1778, 1201)
		PreviewPlacedGear(1732, 1244)
		PreviewPlacedGear(1700, 1290)
		PreviewPlacedGear(1652, 1333)
		PreviewPlacedGear(1599, 1380)
		PreviewPlacedGear(1550, 1425)
		PreviewPlacedGear(1493, 1483)
		PreviewPlacedGear(1443, 1519)
		PreviewPlacedGear(1381, 1557)
		PreviewPlacedGear(1304, 1590)
		PreviewPlacedGear(1237, 1613)
		PreviewPlacedGear(1176, 1621)
		PreviewPlacedGear(1104, 1626)
		PreviewPlacedGear(1032, 1630)
		PreviewPlacedGear(964, 1628)
		PreviewPlacedGear(886, 1615)
		PreviewPlacedGear(813, 1584)
		PreviewPlacedGear(750, 1524)
		PreviewPlacedGear(697, 1473)
		PreviewPlacedGear(645, 1410)
		PreviewPlacedGear(602, 1351)
		PreviewPlacedGear(557, 1284)
		PreviewPlacedGear(506, 1230)
		PreviewPlacedGear(467, 1144)
		PreviewPlacedGear(449, 1066)
		PreviewPlacedGear(421, 980)
		PreviewPlacedGear(425, 876)
		PreviewPlacedGear(422, 789)
		PreviewPlacedGear(434, 699)
		PreviewPlacedGear(439, 625)
		PreviewPlacedGear(481, 551)
		PreviewPlacedGear(537, 494)
		PreviewPlacedGear(586, 444)
		PreviewPlacedGear(633, 393)
		PreviewPlacedGear(674, 360)
		PreviewPlacedGear(745, 332)
		PreviewPlacedGear(1786, 816)
		PreviewPlacedGear(1768, 744)
		PreviewPlacedGear(1765, 875)
		PreviewPlacedGear(1711, 936)
		PreviewPlacedGear(1629, 1016)
		PreviewPlacedGear(1579, 1072)
		PreviewPlacedGear(1520, 1123)
		PreviewPlacedGear(1462, 1185)
		PreviewPlacedGear(1415, 1238)
		PreviewPlacedGear(1361, 1288)
		PreviewPlacedGear(1298, 1318)
		PreviewPlacedGear(1230, 1345)
		PreviewPlacedGear(1161, 1357)
		PreviewPlacedGear(1097, 1367)
		PreviewPlacedGear(1033, 1373)
		PreviewPlacedGear(971, 1333)
		PreviewPlacedGear(900, 1291)
		PreviewPlacedGear(840, 1225)
		PreviewPlacedGear(795, 1156)
		PreviewPlacedGear(744, 1076)
		PreviewPlacedGear(706, 995)
		PreviewPlacedGear(674, 927)
		PreviewPlacedGear(687, 859)
		PreviewPlacedGear(719, 781)
		PreviewPlacedGear(742, 720)
		PreviewPlacedGear(801, 297)
		PreviewPlacedGear(880, 280)
		PreviewPlacedGear(954, 275)
		PreviewPlacedGear(1020, 268)
		PreviewPlacedGear(1093, 265)
		PreviewPlacedGear(1174, 258)
		PreviewPlacedGear(1270, 257)
		PreviewPlacedGear(1338, 262)
		PreviewPlacedGear(1433, 260)
		PreviewPlacedGear(779, 657)
		PreviewPlacedGear(824, 624)
		PreviewPlacedGear(879, 592)
		PreviewPlacedGear(928, 564)
		PreviewPlacedGear(995, 544)
		PreviewPlacedGear(1055, 541)
		PreviewPlacedGear(1121, 540)
		PreviewPlacedGear(1184, 534)
		PreviewPlacedGear(1252, 536)
		PreviewPlacedGear(1317, 542)
		PreviewPlacedGear(1380, 553)
		PreviewPlacedGear(1448, 567)
		PreviewPlacedGear(1521, 582)
		PreviewPlacedGear(1580, 600)
		PreviewPlacedGear(1633, 626)
		PreviewPlacedGear(1683, 651)
	elseif mapID == 4 then
			PreviewWayPoint(337, 533)
		PreviewWayPoint(1069, 1367)
		PreviewWayPoint(884, 729)
		PreviewWayPoint(1682, 464)
		PreviewWayPoint(2773, 505)
		PreviewWayPoint(3512, 929)
		PreviewWayPoint(4002, 106)
		PreviewWayPoint(3964, 1520)
		PreviewWayPoint(2592, 1334)
		PreviewGirder(194, 388, 7)
		PreviewGirder(338, 334, 4)
		PreviewGirder(484, 390, 5)
		PreviewGirder(139, 543, 6)
		PreviewGirder(544, 540, 6)
		PreviewGirder(201, 687, 5)
		PreviewGirder(485, 684, 7)
		PreviewGirder(259, 839, 6)
		PreviewGirder(426, 837, 6)
		PreviewGirder(259, 999, 6)
		PreviewGirder(426, 998, 6)
		PreviewGirder(259, 1159, 6)
		PreviewGirder(426, 1158, 6)
		PreviewGirder(259, 1318, 6)
		PreviewGirder(426, 1318, 6)
		PreviewGirder(426, 1478, 6)
		PreviewGirder(259, 1478, 6)
		PreviewGirder(515, 1477, 4)
		PreviewGirder(659, 1537, 5)
		PreviewGirder(774, 1652, 5)
		PreviewGirder(836, 1799, 6)
		PreviewGirder(907, 1890, 4)
		PreviewGirder(1067, 1890, 4)
		PreviewGirder(1212, 1823, 7)
		PreviewGirder(1359, 1764, 4)
		PreviewGirder(1504, 1822, 5)
		PreviewGirder(1647, 1886, 4)
		PreviewGirder(1807, 1886, 4)
		PreviewGirder(1362, 1869, 4)
		PreviewGirder(1968, 1885, 4)
		PreviewGirder(2111, 1823, 7)
		PreviewGirder(2257, 1769, 4)
		PreviewGirder(2403, 1825, 5)
		PreviewGirder(2549, 1887, 4)
		PreviewGirder(2709, 1887, 4)
		PreviewGirder(2868, 1887, 4)
		PreviewGirder(2958, 1854, 2)
		PreviewGirder(2928, 1773, 1)
		PreviewGirder(2898, 1692, 2)
		PreviewGirder(2928, 1613, 3)
		PreviewGirder(3045, 1584, 4)
		PreviewGirder(3162, 1619, 1)
		PreviewGirder(3192, 1697, 2)
		PreviewGirder(3160, 1777, 3)
		PreviewGirder(3128, 1857, 2)
		PreviewGirder(3218, 1886, 4)
		PreviewGirder(3379, 1885, 4)
		PreviewGirder(3524, 1818, 7)
		PreviewGirder(3641, 1702, 7)
		PreviewGirder(3756, 1585, 7)
		PreviewGirder(4021, 1316, 7)
		PreviewGirder(3842, 1503, 3)
		PreviewGirder(3899, 1409, 7)
		PreviewGirder(3694, 1974, 7)
		PreviewGirder(3809, 1858, 7)
		PreviewGirder(3925, 1741, 7)
		PreviewGirder(4022, 1613, 7)
		PreviewGirder(2256, 1877, 4)
		PreviewGirder(3046, 1728, 0)
		PreviewGirder(501, 1777, 6)
		PreviewGirder(572, 1868, 4)
		PreviewGirder(3372, 771, 7)
		PreviewGirder(3517, 715, 4)
		PreviewGirder(3663, 774, 5)
		PreviewGirder(3313, 923, 6)
		PreviewGirder(3373, 1066, 5)
		PreviewGirder(3518, 1128, 4)
		PreviewGirder(3662, 1065, 7)
		PreviewGirder(3723, 924, 6)
		PreviewGirder(2474, 1373, 6)
		PreviewGirder(2474, 1252, 2)
		PreviewGirder(2507, 1200, 0)
		PreviewGirder(2626, 1200, 4)
		PreviewGirder(2716, 1270, 6)
		PreviewGirder(2505, 1464, 0)
		PreviewGirder(2625, 1464, 4)
		PreviewGirder(2716, 1391, 6)
		PreviewGirder(1544, 300, 7)
		PreviewGirder(1691, 245, 4)
		PreviewGirder(1838, 304, 5)
		PreviewGirder(1487, 453, 6)
		PreviewGirder(1548, 597, 5)
		PreviewGirder(1692, 657, 4)
		PreviewGirder(1835, 593, 7)
		PreviewGirder(1900, 451, 6)
		PreviewGirder(3527, 93, 6)
		PreviewGirder(3586, 238, 5)
		PreviewGirder(3703, 354, 5)
		PreviewGirder(3820, 471, 5)
		PreviewGirder(3938, 588, 5)
		PreviewGirder(4044, 651, 0)
		PreviewGirder(3618, 22, 4)
		PreviewGirder(3779, 22, 4)
		PreviewGirder(3939, 22, 4)
		PreviewGirder(4047, 22, 0)
		PreviewGirder(936, 1198, 7)
		PreviewGirder(1080, 1143, 4)
		PreviewGirder(1225, 1202, 5)
		PreviewGirder(1278, 1352, 6)
		PreviewGirder(881, 1351, 6)
		PreviewGirder(943, 1496, 5)
		PreviewGirder(1219, 1495, 7)
		PreviewGirder(1160, 1645, 6)
		PreviewGirder(998, 1649, 6)
		PreviewGirder(1160, 1766, 2)
		PreviewGirder(998, 1770, 2)
		PreviewGirder(1077, 1824, 4)
		PreviewGirder(1824, 1138, 6)
		PreviewGirder(834, 606, 7)
		PreviewGirder(950, 593, 5)
		PreviewGirder(1035, 683, 1)
		PreviewGirder(748, 696, 3)
		PreviewGirder(764, 780, 5)
		PreviewGirder(850, 870, 1)
		PreviewGirder(937, 850, 7)
		PreviewGirder(1018, 768, 7)
		PreviewGirder(2589, 444, 7)
		PreviewGirder(2704, 329, 7)
		PreviewGirder(2604, 560, 5)
		PreviewGirder(2719, 675, 5)
		PreviewGirder(2832, 689, 7)
		PreviewGirder(2947, 573, 7)
		PreviewGirder(2820, 317, 5)
		PreviewGirder(2936, 433, 5)
		PreviewGirder(2987, 489, 1)
		PreviewGirder(338, 559, 4)

		PreviewPlacedGear(548, 1844)
		PreviewPlacedGear(595, 1844)
		PreviewPlacedGear(642, 1844)
		PreviewPlacedGear(1314, 1845)
		PreviewPlacedGear(1362, 1845)
		PreviewPlacedGear(1419, 1845)
		PreviewPlacedGear(2208, 1853)
		PreviewPlacedGear(2264, 1853)
		PreviewPlacedGear(2318, 1853)
		PreviewPlacedGear(3027, 1704)
		PreviewPlacedGear(3072, 1704)
		PreviewPlacedGear(1822, 1042)
		PreviewPlacedGear(313, 535)
		PreviewPlacedGear(365, 535)
		PreviewPlacedGear(313, 504)
		PreviewPlacedGear(339, 478)
		PreviewPlacedGear(365, 504)
		PreviewPlacedGear(3517, 995)
		PreviewPlacedGear(3448, 858)
		PreviewPlacedGear(3582, 848)
		PreviewPlacedGear(3758, 158)
		PreviewPlacedGear(3964, 297)
		PreviewPlacedGear(2772, 506)
		PreviewPlacedGear(2602, 1339)
		PreviewPlacedGear(1638, 370)
		PreviewPlacedGear(1743, 522)
		PreviewPlacedGear(894, 726)
		PreviewPlacedGear(1080, 1690)
	elseif mapID == 5 then
			PreviewWayPoint(3761, 428)
		PreviewWayPoint(750, 1801)
		PreviewWayPoint(511, 1232)
		PreviewWayPoint(1579, 297)
		PreviewWayPoint(2007, 1618)
		PreviewWayPoint(3642, 1601)
		PreviewRubber(3776, 447, 3)
		PreviewRubber(3629, 503, 0)
		PreviewRubber(3486, 446, 1)
		PreviewRubber(3234, 889, 1)
		PreviewRubber(3084, 838, 0)
		PreviewRubber(2943, 909, 3)
		PreviewRubber(2665, 507, 3)
		PreviewRubber(2520, 557, 0)
		PreviewRubber(2377, 496, 1)
		PreviewRubber(2507, 1263, 1)
		PreviewRubber(2355, 1212, 0)
		PreviewRubber(2206, 1269, 3)
		PreviewRubber(1902, 1270, 1)
		PreviewRubber(1749, 1221, 0)
		PreviewRubber(1607, 1288, 3)
		PreviewRubber(1781, 1659, 1)
		PreviewRubber(1927, 1706, 0)
		PreviewRubber(2089, 1702, 0)
		PreviewRubber(2234, 1649, 3)
		PreviewRubber(3413, 1631, 1)
		PreviewRubber(3558, 1676, 0)
		PreviewRubber(3718, 1673, 0)
		PreviewRubber(3866, 1616, 3)
		PreviewRubber(807, 803, 2)
		PreviewRubber(806, 1131, 2)
		PreviewRubber(732, 1273, 3)
		PreviewRubber(583, 1324, 0)
		PreviewRubber(420, 1324, 0)
		PreviewRubber(272, 1274, 1)
		PreviewRubber(222, 1121, 2)
		PreviewRubber(221, 956, 2)
		PreviewRubber(221, 792, 2)
		PreviewRubber(271, 644, 3)
		PreviewRubber(420, 589, 0)
		PreviewRubber(584, 588, 0)
		PreviewRubber(730, 658, 1)
		PreviewRubber(612, 1846, 1)
		PreviewRubber(758, 1896, 0)
		PreviewRubber(903, 1835, 3)
		PreviewRubber(1051, 1781, 0)
		PreviewRubber(1210, 1780, 0)
		PreviewRubber(1356, 1845, 1)
		PreviewRubber(1501, 1891, 0)
		PreviewRubber(1438, 431, 3)
		PreviewRubber(1589, 378, 0)
		PreviewRubber(1736, 448, 1)

		PreviewPlacedGear(397, 1295)
		PreviewPlacedGear(461, 1295)
		PreviewPlacedGear(555, 1295)
		PreviewPlacedGear(621, 1295)
		PreviewPlacedGear(759, 1867)
		PreviewPlacedGear(1504, 1862)
		PreviewPlacedGear(2521, 528)
		PreviewPlacedGear(3639, 474)
		PreviewPlacedGear(3078, 809)
		PreviewPlacedGear(1752, 1192)
		PreviewPlacedGear(2349, 1183)
		PreviewPlacedGear(1582, 349)
		PreviewPlacedGear(3560, 1647)
		PreviewPlacedGear(3711, 1644)
		PreviewPlacedGear(433, 560)
		PreviewPlacedGear(568, 559)
		PreviewPlacedGear(1935, 1677)
		PreviewPlacedGear(2084, 1673)
		PreviewPlacedGear(1018, 1752)
		PreviewPlacedGear(1086, 1752)
		PreviewPlacedGear(1176, 1751)
		PreviewPlacedGear(1238, 1751)
		PreviewPlacedGear(2009, 1668)
		PreviewPlacedGear(3641, 1639)
		PreviewPlacedGear(3580, 469)
		PreviewPlacedGear(3700, 467)
		PreviewPlacedGear(2458, 523)
		PreviewPlacedGear(2595, 521)
	elseif mapID == 6 then
		PreviewWayPoint(438, 278)
		PreviewWayPoint(1870, 1354)
		PreviewWayPoint(892, 1119)
		PreviewGirder(419, 298, 4)
		PreviewGirder(348, 387, 6)
		PreviewGirder(521, 359, 0)
		PreviewGirder(459, 385, 3)
		PreviewGirder(570, 387, 6)
		PreviewGirder(601, 298, 0)
		PreviewGirder(348, 547, 6)
		PreviewGirder(570, 547, 6)
		PreviewGirder(348, 707, 6)
		PreviewGirder(570, 707, 6)
		PreviewGirder(397, 466, 0)
		PreviewGirder(458, 491, 1)
		PreviewGirder(521, 592, 0)
		PreviewGirder(458, 620, 3)
		PreviewGirder(397, 713, 0)
		PreviewGirder(459, 740, 1)
		PreviewGirder(348, 867, 6)
		PreviewGirder(570, 866, 6)
		PreviewGirder(641, 1038, 4)
		PreviewGirder(800, 1038, 4)
		PreviewGirder(959, 1038, 4)
		PreviewGirder(482, 1038, 4)
		PreviewGirder(323, 1038, 4)
		PreviewGirder(163, 1038, 4)
		PreviewGirder(48, 1038, 0)
		PreviewGirder(813, 1126, 6)
		PreviewGirder(989, 1127, 6)
		PreviewGirder(989, 1288, 6)
		PreviewGirder(989, 1449, 6)
		PreviewGirder(813, 1287, 6)
		PreviewGirder(813, 1448, 6)
		PreviewGirder(900, 1214, 4)
		PreviewGirder(989, 1570, 2)
		PreviewGirder(813, 1569, 2)
		PreviewGirder(813, 1690, 6)
		PreviewGirder(521, 844, 0)
		PreviewGirder(457, 870, 3)
		PreviewGirder(392, 941, 1)
		PreviewGirder(813, 1851, 6)
		PreviewGirder(813, 1972, 2)
		PreviewGirder(989, 1690, 6)
		PreviewGirder(1044, 1817, 5)
		PreviewGirder(901, 1979, 4)
		PreviewGirder(1002, 2005, 1)
		PreviewGirder(1176, 1873, 4)
		PreviewGirder(1333, 1873, 4)
		PreviewGirder(1491, 1873, 4)
		PreviewGirder(1625, 1815, 7)
		PreviewGirder(1680, 1688, 6)
		PreviewGirder(1669, 1980, 7)
		PreviewGirder(1762, 1929, 0)
		PreviewGirder(1811, 1853, 6)
		PreviewGirder(1811, 1692, 6)
		PreviewGirder(1708, 1735, 3)
		PreviewGirder(1776, 1734, 1)
		PreviewGirder(1680, 1527, 6)
		PreviewGirder(1811, 1532, 6)
		PreviewGirder(1608, 1437, 4)
		PreviewGirder(1883, 1443, 4)
		PreviewGirder(1955, 1354, 6)
		PreviewGirder(1883, 1264, 4)
		PreviewGirder(1723, 1264, 4)
		PreviewGirder(1562, 1264, 4)
		PreviewGirder(1519, 1354, 6)
		PreviewRubber(210, 958, 1)
		PreviewRubber(98, 844, 1)

		PreviewPlacedGear(1740, 1905)
		PreviewPlacedGear(1780, 1905)
		PreviewPlacedGear(1782, 1874)
		PreviewPlacedGear(1782, 1843)
		PreviewPlacedGear(368, 274)
		PreviewPlacedGear(526, 568)
		PreviewPlacedGear(474, 1014)
		PreviewPlacedGear(906, 1955)
		PreviewPlacedGear(837, 1570)
		PreviewPlacedGear(835, 1361)
		PreviewPlacedGear(836, 1425)
		PreviewPlacedGear(833, 1495)
		PreviewPlacedGear(967, 1566)
		PreviewPlacedGear(970, 1354)
		PreviewPlacedGear(967, 1422)
		PreviewPlacedGear(968, 1493)
	elseif mapID == 7 then
			PreviewWayPoint(3820, 342)
		PreviewWayPoint(3343, 1612)
		PreviewWayPoint(272, 351)
		PreviewWayPoint(159, 1774)
		PreviewWayPoint(2248, 1573)
		PreviewWayPoint(1379, 1192)
		PreviewGirder(3699, 436, 0)
		PreviewGirder(934, 806, 6)
		PreviewGirder(934, 969, 6)
		PreviewGirder(1233, 1342, 5)
		PreviewGirder(1377, 1403, 4)
		PreviewGirder(1497, 1376, 3)
		PreviewGirder(2816, 1284, 7)
		PreviewGirder(2698, 1401, 7)
		PreviewGirder(2640, 1552, 6)
		PreviewGirder(2640, 1718, 6)
		PreviewGirder(2641, 1881, 6)
		PreviewGirder(2643, 2007, 2)
		PreviewGirder(3823, 363, 0)
		PreviewGirder(233, 596, 6)
		PreviewGirder(288, 446, 7)
		PreviewGirder(79, 642, 6)
		PreviewGirder(80, 479, 6)
		PreviewGirder(140, 335, 7)
		PreviewGirder(281, 268, 4)
		PreviewGirder(343, 334, 2)
		PreviewGirder(57, 747, 3)
		PreviewGirder(32, 852, 6)
		PreviewGirder(33, 1015, 6)
		PreviewGirder(33, 1179, 6)
		PreviewGirder(34, 1342, 6)
		PreviewGirder(1346, 1939, 6)
		PreviewGirder(1347, 1774, 6)
		PreviewGirder(1294, 1636, 5)
		PreviewGirder(1180, 1522, 5)
		PreviewGirder(1067, 1410, 5)
		PreviewGirder(931, 1357, 4)
		PreviewGirder(772, 1358, 4)
		PreviewGirder(96, 1303, 5)
		PreviewGirder(236, 1362, 4)
		PreviewGirder(396, 1363, 4)
		PreviewGirder(520, 1364, 0)
		PreviewGirder(696, 1450, 6)
		PreviewGirder(556, 1454, 6)
		PreviewGirder(489, 1598, 7)
		PreviewGirder(697, 1574, 2)
		PreviewGirder(639, 1681, 7)
		PreviewGirder(520, 1798, 7)
		PreviewGirder(369, 1715, 7)
		PreviewGirder(243, 1716, 5)
		PreviewGirder(128, 1735, 7)
		PreviewGirder(133, 1870, 5)
		PreviewGirder(251, 1987, 5)
		PreviewGirder(402, 1915, 7)
		PreviewGirder(276, 1938, 4)
		PreviewGirder(95, 140, 4)
		PreviewGirder(257, 140, 4)
		PreviewGirder(419, 140, 4)
		PreviewGirder(581, 140, 4)
		PreviewGirder(742, 140, 4)
		PreviewGirder(903, 140, 4)
		PreviewGirder(1064, 141, 4)
		PreviewGirder(1157, 90, 6)
		PreviewRubber(3433, 237, 3)
		PreviewRubber(3581, 185, 0)
		PreviewRubber(3741, 182, 0)
		PreviewRubber(3879, 257, 1)
		PreviewRubber(3921, 411, 2)
		PreviewRubber(3844, 555, 3)
		PreviewRubber(3692, 615, 0)
		PreviewRubber(3529, 618, 0)
		PreviewRubber(3381, 555, 1)
		PreviewRubber(3282, 289, 0)
		PreviewRubber(3223, 514, 0)
		PreviewRubber(3111, 289, 0)
		PreviewRubber(3058, 516, 0)
		PreviewRubber(2947, 287, 0)
		PreviewRubber(2889, 515, 0)
		PreviewRubber(2785, 288, 0)
		PreviewRubber(2788, 578, 2)
		PreviewRubber(2790, 741, 2)
		PreviewRubber(2862, 884, 1)
		PreviewRubber(2749, 1073, 1)
		PreviewRubber(2865, 1186, 1)
		PreviewRubber(2979, 990, 1)
		PreviewRubber(3123, 1036, 0)
		PreviewRubber(3188, 934, 2)
		PreviewRubber(3010, 1234, 0)
		PreviewRubber(3175, 1230, 0)
		PreviewRubber(3339, 1226, 0)
		PreviewRubber(3345, 949, 2)
		PreviewRubber(3405, 804, 3)
		PreviewRubber(3531, 702, 3)
		PreviewRubber(3444, 1007, 0)
		PreviewRubber(3499, 1221, 0)
		PreviewRubber(3604, 1002, 0)
		PreviewRubber(3755, 1038, 1)
		PreviewRubber(3802, 1186, 2)
		PreviewRubber(3741, 1342, 3)
		PreviewRubber(3626, 1456, 3)
		PreviewRubber(3510, 1314, 3)
		PreviewRubber(3392, 1435, 3)
		PreviewRubber(3506, 1577, 3)
		PreviewRubber(2637, 348, 3)
		PreviewRubber(2583, 496, 2)
		PreviewRubber(2633, 952, 1)
		PreviewRubber(2573, 803, 2)
		PreviewRubber(2474, 556, 0)
		PreviewRubber(2468, 742, 0)
		PreviewRubber(2335, 476, 1)
		PreviewRubber(2214, 358, 1)
		PreviewRubber(2322, 812, 3)
		PreviewRubber(2202, 936, 3)
		PreviewRubber(2060, 305, 0)
		PreviewRubber(1898, 304, 0)
		PreviewRubber(1736, 304, 0)
		PreviewRubber(2085, 1049, 3)
		PreviewRubber(1966, 1161, 3)
		PreviewRubber(1818, 1209, 0)
		PreviewRubber(1657, 1212, 0)
		PreviewRubber(1947, 685, 3)
		PreviewRubber(1801, 735, 0)
		PreviewRubber(1659, 677, 1)
		PreviewRubber(1491, 902, 3)
		PreviewRubber(1346, 955, 0)
		PreviewRubber(1210, 881, 1)
		PreviewRubber(1576, 305, 0)
		PreviewRubber(1414, 304, 0)
		PreviewRubber(1253, 302, 0)
		PreviewRubber(1108, 374, 3)
		PreviewRubber(991, 491, 3)
		PreviewRubber(1557, 1273, 2)
		PreviewRubber(938, 639, 2)
		PreviewRubber(999, 1117, 1)
		PreviewRubber(847, 1079, 0)
		PreviewRubber(831, 702, 0)
		PreviewRubber(667, 702, 0)
		PreviewRubber(687, 1084, 0)
		PreviewRubber(1115, 1230, 1)
		PreviewRubber(566, 764, 2)
		PreviewRubber(525, 1083, 0)
		PreviewRubber(422, 1024, 2)
		PreviewRubber(464, 703, 0)
		PreviewRubber(302, 704, 0)
		PreviewRubber(297, 795, 2)
		PreviewRubber(316, 1089, 0)
		PreviewRubber(1559, 1436, 2)
		PreviewRubber(1560, 1598, 2)
		PreviewRubber(1560, 1759, 2)
		PreviewRubber(1561, 1920, 2)
		PreviewRubber(1620, 2022, 0)
		PreviewRubber(3388, 1688, 3)
		PreviewRubber(3276, 1546, 3)

		PreviewPlacedGear(1757, 706)
		PreviewPlacedGear(1838, 706)
		PreviewPlacedGear(1319, 926)
		PreviewPlacedGear(1389, 926)
		PreviewPlacedGear(3184, 839)
		PreviewPlacedGear(3185, 808)
		PreviewPlacedGear(3677, 412)
		PreviewPlacedGear(3079, 1007)
		PreviewPlacedGear(3138, 1007)
		PreviewPlacedGear(420, 929)
		PreviewPlacedGear(3195, 1621)
		PreviewPlacedGear(3155, 1655)
		PreviewPlacedGear(3112, 1691)
		PreviewPlacedGear(3078, 1730)
		PreviewPlacedGear(3044, 1764)
		PreviewPlacedGear(3011, 1805)
		PreviewPlacedGear(2998, 1843)
		PreviewPlacedGear(2986, 1886)
		PreviewPlacedGear(2978, 1937)
		PreviewPlacedGear(733, 1753)
		PreviewPlacedGear(3345, 1773)
		PreviewPlacedGear(3332, 1806)
		PreviewPlacedGear(3317, 1840)
		PreviewPlacedGear(3302, 1873)
		PreviewPlacedGear(3262, 1902)
		PreviewPlacedGear(3237, 1937)
		PreviewPlacedGear(3225, 1978)
		PreviewPlacedGear(1272, 1839)
		PreviewPlacedGear(863, 1776)
		PreviewPlacedGear(712, 1902)
		PreviewPlacedGear(2361, 1922)
		PreviewPlacedGear(2360, 1877)
		PreviewPlacedGear(2362, 1825)
		PreviewPlacedGear(2364, 1772)
		PreviewPlacedGear(2364, 1723)
		PreviewPlacedGear(2362, 1670)
		PreviewPlacedGear(2395, 1645)
		PreviewPlacedGear(2426, 1600)
		PreviewPlacedGear(2434, 1543)
		PreviewPlacedGear(2435, 1480)
		PreviewPlacedGear(2406, 1431)
		PreviewPlacedGear(2362, 1392)
		PreviewPlacedGear(2313, 1368)
		PreviewPlacedGear(2249, 1359)
		PreviewPlacedGear(2202, 1386)
		PreviewPlacedGear(2151, 1434)
		PreviewPlacedGear(1039, 1861)
		PreviewPlacedGear(2154, 1946)
		PreviewPlacedGear(2156, 1902)
		PreviewPlacedGear(2155, 1840)
		PreviewPlacedGear(2152, 1777)
		PreviewPlacedGear(2161, 1724)
		PreviewPlacedGear(2128, 1681)
		PreviewPlacedGear(2094, 1442)
		PreviewPlacedGear(2036, 1448)
		PreviewPlacedGear(1976, 1450)
		PreviewPlacedGear(1924, 1454)
		PreviewPlacedGear(2082, 1685)
		PreviewPlacedGear(2046, 1692)
		PreviewPlacedGear(1999, 1696)
		PreviewPlacedGear(1961, 1701)
		PreviewPlacedGear(1939, 1737)
		PreviewPlacedGear(1925, 1783)
		PreviewPlacedGear(1916, 1821)
		PreviewPlacedGear(1904, 1864)
		PreviewPlacedGear(1888, 1913)
		PreviewPlacedGear(1870, 1961)
		PreviewPlacedGear(1100, 1660)
		PreviewPlacedGear(1876, 1486)
		PreviewPlacedGear(1826, 1533)
		PreviewPlacedGear(1799, 1580)
		PreviewPlacedGear(1784, 1637)
		PreviewPlacedGear(1765, 1681)
		PreviewPlacedGear(1755, 1718)
		PreviewPlacedGear(1726, 1779)
		PreviewPlacedGear(1718, 1836)
		PreviewPlacedGear(1705, 1885)
		PreviewPlacedGear(1696, 1934)
		PreviewPlacedGear(1685, 1975)
		PreviewPlacedGear(859, 1569)

	else

		PreviewWayPoint(383, 1595)
		PreviewWayPoint(605, 1157)
		PreviewWayPoint(2296, 517)
		PreviewWayPoint(2841, 497)
		PreviewWayPoint(3209, 1286)
		PreviewWayPoint(3708, 1945)
		PreviewWayPoint(4075, 1887)
		PreviewGirder(430, 1871, 2)
		PreviewGirder(1249, 1914, 4)
		PreviewGirder(1394, 1849, 7)
		PreviewGirder(1522, 1848, 5)
		PreviewGirder(1578, 1959, 2)
		PreviewGirder(1545, 2011, 0)
		PreviewGirder(430, 1749, 6)
		PreviewGirder(430, 1589, 6)
		PreviewGirder(358, 1499, 4)
		PreviewGirder(198, 1499, 4)
		PreviewGirder(72, 1571, 7)
		PreviewGirder(339, 1618, 4)
		PreviewGirder(520, 1499, 4)
		PreviewGirder(680, 1499, 4)
		PreviewGirder(839, 1499, 4)
		PreviewGirder(1000, 1499, 4)
		PreviewGirder(1404, 1730, 5)
		PreviewGirder(1288, 1613, 5)
		PreviewGirder(1200, 1529, 1)
		PreviewGirder(1125, 1495, 0)
		PreviewGirder(1667, 2011, 4)
		PreviewGirder(1812, 1951, 7)
		PreviewGirder(1964, 2024, 0)
		PreviewGirder(1957, 1892, 4)
		PreviewGirder(2103, 1949, 5)
		PreviewGirder(2242, 2017, 4)
		PreviewGirder(2404, 2017, 4)
		PreviewGirder(2548, 1955, 7)
		PreviewGirder(2635, 1871, 3)
		PreviewGirder(2749, 1836, 4)
		PreviewGirder(2751, 1999, 2)
		PreviewGirder(2749, 1947, 0)
		PreviewGirder(2865, 1870, 1)
		PreviewGirder(2954, 1954, 5)
		PreviewGirder(3061, 2017, 0)
		PreviewGirder(3137, 1984, 3)
		PreviewGirder(3169, 1864, 6)
		PreviewGirder(3169, 1702, 6)
		PreviewGirder(3170, 1540, 6)
		PreviewGirder(3170, 1418, 2)
		PreviewGirder(3138, 1339, 1)
		PreviewGirder(3107, 1260, 2)
		PreviewGirder(3153, 1194, 3)
		PreviewGirder(3230, 1163, 0)
		PreviewGirder(3305, 1201, 1)
		PreviewGirder(3334, 1277, 2)
		PreviewGirder(3227, 1540, 6)
		PreviewGirder(3228, 1419, 2)
		PreviewGirder(3334, 1358, 2)
		PreviewGirder(3280, 1387, 0)
		PreviewGirder(3227, 1702, 6)
		PreviewGirder(3227, 1864, 6)
		PreviewGirder(3253, 1981, 1)
		PreviewGirder(3366, 2017, 4)
		PreviewGirder(3528, 2018, 4)
		PreviewGirder(3689, 2018, 4)
		PreviewGirder(246, 1262, 4)
		PreviewGirder(407, 1262, 4)
		PreviewGirder(568, 1262, 4)
		PreviewGirder(731, 1262, 4)
		PreviewGirder(894, 1261, 4)
		PreviewGirder(1056, 1261, 4)
		PreviewGirder(1179, 1262, 0)
		PreviewGirder(1288, 1314, 5)
		PreviewGirder(1406, 1433, 5)
		PreviewGirder(1525, 1549, 5)
		PreviewGirder(1642, 1666, 5)
		PreviewGirder(1749, 1728, 0)
		PreviewGirder(1956, 1802, 6)
		PreviewGirder(1956, 1640, 6)
		PreviewGirder(1782, 1638, 6)
		PreviewGirder(1835, 1487, 7)
		PreviewGirder(1942, 1430, 0)
		PreviewGirder(2051, 1486, 5)
		PreviewGirder(2109, 1639, 6)
		PreviewGirder(2177, 1778, 5)
		PreviewGirder(2323, 1840, 4)
		PreviewGirder(49, 1029, 0)
		PreviewGirder(499, 1172, 6)
		PreviewGirder(527, 1054, 3)
		PreviewGirder(604, 1026, 0)
		PreviewGirder(680, 1056, 1)
		PreviewGirder(719, 1168, 6)
		PreviewGirder(89, 728, 4)
		PreviewGirder(251, 728, 4)
		PreviewGirder(412, 728, 4)
		PreviewGirder(572, 728, 4)
		PreviewGirder(733, 728, 4)
		PreviewGirder(894, 728, 4)
		PreviewGirder(1016, 728, 0)
		PreviewGirder(1067, 799, 6)
		PreviewGirder(1139, 891, 4)
		PreviewGirder(1067, 1171, 6)
		PreviewGirder(1067, 1049, 2)
		PreviewGirder(1136, 999, 4)
		PreviewGirder(1005, 854, 2)
		PreviewGirder(972, 803, 0)
		PreviewGirder(920, 780, 2)
		PreviewGirder(891, 1206, 2)
		PreviewGirder(887, 1150, 0)
		PreviewGirder(3018, 1311, 4)
		PreviewGirder(2871, 1369, 7)
		PreviewGirder(2809, 1523, 6)
		PreviewGirder(2809, 1647, 2)
		PreviewGirder(2469, 1777, 7)
		PreviewGirder(2612, 1715, 4)
		PreviewGirder(2809, 1702, 0)
		PreviewGirder(2727, 1694, 0)
		PreviewGirder(3334, 1481, 6)
		PreviewGirder(3334, 1643, 6)
		PreviewGirder(3334, 1804, 6)
		PreviewGirder(3403, 1940, 5)
		PreviewGirder(1120, 944, 2)
		PreviewGirder(1163, 945, 2)
		PreviewGirder(1141, 781, 5)
		PreviewGirder(81, 629, 1)
		PreviewGirder(102, 498, 3)
		PreviewGirder(81, 373, 1)
		PreviewGirder(179, 453, 6)
		PreviewGirder(100, 260, 3)
		PreviewGirder(179, 330, 2)
		PreviewGirder(249, 544, 4)
		PreviewGirder(410, 545, 4)
		PreviewGirder(571, 543, 4)
		PreviewGirder(731, 543, 4)
		PreviewGirder(891, 544, 4)
		PreviewGirder(1014, 544, 0)
		PreviewGirder(1779, 1321, 6)
		PreviewGirder(1779, 1159, 6)
		PreviewGirder(1779, 997, 6)
		PreviewGirder(1779, 836, 6)
		PreviewGirder(1722, 684, 5)
		PreviewGirder(1137, 545, 4)
		PreviewGirder(1298, 545, 4)
		PreviewGirder(1460, 546, 4)
		PreviewGirder(1608, 600, 5)
		PreviewGirder(1508, 1005, 4)
		PreviewGirder(160, 246, 1)
		PreviewGirder(1821, 1356, 3)
		PreviewGirder(1938, 1323, 4)
		PreviewGirder(2086, 1381, 5)
		PreviewGirder(4004, 2018, 4)
		PreviewGirder(3934, 1926, 6)
		PreviewGirder(3965, 1835, 0)
		PreviewGirder(4015, 1763, 6)
		PreviewGirder(4015, 1603, 6)
		PreviewGirder(4015, 1442, 6)
		PreviewGirder(4015, 1280, 6)
		PreviewGirder(4014, 1118, 6)
		PreviewGirder(4014, 956, 6)
		PreviewGirder(4014, 793, 6)
		PreviewGirder(4014, 632, 6)
		PreviewGirder(4014, 469, 6)
		PreviewGirder(3981, 351, 1)
		PreviewGirder(3985, 204, 3)
		PreviewGirder(4045, 156, 0)
		PreviewGirder(3667, 344, 0)
		PreviewGirder(4016, 1925, 6)
		PreviewGirder(3998, 1926, 6)
		PreviewGirder(3980, 1925, 6)
		PreviewGirder(3957, 1926, 6)
		PreviewGirder(3843, 1832, 4)
		PreviewGirder(3682, 1832, 4)
		PreviewGirder(3561, 1833, 0)
		PreviewGirder(3484, 1796, 1)
		PreviewGirder(3455, 1675, 6)
		PreviewGirder(3455, 1513, 6)
		PreviewGirder(3455, 1351, 6)
		PreviewGirder(1601, 476, 7)
		PreviewGirder(1706, 421, 0)
		PreviewGirder(1888, 366, 6)
		PreviewGirder(3997, 1743, 6)
		PreviewGirder(3979, 1742, 6)
		PreviewGirder(3962, 1741, 6)
		PreviewGirder(3943, 1741, 6)
		PreviewGirder(2199, 393, 7)
		PreviewGirder(2304, 337, 0)
		PreviewGirder(2409, 392, 5)
		PreviewGirder(2470, 502, 2)
		PreviewGirder(2412, 606, 7)
		PreviewGirder(2308, 673, 0)
		PreviewGirder(2202, 612, 5)
		PreviewGirder(2138, 507, 2)
		PreviewGirder(2739, 378, 7)
		PreviewGirder(2847, 322, 0)
		PreviewGirder(2953, 378, 5)
		PreviewGirder(2680, 489, 2)
		PreviewGirder(3012, 489, 2)
		PreviewGirder(2736, 594, 5)
		PreviewGirder(2841, 657, 0)
		PreviewGirder(2949, 594, 7)
		PreviewGirder(2448, 837, 7)
		PreviewGirder(2594, 779, 4)
		PreviewGirder(2739, 836, 5)
		PreviewGirder(2390, 950, 2)
		PreviewGirder(2789, 950, 2)
		PreviewGirder(2593, 904, 4)
		PreviewGirder(2727, 1056, 7)
		PreviewGirder(2452, 1058, 5)
		PreviewGirder(2510, 1215, 6)
		PreviewGirder(2663, 1208, 6)
		PreviewGirder(2510, 1378, 6)
		PreviewGirder(2664, 1369, 6)
		PreviewGirder(300, 275, 0)
		PreviewGirder(439, 274, 0)
		PreviewGirder(628, 273, 4)
		PreviewGirder(811, 271, 0)
		PreviewGirder(737, 373, 4)
		PreviewGirder(934, 440, 0)
		PreviewGirder(1075, 439, 0)
		PreviewGirder(1209, 438, 0)
		PreviewGirder(1383, 439, 4)
		PreviewGirder(3547, 344, 4)
		PreviewGirder(3584, 254, 6)
		PreviewGirder(3508, 132, 5)
		PreviewGirder(3335, 1117, 6)
		PreviewGirder(3335, 956, 6)
		PreviewGirder(3335, 795, 6)
		PreviewGirder(3335, 634, 6)
		PreviewGirder(3335, 513, 2)
		PreviewGirder(3401, 404, 7)
		PreviewGirder(3455, 1190, 6)
		PreviewGirder(3455, 1029, 6)
		PreviewGirder(3455, 868, 6)
		PreviewGirder(3455, 705, 6)
		PreviewGirder(3455, 582, 2)
		PreviewGirder(3485, 503, 3)
		PreviewGirder(3601, 475, 4)
		PreviewGirder(3719, 444, 3)
		PreviewGirder(3094, 828, 5)
		PreviewGirder(2064, 947, 7)
		PreviewGirder(1826, 512, 7)
		PreviewGirder(3420, 49, 1)
		PreviewGirder(410, 682, 3)
		PreviewGirder(528, 653, 4)
		PreviewGirder(688, 653, 4)
		PreviewGirder(805, 684, 1)
		PreviewGirder(528, 672, 4)
		PreviewGirder(688, 672, 4)
		PreviewGirder(500, 696, 4)
		PreviewGirder(701, 696, 4)

		PreviewPlacedGear(889, 1126)
		PreviewPlacedGear(1211, 975)
		PreviewPlacedGear(3619, 451)
		PreviewPlacedGear(304, 1594)
		PreviewPlacedGear(1538, 1987)
		PreviewPlacedGear(1958, 2000)
		PreviewPlacedGear(2744, 1923)
		PreviewPlacedGear(3283, 1363)
		PreviewPlacedGear(2749, 1812)
		PreviewPlacedGear(970, 779)
		PreviewPlacedGear(3284, 1332)
		PreviewPlacedGear(1082, 975)
		PreviewPlacedGear(1547, 981)
		PreviewPlacedGear(1707, 397)
		PreviewPlacedGear(2309, 649)
		PreviewPlacedGear(1116, 867)
		PreviewPlacedGear(2559, 880)
		PreviewPlacedGear(2630, 880)
		PreviewPlacedGear(1951, 1406)
		PreviewPlacedGear(3536, 320)
		PreviewPlacedGear(3582, 1994)
		PreviewPlacedGear(682, 349)
		PreviewPlacedGear(2842, 633)
		PreviewPlacedGear(506, 1034)
		PreviewPlacedGear(556, 1002)
		PreviewPlacedGear(615, 1002)
		PreviewPlacedGear(676, 1010)
		PreviewPlacedGear(716, 1050)
		PreviewPlacedGear(67, 1005)


	end

    FlushPoints()
end

function LoadMap(mID)

	local tempG
	techX = {}
	techY = {}
	techCount = 1

	if mID == 1 then

		--AddCaption("don't load any map, ermagherd, why are you even?")
		-- use this when you want to load a hand-drawn map with special points, I guess?

	--[[elseif mID == "1" then

		--simple testmap, the first of its kind
		--currently broken due to being old
		------ GIRDER LIST ------
		LoadSprite(306, 530, sprAmGirder, 7)
		LoadSprite(451, 474, sprAmGirder, 4)
		LoadSprite(595, 531, sprAmGirder, 5)
		LoadSprite(245, 679, sprAmGirder, 6)
		LoadSprite(305, 822, sprAmGirder, 5)
		LoadSprite(449, 887, sprAmGirder, 4)
		LoadSprite(593, 825, sprAmGirder, 7)
		LoadSprite(657, 681, sprAmGirder, 6)
		LoadSprite(1063, 682, sprAmGirder, 6)
		LoadSprite(1121, 532, sprAmGirder, 7)
		LoadSprite(1266, 476, sprAmGirder, 4)
		LoadSprite(1411, 535, sprAmGirder, 5)
		LoadSprite(1472, 684, sprAmGirder, 6)
		LoadSprite(1415, 828, sprAmGirder, 7)
		LoadSprite(1271, 892, sprAmGirder, 4)
		LoadSprite(1126, 827, sprAmGirder, 5)
		LoadSprite(841, 1079, sprAmGirder, 4)
		LoadSprite(709, 1153, sprAmGirder, 7)
		LoadSprite(975, 1154, sprAmGirder, 5)
		LoadSprite(653, 1265, sprAmGirder, 2)
		LoadSprite(1021, 1266, sprAmGirder, 2)
		LoadSprite(713, 1369, sprAmGirder, 5)
		LoadSprite(960, 1371, sprAmGirder, 7)
		LoadSprite(835, 1454, sprAmGirder, 4)
		LoadSprite(185, 1617, sprAmGirder, 2)
		LoadSprite(1317, 1399, sprAmGirder, 2)
		LoadSprite(1711, 1811, sprAmGirder, 2)
		LoadSprite(2087, 1424, sprAmGirder, 2)
		LoadSprite(2373, 1804, sprAmGirder, 2)
		LoadSprite(2646, 1434, sprAmGirder, 2)
		LoadSprite(1876, 667, sprAmGirder, 6)
		LoadSprite(1934, 517, sprAmGirder, 7)
		LoadSprite(2079, 461, sprAmGirder, 4)
		LoadSprite(2224, 519, sprAmGirder, 5)
		LoadSprite(1935, 810, sprAmGirder, 5)
		LoadSprite(2080, 875, sprAmGirder, 4)
		LoadSprite(2224, 811, sprAmGirder, 7)
		LoadSprite(2370, 582, sprAmGirder, 4)
		LoadSprite(2370, 759, sprAmGirder, 4)
		LoadSprite(2530, 582, sprAmGirder, 4)
		LoadSprite(2690, 582, sprAmGirder, 4)
		LoadSprite(2530, 759, sprAmGirder, 4)
		LoadSprite(2690, 759, sprAmGirder, 4)
		LoadSprite(2836, 634, sprAmGirder, 5)
		LoadSprite(2835, 822, sprAmGirder, 5)
		LoadSprite(2951, 751, sprAmGirder, 5)
		LoadSprite(2950, 939, sprAmGirder, 5)
		LoadSprite(2964, 1054, sprAmGirder, 7)
		LoadSprite(2978, 1172, sprAmGirder, 5)
		LoadSprite(3095, 1185, sprAmGirder, 7)
		LoadSprite(3211, 1069, sprAmGirder, 7)
		LoadSprite(3038, 843, sprAmGirder, 1)
		LoadSprite(3126, 825, sprAmGirder, 7)
		LoadSprite(3271, 768, sprAmGirder, 4)
		LoadSprite(3357, 1014, sprAmGirder, 4)
		LoadSprite(3416, 826, sprAmGirder, 5)
		LoadSprite(3454, 969, sprAmGirder, 6)
		LoadSprite(3439, 369, sprAmGirder, 6)
		LoadSprite(3500, 220, sprAmGirder, 7)
		LoadSprite(3502, 513, sprAmGirder, 5)
		LoadSprite(3646, 162, sprAmGirder, 4)
		LoadSprite(3791, 224, sprAmGirder, 5)
		LoadSprite(3851, 374, sprAmGirder, 6)
		LoadSprite(3792, 518, sprAmGirder, 7)
		LoadSprite(3994, 1731, sprAmGirder, 7)
		LoadSprite(3877, 1848, sprAmGirder, 7)
		LoadSprite(3789, 1942, sprAmGirder, 3)
		LoadSprite(3986, 1929, sprAmGirder, 2)
		LoadSprite(2837, 1937, sprAmGirder, 4)
		LoadSprite(2997, 1938, sprAmGirder, 4)
		LoadSprite(3157, 1938, sprAmGirder, 4)
		LoadSprite(1152, 1844, sprAmGirder, 4)
		LoadSprite(1299, 1898, sprAmGirder, 5)
		LoadSprite(1005, 1900, sprAmGirder, 7)
		LoadSprite(3578, 575, sprAmGirder, 6)
		LoadSprite(3714, 576, sprAmGirder, 6)
		LoadSprite(3579, 740, sprAmGirder, 6)
		LoadSprite(3714, 741, sprAmGirder, 6)
		LoadSprite(3580, 903, sprAmGirder, 6)
		LoadSprite(3715, 904, sprAmGirder, 6)
		LoadSprite(3552, 452, sprAmGirder, 1)
		LoadSprite(3528, 370, sprAmGirder, 2)
		LoadSprite(3568, 297, sprAmGirder, 3)
		LoadSprite(3736, 455, sprAmGirder, 3)
		LoadSprite(3757, 378, sprAmGirder, 2)
		LoadSprite(3725, 299, sprAmGirder, 1)
		LoadSprite(3646, 261, sprAmGirder, 0)
		LoadSprite(3648, 997, sprAmGirder, 4)
		LoadSprite(3649, 1275, sprAmGirder, 2)
		LoadSprite(3514, 1750, sprAmGirder, 0)

		------ AMMO CRATE LIST ------
		tempG = SpawnSupplyCrate(1707, 1755, amBazooka)
		tempG = SpawnSupplyCrate(3983, 1873, amBazooka)
		tempG = SpawnSupplyCrate(184, 1561, amBazooka)
		tempG = SpawnSupplyCrate(2644, 1378, amBazooka)
		tempG = SpawnSupplyCrate(2914, 865, amBazooka)

		------ MINE LIST ------
		SetTimer(AddGear(2340, 580, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2399, 580, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2448, 580, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2517, 579, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2575, 581, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2647, 582, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2720, 582, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2760, 581, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2331, 757, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2409, 758, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2477, 758, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2545, 759, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2613, 760, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2679, 758, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2744, 757, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2813, 610, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2855, 650, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2887, 686, gtMine, 0, 0, 0, 0), 1)
]]
	elseif mID == 2 then

		-- more detailed landflag test map, should hopefully work now
		-- probably my second favorite techracer map

		------ GIRDER LIST ------
		LoadSprite(402, 1863, sprAmGirder, 0, U_LAND_TINT_ICE, nil, nil, nil, lfIce)
		LoadSprite(442, 1863, sprAmGirder, 4, U_LAND_TINT_ICE, nil, nil, nil, lfIce)
		LoadSprite(2067, 1945, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(1943, 1653, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(1999, 1504, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2143, 1445, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2432, 1565, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2593, 1565, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2752, 1565, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2206, 1949, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2262, 1800, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2407, 1745, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2569, 1745, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2005, 1797, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2288, 1503, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2715, 1802, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2898, 1624, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3014, 1740, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2830, 1919, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3131, 1856, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3191, 1968, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3264, 2021, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2840, 2006, sprAmGirder, 3, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(396, 665, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(619, 665, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(696, 635, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(319, 637, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(268, 604, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(746, 603, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(325, 495, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(689, 493, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(504, 422, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(595, 422, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(412, 422, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(320, 696, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(249, 786, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(249, 948, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(191, 785, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(191, 946, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(191, 1107, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(249, 1109, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(130, 1251, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(306, 1251, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(72, 1360, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(364, 1360, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(132, 1462, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(304, 1463, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(182, 1616, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(255, 1613, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(217, 1796, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(221, 1381, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(154, 669, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(124, 553, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(326, 467, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(223, 592, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(638, 791, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(752, 907, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(866, 1022, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1505, 395, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1445, 544, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1506, 686, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1650, 339, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1797, 397, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1857, 547, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1797, 688, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1652, 754, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3326, 863, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3474, 921, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3180, 921, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3120, 1071, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3183, 1214, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3536, 1071, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3480, 1214, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3330, 1279, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1481, 1133, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1626, 1078, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1772, 1135, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1422, 1280, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1831, 1286, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1773, 1429, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1627, 1492, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1482, 1427, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(587, 855, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(425, 855, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(302, 822, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2502, 556, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2601, 634, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2616, 441, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2716, 519, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3469, 556, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3696, 763, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2756, 379, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2862, 466, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(2918, 379, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3023, 467, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3080, 378, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3616, 503, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3552, 828, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3172, 527, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3232, 428, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3289, 647, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3350, 545, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3406, 764, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3708, 575, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
		LoadSprite(3705, 680, sprAmGirder, 1, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)

		------ RUBBER BAND LIST ------
		LoadSprite(505, 708, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(175, 451, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(822, 1693, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(982, 1691, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1142, 1688, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1302, 1684, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1450, 1750, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1566, 1860, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1680, 1973, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)

		------ WAYPOINT LIST ------
		AddWayPoint(387, 621)
		AddWayPoint(215, 1748)
		AddWayPoint(1617, 1313)
		AddWayPoint(1642, 562)
		AddWayPoint(3318, 1102)
		AddWayPoint(3554, 684)
		AddWayPoint(2142, 1674)

		------ AMMO CRATE LIST ------
		tempG = SpawnSupplyCrate(324, 613, amFirePunch)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amFirePunch")
		tempG = SpawnSupplyCrate(2361, 1721, amBazooka)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amBazooka")
		tempG = SpawnSupplyCrate(2430, 1721, amBazooka)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amBazooka")
		tempG = SpawnSupplyCrate(2510, 1721, amBazooka)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amBazooka")
		tempG = SpawnSupplyCrate(2581, 1721, amBazooka)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amBazooka")
		tempG = SpawnSupplyCrate(405, 1839, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amSineGun")
		tempG = SpawnSupplyCrate(481, 1839, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents", "amSineGun")

		------ UTILITY CRATE LIST ------
		tempG = SpawnSupplyCrate(696, 611, amParachute)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amParachute")
		tempG = SpawnSupplyCrate(825, 1664, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(919, 1657, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(1015, 1662, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(1095, 1654, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(1166, 1659, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(1250, 1650, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(1335, 1655, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")

		------ MINE LIST ------
		SetTimer(AddGear(221, 1373, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(609, 661, gtMine, 0, 0, 0, 0), 3000)

		------ STICKY MINE LIST ------
		tempG = AddGear(190, 756, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(191, 810, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(189, 868, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(190, 923, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(192, 984, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(192, 1045, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(189, 1097, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(192, 1159, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(248, 753, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(248, 808, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(249, 868, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(250, 921, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(246, 982, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(247, 1041, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(249, 1094, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(249, 1156, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2571, 665, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2614, 623, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2658, 580, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2704, 533, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2751, 484, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2830, 466, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2912, 465, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2992, 465, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3072, 468, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2465, 592, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2518, 540, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2580, 477, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2635, 425, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2713, 381, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2796, 378, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2892, 379, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(2988, 379, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3061, 377, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3136, 377, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(627, 770, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(661, 804, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(705, 850, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(754, 899, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(805, 950, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(850, 996, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(902, 1048, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(888, 1034, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(788, 933, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(839, 985, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(736, 881, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(686, 829, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(649, 792, gtSMine, 0, 0, 0, 0)

	elseif mID == 3 then

		--Helix airmine map
		ufoFuel = 2000
		------ GIRDER LIST ------
		LoadSprite(3703, 157, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3846, 100, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3991, 162, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4049, 311, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3648, 308, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3988, 454, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3843, 515, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3616, 429, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3725, 548, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1155, 95, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1067, 167, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(906, 167, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(747, 167, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(586, 167, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(426, 167, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(266, 166, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(105, 166, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

		------ WAYPOINT LIST ------
		AddWayPoint(3892, 478)
		AddWayPoint(1146, 413)
		AddWayPoint(934, 1459)
		AddWayPoint(2635, 1459)
		AddWayPoint(2656, 523)
		AddWayPoint(1958, 834)
		AddWayPoint(555, 864)

		------ UTILITY CRATE LIST ------
		tempG = SpawnSupplyCrate(3801, 491, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(3803, 460, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(3799, 429, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(3846, 491, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(3845, 460, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")
		tempG = SpawnSupplyCrate(3845, 429, amJetpack)
		setGearValue(tempG,"caseType", "util")
		setGearValue(tempG,"contents", "amJetpack")

		------ AIR MINE LIST ------
		SetTimer(AddGear(3684, 595, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3648, 641, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3613, 695, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3575, 733, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3537, 781, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3505, 829, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3476, 881, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3447, 930, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3418, 979, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3388, 1021, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3356, 1072, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3561, 469, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3528, 500, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3496, 545, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3467, 584, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3444, 619, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3404, 656, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3373, 693, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3351, 726, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3329, 756, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3306, 798, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3339, 1115, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3321, 1163, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3298, 1206, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3281, 1250, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3259, 1302, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3238, 1343, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3220, 1397, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3269, 810, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3225, 788, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3188, 762, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3149, 735, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3106, 709, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3064, 682, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3023, 652, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2983, 619, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3135, 980, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3143, 1029, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3130, 1077, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3122, 1127, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3100, 1174, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3069, 1226, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3042, 1287, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3178, 1440, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3125, 1480, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3088, 1521, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2988, 1326, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2944, 1357, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2884, 1356, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2813, 1356, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2755, 1356, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2677, 1347, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2610, 1356, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2532, 1354, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3045, 1553, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2974, 1588, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2901, 1584, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2850, 1569, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2782, 1570, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2708, 1577, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2648, 1579, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2585, 1576, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2525, 1581, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2490, 1338, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2435, 1306, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2386, 1283, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2344, 1242, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3126, 942, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3070, 919, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3005, 897, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2962, 865, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2907, 838, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2858, 803, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2807, 769, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2764, 741, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2714, 703, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2665, 671, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2613, 629, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2557, 591, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2513, 545, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2450, 537, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2390, 569, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2341, 603, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2299, 649, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2255, 684, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2218, 714, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2173, 756, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2125, 801, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2084, 864, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2113, 933, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2154, 974, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2191, 1016, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2223, 1061, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2257, 1113, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2283, 1153, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2316, 1202, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2479, 1553, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2422, 1513, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2363, 1477, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2302, 1446, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2243, 1388, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2188, 1335, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2136, 1273, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2086, 1204, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2033, 1132, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1992, 1085, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1967, 1022, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2943, 560, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2890, 511, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2834, 477, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2774, 451, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2710, 428, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2652, 410, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2578, 375, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2482, 342, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2380, 335, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2302, 359, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2256, 409, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2183, 469, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2111, 513, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2049, 558, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1986, 586, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1742, 412, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1684, 376, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1627, 344, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1566, 325, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1505, 298, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1727, 695, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1917, 1067, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1874, 1122, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1923, 557, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1863, 501, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1796, 447, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1829, 1158, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1778, 1201, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1732, 1244, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1700, 1290, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1652, 1333, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1599, 1380, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1550, 1425, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1493, 1483, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1443, 1519, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1381, 1557, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1304, 1590, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1237, 1613, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1176, 1621, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1104, 1626, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1032, 1630, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(964, 1628, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(886, 1615, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(813, 1584, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(750, 1524, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(697, 1473, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(645, 1410, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(602, 1351, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(557, 1284, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(506, 1230, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(467, 1144, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(449, 1066, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(421, 980, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(425, 876, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(422, 789, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(434, 699, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(439, 625, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(481, 551, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(537, 494, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(586, 444, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(633, 393, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(674, 360, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(745, 332, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1786, 816, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1768, 744, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1765, 875, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1711, 936, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1629, 1016, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1579, 1072, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1520, 1123, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1462, 1185, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1415, 1238, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1361, 1288, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1298, 1318, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1230, 1345, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1161, 1357, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1097, 1367, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1033, 1373, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(971, 1333, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(900, 1291, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(840, 1225, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(795, 1156, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(744, 1076, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(706, 995, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(674, 927, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(687, 859, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(719, 781, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(742, 720, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(801, 297, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(880, 280, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(954, 275, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1020, 268, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1093, 265, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1174, 258, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1270, 257, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1338, 262, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1433, 260, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(779, 657, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(824, 624, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(879, 592, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(928, 564, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(995, 544, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1055, 541, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1121, 540, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1184, 534, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1252, 536, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1317, 542, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1380, 553, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1448, 567, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1521, 582, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1580, 600, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1633, 626, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1683, 651, gtAirMine, 0, 0, 0, 0), 1)

	elseif mID == 4 then

	---nice rope and airmines landflag testmap
	------ GIRDER LIST ------

	LoadSprite(194, 388, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(338, 334, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(484, 390, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(139, 543, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(544, 540, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(201, 687, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(485, 684, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(259, 839, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(426, 837, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(259, 999, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(426, 998, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(259, 1159, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(426, 1158, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(259, 1318, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(426, 1318, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(426, 1478, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(259, 1478, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(515, 1477, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(659, 1537, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(774, 1652, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(836, 1799, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(907, 1890, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1067, 1890, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1212, 1823, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1359, 1764, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1504, 1822, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1647, 1886, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1807, 1886, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1362, 1869, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1968, 1885, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2111, 1823, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2257, 1769, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2403, 1825, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2549, 1887, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2709, 1887, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2868, 1887, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2958, 1854, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2928, 1773, sprAmGirder, 1, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2898, 1692, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2928, 1613, sprAmGirder, 3, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3045, 1584, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3162, 1619, sprAmGirder, 1, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3192, 1697, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3160, 1777, sprAmGirder, 3, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3128, 1857, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3218, 1886, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3379, 1885, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3524, 1818, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3641, 1702, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3756, 1585, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(4021, 1316, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3842, 1503, sprAmGirder, 3, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3899, 1409, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3694, 1974, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3809, 1858, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3925, 1741, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(4022, 1613, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2256, 1877, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3046, 1728, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(501, 1777, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(572, 1868, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3372, 771, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3517, 715, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3663, 774, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3313, 923, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3373, 1066, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3518, 1128, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3662, 1065, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3723, 924, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2474, 1373, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2474, 1252, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2507, 1200, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2626, 1200, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2716, 1270, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2505, 1464, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2625, 1464, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2716, 1391, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1544, 300, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1691, 245, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1838, 304, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1487, 453, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1548, 597, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1692, 657, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1835, 593, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1900, 451, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3527, 93, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3586, 238, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3703, 354, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3820, 471, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3938, 588, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(4044, 651, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3618, 22, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3779, 22, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(3939, 22, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(4047, 22, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(936, 1198, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1080, 1143, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1225, 1202, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1278, 1352, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(881, 1351, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(943, 1496, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1219, 1495, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1160, 1645, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(998, 1649, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1160, 1766, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(998, 1770, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1077, 1824, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1824, 1138, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(834, 606, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(950, 593, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1035, 683, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(748, 696, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(764, 780, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(850, 870, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(937, 850, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1018, 768, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2589, 444, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2704, 329, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2604, 560, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2719, 675, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2832, 689, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2947, 573, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2820, 317, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2936, 433, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2987, 489, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(338, 559, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

	------ WAYPOINT LIST ------
	AddWayPoint(337, 533)
	AddWayPoint(1069, 1367)
	AddWayPoint(884, 729)
	AddWayPoint(1682, 464)
	AddWayPoint(2773, 505)
	AddWayPoint(3512, 929)
	AddWayPoint(4002, 106)
	AddWayPoint(3964, 1520)
	AddWayPoint(2592, 1334)

	------ AMMO CRATE LIST ------
	tempG = SpawnSupplyCrate(548, 1844, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(595, 1844, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(642, 1844, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1314, 1845, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1362, 1845, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1419, 1845, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(2208, 1853, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(2264, 1853, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(2318, 1853, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(3027, 1704, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(3072, 1704, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1822, 1042, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")

	------ UTILITY CRATE LIST ------
	tempG = SpawnSupplyCrate(313, 535, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")
	tempG = SpawnSupplyCrate(365, 535, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")
	tempG = SpawnSupplyCrate(313, 504, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")
	tempG = SpawnSupplyCrate(339, 478, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")
	tempG = SpawnSupplyCrate(365, 504, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")

	------ AIR MINE LIST ------
	SetTimer(AddGear(3517, 995, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3448, 858, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3582, 848, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3758, 158, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3964, 297, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2772, 506, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2602, 1339, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1638, 370, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1743, 522, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(894, 726, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1080, 1690, gtAirMine, 0, 0, 0, 0), 1)

	elseif mID == 5 then
	-- gimmicky bounce map, probably not possible at the moment due
	-- to only having a single land flag and techracer forbidding
	-- indestructible landflag

		------ RUBBER BAND LIST ------
		LoadSprite(3776, 447, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3629, 503, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3486, 446, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3234, 889, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3084, 838, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2943, 909, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2665, 507, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2520, 557, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2377, 496, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2507, 1263, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2355, 1212, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2206, 1269, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1902, 1270, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1749, 1221, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1607, 1288, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1781, 1659, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1927, 1706, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2089, 1702, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(2234, 1649, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3413, 1631, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3558, 1676, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3718, 1673, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(3866, 1616, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(807, 803, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(806, 1131, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(732, 1273, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(583, 1324, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(420, 1324, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(272, 1274, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(222, 1121, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(221, 956, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(221, 792, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(271, 644, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(420, 589, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(584, 588, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(730, 658, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(612, 1846, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(758, 1896, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(903, 1835, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1051, 1781, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1210, 1780, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1356, 1845, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1501, 1891, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1438, 431, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1589, 378, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
		LoadSprite(1736, 448, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)

		------ WAYPOINT LIST ------
		AddWayPoint(3761, 428)
		AddWayPoint(750, 1801)
		AddWayPoint(511, 1232)
		AddWayPoint(1579, 297)
		AddWayPoint(2007, 1618)
		AddWayPoint(3642, 1601)

		------ AMMO CRATE LIST ------
		tempG = SpawnSupplyCrate(397, 1295, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(461, 1295, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(555, 1295, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(621, 1295, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(759, 1867, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1504, 1862, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(2521, 528, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3639, 474, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3078, 809, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1752, 1192, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(2349, 1183, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1582, 349, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3560, 1647, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3711, 1644, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(433, 560, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(568, 559, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1935, 1677, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(2084, 1673, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1018, 1752, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1086, 1752, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1176, 1751, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(1238, 1751, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(2009, 1668, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3641, 1639, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3580, 469, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(3700, 467, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(2458, 523, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")
		tempG = SpawnSupplyCrate(2595, 521, amSineGun)
		setGearValue(tempG,"caseType", "ammo")
		setGearValue(tempG,"contents","amSineGun")


	elseif mID == 6 then
	--incomplete challenge, still working on this map

	------ GIRDER LIST ------
	LoadSprite(419, 298, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 387, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(521, 359, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(459, 385, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 387, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(601, 298, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 547, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 547, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 707, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 707, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(397, 466, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(458, 491, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(521, 592, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(458, 620, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(397, 713, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(459, 740, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 867, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 866, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(641, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(800, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(959, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(482, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(323, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(163, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(48, 1038, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(813, 1126, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1127, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1288, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1449, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1287, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1448, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(900, 1214, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(989, 1570, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1569, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1690, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(521, 844, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(457, 870, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(392, 941, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(813, 1851, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1972, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1690, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1044, 1817, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(901, 1979, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1002, 2005, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1176, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1333, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1491, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1649, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1808, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1898, 1800, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1942, 1798, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2010, 1798, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2054, 1804, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2054, 1925, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1898, 1639, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2054, 1643, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2125, 1553, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2197, 1464, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2126, 1374, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1965, 1374, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1804, 1374, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1733, 1464, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1823, 1547, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2023, 1976, sprAmGirder, 0, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1961, 2003, sprAmGirder, 3, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2216, 1464, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2234, 1464, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2252, 1464, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2270, 1464, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2245, 1553, sprAmGirder, 0, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2246, 1374, sprAmGirder, 0, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2351, 1310, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2350, 1490, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)

	------ RUBBER BAND LIST ------
	LoadSprite(210, 958, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(98, 844, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)

	------ LAND SPRITE LIST ------

	------ WAYPOINT LIST ------
	AddWayPoint(438, 278)
	AddWayPoint(1870, 1354)
	AddWayPoint(892, 1100)

	------ HEALTH CRATE LIST ------

	------ AMMO CRATE LIST ------
	tempG = SpawnSupplyCrate(1943, 1978, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(2002, 1952, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")
	tempG = SpawnSupplyCrate(2002, 1890, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")
	tempG = SpawnSupplyCrate(2002, 1921, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")
	tempG = SpawnSupplyCrate(1998, 1859, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")

	------ UTILITY CRATE LIST ------
	tempG = SpawnSupplyCrate(368, 274, amPickHammer)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amPickHammer")
	tempG = SpawnSupplyCrate(526, 568, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")
	tempG = SpawnSupplyCrate(474, 1014, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")
	tempG = SpawnSupplyCrate(906, 1955, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")
	tempG = SpawnSupplyCrate(2127, 1529, amBlowTorch)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amBlowTorch")

	------ BARREL LIST ------
	SetHealth(AddGear(1860, 1523, gtExplosives, 0, 0, 0, 0), 1)
	SetHealth(AddGear(1817, 1523, gtExplosives, 0, 0, 0, 0), 1)
	SetHealth(AddGear(1836, 1493, gtExplosives, 0, 0, 0, 0), 1)
	SetHealth(AddGear(1769, 1523, gtExplosives, 0, 0, 0, 0), 1)
	SetHealth(AddGear(1792, 1494, gtExplosives, 0, 0, 0, 0), 1)

	------ MINE LIST ------
	SetTimer(AddGear(318, 1028, gtMine, 0, 0, 0, 0), 1)

	------ STICKY MINE LIST ------
	tempG = AddGear(1767, 1506, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(1792, 1477, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(1813, 1506, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(1837, 1476, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(1858, 1506, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(1882, 1537, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(1748, 1537, gtSMine, 0, 0, 0, 0)

	------ AIR MINE LIST ------
	SetTimer(AddGear(837, 1570, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(835, 1361, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(836, 1425, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(833, 1495, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(967, 1566, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(970, 1354, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(967, 1422, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(968, 1493, gtAirMine, 0, 0, 0, 0), 1)

	--[[------ GIRDER LIST ------
	LoadSprite(419, 298, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 387, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(521, 359, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(459, 385, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 387, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(601, 298, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 547, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 547, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 707, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 707, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(397, 466, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(458, 491, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(521, 592, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(458, 620, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(397, 713, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(459, 740, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(348, 867, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(570, 866, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(641, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(800, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(959, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(482, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(323, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(163, 1038, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(48, 1038, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(813, 1126, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1127, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1288, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1449, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1287, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1448, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(900, 1214, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(989, 1570, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1569, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1690, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(521, 844, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(457, 870, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(392, 941, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(813, 1851, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(813, 1972, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(989, 1690, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1044, 1817, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(901, 1979, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1002, 2005, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1176, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1333, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1491, 1873, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1625, 1815, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1680, 1688, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1669, 1980, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1762, 1929, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1811, 1853, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1811, 1692, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1708, 1735, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1776, 1734, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1680, 1527, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1811, 1532, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1608, 1437, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1883, 1443, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1955, 1354, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1883, 1264, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1723, 1264, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1562, 1264, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1519, 1354, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

	------ RUBBER BAND LIST ------
	LoadSprite(210, 958, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(98, 844, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)

	------ WAYPOINT LIST ------
	AddWayPoint(438, 278)
	AddWayPoint(1870, 1354)
	AddWayPoint(892, 1119)

	------ AMMO CRATE LIST ------
	tempG = SpawnSupplyCrate(1740, 1905, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1780, 1905, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")
	tempG = SpawnSupplyCrate(1782, 1874, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")
	tempG = SpawnSupplyCrate(1782, 1843, amSineGun)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amSineGun")

	------ UTILITY CRATE LIST ------
	tempG = SpawnSupplyCrate(368, 274, amPickHammer)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amPickHammer")
	tempG = SpawnSupplyCrate(526, 568, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")
	tempG = SpawnSupplyCrate(474, 1014, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")
	tempG = SpawnSupplyCrate(906, 1955, amRope)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amRope")

	------ STICKY MINE LIST ------
	tempG = AddGear(341, 893, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(341, 845, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(340, 794, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(340, 747, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(340, 694, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(340, 642, gtSMine, 0, 0, 0, 0)

	------ AIR MINE LIST ------
	SetTimer(AddGear(837, 1570, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(835, 1361, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(836, 1425, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(833, 1495, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(967, 1566, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(970, 1354, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(967, 1422, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(968, 1493, gtAirMine, 0, 0, 0, 0), 1)]]

	elseif mID == 7 then
	--Bouncy UFO MAP
	-- should be played with infinite fuel

	ufoFuel = 2000
	------ GIRDER LIST ------
	LoadSprite(3699, 436, sprAmGirder, 0, U_LAND_TINT_ICE, nil, nil, nil, lfIce)
	LoadSprite(934, 806, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(934, 969, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1233, 1342, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1377, 1403, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1497, 1376, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(2816, 1284, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2698, 1401, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2640, 1552, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2640, 1718, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2641, 1881, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(2643, 2007, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(3823, 363, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(233, 596, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(288, 446, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(79, 642, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(80, 479, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(140, 335, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(281, 268, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(343, 334, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(57, 747, sprAmGirder, 3, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(32, 852, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(33, 1015, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(33, 1179, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(34, 1342, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1346, 1939, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1347, 1774, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1294, 1636, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1180, 1522, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1067, 1410, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(931, 1357, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(772, 1358, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(96, 1303, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(236, 1362, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(396, 1363, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(520, 1364, sprAmGirder, 0, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(696, 1450, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(556, 1454, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(489, 1598, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(697, 1574, sprAmGirder, 2, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(639, 1681, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(520, 1798, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(369, 1715, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(243, 1716, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(128, 1735, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(133, 1870, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(251, 1987, sprAmGirder, 5, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(402, 1915, sprAmGirder, 7, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(276, 1938, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(95, 140, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(257, 140, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(419, 140, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(581, 140, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(742, 140, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(903, 140, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1064, 141, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1157, 90, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)

	------ RUBBER BAND LIST ------
	LoadSprite(3433, 237, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3581, 185, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3741, 182, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3879, 257, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3921, 411, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3844, 555, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3692, 615, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3529, 618, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3381, 555, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3282, 289, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3223, 514, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3111, 289, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3058, 516, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2947, 287, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2889, 515, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2785, 288, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2788, 578, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2790, 741, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2862, 884, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2749, 1073, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2865, 1186, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2979, 990, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3123, 1036, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3188, 934, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3010, 1234, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3175, 1230, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3339, 1226, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3345, 949, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3405, 804, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3531, 702, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3444, 1007, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3499, 1221, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3604, 1002, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3755, 1038, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3802, 1186, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3741, 1342, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3626, 1456, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3510, 1314, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3392, 1435, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3506, 1577, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2637, 348, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2583, 496, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2633, 952, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2573, 803, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2474, 556, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2468, 742, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2335, 476, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2214, 358, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2322, 812, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2202, 936, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2060, 305, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1898, 304, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1736, 304, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(2085, 1049, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1966, 1161, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1818, 1209, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1657, 1212, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1947, 685, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1801, 735, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1659, 677, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1491, 902, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1346, 955, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1210, 881, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1576, 305, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1414, 304, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1253, 302, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1108, 374, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(991, 491, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1557, 1273, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(938, 639, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(999, 1117, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(847, 1079, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(831, 702, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(667, 702, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(687, 1084, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1115, 1230, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(566, 764, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(525, 1083, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(422, 1024, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(464, 703, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(302, 704, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(297, 795, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(316, 1089, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1559, 1436, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1560, 1598, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1560, 1759, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1561, 1920, sprAmRubber, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1620, 2022, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3388, 1688, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(3276, 1546, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)

	------ WAYPOINT LIST ------
	AddWayPoint(3820, 342)
	AddWayPoint(3343, 1612)
	AddWayPoint(272, 351)
	AddWayPoint(159, 1774)
	AddWayPoint(2248, 1573)
	AddWayPoint(1379, 1192)

	------ AMMO CRATE LIST ------
	tempG = SpawnSupplyCrate(1757, 706, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1838, 706, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1319, 926, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(1389, 926, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(3184, 839, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(3185, 808, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")

	------ UTILITY CRATE LIST ------
	tempG = SpawnSupplyCrate(3677, 412, amJetpack)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amJetpack")
	tempG = SpawnSupplyCrate(3079, 1007, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")
	tempG = SpawnSupplyCrate(3138, 1007, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")
	tempG = SpawnSupplyCrate(420, 929, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")

	------ BARREL LIST ------

	------ MINE LIST ------
	SetTimer(AddGear(481, 1603, gtMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(485, 1835, gtMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(325, 1759, gtMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(244, 1941, gtMine, 0, 0, 0, 0), 1)

	------ STICKY MINE LIST ------
	tempG = AddGear(226, 270, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(264, 269, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(309, 268, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(340, 268, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(175, 296, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(148, 325, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(121, 356, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(100, 381, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(202, 1352, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(280, 1352, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(359, 1353, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(439, 1353, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(531, 1354, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(744, 1348, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(833, 1348, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(931, 1347, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(990, 1347, gtSMine, 0, 0, 0, 0)

	------ AIR MINE LIST ------
	SetTimer(AddGear(3195, 1621, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3155, 1655, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3112, 1691, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3078, 1730, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3044, 1764, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3011, 1805, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2998, 1843, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2986, 1886, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2978, 1937, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(733, 1753, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3345, 1773, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3332, 1806, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3317, 1840, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3302, 1873, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3262, 1902, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3237, 1937, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(3225, 1978, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1272, 1839, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(863, 1776, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(712, 1902, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2361, 1922, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2360, 1877, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2362, 1825, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2364, 1772, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2364, 1723, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2362, 1670, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2395, 1645, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2426, 1600, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2434, 1543, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2435, 1480, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2406, 1431, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2362, 1392, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2313, 1368, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2249, 1359, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2202, 1386, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2151, 1434, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1039, 1861, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2154, 1946, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2156, 1902, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2155, 1840, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2152, 1777, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2161, 1724, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2128, 1681, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2094, 1442, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2036, 1448, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1976, 1450, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1924, 1454, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2082, 1685, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(2046, 1692, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1999, 1696, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1961, 1701, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1939, 1737, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1925, 1783, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1916, 1821, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1904, 1864, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1888, 1913, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1870, 1961, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1100, 1660, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1876, 1486, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1826, 1533, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1799, 1580, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1784, 1637, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1765, 1681, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1755, 1718, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1726, 1779, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1718, 1836, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1705, 1885, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1696, 1934, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1685, 1975, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(859, 1569, gtAirMine, 0, 0, 0, 0), 1)


--IF NEEDED, YOU CAN PASTE THIS DATA INTO HWMAP CONVERTER
--[[

	3699 436 116
	934 806 106
	934 969 106
	1233 1342 105
	1377 1403 104
	1497 1376 103
	2816 1284 115
	2698 1401 115
	2640 1552 114
	2640 1718 114
	2641 1881 114
	2643 2007 110
	3823 363 100
	233 596 114
	288 446 115
	79 642 114
	80 479 114
	140 335 115
	281 268 112
	343 334 110
	57 747 111
	32 852 114
	33 1015 114
	33 1179 114
	34 1342 114
	1346 1939 114
	1347 1774 114
	1294 1636 113
	1180 1522 113
	1067 1410 113
	931 1357 112
	772 1358 112
	96 1303 113
	236 1362 112
	396 1363 112
	520 1364 108
	696 1450 114
	556 1454 114
	489 1598 115
	697 1574 110
	639 1681 115
	520 1798 115
	369 1715 115
	243 1716 113
	128 1735 115
	133 1870 113
	251 1987 113
	402 1915 115
	276 1938 112
	95 140 112
	257 140 112
	419 140 112
	581 140 112
	742 140 112
	903 140 112
	1064 141 112
	1157 90 114
	3433 237 127
	3581 185 124
	3741 182 124
	3879 257 125
	3921 411 126
	3844 555 127
	3692 615 124
	3529 618 124
	3381 555 125
	3282 289 124
	3223 514 124
	3111 289 124
	3058 516 124
	2947 287 124
	2889 515 124
	2785 288 124
	2788 578 126
	2790 741 126
	2862 884 125
	2749 1073 125
	2865 1186 125
	2979 990 125
	3123 1036 124
	3188 934 126
	3010 1234 124
	3175 1230 124
	3339 1226 124
	3345 949 126
	3405 804 127
	3531 702 127
	3444 1007 124
	3499 1221 124
	3604 1002 124
	3755 1038 125
	3802 1186 126
	3741 1342 127
	3626 1456 127
	3510 1314 127
	3392 1435 127
	3506 1577 127
	2637 348 127
	2583 496 126
	2633 952 125
	2573 803 126
	2474 556 124
	2468 742 124
	2335 476 125
	2214 358 125
	2322 812 127
	2202 936 127
	2060 305 124
	1898 304 124
	1736 304 124
	2085 1049 127
	1966 1161 127
	1818 1209 124
	1657 1212 124
	1947 685 127
	1801 735 124
	1659 677 125
	1491 902 127
	1346 955 124
	1210 881 125
	1576 305 124
	1414 304 124
	1253 302 124
	1108 374 127
	991 491 127
	1557 1273 126
	938 639 126
	999 1117 125
	847 1079 124
	831 702 124
	667 702 124
	687 1084 124
	1115 1230 125
	566 764 126
	525 1083 124
	422 1024 126
	464 703 124
	302 704 124
	297 795 126
	316 1089 124
	1559 1436 126
	1560 1598 126
	1560 1759 126
	1561 1920 126
	1620 2022 124
	3388 1688 127
	3276 1546 127
	3820 342 0
	3343 1612 0
	272 351 0
	159 1774 0
	2248 1573 0
	1379 1192 0
	1757 706 20
	1838 706 20
	1319 926 20
	1389 926 20
	3184 839 20
	3185 808 20
	3677 412 67
	3079 1007 73
	3138 1007 73
	420 929 73
	481 1603 1
	485 1835 1
	325 1759 1
	244 1941 1
	226 270 7
	264 269 7
	309 268 7
	340 268 7
	175 296 7
	148 325 7
	121 356 7
	100 381 7
	202 1352 7
	280 1352 7
	359 1353 7
	439 1353 7
	531 1354 7
	744 1348 7
	833 1348 7
	931 1347 7
	990 1347 7
	3195 1621 8
	3155 1655 8
	3112 1691 8
	3078 1730 8
	3044 1764 8
	3011 1805 8
	2998 1843 8
	2986 1886 8
	2978 1937 8
	733 1753 8
	3345 1773 8
	3332 1806 8
	3317 1840 8
	3302 1873 8
	3262 1902 8
	3237 1937 8
	3225 1978 8
	1272 1839 8
	863 1776 8
	712 1902 8
	2361 1922 8
	2360 1877 8
	2362 1825 8
	2364 1772 8
	2364 1723 8
	2362 1670 8
	2395 1645 8
	2426 1600 8
	2434 1543 8
	2435 1480 8
	2406 1431 8
	2362 1392 8
	2313 1368 8
	2249 1359 8
	2202 1386 8
	2151 1434 8
	1039 1861 8
	2154 1946 8
	2156 1902 8
	2155 1840 8
	2152 1777 8
	2161 1724 8
	2128 1681 8
	2094 1442 8
	2036 1448 8
	1976 1450 8
	1924 1454 8
	2082 1685 8
	2046 1692 8
	1999 1696 8
	1961 1701 8
	1939 1737 8
	1925 1783 8
	1916 1821 8
	1904 1864 8
	1888 1913 8
	1870 1961 8
	1100 1660 8
	1876 1486 8
	1826 1533 8
	1799 1580 8
	1784 1637 8
	1765 1681 8
	1755 1718 8
	1726 1779 8
	1718 1836 8
	1705 1885 8
	1696 1934 8
	1685 1975 8
	859 1569 8]]

	else

		-- the first test epic multi map
		-- default to this crazy shit
		---------- GIRDER LIST---------
		LoadSprite(430, 1871, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1249, 1914, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1394, 1849, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1522, 1848, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1578, 1959, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1545, 2011, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(430, 1749, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(430, 1589, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(358, 1499, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(198, 1499, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(72, 1571, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(339, 1618, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(520, 1499, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(680, 1499, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(839, 1499, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1000, 1499, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1404, 1730, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1288, 1613, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1200, 1529, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1125, 1495, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1667, 2011, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1812, 1951, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1964, 2024, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1957, 1892, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2103, 1949, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2242, 2017, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2404, 2017, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2548, 1955, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2635, 1871, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2749, 1836, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2751, 1999, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2749, 1947, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2865, 1870, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2954, 1954, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3061, 2017, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3137, 1984, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3169, 1864, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3169, 1702, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3170, 1540, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3170, 1418, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3138, 1339, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3107, 1260, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3153, 1194, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3230, 1163, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3305, 1201, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3334, 1277, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3227, 1540, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3228, 1419, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3334, 1358, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3280, 1387, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3227, 1702, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3227, 1864, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3253, 1981, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3366, 2017, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3528, 2018, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3689, 2018, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(246, 1262, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(407, 1262, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(568, 1262, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(731, 1262, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(894, 1261, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1056, 1261, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1179, 1262, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1288, 1314, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1406, 1433, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1525, 1549, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1642, 1666, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1749, 1728, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1956, 1802, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1956, 1640, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1782, 1638, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1835, 1487, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1942, 1430, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2051, 1486, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2109, 1639, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2177, 1778, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2323, 1840, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(49, 1029, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(499, 1172, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(527, 1054, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(604, 1026, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(680, 1056, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(719, 1168, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(89, 728, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(251, 728, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(412, 728, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(572, 728, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(733, 728, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(894, 728, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1016, 728, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1067, 799, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1139, 891, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1067, 1171, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1067, 1049, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1136, 999, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1005, 854, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(972, 803, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(920, 780, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(891, 1206, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(887, 1150, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3018, 1311, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2871, 1369, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2809, 1523, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2809, 1647, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2469, 1777, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2612, 1715, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2809, 1702, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2727, 1694, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

		LoadSprite(3334, 1481, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3334, 1643, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3334, 1804, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3403, 1940, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1120, 944, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1163, 945, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1141, 781, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(81, 629, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(102, 498, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(81, 373, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(179, 453, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(100, 260, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(179, 330, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(249, 544, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(410, 545, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(571, 543, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(731, 543, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(891, 544, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1014, 544, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1779, 1321, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1779, 1159, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1779, 997, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1779, 836, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1722, 684, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1137, 545, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1298, 545, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1460, 546, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1608, 600, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1508, 1005, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(160, 246, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1821, 1356, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1938, 1323, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2086, 1381, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4004, 2018, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3934, 1926, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3965, 1835, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4015, 1763, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4015, 1603, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4015, 1442, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4015, 1280, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4014, 1118, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4014, 956, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4014, 793, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4014, 632, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4014, 469, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3981, 351, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3985, 204, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4045, 156, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3667, 344, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(4016, 1925, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3998, 1926, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3980, 1925, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3957, 1926, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3843, 1832, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3682, 1832, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3561, 1833, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3484, 1796, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 1675, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 1513, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 1351, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1601, 476, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1706, 421, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1888, 366, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

		LoadSprite(3997, 1743, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3979, 1742, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3962, 1741, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3943, 1741, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2199, 393, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2304, 337, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2409, 392, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2470, 502, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2412, 606, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2308, 673, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2202, 612, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2138, 507, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2739, 378, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2847, 322, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2953, 378, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2680, 489, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3012, 489, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2736, 594, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2841, 657, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2949, 594, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2448, 837, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2594, 779, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2739, 836, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2390, 950, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2789, 950, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2593, 904, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2727, 1056, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2452, 1058, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2510, 1215, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2663, 1208, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2510, 1378, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2664, 1369, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(300, 275, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(439, 274, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(628, 273, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(811, 271, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(737, 373, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(934, 440, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1075, 439, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1209, 438, sprAmGirder, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1383, 439, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3547, 344, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3584, 254, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3508, 132, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3335, 1117, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3335, 956, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3335, 795, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3335, 634, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3335, 513, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3401, 404, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 1190, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 1029, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 868, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 705, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3455, 582, sprAmGirder, 2, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3485, 503, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3601, 475, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3719, 444, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3094, 828, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(2064, 947, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(1826, 512, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

		LoadSprite(3420, 49, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(410, 682, sprAmGirder, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(528, 653, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(688, 653, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(805, 684, sprAmGirder, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(528, 672, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(688, 672, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(500, 696, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(701, 696, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

		------ WAYPOINT LIST ------
		AddWayPoint(383, 1595)
		AddWayPoint(605, 1157)
		AddWayPoint(2296, 517)
		AddWayPoint(2841, 497)
		AddWayPoint(3209, 1286)
		AddWayPoint(3708, 1945)
		AddWayPoint(4075, 1887)

		------ AMMO CRATE LIST ------
		tempG = SpawnSupplyCrate(889, 1126, amBaseballBat)
		tempG = SpawnSupplyCrate(1211, 975, amSineGun)
		tempG = SpawnSupplyCrate(3619, 451, amFirePunch)

		------ UTILITY CRATE LIST ------
		tempG = SpawnSupplyCrate(304, 1594, amRope)
		tempG = SpawnSupplyCrate(1538, 1987, amJetpack)
		tempG = SpawnSupplyCrate(1958, 2000, amExtraTime)
		tempG = SpawnSupplyCrate(2744, 1923, amJetpack)
		tempG = SpawnSupplyCrate(3283, 1363, amParachute)
		tempG = SpawnSupplyCrate(2749, 1812, amRope)
		tempG = SpawnSupplyCrate(970, 779, amJetpack)

		tempG = SpawnSupplyCrate(3284, 1332, amExtraTime)
		tempG = SpawnSupplyCrate(1082, 975, amBlowTorch)
		tempG = SpawnSupplyCrate(1547, 981, amJetpack)
		tempG = SpawnSupplyCrate(1707, 397, amRope)
		tempG = SpawnSupplyCrate(2309, 649, amExtraTime)
		tempG = SpawnSupplyCrate(1116, 867, amExtraTime)

		------ AMMO CRATE LIST ------
		tempG = SpawnSupplyCrate(2559, 880, amBazooka)
		tempG = SpawnSupplyCrate(2630, 880, amBazooka)
		tempG = SpawnSupplyCrate(1951, 1406, amGrenade)

		------ UTILITY CRATE LIST ------
		tempG = SpawnSupplyCrate(3536, 320, amBlowTorch)
		tempG = SpawnSupplyCrate(3582, 1994, amJetpack)
		tempG = SpawnSupplyCrate(682, 349, amExtraTime)
		tempG = SpawnSupplyCrate(2842, 633, amExtraTime)

		------ BARREL LIST ------
		SetHealth(AddGear(506, 1034, gtExplosives, 0, 0, 0, 0), 1)
		SetHealth(AddGear(556, 1002, gtExplosives, 0, 0, 0, 0), 1)
		SetHealth(AddGear(615, 1002, gtExplosives, 0, 0, 0, 0), 1)
		SetHealth(AddGear(676, 1010, gtExplosives, 0, 0, 0, 0), 1)
		SetHealth(AddGear(716, 1050, gtExplosives, 0, 0, 0, 0), 1)
		SetHealth(AddGear(67, 1005, gtExplosives, 0, 0, 0, 0), 50)

		------ MINE LIST ------
		SetTimer(AddGear(1187, 1908, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1235, 1908, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1283, 1908, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1323, 1908, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1361, 1875, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1399, 1837, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1426, 1810, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(234, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(308, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(377, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(460, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(550, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(633, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(722, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(795, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(881, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(975, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1060, 1493, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1127, 1489, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1207, 1526, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1261, 1580, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1315, 1634, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1372, 1692, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1416, 1736, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1465, 1792, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1518, 1838, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1566, 1886, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1623, 2005, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1686, 2005, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1799, 1957, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1839, 1917, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1902, 1886, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1933, 1886, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2076, 1916, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2138, 1978, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2221, 2011, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2305, 2011, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2390, 2011, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2578, 1918, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2494, 2002, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1758, 1728, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1683, 1707, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1635, 1657, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1572, 1596, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1517, 1542, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1447, 1477, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1401, 1432, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1338, 1365, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1290, 1310, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1230, 1266, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1149, 1260, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1054, 1257, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(978, 1257, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(895, 1258, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(819, 1257, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(753, 1258, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(671, 1260, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(599, 1260, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(526, 1259, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(466, 1259, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(408, 1261, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(336, 1260, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(290, 1259, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(218, 1260, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1777, 1263, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1776, 1198, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1778, 1141, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1781, 1078, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1778, 1027, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1778, 985, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1779, 925, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1777, 882, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(4052, 2010, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3965, 226, gtMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3962, 326, gtMine, 0, 0, 0, 0), 1)

		------ STICKY MINE LIST ------
		tempG = AddGear(3170, 1907, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3170, 1860, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3169, 1809, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3170, 1761, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3170, 1711, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3172, 1668, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3170, 1624, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3169, 1579, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3171, 1526, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3168, 1469, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3171, 1418, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3227, 1416, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3226, 1465, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3225, 1523, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3224, 1576, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3225, 1624, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3228, 1667, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3228, 1707, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3230, 1757, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3228, 1803, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3229, 1856, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3228, 1910, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(258, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(329, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(410, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(482, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(565, 533, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(670, 533, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(763, 533, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(858, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(917, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1012, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1147, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1102, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1220, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1293, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1368, 535, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(1440, 536, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(223, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(814, 534, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3909, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3867, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3824, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3784, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3732, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3682, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3627, 1822, gtSMine, 0, 0, 0, 0)
		tempG = AddGear(3557, 1823, gtSMine, 0, 0, 0, 0)
	end


end

	--[[
	-----------------------------------------------------------------
	-- not really a racing map, just a simple testmap that contains
	-- a bunch of different stuff to test HWMAP conversion
	--still lacks waypoints
	-- currently disabled because it's only really used to test stuff
	------ GIRDER LIST ------
	LoadSprite(366, 540, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(312, 696, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(377, 837, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(513, 485, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(657, 550, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(712, 704, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(655, 848, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(512, 913, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
	LoadSprite(1044, 530, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(968, 623, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1125, 623, sprAmGirder, 6, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(1042, 716, sprAmGirder, 4, U_LAND_TINT_INDESTRUCTIBLE, nil, nil, nil, lfIndestructible)
	LoadSprite(844, 613, sprAmGirder, 4, U_LAND_TINT_ICE, nil, nil, nil, lfIce)
	LoadSprite(118, 425, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

	------ RUBBER BAND LIST ------
	LoadSprite(688, 957, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(804, 1070, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(921, 1182, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1036, 1299, sprAmRubber, 1, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1184, 1349, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1348, 1345, sprAmRubber, 0, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1490, 1278, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1601, 1161, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)
	LoadSprite(1712, 1044, sprAmRubber, 3, U_LAND_TINT_NORMAL, nil, nil, nil, lfBouncy)

	------ LAND SPRITE LIST ------

	------ HEALTH CRATE LIST ------
	SetHealth(SpawnHealthCrate(694, 553), 25)

	------ AMMO CRATE LIST ------
	tempG = SpawnSupplyCrate(463, 461, amBazooka)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amBazooka")
	tempG = SpawnSupplyCrate(579, 461, amWatermelon)
	setGearValue(tempG,"caseType", "ammo")
	setGearValue(tempG,"contents", "amWatermelon")

	------ UTILITY CRATE LIST ------
	tempG = SpawnSupplyCrate(367, 500, amBlowTorch)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amBlowTorch")
	tempG = SpawnSupplyCrate(638, 493, amExtraTime)
	setGearValue(tempG,"caseType", "util")
	setGearValue(tempG,"contents", "amExtraTime")

	------ BARREL LIST ------
	SetHealth(AddGear(140, 409, gtExplosives, 0, 0, 0, 0), 1)

	------ MINE LIST ------
	SetTimer(AddGear(1016, 520, gtMine, 0, 0, 0, 0), 3000)
	SetTimer(AddGear(1057, 520, gtMine, 0, 0, 0, 0), 3000)
	SetTimer(AddGear(1104, 520, gtMine, 0, 0, 0, 0), 3000)

	------ STICKY MINE LIST ------
	tempG = AddGear(311, 651, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(311, 686, gtSMine, 0, 0, 0, 0)
	tempG = AddGear(308, 729, gtSMine, 0, 0, 0, 0)

	------ AIR MINE LIST ------
	SetTimer(AddGear(1023, 600, gtAirMine, 0, 0, 0, 0), 1)
	SetTimer(AddGear(1073, 657, gtAirMine, 0, 0, 0, 0), 1)

	------ TARGET LIST ------
	tempG = AddGear(485, 895, gtTarget, 0, 0, 0, 0)

	------ CLEAVER LIST ------
	tempG = AddGear(560, 898, gtKnife, 0, 0, 0, 0)]]






	--[[
		------------------------------------------
		-- tiny airmine explosion knock concept test
		-- currently won't play nicely with others
		-- removed because it is small and boring
		------ GIRDER LIST ------
		LoadSprite(3942, 116, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3999, 270, sprAmGirder, 6, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3925, 407, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3777, 470, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3791, 65, sprAmGirder, 4, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3644, 121, sprAmGirder, 7, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)
		LoadSprite(3629, 413, sprAmGirder, 5, U_LAND_TINT_NORMAL, nil, nil, nil, lfNormal)

		------ AMMO CRATE LIST ------
		tempG = SpawnSupplyCrate(3772, 446, amWatermelon)
		tempG = SpawnSupplyCrate(3769, 415, amWatermelon)
		tempG = SpawnSupplyCrate(3773, 384, amWatermelon)
		tempG = SpawnSupplyCrate(3771, 353, amWatermelon)
		tempG = SpawnSupplyCrate(3770, 322, amWatermelon)
		tempG = SpawnSupplyCrate(3775, 291, amWatermelon)
		tempG = SpawnSupplyCrate(3776, 260, amWatermelon)
		tempG = SpawnSupplyCrate(3775, 229, amWatermelon)
		tempG = SpawnSupplyCrate(3772, 198, amWatermelon)
		tempG = SpawnSupplyCrate(3776, 167, amWatermelon)

		------ UTILITY CRATE LIST ------
		tempG = SpawnSupplyCrate(3723, 446, amJetpack)
		tempG = SpawnSupplyCrate(3725, 415, amJetpack)
		tempG = SpawnSupplyCrate(3814, 446, amJetpack)
		tempG = SpawnSupplyCrate(3814, 415, amJetpack)
		tempG = SpawnSupplyCrate(3815, 384, amJetpack)
		tempG = SpawnSupplyCrate(3728, 384, amJetpack)

		------ AIR MINE LIST ------
		SetTimer(AddGear(3489, 110, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3509, 366, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3399, 114, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3438, 383, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3322, 113, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3369, 384, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3290, 379, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3253, 112, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3178, 111, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3228, 375, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3173, 384, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3115, 118, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3039, 126, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2954, 139, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3121, 404, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2918, 414, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2880, 144, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2815, 146, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2731, 140, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2867, 408, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2802, 394, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2733, 392, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2661, 392, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2672, 147, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2608, 144, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2558, 117, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2495, 86, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2425, 49, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2373, 79, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2313, 104, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2256, 156, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2218, 226, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2205, 318, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2218, 419, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2255, 479, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2290, 522, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2343, 557, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2413, 540, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2500, 514, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2572, 471, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2618, 436, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2926, 478, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2926, 548, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2924, 615, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3126, 472, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3128, 553, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3136, 623, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3139, 683, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2927, 657, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2919, 720, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3132, 746, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2920, 771, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3137, 798, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2926, 820, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3140, 848, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(945, 441, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(900, 477, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(899, 540, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(915, 631, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1013, 616, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(970, 533, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1062, 458, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1060, 537, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1094, 640, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1029, 692, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(928, 718, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(831, 592, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(860, 666, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(823, 493, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1032, 427, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(953, 351, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(845, 375, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1101, 326, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1128, 565, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1126, 446, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1208, 703, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1139, 726, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1024, 777, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(918, 775, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(812, 758, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3171, 887, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3222, 939, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3273, 977, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3330, 1011, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3401, 1051, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2928, 899, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2935, 966, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2959, 1021, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2999, 1077, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3050, 1136, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3108, 1184, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3159, 1221, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3214, 1243, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3289, 1279, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3453, 1087, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3515, 1136, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3566, 1202, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3604, 1275, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3618, 1345, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3608, 1436, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3582, 1505, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3528, 1565, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3456, 1610, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3368, 1651, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3289, 1666, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3205, 1668, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3132, 1672, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3270, 1325, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3192, 1346, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3140, 1346, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3067, 1359, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2997, 1373, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2918, 1391, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2839, 1406, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3078, 1672, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(3019, 1659, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2936, 1667, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(2859, 1675, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(975, 722, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(967, 636, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1078, 687, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(868, 740, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(863, 453, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1010, 494, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1080, 590, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(869, 589, gtAirMine, 0, 0, 0, 0), 1)
		SetTimer(AddGear(1013, 569, gtAirMine, 0, 0, 0, 0), 1)]]
