/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.emboss.jemboss.editor.ColourMenu;

public class ColourPanel
extends JPanel
implements ActionListener {
    protected Color col;
    private int xsize = 20;
    private int ysize = 20;
    private JPopupMenu popup;

    public ColourPanel(String menu, Color col) {
        this.col = col;
        this.setPreferredSize(new Dimension(this.xsize, this.ysize));
        this.setMaximumSize(new Dimension(this.xsize, this.ysize));
        ColourMenu cm = new ColourMenu(menu);
        this.popup = new JPopupMenu();
        this.addMouseListener(new PopupListener());
        cm.addActionListener(this);
        this.popup.add(cm);
    }

    public void actionPerformed(ActionEvent e) {
        ColourMenu m = (ColourMenu)e.getSource();
        this.col = m.getColor();
        this.repaint();
    }

    public Color getColour() {
        return this.col;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.col);
        g.fillRect(0, 0, this.xsize, this.ysize);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.xsize, this.ysize);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ColourPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

