// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

#nullable enable

using System.Threading;
using System.Threading.Tasks;
using NuGet.Common;
using NuGet.Protocol.Core.Types;
using NuGet.Protocol.Model;

namespace NuGet.Protocol
{
    /// <summary>A resource to get known package vulnerability information.</summary>
    public interface IVulnerabilityInfoResource : INuGetResource
    {
        /// <summary>Get the known package vulnerabilities from the current package source.</summary>
        /// <param name="cacheContext">The cache settings to use for any external requests.</param>
        /// <param name="logger">The logger for any messages.</param>
        /// <param name="cancellationToken">The cancellation token to cancel operation.</param>
        /// <returns>A result object with known package vulnerability information and any errors.</returns>
        Task<GetVulnerabilityInfoResult> GetVulnerabilityInfoAsync(SourceCacheContext cacheContext, ILogger logger, CancellationToken cancellationToken);
    }
}
