# CiviCRM 4.7.16

Released February 8, 2017

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-19925](https://issues.civicrm.org/jira/browse/CRM-19925) Add metadata
  to fields array with entity info & date format info
  ([9727](https://github.com/civicrm/civicrm-core/pull/9727))**

  The data access objects (DAO) now include additional information for each
  field, including the table name, entity, and business access object (BAO).

- **[CRM-19829](https://issues.civicrm.org/jira/browse/CRM-19829) Activity feed
  ([9714](https://github.com/civicrm/civicrm-core/pull/9714),
  [9649](https://github.com/civicrm/civicrm-core/pull/9649), and
  [9624](https://github.com/civicrm/civicrm-core/pull/9624))
  (Preliminary work)**

  The Attachment API now includes the appropriate icon class name from Font
  Awesome, a `CRM.cache` object in Javascript is available to set and retrieve
  information from `window.localStorage`, and a new Angular utility
  `crmThrottle` prevents a function from running concurrently if called several
  times in rapid succession.

- **[CRM-19893](https://issues.civicrm.org/jira/browse/CRM-19893) Activity Type
  Categories ([9696](https://github.com/civicrm/civicrm-core/pull/9696))
  (Preliminary work)**

  The option value form now displays the option's grouping if available.

- **[CRM-19831](https://issues.civicrm.org/jira/browse/CRM-19831) Function
  `CRM_Contact_BAO_Group::getGroupsHierarchy` performes bad with 3000 groups
  ([9673](https://github.com/civicrm/civicrm-core/pull/9673) and
  [9633](https://github.com/civicrm/civicrm-core/pull/9633))**

  Group listing performance is improved on sites with many groups.

- **[CRM-19256](https://issues.civicrm.org/jira/browse/CRM-19256) Add a hook to
  dynamically escalate permissions
  ([8916](https://github.com/civicrm/civicrm-core/pull/8916))**

  A new `hook_civicrm_permission_check` is invoked whenever a user's permissions
  are evaluated.  (See [hook
  documentation](https://wiki.civicrm.org/confluence/display/CRMDOC/hook_civicrm_permission_check)
  for details and examples.)

- **[CRM-19853](https://issues.civicrm.org/jira/browse/CRM-19853) Change
  interval select controls in Scheduled Reminders with number controls
  ([9664](https://github.com/civicrm/civicrm-core/pull/9664))**

  A few drop-down fields in the Scheduled Reminders interface that were simply
  picking integers have been replaced with regular text fields.

- **[CRM-19769](https://issues.civicrm.org/jira/browse/CRM-19769) Colors for
  tags and [CRM-19779](https://issues.civicrm.org/jira/browse/CRM-19779) Colors
  for activity statuses
  ([9660](https://github.com/civicrm/civicrm-core/pull/9660),
  [9600](https://github.com/civicrm/civicrm-core/pull/9600), and
  [9554](https://github.com/civicrm/civicrm-core/pull/9554))**

  You can choose colors for tags and activity statuses for better visibility.

- **[CRM-19770](https://issues.civicrm.org/jira/browse/CRM-19770) Favorite
  (starred) activities
  ([9629](https://github.com/civicrm/civicrm-core/pull/9629))**

  You can now mark favorite activities with stars.

- **[CRM-19723](https://issues.civicrm.org/jira/browse/CRM-19723) Icons for
  activity types ([9707](https://github.com/civicrm/civicrm-core/pull/9707),
  [9553](https://github.com/civicrm/civicrm-core/pull/9553),
  [9528](https://github.com/civicrm/civicrm-core/pull/9528),
  and [9706](https://github.com/civicrm/civicrm-core/pull/9706)**

  A user can now choose icons for activity types.

- **[CRM-19816](https://issues.civicrm.org/jira/browse/CRM-19816) Improve
  activity search filters
  ([9609](https://github.com/civicrm/civicrm-core/pull/9609)) (Preliminary work)**

  The `Activity.get` API is improved for filtering by related contact, case, and
  tag.

- **[CRM-19447](https://issues.civicrm.org/jira/browse/CRM-19447) Improve
  Activity Subject/Details text search to be similiar to Notes Subject/Body
  ([9536](https://github.com/civicrm/civicrm-core/pull/9536))**

  Activity search now has a single "Activity Text" field for finding text in the
  activity subject, details, or both.

- **[CRM-19883](https://issues.civicrm.org/jira/browse/CRM-19883) Activity
  Priority Field is Not Included in Advanced Search or Activity Reports
  ([9687](https://github.com/civicrm/civicrm-core/pull/9687))**

  The priority field is now available in search and activity reports.

- **[CRM-19810](https://issues.civicrm.org/jira/browse/CRM-19810) Api3 - Add
  joins on optionValue table
  ([9593](https://github.com/civicrm/civicrm-core/pull/9593))**

  Foreign keys to option values can now be used for joins in the API despite the
  fact that they aren't true foreign keys.

- **[CRM-19839](https://issues.civicrm.org/jira/browse/CRM-19839) Declare class
  used on developer tab of CiviCRM reports
  ([9646](https://github.com/civicrm/civicrm-core/pull/9646))**

  When viewing the Developer tab on a report, you can now see the report class
  in use.

- **[CRM-19812](https://issues.civicrm.org/jira/browse/CRM-19812) Display
  related contact names in activity.get api
  ([9599](https://github.com/civicrm/civicrm-core/pull/9599))**

  Activity assignees and targets are now available as return options in the
  `Activity.get` API.

### CiviCase

- **[CRM-19806](https://issues.civicrm.org/jira/browse/CRM-19806) CiviCase using
  two formlinks when it only needs one
  ([9586](https://github.com/civicrm/civicrm-core/pull/9586))**

  CiviCase now behaves like the rest of CiviCRM when creating action links in a
  listing of cases.

- **[CRM-19778](https://issues.civicrm.org/jira/browse/CRM-19778) Allowed
  statuses per case-type
  ([9705](https://github.com/civicrm/civicrm-core/pull/9705))**

  Case types can be configured to restrict the available case statuses.

### CiviContribute

- **[CRM-8526](https://issues.civicrm.org/jira/browse/CRM-8526) Support
  [contribution.custom_nn] tokens in templates
  ([9661](https://github.com/civicrm/civicrm-core/pull/9661))**

  You can now insert tokens for contribution custom fields.

- **[CRM-16189](https://issues.civicrm.org/jira/browse/CRM-16189) Improve
  support for Accrual Method bookkeeping
  ([8870](https://github.com/civicrm/civicrm-core/pull/8870)) (Completes previous work)**

  A "Record Payment" button is now available on contributions.

### CiviEvent

- **Add select2 class to loc_event_id
  ([9603](https://github.com/civicrm/civicrm-core/pull/9603))**

  The field for re-using the location of another event now uses a `select2`
  widget.

### CiviMail

- **[CRM-19690](https://issues.civicrm.org/jira/browse/CRM-19690) Allow
  alternative email templating systems
  ([9689](https://github.com/civicrm/civicrm-core/pull/9689),
  [9566](https://github.com/civicrm/civicrm-core/pull/9566),
  [9619](https://github.com/civicrm/civicrm-core/pull/9619),
  [9565](https://github.com/civicrm/civicrm-core/pull/9565),
  [9564](https://github.com/civicrm/civicrm-core/pull/9564),
  [9563](https://github.com/civicrm/civicrm-core/pull/9563), and
  [9562](https://github.com/civicrm/civicrm-core/pull/9562))**

  Extensions can now specify mailing template types with template options.
  These types can be associated with different template editors, such as
  [Mosaico](https://github.com/veda-consulting/uk.co.vedaconsulting.mosaico).
  The way tokens are presented and evaluated in CiviMail is also streamlined.
  This also passes mail delivery to the FlexMailer extension when it is enabled.

### Drupal Integration Modules

- **[CRM-17917](https://issues.civicrm.org/jira/browse/CRM-17917) Add support
  for Drupal 8 ([388](https://github.com/civicrm/civicrm-drupal/pull/388)) (Continues previous work)**

  Several small improvements were made, making it easier to install CiviCRM on Drupal 8 using [Buildkit](https://buildkit.civicrm.org/).

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-19874](https://issues.civicrm.org/jira/browse/CRM-19874) Allow
  overriding sort in the getlist API without clobbering pager
  ([9675](https://github.com/civicrm/civicrm-core/pull/9675))**

  The default pager parameters are no longer ignored when other `options` are set in a `getlist` API.

- **[CRM-19783](https://issues.civicrm.org/jira/browse/CRM-19783) Accessibility
  Error - CiviCRM Subscription Page
  ([9606](https://github.com/civicrm/civicrm-core/pull/9606))**

- **Remove unused var, comments & clean up & refactor caching function
  ([9721](https://github.com/civicrm/civicrm-core/pull/9721))**

- **[CRM-19906](https://issues.civicrm.org/jira/browse/CRM-19906) Allow Drupal
  user names with "@"
  ([9708](https://github.com/civicrm/civicrm-core/pull/9708))**

- **[CRM-19003](https://issues.civicrm.org/jira/browse/CRM-19003) Profile
  listing doesn't produce expected results when range-searching custom date
  field ([9699](https://github.com/civicrm/civicrm-core/pull/9699))**

- **[CRM-19801](https://issues.civicrm.org/jira/browse/CRM-19801) changing the
  same relationship type of a relationship from A to B or vice versa does not
  work ([9579](https://github.com/civicrm/civicrm-core/pull/9579))**

- **[CRM-19842](https://issues.civicrm.org/jira/browse/CRM-19842) Can't delete a
  dedupe rule ([9698](https://github.com/civicrm/civicrm-core/pull/9698))**

- **typo fix in New Tag Form.
  ([9700](https://github.com/civicrm/civicrm-core/pull/9700))**

- **CRM_Extension_Browser - Allow different cache files for different feeds
  ([9693](https://github.com/civicrm/civicrm-core/pull/9693))**

- **[CRM-17663](https://issues.civicrm.org/jira/browse/CRM-17663) Dashlet code
  improvements ([9672](https://github.com/civicrm/civicrm-core/pull/9672))
  (Completes previous work)**

  An upgrade step now fixes dashlets named `NULL`.

- **Fire hook_civicrm_emailProcessor('activity') if Activity,create successful
  ([9651](https://github.com/civicrm/civicrm-core/pull/9651))**

- **Civi\API\ExternalBatch - Verify that $_ENV is working
  ([9595](https://github.com/civicrm/civicrm-core/pull/9595))**

- **[CRM-19847](https://issues.civicrm.org/jira/browse/CRM-19847) batch merge
  redirects users to snippet URL
  ([9653](https://github.com/civicrm/civicrm-core/pull/9653))**

- **(NFC) Civi/*, CRM_Utils_SQL_Select - Fix various warnings
  ([9657](https://github.com/civicrm/civicrm-core/pull/9657))**

- **[CRM-19824](https://issues.civicrm.org/jira/browse/CRM-19824) Event
  listeners are missing if container cache is disabled
  ([9617](https://github.com/civicrm/civicrm-core/pull/9617))**

- **[CRM-19826](https://issues.civicrm.org/jira/browse/CRM-19826) Extensions in
  "vendor" folder have errant slash
  ([9618](https://github.com/civicrm/civicrm-core/pull/9618))**

- **[CRM-19706](https://issues.civicrm.org/jira/browse/CRM-19706) Smart Group
  criteria (Activity Status) are not being retained when using 'Edit Smart Group
  criteria' ([9620](https://github.com/civicrm/civicrm-core/pull/9620))**

- **[CRM-19624](https://issues.civicrm.org/jira/browse/CRM-19624) Exclude /
  Include by privacy radio buttons gets reset on Smartgroup re-editing
  ([9597](https://github.com/civicrm/civicrm-core/pull/9597))**

- **[CRM-19805](https://issues.civicrm.org/jira/browse/CRM-19805) Comparing
  instead of Assigning
  ([9591](https://github.com/civicrm/civicrm-core/pull/9591))**

  This fixes three typos in the codebase where `==` was used instead of `=`.

- **[CRM-19244](https://issues.civicrm.org/jira/browse/CRM-19244) Custom fields
  with option group not importing
  ([8906](https://github.com/civicrm/civicrm-core/pull/8906))**

- **OptionValue Api cleanup - remove unnecessary lookup
  ([9569](https://github.com/civicrm/civicrm-core/pull/9569))**

- **[CRM-18472](https://issues.civicrm.org/jira/browse/CRM-18472) Notice fixes
  ([9558](https://github.com/civicrm/civicrm-core/pull/9558)) (Completes
  previous work)**

  Avoids a PHP notice on deleting soft credits.

- **Upgrade cleanup - use addColumn utility instead of sql
  ([9548](https://github.com/civicrm/civicrm-core/pull/9548))**

- **API Explorer: Minor usability improvements
  ([9539](https://github.com/civicrm/civicrm-core/pull/9539))**

- **[CRM-19832](https://issues.civicrm.org/jira/browse/CRM-19832)
  hook_civicrm_searchTasks get invoked twice for some entities
  ([9637](https://github.com/civicrm/civicrm-core/pull/9637))**

- **[CRM-19875](https://issues.civicrm.org/jira/browse/CRM-19875) Search
  builder: Fatal error when searching custom field of type "country"
  ([9695](https://github.com/civicrm/civicrm-core/pull/9695))**

- **[CRM-19811](https://issues.civicrm.org/jira/browse/CRM-19811) Slow queries
  due to use of LOWER() in mysql searches, fix contribution search, current
  employer. Comment elsewhere
  ([9596](https://github.com/civicrm/civicrm-core/pull/9596))**

- **[CRM-19884](https://issues.civicrm.org/jira/browse/CRM-19884) DB Error on
  Activity Details Report
  ([9681](https://github.com/civicrm/civicrm-core/pull/9681))**

- **[CRM-19509](https://issues.civicrm.org/jira/browse/CRM-19509) Add character
  set and collation to create table statements in reports
  ([9411](https://github.com/civicrm/civicrm-core/pull/9411))**

- **[CRM-19807](https://issues.civicrm.org/jira/browse/CRM-19807) MySQL error
  when adding contacts on a report to a group
  ([9594](https://github.com/civicrm/civicrm-core/pull/9594))**

- **[CRM-18591](https://issues.civicrm.org/jira/browse/CRM-18591) group_type
  parameter ignored when using API to create group
  ([9578](https://github.com/civicrm/civicrm-core/pull/9578)) (Completes
  previous work)**

  This improves the handling of checkboxes on the group edit form.

### Accounting

- **[CRM-19800](https://issues.civicrm.org/jira/browse/CRM-19800) Incorrect
  Amount recorded in civicrm_financial_trxn table
  ([9577](https://github.com/civicrm/civicrm-core/pull/9577))**

  This fixes problems when money amounts were entered with a thousands
  delimiter.

- **[CRM-19585](https://issues.civicrm.org/jira/browse/CRM-19585) Sales tax
  issue ([9598](https://github.com/civicrm/civicrm-core/pull/9598),
  [9576](https://github.com/civicrm/civicrm-core/pull/9576),
  [9590](https://github.com/civicrm/civicrm-core/pull/9590), and
  [9574](https://github.com/civicrm/civicrm-core/pull/9574)) (Preliminary
  work)**

  A variety of problems have been partially fixed.

- **[CRM-19804](https://issues.civicrm.org/jira/browse/CRM-19804) Pre() and
  Post() hook for Financial Account
  ([9584](https://github.com/civicrm/civicrm-core/pull/9584))**

### CiviCase

- **[CRM-19890](https://issues.civicrm.org/jira/browse/CRM-19890) Case Manager
  listed in cases tab is not up to date
  ([9691](https://github.com/civicrm/civicrm-core/pull/9691))**

- **[CRM-19754](https://issues.civicrm.org/jira/browse/CRM-19754) CiviCase role
  relationships reversed
  ([9560](https://github.com/civicrm/civicrm-core/pull/9560))**

- **[CRM-19897](https://issues.civicrm.org/jira/browse/CRM-19897) Cannot edit
  multiple case activities via profile, because deprecated "access CiviCase"
  permission is referenced
  ([9703](https://github.com/civicrm/civicrm-core/pull/9703))**

- **Docs fix: update for changed URL of Case Management > Setup page.
  ([9701](https://github.com/civicrm/civicrm-core/pull/9701))**

### CiviContribute

- **[CRM-19172](https://issues.civicrm.org/jira/browse/CRM-19172) on behalf form +
  user account creation attempts to create user for org
  ([9669](https://github.com/civicrm/civicrm-core/pull/9669))**

- **[CRM-19863](https://issues.civicrm.org/jira/browse/CRM-19863) 'item_name'
  unnecessarily truncated when passed to PayPal
  ([9677](https://github.com/civicrm/civicrm-core/pull/9677))**

- **[CRM-19725](https://issues.civicrm.org/jira/browse/CRM-19725) Honoree should
  never be same as donor
  ([9503](https://github.com/civicrm/civicrm-core/pull/9503))**

- **[CRM-19761](https://issues.civicrm.org/jira/browse/CRM-19761) contribution
  thank you letter generator: unable to export to docx
  ([9575](https://github.com/civicrm/civicrm-core/pull/9575) and
  [9568](https://github.com/civicrm/civicrm-core/pull/9568))**

- **[CRM-19799](https://issues.civicrm.org/jira/browse/CRM-19799) LineItems
  incorrect at both Contribution Level and Financial Accounts Level
  ([9580](https://github.com/civicrm/civicrm-core/pull/9580))**

- **[CRM-19802](https://issues.civicrm.org/jira/browse/CRM-19802) Contribution
  page : missing translation
  ([9581](https://github.com/civicrm/civicrm-core/pull/9581))**

- **[CRM-19777](https://issues.civicrm.org/jira/browse/CRM-19777) Edit
  contribution : wrong decimal separator on total_amount
  ([9556](https://github.com/civicrm/civicrm-core/pull/9556))**

- **[CRM-19795](https://issues.civicrm.org/jira/browse/CRM-19795) Contribution
  page confirmation screen undefined index pay_later_receipt
  ([9632](https://github.com/civicrm/civicrm-core/pull/9632))**

- **[CRM-19794](https://issues.civicrm.org/jira/browse/CRM-19794) Wrong fields
  displayed when setting a price set for a contribution page
  ([9697](https://github.com/civicrm/civicrm-core/pull/9697))**

### CiviEvent

- **[CRM-19860](https://issues.civicrm.org/jira/browse/CRM-19860) Event
  participant batch update: respect "options per line" setting for radio buttons
  ([9667](https://github.com/civicrm/civicrm-core/pull/9667))**

- **[CRM-19907](https://issues.civicrm.org/jira/browse/CRM-19907) Syntax error
  generated on CiviEvent Dashboard when show_events is null
  ([9709](https://github.com/civicrm/civicrm-core/pull/9709))**

- **[CRM-19789](https://issues.civicrm.org/jira/browse/CRM-19789) Cannot create
  smart group from 'Find participants'
  ([9567](https://github.com/civicrm/civicrm-core/pull/9567))**

- **[CRM-19782](https://issues.civicrm.org/jira/browse/CRM-19782) "View" link on
  printed Participant Listing Report renders display name unreadable
  ([9546](https://github.com/civicrm/civicrm-core/pull/9546))**

- **[CRM-19803](https://issues.civicrm.org/jira/browse/CRM-19803) View Payment
  popup of a participant does not show refunds
  ([9634](https://github.com/civicrm/civicrm-core/pull/9634) and
  [9592](https://github.com/civicrm/civicrm-core/pull/9592))**

- **[CRM-19288](https://issues.civicrm.org/jira/browse/CRM-19288) VAT not
  included for additional participant fee when registering for events
  ([9545](https://github.com/civicrm/civicrm-core/pull/9545))**

### CiviMail

- **[CRM-19413](https://issues.civicrm.org/jira/browse/CRM-19413) CiviMail: Test
  mail notice errors: undefined index
  ([9550](https://github.com/civicrm/civicrm-core/pull/9550))**

### CiviMember

- **[CRM-19895](https://issues.civicrm.org/jira/browse/CRM-19895) membership
  renewal page style collapsed if email disabled
  ([9713](https://github.com/civicrm/civicrm-core/pull/9713))**

- **[CRM-19936](https://issues.civicrm.org/jira/browse/CRM-19936) Membership
  line items are duplicated when a membership is created or renewed with
  priceset containing multiple memberships
  ([9748](https://github.com/civicrm/civicrm-core/pull/9748))
  (Preliminary work)**

- **[CRM-19817](https://issues.civicrm.org/jira/browse/CRM-19817) Notice error
  fails membership export
  ([9610](https://github.com/civicrm/civicrm-core/pull/9610))**

  Membership export with data from related contacts was causing PHP notices or
  complete failure, depending upon the CMS.

- **Fix startdate for testMembershipJoinDateFixed
  ([9608](https://github.com/civicrm/civicrm-core/pull/9608))**

### Drupal Integration

- **[CRM-19740](https://issues.civicrm.org/jira/browse/CRM-19740) Regression in
  phone number Drupal views integration
  ([415](https://github.com/civicrm/civicrm-drupal/pull/415))**

  A problem has been fixed where the same phone number would show up for each of
  a contact's location/phone types in Views.

- **CiviCRM Menu -- Add PathProcessor to allow parameters to routes to include
  slashes ([420](https://github.com/civicrm/civicrm-drupal/pull/420))**

- **[CRM-19086](https://issues.civicrm.org/jira/browse/CRM-19086) CiviCRM Core
  Installation fails on Drupal 8.1.x and
  [CRM-18297](https://issues.civicrm.org/jira/browse/CRM-18297) Drupal 8 Crash
  on Admin Config page
  ([419](https://github.com/civicrm/civicrm-drupal/pull/419))**

### Joomla Integration

- **[CRM-19877](https://issues.civicrm.org/jira/browse/CRM-19877) on Joomla
  api.Setting.create fails with "option,task not valid settings"
  ([9678](https://github.com/civicrm/civicrm-core/pull/9678))**

## <a name="misc"></a>Miscellany

- **Comment fixes plus fix inconsistent unused return bool
  ([9722](https://github.com/civicrm/civicrm-core/pull/9722))**

- **[nfc] Updated test generated examples
  ([9720](https://github.com/civicrm/civicrm-core/pull/9720))**

- **[nfc] Comment fixes, remove one unused var, declare visibility
  ([9717](https://github.com/civicrm/civicrm-core/pull/9717))**

- **[NFC] add comments & extract function in contribution search
  ([9716](https://github.com/civicrm/civicrm-core/pull/9716))**

- **Comment Fixes ([9659](https://github.com/civicrm/civicrm-core/pull/9659))**

- **Comments ([9658](https://github.com/civicrm/civicrm-core/pull/9658))**

- **Add comment blocks
  ([9656](https://github.com/civicrm/civicrm-core/pull/9656))**

- **allow descendant classes to access the cache array
  ([9605](https://github.com/civicrm/civicrm-core/pull/9605))**

- **(NFC) CRM_*_Tokens - Reduce redundant docs
  ([9573](https://github.com/civicrm/civicrm-core/pull/9573))**

- **tools/scripts/phpunit-ls - Fix PhpStorm lookup of PHPUnit_Framework_TestCase
  ([9535](https://github.com/civicrm/civicrm-core/pull/9535))**

- **[CRM-19768](https://issues.civicrm.org/jira/browse/CRM-19768)
  CRM_Utils_Token::replace*Tokens() usage is inconsistent
  ([9541](https://github.com/civicrm/civicrm-core/pull/9541)) (Preliminary
  work)**

- **Convert drupal to Backdrop and change variable_get/set to state_get/set
  ([21](https://github.com/civicrm/civicrm-backdrop/pull/21))**

- **fix header ([9607](https://github.com/civicrm/civicrm-core/pull/9607))**

- **fix headers ([421](https://github.com/civicrm/civicrm-drupal/pull/421))**

- **fix headers ([109](https://github.com/civicrm/civicrm-wordpress/pull/109))**

- **fix headers ([42](https://github.com/civicrm/civicrm-joomla/pull/42))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; ATD Fourth World - Véronique
Gratioulet; Agileware - Agileware Team; Aidan Saunders; AppChecker; Australian
reens - Seamus Lee; CiviCRM - Coleman Watts, Jitendra Purohit, Tim Otten, Monish
Deb, Yashodha Chaku; CiviCoop - Jaap Jansma; CiviDesk - Nicolas Ganivet;
Community Builders - Dejan Lukic; CompuCorp - Omar Abu Hussein; Coop SymbioTIC -
Mathieu Lutfy; Erich Schulz; Freeform Solutions - Herb van den Dool; Fuzion -
Chris Burgess, Eileen McNaughton; Ginkgo Street Labs - Frank Gómez; JMA
Consulting - Edsel Lopez, Jon Goldberg, Pradeep Nayak; John Kingsnorth; Joinery -
Allen Shaw; Klaas Eikelboom; Klangsoft - David Reedy Jr; Lighthouse Design and
Consulting - Brian Shaughnessy; Marc Brazeau; Progressive Technology Project -
Jamie McClelland; Skvare - Mark Hanna; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Tommy Bobo; Christian Wach; Circle Interactive - Dave Jenkins;
CiviCRM - Donald Lobo, Rohan Katkar; Community IT Academy - William Mortada;
CompuCorp - Madura Krishnamoorthy, Mike Kondrashin; Denver DataMan - Steve
Kessler; Digitalcourage - Detlev Sieber; Fedor Khodkov; Forest CRM Consulting -
Tamar Meir; Fuzion - Peter Davis; Ginkgo Street Labs - Frank Gómez; Glick
Software - David Glick; iXiam - Vangelis Pantazis; JMA Consulting - Joe Murray;
Kacper Warda; Ken West; Korlon - Stuart Gaston; Naomi Rosenberg; Noah Miller;
Oxfam Germany - Thomas Schüttler; Richard van Oosterhout; Robert Lang; Semper IT -
Karin Gerritsen; Tadpole Collective - Kevin Cristiano; University of Hawaii at
Manoa - Center on Disability Studies - William Rems; Vakees K; Valéry Gouleau
