/*
 *                    PDB web development code
 *
 * This code may be freely distributed and modified under the
 * terms of the GNU Lesser General Public Licence.  This should
 * be distributed with the code.  If you do not have a copy,
 * see:
 *
 *      http://www.gnu.org/copyleft/lesser.html
 *
 * Copyright for this code is held jointly by the individual
 * authors.  These should be listed in @author doc comments.
 *
 *
 * Created on Jul 23, 2009
 * Created by ap3
 *
 */

package org.biojava.nbio.structure.test.align.fatcat;


import junit.framework.TestCase;

public class TestOutputStrings extends TestCase
{

	static final String newline = System.getProperty("line.separator");

	public void printFirstMismatch(String s1, String s2){
		String[] spl1 = s1.split(newline);
		String[] spl2 = s2.split(newline);

		for (int i = 0 ; i < spl1.length ; i++){

			String line1 = spl1[i];

			if ( i >= spl2.length){
				System.err.println("s2 does not contain line " + (i+1));
				return;
			}
			String line2 = spl2[i];

			if ( line1.equals(line2)){
				continue;
			}

			System.err.println("mismatch in line: " + (i+1));

			for ( int j = 0 ; j < line1.length();j++){
				char c1 = line1.charAt(j);

				if ( j >= line2.length()){
					System.err.println("s2 is shorter than s1. length s1:" + line1.length() + " length2:" + line2.length() );
					return;
				}

				char c2 = line2.charAt(j);
				if ( c1 != c2){

					System.err.println("line1: " + line1.substring(0,j+1));
					System.err.println("line2: " + line2.substring(0,j+1));

					System.err.println("mismatch at position " + (j+1) + " c1: "+ c1 + " " + c2);

					return;
				}
			}


		}

	}

	protected void printMismatch(String orig, String mine){
		System.err.println("The two provided strings are not identical.");
		System.err.println("Original version");
		System.err.println(orig);
		System.err.println("My version");
		System.err.println(mine);
	}


	//
	// a bad mismatch!
	// looks like a bug in the optimizer still...
	// spent already too much time with figuring this out. perhaps there is no bug
	// and the diff is caused by this tricky alignment and some Java/C differences...
	//
//   public void test1a641hng(){
//      String pdb1 = "1a64";
//      String chain1 = "A";
//      String pdb2 = "1hng";
//      String chain2 ="B";
//
//      String originalOutput="Align 1a64A.pdb 94 with 1hngB.pdb 175" +newline +
//      "Twists 0 ini-len 72 ini-rmsd 20.93 opt-equ 55 opt-rmsd 7.78 chain-rmsd 20.93 Score 189.29 align-len 73 gaps 18 (24.66%)" +newline +
//      "P-value 9.15e-03 Afp-num 6497 Identity 4.11% Similarity 13.70%" +newline +
//      "Block  0 afp  9 score 189.29 rmsd 20.93 gap 17 (0.19%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:   27 IDEVRWERGSTLVAEFKR-----------KPFLKSGAFEILANGDLKIKNLTRDDSGTYNVTVYSTNGTR" +newline +
//      "              111111111111111111           1111111111111111111       111111111111111" +newline +
//      "Chain 2:    2 DSGTVWGALGHGINLNIPNFQMTDDIDEVRWERGSTLVAEFKRKMKPF-------LKSGAFEILANGDLK" +newline +
//      "" +newline +
//      "" +newline +
//      "Chain 1:   88 ILD" +newline +
//      "              111" +newline +
//      "Chain 2:   65 IKN" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" +newline ;
//
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,true);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//         fail(msg);
//
//      }
//   }

// disabled since so slow...
//   public void test1jbe1ord(){
//      String pdb1 = "1jbe";
//      String chain1 = "A";
//      String pdb2 = "1ord";
//      String chain2 ="A";
//
//
//
//      String originalOutput="Align 1jbeA.pdb 126 with 1ordA.pdb 730" + newline +
//      "Twists 0 ini-len 72 ini-rmsd 3.09 opt-equ 101 opt-rmsd 3.03 chain-rmsd 3.09 Score 123.13 align-len 127 gaps 26 (20.47%)" + newline +
//      "P-value 3.45e-01 Afp-num 30029 Identity 11.02% Similarity 22.05%" + newline +
//      "Block  0 afp  9 score 123.13 rmsd  3.09 gap 53 (0.42%)" + newline +
//      "" + newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" + newline +
//      "Chain 1:    3 DKELKFLVVDDFSTMRRIVRNLLKELGFNNVEEAEDGVDALNKLQAGGYGFVISDWNMPNMDGLELLKTI" + newline +
//      "              11111111111   11111  111   1111111        111111111111111     11111111" + newline +
//      "Chain 2:    1 SSSLKIASTQE---ARQYF--DTD---RVVVDAV--------GSDFTDVGAVIAMDY-----ETDVIDAA" + newline +
//      "" + newline +
//      "                  .    :    .    :    .    :    .    :    .    :    ." + newline +
//      "Chain 1:   73 RAAMSALPVLMVTAEAKKENIIAAAQAGASGYVVKPFT--AATLEEKLNKIFEKLGM" + newline +
//      "              11111111111111111 11111111 11111111111  111111111111 1111" + newline +
//      "Chain 2:   50 DATKFGIPVFAVTKDAQ-AISADELK-KIFHIIDLENKFDATVNAREIETAVNNYED" + newline +
//      "" + newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" + newline ;
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,true);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//         fail(msg);
//      }
//
//      // no point in testing flexible here, since it is identical...
//   }


	// speed up of junit tests
	//exact
//   public void test1buz1ali(){
//      String pdb1 = "1buz";
//      String chain1 = "A";
//      String pdb2 = "1ali";
//      String chain2 ="A";
//
//
//      String originalOutput ="Align 1buzA.pdb 116 with 1aliA.pdb 446" + newline +
//      "Twists 0 ini-len 64 ini-rmsd 5.32 opt-equ 80 opt-rmsd 3.50 chain-rmsd 5.32 Score 103.72 align-len 153 gaps 73 (47.71%)" +newline +
//      "P-value 2.97e-01 Afp-num 15578 Identity 4.58% Similarity 15.03%" +newline +
//      "Block  0 afp  8 score 103.72 rmsd  5.32 gap 55 (0.46%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:   23 HHTAETLKQKVTQSLEKDDIRHIVLNLEDLSF-------------MDSSGLGVILGRYKQIKQIGGEMVV" +newline +
//      "              11111111111111 111111111111 1111             1111111111111111111111111" +newline +
//      "Chain 2:  297 PTLAQMTDKAIELL-SKNEKGFFLQVEGASIDKQDHAANPCGQIGETVDLDEAVQRALEFAKKEGNTLVI" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:   80 CAISPAVKRLFDMSGL--------------------------------------FKIIRF--------EQ" +newline +
//      "              1111111                                               111           11" +newline +
//      "Chain 2:  366 VTADHAHASQIVAPDTKAPGLTQALNTKDGAVMVMSYGNSEEDSQENTGSQLRIAAYGPHAANVVGLTDQ" +newline +
//      "" +newline +
//      "                  .    :" +newline +
//      "Chain 1:  104 SEQQALLTLGVAS" +newline +
//      "              1111111111111" +newline +
//      "Chain 2:  436 TDLFYTMKAALGL" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" + newline ;
//
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,true);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//         fail(msg);
//      }
//
//   }

	// exact
	public void test1buz1aliFlexible(){

		String pdb1 = "1buz";
		String chain1 = "A";
		String pdb2 = "1ali";
		String chain2 ="A";

		String originalOutput ="Align 1buzA.pdb 116 with 1aliA.pdb 446" +newline +
		"Twists 1 ini-len 64 ini-rmsd 3.12 opt-equ 88 opt-rmsd 3.34 chain-rmsd 5.32 Score 103.72 align-len 199 gaps 111 (55.78%)" +newline +
		"P-value 3.26e-01 Afp-num 15578 Identity 3.52% Similarity 14.57%" +newline +
		"Block  0 afp  1 score 23.14 rmsd  0.76 gap 0 (0.00%)" +newline +
		"Block  1 afp  7 score 100.08 rmsd  3.32 gap 17 (0.23%)" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
		"Chain 1:    5 DMNVKESVLCIRLTGELDH---------------------------------HTAETLKQKVTQSLEKDD" +newline +
		"              1 11111111111111                                    222222222222222222" +newline +
		"Chain 2:  246 VTEANQQKPLLGLFADGNMPVRWLGPKATYHGNIDKPAVTCTPNPQRNDSVPTLAQMTDKAIELLSKNEK" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
		"Chain 1:   42 IRHIVLNLEDLS------------FMDSSGLGVILGRYKQIK-QIGGEMVVCAISPAVKRLFDMSGLFKI" +newline +
		"              222222222222            222222222222222222 2222222222222              " +newline +
		"Chain 2:  316 GFFLQVEGASIDKQDHAANPCGQIGETVDLDEAVQRALEFAKKEGNTLVIVTADHAHASQIVAPDTKAPG" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    ." +newline +
		"Chain 1:   99 I---------------------------------RFEQSE--------QQALLTLGVAS" +newline +
		"                                                22            222222 2222" +newline +
		"Chain 2:  386 LTQALNTKDGAVMVMSYGNSEEDSQENTGSQLRIAAYGPHAANVVGLTDQTDLFYTMKA" +newline +
		"" +newline +
		"Note: positions are from PDB; the numbers between alignments are block index" +newline ;

		String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,false);
		if (! result.equals("")){
			String msg = "the created alignment images are not identical! ";
			printMismatch(originalOutput,result);
			printFirstMismatch(result, originalOutput);
			fail(msg);
		}
	}


	// speed up of junit tests
	//exact
//   public void test4hhbs(){
//      String pdb1= "4hhb";
//      String pdb2 = "4hhb";
//      String chain1 = "A";
//      String chain2 = "B";
//
//      String originalOutput="Align 4hhbA.pdb 141 with 4hhbB.pdb 146" +newline +
//      "Twists 0 ini-len 128 ini-rmsd 1.36 opt-equ 139 opt-rmsd 1.49 chain-rmsd 1.36 Score 364.84 align-len 147 gaps 8 (5.44%)" +newline +
//      "P-value 0.00e+00 Afp-num 13309 Identity 40.82% Similarity 57.82%" +newline +
//      "Block  0 afp 16 score 364.84 rmsd  1.36 gap 17 (0.12%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:    1 VLSPADKTNVKAAWGKVGAHAGEYGAEALERMFLSFPTTKTYFPHFDL------SHGSAQVKGHGKKVAD" +newline +
//      "              11111111111111111  11111111111111111111111111111      1111111111111111" +newline +
//      "Chain 2:    2 HLTPEEKSAVTALWGKV--NVDEVGGEALGRLLVVYPWTQRFFESFGDLSTPDAVMGNPKVKAHGKKVLG" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:   65 ALTNAVAHVDDMPNALSALSDLHAHKLRVDPVNFKLLSHCLLVTLAAHLPAEFTPAVHASLDKFLASVST" +newline +
//      "              1111111111111111111111111111111111111111111111111111111111111111111111" +newline +
//      "Chain 2:   70 AFSDGLAHLDNLKGTFATLSELHCDKLHVDPENFRLLGNVLVCVLAHHFGKEFTPPVQAAYQKVVAGVAN" +newline +
//      "" +newline +
//      "                  ." +newline +
//      "Chain 1:  135 VLTSKYR" +newline +
//      "              1111111" +newline +
//      "Chain 2:  140 ALAHKYH" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" +newline ;
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,true);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//         fail(msg);
//      }
//   }

	// speed up of junit tests
	//exact
//   public void test4hhbsFlexible(){
//      String pdb1= "4hhb";
//      String pdb2 = "4hhb";
//      String chain1 = "A";
//      String chain2 = "B";
//
//      String originalOutput="Align 4hhbA.pdb 141 with 4hhbB.pdb 146" +newline +
//      "Twists 0 ini-len 128 ini-rmsd 1.36 opt-equ 139 opt-rmsd 1.49 chain-rmsd 1.36 Score 364.84 align-len 147 gaps 8 (5.44%)" +newline +
//      "P-value 0.00e+00 Afp-num 13309 Identity 40.82% Similarity 57.82%" +newline +
//      "Block  0 afp 16 score 364.84 rmsd  1.36 gap 17 (0.12%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:    1 VLSPADKTNVKAAWGKVGAHAGEYGAEALERMFLSFPTTKTYFPHFDL------SHGSAQVKGHGKKVAD" +newline +
//      "              11111111111111111  11111111111111111111111111111      1111111111111111" +newline +
//      "Chain 2:    2 HLTPEEKSAVTALWGKV--NVDEVGGEALGRLLVVYPWTQRFFESFGDLSTPDAVMGNPKVKAHGKKVLG" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:   65 ALTNAVAHVDDMPNALSALSDLHAHKLRVDPVNFKLLSHCLLVTLAAHLPAEFTPAVHASLDKFLASVST" +newline +
//      "              1111111111111111111111111111111111111111111111111111111111111111111111" +newline +
//      "Chain 2:   70 AFSDGLAHLDNLKGTFATLSELHCDKLHVDPENFRLLGNVLVCVLAHHFGKEFTPPVQAAYQKVVAGVAN" +newline +
//      "" +newline +
//      "                  ." +newline +
//      "Chain 1:  135 VLTSKYR" +newline +
//      "              1111111" +newline +
//      "Chain 2:  140 ALAHKYH" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" +newline ;
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,false);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//         fail(msg);
//      }
//   }
//




	public void test1a641hngFlexible(){
		String pdb1 = "1a64";
		String chain1 = "A";
		String pdb2 = "1hng";
		String chain2 ="B";

		String originalOutput="Align 1a64A.pdb 94 with 1hngB.pdb 175" +newline +
		"Twists 1 ini-len 88 ini-rmsd 1.84 opt-equ 94 opt-rmsd 0.64 chain-rmsd 20.77 Score 235.94 align-len 96 gaps 2 (2.08%)" +newline +
		"P-value 4.23e-13 Afp-num 6497 Identity 96.88% Similarity 97.92%" +newline +
		"Block  0 afp  5 score 118.80 rmsd  0.75 gap 0 (0.00%)" +newline +
		"Block  1 afp  6 score 143.14 rmsd  0.46 gap 0 (0.00%)" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
		"Chain 1:    4 GTVWGALGHGINLNIPNFQMTDDIDEVRWERGSTLVAEFKR--KPFLKSGAFEILANGDLKIKNLTRDDS" +newline +
		"              11111111111111111111111111111111111111111  222222222222222222222222222" +newline +
		"Chain 2:    4 GTVWGALGHGINLNIPNFQMTDDIDEVRWERGSTLVAEFKRKMKPFLKSGAFEILANGDLKIKNLTRDDS" +newline +
		"" +newline +
		"                  .    :    .    :    ." +newline +
		"Chain 1:   74 GTYNVTVYSTNGTRILDKALDLRILE" +newline +
		"              22222222222222222222222222" +newline +
		"Chain 2:   74 GTYNVTVYSTNGTRILNKALDLRILE" +newline +
		"" +newline +
		"Note: positions are from PDB; the numbers between alignments are block index" +newline ;
		String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,false);
		if (! result.equals("")){
			String msg = "the created alignment images are not identical! ";
			printMismatch(originalOutput,result);
			printFirstMismatch(result, originalOutput);
			fail(msg);
		}

	}

	// disabled since so slow
	// 100% identical
//   public void test1nbw1kidFlexible(){
//      String pdb1 = "1nbw";
//      String chain1 = "A";
//      String pdb2 = "1kid";
//      String chain2 ="A";
//
//      String originalOutput="Align 1nbwA.pdb 606 with 1kidA.pdb 193" +newline +
//      "Twists 5 ini-len 120 ini-rmsd 5.60 opt-equ 155 opt-rmsd 3.58 chain-rmsd 21.86 Score 133.98 align-len 248 gaps 93 (37.50%)" +newline +
//      "P-value 6.48e-01 Afp-num 37019 Identity 5.65% Similarity 18.55%" +newline +
//      "Block  0 afp  6 score 68.26 rmsd  4.20 gap 13 (0.21%)" +newline +
//      "Block  1 afp  2 score 42.05 rmsd  1.96 gap 1 (0.06%)" +newline +
//      "Block  2 afp  1 score 22.05 rmsd  1.14 gap 0 (0.00%)" +newline +
//      "Block  3 afp  2 score 40.82 rmsd  2.48 gap 0 (0.00%)" +newline +
//      "Block  4 afp  2 score 40.27 rmsd  2.24 gap 0 (0.00%)" +newline +
//      "Block  5 afp  2 score 47.60 rmsd  0.60 gap 0 (0.00%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:   93 TESTMIGHNPQTPGGVG-------VGVGTTIALGRLATLPAAQYAEGWIVLIDDAVDFLDAVWWLNEALD" +newline +
//      "              1 111111111111111       1111                  111111111111111111111111" +newline +
//      "Chain 2:  190 SEGMQFDRGYLSPYFINKPETGAVELES------------------PFILLADKKISNIREMLPVLEAVA" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  156 RGINVVAAILKKDD--GVLVNNRLR---KTLPVVDEVTLLEQVPEGVMAAVEVAAPGQVVRILSNPYGIA" +newline +
//      "              11111111111111  111111111   1111111                                222" +newline +
//      "Chain 2:  242 KAGKPLLIIAEDVEGEALATLVVNTMRGIVKVAAV--------------------------------KAP" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  221 TFFGLSPEETQAIVPIARALIGNRSAVVLKTPQGDVQSRVIPA-----GNLYISGEKRRGEADVAEGAEA" +newline +
//      "                  22222222222222222    33333333               444444444444444  55555" +newline +
//      "Chain 2:  280 ----GFGDRRKAMLQDIATLT----GGTVISEEIGMELEKATLEDLGQAKRVVINKDTTTIIDGVGEEAA" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    ." +newline +
//      "Chain 1:  286 IMQAMSACAPVRDIRGEPGTHAGGMLERVRKVMASLTG" +newline +
//      "              555555555555     666666666666666666666" +newline +
//      "Chain 2:  342 IQGRVAQIRQQIEE---ATSDYDREKLQERVAKLAGGV" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" +newline;
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,false);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//
//         fail(msg);
//      }
//   }

	// 100% identical
//   public void test1cdg8tim(){
//
//      String pdb1 = "1cdg";
//      String chain1 = "A";
//      String pdb2 = "8tim";
//      String chain2 ="A";
//
//      String originalOutput ="Align 1cdgA.pdb 686 with 8timA.pdb 247" +newline +
//      "Twists 0 ini-len 128 ini-rmsd 8.15 opt-equ 159 opt-rmsd 4.72 chain-rmsd 8.15 Score 185.44 align-len 238 gaps 79 (33.19%)" +newline +
//      "P-value 1.38e-01 Afp-num 50059 Identity 5.46% Similarity 13.87%" +newline +
//      "Block  0 afp 16 score 185.44 rmsd  8.15 gap 121 (0.49%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  193 NLYDLADLNHNNSTVDVYLKDAIKMWLDLGIDGIRMDA---VKHMPFGWQKSFMAAVNNYKPVFTFGEWF" +newline +
//      "              11111111          1  111111  111111111   111111111  111         111111" +newline +
//      "Chain 2:   16 GDKKSLGELI--------HTLNGAKLS--ADTEVVCGAPSIYLDFARQKL--DAK---------IGVAAQ" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  260 LGV---------NEVSPENHKFANESGMSLLDFRFAQKVRQVFRDNTDNMYGLKAMLEGSAADYAQVDDQ" +newline +
//      "              111         11111111111     111111111 11   1111111111111111111111   11" +newline +
//      "Chain 2:   65 NCYKVPKGAFTGEISPAMIKDIG-----AAWVILGHSERR---HVFGESDELIGQKVAHALAEGL---GV" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  321 VTFIDNHDMERFHASNANRRKLEQALAFTLTS---------RGVPAIYYGTEQYMSGGTDPDNRARIPSF" +newline +
//      "              11111      111111111111111111111         111111   11111111      111111" +newline +
//      "Chain 2:  124 IACIG------EKLDEREAGITEKVVFEQTKAIADNVKDWSKVVLAY---EPVWAIGT------GKTATP" +newline +
//      "" +newline +
//      "                  .    :    .    :    ." +newline +
//      "Chain 1:  382 STSTTAYQVIQKLAPLRK---CNPAIAY" +newline +
//      "              11   1111111111111   1111111" +newline +
//      "Chain 2:  179 QQ---AQEVHEKLRGWLKTHVSDAVAQS" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" +newline ;
//
//
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,true);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//
//         fail(msg);
//      }
//   }


	// 100% identical
//   public void test1cdg8timFlexible(){
//
//      String pdb1 = "1cdg";
//      String chain1 = "A";
//      String pdb2 = "8tim";
//      String chain2 ="A";
//
//      String originalOutput ="Align 1cdgA.pdb 686 with 8timA.pdb 247" +newline +
//      "Twists 3 ini-len 112 ini-rmsd 3.95 opt-equ 149 opt-rmsd 3.85 chain-rmsd 8.15 Score 185.44 align-len 255 gaps 106 (41.57%)" +newline +
//      "P-value 3.52e-01 Afp-num 50059 Identity 7.45% Similarity 18.82%" +newline +
//      "Block  0 afp  4 score 72.41 rmsd  2.94 gap 28 (0.47%)" +newline +
//      "Block  1 afp  2 score 26.63 rmsd  2.67 gap 1 (0.06%)" +newline +
//      "Block  2 afp  5 score 86.03 rmsd  4.72 gap 24 (0.38%)" +newline +
//      "Block  3 afp  3 score 49.73 rmsd  4.26 gap 28 (0.54%)" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  223 IDGIRMDAVKHMPFGWQKSFMAAVNNYKP----VFTFGEWFLGVNEV-----------------------" +newline +
//      "              11111111111111111111111111111    111111111                            " +newline +
//      "Chain 2:    5 KFFVGGNWKMNGDKKSLGELIHTLNGAKLSADTEVVCGAPSIYLDFARQKLDAKIGVAAQNCYKVPKGAF" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  266 -SPENHKFANESGMSLLDFRFAQKVRQVFRDNTDNMYGLKAMLEGSAADYAQVDDQVTFIDNHDMERFHA" +newline +
//      "               2222222222222222222    333333333333333333333333333   333333       333" +newline +
//      "Chain 2:   75 TGEISPAMIKDIGAAWVILG----HSERRHVFGESDELIGQKVAHALAEGL---GVIACI-------GEK" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
//      "Chain 1:  335 SNANR--RKLEQALAFTLTSR--------GVPAIYYGTEQYMSGGTDPDNRARIPSFSTSTTAYQVIQKL" +newline +
//      "              33333  33333333333333        333333                       444444444444" +newline +
//      "Chain 2:  131 LDEREAGITEKVVFEQTKAIADNVKDWSKVVLAYEPVWAIGTGKTA------------TPQQAQEVHEKL" +newline +
//      "" +newline +
//      "                  .    :    .    :    .    :    .    :    ." +newline +
//      "Chain 1:  395 APLRKCNPAIAYGSTQERWINNDVLIYERKFGSNVAVVAVNRNLN" +newline +
//      "              4444444444444 4                         44444" +newline +
//      "Chain 2:  189 RGWLKTHVSDAVAQSTRIIYGGSVTGGNCKELASQHDVDGFLVGG" +newline +
//      "" +newline +
//      "Note: positions are from PDB; the numbers between alignments are block index" +newline ;
//
//
//      String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,false);
//      if (! result.equals("")){
//         String msg = "the created alignment images are not identical! ";
//         printMismatch(originalOutput,result);
//         printFirstMismatch(result, originalOutput);
//
//         fail(msg);
//      }
//   }


	//exact
	public void test1a211hwgFlexible(){

		String pdb1 = "1a21";
		String chain1 = "A";
		String pdb2 = "1hwg";
		String chain2 ="C";

		String originalOutput="Align 1a21A.pdb 194 with 1hwgC.pdb 191" +newline +
		"Twists 1 ini-len 120 ini-rmsd 3.04 opt-equ 150 opt-rmsd 2.96 chain-rmsd 4.21 Score 233.34 align-len 210 gaps 60 (28.57%)" +newline +
		"P-value 1.15e-05 Afp-num 12696 Identity 9.52% Similarity 19.05%" +newline +
		"Block  0 afp  4 score 66.42 rmsd  2.03 gap 6 (0.16%)" +newline +
		"Block  1 afp 11 score 184.29 rmsd  3.24 gap 69 (0.44%)" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
		"Chain 1:    6 RAYNLTWKSTN-FKTILEWEPKSIDHVYTVQISTRLENWKSKCFLTAE---TECDLTDEVVKDVGQTYMA" +newline +
		"              11111111111 111111111     111111111111111111       222222222   222222 " +newline +
		"Chain 2:   32 EPKFTKCRSPERETFSCHWTD-----PIQLFYTRRNQEWKECPDYVSAGENSCYFNSSFT---SIWIPYC" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
		"Chain 1:   72 RVLSYPARNTTGFPEEPPFRNSPEFTPYLDTNLGQPTIQSFEQVG-------TKLNVTVQDARTLVTFLS" +newline +
		"                                    22222222222222222222222       222222222222   222" +newline +
		"Chain 2:  109 IKLTSNGGTVDE----------KCFSVDEIVQPDPPIALNWTLLNVSLTGIHADIQVRWEAPRN---ADI" +newline +
		"" +newline +
		"                  .    :    .    :    .    :    .    :    .    :    .    :    .    :" +newline +
		"Chain 1:  141 LRAVFGKDLNYTLYYWR-----KKTAT-TNTNEFLIDVDKGE-NYCFSVQAVIPSRKRKQRSPESLTECT" +newline +
		"              222222  222222222     22222 22222222222222 2222222222222  222222222222" +newline +
		"Chain 2:  166 QKGWMV--LEYELQYKEVNETKWKMMDPILTTSVPVYSLKVDKEYEVRVRSKQRNS--GNYGEFSEVLYV" +newline +
		"" +newline +
		"Note: positions are from PDB; the numbers between alignments are block index" +newline;

		String result = MyTestHelper.compareAlignment(pdb1, chain1, pdb2, chain2, originalOutput,false);
		if (! result.equals("")){
			String msg = "the created alignment images are not identical! ";
			printMismatch(originalOutput,result);
			printFirstMismatch(result, originalOutput);

			fail(msg);
		}
	}

}
