%% @hidden
%% -*- coding: utf-8 -*-
%% @private
%% Automatically generated, do not edit
%% Generated by gpb_compile version 4.6.0
-module(prometheus_model).

-export([encode_msg/1, encode_msg/2, encode_msg/3]).
-export([decode_msg/2, decode_msg/3]).
-export([merge_msgs/2, merge_msgs/3, merge_msgs/4]).
-export([verify_msg/1, verify_msg/2, verify_msg/3]).
-export([get_msg_defs/0]).
-export([get_msg_names/0]).
-export([get_group_names/0]).
-export([get_msg_or_group_names/0]).
-export([get_enum_names/0]).
-export([find_msg_def/1, fetch_msg_def/1]).
-export([find_enum_def/1, fetch_enum_def/1]).
-export([enum_symbol_by_value/2, enum_value_by_symbol/2]).
-export([enum_symbol_by_value_MetricType/1, enum_value_by_symbol_MetricType/1]).
-export([get_service_names/0]).
-export([get_service_def/1]).
-export([get_rpc_names/1]).
-export([find_rpc_def/2, fetch_rpc_def/2]).
-export([fqbin_to_service_name/1]).
-export([service_name_to_fqbin/1]).
-export([fqbins_to_service_and_rpc_name/2]).
-export([service_and_rpc_name_to_fqbins/2]).
-export([get_package_name/0]).
-export([uses_packages/0]).
-export([source_basename/0]).
-export([gpb_version_as_string/0, gpb_version_as_list/0]).

-include("prometheus_model.hrl").

%% enumerated types
-type 'MetricType'() :: 'COUNTER' | 'GAUGE' | 'SUMMARY' | 'UNTYPED' | 'HISTOGRAM'.
-export_type(['MetricType'/0]).

%% message types
-type 'LabelPair'() :: #'LabelPair'{}.

-type 'Gauge'() :: #'Gauge'{}.

-type 'Counter'() :: #'Counter'{}.

-type 'Quantile'() :: #'Quantile'{}.

-type 'Summary'() :: #'Summary'{}.

-type 'Untyped'() :: #'Untyped'{}.

-type 'Histogram'() :: #'Histogram'{}.

-type 'Bucket'() :: #'Bucket'{}.

-type 'Metric'() :: #'Metric'{}.

-type 'MetricFamily'() :: #'MetricFamily'{}.

-export_type(['LabelPair'/0, 'Gauge'/0, 'Counter'/0, 'Quantile'/0, 'Summary'/0, 'Untyped'/0, 'Histogram'/0, 'Bucket'/0, 'Metric'/0, 'MetricFamily'/0]).

-spec encode_msg(#'LabelPair'{} | #'Gauge'{} | #'Counter'{} | #'Quantile'{} | #'Summary'{} | #'Untyped'{} | #'Histogram'{} | #'Bucket'{} | #'Metric'{} | #'MetricFamily'{}) -> binary().
encode_msg(Msg) when tuple_size(Msg) >= 1 ->
    encode_msg(Msg, element(1, Msg), []).

-spec encode_msg(#'LabelPair'{} | #'Gauge'{} | #'Counter'{} | #'Quantile'{} | #'Summary'{} | #'Untyped'{} | #'Histogram'{} | #'Bucket'{} | #'Metric'{} | #'MetricFamily'{}, atom() | list()) -> binary().
encode_msg(Msg, MsgName) when is_atom(MsgName) ->
    encode_msg(Msg, MsgName, []);
encode_msg(Msg, Opts)
    when tuple_size(Msg) >= 1, is_list(Opts) ->
    encode_msg(Msg, element(1, Msg), Opts).

-spec encode_msg(#'LabelPair'{} | #'Gauge'{} | #'Counter'{} | #'Quantile'{} | #'Summary'{} | #'Untyped'{} | #'Histogram'{} | #'Bucket'{} | #'Metric'{} | #'MetricFamily'{}, atom(), list()) -> binary().
encode_msg(Msg, MsgName, Opts) ->
    case proplists:get_bool(verify, Opts) of
      true -> verify_msg(Msg, MsgName, Opts);
      false -> ok
    end,
    TrUserData = proplists:get_value(user_data, Opts),
    case MsgName of
      'LabelPair' ->
	  encode_msg_LabelPair(id(Msg, TrUserData), TrUserData);
      'Gauge' ->
	  encode_msg_Gauge(id(Msg, TrUserData), TrUserData);
      'Counter' ->
	  encode_msg_Counter(id(Msg, TrUserData), TrUserData);
      'Quantile' ->
	  encode_msg_Quantile(id(Msg, TrUserData), TrUserData);
      'Summary' ->
	  encode_msg_Summary(id(Msg, TrUserData), TrUserData);
      'Untyped' ->
	  encode_msg_Untyped(id(Msg, TrUserData), TrUserData);
      'Histogram' ->
	  encode_msg_Histogram(id(Msg, TrUserData), TrUserData);
      'Bucket' ->
	  encode_msg_Bucket(id(Msg, TrUserData), TrUserData);
      'Metric' ->
	  encode_msg_Metric(id(Msg, TrUserData), TrUserData);
      'MetricFamily' ->
	  encode_msg_MetricFamily(id(Msg, TrUserData), TrUserData)
    end.


encode_msg_LabelPair(Msg, TrUserData) ->
    encode_msg_LabelPair(Msg, <<>>, TrUserData).


encode_msg_LabelPair(#'LabelPair'{name = F1,
				  value = F2},
		     Bin, TrUserData) ->
    B1 = if F1 == undefined -> Bin;
	    true ->
		begin
		  TrF1 = id(F1, TrUserData),
		  e_type_string(TrF1, <<Bin/binary, 10>>, TrUserData)
		end
	 end,
    if F2 == undefined -> B1;
       true ->
	   begin
	     TrF2 = id(F2, TrUserData),
	     e_type_string(TrF2, <<B1/binary, 18>>, TrUserData)
	   end
    end.

encode_msg_Gauge(Msg, TrUserData) ->
    encode_msg_Gauge(Msg, <<>>, TrUserData).


encode_msg_Gauge(#'Gauge'{value = F1}, Bin,
		 TrUserData) ->
    if F1 == undefined -> Bin;
       true ->
	   begin
	     TrF1 = id(F1, TrUserData),
	     e_type_double(TrF1, <<Bin/binary, 9>>, TrUserData)
	   end
    end.

encode_msg_Counter(Msg, TrUserData) ->
    encode_msg_Counter(Msg, <<>>, TrUserData).


encode_msg_Counter(#'Counter'{value = F1}, Bin,
		   TrUserData) ->
    if F1 == undefined -> Bin;
       true ->
	   begin
	     TrF1 = id(F1, TrUserData),
	     e_type_double(TrF1, <<Bin/binary, 9>>, TrUserData)
	   end
    end.

encode_msg_Quantile(Msg, TrUserData) ->
    encode_msg_Quantile(Msg, <<>>, TrUserData).


encode_msg_Quantile(#'Quantile'{quantile = F1,
				value = F2},
		    Bin, TrUserData) ->
    B1 = if F1 == undefined -> Bin;
	    true ->
		begin
		  TrF1 = id(F1, TrUserData),
		  e_type_double(TrF1, <<Bin/binary, 9>>, TrUserData)
		end
	 end,
    if F2 == undefined -> B1;
       true ->
	   begin
	     TrF2 = id(F2, TrUserData),
	     e_type_double(TrF2, <<B1/binary, 17>>, TrUserData)
	   end
    end.

encode_msg_Summary(Msg, TrUserData) ->
    encode_msg_Summary(Msg, <<>>, TrUserData).


encode_msg_Summary(#'Summary'{sample_count = F1,
			      sample_sum = F2, quantile = F3},
		   Bin, TrUserData) ->
    B1 = if F1 == undefined -> Bin;
	    true ->
		begin
		  TrF1 = id(F1, TrUserData),
		  e_varint(TrF1, <<Bin/binary, 8>>, TrUserData)
		end
	 end,
    B2 = if F2 == undefined -> B1;
	    true ->
		begin
		  TrF2 = id(F2, TrUserData),
		  e_type_double(TrF2, <<B1/binary, 17>>, TrUserData)
		end
	 end,
    begin
      TrF3 = id(F3, TrUserData),
      if TrF3 == [] -> B2;
	 true -> e_field_Summary_quantile(TrF3, B2, TrUserData)
      end
    end.

encode_msg_Untyped(Msg, TrUserData) ->
    encode_msg_Untyped(Msg, <<>>, TrUserData).


encode_msg_Untyped(#'Untyped'{value = F1}, Bin,
		   TrUserData) ->
    if F1 == undefined -> Bin;
       true ->
	   begin
	     TrF1 = id(F1, TrUserData),
	     e_type_double(TrF1, <<Bin/binary, 9>>, TrUserData)
	   end
    end.

encode_msg_Histogram(Msg, TrUserData) ->
    encode_msg_Histogram(Msg, <<>>, TrUserData).


encode_msg_Histogram(#'Histogram'{sample_count = F1,
				  sample_sum = F2, bucket = F3},
		     Bin, TrUserData) ->
    B1 = if F1 == undefined -> Bin;
	    true ->
		begin
		  TrF1 = id(F1, TrUserData),
		  e_varint(TrF1, <<Bin/binary, 8>>, TrUserData)
		end
	 end,
    B2 = if F2 == undefined -> B1;
	    true ->
		begin
		  TrF2 = id(F2, TrUserData),
		  e_type_double(TrF2, <<B1/binary, 17>>, TrUserData)
		end
	 end,
    begin
      TrF3 = id(F3, TrUserData),
      if TrF3 == [] -> B2;
	 true -> e_field_Histogram_bucket(TrF3, B2, TrUserData)
      end
    end.

encode_msg_Bucket(Msg, TrUserData) ->
    encode_msg_Bucket(Msg, <<>>, TrUserData).


encode_msg_Bucket(#'Bucket'{cumulative_count = F1,
			    upper_bound = F2},
		  Bin, TrUserData) ->
    B1 = if F1 == undefined -> Bin;
	    true ->
		begin
		  TrF1 = id(F1, TrUserData),
		  e_varint(TrF1, <<Bin/binary, 8>>, TrUserData)
		end
	 end,
    if F2 == undefined -> B1;
       true ->
	   begin
	     TrF2 = id(F2, TrUserData),
	     e_type_double(TrF2, <<B1/binary, 17>>, TrUserData)
	   end
    end.

encode_msg_Metric(Msg, TrUserData) ->
    encode_msg_Metric(Msg, <<>>, TrUserData).


encode_msg_Metric(#'Metric'{label = F1, gauge = F2,
			    counter = F3, summary = F4, untyped = F5,
			    histogram = F6, timestamp_ms = F7},
		  Bin, TrUserData) ->
    B1 = begin
	   TrF1 = id(F1, TrUserData),
	   if TrF1 == [] -> Bin;
	      true -> e_field_Metric_label(TrF1, Bin, TrUserData)
	   end
	 end,
    B2 = if F2 == undefined -> B1;
	    true ->
		begin
		  TrF2 = id(F2, TrUserData),
		  e_mfield_Metric_gauge(TrF2, <<B1/binary, 18>>,
					TrUserData)
		end
	 end,
    B3 = if F3 == undefined -> B2;
	    true ->
		begin
		  TrF3 = id(F3, TrUserData),
		  e_mfield_Metric_counter(TrF3, <<B2/binary, 26>>,
					  TrUserData)
		end
	 end,
    B4 = if F4 == undefined -> B3;
	    true ->
		begin
		  TrF4 = id(F4, TrUserData),
		  e_mfield_Metric_summary(TrF4, <<B3/binary, 34>>,
					  TrUserData)
		end
	 end,
    B5 = if F5 == undefined -> B4;
	    true ->
		begin
		  TrF5 = id(F5, TrUserData),
		  e_mfield_Metric_untyped(TrF5, <<B4/binary, 42>>,
					  TrUserData)
		end
	 end,
    B6 = if F6 == undefined -> B5;
	    true ->
		begin
		  TrF6 = id(F6, TrUserData),
		  e_mfield_Metric_histogram(TrF6, <<B5/binary, 58>>,
					    TrUserData)
		end
	 end,
    if F7 == undefined -> B6;
       true ->
	   begin
	     TrF7 = id(F7, TrUserData),
	     e_type_int64(TrF7, <<B6/binary, 48>>, TrUserData)
	   end
    end.

encode_msg_MetricFamily(Msg, TrUserData) ->
    encode_msg_MetricFamily(Msg, <<>>, TrUserData).


encode_msg_MetricFamily(#'MetricFamily'{name = F1,
					help = F2, type = F3, metric = F4},
			Bin, TrUserData) ->
    B1 = if F1 == undefined -> Bin;
	    true ->
		begin
		  TrF1 = id(F1, TrUserData),
		  e_type_string(TrF1, <<Bin/binary, 10>>, TrUserData)
		end
	 end,
    B2 = if F2 == undefined -> B1;
	    true ->
		begin
		  TrF2 = id(F2, TrUserData),
		  e_type_string(TrF2, <<B1/binary, 18>>, TrUserData)
		end
	 end,
    B3 = if F3 == undefined -> B2;
	    true ->
		begin
		  TrF3 = id(F3, TrUserData),
		  e_enum_MetricType(TrF3, <<B2/binary, 24>>, TrUserData)
		end
	 end,
    begin
      TrF4 = id(F4, TrUserData),
      if TrF4 == [] -> B3;
	 true ->
	     e_field_MetricFamily_metric(TrF4, B3, TrUserData)
      end
    end.

e_mfield_Summary_quantile(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Quantile(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_field_Summary_quantile([Elem | Rest], Bin,
			 TrUserData) ->
    Bin2 = <<Bin/binary, 26>>,
    Bin3 = e_mfield_Summary_quantile(id(Elem, TrUserData),
				     Bin2, TrUserData),
    e_field_Summary_quantile(Rest, Bin3, TrUserData);
e_field_Summary_quantile([], Bin, _TrUserData) -> Bin.

e_mfield_Histogram_bucket(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Bucket(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_field_Histogram_bucket([Elem | Rest], Bin,
			 TrUserData) ->
    Bin2 = <<Bin/binary, 26>>,
    Bin3 = e_mfield_Histogram_bucket(id(Elem, TrUserData),
				     Bin2, TrUserData),
    e_field_Histogram_bucket(Rest, Bin3, TrUserData);
e_field_Histogram_bucket([], Bin, _TrUserData) -> Bin.

e_mfield_Metric_label(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_LabelPair(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_field_Metric_label([Elem | Rest], Bin, TrUserData) ->
    Bin2 = <<Bin/binary, 10>>,
    Bin3 = e_mfield_Metric_label(id(Elem, TrUserData), Bin2,
				 TrUserData),
    e_field_Metric_label(Rest, Bin3, TrUserData);
e_field_Metric_label([], Bin, _TrUserData) -> Bin.

e_mfield_Metric_gauge(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Gauge(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_mfield_Metric_counter(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Counter(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_mfield_Metric_summary(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Summary(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_mfield_Metric_untyped(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Untyped(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_mfield_Metric_histogram(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Histogram(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_mfield_MetricFamily_metric(Msg, Bin, TrUserData) ->
    SubBin = encode_msg_Metric(Msg, <<>>, TrUserData),
    Bin2 = e_varint(byte_size(SubBin), Bin),
    <<Bin2/binary, SubBin/binary>>.

e_field_MetricFamily_metric([Elem | Rest], Bin,
			    TrUserData) ->
    Bin2 = <<Bin/binary, 34>>,
    Bin3 = e_mfield_MetricFamily_metric(id(Elem,
					   TrUserData),
					Bin2, TrUserData),
    e_field_MetricFamily_metric(Rest, Bin3, TrUserData);
e_field_MetricFamily_metric([], Bin, _TrUserData) ->
    Bin.

e_enum_MetricType('COUNTER', Bin, _TrUserData) ->
    <<Bin/binary, 0>>;
e_enum_MetricType('GAUGE', Bin, _TrUserData) ->
    <<Bin/binary, 1>>;
e_enum_MetricType('SUMMARY', Bin, _TrUserData) ->
    <<Bin/binary, 2>>;
e_enum_MetricType('UNTYPED', Bin, _TrUserData) ->
    <<Bin/binary, 3>>;
e_enum_MetricType('HISTOGRAM', Bin, _TrUserData) ->
    <<Bin/binary, 4>>;
e_enum_MetricType(V, Bin, _TrUserData) ->
    e_varint(V, Bin).

-compile({nowarn_unused_function,e_type_sint/3}).
e_type_sint(Value, Bin, _TrUserData) when Value >= 0 ->
    e_varint(Value * 2, Bin);
e_type_sint(Value, Bin, _TrUserData) ->
    e_varint(Value * -2 - 1, Bin).

-compile({nowarn_unused_function,e_type_int32/3}).
e_type_int32(Value, Bin, _TrUserData)
    when 0 =< Value, Value =< 127 ->
    <<Bin/binary, Value>>;
e_type_int32(Value, Bin, _TrUserData) ->
    <<N:64/unsigned-native>> = <<Value:64/signed-native>>,
    e_varint(N, Bin).

-compile({nowarn_unused_function,e_type_int64/3}).
e_type_int64(Value, Bin, _TrUserData)
    when 0 =< Value, Value =< 127 ->
    <<Bin/binary, Value>>;
e_type_int64(Value, Bin, _TrUserData) ->
    <<N:64/unsigned-native>> = <<Value:64/signed-native>>,
    e_varint(N, Bin).

-compile({nowarn_unused_function,e_type_bool/3}).
e_type_bool(true, Bin, _TrUserData) ->
    <<Bin/binary, 1>>;
e_type_bool(false, Bin, _TrUserData) ->
    <<Bin/binary, 0>>;
e_type_bool(1, Bin, _TrUserData) -> <<Bin/binary, 1>>;
e_type_bool(0, Bin, _TrUserData) -> <<Bin/binary, 0>>.

-compile({nowarn_unused_function,e_type_string/3}).
e_type_string(S, Bin, _TrUserData) ->
    Utf8 = unicode:characters_to_binary(S),
    Bin2 = e_varint(byte_size(Utf8), Bin),
    <<Bin2/binary, Utf8/binary>>.

-compile({nowarn_unused_function,e_type_bytes/3}).
e_type_bytes(Bytes, Bin, _TrUserData)
    when is_binary(Bytes) ->
    Bin2 = e_varint(byte_size(Bytes), Bin),
    <<Bin2/binary, Bytes/binary>>;
e_type_bytes(Bytes, Bin, _TrUserData)
    when is_list(Bytes) ->
    BytesBin = iolist_to_binary(Bytes),
    Bin2 = e_varint(byte_size(BytesBin), Bin),
    <<Bin2/binary, BytesBin/binary>>.

-compile({nowarn_unused_function,e_type_fixed32/3}).
e_type_fixed32(Value, Bin, _TrUserData) ->
    <<Bin/binary, Value:32/little>>.

-compile({nowarn_unused_function,e_type_sfixed32/3}).
e_type_sfixed32(Value, Bin, _TrUserData) ->
    <<Bin/binary, Value:32/little-signed>>.

-compile({nowarn_unused_function,e_type_fixed64/3}).
e_type_fixed64(Value, Bin, _TrUserData) ->
    <<Bin/binary, Value:64/little>>.

-compile({nowarn_unused_function,e_type_sfixed64/3}).
e_type_sfixed64(Value, Bin, _TrUserData) ->
    <<Bin/binary, Value:64/little-signed>>.

-compile({nowarn_unused_function,e_type_float/3}).
e_type_float(V, Bin, _) when is_number(V) ->
    <<Bin/binary, V:32/little-float>>;
e_type_float(infinity, Bin, _) ->
    <<Bin/binary, 0:16, 128, 127>>;
e_type_float('-infinity', Bin, _) ->
    <<Bin/binary, 0:16, 128, 255>>;
e_type_float(nan, Bin, _) ->
    <<Bin/binary, 0:16, 192, 127>>.

-compile({nowarn_unused_function,e_type_double/3}).
e_type_double(V, Bin, _) when is_number(V) ->
    <<Bin/binary, V:64/little-float>>;
e_type_double(infinity, Bin, _) ->
    <<Bin/binary, 0:48, 240, 127>>;
e_type_double('-infinity', Bin, _) ->
    <<Bin/binary, 0:48, 240, 255>>;
e_type_double(nan, Bin, _) ->
    <<Bin/binary, 0:48, 248, 127>>.

-compile({nowarn_unused_function,e_varint/3}).
e_varint(N, Bin, _TrUserData) -> e_varint(N, Bin).

-compile({nowarn_unused_function,e_varint/2}).
e_varint(N, Bin) when N =< 127 -> <<Bin/binary, N>>;
e_varint(N, Bin) ->
    Bin2 = <<Bin/binary, (N band 127 bor 128)>>,
    e_varint(N bsr 7, Bin2).


decode_msg(Bin, MsgName) when is_binary(Bin) ->
    decode_msg(Bin, MsgName, []).

decode_msg(Bin, MsgName, Opts) when is_binary(Bin) ->
    TrUserData = proplists:get_value(user_data, Opts),
    decode_msg_1_catch(Bin, MsgName, TrUserData).

-ifdef('OTP_RELEASE').
decode_msg_1_catch(Bin, MsgName, TrUserData) ->
    try decode_msg_2_doit(MsgName, Bin, TrUserData)
    catch Class:Reason:StackTrace -> error({gpb_error,{decoding_failure, {Bin, MsgName, {Class, Reason, StackTrace}}}})
    end.
-else.
decode_msg_1_catch(Bin, MsgName, TrUserData) ->
    try decode_msg_2_doit(MsgName, Bin, TrUserData)
    catch Class:Reason ->
        StackTrace = erlang:get_stacktrace(),
        error({gpb_error,{decoding_failure, {Bin, MsgName, {Class, Reason, StackTrace}}}})
    end.
-endif.

decode_msg_2_doit('LabelPair', Bin, TrUserData) ->
    id(decode_msg_LabelPair(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Gauge', Bin, TrUserData) ->
    id(decode_msg_Gauge(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Counter', Bin, TrUserData) ->
    id(decode_msg_Counter(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Quantile', Bin, TrUserData) ->
    id(decode_msg_Quantile(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Summary', Bin, TrUserData) ->
    id(decode_msg_Summary(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Untyped', Bin, TrUserData) ->
    id(decode_msg_Untyped(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Histogram', Bin, TrUserData) ->
    id(decode_msg_Histogram(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Bucket', Bin, TrUserData) ->
    id(decode_msg_Bucket(Bin, TrUserData), TrUserData);
decode_msg_2_doit('Metric', Bin, TrUserData) ->
    id(decode_msg_Metric(Bin, TrUserData), TrUserData);
decode_msg_2_doit('MetricFamily', Bin, TrUserData) ->
    id(decode_msg_MetricFamily(Bin, TrUserData),
       TrUserData).



decode_msg_LabelPair(Bin, TrUserData) ->
    dfp_read_field_def_LabelPair(Bin, 0, 0,
				 id(undefined, TrUserData),
				 id(undefined, TrUserData), TrUserData).

dfp_read_field_def_LabelPair(<<10, Rest/binary>>, Z1,
			     Z2, F@_1, F@_2, TrUserData) ->
    d_field_LabelPair_name(Rest, Z1, Z2, F@_1, F@_2,
			   TrUserData);
dfp_read_field_def_LabelPair(<<18, Rest/binary>>, Z1,
			     Z2, F@_1, F@_2, TrUserData) ->
    d_field_LabelPair_value(Rest, Z1, Z2, F@_1, F@_2,
			    TrUserData);
dfp_read_field_def_LabelPair(<<>>, 0, 0, F@_1, F@_2,
			     _) ->
    #'LabelPair'{name = F@_1, value = F@_2};
dfp_read_field_def_LabelPair(Other, Z1, Z2, F@_1, F@_2,
			     TrUserData) ->
    dg_read_field_def_LabelPair(Other, Z1, Z2, F@_1, F@_2,
				TrUserData).

dg_read_field_def_LabelPair(<<1:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_LabelPair(Rest, N + 7, X bsl N + Acc,
				F@_1, F@_2, TrUserData);
dg_read_field_def_LabelPair(<<0:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      10 ->
	  d_field_LabelPair_name(Rest, 0, 0, F@_1, F@_2,
				 TrUserData);
      18 ->
	  d_field_LabelPair_value(Rest, 0, 0, F@_1, F@_2,
				  TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_LabelPair(Rest, 0, 0, F@_1, F@_2,
				      TrUserData);
	    1 ->
		skip_64_LabelPair(Rest, 0, 0, F@_1, F@_2, TrUserData);
	    2 ->
		skip_length_delimited_LabelPair(Rest, 0, 0, F@_1, F@_2,
						TrUserData);
	    3 ->
		skip_group_LabelPair(Rest, Key bsr 3, 0, F@_1, F@_2,
				     TrUserData);
	    5 ->
		skip_32_LabelPair(Rest, 0, 0, F@_1, F@_2, TrUserData)
	  end
    end;
dg_read_field_def_LabelPair(<<>>, 0, 0, F@_1, F@_2,
			    _) ->
    #'LabelPair'{name = F@_1, value = F@_2}.

d_field_LabelPair_name(<<1:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, TrUserData)
    when N < 57 ->
    d_field_LabelPair_name(Rest, N + 7, X bsl N + Acc, F@_1,
			   F@_2, TrUserData);
d_field_LabelPair_name(<<0:1, X:7, Rest/binary>>, N,
		       Acc, _, F@_2, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bytes:Len/binary, Rest2/binary>> = Rest,
			   {id(binary:copy(Bytes), TrUserData), Rest2}
			 end,
    dfp_read_field_def_LabelPair(RestF, 0, 0, NewFValue,
				 F@_2, TrUserData).

d_field_LabelPair_value(<<1:1, X:7, Rest/binary>>, N,
			Acc, F@_1, F@_2, TrUserData)
    when N < 57 ->
    d_field_LabelPair_value(Rest, N + 7, X bsl N + Acc,
			    F@_1, F@_2, TrUserData);
d_field_LabelPair_value(<<0:1, X:7, Rest/binary>>, N,
			Acc, F@_1, _, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bytes:Len/binary, Rest2/binary>> = Rest,
			   {id(binary:copy(Bytes), TrUserData), Rest2}
			 end,
    dfp_read_field_def_LabelPair(RestF, 0, 0, F@_1,
				 NewFValue, TrUserData).

skip_varint_LabelPair(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		      F@_1, F@_2, TrUserData) ->
    skip_varint_LabelPair(Rest, Z1, Z2, F@_1, F@_2,
			  TrUserData);
skip_varint_LabelPair(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		      F@_1, F@_2, TrUserData) ->
    dfp_read_field_def_LabelPair(Rest, Z1, Z2, F@_1, F@_2,
				 TrUserData).

skip_length_delimited_LabelPair(<<1:1, X:7,
				  Rest/binary>>,
				N, Acc, F@_1, F@_2, TrUserData)
    when N < 57 ->
    skip_length_delimited_LabelPair(Rest, N + 7,
				    X bsl N + Acc, F@_1, F@_2, TrUserData);
skip_length_delimited_LabelPair(<<0:1, X:7,
				  Rest/binary>>,
				N, Acc, F@_1, F@_2, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_LabelPair(Rest2, 0, 0, F@_1, F@_2,
				 TrUserData).

skip_group_LabelPair(Bin, FNum, Z2, F@_1, F@_2,
		     TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_LabelPair(Rest, 0, Z2, F@_1, F@_2,
				 TrUserData).

skip_32_LabelPair(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
		  F@_2, TrUserData) ->
    dfp_read_field_def_LabelPair(Rest, Z1, Z2, F@_1, F@_2,
				 TrUserData).

skip_64_LabelPair(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
		  F@_2, TrUserData) ->
    dfp_read_field_def_LabelPair(Rest, Z1, Z2, F@_1, F@_2,
				 TrUserData).

decode_msg_Gauge(Bin, TrUserData) ->
    dfp_read_field_def_Gauge(Bin, 0, 0,
			     id(undefined, TrUserData), TrUserData).

dfp_read_field_def_Gauge(<<9, Rest/binary>>, Z1, Z2,
			 F@_1, TrUserData) ->
    d_field_Gauge_value(Rest, Z1, Z2, F@_1, TrUserData);
dfp_read_field_def_Gauge(<<>>, 0, 0, F@_1, _) ->
    #'Gauge'{value = F@_1};
dfp_read_field_def_Gauge(Other, Z1, Z2, F@_1,
			 TrUserData) ->
    dg_read_field_def_Gauge(Other, Z1, Z2, F@_1,
			    TrUserData).

dg_read_field_def_Gauge(<<1:1, X:7, Rest/binary>>, N,
			Acc, F@_1, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Gauge(Rest, N + 7, X bsl N + Acc,
			    F@_1, TrUserData);
dg_read_field_def_Gauge(<<0:1, X:7, Rest/binary>>, N,
			Acc, F@_1, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      9 -> d_field_Gauge_value(Rest, 0, 0, F@_1, TrUserData);
      _ ->
	  case Key band 7 of
	    0 -> skip_varint_Gauge(Rest, 0, 0, F@_1, TrUserData);
	    1 -> skip_64_Gauge(Rest, 0, 0, F@_1, TrUserData);
	    2 ->
		skip_length_delimited_Gauge(Rest, 0, 0, F@_1,
					    TrUserData);
	    3 ->
		skip_group_Gauge(Rest, Key bsr 3, 0, F@_1, TrUserData);
	    5 -> skip_32_Gauge(Rest, 0, 0, F@_1, TrUserData)
	  end
    end;
dg_read_field_def_Gauge(<<>>, 0, 0, F@_1, _) ->
    #'Gauge'{value = F@_1}.

d_field_Gauge_value(<<0:48, 240, 127, Rest/binary>>, Z1,
		    Z2, _, TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2,
			     id(infinity, TrUserData), TrUserData);
d_field_Gauge_value(<<0:48, 240, 255, Rest/binary>>, Z1,
		    Z2, _, TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2,
			     id('-infinity', TrUserData), TrUserData);
d_field_Gauge_value(<<_:48, 15:4, _:4, _:1, 127:7,
		      Rest/binary>>,
		    Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2,
			     id(nan, TrUserData), TrUserData);
d_field_Gauge_value(<<Value:64/little-float,
		      Rest/binary>>,
		    Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2,
			     id(Value, TrUserData), TrUserData).

skip_varint_Gauge(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		  F@_1, TrUserData) ->
    skip_varint_Gauge(Rest, Z1, Z2, F@_1, TrUserData);
skip_varint_Gauge(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		  F@_1, TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2, F@_1,
			     TrUserData).

skip_length_delimited_Gauge(<<1:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, TrUserData)
    when N < 57 ->
    skip_length_delimited_Gauge(Rest, N + 7, X bsl N + Acc,
				F@_1, TrUserData);
skip_length_delimited_Gauge(<<0:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Gauge(Rest2, 0, 0, F@_1, TrUserData).

skip_group_Gauge(Bin, FNum, Z2, F@_1, TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Gauge(Rest, 0, Z2, F@_1, TrUserData).

skip_32_Gauge(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
	      TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2, F@_1,
			     TrUserData).

skip_64_Gauge(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
	      TrUserData) ->
    dfp_read_field_def_Gauge(Rest, Z1, Z2, F@_1,
			     TrUserData).

decode_msg_Counter(Bin, TrUserData) ->
    dfp_read_field_def_Counter(Bin, 0, 0,
			       id(undefined, TrUserData), TrUserData).

dfp_read_field_def_Counter(<<9, Rest/binary>>, Z1, Z2,
			   F@_1, TrUserData) ->
    d_field_Counter_value(Rest, Z1, Z2, F@_1, TrUserData);
dfp_read_field_def_Counter(<<>>, 0, 0, F@_1, _) ->
    #'Counter'{value = F@_1};
dfp_read_field_def_Counter(Other, Z1, Z2, F@_1,
			   TrUserData) ->
    dg_read_field_def_Counter(Other, Z1, Z2, F@_1,
			      TrUserData).

dg_read_field_def_Counter(<<1:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Counter(Rest, N + 7, X bsl N + Acc,
			      F@_1, TrUserData);
dg_read_field_def_Counter(<<0:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      9 ->
	  d_field_Counter_value(Rest, 0, 0, F@_1, TrUserData);
      _ ->
	  case Key band 7 of
	    0 -> skip_varint_Counter(Rest, 0, 0, F@_1, TrUserData);
	    1 -> skip_64_Counter(Rest, 0, 0, F@_1, TrUserData);
	    2 ->
		skip_length_delimited_Counter(Rest, 0, 0, F@_1,
					      TrUserData);
	    3 ->
		skip_group_Counter(Rest, Key bsr 3, 0, F@_1,
				   TrUserData);
	    5 -> skip_32_Counter(Rest, 0, 0, F@_1, TrUserData)
	  end
    end;
dg_read_field_def_Counter(<<>>, 0, 0, F@_1, _) ->
    #'Counter'{value = F@_1}.

d_field_Counter_value(<<0:48, 240, 127, Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2,
			       id(infinity, TrUserData), TrUserData);
d_field_Counter_value(<<0:48, 240, 255, Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2,
			       id('-infinity', TrUserData), TrUserData);
d_field_Counter_value(<<_:48, 15:4, _:4, _:1, 127:7,
			Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2,
			       id(nan, TrUserData), TrUserData);
d_field_Counter_value(<<Value:64/little-float,
			Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2,
			       id(Value, TrUserData), TrUserData).

skip_varint_Counter(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		    F@_1, TrUserData) ->
    skip_varint_Counter(Rest, Z1, Z2, F@_1, TrUserData);
skip_varint_Counter(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		    F@_1, TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2, F@_1,
			       TrUserData).

skip_length_delimited_Counter(<<1:1, X:7, Rest/binary>>,
			      N, Acc, F@_1, TrUserData)
    when N < 57 ->
    skip_length_delimited_Counter(Rest, N + 7,
				  X bsl N + Acc, F@_1, TrUserData);
skip_length_delimited_Counter(<<0:1, X:7, Rest/binary>>,
			      N, Acc, F@_1, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Counter(Rest2, 0, 0, F@_1,
			       TrUserData).

skip_group_Counter(Bin, FNum, Z2, F@_1, TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Counter(Rest, 0, Z2, F@_1,
			       TrUserData).

skip_32_Counter(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
		TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2, F@_1,
			       TrUserData).

skip_64_Counter(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
		TrUserData) ->
    dfp_read_field_def_Counter(Rest, Z1, Z2, F@_1,
			       TrUserData).

decode_msg_Quantile(Bin, TrUserData) ->
    dfp_read_field_def_Quantile(Bin, 0, 0,
				id(undefined, TrUserData),
				id(undefined, TrUserData), TrUserData).

dfp_read_field_def_Quantile(<<9, Rest/binary>>, Z1, Z2,
			    F@_1, F@_2, TrUserData) ->
    d_field_Quantile_quantile(Rest, Z1, Z2, F@_1, F@_2,
			      TrUserData);
dfp_read_field_def_Quantile(<<17, Rest/binary>>, Z1, Z2,
			    F@_1, F@_2, TrUserData) ->
    d_field_Quantile_value(Rest, Z1, Z2, F@_1, F@_2,
			   TrUserData);
dfp_read_field_def_Quantile(<<>>, 0, 0, F@_1, F@_2,
			    _) ->
    #'Quantile'{quantile = F@_1, value = F@_2};
dfp_read_field_def_Quantile(Other, Z1, Z2, F@_1, F@_2,
			    TrUserData) ->
    dg_read_field_def_Quantile(Other, Z1, Z2, F@_1, F@_2,
			       TrUserData).

dg_read_field_def_Quantile(<<1:1, X:7, Rest/binary>>, N,
			   Acc, F@_1, F@_2, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Quantile(Rest, N + 7, X bsl N + Acc,
			       F@_1, F@_2, TrUserData);
dg_read_field_def_Quantile(<<0:1, X:7, Rest/binary>>, N,
			   Acc, F@_1, F@_2, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      9 ->
	  d_field_Quantile_quantile(Rest, 0, 0, F@_1, F@_2,
				    TrUserData);
      17 ->
	  d_field_Quantile_value(Rest, 0, 0, F@_1, F@_2,
				 TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_Quantile(Rest, 0, 0, F@_1, F@_2,
				     TrUserData);
	    1 ->
		skip_64_Quantile(Rest, 0, 0, F@_1, F@_2, TrUserData);
	    2 ->
		skip_length_delimited_Quantile(Rest, 0, 0, F@_1, F@_2,
					       TrUserData);
	    3 ->
		skip_group_Quantile(Rest, Key bsr 3, 0, F@_1, F@_2,
				    TrUserData);
	    5 ->
		skip_32_Quantile(Rest, 0, 0, F@_1, F@_2, TrUserData)
	  end
    end;
dg_read_field_def_Quantile(<<>>, 0, 0, F@_1, F@_2, _) ->
    #'Quantile'{quantile = F@_1, value = F@_2}.

d_field_Quantile_quantile(<<0:48, 240, 127,
			    Rest/binary>>,
			  Z1, Z2, _, F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2,
				id(infinity, TrUserData), F@_2, TrUserData);
d_field_Quantile_quantile(<<0:48, 240, 255,
			    Rest/binary>>,
			  Z1, Z2, _, F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2,
				id('-infinity', TrUserData), F@_2, TrUserData);
d_field_Quantile_quantile(<<_:48, 15:4, _:4, _:1, 127:7,
			    Rest/binary>>,
			  Z1, Z2, _, F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2,
				id(nan, TrUserData), F@_2, TrUserData);
d_field_Quantile_quantile(<<Value:64/little-float,
			    Rest/binary>>,
			  Z1, Z2, _, F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2,
				id(Value, TrUserData), F@_2, TrUserData).

d_field_Quantile_value(<<0:48, 240, 127, Rest/binary>>,
		       Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1,
				id(infinity, TrUserData), TrUserData);
d_field_Quantile_value(<<0:48, 240, 255, Rest/binary>>,
		       Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1,
				id('-infinity', TrUserData), TrUserData);
d_field_Quantile_value(<<_:48, 15:4, _:4, _:1, 127:7,
			 Rest/binary>>,
		       Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1,
				id(nan, TrUserData), TrUserData);
d_field_Quantile_value(<<Value:64/little-float,
			 Rest/binary>>,
		       Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1,
				id(Value, TrUserData), TrUserData).

skip_varint_Quantile(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		     F@_1, F@_2, TrUserData) ->
    skip_varint_Quantile(Rest, Z1, Z2, F@_1, F@_2,
			 TrUserData);
skip_varint_Quantile(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		     F@_1, F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1, F@_2,
				TrUserData).

skip_length_delimited_Quantile(<<1:1, X:7,
				 Rest/binary>>,
			       N, Acc, F@_1, F@_2, TrUserData)
    when N < 57 ->
    skip_length_delimited_Quantile(Rest, N + 7,
				   X bsl N + Acc, F@_1, F@_2, TrUserData);
skip_length_delimited_Quantile(<<0:1, X:7,
				 Rest/binary>>,
			       N, Acc, F@_1, F@_2, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Quantile(Rest2, 0, 0, F@_1, F@_2,
				TrUserData).

skip_group_Quantile(Bin, FNum, Z2, F@_1, F@_2,
		    TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Quantile(Rest, 0, Z2, F@_1, F@_2,
				TrUserData).

skip_32_Quantile(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
		 F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1, F@_2,
				TrUserData).

skip_64_Quantile(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
		 F@_2, TrUserData) ->
    dfp_read_field_def_Quantile(Rest, Z1, Z2, F@_1, F@_2,
				TrUserData).

decode_msg_Summary(Bin, TrUserData) ->
    dfp_read_field_def_Summary(Bin, 0, 0,
			       id(undefined, TrUserData),
			       id(undefined, TrUserData), id([], TrUserData),
			       TrUserData).

dfp_read_field_def_Summary(<<8, Rest/binary>>, Z1, Z2,
			   F@_1, F@_2, F@_3, TrUserData) ->
    d_field_Summary_sample_count(Rest, Z1, Z2, F@_1, F@_2,
				 F@_3, TrUserData);
dfp_read_field_def_Summary(<<17, Rest/binary>>, Z1, Z2,
			   F@_1, F@_2, F@_3, TrUserData) ->
    d_field_Summary_sample_sum(Rest, Z1, Z2, F@_1, F@_2,
			       F@_3, TrUserData);
dfp_read_field_def_Summary(<<26, Rest/binary>>, Z1, Z2,
			   F@_1, F@_2, F@_3, TrUserData) ->
    d_field_Summary_quantile(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			     TrUserData);
dfp_read_field_def_Summary(<<>>, 0, 0, F@_1, F@_2, R1,
			   TrUserData) ->
    #'Summary'{sample_count = F@_1, sample_sum = F@_2,
	       quantile = lists_reverse(R1, TrUserData)};
dfp_read_field_def_Summary(Other, Z1, Z2, F@_1, F@_2,
			   F@_3, TrUserData) ->
    dg_read_field_def_Summary(Other, Z1, Z2, F@_1, F@_2,
			      F@_3, TrUserData).

dg_read_field_def_Summary(<<1:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Summary(Rest, N + 7, X bsl N + Acc,
			      F@_1, F@_2, F@_3, TrUserData);
dg_read_field_def_Summary(<<0:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, F@_2, F@_3, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      8 ->
	  d_field_Summary_sample_count(Rest, 0, 0, F@_1, F@_2,
				       F@_3, TrUserData);
      17 ->
	  d_field_Summary_sample_sum(Rest, 0, 0, F@_1, F@_2, F@_3,
				     TrUserData);
      26 ->
	  d_field_Summary_quantile(Rest, 0, 0, F@_1, F@_2, F@_3,
				   TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_Summary(Rest, 0, 0, F@_1, F@_2, F@_3,
				    TrUserData);
	    1 ->
		skip_64_Summary(Rest, 0, 0, F@_1, F@_2, F@_3,
				TrUserData);
	    2 ->
		skip_length_delimited_Summary(Rest, 0, 0, F@_1, F@_2,
					      F@_3, TrUserData);
	    3 ->
		skip_group_Summary(Rest, Key bsr 3, 0, F@_1, F@_2, F@_3,
				   TrUserData);
	    5 ->
		skip_32_Summary(Rest, 0, 0, F@_1, F@_2, F@_3,
				TrUserData)
	  end
    end;
dg_read_field_def_Summary(<<>>, 0, 0, F@_1, F@_2, R1,
			  TrUserData) ->
    #'Summary'{sample_count = F@_1, sample_sum = F@_2,
	       quantile = lists_reverse(R1, TrUserData)}.

d_field_Summary_sample_count(<<1:1, X:7, Rest/binary>>,
			     N, Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 57 ->
    d_field_Summary_sample_count(Rest, N + 7, X bsl N + Acc,
				 F@_1, F@_2, F@_3, TrUserData);
d_field_Summary_sample_count(<<0:1, X:7, Rest/binary>>,
			     N, Acc, _, F@_2, F@_3, TrUserData) ->
    {NewFValue, RestF} = {id(X bsl N + Acc, TrUserData),
			  Rest},
    dfp_read_field_def_Summary(RestF, 0, 0, NewFValue, F@_2,
			       F@_3, TrUserData).

d_field_Summary_sample_sum(<<0:48, 240, 127,
			     Rest/binary>>,
			   Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1,
			       id(infinity, TrUserData), F@_3, TrUserData);
d_field_Summary_sample_sum(<<0:48, 240, 255,
			     Rest/binary>>,
			   Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1,
			       id('-infinity', TrUserData), F@_3, TrUserData);
d_field_Summary_sample_sum(<<_:48, 15:4, _:4, _:1,
			     127:7, Rest/binary>>,
			   Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1,
			       id(nan, TrUserData), F@_3, TrUserData);
d_field_Summary_sample_sum(<<Value:64/little-float,
			     Rest/binary>>,
			   Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1,
			       id(Value, TrUserData), F@_3, TrUserData).

d_field_Summary_quantile(<<1:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 57 ->
    d_field_Summary_quantile(Rest, N + 7, X bsl N + Acc,
			     F@_1, F@_2, F@_3, TrUserData);
d_field_Summary_quantile(<<0:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, Prev, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Quantile(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Summary(RestF, 0, 0, F@_1, F@_2,
			       cons(NewFValue, Prev, TrUserData), TrUserData).

skip_varint_Summary(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		    F@_1, F@_2, F@_3, TrUserData) ->
    skip_varint_Summary(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			TrUserData);
skip_varint_Summary(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		    F@_1, F@_2, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1, F@_2,
			       F@_3, TrUserData).

skip_length_delimited_Summary(<<1:1, X:7, Rest/binary>>,
			      N, Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 57 ->
    skip_length_delimited_Summary(Rest, N + 7,
				  X bsl N + Acc, F@_1, F@_2, F@_3, TrUserData);
skip_length_delimited_Summary(<<0:1, X:7, Rest/binary>>,
			      N, Acc, F@_1, F@_2, F@_3, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Summary(Rest2, 0, 0, F@_1, F@_2,
			       F@_3, TrUserData).

skip_group_Summary(Bin, FNum, Z2, F@_1, F@_2, F@_3,
		   TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Summary(Rest, 0, Z2, F@_1, F@_2,
			       F@_3, TrUserData).

skip_32_Summary(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
		F@_2, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1, F@_2,
			       F@_3, TrUserData).

skip_64_Summary(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
		F@_2, F@_3, TrUserData) ->
    dfp_read_field_def_Summary(Rest, Z1, Z2, F@_1, F@_2,
			       F@_3, TrUserData).

decode_msg_Untyped(Bin, TrUserData) ->
    dfp_read_field_def_Untyped(Bin, 0, 0,
			       id(undefined, TrUserData), TrUserData).

dfp_read_field_def_Untyped(<<9, Rest/binary>>, Z1, Z2,
			   F@_1, TrUserData) ->
    d_field_Untyped_value(Rest, Z1, Z2, F@_1, TrUserData);
dfp_read_field_def_Untyped(<<>>, 0, 0, F@_1, _) ->
    #'Untyped'{value = F@_1};
dfp_read_field_def_Untyped(Other, Z1, Z2, F@_1,
			   TrUserData) ->
    dg_read_field_def_Untyped(Other, Z1, Z2, F@_1,
			      TrUserData).

dg_read_field_def_Untyped(<<1:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Untyped(Rest, N + 7, X bsl N + Acc,
			      F@_1, TrUserData);
dg_read_field_def_Untyped(<<0:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      9 ->
	  d_field_Untyped_value(Rest, 0, 0, F@_1, TrUserData);
      _ ->
	  case Key band 7 of
	    0 -> skip_varint_Untyped(Rest, 0, 0, F@_1, TrUserData);
	    1 -> skip_64_Untyped(Rest, 0, 0, F@_1, TrUserData);
	    2 ->
		skip_length_delimited_Untyped(Rest, 0, 0, F@_1,
					      TrUserData);
	    3 ->
		skip_group_Untyped(Rest, Key bsr 3, 0, F@_1,
				   TrUserData);
	    5 -> skip_32_Untyped(Rest, 0, 0, F@_1, TrUserData)
	  end
    end;
dg_read_field_def_Untyped(<<>>, 0, 0, F@_1, _) ->
    #'Untyped'{value = F@_1}.

d_field_Untyped_value(<<0:48, 240, 127, Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2,
			       id(infinity, TrUserData), TrUserData);
d_field_Untyped_value(<<0:48, 240, 255, Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2,
			       id('-infinity', TrUserData), TrUserData);
d_field_Untyped_value(<<_:48, 15:4, _:4, _:1, 127:7,
			Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2,
			       id(nan, TrUserData), TrUserData);
d_field_Untyped_value(<<Value:64/little-float,
			Rest/binary>>,
		      Z1, Z2, _, TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2,
			       id(Value, TrUserData), TrUserData).

skip_varint_Untyped(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		    F@_1, TrUserData) ->
    skip_varint_Untyped(Rest, Z1, Z2, F@_1, TrUserData);
skip_varint_Untyped(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		    F@_1, TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2, F@_1,
			       TrUserData).

skip_length_delimited_Untyped(<<1:1, X:7, Rest/binary>>,
			      N, Acc, F@_1, TrUserData)
    when N < 57 ->
    skip_length_delimited_Untyped(Rest, N + 7,
				  X bsl N + Acc, F@_1, TrUserData);
skip_length_delimited_Untyped(<<0:1, X:7, Rest/binary>>,
			      N, Acc, F@_1, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Untyped(Rest2, 0, 0, F@_1,
			       TrUserData).

skip_group_Untyped(Bin, FNum, Z2, F@_1, TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Untyped(Rest, 0, Z2, F@_1,
			       TrUserData).

skip_32_Untyped(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
		TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2, F@_1,
			       TrUserData).

skip_64_Untyped(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
		TrUserData) ->
    dfp_read_field_def_Untyped(Rest, Z1, Z2, F@_1,
			       TrUserData).

decode_msg_Histogram(Bin, TrUserData) ->
    dfp_read_field_def_Histogram(Bin, 0, 0,
				 id(undefined, TrUserData),
				 id(undefined, TrUserData), id([], TrUserData),
				 TrUserData).

dfp_read_field_def_Histogram(<<8, Rest/binary>>, Z1, Z2,
			     F@_1, F@_2, F@_3, TrUserData) ->
    d_field_Histogram_sample_count(Rest, Z1, Z2, F@_1, F@_2,
				   F@_3, TrUserData);
dfp_read_field_def_Histogram(<<17, Rest/binary>>, Z1,
			     Z2, F@_1, F@_2, F@_3, TrUserData) ->
    d_field_Histogram_sample_sum(Rest, Z1, Z2, F@_1, F@_2,
				 F@_3, TrUserData);
dfp_read_field_def_Histogram(<<26, Rest/binary>>, Z1,
			     Z2, F@_1, F@_2, F@_3, TrUserData) ->
    d_field_Histogram_bucket(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			     TrUserData);
dfp_read_field_def_Histogram(<<>>, 0, 0, F@_1, F@_2, R1,
			     TrUserData) ->
    #'Histogram'{sample_count = F@_1, sample_sum = F@_2,
		 bucket = lists_reverse(R1, TrUserData)};
dfp_read_field_def_Histogram(Other, Z1, Z2, F@_1, F@_2,
			     F@_3, TrUserData) ->
    dg_read_field_def_Histogram(Other, Z1, Z2, F@_1, F@_2,
				F@_3, TrUserData).

dg_read_field_def_Histogram(<<1:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Histogram(Rest, N + 7, X bsl N + Acc,
				F@_1, F@_2, F@_3, TrUserData);
dg_read_field_def_Histogram(<<0:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, F@_3, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      8 ->
	  d_field_Histogram_sample_count(Rest, 0, 0, F@_1, F@_2,
					 F@_3, TrUserData);
      17 ->
	  d_field_Histogram_sample_sum(Rest, 0, 0, F@_1, F@_2,
				       F@_3, TrUserData);
      26 ->
	  d_field_Histogram_bucket(Rest, 0, 0, F@_1, F@_2, F@_3,
				   TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_Histogram(Rest, 0, 0, F@_1, F@_2, F@_3,
				      TrUserData);
	    1 ->
		skip_64_Histogram(Rest, 0, 0, F@_1, F@_2, F@_3,
				  TrUserData);
	    2 ->
		skip_length_delimited_Histogram(Rest, 0, 0, F@_1, F@_2,
						F@_3, TrUserData);
	    3 ->
		skip_group_Histogram(Rest, Key bsr 3, 0, F@_1, F@_2,
				     F@_3, TrUserData);
	    5 ->
		skip_32_Histogram(Rest, 0, 0, F@_1, F@_2, F@_3,
				  TrUserData)
	  end
    end;
dg_read_field_def_Histogram(<<>>, 0, 0, F@_1, F@_2, R1,
			    TrUserData) ->
    #'Histogram'{sample_count = F@_1, sample_sum = F@_2,
		 bucket = lists_reverse(R1, TrUserData)}.

d_field_Histogram_sample_count(<<1:1, X:7,
				 Rest/binary>>,
			       N, Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 57 ->
    d_field_Histogram_sample_count(Rest, N + 7,
				   X bsl N + Acc, F@_1, F@_2, F@_3, TrUserData);
d_field_Histogram_sample_count(<<0:1, X:7,
				 Rest/binary>>,
			       N, Acc, _, F@_2, F@_3, TrUserData) ->
    {NewFValue, RestF} = {id(X bsl N + Acc, TrUserData),
			  Rest},
    dfp_read_field_def_Histogram(RestF, 0, 0, NewFValue,
				 F@_2, F@_3, TrUserData).

d_field_Histogram_sample_sum(<<0:48, 240, 127,
			       Rest/binary>>,
			     Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1,
				 id(infinity, TrUserData), F@_3, TrUserData);
d_field_Histogram_sample_sum(<<0:48, 240, 255,
			       Rest/binary>>,
			     Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1,
				 id('-infinity', TrUserData), F@_3, TrUserData);
d_field_Histogram_sample_sum(<<_:48, 15:4, _:4, _:1,
			       127:7, Rest/binary>>,
			     Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1,
				 id(nan, TrUserData), F@_3, TrUserData);
d_field_Histogram_sample_sum(<<Value:64/little-float,
			       Rest/binary>>,
			     Z1, Z2, F@_1, _, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1,
				 id(Value, TrUserData), F@_3, TrUserData).

d_field_Histogram_bucket(<<1:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 57 ->
    d_field_Histogram_bucket(Rest, N + 7, X bsl N + Acc,
			     F@_1, F@_2, F@_3, TrUserData);
d_field_Histogram_bucket(<<0:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, Prev, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Bucket(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Histogram(RestF, 0, 0, F@_1, F@_2,
				 cons(NewFValue, Prev, TrUserData), TrUserData).

skip_varint_Histogram(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		      F@_1, F@_2, F@_3, TrUserData) ->
    skip_varint_Histogram(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			  TrUserData);
skip_varint_Histogram(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		      F@_1, F@_2, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1, F@_2,
				 F@_3, TrUserData).

skip_length_delimited_Histogram(<<1:1, X:7,
				  Rest/binary>>,
				N, Acc, F@_1, F@_2, F@_3, TrUserData)
    when N < 57 ->
    skip_length_delimited_Histogram(Rest, N + 7,
				    X bsl N + Acc, F@_1, F@_2, F@_3,
				    TrUserData);
skip_length_delimited_Histogram(<<0:1, X:7,
				  Rest/binary>>,
				N, Acc, F@_1, F@_2, F@_3, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Histogram(Rest2, 0, 0, F@_1, F@_2,
				 F@_3, TrUserData).

skip_group_Histogram(Bin, FNum, Z2, F@_1, F@_2, F@_3,
		     TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Histogram(Rest, 0, Z2, F@_1, F@_2,
				 F@_3, TrUserData).

skip_32_Histogram(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
		  F@_2, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1, F@_2,
				 F@_3, TrUserData).

skip_64_Histogram(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
		  F@_2, F@_3, TrUserData) ->
    dfp_read_field_def_Histogram(Rest, Z1, Z2, F@_1, F@_2,
				 F@_3, TrUserData).

decode_msg_Bucket(Bin, TrUserData) ->
    dfp_read_field_def_Bucket(Bin, 0, 0,
			      id(undefined, TrUserData),
			      id(undefined, TrUserData), TrUserData).

dfp_read_field_def_Bucket(<<8, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, TrUserData) ->
    d_field_Bucket_cumulative_count(Rest, Z1, Z2, F@_1,
				    F@_2, TrUserData);
dfp_read_field_def_Bucket(<<17, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, TrUserData) ->
    d_field_Bucket_upper_bound(Rest, Z1, Z2, F@_1, F@_2,
			       TrUserData);
dfp_read_field_def_Bucket(<<>>, 0, 0, F@_1, F@_2, _) ->
    #'Bucket'{cumulative_count = F@_1, upper_bound = F@_2};
dfp_read_field_def_Bucket(Other, Z1, Z2, F@_1, F@_2,
			  TrUserData) ->
    dg_read_field_def_Bucket(Other, Z1, Z2, F@_1, F@_2,
			     TrUserData).

dg_read_field_def_Bucket(<<1:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Bucket(Rest, N + 7, X bsl N + Acc,
			     F@_1, F@_2, TrUserData);
dg_read_field_def_Bucket(<<0:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      8 ->
	  d_field_Bucket_cumulative_count(Rest, 0, 0, F@_1, F@_2,
					  TrUserData);
      17 ->
	  d_field_Bucket_upper_bound(Rest, 0, 0, F@_1, F@_2,
				     TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_Bucket(Rest, 0, 0, F@_1, F@_2, TrUserData);
	    1 -> skip_64_Bucket(Rest, 0, 0, F@_1, F@_2, TrUserData);
	    2 ->
		skip_length_delimited_Bucket(Rest, 0, 0, F@_1, F@_2,
					     TrUserData);
	    3 ->
		skip_group_Bucket(Rest, Key bsr 3, 0, F@_1, F@_2,
				  TrUserData);
	    5 -> skip_32_Bucket(Rest, 0, 0, F@_1, F@_2, TrUserData)
	  end
    end;
dg_read_field_def_Bucket(<<>>, 0, 0, F@_1, F@_2, _) ->
    #'Bucket'{cumulative_count = F@_1, upper_bound = F@_2}.

d_field_Bucket_cumulative_count(<<1:1, X:7,
				  Rest/binary>>,
				N, Acc, F@_1, F@_2, TrUserData)
    when N < 57 ->
    d_field_Bucket_cumulative_count(Rest, N + 7,
				    X bsl N + Acc, F@_1, F@_2, TrUserData);
d_field_Bucket_cumulative_count(<<0:1, X:7,
				  Rest/binary>>,
				N, Acc, _, F@_2, TrUserData) ->
    {NewFValue, RestF} = {id(X bsl N + Acc, TrUserData),
			  Rest},
    dfp_read_field_def_Bucket(RestF, 0, 0, NewFValue, F@_2,
			      TrUserData).

d_field_Bucket_upper_bound(<<0:48, 240, 127,
			     Rest/binary>>,
			   Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1,
			      id(infinity, TrUserData), TrUserData);
d_field_Bucket_upper_bound(<<0:48, 240, 255,
			     Rest/binary>>,
			   Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1,
			      id('-infinity', TrUserData), TrUserData);
d_field_Bucket_upper_bound(<<_:48, 15:4, _:4, _:1,
			     127:7, Rest/binary>>,
			   Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1,
			      id(nan, TrUserData), TrUserData);
d_field_Bucket_upper_bound(<<Value:64/little-float,
			     Rest/binary>>,
			   Z1, Z2, F@_1, _, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1,
			      id(Value, TrUserData), TrUserData).

skip_varint_Bucket(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		   F@_1, F@_2, TrUserData) ->
    skip_varint_Bucket(Rest, Z1, Z2, F@_1, F@_2,
		       TrUserData);
skip_varint_Bucket(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		   F@_1, F@_2, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1, F@_2,
			      TrUserData).

skip_length_delimited_Bucket(<<1:1, X:7, Rest/binary>>,
			     N, Acc, F@_1, F@_2, TrUserData)
    when N < 57 ->
    skip_length_delimited_Bucket(Rest, N + 7, X bsl N + Acc,
				 F@_1, F@_2, TrUserData);
skip_length_delimited_Bucket(<<0:1, X:7, Rest/binary>>,
			     N, Acc, F@_1, F@_2, TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Bucket(Rest2, 0, 0, F@_1, F@_2,
			      TrUserData).

skip_group_Bucket(Bin, FNum, Z2, F@_1, F@_2,
		  TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Bucket(Rest, 0, Z2, F@_1, F@_2,
			      TrUserData).

skip_32_Bucket(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
	       F@_2, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1, F@_2,
			      TrUserData).

skip_64_Bucket(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
	       F@_2, TrUserData) ->
    dfp_read_field_def_Bucket(Rest, Z1, Z2, F@_1, F@_2,
			      TrUserData).

decode_msg_Metric(Bin, TrUserData) ->
    dfp_read_field_def_Metric(Bin, 0, 0, id([], TrUserData),
			      id(undefined, TrUserData),
			      id(undefined, TrUserData),
			      id(undefined, TrUserData),
			      id(undefined, TrUserData),
			      id(undefined, TrUserData),
			      id(undefined, TrUserData), TrUserData).

dfp_read_field_def_Metric(<<10, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_label(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			 F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<18, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_gauge(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			 F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<26, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_counter(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			   F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<34, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_summary(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			   F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<42, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_untyped(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			   F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<58, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_histogram(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			     F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<48, Rest/binary>>, Z1, Z2,
			  F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			  TrUserData) ->
    d_field_Metric_timestamp_ms(Rest, Z1, Z2, F@_1, F@_2,
				F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
dfp_read_field_def_Metric(<<>>, 0, 0, R1, F@_2, F@_3,
			  F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    #'Metric'{label = lists_reverse(R1, TrUserData),
	      gauge = F@_2, counter = F@_3, summary = F@_4,
	      untyped = F@_5, histogram = F@_6, timestamp_ms = F@_7};
dfp_read_field_def_Metric(Other, Z1, Z2, F@_1, F@_2,
			  F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    dg_read_field_def_Metric(Other, Z1, Z2, F@_1, F@_2,
			     F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData).

dg_read_field_def_Metric(<<1:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			 TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_Metric(Rest, N + 7, X bsl N + Acc,
			     F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			     TrUserData);
dg_read_field_def_Metric(<<0:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			 TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      10 ->
	  d_field_Metric_label(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4,
			       F@_5, F@_6, F@_7, TrUserData);
      18 ->
	  d_field_Metric_gauge(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4,
			       F@_5, F@_6, F@_7, TrUserData);
      26 ->
	  d_field_Metric_counter(Rest, 0, 0, F@_1, F@_2, F@_3,
				 F@_4, F@_5, F@_6, F@_7, TrUserData);
      34 ->
	  d_field_Metric_summary(Rest, 0, 0, F@_1, F@_2, F@_3,
				 F@_4, F@_5, F@_6, F@_7, TrUserData);
      42 ->
	  d_field_Metric_untyped(Rest, 0, 0, F@_1, F@_2, F@_3,
				 F@_4, F@_5, F@_6, F@_7, TrUserData);
      58 ->
	  d_field_Metric_histogram(Rest, 0, 0, F@_1, F@_2, F@_3,
				   F@_4, F@_5, F@_6, F@_7, TrUserData);
      48 ->
	  d_field_Metric_timestamp_ms(Rest, 0, 0, F@_1, F@_2,
				      F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_Metric(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4,
				   F@_5, F@_6, F@_7, TrUserData);
	    1 ->
		skip_64_Metric(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4, F@_5,
			       F@_6, F@_7, TrUserData);
	    2 ->
		skip_length_delimited_Metric(Rest, 0, 0, F@_1, F@_2,
					     F@_3, F@_4, F@_5, F@_6, F@_7,
					     TrUserData);
	    3 ->
		skip_group_Metric(Rest, Key bsr 3, 0, F@_1, F@_2, F@_3,
				  F@_4, F@_5, F@_6, F@_7, TrUserData);
	    5 ->
		skip_32_Metric(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4, F@_5,
			       F@_6, F@_7, TrUserData)
	  end
    end;
dg_read_field_def_Metric(<<>>, 0, 0, R1, F@_2, F@_3,
			 F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    #'Metric'{label = lists_reverse(R1, TrUserData),
	      gauge = F@_2, counter = F@_3, summary = F@_4,
	      untyped = F@_5, histogram = F@_6, timestamp_ms = F@_7}.

d_field_Metric_label(<<1:1, X:7, Rest/binary>>, N, Acc,
		     F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData)
    when N < 57 ->
    d_field_Metric_label(Rest, N + 7, X bsl N + Acc, F@_1,
			 F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
d_field_Metric_label(<<0:1, X:7, Rest/binary>>, N, Acc,
		     Prev, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_LabelPair(Bs, TrUserData),
			       TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Metric(RestF, 0, 0,
			      cons(NewFValue, Prev, TrUserData), F@_2, F@_3,
			      F@_4, F@_5, F@_6, F@_7, TrUserData).

d_field_Metric_gauge(<<1:1, X:7, Rest/binary>>, N, Acc,
		     F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData)
    when N < 57 ->
    d_field_Metric_gauge(Rest, N + 7, X bsl N + Acc, F@_1,
			 F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
d_field_Metric_gauge(<<0:1, X:7, Rest/binary>>, N, Acc,
		     F@_1, Prev, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Gauge(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Metric(RestF, 0, 0, F@_1,
			      if Prev == undefined -> NewFValue;
				 true ->
				     merge_msg_Gauge(Prev, NewFValue,
						     TrUserData)
			      end,
			      F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData).

d_field_Metric_counter(<<1:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
		       TrUserData)
    when N < 57 ->
    d_field_Metric_counter(Rest, N + 7, X bsl N + Acc, F@_1,
			   F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
d_field_Metric_counter(<<0:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, Prev, F@_4, F@_5, F@_6, F@_7,
		       TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Counter(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Metric(RestF, 0, 0, F@_1, F@_2,
			      if Prev == undefined -> NewFValue;
				 true ->
				     merge_msg_Counter(Prev, NewFValue,
						       TrUserData)
			      end,
			      F@_4, F@_5, F@_6, F@_7, TrUserData).

d_field_Metric_summary(<<1:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
		       TrUserData)
    when N < 57 ->
    d_field_Metric_summary(Rest, N + 7, X bsl N + Acc, F@_1,
			   F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
d_field_Metric_summary(<<0:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, F@_3, Prev, F@_5, F@_6, F@_7,
		       TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Summary(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Metric(RestF, 0, 0, F@_1, F@_2, F@_3,
			      if Prev == undefined -> NewFValue;
				 true ->
				     merge_msg_Summary(Prev, NewFValue,
						       TrUserData)
			      end,
			      F@_5, F@_6, F@_7, TrUserData).

d_field_Metric_untyped(<<1:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
		       TrUserData)
    when N < 57 ->
    d_field_Metric_untyped(Rest, N + 7, X bsl N + Acc, F@_1,
			   F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData);
d_field_Metric_untyped(<<0:1, X:7, Rest/binary>>, N,
		       Acc, F@_1, F@_2, F@_3, F@_4, Prev, F@_6, F@_7,
		       TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Untyped(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Metric(RestF, 0, 0, F@_1, F@_2, F@_3,
			      F@_4,
			      if Prev == undefined -> NewFValue;
				 true ->
				     merge_msg_Untyped(Prev, NewFValue,
						       TrUserData)
			      end,
			      F@_6, F@_7, TrUserData).

d_field_Metric_histogram(<<1:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			 TrUserData)
    when N < 57 ->
    d_field_Metric_histogram(Rest, N + 7, X bsl N + Acc,
			     F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			     TrUserData);
d_field_Metric_histogram(<<0:1, X:7, Rest/binary>>, N,
			 Acc, F@_1, F@_2, F@_3, F@_4, F@_5, Prev, F@_7,
			 TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Histogram(Bs, TrUserData),
			       TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_Metric(RestF, 0, 0, F@_1, F@_2, F@_3,
			      F@_4, F@_5,
			      if Prev == undefined -> NewFValue;
				 true ->
				     merge_msg_Histogram(Prev, NewFValue,
							 TrUserData)
			      end,
			      F@_7, TrUserData).

d_field_Metric_timestamp_ms(<<1:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			    TrUserData)
    when N < 57 ->
    d_field_Metric_timestamp_ms(Rest, N + 7, X bsl N + Acc,
				F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
				TrUserData);
d_field_Metric_timestamp_ms(<<0:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, _,
			    TrUserData) ->
    {NewFValue, RestF} = {begin
			    <<Res:64/signed-native>> = <<(X bsl N +
							    Acc):64/unsigned-native>>,
			    id(Res, TrUserData)
			  end,
			  Rest},
    dfp_read_field_def_Metric(RestF, 0, 0, F@_1, F@_2, F@_3,
			      F@_4, F@_5, F@_6, NewFValue, TrUserData).

skip_varint_Metric(<<1:1, _:7, Rest/binary>>, Z1, Z2,
		   F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    skip_varint_Metric(Rest, Z1, Z2, F@_1, F@_2, F@_3, F@_4,
		       F@_5, F@_6, F@_7, TrUserData);
skip_varint_Metric(<<0:1, _:7, Rest/binary>>, Z1, Z2,
		   F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    dfp_read_field_def_Metric(Rest, Z1, Z2, F@_1, F@_2,
			      F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData).

skip_length_delimited_Metric(<<1:1, X:7, Rest/binary>>,
			     N, Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			     TrUserData)
    when N < 57 ->
    skip_length_delimited_Metric(Rest, N + 7, X bsl N + Acc,
				 F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
				 TrUserData);
skip_length_delimited_Metric(<<0:1, X:7, Rest/binary>>,
			     N, Acc, F@_1, F@_2, F@_3, F@_4, F@_5, F@_6, F@_7,
			     TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_Metric(Rest2, 0, 0, F@_1, F@_2, F@_3,
			      F@_4, F@_5, F@_6, F@_7, TrUserData).

skip_group_Metric(Bin, FNum, Z2, F@_1, F@_2, F@_3, F@_4,
		  F@_5, F@_6, F@_7, TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_Metric(Rest, 0, Z2, F@_1, F@_2, F@_3,
			      F@_4, F@_5, F@_6, F@_7, TrUserData).

skip_32_Metric(<<_:32, Rest/binary>>, Z1, Z2, F@_1,
	       F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    dfp_read_field_def_Metric(Rest, Z1, Z2, F@_1, F@_2,
			      F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData).

skip_64_Metric(<<_:64, Rest/binary>>, Z1, Z2, F@_1,
	       F@_2, F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData) ->
    dfp_read_field_def_Metric(Rest, Z1, Z2, F@_1, F@_2,
			      F@_3, F@_4, F@_5, F@_6, F@_7, TrUserData).

decode_msg_MetricFamily(Bin, TrUserData) ->
    dfp_read_field_def_MetricFamily(Bin, 0, 0,
				    id(undefined, TrUserData),
				    id(undefined, TrUserData),
				    id(undefined, TrUserData),
				    id([], TrUserData), TrUserData).

dfp_read_field_def_MetricFamily(<<10, Rest/binary>>, Z1,
				Z2, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    d_field_MetricFamily_name(Rest, Z1, Z2, F@_1, F@_2,
			      F@_3, F@_4, TrUserData);
dfp_read_field_def_MetricFamily(<<18, Rest/binary>>, Z1,
				Z2, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    d_field_MetricFamily_help(Rest, Z1, Z2, F@_1, F@_2,
			      F@_3, F@_4, TrUserData);
dfp_read_field_def_MetricFamily(<<24, Rest/binary>>, Z1,
				Z2, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    d_field_MetricFamily_type(Rest, Z1, Z2, F@_1, F@_2,
			      F@_3, F@_4, TrUserData);
dfp_read_field_def_MetricFamily(<<34, Rest/binary>>, Z1,
				Z2, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    d_field_MetricFamily_metric(Rest, Z1, Z2, F@_1, F@_2,
				F@_3, F@_4, TrUserData);
dfp_read_field_def_MetricFamily(<<>>, 0, 0, F@_1, F@_2,
				F@_3, R1, TrUserData) ->
    #'MetricFamily'{name = F@_1, help = F@_2, type = F@_3,
		    metric = lists_reverse(R1, TrUserData)};
dfp_read_field_def_MetricFamily(Other, Z1, Z2, F@_1,
				F@_2, F@_3, F@_4, TrUserData) ->
    dg_read_field_def_MetricFamily(Other, Z1, Z2, F@_1,
				   F@_2, F@_3, F@_4, TrUserData).

dg_read_field_def_MetricFamily(<<1:1, X:7,
				 Rest/binary>>,
			       N, Acc, F@_1, F@_2, F@_3, F@_4, TrUserData)
    when N < 32 - 7 ->
    dg_read_field_def_MetricFamily(Rest, N + 7,
				   X bsl N + Acc, F@_1, F@_2, F@_3, F@_4,
				   TrUserData);
dg_read_field_def_MetricFamily(<<0:1, X:7,
				 Rest/binary>>,
			       N, Acc, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    Key = X bsl N + Acc,
    case Key of
      10 ->
	  d_field_MetricFamily_name(Rest, 0, 0, F@_1, F@_2, F@_3,
				    F@_4, TrUserData);
      18 ->
	  d_field_MetricFamily_help(Rest, 0, 0, F@_1, F@_2, F@_3,
				    F@_4, TrUserData);
      24 ->
	  d_field_MetricFamily_type(Rest, 0, 0, F@_1, F@_2, F@_3,
				    F@_4, TrUserData);
      34 ->
	  d_field_MetricFamily_metric(Rest, 0, 0, F@_1, F@_2,
				      F@_3, F@_4, TrUserData);
      _ ->
	  case Key band 7 of
	    0 ->
		skip_varint_MetricFamily(Rest, 0, 0, F@_1, F@_2, F@_3,
					 F@_4, TrUserData);
	    1 ->
		skip_64_MetricFamily(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4,
				     TrUserData);
	    2 ->
		skip_length_delimited_MetricFamily(Rest, 0, 0, F@_1,
						   F@_2, F@_3, F@_4,
						   TrUserData);
	    3 ->
		skip_group_MetricFamily(Rest, Key bsr 3, 0, F@_1, F@_2,
					F@_3, F@_4, TrUserData);
	    5 ->
		skip_32_MetricFamily(Rest, 0, 0, F@_1, F@_2, F@_3, F@_4,
				     TrUserData)
	  end
    end;
dg_read_field_def_MetricFamily(<<>>, 0, 0, F@_1, F@_2,
			       F@_3, R1, TrUserData) ->
    #'MetricFamily'{name = F@_1, help = F@_2, type = F@_3,
		    metric = lists_reverse(R1, TrUserData)}.

d_field_MetricFamily_name(<<1:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, F@_2, F@_3, F@_4, TrUserData)
    when N < 57 ->
    d_field_MetricFamily_name(Rest, N + 7, X bsl N + Acc,
			      F@_1, F@_2, F@_3, F@_4, TrUserData);
d_field_MetricFamily_name(<<0:1, X:7, Rest/binary>>, N,
			  Acc, _, F@_2, F@_3, F@_4, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bytes:Len/binary, Rest2/binary>> = Rest,
			   {id(binary:copy(Bytes), TrUserData), Rest2}
			 end,
    dfp_read_field_def_MetricFamily(RestF, 0, 0, NewFValue,
				    F@_2, F@_3, F@_4, TrUserData).

d_field_MetricFamily_help(<<1:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, F@_2, F@_3, F@_4, TrUserData)
    when N < 57 ->
    d_field_MetricFamily_help(Rest, N + 7, X bsl N + Acc,
			      F@_1, F@_2, F@_3, F@_4, TrUserData);
d_field_MetricFamily_help(<<0:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, _, F@_3, F@_4, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bytes:Len/binary, Rest2/binary>> = Rest,
			   {id(binary:copy(Bytes), TrUserData), Rest2}
			 end,
    dfp_read_field_def_MetricFamily(RestF, 0, 0, F@_1,
				    NewFValue, F@_3, F@_4, TrUserData).

d_field_MetricFamily_type(<<1:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, F@_2, F@_3, F@_4, TrUserData)
    when N < 57 ->
    d_field_MetricFamily_type(Rest, N + 7, X bsl N + Acc,
			      F@_1, F@_2, F@_3, F@_4, TrUserData);
d_field_MetricFamily_type(<<0:1, X:7, Rest/binary>>, N,
			  Acc, F@_1, F@_2, _, F@_4, TrUserData) ->
    {NewFValue, RestF} = {id(d_enum_MetricType(begin
						 <<Res:32/signed-native>> = <<(X
										 bsl
										 N
										 +
										 Acc):32/unsigned-native>>,
						 id(Res, TrUserData)
					       end),
			     TrUserData),
			  Rest},
    dfp_read_field_def_MetricFamily(RestF, 0, 0, F@_1, F@_2,
				    NewFValue, F@_4, TrUserData).

d_field_MetricFamily_metric(<<1:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, F@_3, F@_4, TrUserData)
    when N < 57 ->
    d_field_MetricFamily_metric(Rest, N + 7, X bsl N + Acc,
				F@_1, F@_2, F@_3, F@_4, TrUserData);
d_field_MetricFamily_metric(<<0:1, X:7, Rest/binary>>,
			    N, Acc, F@_1, F@_2, F@_3, Prev, TrUserData) ->
    {NewFValue, RestF} = begin
			   Len = X bsl N + Acc,
			   <<Bs:Len/binary, Rest2/binary>> = Rest,
			   {id(decode_msg_Metric(Bs, TrUserData), TrUserData),
			    Rest2}
			 end,
    dfp_read_field_def_MetricFamily(RestF, 0, 0, F@_1, F@_2,
				    F@_3, cons(NewFValue, Prev, TrUserData),
				    TrUserData).

skip_varint_MetricFamily(<<1:1, _:7, Rest/binary>>, Z1,
			 Z2, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    skip_varint_MetricFamily(Rest, Z1, Z2, F@_1, F@_2, F@_3,
			     F@_4, TrUserData);
skip_varint_MetricFamily(<<0:1, _:7, Rest/binary>>, Z1,
			 Z2, F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    dfp_read_field_def_MetricFamily(Rest, Z1, Z2, F@_1,
				    F@_2, F@_3, F@_4, TrUserData).

skip_length_delimited_MetricFamily(<<1:1, X:7,
				     Rest/binary>>,
				   N, Acc, F@_1, F@_2, F@_3, F@_4, TrUserData)
    when N < 57 ->
    skip_length_delimited_MetricFamily(Rest, N + 7,
				       X bsl N + Acc, F@_1, F@_2, F@_3, F@_4,
				       TrUserData);
skip_length_delimited_MetricFamily(<<0:1, X:7,
				     Rest/binary>>,
				   N, Acc, F@_1, F@_2, F@_3, F@_4,
				   TrUserData) ->
    Length = X bsl N + Acc,
    <<_:Length/binary, Rest2/binary>> = Rest,
    dfp_read_field_def_MetricFamily(Rest2, 0, 0, F@_1, F@_2,
				    F@_3, F@_4, TrUserData).

skip_group_MetricFamily(Bin, FNum, Z2, F@_1, F@_2, F@_3,
			F@_4, TrUserData) ->
    {_, Rest} = read_group(Bin, FNum),
    dfp_read_field_def_MetricFamily(Rest, 0, Z2, F@_1, F@_2,
				    F@_3, F@_4, TrUserData).

skip_32_MetricFamily(<<_:32, Rest/binary>>, Z1, Z2,
		     F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    dfp_read_field_def_MetricFamily(Rest, Z1, Z2, F@_1,
				    F@_2, F@_3, F@_4, TrUserData).

skip_64_MetricFamily(<<_:64, Rest/binary>>, Z1, Z2,
		     F@_1, F@_2, F@_3, F@_4, TrUserData) ->
    dfp_read_field_def_MetricFamily(Rest, Z1, Z2, F@_1,
				    F@_2, F@_3, F@_4, TrUserData).

d_enum_MetricType(0) -> 'COUNTER';
d_enum_MetricType(1) -> 'GAUGE';
d_enum_MetricType(2) -> 'SUMMARY';
d_enum_MetricType(3) -> 'UNTYPED';
d_enum_MetricType(4) -> 'HISTOGRAM';
d_enum_MetricType(V) -> V.

read_group(Bin, FieldNum) ->
    {NumBytes, EndTagLen} = read_gr_b(Bin, 0, 0, 0, 0, FieldNum),
    <<Group:NumBytes/binary, _:EndTagLen/binary, Rest/binary>> = Bin,
    {Group, Rest}.

%% Like skipping over fields, but record the total length,
%% Each field is <(FieldNum bsl 3) bor FieldType> ++ <FieldValue>
%% Record the length because varints may be non-optimally encoded.
%%
%% Groups can be nested, but assume the same FieldNum cannot be nested
%% because group field numbers are shared with the rest of the fields
%% numbers. Thus we can search just for an group-end with the same
%% field number.
%%
%% (The only time the same group field number could occur would
%% be in a nested sub message, but then it would be inside a
%% length-delimited entry, which we skip-read by length.)
read_gr_b(<<1:1, X:7, Tl/binary>>, N, Acc, NumBytes, TagLen, FieldNum)
  when N < (32-7) ->
    read_gr_b(Tl, N+7, X bsl N + Acc, NumBytes, TagLen+1, FieldNum);
read_gr_b(<<0:1, X:7, Tl/binary>>, N, Acc, NumBytes, TagLen,
          FieldNum) ->
    Key = X bsl N + Acc,
    TagLen1 = TagLen + 1,
    case {Key bsr 3, Key band 7} of
        {FieldNum, 4} -> % 4 = group_end
            {NumBytes, TagLen1};
        {_, 0} -> % 0 = varint
            read_gr_vi(Tl, 0, NumBytes + TagLen1, FieldNum);
        {_, 1} -> % 1 = bits64
            <<_:64, Tl2/binary>> = Tl,
            read_gr_b(Tl2, 0, 0, NumBytes + TagLen1 + 8, 0, FieldNum);
        {_, 2} -> % 2 = length_delimited
            read_gr_ld(Tl, 0, 0, NumBytes + TagLen1, FieldNum);
        {_, 3} -> % 3 = group_start
            read_gr_b(Tl, 0, 0, NumBytes + TagLen1, 0, FieldNum);
        {_, 4} -> % 4 = group_end
            read_gr_b(Tl, 0, 0, NumBytes + TagLen1, 0, FieldNum);
        {_, 5} -> % 5 = bits32
            <<_:32, Tl2/binary>> = Tl,
            read_gr_b(Tl2, 0, 0, NumBytes + TagLen1 + 4, 0, FieldNum)
    end.

read_gr_vi(<<1:1, _:7, Tl/binary>>, N, NumBytes, FieldNum)
  when N < (64-7) ->
    read_gr_vi(Tl, N+7, NumBytes+1, FieldNum);
read_gr_vi(<<0:1, _:7, Tl/binary>>, _, NumBytes, FieldNum) ->
    read_gr_b(Tl, 0, 0, NumBytes+1, 0, FieldNum).

read_gr_ld(<<1:1, X:7, Tl/binary>>, N, Acc, NumBytes, FieldNum)
  when N < (64-7) ->
    read_gr_ld(Tl, N+7, X bsl N + Acc, NumBytes+1, FieldNum);
read_gr_ld(<<0:1, X:7, Tl/binary>>, N, Acc, NumBytes, FieldNum) ->
    Len = X bsl N + Acc,
    NumBytes1 = NumBytes + 1,
    <<_:Len/binary, Tl2/binary>> = Tl,
    read_gr_b(Tl2, 0, 0, NumBytes1 + Len, 0, FieldNum).

merge_msgs(Prev, New)
    when element(1, Prev) =:= element(1, New) ->
    merge_msgs(Prev, New, element(1, Prev), []).

merge_msgs(Prev, New, MsgName) when is_atom(MsgName) ->
    merge_msgs(Prev, New, MsgName, []);
merge_msgs(Prev, New, Opts)
    when element(1, Prev) =:= element(1, New),
	 is_list(Opts) ->
    merge_msgs(Prev, New, element(1, Prev), Opts).

merge_msgs(Prev, New, MsgName, Opts) ->
    TrUserData = proplists:get_value(user_data, Opts),
    case MsgName of
      'LabelPair' ->
	  merge_msg_LabelPair(Prev, New, TrUserData);
      'Gauge' -> merge_msg_Gauge(Prev, New, TrUserData);
      'Counter' -> merge_msg_Counter(Prev, New, TrUserData);
      'Quantile' -> merge_msg_Quantile(Prev, New, TrUserData);
      'Summary' -> merge_msg_Summary(Prev, New, TrUserData);
      'Untyped' -> merge_msg_Untyped(Prev, New, TrUserData);
      'Histogram' ->
	  merge_msg_Histogram(Prev, New, TrUserData);
      'Bucket' -> merge_msg_Bucket(Prev, New, TrUserData);
      'Metric' -> merge_msg_Metric(Prev, New, TrUserData);
      'MetricFamily' ->
	  merge_msg_MetricFamily(Prev, New, TrUserData)
    end.

-compile({nowarn_unused_function,merge_msg_LabelPair/3}).
merge_msg_LabelPair(#'LabelPair'{name = PFname,
				 value = PFvalue},
		    #'LabelPair'{name = NFname, value = NFvalue}, _) ->
    #'LabelPair'{name =
		     if NFname =:= undefined -> PFname;
			true -> NFname
		     end,
		 value =
		     if NFvalue =:= undefined -> PFvalue;
			true -> NFvalue
		     end}.

-compile({nowarn_unused_function,merge_msg_Gauge/3}).
merge_msg_Gauge(#'Gauge'{value = PFvalue},
		#'Gauge'{value = NFvalue}, _) ->
    #'Gauge'{value =
		 if NFvalue =:= undefined -> PFvalue;
		    true -> NFvalue
		 end}.

-compile({nowarn_unused_function,merge_msg_Counter/3}).
merge_msg_Counter(#'Counter'{value = PFvalue},
		  #'Counter'{value = NFvalue}, _) ->
    #'Counter'{value =
		   if NFvalue =:= undefined -> PFvalue;
		      true -> NFvalue
		   end}.

-compile({nowarn_unused_function,merge_msg_Quantile/3}).
merge_msg_Quantile(#'Quantile'{quantile = PFquantile,
			       value = PFvalue},
		   #'Quantile'{quantile = NFquantile, value = NFvalue},
		   _) ->
    #'Quantile'{quantile =
		    if NFquantile =:= undefined -> PFquantile;
		       true -> NFquantile
		    end,
		value =
		    if NFvalue =:= undefined -> PFvalue;
		       true -> NFvalue
		    end}.

-compile({nowarn_unused_function,merge_msg_Summary/3}).
merge_msg_Summary(#'Summary'{sample_count =
				 PFsample_count,
			     sample_sum = PFsample_sum, quantile = PFquantile},
		  #'Summary'{sample_count = NFsample_count,
			     sample_sum = NFsample_sum, quantile = NFquantile},
		  TrUserData) ->
    #'Summary'{sample_count =
		   if NFsample_count =:= undefined -> PFsample_count;
		      true -> NFsample_count
		   end,
	       sample_sum =
		   if NFsample_sum =:= undefined -> PFsample_sum;
		      true -> NFsample_sum
		   end,
	       quantile =
		   if PFquantile /= undefined, NFquantile /= undefined ->
			  'erlang_++'(PFquantile, NFquantile, TrUserData);
		      PFquantile == undefined -> NFquantile;
		      NFquantile == undefined -> PFquantile
		   end}.

-compile({nowarn_unused_function,merge_msg_Untyped/3}).
merge_msg_Untyped(#'Untyped'{value = PFvalue},
		  #'Untyped'{value = NFvalue}, _) ->
    #'Untyped'{value =
		   if NFvalue =:= undefined -> PFvalue;
		      true -> NFvalue
		   end}.

-compile({nowarn_unused_function,merge_msg_Histogram/3}).
merge_msg_Histogram(#'Histogram'{sample_count =
				     PFsample_count,
				 sample_sum = PFsample_sum, bucket = PFbucket},
		    #'Histogram'{sample_count = NFsample_count,
				 sample_sum = NFsample_sum, bucket = NFbucket},
		    TrUserData) ->
    #'Histogram'{sample_count =
		     if NFsample_count =:= undefined -> PFsample_count;
			true -> NFsample_count
		     end,
		 sample_sum =
		     if NFsample_sum =:= undefined -> PFsample_sum;
			true -> NFsample_sum
		     end,
		 bucket =
		     if PFbucket /= undefined, NFbucket /= undefined ->
			    'erlang_++'(PFbucket, NFbucket, TrUserData);
			PFbucket == undefined -> NFbucket;
			NFbucket == undefined -> PFbucket
		     end}.

-compile({nowarn_unused_function,merge_msg_Bucket/3}).
merge_msg_Bucket(#'Bucket'{cumulative_count =
			       PFcumulative_count,
			   upper_bound = PFupper_bound},
		 #'Bucket'{cumulative_count = NFcumulative_count,
			   upper_bound = NFupper_bound},
		 _) ->
    #'Bucket'{cumulative_count =
		  if NFcumulative_count =:= undefined ->
			 PFcumulative_count;
		     true -> NFcumulative_count
		  end,
	      upper_bound =
		  if NFupper_bound =:= undefined -> PFupper_bound;
		     true -> NFupper_bound
		  end}.

-compile({nowarn_unused_function,merge_msg_Metric/3}).
merge_msg_Metric(#'Metric'{label = PFlabel,
			   gauge = PFgauge, counter = PFcounter,
			   summary = PFsummary, untyped = PFuntyped,
			   histogram = PFhistogram,
			   timestamp_ms = PFtimestamp_ms},
		 #'Metric'{label = NFlabel, gauge = NFgauge,
			   counter = NFcounter, summary = NFsummary,
			   untyped = NFuntyped, histogram = NFhistogram,
			   timestamp_ms = NFtimestamp_ms},
		 TrUserData) ->
    #'Metric'{label =
		  if PFlabel /= undefined, NFlabel /= undefined ->
			 'erlang_++'(PFlabel, NFlabel, TrUserData);
		     PFlabel == undefined -> NFlabel;
		     NFlabel == undefined -> PFlabel
		  end,
	      gauge =
		  if PFgauge /= undefined, NFgauge /= undefined ->
			 merge_msg_Gauge(PFgauge, NFgauge, TrUserData);
		     PFgauge == undefined -> NFgauge;
		     NFgauge == undefined -> PFgauge
		  end,
	      counter =
		  if PFcounter /= undefined, NFcounter /= undefined ->
			 merge_msg_Counter(PFcounter, NFcounter, TrUserData);
		     PFcounter == undefined -> NFcounter;
		     NFcounter == undefined -> PFcounter
		  end,
	      summary =
		  if PFsummary /= undefined, NFsummary /= undefined ->
			 merge_msg_Summary(PFsummary, NFsummary, TrUserData);
		     PFsummary == undefined -> NFsummary;
		     NFsummary == undefined -> PFsummary
		  end,
	      untyped =
		  if PFuntyped /= undefined, NFuntyped /= undefined ->
			 merge_msg_Untyped(PFuntyped, NFuntyped, TrUserData);
		     PFuntyped == undefined -> NFuntyped;
		     NFuntyped == undefined -> PFuntyped
		  end,
	      histogram =
		  if PFhistogram /= undefined, NFhistogram /= undefined ->
			 merge_msg_Histogram(PFhistogram, NFhistogram,
					     TrUserData);
		     PFhistogram == undefined -> NFhistogram;
		     NFhistogram == undefined -> PFhistogram
		  end,
	      timestamp_ms =
		  if NFtimestamp_ms =:= undefined -> PFtimestamp_ms;
		     true -> NFtimestamp_ms
		  end}.

-compile({nowarn_unused_function,merge_msg_MetricFamily/3}).
merge_msg_MetricFamily(#'MetricFamily'{name = PFname,
				       help = PFhelp, type = PFtype,
				       metric = PFmetric},
		       #'MetricFamily'{name = NFname, help = NFhelp,
				       type = NFtype, metric = NFmetric},
		       TrUserData) ->
    #'MetricFamily'{name =
			if NFname =:= undefined -> PFname;
			   true -> NFname
			end,
		    help =
			if NFhelp =:= undefined -> PFhelp;
			   true -> NFhelp
			end,
		    type =
			if NFtype =:= undefined -> PFtype;
			   true -> NFtype
			end,
		    metric =
			if PFmetric /= undefined, NFmetric /= undefined ->
			       'erlang_++'(PFmetric, NFmetric, TrUserData);
			   PFmetric == undefined -> NFmetric;
			   NFmetric == undefined -> PFmetric
			end}.


verify_msg(Msg) when tuple_size(Msg) >= 1 ->
    verify_msg(Msg, element(1, Msg), []);
verify_msg(X) ->
    mk_type_error(not_a_known_message, X, []).

verify_msg(Msg, MsgName) when is_atom(MsgName) ->
    verify_msg(Msg, MsgName, []);
verify_msg(Msg, Opts) when tuple_size(Msg) >= 1 ->
    verify_msg(Msg, element(1, Msg), Opts);
verify_msg(X, _Opts) ->
    mk_type_error(not_a_known_message, X, []).

verify_msg(Msg, MsgName, Opts) ->
    TrUserData = proplists:get_value(user_data, Opts),
    case MsgName of
      'LabelPair' ->
	  v_msg_LabelPair(Msg, [MsgName], TrUserData);
      'Gauge' -> v_msg_Gauge(Msg, [MsgName], TrUserData);
      'Counter' -> v_msg_Counter(Msg, [MsgName], TrUserData);
      'Quantile' ->
	  v_msg_Quantile(Msg, [MsgName], TrUserData);
      'Summary' -> v_msg_Summary(Msg, [MsgName], TrUserData);
      'Untyped' -> v_msg_Untyped(Msg, [MsgName], TrUserData);
      'Histogram' ->
	  v_msg_Histogram(Msg, [MsgName], TrUserData);
      'Bucket' -> v_msg_Bucket(Msg, [MsgName], TrUserData);
      'Metric' -> v_msg_Metric(Msg, [MsgName], TrUserData);
      'MetricFamily' ->
	  v_msg_MetricFamily(Msg, [MsgName], TrUserData);
      _ -> mk_type_error(not_a_known_message, Msg, [])
    end.


-compile({nowarn_unused_function,v_msg_LabelPair/3}).
-dialyzer({nowarn_function,v_msg_LabelPair/3}).
v_msg_LabelPair(#'LabelPair'{name = F1, value = F2},
		Path, TrUserData) ->
    if F1 == undefined -> ok;
       true -> v_type_string(F1, [name | Path], TrUserData)
    end,
    if F2 == undefined -> ok;
       true -> v_type_string(F2, [value | Path], TrUserData)
    end,
    ok;
v_msg_LabelPair(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'LabelPair'}, X, Path).

-compile({nowarn_unused_function,v_msg_Gauge/3}).
-dialyzer({nowarn_function,v_msg_Gauge/3}).
v_msg_Gauge(#'Gauge'{value = F1}, Path, TrUserData) ->
    if F1 == undefined -> ok;
       true -> v_type_double(F1, [value | Path], TrUserData)
    end,
    ok;
v_msg_Gauge(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Gauge'}, X, Path).

-compile({nowarn_unused_function,v_msg_Counter/3}).
-dialyzer({nowarn_function,v_msg_Counter/3}).
v_msg_Counter(#'Counter'{value = F1}, Path,
	      TrUserData) ->
    if F1 == undefined -> ok;
       true -> v_type_double(F1, [value | Path], TrUserData)
    end,
    ok;
v_msg_Counter(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Counter'}, X, Path).

-compile({nowarn_unused_function,v_msg_Quantile/3}).
-dialyzer({nowarn_function,v_msg_Quantile/3}).
v_msg_Quantile(#'Quantile'{quantile = F1, value = F2},
	       Path, TrUserData) ->
    if F1 == undefined -> ok;
       true -> v_type_double(F1, [quantile | Path], TrUserData)
    end,
    if F2 == undefined -> ok;
       true -> v_type_double(F2, [value | Path], TrUserData)
    end,
    ok;
v_msg_Quantile(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Quantile'}, X, Path).

-compile({nowarn_unused_function,v_msg_Summary/3}).
-dialyzer({nowarn_function,v_msg_Summary/3}).
v_msg_Summary(#'Summary'{sample_count = F1,
			 sample_sum = F2, quantile = F3},
	      Path, TrUserData) ->
    if F1 == undefined -> ok;
       true ->
	   v_type_uint64(F1, [sample_count | Path], TrUserData)
    end,
    if F2 == undefined -> ok;
       true ->
	   v_type_double(F2, [sample_sum | Path], TrUserData)
    end,
    if is_list(F3) ->
	   _ = [v_msg_Quantile(Elem, [quantile | Path], TrUserData)
		|| Elem <- F3],
	   ok;
       true ->
	   mk_type_error({invalid_list_of, {msg, 'Quantile'}}, F3,
			 [quantile | Path])
    end,
    ok;
v_msg_Summary(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Summary'}, X, Path).

-compile({nowarn_unused_function,v_msg_Untyped/3}).
-dialyzer({nowarn_function,v_msg_Untyped/3}).
v_msg_Untyped(#'Untyped'{value = F1}, Path,
	      TrUserData) ->
    if F1 == undefined -> ok;
       true -> v_type_double(F1, [value | Path], TrUserData)
    end,
    ok;
v_msg_Untyped(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Untyped'}, X, Path).

-compile({nowarn_unused_function,v_msg_Histogram/3}).
-dialyzer({nowarn_function,v_msg_Histogram/3}).
v_msg_Histogram(#'Histogram'{sample_count = F1,
			     sample_sum = F2, bucket = F3},
		Path, TrUserData) ->
    if F1 == undefined -> ok;
       true ->
	   v_type_uint64(F1, [sample_count | Path], TrUserData)
    end,
    if F2 == undefined -> ok;
       true ->
	   v_type_double(F2, [sample_sum | Path], TrUserData)
    end,
    if is_list(F3) ->
	   _ = [v_msg_Bucket(Elem, [bucket | Path], TrUserData)
		|| Elem <- F3],
	   ok;
       true ->
	   mk_type_error({invalid_list_of, {msg, 'Bucket'}}, F3,
			 [bucket | Path])
    end,
    ok;
v_msg_Histogram(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Histogram'}, X, Path).

-compile({nowarn_unused_function,v_msg_Bucket/3}).
-dialyzer({nowarn_function,v_msg_Bucket/3}).
v_msg_Bucket(#'Bucket'{cumulative_count = F1,
		       upper_bound = F2},
	     Path, TrUserData) ->
    if F1 == undefined -> ok;
       true ->
	   v_type_uint64(F1, [cumulative_count | Path], TrUserData)
    end,
    if F2 == undefined -> ok;
       true ->
	   v_type_double(F2, [upper_bound | Path], TrUserData)
    end,
    ok;
v_msg_Bucket(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Bucket'}, X, Path).

-compile({nowarn_unused_function,v_msg_Metric/3}).
-dialyzer({nowarn_function,v_msg_Metric/3}).
v_msg_Metric(#'Metric'{label = F1, gauge = F2,
		       counter = F3, summary = F4, untyped = F5,
		       histogram = F6, timestamp_ms = F7},
	     Path, TrUserData) ->
    if is_list(F1) ->
	   _ = [v_msg_LabelPair(Elem, [label | Path], TrUserData)
		|| Elem <- F1],
	   ok;
       true ->
	   mk_type_error({invalid_list_of, {msg, 'LabelPair'}}, F1,
			 [label | Path])
    end,
    if F2 == undefined -> ok;
       true -> v_msg_Gauge(F2, [gauge | Path], TrUserData)
    end,
    if F3 == undefined -> ok;
       true -> v_msg_Counter(F3, [counter | Path], TrUserData)
    end,
    if F4 == undefined -> ok;
       true -> v_msg_Summary(F4, [summary | Path], TrUserData)
    end,
    if F5 == undefined -> ok;
       true -> v_msg_Untyped(F5, [untyped | Path], TrUserData)
    end,
    if F6 == undefined -> ok;
       true ->
	   v_msg_Histogram(F6, [histogram | Path], TrUserData)
    end,
    if F7 == undefined -> ok;
       true ->
	   v_type_int64(F7, [timestamp_ms | Path], TrUserData)
    end,
    ok;
v_msg_Metric(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'Metric'}, X, Path).

-compile({nowarn_unused_function,v_msg_MetricFamily/3}).
-dialyzer({nowarn_function,v_msg_MetricFamily/3}).
v_msg_MetricFamily(#'MetricFamily'{name = F1, help = F2,
				   type = F3, metric = F4},
		   Path, TrUserData) ->
    if F1 == undefined -> ok;
       true -> v_type_string(F1, [name | Path], TrUserData)
    end,
    if F2 == undefined -> ok;
       true -> v_type_string(F2, [help | Path], TrUserData)
    end,
    if F3 == undefined -> ok;
       true -> v_enum_MetricType(F3, [type | Path], TrUserData)
    end,
    if is_list(F4) ->
	   _ = [v_msg_Metric(Elem, [metric | Path], TrUserData)
		|| Elem <- F4],
	   ok;
       true ->
	   mk_type_error({invalid_list_of, {msg, 'Metric'}}, F4,
			 [metric | Path])
    end,
    ok;
v_msg_MetricFamily(X, Path, _TrUserData) ->
    mk_type_error({expected_msg, 'MetricFamily'}, X, Path).

-compile({nowarn_unused_function,v_enum_MetricType/3}).
-dialyzer({nowarn_function,v_enum_MetricType/3}).
v_enum_MetricType('COUNTER', _Path, _TrUserData) -> ok;
v_enum_MetricType('GAUGE', _Path, _TrUserData) -> ok;
v_enum_MetricType('SUMMARY', _Path, _TrUserData) -> ok;
v_enum_MetricType('UNTYPED', _Path, _TrUserData) -> ok;
v_enum_MetricType('HISTOGRAM', _Path, _TrUserData) ->
    ok;
v_enum_MetricType(V, Path, TrUserData)
    when is_integer(V) ->
    v_type_sint32(V, Path, TrUserData);
v_enum_MetricType(X, Path, _TrUserData) ->
    mk_type_error({invalid_enum, 'MetricType'}, X, Path).

-compile({nowarn_unused_function,v_type_sint32/3}).
-dialyzer({nowarn_function,v_type_sint32/3}).
v_type_sint32(N, _Path, _TrUserData)
    when -2147483648 =< N, N =< 2147483647 ->
    ok;
v_type_sint32(N, Path, _TrUserData)
    when is_integer(N) ->
    mk_type_error({value_out_of_range, sint32, signed, 32},
		  N, Path);
v_type_sint32(X, Path, _TrUserData) ->
    mk_type_error({bad_integer, sint32, signed, 32}, X,
		  Path).

-compile({nowarn_unused_function,v_type_int64/3}).
-dialyzer({nowarn_function,v_type_int64/3}).
v_type_int64(N, _Path, _TrUserData)
    when -9223372036854775808 =< N,
	 N =< 9223372036854775807 ->
    ok;
v_type_int64(N, Path, _TrUserData) when is_integer(N) ->
    mk_type_error({value_out_of_range, int64, signed, 64},
		  N, Path);
v_type_int64(X, Path, _TrUserData) ->
    mk_type_error({bad_integer, int64, signed, 64}, X,
		  Path).

-compile({nowarn_unused_function,v_type_uint64/3}).
-dialyzer({nowarn_function,v_type_uint64/3}).
v_type_uint64(N, _Path, _TrUserData)
    when 0 =< N, N =< 18446744073709551615 ->
    ok;
v_type_uint64(N, Path, _TrUserData)
    when is_integer(N) ->
    mk_type_error({value_out_of_range, uint64, unsigned,
		   64},
		  N, Path);
v_type_uint64(X, Path, _TrUserData) ->
    mk_type_error({bad_integer, uint64, unsigned, 64}, X,
		  Path).

-compile({nowarn_unused_function,v_type_double/3}).
-dialyzer({nowarn_function,v_type_double/3}).
v_type_double(N, _Path, _TrUserData) when is_float(N) ->
    ok;
v_type_double(N, _Path, _TrUserData)
    when is_integer(N) ->
    ok;
v_type_double(infinity, _Path, _TrUserData) -> ok;
v_type_double('-infinity', _Path, _TrUserData) -> ok;
v_type_double(nan, _Path, _TrUserData) -> ok;
v_type_double(X, Path, _TrUserData) ->
    mk_type_error(bad_double_value, X, Path).

-compile({nowarn_unused_function,v_type_string/3}).
-dialyzer({nowarn_function,v_type_string/3}).
v_type_string(S, Path, _TrUserData)
    when is_list(S); is_binary(S) ->
    try unicode:characters_to_binary(S) of
      B when is_binary(B) -> ok;
      {error, _, _} ->
	  mk_type_error(bad_unicode_string, S, Path)
    catch
      error:badarg ->
	  mk_type_error(bad_unicode_string, S, Path)
    end;
v_type_string(X, Path, _TrUserData) ->
    mk_type_error(bad_unicode_string, X, Path).

-compile({nowarn_unused_function,mk_type_error/3}).
-spec mk_type_error(_, _, list()) -> no_return().
mk_type_error(Error, ValueSeen, Path) ->
    Path2 = prettify_path(Path),
    erlang:error({gpb_type_error,
		  {Error, [{value, ValueSeen}, {path, Path2}]}}).


-compile({nowarn_unused_function,prettify_path/1}).
-dialyzer({nowarn_function,prettify_path/1}).
prettify_path([]) -> top_level;
prettify_path(PathR) ->
    list_to_atom(lists:append(lists:join(".",
					 lists:map(fun atom_to_list/1,
						   lists:reverse(PathR))))).


-compile({nowarn_unused_function,id/2}).
-compile({inline,id/2}).
id(X, _TrUserData) -> X.

-compile({nowarn_unused_function,v_ok/3}).
-compile({inline,v_ok/3}).
v_ok(_Value, _Path, _TrUserData) -> ok.

-compile({nowarn_unused_function,m_overwrite/3}).
-compile({inline,m_overwrite/3}).
m_overwrite(_Prev, New, _TrUserData) -> New.

-compile({nowarn_unused_function,cons/3}).
-compile({inline,cons/3}).
cons(Elem, Acc, _TrUserData) -> [Elem | Acc].

-compile({nowarn_unused_function,lists_reverse/2}).
-compile({inline,lists_reverse/2}).
'lists_reverse'(L, _TrUserData) -> lists:reverse(L).
-compile({nowarn_unused_function,'erlang_++'/3}).
-compile({inline,'erlang_++'/3}).
'erlang_++'(A, B, _TrUserData) -> A ++ B.

get_msg_defs() ->
    [{{enum, 'MetricType'},
      [{'COUNTER', 0}, {'GAUGE', 1}, {'SUMMARY', 2},
       {'UNTYPED', 3}, {'HISTOGRAM', 4}]},
     {{msg, 'LabelPair'},
      [[{name, name}, {fnum, 1}, {rnum, 2}, {type, string},
	{occurrence, optional}, {opts, []}],
       [{name, value}, {fnum, 2}, {rnum, 3}, {type, string},
	{occurrence, optional}, {opts, []}]]},
     {{msg, 'Gauge'},
      [[{name, value}, {fnum, 1}, {rnum, 2}, {type, double},
	{occurrence, optional}, {opts, []}]]},
     {{msg, 'Counter'},
      [[{name, value}, {fnum, 1}, {rnum, 2}, {type, double},
	{occurrence, optional}, {opts, []}]]},
     {{msg, 'Quantile'},
      [[{name, quantile}, {fnum, 1}, {rnum, 2},
	{type, double}, {occurrence, optional}, {opts, []}],
       [{name, value}, {fnum, 2}, {rnum, 3}, {type, double},
	{occurrence, optional}, {opts, []}]]},
     {{msg, 'Summary'},
      [[{name, sample_count}, {fnum, 1}, {rnum, 2},
	{type, uint64}, {occurrence, optional}, {opts, []}],
       [{name, sample_sum}, {fnum, 2}, {rnum, 3},
	{type, double}, {occurrence, optional}, {opts, []}],
       [{name, quantile}, {fnum, 3}, {rnum, 4},
	{type, {msg, 'Quantile'}}, {occurrence, repeated},
	{opts, []}]]},
     {{msg, 'Untyped'},
      [[{name, value}, {fnum, 1}, {rnum, 2}, {type, double},
	{occurrence, optional}, {opts, []}]]},
     {{msg, 'Histogram'},
      [[{name, sample_count}, {fnum, 1}, {rnum, 2},
	{type, uint64}, {occurrence, optional}, {opts, []}],
       [{name, sample_sum}, {fnum, 2}, {rnum, 3},
	{type, double}, {occurrence, optional}, {opts, []}],
       [{name, bucket}, {fnum, 3}, {rnum, 4},
	{type, {msg, 'Bucket'}}, {occurrence, repeated},
	{opts, []}]]},
     {{msg, 'Bucket'},
      [[{name, cumulative_count}, {fnum, 1}, {rnum, 2},
	{type, uint64}, {occurrence, optional}, {opts, []}],
       [{name, upper_bound}, {fnum, 2}, {rnum, 3},
	{type, double}, {occurrence, optional}, {opts, []}]]},
     {{msg, 'Metric'},
      [[{name, label}, {fnum, 1}, {rnum, 2},
	{type, {msg, 'LabelPair'}}, {occurrence, repeated},
	{opts, []}],
       [{name, gauge}, {fnum, 2}, {rnum, 3},
	{type, {msg, 'Gauge'}}, {occurrence, optional},
	{opts, []}],
       [{name, counter}, {fnum, 3}, {rnum, 4},
	{type, {msg, 'Counter'}}, {occurrence, optional},
	{opts, []}],
       [{name, summary}, {fnum, 4}, {rnum, 5},
	{type, {msg, 'Summary'}}, {occurrence, optional},
	{opts, []}],
       [{name, untyped}, {fnum, 5}, {rnum, 6},
	{type, {msg, 'Untyped'}}, {occurrence, optional},
	{opts, []}],
       [{name, histogram}, {fnum, 7}, {rnum, 7},
	{type, {msg, 'Histogram'}}, {occurrence, optional},
	{opts, []}],
       [{name, timestamp_ms}, {fnum, 6}, {rnum, 8},
	{type, int64}, {occurrence, optional}, {opts, []}]]},
     {{msg, 'MetricFamily'},
      [[{name, name}, {fnum, 1}, {rnum, 2}, {type, string},
	{occurrence, optional}, {opts, []}],
       [{name, help}, {fnum, 2}, {rnum, 3}, {type, string},
	{occurrence, optional}, {opts, []}],
       [{name, type}, {fnum, 3}, {rnum, 4},
	{type, {enum, 'MetricType'}}, {occurrence, optional},
	{opts, []}],
       [{name, metric}, {fnum, 4}, {rnum, 5},
	{type, {msg, 'Metric'}}, {occurrence, repeated},
	{opts, []}]]}].


get_msg_names() ->
    ['LabelPair', 'Gauge', 'Counter', 'Quantile', 'Summary',
     'Untyped', 'Histogram', 'Bucket', 'Metric',
     'MetricFamily'].


get_group_names() -> [].


get_msg_or_group_names() ->
    ['LabelPair', 'Gauge', 'Counter', 'Quantile', 'Summary',
     'Untyped', 'Histogram', 'Bucket', 'Metric',
     'MetricFamily'].


get_enum_names() -> ['MetricType'].


fetch_msg_def(MsgName) ->
    case find_msg_def(MsgName) of
      Fs when is_list(Fs) -> Fs;
      error -> erlang:error({no_such_msg, MsgName})
    end.


fetch_enum_def(EnumName) ->
    case find_enum_def(EnumName) of
      Es when is_list(Es) -> Es;
      error -> erlang:error({no_such_enum, EnumName})
    end.


find_msg_def('LabelPair') ->
    [[{name, name}, {fnum, 1}, {rnum, 2}, {type, string},
      {occurrence, optional}, {opts, []}],
     [{name, value}, {fnum, 2}, {rnum, 3}, {type, string},
      {occurrence, optional}, {opts, []}]];
find_msg_def('Gauge') ->
    [[{name, value}, {fnum, 1}, {rnum, 2}, {type, double},
      {occurrence, optional}, {opts, []}]];
find_msg_def('Counter') ->
    [[{name, value}, {fnum, 1}, {rnum, 2}, {type, double},
      {occurrence, optional}, {opts, []}]];
find_msg_def('Quantile') ->
    [[{name, quantile}, {fnum, 1}, {rnum, 2},
      {type, double}, {occurrence, optional}, {opts, []}],
     [{name, value}, {fnum, 2}, {rnum, 3}, {type, double},
      {occurrence, optional}, {opts, []}]];
find_msg_def('Summary') ->
    [[{name, sample_count}, {fnum, 1}, {rnum, 2},
      {type, uint64}, {occurrence, optional}, {opts, []}],
     [{name, sample_sum}, {fnum, 2}, {rnum, 3},
      {type, double}, {occurrence, optional}, {opts, []}],
     [{name, quantile}, {fnum, 3}, {rnum, 4},
      {type, {msg, 'Quantile'}}, {occurrence, repeated},
      {opts, []}]];
find_msg_def('Untyped') ->
    [[{name, value}, {fnum, 1}, {rnum, 2}, {type, double},
      {occurrence, optional}, {opts, []}]];
find_msg_def('Histogram') ->
    [[{name, sample_count}, {fnum, 1}, {rnum, 2},
      {type, uint64}, {occurrence, optional}, {opts, []}],
     [{name, sample_sum}, {fnum, 2}, {rnum, 3},
      {type, double}, {occurrence, optional}, {opts, []}],
     [{name, bucket}, {fnum, 3}, {rnum, 4},
      {type, {msg, 'Bucket'}}, {occurrence, repeated},
      {opts, []}]];
find_msg_def('Bucket') ->
    [[{name, cumulative_count}, {fnum, 1}, {rnum, 2},
      {type, uint64}, {occurrence, optional}, {opts, []}],
     [{name, upper_bound}, {fnum, 2}, {rnum, 3},
      {type, double}, {occurrence, optional}, {opts, []}]];
find_msg_def('Metric') ->
    [[{name, label}, {fnum, 1}, {rnum, 2},
      {type, {msg, 'LabelPair'}}, {occurrence, repeated},
      {opts, []}],
     [{name, gauge}, {fnum, 2}, {rnum, 3},
      {type, {msg, 'Gauge'}}, {occurrence, optional},
      {opts, []}],
     [{name, counter}, {fnum, 3}, {rnum, 4},
      {type, {msg, 'Counter'}}, {occurrence, optional},
      {opts, []}],
     [{name, summary}, {fnum, 4}, {rnum, 5},
      {type, {msg, 'Summary'}}, {occurrence, optional},
      {opts, []}],
     [{name, untyped}, {fnum, 5}, {rnum, 6},
      {type, {msg, 'Untyped'}}, {occurrence, optional},
      {opts, []}],
     [{name, histogram}, {fnum, 7}, {rnum, 7},
      {type, {msg, 'Histogram'}}, {occurrence, optional},
      {opts, []}],
     [{name, timestamp_ms}, {fnum, 6}, {rnum, 8},
      {type, int64}, {occurrence, optional}, {opts, []}]];
find_msg_def('MetricFamily') ->
    [[{name, name}, {fnum, 1}, {rnum, 2}, {type, string},
      {occurrence, optional}, {opts, []}],
     [{name, help}, {fnum, 2}, {rnum, 3}, {type, string},
      {occurrence, optional}, {opts, []}],
     [{name, type}, {fnum, 3}, {rnum, 4},
      {type, {enum, 'MetricType'}}, {occurrence, optional},
      {opts, []}],
     [{name, metric}, {fnum, 4}, {rnum, 5},
      {type, {msg, 'Metric'}}, {occurrence, repeated},
      {opts, []}]];
find_msg_def(_) -> error.


find_enum_def('MetricType') ->
    [{'COUNTER', 0}, {'GAUGE', 1}, {'SUMMARY', 2},
     {'UNTYPED', 3}, {'HISTOGRAM', 4}];
find_enum_def(_) -> error.


enum_symbol_by_value('MetricType', Value) ->
    enum_symbol_by_value_MetricType(Value).


enum_value_by_symbol('MetricType', Sym) ->
    enum_value_by_symbol_MetricType(Sym).


enum_symbol_by_value_MetricType(0) -> 'COUNTER';
enum_symbol_by_value_MetricType(1) -> 'GAUGE';
enum_symbol_by_value_MetricType(2) -> 'SUMMARY';
enum_symbol_by_value_MetricType(3) -> 'UNTYPED';
enum_symbol_by_value_MetricType(4) -> 'HISTOGRAM'.


enum_value_by_symbol_MetricType('COUNTER') -> 0;
enum_value_by_symbol_MetricType('GAUGE') -> 1;
enum_value_by_symbol_MetricType('SUMMARY') -> 2;
enum_value_by_symbol_MetricType('UNTYPED') -> 3;
enum_value_by_symbol_MetricType('HISTOGRAM') -> 4.


get_service_names() -> [].


get_service_def(_) -> error.


get_rpc_names(_) -> error.


find_rpc_def(_, _) -> error.



-spec fetch_rpc_def(_, _) -> no_return().
fetch_rpc_def(ServiceName, RpcName) ->
    erlang:error({no_such_rpc, ServiceName, RpcName}).


%% Convert a a fully qualified (ie with package name) service name
%% as a binary to a service name as an atom.
-spec fqbin_to_service_name(_) -> no_return().
fqbin_to_service_name(X) ->
    error({gpb_error, {badservice, X}}).


%% Convert a service name as an atom to a fully qualified

%% (ie with package name) name as a binary.
-spec service_name_to_fqbin(_) -> no_return().
service_name_to_fqbin(X) ->
    error({gpb_error, {badservice, X}}).


%% Convert a a fully qualified (ie with package name) service name
%% and an rpc name, both as binaries to a service name and an rpc
%% name, as atoms.
-spec fqbins_to_service_and_rpc_name(_, _) -> no_return().
fqbins_to_service_and_rpc_name(S, R) ->
    error({gpb_error, {badservice_or_rpc, {S, R}}}).


%% Convert a service name and an rpc name, both as atoms,
%% to a fully qualified (ie with package name) service name and
%% an rpc name as binaries.
-spec service_and_rpc_name_to_fqbins(_, _) -> no_return().
service_and_rpc_name_to_fqbins(S, R) ->
    error({gpb_error, {badservice_or_rpc, {S, R}}}).


get_package_name() -> 'io.prometheus.client'.


%% Whether or not the message names
%% are prepended with package name or not.
uses_packages() -> false.


source_basename() -> "prometheus_model.proto".



gpb_version_as_string() ->
    "4.6.0".

gpb_version_as_list() ->
    [4,6,0].
