; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;
; Test that vector compare / select combinations do not produce any
; unnecessary pack /unpack / shift instructions.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s


define <2 x i8> @fun0(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4) {
; CHECK-LABEL: fun0:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i8> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i8> %val3, <2 x i8> %val4
  ret <2 x i8> %sel
}

define <2 x i16> @fun1(<2 x i8> %val1, <2 x i8> %val2, <2 x i16> %val3, <2 x i16> %val4) {
; CHECK-LABEL: fun1:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i8> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i16> %val3, <2 x i16> %val4
  ret <2 x i16> %sel
}

define <2 x i32> @fun2(<2 x i8> %val1, <2 x i8> %val2, <2 x i32> %val3, <2 x i32> %val4) {
; CHECK-LABEL: fun2:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i8> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i32> %val3, <2 x i32> %val4
  ret <2 x i32> %sel
}

define <2 x i64> @fun3(<2 x i8> %val1, <2 x i8> %val2, <2 x i64> %val3, <2 x i64> %val4) {
; CHECK-LABEL: fun3:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i8> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i64> %val3, <2 x i64> %val4
  ret <2 x i64> %sel
}

define <2 x float> @fun4(<2 x i8> %val1, <2 x i8> %val2, <2 x float> %val3, <2 x float> %val4) {
; CHECK-LABEL: fun4:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i8> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x float> %val3, <2 x float> %val4
  ret <2 x float> %sel
}

define <2 x double> @fun5(<2 x i8> %val1, <2 x i8> %val2, <2 x double> %val3, <2 x double> %val4) {
; CHECK-LABEL: fun5:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i8> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x double> %val3, <2 x double> %val4
  ret <2 x double> %sel
}

define <2 x i8> @fun6(<2 x i16> %val1, <2 x i16> %val2, <2 x i8> %val3, <2 x i8> %val4) {
; CHECK-LABEL: fun6:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i16> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i8> %val3, <2 x i8> %val4
  ret <2 x i8> %sel
}

define <2 x i16> @fun7(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4) {
; CHECK-LABEL: fun7:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i16> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i16> %val3, <2 x i16> %val4
  ret <2 x i16> %sel
}

define <2 x i32> @fun8(<2 x i16> %val1, <2 x i16> %val2, <2 x i32> %val3, <2 x i32> %val4) {
; CHECK-LABEL: fun8:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i16> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i32> %val3, <2 x i32> %val4
  ret <2 x i32> %sel
}

define <2 x i64> @fun9(<2 x i16> %val1, <2 x i16> %val2, <2 x i64> %val3, <2 x i64> %val4) {
; CHECK-LABEL: fun9:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i16> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i64> %val3, <2 x i64> %val4
  ret <2 x i64> %sel
}

define <2 x float> @fun10(<2 x i16> %val1, <2 x i16> %val2, <2 x float> %val3, <2 x float> %val4) {
; CHECK-LABEL: fun10:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i16> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x float> %val3, <2 x float> %val4
  ret <2 x float> %sel
}

define <2 x double> @fun11(<2 x i16> %val1, <2 x i16> %val2, <2 x double> %val3, <2 x double> %val4) {
; CHECK-LABEL: fun11:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i16> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x double> %val3, <2 x double> %val4
  ret <2 x double> %sel
}

define <2 x i8> @fun12(<2 x i32> %val1, <2 x i32> %val2, <2 x i8> %val3, <2 x i8> %val4) {
; CHECK-LABEL: fun12:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI12_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i32> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i8> %val3, <2 x i8> %val4
  ret <2 x i8> %sel
}

define <2 x i16> @fun13(<2 x i32> %val1, <2 x i32> %val2, <2 x i16> %val3, <2 x i16> %val4) {
; CHECK-LABEL: fun13:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i32> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i16> %val3, <2 x i16> %val4
  ret <2 x i16> %sel
}

define <2 x i32> @fun14(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4) {
; CHECK-LABEL: fun14:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i32> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i32> %val3, <2 x i32> %val4
  ret <2 x i32> %sel
}

define <2 x i64> @fun15(<2 x i32> %val1, <2 x i32> %val2, <2 x i64> %val3, <2 x i64> %val4) {
; CHECK-LABEL: fun15:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i32> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i64> %val3, <2 x i64> %val4
  ret <2 x i64> %sel
}

define <2 x float> @fun16(<2 x i32> %val1, <2 x i32> %val2, <2 x float> %val3, <2 x float> %val4) {
; CHECK-LABEL: fun16:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i32> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x float> %val3, <2 x float> %val4
  ret <2 x float> %sel
}

define <2 x double> @fun17(<2 x i32> %val1, <2 x i32> %val2, <2 x double> %val3, <2 x double> %val4) {
; CHECK-LABEL: fun17:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i32> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x double> %val3, <2 x double> %val4
  ret <2 x double> %sel
}

define <2 x i8> @fun18(<2 x i64> %val1, <2 x i64> %val2, <2 x i8> %val3, <2 x i8> %val4) {
; CHECK-LABEL: fun18:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v26
; CHECK-NEXT:    vrepih %v1, 1807
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i64> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i8> %val3, <2 x i8> %val4
  ret <2 x i8> %sel
}

define <2 x i16> @fun19(<2 x i64> %val1, <2 x i64> %val2, <2 x i16> %val3, <2 x i16> %val4) {
; CHECK-LABEL: fun19:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI19_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vceqg %v0, %v24, %v26
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i64> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i16> %val3, <2 x i16> %val4
  ret <2 x i16> %sel
}

define <2 x i32> @fun20(<2 x i64> %val1, <2 x i64> %val2, <2 x i32> %val3, <2 x i32> %val4) {
; CHECK-LABEL: fun20:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i64> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i32> %val3, <2 x i32> %val4
  ret <2 x i32> %sel
}

define <2 x i64> @fun21(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4) {
; CHECK-LABEL: fun21:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i64> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i64> %val3, <2 x i64> %val4
  ret <2 x i64> %sel
}

define <2 x float> @fun22(<2 x i64> %val1, <2 x i64> %val2, <2 x float> %val3, <2 x float> %val4) {
; CHECK-LABEL: fun22:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i64> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x float> %val3, <2 x float> %val4
  ret <2 x float> %sel
}

define <2 x double> @fun23(<2 x i64> %val1, <2 x i64> %val2, <2 x double> %val3, <2 x double> %val4) {
; CHECK-LABEL: fun23:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <2 x i64> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x double> %val3, <2 x double> %val4
  ret <2 x double> %sel
}

define <4 x i8> @fun24(<4 x i8> %val1, <4 x i8> %val2, <4 x i8> %val3, <4 x i8> %val4) {
; CHECK-LABEL: fun24:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i8> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i8> %val3, <4 x i8> %val4
  ret <4 x i8> %sel
}

define <4 x i16> @fun25(<4 x i8> %val1, <4 x i8> %val2, <4 x i16> %val3, <4 x i16> %val4) {
; CHECK-LABEL: fun25:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i8> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i16> %val3, <4 x i16> %val4
  ret <4 x i16> %sel
}

define <4 x i32> @fun26(<4 x i8> %val1, <4 x i8> %val2, <4 x i32> %val3, <4 x i32> %val4) {
; CHECK-LABEL: fun26:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i8> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i32> %val3, <4 x i32> %val4
  ret <4 x i32> %sel
}

define <4 x i64> @fun27(<4 x i8> %val1, <4 x i8> %val2, <4 x i64> %val3, <4 x i64> %val4) {
; CHECK-LABEL: fun27:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i8> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i64> %val3, <4 x i64> %val4
  ret <4 x i64> %sel
}

define <4 x float> @fun28(<4 x i8> %val1, <4 x i8> %val2, <4 x float> %val3, <4 x float> %val4) {
; CHECK-LABEL: fun28:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i8> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x float> %val3, <4 x float> %val4
  ret <4 x float> %sel
}

define <4 x double> @fun29(<4 x i8> %val1, <4 x i8> %val2, <4 x double> %val3, <4 x double> %val4) {
; CHECK-LABEL: fun29:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i8> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x double> %val3, <4 x double> %val4
  ret <4 x double> %sel
}

define <4 x i8> @fun30(<4 x i16> %val1, <4 x i16> %val2, <4 x i8> %val3, <4 x i8> %val4) {
; CHECK-LABEL: fun30:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i16> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i8> %val3, <4 x i8> %val4
  ret <4 x i8> %sel
}

define <4 x i16> @fun31(<4 x i16> %val1, <4 x i16> %val2, <4 x i16> %val3, <4 x i16> %val4) {
; CHECK-LABEL: fun31:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i16> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i16> %val3, <4 x i16> %val4
  ret <4 x i16> %sel
}

define <4 x i32> @fun32(<4 x i16> %val1, <4 x i16> %val2, <4 x i32> %val3, <4 x i32> %val4) {
; CHECK-LABEL: fun32:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i16> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i32> %val3, <4 x i32> %val4
  ret <4 x i32> %sel
}

define <4 x i64> @fun33(<4 x i16> %val1, <4 x i16> %val2, <4 x i64> %val3, <4 x i64> %val4) {
; CHECK-LABEL: fun33:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i16> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i64> %val3, <4 x i64> %val4
  ret <4 x i64> %sel
}

define <4 x float> @fun34(<4 x i16> %val1, <4 x i16> %val2, <4 x float> %val3, <4 x float> %val4) {
; CHECK-LABEL: fun34:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i16> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x float> %val3, <4 x float> %val4
  ret <4 x float> %sel
}

define <4 x double> @fun35(<4 x i16> %val1, <4 x i16> %val2, <4 x double> %val3, <4 x double> %val4) {
; CHECK-LABEL: fun35:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i16> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x double> %val3, <4 x double> %val4
  ret <4 x double> %sel
}

define <4 x i8> @fun36(<4 x i32> %val1, <4 x i32> %val2, <4 x i8> %val3, <4 x i8> %val4) {
; CHECK-LABEL: fun36:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI36_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i32> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i8> %val3, <4 x i8> %val4
  ret <4 x i8> %sel
}

define <4 x i16> @fun37(<4 x i32> %val1, <4 x i32> %val2, <4 x i16> %val3, <4 x i16> %val4) {
; CHECK-LABEL: fun37:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i32> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i16> %val3, <4 x i16> %val4
  ret <4 x i16> %sel
}

define <4 x i32> @fun38(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4) {
; CHECK-LABEL: fun38:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i32> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i32> %val3, <4 x i32> %val4
  ret <4 x i32> %sel
}

define <4 x i64> @fun39(<4 x i32> %val1, <4 x i32> %val2, <4 x i64> %val3, <4 x i64> %val4) {
; CHECK-LABEL: fun39:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i32> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i64> %val3, <4 x i64> %val4
  ret <4 x i64> %sel
}

define <4 x float> @fun40(<4 x i32> %val1, <4 x i32> %val2, <4 x float> %val3, <4 x float> %val4) {
; CHECK-LABEL: fun40:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i32> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x float> %val3, <4 x float> %val4
  ret <4 x float> %sel
}

define <4 x double> @fun41(<4 x i32> %val1, <4 x i32> %val2, <4 x double> %val3, <4 x double> %val4) {
; CHECK-LABEL: fun41:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i32> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x double> %val3, <4 x double> %val4
  ret <4 x double> %sel
}

define <4 x i8> @fun42(<4 x i64> %val1, <4 x i64> %val2, <4 x i8> %val3, <4 x i8> %val4) {
; CHECK-LABEL: fun42:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI42_0
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vceqg %v0, %v26, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i64> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i8> %val3, <4 x i8> %val4
  ret <4 x i8> %sel
}

define <4 x i16> @fun43(<4 x i64> %val1, <4 x i64> %val2, <4 x i16> %val3, <4 x i16> %val4) {
; CHECK-LABEL: fun43:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI43_0
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vceqg %v0, %v26, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i64> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i16> %val3, <4 x i16> %val4
  ret <4 x i16> %sel
}

define <4 x i32> @fun44(<4 x i64> %val1, <4 x i64> %val2, <4 x i32> %val3, <4 x i32> %val4) {
; CHECK-LABEL: fun44:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v26, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i64> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i32> %val3, <4 x i32> %val4
  ret <4 x i32> %sel
}

define <4 x i64> @fun45(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4) {
; CHECK-LABEL: fun45:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vceqg %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i64> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i64> %val3, <4 x i64> %val4
  ret <4 x i64> %sel
}

define <4 x float> @fun46(<4 x i64> %val1, <4 x i64> %val2, <4 x float> %val3, <4 x float> %val4) {
; CHECK-LABEL: fun46:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v26, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i64> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x float> %val3, <4 x float> %val4
  ret <4 x float> %sel
}

define <4 x double> @fun47(<4 x i64> %val1, <4 x i64> %val2, <4 x double> %val3, <4 x double> %val4) {
; CHECK-LABEL: fun47:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vceqg %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <4 x i64> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x double> %val3, <4 x double> %val4
  ret <4 x double> %sel
}

define <8 x i8> @fun48(<8 x i8> %val1, <8 x i8> %val2, <8 x i8> %val3, <8 x i8> %val4) {
; CHECK-LABEL: fun48:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i8> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i8> %val3, <8 x i8> %val4
  ret <8 x i8> %sel
}

define <8 x i16> @fun49(<8 x i8> %val1, <8 x i8> %val2, <8 x i16> %val3, <8 x i16> %val4) {
; CHECK-LABEL: fun49:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i8> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i16> %val3, <8 x i16> %val4
  ret <8 x i16> %sel
}

define <8 x i32> @fun50(<8 x i8> %val1, <8 x i8> %val2, <8 x i32> %val3, <8 x i32> %val4) {
; CHECK-LABEL: fun50:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i8> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i32> %val3, <8 x i32> %val4
  ret <8 x i32> %sel
}

define <8 x i64> @fun51(<8 x i8> %val1, <8 x i8> %val2, <8 x i64> %val3, <8 x i64> %val4) {
; CHECK-LABEL: fun51:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v29, %v1
; CHECK-NEXT:    vpkf %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v31, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 6
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v27, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i8> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i64> %val3, <8 x i64> %val4
  ret <8 x i64> %sel
}

define <8 x float> @fun52(<8 x i8> %val1, <8 x i8> %val2, <8 x float> %val3, <8 x float> %val4) {
; CHECK-LABEL: fun52:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i8> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x float> %val3, <8 x float> %val4
  ret <8 x float> %sel
}

define <8 x double> @fun53(<8 x i8> %val1, <8 x i8> %val2, <8 x double> %val3, <8 x double> %val4) {
; CHECK-LABEL: fun53:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v29, %v1
; CHECK-NEXT:    vpkf %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v31, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 6
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v27, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i8> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x double> %val3, <8 x double> %val4
  ret <8 x double> %sel
}

define <8 x i8> @fun54(<8 x i16> %val1, <8 x i16> %val2, <8 x i8> %val3, <8 x i8> %val4) {
; CHECK-LABEL: fun54:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i16> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i8> %val3, <8 x i8> %val4
  ret <8 x i8> %sel
}

define <8 x i16> @fun55(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4) {
; CHECK-LABEL: fun55:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i16> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i16> %val3, <8 x i16> %val4
  ret <8 x i16> %sel
}

define <8 x i32> @fun56(<8 x i16> %val1, <8 x i16> %val2, <8 x i32> %val3, <8 x i32> %val4) {
; CHECK-LABEL: fun56:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i16> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i32> %val3, <8 x i32> %val4
  ret <8 x i32> %sel
}

define <8 x i64> @fun57(<8 x i16> %val1, <8 x i16> %val2, <8 x i64> %val3, <8 x i64> %val4) {
; CHECK-LABEL: fun57:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v29, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v31, %v1
; CHECK-NEXT:    vmrlg %v1, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v27, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i16> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i64> %val3, <8 x i64> %val4
  ret <8 x i64> %sel
}

define <8 x float> @fun58(<8 x i16> %val1, <8 x i16> %val2, <8 x float> %val3, <8 x float> %val4) {
; CHECK-LABEL: fun58:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i16> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x float> %val3, <8 x float> %val4
  ret <8 x float> %sel
}

define <8 x double> @fun59(<8 x i16> %val1, <8 x i16> %val2, <8 x double> %val3, <8 x double> %val4) {
; CHECK-LABEL: fun59:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v29, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v31, %v1
; CHECK-NEXT:    vmrlg %v1, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v27, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i16> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x double> %val3, <8 x double> %val4
  ret <8 x double> %sel
}

define <8 x i8> @fun60(<8 x i32> %val1, <8 x i32> %val2, <8 x i8> %val3, <8 x i8> %val4) {
; CHECK-LABEL: fun60:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI60_0
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vceqf %v0, %v26, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i32> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i8> %val3, <8 x i8> %val4
  ret <8 x i8> %sel
}

define <8 x i16> @fun61(<8 x i32> %val1, <8 x i32> %val2, <8 x i16> %val3, <8 x i16> %val4) {
; CHECK-LABEL: fun61:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v26, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i32> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i16> %val3, <8 x i16> %val4
  ret <8 x i16> %sel
}

define <8 x i32> @fun62(<8 x i32> %val1, <8 x i32> %val2, <8 x i32> %val3, <8 x i32> %val4) {
; CHECK-LABEL: fun62:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vceqf %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i32> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i32> %val3, <8 x i32> %val4
  ret <8 x i32> %sel
}

define <8 x i64> @fun63(<8 x i32> %val1, <8 x i32> %val2, <8 x i64> %val3, <8 x i64> %val4) {
; CHECK-LABEL: fun63:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v28
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vceqf %v1, %v26, %v30
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v26, %v27, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i32> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i64> %val3, <8 x i64> %val4
  ret <8 x i64> %sel
}

define <8 x float> @fun64(<8 x i32> %val1, <8 x i32> %val2, <8 x float> %val3, <8 x float> %val4) {
; CHECK-LABEL: fun64:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vceqf %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i32> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x float> %val3, <8 x float> %val4
  ret <8 x float> %sel
}

define <8 x double> @fun65(<8 x i32> %val1, <8 x i32> %val2, <8 x double> %val3, <8 x double> %val4) {
; CHECK-LABEL: fun65:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v24, %v28
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vceqf %v1, %v26, %v30
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v26, %v27, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i32> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x double> %val3, <8 x double> %val4
  ret <8 x double> %sel
}

define <8 x i8> @fun66(<8 x i64> %val1, <8 x i64> %val2, <8 x i8> %val3, <8 x i8> %val4) {
; CHECK-LABEL: fun66:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v30, %v31
; CHECK-NEXT:    vceqg %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v26, %v27
; CHECK-NEXT:    vceqg %v2, %v24, %v25
; CHECK-NEXT:    larl %r1, .LCPI66_0
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vlrepg %v1, 168(%r15)
; CHECK-NEXT:    vlrepg %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i64> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i8> %val3, <8 x i8> %val4
  ret <8 x i8> %sel
}

define <8 x i16> @fun67(<8 x i64> %val1, <8 x i64> %val2, <8 x i16> %val3, <8 x i16> %val4) {
; CHECK-LABEL: fun67:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v30, %v31
; CHECK-NEXT:    vceqg %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v26, %v27
; CHECK-NEXT:    vceqg %v2, %v24, %v25
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i64> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i16> %val3, <8 x i16> %val4
  ret <8 x i16> %sel
}

define <8 x i32> @fun68(<8 x i64> %val1, <8 x i64> %val2, <8 x i32> %val3, <8 x i32> %val4) {
; CHECK-LABEL: fun68:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v26, %v27
; CHECK-NEXT:    vceqg %v1, %v24, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqg %v0, %v30, %v31
; CHECK-NEXT:    vceqg %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i64> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i32> %val3, <8 x i32> %val4
  ret <8 x i32> %sel
}

define <8 x i64> @fun69(<8 x i64> %val1, <8 x i64> %val2, <8 x i64> %val3, <8 x i64> %val4) {
; CHECK-LABEL: fun69:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v24, %v25
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqg %v0, %v26, %v27
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v28, %v29
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v31
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i64> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i64> %val3, <8 x i64> %val4
  ret <8 x i64> %sel
}

define <8 x float> @fun70(<8 x i64> %val1, <8 x i64> %val2, <8 x float> %val3, <8 x float> %val4) {
; CHECK-LABEL: fun70:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v26, %v27
; CHECK-NEXT:    vceqg %v1, %v24, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqg %v0, %v30, %v31
; CHECK-NEXT:    vceqg %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i64> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x float> %val3, <8 x float> %val4
  ret <8 x float> %sel
}

define <8 x double> @fun71(<8 x i64> %val1, <8 x i64> %val2, <8 x double> %val3, <8 x double> %val4) {
; CHECK-LABEL: fun71:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v24, %v25
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqg %v0, %v26, %v27
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v28, %v29
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v31
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <8 x i64> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x double> %val3, <8 x double> %val4
  ret <8 x double> %sel
}

define <16 x i8> @fun72(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4) {
; CHECK-LABEL: fun72:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i8> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i8> %val3, <16 x i8> %val4
  ret <16 x i8> %sel
}

define <16 x i16> @fun73(<16 x i8> %val1, <16 x i8> %val2, <16 x i16> %val3, <16 x i16> %val4) {
; CHECK-LABEL: fun73:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i8> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i16> %val3, <16 x i16> %val4
  ret <16 x i16> %sel
}

define <16 x i32> @fun74(<16 x i8> %val1, <16 x i8> %val2, <16 x i32> %val3, <16 x i32> %val4) {
; CHECK-LABEL: fun74:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v29, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v31, %v1
; CHECK-NEXT:    vmrlg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v27, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i8> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i32> %val3, <16 x i32> %val4
  ret <16 x i32> %sel
}

define <16 x i64> @fun75(<16 x i8> %val1, <16 x i8> %val2, <16 x i64> %val3, <16 x i64> %val4) {
; CHECK-LABEL: fun75:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v2, %v1
; CHECK-NEXT:    vpkf %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v2, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vsldb %v1, %v0, %v0, 6
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v30, %v27, %v2, %v1
; CHECK-NEXT:    vl %v2, 256(%r15)
; CHECK-NEXT:    vmrlg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v25, %v29, %v2, %v1
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vsldb %v1, %v0, %v0, 10
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v27, %v31, %v2, %v1
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsldb %v1, %v0, %v0, 12
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 14
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i8> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i64> %val3, <16 x i64> %val4
  ret <16 x i64> %sel
}

define <16 x float> @fun76(<16 x i8> %val1, <16 x i8> %val2, <16 x float> %val3, <16 x float> %val4) {
; CHECK-LABEL: fun76:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v29, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v31, %v1
; CHECK-NEXT:    vmrlg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v27, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i8> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x float> %val3, <16 x float> %val4
  ret <16 x float> %sel
}

define <16 x double> @fun77(<16 x i8> %val1, <16 x i8> %val2, <16 x double> %val3, <16 x double> %val4) {
; CHECK-LABEL: fun77:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v2, %v1
; CHECK-NEXT:    vpkf %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v2, %v1
; CHECK-NEXT:    vpkg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vsel %v28, %v25, %v2, %v1
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vsldb %v1, %v0, %v0, 6
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v30, %v27, %v2, %v1
; CHECK-NEXT:    vl %v2, 256(%r15)
; CHECK-NEXT:    vmrlg %v1, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v25, %v29, %v2, %v1
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vsldb %v1, %v0, %v0, 10
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v27, %v31, %v2, %v1
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsldb %v1, %v0, %v0, 12
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 14
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i8> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x double> %val3, <16 x double> %val4
  ret <16 x double> %sel
}

define <16 x i8> @fun78(<16 x i16> %val1, <16 x i16> %val2, <16 x i8> %val3, <16 x i8> %val4) {
; CHECK-LABEL: fun78:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v26, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i16> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i8> %val3, <16 x i8> %val4
  ret <16 x i8> %sel
}

define <16 x i16> @fun79(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4) {
; CHECK-LABEL: fun79:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vceqh %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i16> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i16> %val3, <16 x i16> %val4
  ret <16 x i16> %sel
}

define <16 x i32> @fun80(<16 x i16> %val1, <16 x i16> %val2, <16 x i32> %val3, <16 x i32> %val4) {
; CHECK-LABEL: fun80:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v28
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v26, %v27, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i16> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i32> %val3, <16 x i32> %val4
  ret <16 x i32> %sel
}

define <16 x i64> @fun81(<16 x i16> %val1, <16 x i16> %val2, <16 x i64> %val3, <16 x i64> %val4) {
; CHECK-LABEL: fun81:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v28
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vl %v3, 288(%r15)
; CHECK-NEXT:    vl %v4, 160(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v25, %v4, %v3, %v2
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v26, %v27, %v3, %v2
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v2, %v0
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vsldb %v0, %v1, %v1, 12
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i16> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i64> %val3, <16 x i64> %val4
  ret <16 x i64> %sel
}

define <16 x float> @fun82(<16 x i16> %val1, <16 x i16> %val2, <16 x float> %val3, <16 x float> %val4) {
; CHECK-LABEL: fun82:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v28
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v26, %v27, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i16> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x float> %val3, <16 x float> %val4
  ret <16 x float> %sel
}

define <16 x double> @fun83(<16 x i16> %val1, <16 x i16> %val2, <16 x double> %val3, <16 x double> %val4) {
; CHECK-LABEL: fun83:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v24, %v28
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vl %v3, 288(%r15)
; CHECK-NEXT:    vl %v4, 160(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v25, %v4, %v3, %v2
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v26, %v27, %v3, %v2
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v2, %v0
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vsldb %v0, %v1, %v1, 12
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i16> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x double> %val3, <16 x double> %val4
  ret <16 x double> %sel
}

define <16 x i8> @fun84(<16 x i32> %val1, <16 x i32> %val2, <16 x i8> %val3, <16 x i8> %val4) {
; CHECK-LABEL: fun84:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vceqf %v1, %v28, %v29
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v26, %v27
; CHECK-NEXT:    vceqf %v2, %v24, %v25
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i32> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i8> %val3, <16 x i8> %val4
  ret <16 x i8> %sel
}

define <16 x i16> @fun85(<16 x i32> %val1, <16 x i32> %val2, <16 x i16> %val3, <16 x i16> %val4) {
; CHECK-LABEL: fun85:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v26, %v27
; CHECK-NEXT:    vceqf %v1, %v24, %v25
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vceqf %v1, %v28, %v29
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i32> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i16> %val3, <16 x i16> %val4
  ret <16 x i16> %sel
}

define <16 x i32> @fun86(<16 x i32> %val1, <16 x i32> %val2, <16 x i32> %val3, <16 x i32> %val4) {
; CHECK-LABEL: fun86:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqf %v0, %v24, %v25
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqf %v0, %v26, %v27
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vceqf %v0, %v28, %v29
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i32> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i32> %val3, <16 x i32> %val4
  ret <16 x i32> %sel
}

define <16 x i64> @fun87(<16 x i32> %val1, <16 x i32> %val2, <16 x i64> %val3, <16 x i64> %val4) {
; CHECK-LABEL: fun87:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v24, %v25
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphf %v0, %v1
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vceqf %v2, %v26, %v27
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v0, %v2
; CHECK-NEXT:    vsel %v0, %v4, %v3, %v0
; CHECK-NEXT:    vceqf %v3, %v28, %v29
; CHECK-NEXT:    vl %v5, 352(%r15)
; CHECK-NEXT:    vl %v6, 224(%r15)
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vceqf %v4, %v30, %v31
; CHECK-NEXT:    vl %v6, 384(%r15)
; CHECK-NEXT:    vl %v7, 256(%r15)
; CHECK-NEXT:    vuphf %v5, %v4
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v29, %v7, %v6, %v5
; CHECK-NEXT:    vl %v5, 304(%r15)
; CHECK-NEXT:    vl %v6, 176(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v6, %v5, %v1
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vl %v5, 208(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v30, %v5, %v2, %v1
; CHECK-NEXT:    vmrlg %v1, %v3, %v3
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vlr %v28, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v1, %v4, %v4
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i32> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i64> %val3, <16 x i64> %val4
  ret <16 x i64> %sel
}

define <16 x float> @fun88(<16 x i32> %val1, <16 x i32> %val2, <16 x float> %val3, <16 x float> %val4) {
; CHECK-LABEL: fun88:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqf %v0, %v24, %v25
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqf %v0, %v26, %v27
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vceqf %v0, %v28, %v29
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i32> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x float> %val3, <16 x float> %val4
  ret <16 x float> %sel
}

define <16 x double> @fun89(<16 x i32> %val1, <16 x i32> %val2, <16 x double> %val3, <16 x double> %val4) {
; CHECK-LABEL: fun89:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v24, %v25
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphf %v0, %v1
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vceqf %v2, %v26, %v27
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v0, %v2
; CHECK-NEXT:    vsel %v0, %v4, %v3, %v0
; CHECK-NEXT:    vceqf %v3, %v28, %v29
; CHECK-NEXT:    vl %v5, 352(%r15)
; CHECK-NEXT:    vl %v6, 224(%r15)
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vceqf %v4, %v30, %v31
; CHECK-NEXT:    vl %v6, 384(%r15)
; CHECK-NEXT:    vl %v7, 256(%r15)
; CHECK-NEXT:    vuphf %v5, %v4
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v29, %v7, %v6, %v5
; CHECK-NEXT:    vl %v5, 304(%r15)
; CHECK-NEXT:    vl %v6, 176(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v26, %v6, %v5, %v1
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vl %v5, 208(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v30, %v5, %v2, %v1
; CHECK-NEXT:    vmrlg %v1, %v3, %v3
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vlr %v28, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v1, %v4, %v4
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i32> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x double> %val3, <16 x double> %val4
  ret <16 x double> %sel
}

define <16 x i8> @fun90(<16 x i64> %val1, <16 x i64> %val2, <16 x i8> %val3, <16 x i8> %val4) {
; CHECK-LABEL: fun90:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vceqg %v1, %v27, %v1
; CHECK-NEXT:    vceqg %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vceqg %v1, %v30, %v1
; CHECK-NEXT:    vceqg %v2, %v28, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vceqg %v2, %v26, %v2
; CHECK-NEXT:    vceqg %v3, %v24, %v3
; CHECK-NEXT:    vpkg %v2, %v3, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i64> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i8> %val3, <16 x i8> %val4
  ret <16 x i8> %sel
}

define <16 x i16> @fun91(<16 x i64> %val1, <16 x i64> %val2, <16 x i16> %val3, <16 x i16> %val4) {
; CHECK-LABEL: fun91:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v0
; CHECK-NEXT:    vceqg %v1, %v28, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqg %v1, %v26, %v1
; CHECK-NEXT:    vceqg %v2, %v24, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vceqg %v1, %v27, %v1
; CHECK-NEXT:    vceqg %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i64> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i16> %val3, <16 x i16> %val4
  ret <16 x i16> %sel
}

define <16 x i32> @fun92(<16 x i64> %val1, <16 x i64> %val2, <16 x i32> %val3, <16 x i32> %val4) {
; CHECK-LABEL: fun92:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v26, %v0
; CHECK-NEXT:    vceqg %v1, %v24, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 352(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v0
; CHECK-NEXT:    vceqg %v1, %v28, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 368(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 384(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i64> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i32> %val3, <16 x i32> %val4
  ret <16 x i32> %sel
}

define <16 x i64> @fun93(<16 x i64> %val1, <16 x i64> %val2, <16 x i64> %val3, <16 x i64> %val4) {
; CHECK-LABEL: fun93:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vl %v1, 416(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vceqg %v0, %v24, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vceqg %v0, %v26, %v0
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vl %v1, 448(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vceqg %v0, %v28, %v0
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 224(%r15)
; CHECK-NEXT:    vl %v1, 480(%r15)
; CHECK-NEXT:    vl %v2, 352(%r15)
; CHECK-NEXT:    vceqg %v0, %v25, %v0
; CHECK-NEXT:    vsel %v25, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 496(%r15)
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v29, %v0
; CHECK-NEXT:    vl %v1, 512(%r15)
; CHECK-NEXT:    vl %v2, 384(%r15)
; CHECK-NEXT:    vsel %v29, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vl %v1, 528(%r15)
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i64> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i64> %val3, <16 x i64> %val4
  ret <16 x i64> %sel
}

define <16 x float> @fun94(<16 x i64> %val1, <16 x i64> %val2, <16 x float> %val3, <16 x float> %val4) {
; CHECK-LABEL: fun94:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v26, %v0
; CHECK-NEXT:    vceqg %v1, %v24, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 352(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v0
; CHECK-NEXT:    vceqg %v1, %v28, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 368(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 384(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i64> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x float> %val3, <16 x float> %val4
  ret <16 x float> %sel
}

define <16 x double> @fun95(<16 x i64> %val1, <16 x i64> %val2, <16 x double> %val3, <16 x double> %val4) {
; CHECK-LABEL: fun95:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vl %v1, 416(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vceqg %v0, %v24, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vceqg %v0, %v26, %v0
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vl %v1, 448(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vceqg %v0, %v28, %v0
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vceqg %v0, %v30, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 224(%r15)
; CHECK-NEXT:    vl %v1, 480(%r15)
; CHECK-NEXT:    vl %v2, 352(%r15)
; CHECK-NEXT:    vceqg %v0, %v25, %v0
; CHECK-NEXT:    vsel %v25, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 496(%r15)
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v29, %v0
; CHECK-NEXT:    vl %v1, 512(%r15)
; CHECK-NEXT:    vl %v2, 384(%r15)
; CHECK-NEXT:    vsel %v29, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vl %v1, 528(%r15)
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = icmp eq <16 x i64> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x double> %val3, <16 x double> %val4
  ret <16 x double> %sel
}

define <2 x i8> @fun96(<2 x float> %val1, <2 x float> %val2, <2 x i8> %val3, <2 x i8> %val4) {
; CHECK-LABEL: fun96:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    larl %r1, .LCPI96_0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x float> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i8> %val3, <2 x i8> %val4
  ret <2 x i8> %sel
}

define <2 x i16> @fun97(<2 x float> %val1, <2 x float> %val2, <2 x i16> %val3, <2 x i16> %val4) {
; CHECK-LABEL: fun97:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x float> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i16> %val3, <2 x i16> %val4
  ret <2 x i16> %sel
}

define <2 x i32> @fun98(<2 x float> %val1, <2 x float> %val2, <2 x i32> %val3, <2 x i32> %val4) {
; CHECK-LABEL: fun98:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x float> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i32> %val3, <2 x i32> %val4
  ret <2 x i32> %sel
}

define <2 x i64> @fun99(<2 x float> %val1, <2 x float> %val2, <2 x i64> %val3, <2 x i64> %val4) {
; CHECK-LABEL: fun99:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x float> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i64> %val3, <2 x i64> %val4
  ret <2 x i64> %sel
}

define <2 x float> @fun100(<2 x float> %val1, <2 x float> %val2, <2 x float> %val3, <2 x float> %val4) {
; CHECK-LABEL: fun100:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x float> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x float> %val3, <2 x float> %val4
  ret <2 x float> %sel
}

define <2 x double> @fun101(<2 x float> %val1, <2 x float> %val2, <2 x double> %val3, <2 x double> %val4) {
; CHECK-LABEL: fun101:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x float> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x double> %val3, <2 x double> %val4
  ret <2 x double> %sel
}

define <2 x i8> @fun102(<2 x double> %val1, <2 x double> %val2, <2 x i8> %val3, <2 x i8> %val4) {
; CHECK-LABEL: fun102:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v26
; CHECK-NEXT:    vrepih %v1, 1807
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x double> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i8> %val3, <2 x i8> %val4
  ret <2 x i8> %sel
}

define <2 x i16> @fun103(<2 x double> %val1, <2 x double> %val2, <2 x i16> %val3, <2 x i16> %val4) {
; CHECK-LABEL: fun103:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI103_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vfchdb %v0, %v24, %v26
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x double> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i16> %val3, <2 x i16> %val4
  ret <2 x i16> %sel
}

define <2 x i32> @fun104(<2 x double> %val1, <2 x double> %val2, <2 x i32> %val3, <2 x i32> %val4) {
; CHECK-LABEL: fun104:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x double> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i32> %val3, <2 x i32> %val4
  ret <2 x i32> %sel
}

define <2 x i64> @fun105(<2 x double> %val1, <2 x double> %val2, <2 x i64> %val3, <2 x i64> %val4) {
; CHECK-LABEL: fun105:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x double> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x i64> %val3, <2 x i64> %val4
  ret <2 x i64> %sel
}

define <2 x float> @fun106(<2 x double> %val1, <2 x double> %val2, <2 x float> %val3, <2 x float> %val4) {
; CHECK-LABEL: fun106:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x double> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x float> %val3, <2 x float> %val4
  ret <2 x float> %sel
}

define <2 x double> @fun107(<2 x double> %val1, <2 x double> %val2, <2 x double> %val3, <2 x double> %val4) {
; CHECK-LABEL: fun107:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <2 x double> %val1, %val2
  %sel = select <2 x i1> %cmp, <2 x double> %val3, <2 x double> %val4
  ret <2 x double> %sel
}

define <4 x i8> @fun108(<4 x float> %val1, <4 x float> %val2, <4 x i8> %val3, <4 x i8> %val4) {
; CHECK-LABEL: fun108:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    larl %r1, .LCPI108_0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x float> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i8> %val3, <4 x i8> %val4
  ret <4 x i8> %sel
}

define <4 x i16> @fun109(<4 x float> %val1, <4 x float> %val2, <4 x i16> %val3, <4 x i16> %val4) {
; CHECK-LABEL: fun109:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x float> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i16> %val3, <4 x i16> %val4
  ret <4 x i16> %sel
}

define <4 x i32> @fun110(<4 x float> %val1, <4 x float> %val2, <4 x i32> %val3, <4 x i32> %val4) {
; CHECK-LABEL: fun110:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x float> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i32> %val3, <4 x i32> %val4
  ret <4 x i32> %sel
}

define <4 x i64> @fun111(<4 x float> %val1, <4 x float> %val2, <4 x i64> %val3, <4 x i64> %val4) {
; CHECK-LABEL: fun111:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x float> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i64> %val3, <4 x i64> %val4
  ret <4 x i64> %sel
}

define <4 x float> @fun112(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4) {
; CHECK-LABEL: fun112:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v30, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x float> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x float> %val3, <4 x float> %val4
  ret <4 x float> %sel
}

define <4 x double> @fun113(<4 x float> %val1, <4 x float> %val2, <4 x double> %val3, <4 x double> %val4) {
; CHECK-LABEL: fun113:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v28, %v25, %v1
; CHECK-NEXT:    vsel %v26, %v30, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x float> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x double> %val3, <4 x double> %val4
  ret <4 x double> %sel
}

define <4 x i8> @fun114(<4 x double> %val1, <4 x double> %val2, <4 x i8> %val3, <4 x i8> %val4) {
; CHECK-LABEL: fun114:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI114_0
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vfchdb %v0, %v26, %v30
; CHECK-NEXT:    vfchdb %v1, %v24, %v28
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x double> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i8> %val3, <4 x i8> %val4
  ret <4 x i8> %sel
}

define <4 x i16> @fun115(<4 x double> %val1, <4 x double> %val2, <4 x i16> %val3, <4 x i16> %val4) {
; CHECK-LABEL: fun115:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI115_0
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vfchdb %v0, %v26, %v30
; CHECK-NEXT:    vfchdb %v1, %v24, %v28
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x double> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i16> %val3, <4 x i16> %val4
  ret <4 x i16> %sel
}

define <4 x i32> @fun116(<4 x double> %val1, <4 x double> %val2, <4 x i32> %val3, <4 x i32> %val4) {
; CHECK-LABEL: fun116:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v26, %v30
; CHECK-NEXT:    vfchdb %v1, %v24, %v28
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x double> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i32> %val3, <4 x i32> %val4
  ret <4 x i32> %sel
}

define <4 x i64> @fun117(<4 x double> %val1, <4 x double> %val2, <4 x i64> %val3, <4 x i64> %val4) {
; CHECK-LABEL: fun117:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vfchdb %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x double> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x i64> %val3, <4 x i64> %val4
  ret <4 x i64> %sel
}

define <4 x float> @fun118(<4 x double> %val1, <4 x double> %val2, <4 x float> %val3, <4 x float> %val4) {
; CHECK-LABEL: fun118:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v26, %v30
; CHECK-NEXT:    vfchdb %v1, %v24, %v28
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x double> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x float> %val3, <4 x float> %val4
  ret <4 x float> %sel
}

define <4 x double> @fun119(<4 x double> %val1, <4 x double> %val2, <4 x double> %val3, <4 x double> %val4) {
; CHECK-LABEL: fun119:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vfchdb %v0, %v26, %v30
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <4 x double> %val1, %val2
  %sel = select <4 x i1> %cmp, <4 x double> %val3, <4 x double> %val4
  ret <4 x double> %sel
}

define <8 x i8> @fun120(<8 x float> %val1, <8 x float> %val2, <8 x i8> %val3, <8 x i8> %val4) {
; CHECK-LABEL: fun120:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    larl %r1, .LCPI120_0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x float> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i8> %val3, <8 x i8> %val4
  ret <8 x i8> %sel
}

define <8 x i16> @fun121(<8 x float> %val1, <8 x float> %val2, <8 x i16> %val3, <8 x i16> %val4) {
; CHECK-LABEL: fun121:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x float> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i16> %val3, <8 x i16> %val4
  ret <8 x i16> %sel
}

define <8 x i32> @fun122(<8 x float> %val1, <8 x float> %val2, <8 x i32> %val3, <8 x i32> %val4) {
; CHECK-LABEL: fun122:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x float> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i32> %val3, <8 x i32> %val4
  ret <8 x i32> %sel
}

define <8 x i64> @fun123(<8 x float> %val1, <8 x float> %val2, <8 x i64> %val3, <8 x i64> %val4) {
; CHECK-LABEL: fun123:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v27, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x float> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i64> %val3, <8 x i64> %val4
  ret <8 x i64> %sel
}

define <8 x float> @fun124(<8 x float> %val1, <8 x float> %val2, <8 x float> %val3, <8 x float> %val4) {
; CHECK-LABEL: fun124:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v0
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x float> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x float> %val3, <8 x float> %val4
  ret <8 x float> %sel
}

define <8 x double> @fun125(<8 x float> %val1, <8 x float> %val2, <8 x double> %val3, <8 x double> %val4) {
; CHECK-LABEL: fun125:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v27, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x float> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x double> %val3, <8 x double> %val4
  ret <8 x double> %sel
}

define <8 x i8> @fun126(<8 x double> %val1, <8 x double> %val2, <8 x i8> %val3, <8 x i8> %val4) {
; CHECK-LABEL: fun126:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v26, %v27
; CHECK-NEXT:    vfchdb %v2, %v24, %v25
; CHECK-NEXT:    larl %r1, .LCPI126_0
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v1, %v0, %v2
; CHECK-NEXT:    vlrepg %v1, 168(%r15)
; CHECK-NEXT:    vlrepg %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x double> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i8> %val3, <8 x i8> %val4
  ret <8 x i8> %sel
}

define <8 x i16> @fun127(<8 x double> %val1, <8 x double> %val2, <8 x i16> %val3, <8 x i16> %val4) {
; CHECK-LABEL: fun127:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v26, %v27
; CHECK-NEXT:    vfchdb %v2, %v24, %v25
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x double> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i16> %val3, <8 x i16> %val4
  ret <8 x i16> %sel
}

define <8 x i32> @fun128(<8 x double> %val1, <8 x double> %val2, <8 x i32> %val3, <8 x i32> %val4) {
; CHECK-LABEL: fun128:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v26, %v27
; CHECK-NEXT:    vfchdb %v1, %v24, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x double> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i32> %val3, <8 x i32> %val4
  ret <8 x i32> %sel
}

define <8 x i64> @fun129(<8 x double> %val1, <8 x double> %val2, <8 x i64> %val3, <8 x i64> %val4) {
; CHECK-LABEL: fun129:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v24, %v25
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v26, %v27
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v28, %v29
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x double> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x i64> %val3, <8 x i64> %val4
  ret <8 x i64> %sel
}

define <8 x float> @fun130(<8 x double> %val1, <8 x double> %val2, <8 x float> %val3, <8 x float> %val4) {
; CHECK-LABEL: fun130:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v26, %v27
; CHECK-NEXT:    vfchdb %v1, %v24, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x double> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x float> %val3, <8 x float> %val4
  ret <8 x float> %sel
}

define <8 x double> @fun131(<8 x double> %val1, <8 x double> %val2, <8 x double> %val3, <8 x double> %val4) {
; CHECK-LABEL: fun131:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v24, %v25
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v26, %v27
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v28, %v29
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <8 x double> %val1, %val2
  %sel = select <8 x i1> %cmp, <8 x double> %val3, <8 x double> %val4
  ret <8 x double> %sel
}

define <16 x i8> @fun132(<16 x float> %val1, <16 x float> %val2, <16 x i8> %val3, <16 x i8> %val4) {
; CHECK-LABEL: fun132:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vmrhf %v4, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v29, %v29
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v27, %v27
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v27, %v27
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vmrlf %v2, %v25, %v25
; CHECK-NEXT:    vmrlf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vmrhf %v3, %v25, %v25
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vpkg %v2, %v3, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x float> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i8> %val3, <16 x i8> %val4
  ret <16 x i8> %sel
}

define <16 x i16> @fun133(<16 x float> %val1, <16 x float> %val2, <16 x i16> %val3, <16 x i16> %val4) {
; CHECK-LABEL: fun133:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v29, %v29
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x float> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i16> %val3, <16 x i16> %val4
  ret <16 x i16> %sel
}

define <16 x i32> @fun134(<16 x float> %val1, <16 x float> %val2, <16 x i32> %val3, <16 x i32> %val4) {
; CHECK-LABEL: fun134:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v25, %v25
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v25, %v25
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v29, %v29
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v29, %v29
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x float> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i32> %val3, <16 x i32> %val4
  ret <16 x i32> %sel
}

define <16 x i64> @fun135(<16 x float> %val1, <16 x float> %val2, <16 x i64> %val3, <16 x i64> %val4) {
; CHECK-LABEL: fun135:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v25, %v25
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v25, %v25
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vl %v6, 224(%r15)
; CHECK-NEXT:    vl %v7, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vpkg %v1, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v1
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vmrhf %v5, %v28, %v28
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vmrhf %v2, %v27, %v27
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vpkg %v2, %v2, %v0
; CHECK-NEXT:    vuphf %v0, %v2
; CHECK-NEXT:    vsel %v0, %v4, %v3, %v0
; CHECK-NEXT:    vmrlf %v3, %v29, %v29
; CHECK-NEXT:    vmrlf %v4, %v28, %v28
; CHECK-NEXT:    vlr %v28, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v29, %v29
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vfchdb %v4, %v5, %v4
; CHECK-NEXT:    vl %v5, 352(%r15)
; CHECK-NEXT:    vpkg %v3, %v4, %v3
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vmrlf %v4, %v31, %v31
; CHECK-NEXT:    vmrlf %v5, %v30, %v30
; CHECK-NEXT:    vmrhf %v6, %v30, %v30
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vfchdb %v4, %v5, %v4
; CHECK-NEXT:    vmrhf %v5, %v31, %v31
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v5, %v6, %v5
; CHECK-NEXT:    vl %v6, 384(%r15)
; CHECK-NEXT:    vpkg %v4, %v5, %v4
; CHECK-NEXT:    vuphf %v5, %v4
; CHECK-NEXT:    vsel %v29, %v7, %v6, %v5
; CHECK-NEXT:    vl %v5, 304(%r15)
; CHECK-NEXT:    vl %v6, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v6, %v5, %v1
; CHECK-NEXT:    vl %v5, 208(%r15)
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v30, %v5, %v2, %v1
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vmrlg %v1, %v3, %v3
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v1, %v4, %v4
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x float> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i64> %val3, <16 x i64> %val4
  ret <16 x i64> %sel
}

define <16 x float> @fun136(<16 x float> %val1, <16 x float> %val2, <16 x float> %val3, <16 x float> %val4) {
; CHECK-LABEL: fun136:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v25, %v25
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v25, %v25
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v29, %v29
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v29, %v29
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x float> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x float> %val3, <16 x float> %val4
  ret <16 x float> %sel
}

define <16 x double> @fun137(<16 x float> %val1, <16 x float> %val2, <16 x double> %val3, <16 x double> %val4) {
; CHECK-LABEL: fun137:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v25, %v25
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v25, %v25
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vl %v6, 224(%r15)
; CHECK-NEXT:    vl %v7, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vpkg %v1, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v1
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vmrhf %v5, %v28, %v28
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vmrhf %v2, %v27, %v27
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vpkg %v2, %v2, %v0
; CHECK-NEXT:    vuphf %v0, %v2
; CHECK-NEXT:    vsel %v0, %v4, %v3, %v0
; CHECK-NEXT:    vmrlf %v3, %v29, %v29
; CHECK-NEXT:    vmrlf %v4, %v28, %v28
; CHECK-NEXT:    vlr %v28, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v29, %v29
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vfchdb %v4, %v5, %v4
; CHECK-NEXT:    vl %v5, 352(%r15)
; CHECK-NEXT:    vpkg %v3, %v4, %v3
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vmrlf %v4, %v31, %v31
; CHECK-NEXT:    vmrlf %v5, %v30, %v30
; CHECK-NEXT:    vmrhf %v6, %v30, %v30
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vfchdb %v4, %v5, %v4
; CHECK-NEXT:    vmrhf %v5, %v31, %v31
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v5, %v6, %v5
; CHECK-NEXT:    vl %v6, 384(%r15)
; CHECK-NEXT:    vpkg %v4, %v5, %v4
; CHECK-NEXT:    vuphf %v5, %v4
; CHECK-NEXT:    vsel %v29, %v7, %v6, %v5
; CHECK-NEXT:    vl %v5, 304(%r15)
; CHECK-NEXT:    vl %v6, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v6, %v5, %v1
; CHECK-NEXT:    vl %v5, 208(%r15)
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v30, %v5, %v2, %v1
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vmrlg %v1, %v3, %v3
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v1, %v4, %v4
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x float> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x double> %val3, <16 x double> %val4
  ret <16 x double> %sel
}

define <16 x i8> @fun138(<16 x double> %val1, <16 x double> %val2, <16 x i8> %val3, <16 x i8> %val4) {
; CHECK-LABEL: fun138:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vfchdb %v1, %v27, %v1
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vfchdb %v1, %v30, %v1
; CHECK-NEXT:    vfchdb %v2, %v28, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vfchdb %v2, %v26, %v2
; CHECK-NEXT:    vfchdb %v3, %v24, %v3
; CHECK-NEXT:    vpkg %v2, %v3, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x double> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i8> %val3, <16 x i8> %val4
  ret <16 x i8> %sel
}

define <16 x i16> @fun139(<16 x double> %val1, <16 x double> %val2, <16 x i16> %val3, <16 x i16> %val4) {
; CHECK-LABEL: fun139:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v0
; CHECK-NEXT:    vfchdb %v1, %v28, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v1, %v26, %v1
; CHECK-NEXT:    vfchdb %v2, %v24, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vfchdb %v1, %v27, %v1
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x double> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i16> %val3, <16 x i16> %val4
  ret <16 x i16> %sel
}

define <16 x i32> @fun140(<16 x double> %val1, <16 x double> %val2, <16 x i32> %val3, <16 x i32> %val4) {
; CHECK-LABEL: fun140:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v26, %v0
; CHECK-NEXT:    vfchdb %v1, %v24, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 352(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v0
; CHECK-NEXT:    vfchdb %v1, %v28, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 368(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 384(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x double> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i32> %val3, <16 x i32> %val4
  ret <16 x i32> %sel
}

define <16 x i64> @fun141(<16 x double> %val1, <16 x double> %val2, <16 x i64> %val3, <16 x i64> %val4) {
; CHECK-LABEL: fun141:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vl %v1, 416(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vfchdb %v0, %v24, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vfchdb %v0, %v26, %v0
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vl %v1, 448(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vfchdb %v0, %v28, %v0
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 224(%r15)
; CHECK-NEXT:    vl %v1, 480(%r15)
; CHECK-NEXT:    vl %v2, 352(%r15)
; CHECK-NEXT:    vfchdb %v0, %v25, %v0
; CHECK-NEXT:    vsel %v25, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 496(%r15)
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v29, %v0
; CHECK-NEXT:    vl %v1, 512(%r15)
; CHECK-NEXT:    vl %v2, 384(%r15)
; CHECK-NEXT:    vsel %v29, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vl %v1, 528(%r15)
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x double> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x i64> %val3, <16 x i64> %val4
  ret <16 x i64> %sel
}

define <16 x float> @fun142(<16 x double> %val1, <16 x double> %val2, <16 x float> %val3, <16 x float> %val4) {
; CHECK-LABEL: fun142:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v26, %v0
; CHECK-NEXT:    vfchdb %v1, %v24, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 352(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v0
; CHECK-NEXT:    vfchdb %v1, %v28, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 368(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 384(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x double> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x float> %val3, <16 x float> %val4
  ret <16 x float> %sel
}

define <16 x double> @fun143(<16 x double> %val1, <16 x double> %val2, <16 x double> %val3, <16 x double> %val4) {
; CHECK-LABEL: fun143:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vl %v1, 416(%r15)
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vfchdb %v0, %v24, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vfchdb %v0, %v26, %v0
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vl %v1, 448(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vfchdb %v0, %v28, %v0
; CHECK-NEXT:    vsel %v28, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vfchdb %v0, %v30, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 224(%r15)
; CHECK-NEXT:    vl %v1, 480(%r15)
; CHECK-NEXT:    vl %v2, 352(%r15)
; CHECK-NEXT:    vfchdb %v0, %v25, %v0
; CHECK-NEXT:    vsel %v25, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 496(%r15)
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v29, %v0
; CHECK-NEXT:    vl %v1, 512(%r15)
; CHECK-NEXT:    vl %v2, 384(%r15)
; CHECK-NEXT:    vsel %v29, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vl %v1, 528(%r15)
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp = fcmp ogt <16 x double> %val1, %val2
  %sel = select <16 x i1> %cmp, <16 x double> %val3, <16 x double> %val4
  ret <16 x double> %sel
}

