; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s

; These tests just check that the plumbing is in place for @llvm.bitreverse. The
; actual output is massive at the moment as llvm.bitreverse is not yet legal.

declare <2 x i16> @llvm.bitreverse.v2i16(<2 x i16>) readnone

define <2 x i16> @test_bitreverse_v2i16(<2 x i16> %a) nounwind {
; CHECK-LABEL: test_bitreverse_v2i16:
; CHECK:       # BB#0:
; CHECK-NEXT:    movw {{[0-9]+}}(%esp), %cx
; CHECK-NEXT:    movw {{[0-9]+}}(%esp), %ax
; CHECK-NEXT:    rolw $8, %ax
; CHECK-NEXT:    movl %eax, %edx
; CHECK-NEXT:    andl $3855, %edx # imm = 0xF0F
; CHECK-NEXT:    shll $4, %edx
; CHECK-NEXT:    andl $61680, %eax # imm = 0xF0F0
; CHECK-NEXT:    shrl $4, %eax
; CHECK-NEXT:    orl %edx, %eax
; CHECK-NEXT:    movl %eax, %edx
; CHECK-NEXT:    andl $13107, %edx # imm = 0x3333
; CHECK-NEXT:    andl $52428, %eax # imm = 0xCCCC
; CHECK-NEXT:    shrl $2, %eax
; CHECK-NEXT:    leal (%eax,%edx,4), %eax
; CHECK-NEXT:    movl %eax, %edx
; CHECK-NEXT:    andl $21845, %edx # imm = 0x5555
; CHECK-NEXT:    andl $43690, %eax # imm = 0xAAAA
; CHECK-NEXT:    shrl %eax
; CHECK-NEXT:    leal (%eax,%edx,2), %eax
; CHECK-NEXT:    rolw $8, %cx
; CHECK-NEXT:    movl %ecx, %edx
; CHECK-NEXT:    andl $3855, %edx # imm = 0xF0F
; CHECK-NEXT:    shll $4, %edx
; CHECK-NEXT:    andl $61680, %ecx # imm = 0xF0F0
; CHECK-NEXT:    shrl $4, %ecx
; CHECK-NEXT:    orl %edx, %ecx
; CHECK-NEXT:    movl %ecx, %edx
; CHECK-NEXT:    andl $13107, %edx # imm = 0x3333
; CHECK-NEXT:    andl $52428, %ecx # imm = 0xCCCC
; CHECK-NEXT:    shrl $2, %ecx
; CHECK-NEXT:    leal (%ecx,%edx,4), %ecx
; CHECK-NEXT:    movl %ecx, %edx
; CHECK-NEXT:    andl $21845, %edx # imm = 0x5555
; CHECK-NEXT:    andl $43690, %ecx # imm = 0xAAAA
; CHECK-NEXT:    shrl %ecx
; CHECK-NEXT:    leal (%ecx,%edx,2), %edx
; CHECK-NEXT:    # kill: %AX<def> %AX<kill> %EAX<kill>
; CHECK-NEXT:    # kill: %DX<def> %DX<kill> %EDX<kill>
; CHECK-NEXT:    retl
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %a)
  ret <2 x i16> %b
}

declare i24 @llvm.bitreverse.i24(i24) readnone

define i24 @test_bitreverse_i24(i24 %a) nounwind {
; CHECK-LABEL: test_bitreverse_i24:
; CHECK:       # BB#0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    bswapl %eax
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; CHECK-NEXT:    shll $4, %ecx
; CHECK-NEXT:    andl $-252645136, %eax # imm = 0xF0F0F0F0
; CHECK-NEXT:    shrl $4, %eax
; CHECK-NEXT:    orl %ecx, %eax
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; CHECK-NEXT:    andl $-858993460, %eax # imm = 0xCCCCCCCC
; CHECK-NEXT:    shrl $2, %eax
; CHECK-NEXT:    leal (%eax,%ecx,4), %eax
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andl $1431655680, %ecx # imm = 0x55555500
; CHECK-NEXT:    andl $-1431655936, %eax # imm = 0xAAAAAA00
; CHECK-NEXT:    shrl %eax
; CHECK-NEXT:    leal (%eax,%ecx,2), %eax
; CHECK-NEXT:    shrl $8, %eax
; CHECK-NEXT:    retl
  %b = call i24 @llvm.bitreverse.i24(i24 %a)
  ret i24 %b
}

declare i8 @llvm.bitreverse.i8(i8) readnone

define i8 @test_bitreverse_i8(i8 %a) {
; CHECK-LABEL: test_bitreverse_i8:
; CHECK:       # BB#0:
; CHECK-NEXT:    movb {{[0-9]+}}(%esp), %al
; CHECK-NEXT:    rolb $4, %al
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andb $51, %cl
; CHECK-NEXT:    shlb $2, %cl
; CHECK-NEXT:    andb $-52, %al
; CHECK-NEXT:    shrb $2, %al
; CHECK-NEXT:    orb %cl, %al
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andb $85, %cl
; CHECK-NEXT:    addb %cl, %cl
; CHECK-NEXT:    andb $-86, %al
; CHECK-NEXT:    shrb %al
; CHECK-NEXT:    orb %cl, %al
; CHECK-NEXT:    retl
  %b = call i8 @llvm.bitreverse.i8(i8 %a)
  ret i8 %b
}

declare i4 @llvm.bitreverse.i4(i4) readnone

define i4 @test_bitreverse_i4(i4 %a) {
; CHECK-LABEL: test_bitreverse_i4:
; CHECK:       # BB#0:
; CHECK-NEXT:    movb {{[0-9]+}}(%esp), %al
; CHECK-NEXT:    rolb $4, %al
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andb $51, %cl
; CHECK-NEXT:    shlb $2, %cl
; CHECK-NEXT:    andb $-52, %al
; CHECK-NEXT:    shrb $2, %al
; CHECK-NEXT:    orb %cl, %al
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    andb $80, %cl
; CHECK-NEXT:    addb %cl, %cl
; CHECK-NEXT:    andb $-96, %al
; CHECK-NEXT:    shrb %al
; CHECK-NEXT:    orb %cl, %al
; CHECK-NEXT:    shrb $4, %al
; CHECK-NEXT:    retl
  %b = call i4 @llvm.bitreverse.i4(i4 %a)
  ret i4 %b
}

; These tests check that bitreverse(constant) calls are folded

define <2 x i16> @fold_v2i16() {
; CHECK-LABEL: fold_v2i16:
; CHECK:       # BB#0:
; CHECK-NEXT:    movw $-4096, %ax # imm = 0xF000
; CHECK-NEXT:    movw $240, %dx
; CHECK-NEXT:    retl
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> <i16 15, i16 3840>)
  ret <2 x i16> %b
}

define i24 @fold_i24() {
; CHECK-LABEL: fold_i24:
; CHECK:       # BB#0:
; CHECK-NEXT:    movl $2048, %eax # imm = 0x800
; CHECK-NEXT:    retl
  %b = call i24 @llvm.bitreverse.i24(i24 4096)
  ret i24 %b
}

define i8 @fold_i8() {
; CHECK-LABEL: fold_i8:
; CHECK:       # BB#0:
; CHECK-NEXT:    movb $-16, %al
; CHECK-NEXT:    retl
  %b = call i8 @llvm.bitreverse.i8(i8 15)
  ret i8 %b
}

define i4 @fold_i4() {
; CHECK-LABEL: fold_i4:
; CHECK:       # BB#0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retl
  %b = call i4 @llvm.bitreverse.i4(i4 8)
  ret i4 %b
}

; These tests check that bitreverse(bitreverse()) calls are removed

define i8 @identity_i8(i8 %a) {
; CHECK-LABEL: identity_i8:
; CHECK:       # BB#0:
; CHECK-NEXT:    movb {{[0-9]+}}(%esp), %al
; CHECK-NEXT:    retl
  %b = call i8 @llvm.bitreverse.i8(i8 %a)
  %c = call i8 @llvm.bitreverse.i8(i8 %b)
  ret i8 %c
}

define <2 x i16> @identity_v2i16(<2 x i16> %a) {
; CHECK-LABEL: identity_v2i16:
; CHECK:       # BB#0:
; CHECK-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; CHECK-NEXT:    retl
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %a)
  %c = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %b)
  ret <2 x i16> %c
}

; These tests check that bitreverse(undef) calls are removed

define i8 @undef_i8() {
; CHECK-LABEL: undef_i8:
; CHECK:       # BB#0:
; CHECK-NEXT:    retl
  %b = call i8 @llvm.bitreverse.i8(i8 undef)
  ret i8 %b
}

define <2 x i16> @undef_v2i16() {
; CHECK-LABEL: undef_v2i16:
; CHECK:       # BB#0:
; CHECK-NEXT:    retl
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> undef)
  ret <2 x i16> %b
}
