/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2018-2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2022 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef __WCD939X_H__
#define __WCD939X_H__
#include <linux/soundwire/sdw.h>
#include <linux/soundwire/sdw_type.h>

#define WCD939X_BASE					   (0x3000)
#define WCD939X_ANA_PAGE				   (0x3000)
#define WCD939X_ANA_BIAS				   (0x3001)
#define WCD939X_BIAS_ANALOG_BIAS_EN	BIT(7)
#define WCD939X_BIAS_PRECHRG_EN	BIT(6)
#define WCD939X_BIAS_PRECHRG_CTL_MODE	BIT(5)
#define WCD939X_ANA_RX_SUPPLIES				   (0x3008)
#define WCD939X_RX_SUPPLIES_VPOS_EN	BIT(7)
#define WCD939X_RX_SUPPLIES_VNEG_EN	BIT(6)
#define WCD939X_RX_SUPPLIES_VPOS_PWR_LVL	BIT(3)
#define WCD939X_RX_SUPPLIES_VNEG_PWR_LVL	BIT(2)
#define WCD939X_RX_SUPPLIES_REGULATOR_MODE	BIT(1)
#define WCD939X_RX_SUPPLIES_RX_BIAS_ENABLE	BIT(0)
#define WCD939X_ANA_HPH					   (0x3009)
#define WCD939X_HPH_HPHL_ENABLE	BIT(7)
#define WCD939X_HPH_HPHR_ENABLE	BIT(6)
#define WCD939X_HPH_HPHL_REF_ENABLE	BIT(5)
#define WCD939X_HPH_HPHR_REF_ENABLE	BIT(4)
#define WCD939X_HPH_PWR_LEVEL	GENMASK(3, 2)
#define WCD939X_ANA_EAR					   (0x300a)
#define WCD939X_ANA_EAR_COMPANDER_CTL			   (0x300b)
#define WCD939X_EAR_COMPANDER_CTL_GAIN_OVRD_REG	BIT(7)
#define WCD939X_EAR_COMPANDER_CTL_EAR_GAIN	GENMASK(6, 2)
#define WCD939X_EAR_COMPANDER_CTL_COMP_DFF_BYP	BIT(1)
#define WCD939X_EAR_COMPANDER_CTL_COMP_DFF_CLK_EDGE	BIT(0)
#define WCD939X_ANA_TX_CH1				   (0x300e)
#define WCD939X_ANA_TX_CH2				   (0x300f)
#define WCD939X_TX_CH2_ENABLE	BIT(7)
#define WCD939X_TX_CH2_HPF1_INIT	BIT(6)
#define WCD939X_TX_CH2_HPF2_INIT	BIT(5)
#define WCD939X_TX_CH2_GAIN	GENMASK(4, 0)
#define WCD939X_ANA_TX_CH3				   (0x3010)
#define WCD939X_ANA_TX_CH4				   (0x3011)
#define WCD939X_TX_CH4_ENABLE	BIT(7)
#define WCD939X_TX_CH4_HPF3_INIT	BIT(6)
#define WCD939X_TX_CH4_HPF4_INIT	BIT(5)
#define WCD939X_TX_CH4_GAIN	GENMASK(4, 0)
#define WCD939X_ANA_MICB1_MICB2_DSP_EN_LOGIC		   (0x3012)
#define WCD939X_ANA_MICB3_DSP_EN_LOGIC			   (0x3013)
#define WCD939X_ANA_MBHC_MECH				   (0x3014)
#define WCD939X_MBHC_MECH_L_DET_EN	BIT(7)
#define WCD939X_MBHC_MECH_GND_DET_EN	BIT(6)
#define WCD939X_MBHC_MECH_MECH_DETECT_TYPE	BIT(5)
#define WCD939X_MBHC_MECH_HPHL_PLUG_TYPE	BIT(4)
#define WCD939X_MBHC_MECH_GND_PLUG_TYPE	BIT(3)
#define WCD939X_MBHC_MECH_MECH_HS_L_PULLUP_COMP_EN	BIT(2)
#define WCD939X_MBHC_MECH_MECH_HS_G_PULLUP_COMP_EN	BIT(1)
#define WCD939X_MBHC_MECH_SW_HPH_L_P_100K_TO_GND	BIT(0)
#define WCD939X_ANA_MBHC_ELECT				   (0x3015)
#define WCD939X_MBHC_ELECT_FSM_EN	BIT(7)
#define WCD939X_MBHC_ELECT_BTNDET_ISRC_CTL	GENMASK(6, 4)
#define WCD939X_MBHC_ELECT_ELECT_DET_TYPE	BIT(3)
#define WCD939X_MBHC_ELECT_ELECT_SCHMT_ISRC_CTL	GENMASK(2, 1)
#define WCD939X_MBHC_ELECT_BIAS_EN	BIT(0)
#define WCD939X_ANA_MBHC_ZDET				   (0x3016)
#define WCD939X_MBHC_ZDET_ZDET_L_MEAS_EN	BIT(7)
#define WCD939X_MBHC_ZDET_ZDET_R_MEAS_EN	BIT(6)
#define WCD939X_MBHC_ZDET_ZDET_CHG_EN	BIT(5)
#define WCD939X_MBHC_ZDET_ZDET_ILEAK_COMP_EN	BIT(4)
#define WCD939X_MBHC_ZDET_ELECT_ISRC_EN	BIT(1)
#define WCD939X_ANA_MBHC_RESULT_1			   (0x3017)
#define WCD939X_MBHC_RESULT_1_Z_RESULT_LSB	GENMASK(7, 0)
#define WCD939X_ANA_MBHC_RESULT_2			   (0x3018)
#define WCD939X_MBHC_RESULT_2_Z_RESULT_MSB	GENMASK(7, 0)
#define WCD939X_ANA_MBHC_RESULT_3			   (0x3019)
#define WCD939X_ANA_MBHC_BTN0				   (0x301a)
#define WCD939X_MBHC_BTN0_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN1				   (0x301b)
#define WCD939X_MBHC_BTN1_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN2				   (0x301c)
#define WCD939X_MBHC_BTN2_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN3				   (0x301d)
#define WCD939X_MBHC_BTN3_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN4				   (0x301e)
#define WCD939X_MBHC_BTN4_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN5				   (0x301f)
#define WCD939X_MBHC_BTN5_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN6				   (0x3020)
#define WCD939X_MBHC_BTN6_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MBHC_BTN7				   (0x3021)
#define WCD939X_MBHC_BTN7_VTH	GENMASK(7, 2)
#define WCD939X_ANA_MICB1				   (0x3022)
#define WCD939X_MICB_ENABLE	GENMASK(7, 6)
#define WCD939X_MICB_VOUT_CTL	GENMASK(5, 0)
#define WCD939X_ANA_MICB2				   (0x3023)
#define WCD939X_ANA_MICB2_RAMP				   (0x3024)
#define WCD939X_MICB2_RAMP_RAMP_ENABLE	BIT(7)
#define WCD939X_MICB2_RAMP_MB2_IN2P_SHORT_ENABLE	BIT(6)
#define WCD939X_MICB2_RAMP_ALLSW_OVRD_ENABLE	BIT(5)
#define WCD939X_MICB2_RAMP_SHIFT_CTL	GENMASK(4, 2)
#define WCD939X_MICB2_RAMP_USB_MGDET_MICB2_RAMP	GENMASK(1, 0)
#define WCD939X_ANA_MICB3				   (0x3025)
#define WCD939X_ANA_MICB4				   (0x3026)
#define WCD939X_BIAS_CTL				   (0x3028)
#define WCD939X_BIAS_VBG_FINE_ADJ			   (0x3029)
#define WCD939X_LDOL_VDDCX_ADJUST			   (0x3040)
#define WCD939X_LDOL_DISABLE_LDOL			   (0x3041)
#define WCD939X_MBHC_CTL_CLK				   (0x3056)
#define WCD939X_MBHC_CTL_ANA				   (0x3057)
#define WCD939X_MBHC_ZDET_VNEG_CTL			   (0x3058)
#define WCD939X_MBHC_ZDET_BIAS_CTL			   (0x3059)
#define WCD939X_MBHC_CTL_BCS				   (0x305a)
#define WCD939X_MBHC_MOISTURE_DET_FSM_STATUS		   (0x305b)
#define WCD939X_MBHC_TEST_CTL				   (0x305c)
#define WCD939X_LDOH_MODE				   (0x3067)
#define WCD939X_MODE_LDOH_EN	BIT(7)
#define WCD939X_MODE_PWRDN_STATE	BIT(6)
#define WCD939X_MODE_SLOWRAMP_EN	BIT(5)
#define WCD939X_MODE_VOUT_ADJUST	GENMASK(4, 3)
#define WCD939X_MODE_VOUT_COARSE_ADJ	GENMASK(2, 0)
#define WCD939X_LDOH_BIAS				   (0x3068)
#define WCD939X_LDOH_STB_LOADS				   (0x3069)
#define WCD939X_LDOH_SLOWRAMP				   (0x306a)
#define WCD939X_MICB1_TEST_CTL_1			   (0x306b)
#define WCD939X_TEST_CTL_1_NOISE_FILT_RES_VAL	GENMASK(7, 5)
#define WCD939X_TEST_CTL_1_EN_VREFGEN	BIT(4)
#define WCD939X_TEST_CTL_1_EN_LDO	BIT(3)
#define WCD939X_TEST_CTL_1_LDO_BLEEDER_I_CTRL	GENMASK(2, 0)
#define WCD939X_MICB1_TEST_CTL_2			   (0x306c)
#define WCD939X_TEST_CTL_2_IBIAS_VREFGEN	GENMASK(7, 6)
#define WCD939X_TEST_CTL_2_INRUSH_CURRENT_FIX_DIS	BIT(5)
#define WCD939X_TEST_CTL_2_IBIAS_LDO_DRIVER	GENMASK(2, 0)
#define WCD939X_MICB1_TEST_CTL_3			   (0x306d)
#define WCD939X_TEST_CTL_3_CFILT_REF_EN	BIT(7)
#define WCD939X_TEST_CTL_3_RZ_LDO_VAL	GENMASK(6, 4)
#define WCD939X_TEST_CTL_3_IBIAS_LDO_STG3	GENMASK(3, 2)
#define WCD939X_TEST_CTL_3_ATEST_CTRL	GENMASK(1, 0)
#define WCD939X_MICB2_TEST_CTL_1			   (0x306e)
#define WCD939X_MICB2_TEST_CTL_2			   (0x306f)
#define WCD939X_MICB2_TEST_CTL_3			   (0x3070)
#define WCD939X_MICB3_TEST_CTL_1			   (0x3071)
#define WCD939X_MICB3_TEST_CTL_2			   (0x3072)
#define WCD939X_MICB3_TEST_CTL_3			   (0x3073)
#define WCD939X_MICB4_TEST_CTL_1			   (0x3074)
#define WCD939X_MICB4_TEST_CTL_2			   (0x3075)
#define WCD939X_MICB4_TEST_CTL_3			   (0x3076)
#define WCD939X_TX_COM_ADC_VCM				   (0x3077)
#define WCD939X_TX_COM_BIAS_ATEST			   (0x3078)
#define WCD939X_TX_COM_SPARE1				   (0x3079)
#define WCD939X_TX_COM_SPARE2				   (0x307a)
#define WCD939X_TX_COM_TXFE_DIV_CTL			   (0x307b)
#define WCD939X_TX_COM_TXFE_DIV_START			   (0x307c)
#define WCD939X_TX_COM_SPARE3				   (0x307d)
#define WCD939X_TX_COM_SPARE4				   (0x307e)
#define WCD939X_TX_1_2_TEST_EN				   (0x307f)
#define WCD939X_TX_1_2_ADC_IB				   (0x3080)
#define WCD939X_TX_1_2_ATEST_REFCTL			   (0x3081)
#define WCD939X_TX_1_2_TEST_CTL				   (0x3082)
#define WCD939X_TX_1_2_TEST_BLK_EN1			   (0x3083)
#define WCD939X_TX_1_2_TXFE1_CLKDIV			   (0x3084)
#define WCD939X_TX_1_2_SAR2_ERR				   (0x3085)
#define WCD939X_TX_1_2_SAR1_ERR				   (0x3086)
#define WCD939X_TX_3_4_TEST_EN				   (0x3087)
#define WCD939X_TX_3_4_ADC_IB				   (0x3088)
#define WCD939X_TX_3_4_ATEST_REFCTL			   (0x3089)
#define WCD939X_TX_3_4_TEST_CTL				   (0x308a)
#define WCD939X_TX_3_4_TEST_BLK_EN3			   (0x308b)
#define WCD939X_TX_3_4_TXFE3_CLKDIV			   (0x308c)
#define WCD939X_TX_3_4_SAR4_ERR				   (0x308d)
#define WCD939X_TX_3_4_SAR3_ERR				   (0x308e)
#define WCD939X_TX_3_4_TEST_BLK_EN2			   (0x308f)
#define WCD939X_TEST_BLK_EN2_ADC2_INT1_EN	BIT(7)
#define WCD939X_TEST_BLK_EN2_ADC2_INT2_EN	BIT(6)
#define WCD939X_TEST_BLK_EN2_ADC2_SAR_EN	BIT(5)
#define WCD939X_TEST_BLK_EN2_ADC2_CMGEN_EN	BIT(4)
#define WCD939X_TEST_BLK_EN2_ADC2_CLKGEN_EN	BIT(3)
#define WCD939X_TEST_BLK_EN2_ADC12_VREF_NONL2	GENMASK(2, 1)
#define WCD939X_TEST_BLK_EN2_TXFE2_MBHC_CLKRST_EN	BIT(0)
#define WCD939X_TX_3_4_TXFE2_CLKDIV			   (0x3090)
#define WCD939X_TX_3_4_SPARE1				   (0x3091)
#define WCD939X_TX_3_4_TEST_BLK_EN4			   (0x3092)
#define WCD939X_TX_3_4_TXFE4_CLKDIV			   (0x3093)
#define WCD939X_TX_3_4_SPARE2				   (0x3094)
#define WCD939X_CLASSH_MODE_1				   (0x3097)
#define WCD939X_CLASSH_MODE_2				   (0x3098)
#define WCD939X_CLASSH_MODE_3				   (0x3099)
#define WCD939X_CLASSH_CTRL_VCL_1			   (0x309a)
#define WCD939X_CLASSH_CTRL_VCL_2			   (0x309b)
#define WCD939X_CLASSH_CTRL_CCL_1			   (0x309c)
#define WCD939X_CLASSH_CTRL_CCL_2			   (0x309d)
#define WCD939X_CLASSH_CTRL_CCL_3			   (0x309e)
#define WCD939X_CLASSH_CTRL_CCL_4			   (0x309f)
#define WCD939X_CLASSH_CTRL_CCL_5			   (0x30a0)
#define WCD939X_CLASSH_BUCK_TMUX_A_D			   (0x30a1)
#define WCD939X_CLASSH_BUCK_SW_DRV_CNTL			   (0x30a2)
#define WCD939X_CLASSH_SPARE				   (0x30a3)
#define WCD939X_FLYBACK_EN				   (0x30a4)
#define WCD939X_FLYBACK_VNEG_CTRL_1			   (0x30a5)
#define WCD939X_FLYBACK_VNEG_CTRL_2			   (0x30a6)
#define WCD939X_FLYBACK_VNEG_CTRL_3			   (0x30a7)
#define WCD939X_FLYBACK_VNEG_CTRL_4			   (0x30a8)
#define WCD939X_VNEG_CTRL_4_ILIM_SEL	GENMASK(7, 4)
#define WCD939X_VNEG_CTRL_4_PW_BUF_POS	GENMASK(3, 2)
#define WCD939X_VNEG_CTRL_4_PW_BUF_NEG	GENMASK(1, 0)
#define WCD939X_FLYBACK_VNEG_CTRL_5			   (0x30a9)
#define WCD939X_FLYBACK_VNEG_CTRL_6			   (0x30aa)
#define WCD939X_FLYBACK_VNEG_CTRL_7			   (0x30ab)
#define WCD939X_FLYBACK_VNEG_CTRL_8			   (0x30ac)
#define WCD939X_FLYBACK_VNEG_CTRL_9			   (0x30ad)
#define WCD939X_FLYBACK_VNEGDAC_CTRL_1			   (0x30ae)
#define WCD939X_FLYBACK_VNEGDAC_CTRL_2			   (0x30af)
#define WCD939X_FLYBACK_VNEGDAC_CTRL_3			   (0x30b0)
#define WCD939X_FLYBACK_CTRL_1				   (0x30b1)
#define WCD939X_FLYBACK_TEST_CTL			   (0x30b2)
#define WCD939X_RX_AUX_SW_CTL				   (0x30b3)
#define WCD939X_RX_PA_AUX_IN_CONN			   (0x30b4)
#define WCD939X_RX_TIMER_DIV				   (0x30b5)
#define WCD939X_RX_OCP_CTL				   (0x30b6)
#define WCD939X_RX_OCP_COUNT				   (0x30b7)
#define WCD939X_RX_BIAS_EAR_DAC				   (0x30b8)
#define WCD939X_RX_BIAS_EAR_AMP				   (0x30b9)
#define WCD939X_RX_BIAS_HPH_LDO				   (0x30ba)
#define WCD939X_RX_BIAS_HPH_PA				   (0x30bb)
#define WCD939X_RX_BIAS_HPH_RDACBUFF_CNP2		   (0x30bc)
#define WCD939X_RX_BIAS_HPH_RDAC_LDO			   (0x30bd)
#define WCD939X_RX_BIAS_HPH_CNP1			   (0x30be)
#define WCD939X_RX_BIAS_HPH_LOWPOWER			   (0x30bf)
#define WCD939X_RX_BIAS_AUX_DAC				   (0x30c0)
#define WCD939X_RX_BIAS_AUX_AMP				   (0x30c1)
#define WCD939X_RX_BIAS_VNEGDAC_BLEEDER			   (0x30c2)
#define WCD939X_RX_BIAS_MISC				   (0x30c3)
#define WCD939X_RX_BIAS_BUCK_RST			   (0x30c4)
#define WCD939X_RX_BIAS_BUCK_VREF_ERRAMP		   (0x30c5)
#define WCD939X_RX_BIAS_FLYB_ERRAMP			   (0x30c6)
#define WCD939X_RX_BIAS_FLYB_BUFF			   (0x30c7)
#define WCD939X_RX_BIAS_FLYB_MID_RST			   (0x30c8)
#define WCD939X_HPH_L_STATUS				   (0x30c9)
#define WCD939X_HPH_R_STATUS				   (0x30ca)
#define WCD939X_HPH_CNP_EN				   (0x30cb)
#define WCD939X_HPH_CNP_WG_CTL				   (0x30cc)
#define WCD939X_HPH_CNP_WG_TIME				   (0x30cd)
#define WCD939X_HPH_OCP_CTL				   (0x30ce)
#define WCD939X_OCP_CTL_OCP_CURR_LIMIT	GENMASK(7, 5)
#define WCD939X_OCP_CTL_OCP_FSM_EN	BIT(4)
#define WCD939X_OCP_CTL_SPARE_BITS	BIT(3)
#define WCD939X_OCP_CTL_SCD_OP_EN	BIT(1)
#define WCD939X_HPH_AUTO_CHOP				   (0x30cf)
#define WCD939X_HPH_CHOP_CTL				   (0x30d0)
#define WCD939X_HPH_PA_CTL1				   (0x30d1)
#define WCD939X_HPH_PA_CTL2				   (0x30d2)
#define WCD939X_PA_CTL2_HPHPA_GND_R	BIT(6)
#define WCD939X_PA_CTL2_HPHPA_GND_L	BIT(4)
#define WCD939X_PA_CTL2_GM3_CASCODE_CTL_NORMAL	GENMASK(1, 0)
#define WCD939X_HPH_L_EN				   (0x30d3)
#define WCD939X_L_EN_CONST_SEL_L	GENMASK(7, 6)
#define WCD939X_L_EN_GAIN_SOURCE_SEL	BIT(5)
#define WCD939X_L_EN_SPARE_BITS	GENMASK(4, 0)
#define WCD939X_HPH_L_TEST				   (0x30d4)
#define WCD939X_HPH_L_ATEST				   (0x30d5)
#define WCD939X_HPH_R_EN				   (0x30d6)
#define WCD939X_R_EN_CONST_SEL_R	GENMASK(7, 6)
#define WCD939X_R_EN_GAIN_SOURCE_SEL	BIT(5)
#define WCD939X_R_EN_SPARE_BITS	GENMASK(4, 0)
#define WCD939X_HPH_R_TEST				   (0x30d7)
#define WCD939X_HPH_R_ATEST				   (0x30d8)
#define WCD939X_R_ATEST_DACR_REF_ATEST1_CONN	BIT(7)
#define WCD939X_R_ATEST_LDO1_R_ATEST2_CONN	BIT(6)
#define WCD939X_R_ATEST_LDO_R_ATEST2_CAL	BIT(5)
#define WCD939X_R_ATEST_LDO2_R_ATEST2_CONN	BIT(4)
#define WCD939X_R_ATEST_LDO_1P65V_ATEST1_CONN	BIT(3)
#define WCD939X_R_ATEST_HPH_GND_OVR	BIT(1)
#define WCD939X_HPH_RDAC_CLK_CTL1			   (0x30d9)
#define WCD939X_RDAC_CLK_CTL1_OPAMP_CHOP_CLK_EN	BIT(7)
#define WCD939X_RDAC_CLK_CTL1_OPAMP_CHOP_CLK_DIV_CTRL	GENMASK(6, 4)
#define WCD939X_RDAC_CLK_CTL1_SPARE_BITS	GENMASK(3, 0)
#define WCD939X_HPH_RDAC_CLK_CTL2			   (0x30da)
#define WCD939X_HPH_RDAC_LDO_CTL			   (0x30db)
#define WCD939X_HPH_RDAC_CHOP_CLK_LP_CTL		   (0x30dc)
#define WCD939X_HPH_REFBUFF_UHQA_CTL			   (0x30dd)
#define WCD939X_REFBUFF_UHQA_CTL_SPARE_BITS	GENMASK(7, 6)
#define WCD939X_REFBUFF_UHQA_CTL_HPH_VNEGREG2_COMP_CTL_OV	BIT(5)
#define WCD939X_REFBUFF_UHQA_CTL_REFBUFN_RBIAS_ADJUST	BIT(4)
#define WCD939X_REFBUFF_UHQA_CTL_REFBUFP_IOUT_CTL	GENMASK(3, 2)
#define WCD939X_REFBUFF_UHQA_CTL_REFBUFN_IOUT_CTL	GENMASK(1, 0)
#define WCD939X_HPH_REFBUFF_LP_CTL			   (0x30de)
#define WCD939X_REFBUFF_LP_CTL_HPH_VNEGREG2_CURR_COMP	GENMASK(7, 6)
#define WCD939X_REFBUFF_LP_CTL_SPARE_BITS	GENMASK(5, 4)
#define WCD939X_REFBUFF_LP_CTL_EN_PREREF_FILT_STARTUP_CLKDIV	BIT(3)
#define WCD939X_REFBUFF_LP_CTL_PREREF_FILT_STARTUP_CLKDIV_CTL	GENMASK(2, 1)
#define WCD939X_REFBUFF_LP_CTL_PREREF_FILT_BYPASS	BIT(0)
#define WCD939X_HPH_L_DAC_CTL				   (0x30df)
#define WCD939X_HPH_R_DAC_CTL				   (0x30e0)
#define WCD939X_HPH_SURGE_COMP_SEL			   (0x30e1)
#define WCD939X_HPH_SURGE_EN				   (0x30e2)
#define WCD939X_EN_EN_SURGE_PROTECTION_HPHL	BIT(7)
#define WCD939X_EN_EN_SURGE_PROTECTION_HPHR	BIT(6)
#define WCD939X_EN_SEL_SURGE_COMP_IQ	GENMASK(5, 4)
#define WCD939X_EN_SURGE_VOLT_MODE_SHUTOFF_EN	BIT(3)
#define WCD939X_EN_LATCH_INTR_OP_STG_HIZ_EN	BIT(2)
#define WCD939X_EN_SURGE_LATCH_REG_RESET	BIT(1)
#define WCD939X_EN_SWTICH_VN_VNDAC_NSURGE_EN	BIT(0)
#define WCD939X_HPH_SURGE_MISC1				   (0x30e3)
#define WCD939X_HPH_SURGE_STATUS			   (0x30e4)
#define WCD939X_EAR_EN					   (0x30e9)
#define WCD939X_EAR_PA_CON				   (0x30ea)
#define WCD939X_EAR_SP_CON				   (0x30eb)
#define WCD939X_EAR_DAC_CON				   (0x30ec)
#define WCD939X_DAC_CON_DAC_SAMPLE_EDGE_SEL	BIT(7)
#define WCD939X_DAC_CON_REF_DBG_EN	BIT(6)
#define WCD939X_DAC_CON_REF_DBG_GAIN	GENMASK(5, 3)
#define WCD939X_DAC_CON_GAIN_DAC	GENMASK(2, 1)
#define WCD939X_DAC_CON_INV_DATA	BIT(0)
#define WCD939X_EAR_CNP_FSM_CON				   (0x30ed)
#define WCD939X_EAR_TEST_CTL				   (0x30ee)
#define WCD939X_EAR_STATUS_REG_1			   (0x30ef)
#define WCD939X_EAR_STATUS_REG_2			   (0x30f0)
#define WCD939X_FLYBACK_NEW_CTRL_2			   (0x30f6)
#define WCD939X_FLYBACK_NEW_CTRL_3			   (0x30f7)
#define WCD939X_FLYBACK_NEW_CTRL_4			   (0x30f8)
#define WCD939X_ANA_NEW_PAGE				   (0x3100)
#define WCD939X_HPH_NEW_ANA_HPH2			   (0x3101)
#define WCD939X_HPH_NEW_ANA_HPH3			   (0x3102)
#define WCD939X_SLEEP_CTL				   (0x3103)
#define WCD939X_SLEEP_WATCHDOG_CTL			   (0x3104)
#define WCD939X_MBHC_NEW_ELECT_REM_CLAMP_CTL		   (0x311f)
#define WCD939X_MBHC_NEW_CTL_1				   (0x3120)
#define WCD939X_CTL_1_RCO_EN	BIT(7)
#define WCD939X_CTL_1_ADC_MODE	BIT(4)
#define WCD939X_CTL_1_ADC_ENABLE	BIT(3)
#define WCD939X_CTL_1_DETECTION_DONE	BIT(2)
#define WCD939X_CTL_1_BTN_DBNC_CTL	GENMASK(1, 0)
#define WCD939X_MBHC_NEW_CTL_2				   (0x3121)
#define WCD939X_CTL_2_MUX_CTL	GENMASK(6, 4)
#define WCD939X_CTL_2_M_RTH_CTL	GENMASK(3, 2)
#define WCD939X_CTL_2_HS_VREF_CTL	GENMASK(1, 0)
#define WCD939X_MBHC_NEW_PLUG_DETECT_CTL		   (0x3122)
#define WCD939X_MBHC_NEW_ZDET_ANA_CTL			   (0x3123)
#define WCD939X_ZDET_ANA_CTL_AVERAGING_EN	BIT(7)
#define WCD939X_ZDET_ANA_CTL_MAXV_CTL	GENMASK(6, 4)
#define WCD939X_ZDET_ANA_CTL_RANGE_CTL	GENMASK(3, 0)
#define WCD939X_MBHC_NEW_ZDET_RAMP_CTL			   (0x3124)
#define WCD939X_ZDET_RAMP_CTL_ACC1_MIN_CTL	GENMASK(6, 4)
#define WCD939X_ZDET_RAMP_CTL_TIME_CTL	GENMASK(3, 0)
#define WCD939X_MBHC_NEW_FSM_STATUS			   (0x3125)
#define WCD939X_FSM_STATUS_ADC_TIMEOUT	BIT(7)
#define WCD939X_FSM_STATUS_ADC_COMPLETE	BIT(6)
#define WCD939X_FSM_STATUS_HS_M_COMP_STATUS	BIT(5)
#define WCD939X_FSM_STATUS_FAST_PRESS_FLAG_STATUS	BIT(4)
#define WCD939X_FSM_STATUS_FAST_REMOVAL_FLAG_STATUS	BIT(3)
#define WCD939X_FSM_STATUS_REMOVAL_FLAG_STATUS	BIT(2)
#define WCD939X_FSM_STATUS_ELECT_REM_RT_STATUS	BIT(1)
#define WCD939X_FSM_STATUS_BTN_STATUS	BIT(0)
#define WCD939X_MBHC_NEW_ADC_RESULT			   (0x3126)
#define WCD939X_ADC_RESULT_VALUE	GENMASK(7, 0)
#define WCD939X_TX_NEW_CH12_MUX				   (0x3127)
#define WCD939X_TX_NEW_CH34_MUX				   (0x3128)
#define WCD939X_DIE_CRACK_DET_EN			   (0x312c)
#define WCD939X_DIE_CRACK_DET_OUT			   (0x312d)
#define WCD939X_HPH_NEW_INT_RDAC_GAIN_CTL		   (0x3132)
#define WCD939X_HPH_NEW_INT_PA_GAIN_CTL_L		   (0x3133)
#define WCD939X_PA_GAIN_CTL_L_EN_HPHPA_2VPK	BIT(7)
#define WCD939X_PA_GAIN_CTL_L_RX_SUPPLY_LEVEL	BIT(6)
#define WCD939X_PA_GAIN_CTL_L_DAC_DR_BOOST	BIT(5)
#define WCD939X_PA_GAIN_CTL_L_VALUE	GENMASK(4, 0)
#define WCD939X_HPH_NEW_INT_RDAC_VREF_CTL		   (0x3134)
#define WCD939X_HPH_NEW_INT_RDAC_OVERRIDE_CTL		   (0x3135)
#define WCD939X_HPH_NEW_INT_PA_GAIN_CTL_R		   (0x3136)
#define WCD939X_PA_GAIN_CTL_R_D_RCO_CLK_EN	BIT(7)
#define WCD939X_PA_GAIN_CTL_R_SPARE_BITS	GENMASK(6, 5)
#define WCD939X_PA_GAIN_CTL_R_VALUE	GENMASK(4, 0)
#define WCD939X_HPH_NEW_INT_PA_MISC1			   (0x3137)
#define WCD939X_HPH_NEW_INT_PA_MISC2			   (0x3138)
#define WCD939X_HPH_NEW_INT_PA_RDAC_MISC		   (0x3139)
#define WCD939X_HPH_NEW_INT_TIMER1			   (0x313a)
#define WCD939X_TIMER1_CURR_IDIV_CTL_CMPDR_OFF	GENMASK(7, 5)
#define WCD939X_TIMER1_CURR_IDIV_CTL_AUTOCHOP	GENMASK(4, 2)
#define WCD939X_TIMER1_AUTOCHOP_TIMER_CTL_EN	BIT(1)
#define WCD939X_HPH_NEW_INT_TIMER2			   (0x313b)
#define WCD939X_HPH_NEW_INT_TIMER3			   (0x313c)
#define WCD939X_HPH_NEW_INT_TIMER4			   (0x313d)
#define WCD939X_HPH_NEW_INT_PA_RDAC_MISC2		   (0x313e)
#define WCD939X_HPH_NEW_INT_PA_RDAC_MISC3		   (0x313f)
#define WCD939X_HPH_NEW_INT_RDAC_HD2_CTL_L		   (0x3140)
#define WCD939X_RDAC_HD2_CTL_L_EN_HD2_RES_DIV_L	BIT(7)
#define WCD939X_RDAC_HD2_CTL_L_HD2_RES_DIV_PULLGND_L	BIT(6)
#define WCD939X_RDAC_HD2_CTL_L_HD2_RES_DIV_CTL_L	GENMASK(5, 0)
#define WCD939X_HPH_NEW_INT_RDAC_HD2_CTL_R		   (0x3141)
#define WCD939X_RDAC_HD2_CTL_R_EN_HD2_RES_DIV_R	BIT(7)
#define WCD939X_RDAC_HD2_CTL_R_HD2_RES_DIV_PULLGND_L	BIT(6)
#define WCD939X_RDAC_HD2_CTL_R_HD2_RES_DIV_CTL_R	GENMASK(5, 0)
#define WCD939X_RX_NEW_INT_HPH_RDAC_BIAS_LOHIFI		   (0x3145)
#define WCD939X_RX_NEW_INT_HPH_RDAC_BIAS_ULP		   (0x3146)
#define WCD939X_RX_NEW_INT_HPH_RDAC_LDO_LP		   (0x3147)
#define WCD939X_MBHC_NEW_INT_MOISTURE_DET_DC_CTRL	   (0x31af)
#define WCD939X_MOISTURE_DET_DC_CTRL_ONCOUNT	GENMASK(6, 5)
#define WCD939X_MOISTURE_DET_DC_CTRL_OFFCOUNT	GENMASK(4, 0)
#define WCD939X_MBHC_NEW_INT_MOISTURE_DET_POLLING_CTRL	   (0x31b0)
#define WCD939X_MOISTURE_DET_POLLING_CTRL_HPHL_PA_EN	BIT(6)
#define WCD939X_MOISTURE_DET_POLLING_CTRL_DTEST_EN	GENMASK(5, 4)
#define WCD939X_MOISTURE_DET_POLLING_CTRL_MOIST_OVRD_POLLING	BIT(3)
#define WCD939X_MOISTURE_DET_POLLING_CTRL_MOIST_EN_POLLING	BIT(2)
#define WCD939X_MOISTURE_DET_POLLING_CTRL_MOIST_DBNC_TIME	GENMASK(1, 0)
#define WCD939X_MBHC_NEW_INT_MECH_DET_CURRENT		   (0x31b1)
#define WCD939X_MECH_DET_CURRENT_HSDET_PULLUP_CTL	GENMASK(4, 0)
#define WCD939X_MBHC_NEW_INT_ZDET_CLK_AND_MOISTURE_CTL_NEW (0x31b2)
#define WCD939X_EAR_INT_NEW_CHOPPER_CON			   (0x31b7)
#define WCD939X_EAR_INT_NEW_CNP_VCM_CON1		   (0x31b8)
#define WCD939X_EAR_INT_NEW_CNP_VCM_CON2		   (0x31b9)
#define WCD939X_EAR_INT_NEW_DYNAMIC_BIAS		   (0x31ba)
#define WCD939X_SLEEP_INT_WATCHDOG_CTL_1		   (0x31d0)
#define WCD939X_SLEEP_INT_WATCHDOG_CTL_2		   (0x31d1)
#define WCD939X_DIE_CRACK_INT_DET_INT1			   (0x31d3)
#define WCD939X_DIE_CRACK_INT_DET_INT2			   (0x31d4)
#define WCD939X_TX_COM_NEW_INT_FE_DIVSTOP_L2		   (0x31d5)
#define WCD939X_TX_COM_NEW_INT_FE_DIVSTOP_L1		   (0x31d6)
#define WCD939X_TX_COM_NEW_INT_FE_DIVSTOP_L0		   (0x31d7)
#define WCD939X_TX_COM_NEW_INT_FE_DIVSTOP_ULP1P2M	   (0x31d8)
#define WCD939X_TX_COM_NEW_INT_FE_DIVSTOP_ULP0P6M	   (0x31d9)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG1_L2L1	   (0x31da)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG1_L0		   (0x31db)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG1_ULP	   (0x31dc)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG2MAIN_L2L1	   (0x31dd)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG2MAIN_L0	   (0x31de)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG2MAIN_ULP	   (0x31df)
#define WCD939X_FE_ICTRL_STG2MAIN_ULP_VALUE	GENMASK(4, 0)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG2CASC_L2L1L0	   (0x31e0)
#define WCD939X_TX_COM_NEW_INT_FE_ICTRL_STG2CASC_ULP	   (0x31e1)
#define WCD939X_FE_ICTRL_STG2CASC_ULP_ICTRL_SCBIAS_ULP0P6M	GENMASK(7, 4)
#define WCD939X_FE_ICTRL_STG2CASC_ULP_VALUE	GENMASK(3, 0)
#define WCD939X_TX_COM_NEW_INT_ADC_SCBIAS_L2L1		   (0x31e2)
#define WCD939X_TX_COM_NEW_INT_ADC_SCBIAS_L0ULP		   (0x31e3)
#define WCD939X_TX_COM_NEW_INT_ADC_INT_L2		   (0x31e4)
#define WCD939X_TX_COM_NEW_INT_ADC_INT_L1		   (0x31e5)
#define WCD939X_TX_COM_NEW_INT_ADC_INT_L0		   (0x31e6)
#define WCD939X_TX_COM_NEW_INT_ADC_INT_ULP		   (0x31e7)
#define WCD939X_DIGITAL_PAGE				   (0x3400)
#define WCD939X_DIGITAL_CHIP_ID0			   (0x3401)
#define WCD939X_DIGITAL_CHIP_ID1			   (0x3402)
#define WCD939X_DIGITAL_CHIP_ID2			   (0x3403)
#define WCD939X_DIGITAL_CHIP_ID3			   (0x3404)
#define WCD939X_DIGITAL_SWR_TX_CLK_RATE			   (0x3405)
#define WCD939X_DIGITAL_CDC_RST_CTL			   (0x3406)
#define WCD939X_DIGITAL_TOP_CLK_CFG			   (0x3407)
#define WCD939X_DIGITAL_CDC_ANA_CLK_CTL			   (0x3408)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_TX_DIV4_CLK_EN	BIT(5)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_TX_DIV2_CLK_EN	BIT(4)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_TX_CLK_EN	BIT(3)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_RX_DIV4_CLK_EN	BIT(2)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_RX_DIV2_CLK_EN	BIT(1)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_RX_CLK_EN	BIT(0)
#define WCD939X_CDC_ANA_CLK_CTL_ANA_TX_DIV2_CLK_EN	BIT(4)
#define WCD939X_DIGITAL_CDC_DIG_CLK_CTL			   (0x3409)
#define WCD939X_CDC_DIG_CLK_CTL_TXD3_CLK_EN	BIT(7)
#define WCD939X_CDC_DIG_CLK_CTL_TXD2_CLK_EN	BIT(6)
#define WCD939X_CDC_DIG_CLK_CTL_TXD1_CLK_EN	BIT(5)
#define WCD939X_CDC_DIG_CLK_CTL_TXD0_CLK_EN	BIT(4)
#define WCD939X_CDC_DIG_CLK_CTL_RXD2_CLK_EN	BIT(2)
#define WCD939X_CDC_DIG_CLK_CTL_RXD1_CLK_EN	BIT(1)
#define WCD939X_CDC_DIG_CLK_CTL_RXD0_CLK_EN	BIT(0)
#define WCD939X_DIGITAL_SWR_RST_EN			   (0x340a)
#define WCD939X_DIGITAL_CDC_PATH_MODE			   (0x340b)
#define WCD939X_DIGITAL_CDC_RX_RST			   (0x340c)
#define WCD939X_DIGITAL_CDC_RX0_CTL			   (0x340d)
#define WCD939X_DIGITAL_CDC_RX1_CTL			   (0x340e)
#define WCD939X_DIGITAL_CDC_RX2_CTL			   (0x340f)
#define WCD939X_DIGITAL_CDC_TX_ANA_MODE_0_1		   (0x3410)
#define WCD939X_CDC_TX_ANA_MODE_0_1_TXD1_MODE	GENMASK(7, 4)
#define WCD939X_CDC_TX_ANA_MODE_0_1_TXD0_MODE	GENMASK(3, 0)
#define WCD939X_DIGITAL_CDC_TX_ANA_MODE_2_3		   (0x3411)
#define WCD939X_CDC_TX_ANA_MODE_2_3_TXD3_MODE	GENMASK(7, 4)
#define WCD939X_CDC_TX_ANA_MODE_2_3_TXD2_MODE	GENMASK(3, 0)
#define WCD939X_DIGITAL_CDC_COMP_CTL_0			   (0x3414)
#define WCD939X_CDC_COMP_CTL_0_HPHL_COMP_EN	BIT(1)
#define WCD939X_CDC_COMP_CTL_0_HPHR_COMP_EN	BIT(0)
#define WCD939X_DIGITAL_CDC_ANA_TX_CLK_CTL		   (0x3417)
#define WCD939X_CDC_ANA_TX_CLK_CTL_ANA_MBHC_1P2M_CLK_EN	BIT(5)
#define WCD939X_CDC_ANA_TX_CLK_CTL_ANA_TX3_ADC_CLK_EN	BIT(4)
#define WCD939X_CDC_ANA_TX_CLK_CTL_ANA_TX2_ADC_CLK_EN	BIT(3)
#define WCD939X_CDC_ANA_TX_CLK_CTL_ANA_TX1_ADC_CLK_EN	BIT(2)
#define WCD939X_CDC_ANA_TX_CLK_CTL_ANA_TX0_ADC_CLK_EN	BIT(1)
#define WCD939X_CDC_ANA_TX_CLK_CTL_ANA_TXSCBIAS_CLK_EN	BIT(0)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A1_0		   (0x3418)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A1_1		   (0x3419)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A2_0		   (0x341a)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A2_1		   (0x341b)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A3_0		   (0x341c)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A3_1		   (0x341d)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A4_0		   (0x341e)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A4_1		   (0x341f)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A5_0		   (0x3420)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A5_1		   (0x3421)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A6_0		   (0x3422)
#define WCD939X_DIGITAL_CDC_HPH_DSM_A7_0		   (0x3423)
#define WCD939X_DIGITAL_CDC_HPH_DSM_C_0			   (0x3424)
#define WCD939X_DIGITAL_CDC_HPH_DSM_C_1			   (0x3425)
#define WCD939X_DIGITAL_CDC_HPH_DSM_C_2			   (0x3426)
#define WCD939X_DIGITAL_CDC_HPH_DSM_C_3			   (0x3427)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R1			   (0x3428)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R2			   (0x3429)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R3			   (0x342a)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R4			   (0x342b)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R5			   (0x342c)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R6			   (0x342d)
#define WCD939X_DIGITAL_CDC_HPH_DSM_R7			   (0x342e)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A1_0		   (0x342f)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A1_1		   (0x3430)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A2_0		   (0x3431)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A2_1		   (0x3432)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A3_0		   (0x3433)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A3_1		   (0x3434)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A4_0		   (0x3435)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A4_1		   (0x3436)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A5_0		   (0x3437)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A5_1		   (0x3438)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A6_0		   (0x3439)
#define WCD939X_DIGITAL_CDC_EAR_DSM_A7_0		   (0x343a)
#define WCD939X_DIGITAL_CDC_EAR_DSM_C_0			   (0x343b)
#define WCD939X_DIGITAL_CDC_EAR_DSM_C_1			   (0x343c)
#define WCD939X_DIGITAL_CDC_EAR_DSM_C_2			   (0x343d)
#define WCD939X_DIGITAL_CDC_EAR_DSM_C_3			   (0x343e)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R1			   (0x343f)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R2			   (0x3440)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R3			   (0x3441)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R4			   (0x3442)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R5			   (0x3443)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R6			   (0x3444)
#define WCD939X_DIGITAL_CDC_EAR_DSM_R7			   (0x3445)
#define WCD939X_DIGITAL_CDC_HPH_GAIN_RX_0		   (0x3446)
#define WCD939X_DIGITAL_CDC_HPH_GAIN_RX_1		   (0x3447)
#define WCD939X_DIGITAL_CDC_HPH_GAIN_DSD_0		   (0x3448)
#define WCD939X_DIGITAL_CDC_HPH_GAIN_DSD_1		   (0x3449)
#define WCD939X_DIGITAL_CDC_HPH_GAIN_DSD_2		   (0x344a)
#define WCD939X_DIGITAL_CDC_EAR_GAIN_DSD_0		   (0x344b)
#define WCD939X_DIGITAL_CDC_EAR_GAIN_DSD_1		   (0x344c)
#define WCD939X_DIGITAL_CDC_EAR_GAIN_DSD_2		   (0x344d)
#define WCD939X_DIGITAL_CDC_HPH_GAIN_CTL		   (0x344e)
#define WCD939X_CDC_HPH_GAIN_CTL_HPH_STEREO_EN	BIT(4)
#define WCD939X_CDC_HPH_GAIN_CTL_HPHR_RX_EN	BIT(3)
#define WCD939X_CDC_HPH_GAIN_CTL_HPHL_RX_EN	BIT(2)
#define WCD939X_CDC_HPH_GAIN_CTL_HPHR_DSD_EN	BIT(1)
#define WCD939X_CDC_HPH_GAIN_CTL_HPHL_DSD_EN	BIT(0)
#define WCD939X_DIGITAL_CDC_EAR_GAIN_CTL		   (0x344f)
#define WCD939X_CDC_EAR_GAIN_CTL_EAR_EN	BIT(0)
#define WCD939X_DIGITAL_CDC_EAR_PATH_CTL		   (0x3450)
#define WCD939X_DIGITAL_CDC_SWR_CLH			   (0x3451)
#define WCD939X_CDC_SWR_CLH_CLH_CTL	GENMASK(7, 0)
#define WCD939X_DIGITAL_SWR_CLH_BYP			   (0x3452)
#define WCD939X_DIGITAL_CDC_TX0_CTL			   (0x3453)
#define WCD939X_DIGITAL_CDC_TX1_CTL			   (0x3454)
#define WCD939X_DIGITAL_CDC_TX2_CTL			   (0x3455)
#define WCD939X_DIGITAL_CDC_TX_RST			   (0x3456)
#define WCD939X_DIGITAL_CDC_REQ_CTL			   (0x3457)
#define WCD939X_CDC_REQ_CTL_TX3_WIDE_BAND	BIT(5)
#define WCD939X_CDC_REQ_CTL_TX2_WIDE_BAND	BIT(4)
#define WCD939X_CDC_REQ_CTL_TX1_WIDE_BAND	BIT(3)
#define WCD939X_CDC_REQ_CTL_TX0_WIDE_BAND	BIT(2)
#define WCD939X_CDC_REQ_CTL_FS_RATE_4P8	BIT(1)
#define WCD939X_CDC_REQ_CTL_NO_NOTCH	BIT(0)
#define WCD939X_DIGITAL_CDC_RST				   (0x3458)
#define WCD939X_DIGITAL_CDC_AMIC_CTL			   (0x345a)
#define WCD939X_CDC_AMIC_CTL_AMIC5_IN_SEL	BIT(3)
#define WCD939X_CDC_AMIC_CTL_AMIC4_IN_SEL	BIT(2)
#define WCD939X_CDC_AMIC_CTL_AMIC3_IN_SEL	BIT(1)
#define WCD939X_CDC_AMIC_CTL_AMIC1_IN_SEL	BIT(0)
#define WCD939X_DIGITAL_CDC_DMIC_CTL			   (0x345b)
#define WCD939X_CDC_DMIC_CTL_DMIC_LEGACY_SW_MODE	BIT(3)
#define WCD939X_CDC_DMIC_CTL_DMIC_DIV_BAK_EN	BIT(2)
#define WCD939X_CDC_DMIC_CTL_CLK_SCALE_EN	BIT(1)
#define WCD939X_CDC_DMIC_CTL_SOFT_RESET	BIT(0)
#define WCD939X_DIGITAL_CDC_DMIC1_CTL			   (0x345c)
#define WCD939X_CDC_DMIC1_CTL_DMIC_CLK_SCALE_SEL	GENMASK(6, 4)
#define WCD939X_CDC_DMIC1_CTL_DMIC_CLK_EN	BIT(3)
#define WCD939X_CDC_DMIC1_CTL_DMIC_CLK_SEL	GENMASK(2, 0)
#define WCD939X_DIGITAL_CDC_DMIC2_CTL			   (0x345d)
#define WCD939X_CDC_DMIC2_CTL_DMIC_LEFT_EN	BIT(7)
#define WCD939X_CDC_DMIC2_CTL_DMIC_CLK_SCALE_SEL	GENMASK(6, 4)
#define WCD939X_CDC_DMIC2_CTL_DMIC_CLK_EN	BIT(3)
#define WCD939X_CDC_DMIC2_CTL_DMIC_CLK_SEL	GENMASK(2, 0)
#define WCD939X_DIGITAL_CDC_DMIC3_CTL			   (0x345e)
#define WCD939X_CDC_DMIC3_CTL_DMIC_CLK_SCALE_SEL	GENMASK(6, 4)
#define WCD939X_CDC_DMIC3_CTL_DMIC_CLK_EN	BIT(3)
#define WCD939X_CDC_DMIC3_CTL_DMIC_CLK_SEL	GENMASK(2, 0)
#define WCD939X_DIGITAL_CDC_DMIC4_CTL			   (0x345f)
#define WCD939X_CDC_DMIC4_CTL_DMIC_CLK_SCALE_SEL	GENMASK(6, 4)
#define WCD939X_CDC_DMIC4_CTL_DMIC_CLK_EN	BIT(3)
#define WCD939X_CDC_DMIC4_CTL_DMIC_CLK_SEL	GENMASK(2, 0)
#define WCD939X_DIGITAL_EFUSE_PRG_CTL			   (0x3460)
#define WCD939X_DIGITAL_EFUSE_CTL			   (0x3461)
#define WCD939X_DIGITAL_CDC_DMIC_RATE_1_2		   (0x3462)
#define WCD939X_CDC_DMIC_RATE_1_2_DMIC2_RATE	GENMASK(7, 4)
#define WCD939X_CDC_DMIC_RATE_1_2_DMIC1_RATE	GENMASK(3, 0)
#define WCD939X_DIGITAL_CDC_DMIC_RATE_3_4		   (0x3463)
#define WCD939X_CDC_DMIC_RATE_3_4_DMIC4_RATE	GENMASK(7, 4)
#define WCD939X_CDC_DMIC_RATE_3_4_DMIC3_RATE	GENMASK(3, 0)
#define WCD939X_DIGITAL_PDM_WD_CTL0			   (0x3465)
#define WCD939X_PDM_WD_CTL0_HOLD_OFF	BIT(4)
#define WCD939X_PDM_WD_CTL0_TIME_OUT_SEL	BIT(3)
#define WCD939X_PDM_WD_CTL0_PDM_WD_EN	GENMASK(2, 0)
#define WCD939X_DIGITAL_PDM_WD_CTL1			   (0x3466)
#define WCD939X_PDM_WD_CTL1_HOLD_OFF	BIT(4)
#define WCD939X_PDM_WD_CTL1_TIME_OUT_SEL	BIT(3)
#define WCD939X_PDM_WD_CTL1_PDM_WD_EN	GENMASK(2, 0)
#define WCD939X_DIGITAL_PDM_WD_CTL2			   (0x3467)
#define WCD939X_DIGITAL_INTR_MODE			   (0x346a)
#define WCD939X_DIGITAL_INTR_MASK_0			   (0x346b)
#define WCD939X_DIGITAL_INTR_MASK_1			   (0x346c)
#define WCD939X_DIGITAL_INTR_MASK_2			   (0x346d)
#define WCD939X_DIGITAL_INTR_STATUS_0			   (0x346e)
#define WCD939X_DIGITAL_INTR_STATUS_1			   (0x346f)
#define WCD939X_DIGITAL_INTR_STATUS_2			   (0x3470)
#define WCD939X_DIGITAL_INTR_CLEAR_0			   (0x3471)
#define WCD939X_DIGITAL_INTR_CLEAR_1			   (0x3472)
#define WCD939X_DIGITAL_INTR_CLEAR_2			   (0x3473)
#define WCD939X_DIGITAL_INTR_LEVEL_0			   (0x3474)
#define WCD939X_DIGITAL_INTR_LEVEL_1			   (0x3475)
#define WCD939X_DIGITAL_INTR_LEVEL_2			   (0x3476)
#define WCD939X_DIGITAL_INTR_SET_0			   (0x3477)
#define WCD939X_DIGITAL_INTR_SET_1			   (0x3478)
#define WCD939X_DIGITAL_INTR_SET_2			   (0x3479)
#define WCD939X_DIGITAL_INTR_TEST_0			   (0x347a)
#define WCD939X_DIGITAL_INTR_TEST_1			   (0x347b)
#define WCD939X_DIGITAL_INTR_TEST_2			   (0x347c)
#define WCD939X_DIGITAL_TX_MODE_DBG_EN			   (0x347f)
#define WCD939X_DIGITAL_TX_MODE_DBG_0_1			   (0x3480)
#define WCD939X_DIGITAL_TX_MODE_DBG_2_3			   (0x3481)
#define WCD939X_DIGITAL_LB_IN_SEL_CTL			   (0x3482)
#define WCD939X_DIGITAL_LOOP_BACK_MODE			   (0x3483)
#define WCD939X_DIGITAL_SWR_DAC_TEST			   (0x3484)
#define WCD939X_DIGITAL_SWR_HM_TEST_RX_0		   (0x3485)
#define WCD939X_DIGITAL_SWR_HM_TEST_TX_0		   (0x3486)
#define WCD939X_DIGITAL_SWR_HM_TEST_RX_1		   (0x3487)
#define WCD939X_DIGITAL_SWR_HM_TEST_TX_1		   (0x3488)
#define WCD939X_DIGITAL_SWR_HM_TEST_TX_2		   (0x3489)
#define WCD939X_DIGITAL_SWR_HM_TEST_0			   (0x348a)
#define WCD939X_DIGITAL_SWR_HM_TEST_1			   (0x348b)
#define WCD939X_DIGITAL_PAD_CTL_SWR_0			   (0x348c)
#define WCD939X_DIGITAL_PAD_CTL_SWR_1			   (0x348d)
#define WCD939X_DIGITAL_I2C_CTL				   (0x348e)
#define WCD939X_DIGITAL_CDC_TX_TANGGU_SW_MODE		   (0x348f)
#define WCD939X_DIGITAL_EFUSE_TEST_CTL_0		   (0x3490)
#define WCD939X_DIGITAL_EFUSE_TEST_CTL_1		   (0x3491)
#define WCD939X_DIGITAL_EFUSE_T_DATA_0			   (0x3492)
#define WCD939X_DIGITAL_EFUSE_T_DATA_1			   (0x3493)
#define WCD939X_DIGITAL_PAD_CTL_PDM_RX0			   (0x3494)
#define WCD939X_DIGITAL_PAD_CTL_PDM_RX1			   (0x3495)
#define WCD939X_DIGITAL_PAD_CTL_PDM_TX0			   (0x3496)
#define WCD939X_DIGITAL_PAD_CTL_PDM_TX1			   (0x3497)
#define WCD939X_DIGITAL_PAD_CTL_PDM_TX2			   (0x3498)
#define WCD939X_DIGITAL_PAD_INP_DIS_0			   (0x3499)
#define WCD939X_DIGITAL_PAD_INP_DIS_1			   (0x349a)
#define WCD939X_DIGITAL_DRIVE_STRENGTH_0		   (0x349b)
#define WCD939X_DIGITAL_DRIVE_STRENGTH_1		   (0x349c)
#define WCD939X_DIGITAL_DRIVE_STRENGTH_2		   (0x349d)
#define WCD939X_DIGITAL_RX_DATA_EDGE_CTL		   (0x349e)
#define WCD939X_DIGITAL_TX_DATA_EDGE_CTL		   (0x349f)
#define WCD939X_DIGITAL_GPIO_MODE			   (0x34a0)
#define WCD939X_DIGITAL_PIN_CTL_OE			   (0x34a1)
#define WCD939X_DIGITAL_PIN_CTL_DATA_0			   (0x34a2)
#define WCD939X_DIGITAL_PIN_CTL_DATA_1			   (0x34a3)
#define WCD939X_DIGITAL_PIN_STATUS_0			   (0x34a4)
#define WCD939X_DIGITAL_PIN_STATUS_1			   (0x34a5)
#define WCD939X_DIGITAL_DIG_DEBUG_CTL			   (0x34a6)
#define WCD939X_DIGITAL_DIG_DEBUG_EN			   (0x34a7)
#define WCD939X_DIGITAL_ANA_CSR_DBG_ADD			   (0x34a8)
#define WCD939X_DIGITAL_ANA_CSR_DBG_CTL			   (0x34a9)
#define WCD939X_DIGITAL_SSP_DBG				   (0x34aa)
#define WCD939X_DIGITAL_MODE_STATUS_0			   (0x34ab)
#define WCD939X_DIGITAL_MODE_STATUS_1			   (0x34ac)
#define WCD939X_DIGITAL_SPARE_0				   (0x34ad)
#define WCD939X_DIGITAL_SPARE_1				   (0x34ae)
#define WCD939X_DIGITAL_SPARE_2				   (0x34af)
#define WCD939X_DIGITAL_EFUSE_REG_0			   (0x34b0)
#define WCD939X_EFUSE_REG_0_WCD939X_ID	GENMASK(4, 1)
#define WCD939X_EFUSE_REG_0_EFUSE_BLOWN	BIT(0)
#define WCD939X_DIGITAL_EFUSE_REG_1			   (0x34b1)
#define WCD939X_DIGITAL_EFUSE_REG_2			   (0x34b2)
#define WCD939X_DIGITAL_EFUSE_REG_3			   (0x34b3)
#define WCD939X_DIGITAL_EFUSE_REG_4			   (0x34b4)
#define WCD939X_DIGITAL_EFUSE_REG_5			   (0x34b5)
#define WCD939X_DIGITAL_EFUSE_REG_6			   (0x34b6)
#define WCD939X_DIGITAL_EFUSE_REG_7			   (0x34b7)
#define WCD939X_DIGITAL_EFUSE_REG_8			   (0x34b8)
#define WCD939X_DIGITAL_EFUSE_REG_9			   (0x34b9)
#define WCD939X_DIGITAL_EFUSE_REG_10			   (0x34ba)
#define WCD939X_DIGITAL_EFUSE_REG_11			   (0x34bb)
#define WCD939X_DIGITAL_EFUSE_REG_12			   (0x34bc)
#define WCD939X_DIGITAL_EFUSE_REG_13			   (0x34bd)
#define WCD939X_DIGITAL_EFUSE_REG_14			   (0x34be)
#define WCD939X_DIGITAL_EFUSE_REG_15			   (0x34bf)
#define WCD939X_DIGITAL_EFUSE_REG_16			   (0x34c0)
#define WCD939X_DIGITAL_EFUSE_REG_17			   (0x34c1)
#define WCD939X_DIGITAL_EFUSE_REG_18			   (0x34c2)
#define WCD939X_DIGITAL_EFUSE_REG_19			   (0x34c3)
#define WCD939X_DIGITAL_EFUSE_REG_20			   (0x34c4)
#define WCD939X_DIGITAL_EFUSE_REG_21			   (0x34c5)
#define WCD939X_DIGITAL_EFUSE_REG_22			   (0x34c6)
#define WCD939X_DIGITAL_EFUSE_REG_23			   (0x34c7)
#define WCD939X_DIGITAL_EFUSE_REG_24			   (0x34c8)
#define WCD939X_DIGITAL_EFUSE_REG_25			   (0x34c9)
#define WCD939X_DIGITAL_EFUSE_REG_26			   (0x34ca)
#define WCD939X_DIGITAL_EFUSE_REG_27			   (0x34cb)
#define WCD939X_DIGITAL_EFUSE_REG_28			   (0x34cc)
#define WCD939X_DIGITAL_EFUSE_REG_29			   (0x34cd)
#define WCD939X_DIGITAL_EFUSE_REG_30			   (0x34ce)
#define WCD939X_DIGITAL_EFUSE_REG_31			   (0x34cf)
#define WCD939X_DIGITAL_TX_REQ_FB_CTL_0			   (0x34d0)
#define WCD939X_DIGITAL_TX_REQ_FB_CTL_1			   (0x34d1)
#define WCD939X_DIGITAL_TX_REQ_FB_CTL_2			   (0x34d2)
#define WCD939X_DIGITAL_TX_REQ_FB_CTL_3			   (0x34d3)
#define WCD939X_DIGITAL_TX_REQ_FB_CTL_4			   (0x34d4)
#define WCD939X_DIGITAL_DEM_BYPASS_DATA0		   (0x34d5)
#define WCD939X_DIGITAL_DEM_BYPASS_DATA1		   (0x34d6)
#define WCD939X_DIGITAL_DEM_BYPASS_DATA2		   (0x34d7)
#define WCD939X_DIGITAL_DEM_BYPASS_DATA3		   (0x34d8)
#define WCD939X_DIGITAL_DEM_SECOND_ORDER		   (0x34d9)
#define WCD939X_DIGITAL_DSM_CTRL			   (0x34da)
#define WCD939X_DIGITAL_DSM_0_STATIC_DATA_0		   (0x34db)
#define WCD939X_DIGITAL_DSM_0_STATIC_DATA_1		   (0x34dc)
#define WCD939X_DIGITAL_DSM_0_STATIC_DATA_2		   (0x34dd)
#define WCD939X_DIGITAL_DSM_0_STATIC_DATA_3		   (0x34de)
#define WCD939X_DIGITAL_DSM_1_STATIC_DATA_0		   (0x34df)
#define WCD939X_DIGITAL_DSM_1_STATIC_DATA_1		   (0x34e0)
#define WCD939X_DIGITAL_DSM_1_STATIC_DATA_2		   (0x34e1)
#define WCD939X_DIGITAL_DSM_1_STATIC_DATA_3		   (0x34e2)
#define WCD939X_RX_TOP_PAGE				   (0x3500)
#define WCD939X_RX_TOP_TOP_CFG0				   (0x3501)
#define WCD939X_TOP_CFG0_HPH_DAC_RATE_SEL	BIT(1)
#define WCD939X_TOP_CFG0_PGA_UPDATE	BIT(0)
#define WCD939X_RX_TOP_HPHL_COMP_WR_LSB			   (0x3502)
#define WCD939X_RX_TOP_HPHL_COMP_WR_MSB			   (0x3503)
#define WCD939X_RX_TOP_HPHL_COMP_LUT			   (0x3504)
#define WCD939X_RX_TOP_HPHL_COMP_RD_LSB			   (0x3505)
#define WCD939X_RX_TOP_HPHL_COMP_RD_MSB			   (0x3506)
#define WCD939X_RX_TOP_HPHR_COMP_WR_LSB			   (0x3507)
#define WCD939X_RX_TOP_HPHR_COMP_WR_MSB			   (0x3508)
#define WCD939X_RX_TOP_HPHR_COMP_LUT			   (0x3509)
#define WCD939X_RX_TOP_HPHR_COMP_RD_LSB			   (0x350a)
#define WCD939X_RX_TOP_HPHR_COMP_RD_MSB			   (0x350b)
#define WCD939X_RX_TOP_DSD0_DEBUG_CFG1			   (0x350c)
#define WCD939X_RX_TOP_DSD0_DEBUG_CFG2			   (0x350d)
#define WCD939X_RX_TOP_DSD0_DEBUG_CFG3			   (0x350e)
#define WCD939X_RX_TOP_DSD0_DEBUG_CFG4			   (0x350f)
#define WCD939X_RX_TOP_DSD0_DEBUG_CFG5			   (0x3510)
#define WCD939X_RX_TOP_DSD0_DEBUG_CFG6			   (0x3511)
#define WCD939X_RX_TOP_DSD1_DEBUG_CFG1			   (0x3512)
#define WCD939X_RX_TOP_DSD1_DEBUG_CFG2			   (0x3513)
#define WCD939X_RX_TOP_DSD1_DEBUG_CFG3			   (0x3514)
#define WCD939X_RX_TOP_DSD1_DEBUG_CFG4			   (0x3515)
#define WCD939X_RX_TOP_DSD1_DEBUG_CFG5			   (0x3516)
#define WCD939X_RX_TOP_DSD1_DEBUG_CFG6			   (0x3517)
#define WCD939X_RX_TOP_HPHL_PATH_CFG0			   (0x351c)
#define WCD939X_HPHL_PATH_CFG0_INT_EN	BIT(1)
#define WCD939X_HPHL_PATH_CFG0_DLY_ZN_EN	BIT(0)
#define WCD939X_RX_TOP_HPHL_PATH_CFG1			   (0x351d)
#define WCD939X_HPHL_PATH_CFG1_DSM_SOFT_RST	BIT(5)
#define WCD939X_HPHL_PATH_CFG1_INT_SOFT_RST	BIT(4)
#define WCD939X_HPHL_PATH_CFG1_FMT_CONV	BIT(3)
#define WCD939X_HPHL_PATH_CFG1_IDLE_OVRD_EN	BIT(2)
#define WCD939X_HPHL_PATH_CFG1_RX_DC_DROOP_COEFF_SEL	GENMASK(1, 0)
#define WCD939X_RX_TOP_HPHR_PATH_CFG0			   (0x351e)
#define WCD939X_HPHR_PATH_CFG0_INT_EN	BIT(2)
#define WCD939X_HPHR_PATH_CFG0_DLY_ZN_EN	BIT(1)
#define WCD939X_RX_TOP_HPHR_PATH_CFG1			   (0x351f)
#define WCD939X_HPHR_PATH_CFG1_DSM_SOFT_RST	BIT(5)
#define WCD939X_HPHR_PATH_CFG1_INT_SOFT_RST	BIT(4)
#define WCD939X_HPHR_PATH_CFG1_FMT_CONV	BIT(3)
#define WCD939X_HPHR_PATH_CFG1_IDLE_OVRD_EN	BIT(2)
#define WCD939X_HPHR_PATH_CFG1_RX_DC_DROOP_COEFF_SEL	GENMASK(1, 0)
#define WCD939X_RX_TOP_PATH_CFG2			   (0x3520)
#define WCD939X_RX_TOP_HPHL_PATH_SEC0			   (0x3521)
#define WCD939X_RX_TOP_HPHL_PATH_SEC1			   (0x3522)
#define WCD939X_RX_TOP_HPHL_PATH_SEC2			   (0x3523)
#define WCD939X_RX_TOP_HPHL_PATH_SEC3			   (0x3524)
#define WCD939X_RX_TOP_HPHR_PATH_SEC0			   (0x3525)
#define WCD939X_RX_TOP_HPHR_PATH_SEC1			   (0x3526)
#define WCD939X_RX_TOP_HPHR_PATH_SEC2			   (0x3527)
#define WCD939X_RX_TOP_HPHR_PATH_SEC3			   (0x3528)
#define WCD939X_RX_TOP_PATH_SEC4			   (0x3529)
#define WCD939X_RX_TOP_PATH_SEC5			   (0x352a)
#define WCD939X_COMPANDER_HPHL_CTL0			   (0x3540)
#define WCD939X_COMPANDER_HPHL_CTL1			   (0x3541)
#define WCD939X_COMPANDER_HPHL_CTL2			   (0x3542)
#define WCD939X_COMPANDER_HPHL_CTL3			   (0x3543)
#define WCD939X_COMPANDER_HPHL_CTL4			   (0x3544)
#define WCD939X_COMPANDER_HPHL_CTL5			   (0x3545)
#define WCD939X_COMPANDER_HPHL_CTL6			   (0x3546)
#define WCD939X_COMPANDER_HPHL_CTL7			   (0x3547)
#define WCD939X_COMPANDER_HPHL_CTL8			   (0x3548)
#define WCD939X_COMPANDER_HPHL_CTL9			   (0x3549)
#define WCD939X_COMPANDER_HPHL_CTL10			   (0x354a)
#define WCD939X_COMPANDER_HPHL_CTL11			   (0x354b)
#define WCD939X_COMPANDER_HPHL_CTL12			   (0x354c)
#define WCD939X_COMPANDER_HPHL_CTL13			   (0x354d)
#define WCD939X_COMPANDER_HPHL_CTL14			   (0x354e)
#define WCD939X_COMPANDER_HPHL_CTL15			   (0x354f)
#define WCD939X_COMPANDER_HPHL_CTL16			   (0x3550)
#define WCD939X_COMPANDER_HPHL_CTL17			   (0x3551)
#define WCD939X_COMPANDER_HPHL_CTL18			   (0x3552)
#define WCD939X_COMPANDER_HPHL_CTL19			   (0x3553)
#define WCD939X_R_CTL0					   (0x3560)
#define WCD939X_R_CTL1					   (0x3561)
#define WCD939X_R_CTL2					   (0x3562)
#define WCD939X_R_CTL3					   (0x3563)
#define WCD939X_R_CTL4					   (0x3564)
#define WCD939X_R_CTL5					   (0x3565)
#define WCD939X_R_CTL6					   (0x3566)
#define WCD939X_R_CTL7					   (0x3567)
#define WCD939X_R_CTL8					   (0x3568)
#define WCD939X_R_CTL9					   (0x3569)
#define WCD939X_R_CTL10					   (0x356a)
#define WCD939X_R_CTL11					   (0x356b)
#define WCD939X_R_CTL12					   (0x356c)
#define WCD939X_R_CTL13					   (0x356d)
#define WCD939X_R_CTL14					   (0x356e)
#define WCD939X_R_CTL15					   (0x356f)
#define WCD939X_R_CTL16					   (0x3570)
#define WCD939X_R_CTL17					   (0x3571)
#define WCD939X_R_CTL18					   (0x3572)
#define WCD939X_R_CTL19					   (0x3573)
#define WCD939X_E_PATH_CTL				   (0x3580)
#define WCD939X_E_CFG0					   (0x3581)
#define WCD939X_CFG0_AUTO_DISABLE_ANC	BIT(2)
#define WCD939X_CFG0_AUTO_DISABLE_DSD	BIT(1)
#define WCD939X_CFG0_IDLE_STEREO	BIT(0)
#define WCD939X_E_CFG1					   (0x3582)
#define WCD939X_E_CFG2					   (0x3583)
#define WCD939X_E_CFG3					   (0x3584)
#define WCD939X_DSD_HPHL_PATH_CTL			   (0x3590)
#define WCD939X_DSD_HPHL_CFG0				   (0x3591)
#define WCD939X_DSD_HPHL_CFG1				   (0x3592)
#define WCD939X_DSD_HPHL_CFG2				   (0x3593)
#define WCD939X_DSD_HPHL_CFG3				   (0x3594)
#define WCD939X_DSD_HPHL_CFG4				   (0x3595)
#define WCD939X_DSD_HPHL_CFG5				   (0x3596)
#define WCD939X_DSD_HPHR_PATH_CTL			   (0x35a0)
#define WCD939X_DSD_HPHR_CFG0				   (0x35a1)
#define WCD939X_DSD_HPHR_CFG1				   (0x35a2)
#define WCD939X_DSD_HPHR_CFG2				   (0x35a3)
#define WCD939X_DSD_HPHR_CFG3				   (0x35a4)
#define WCD939X_DSD_HPHR_CFG4				   (0x35a5)
#define WCD939X_DSD_HPHR_CFG5				   (0x35a6)
#define WCD939X_MAX_REGISTER				   (WCD939X_DSD_HPHR_CFG5)

#define WCD939X_MAX_SWR_PORTS		(6)
#define WCD939X_MAX_RX_SWR_PORTS	(6)
#define WCD939X_MAX_TX_SWR_PORTS	(4)
#define WCD939X_MAX_SWR_CH_IDS		(15)

struct wcd939x_sdw_ch_info {
	int port_num;
	unsigned int ch_mask;
};

#define WCD_SDW_CH(id, pn, cmask)	\
	[id] = {			\
		.port_num = pn,		\
		.ch_mask = cmask,	\
	}

enum wcd939x_tx_sdw_ports {
	WCD939X_ADC_1_4_PORT = 1,
	WCD939X_ADC_DMIC_1_2_PORT,
	WCD939X_DMIC_0_3_MBHC_PORT,
	WCD939X_DMIC_3_7_PORT,
};

enum wcd939x_tx_sdw_channels {
	WCD939X_ADC1,
	WCD939X_ADC2,
	WCD939X_ADC3,
	WCD939X_ADC4,
	WCD939X_DMIC0,
	WCD939X_DMIC1,
	WCD939X_MBHC,
	WCD939X_DMIC2,
	WCD939X_DMIC3,
	WCD939X_DMIC4,
	WCD939X_DMIC5,
	WCD939X_DMIC6,
	WCD939X_DMIC7,
};

enum wcd939x_rx_sdw_ports {
	WCD939X_HPH_PORT = 1,
	WCD939X_CLSH_PORT,
	WCD939X_COMP_PORT,
	WCD939X_LO_PORT,
	WCD939X_DSD_PORT,
	WCD939X_HIFI_PCM_PORT,
};

enum wcd939x_rx_sdw_channels {
	WCD939X_HPH_L,
	WCD939X_HPH_R,
	WCD939X_CLSH,
	WCD939X_COMP_L,
	WCD939X_COMP_R,
	WCD939X_LO,
	WCD939X_DSD_L,
	WCD939X_DSD_R,
	WCD939X_HIFI_PCM_L,
	WCD939X_HIFI_PCM_R,
};

struct wcd939x_priv;
struct wcd939x_sdw_priv {
	struct sdw_slave *sdev;
	struct sdw_stream_config sconfig;
	struct sdw_stream_runtime *sruntime;
	struct sdw_port_config port_config[WCD939X_MAX_SWR_PORTS];
	const struct wcd939x_sdw_ch_info *ch_info;
	bool port_enable[WCD939X_MAX_SWR_CH_IDS];
	int active_ports;
	bool is_tx;
	struct wcd939x_priv *wcd939x;
	struct irq_domain *slave_irq;
	struct regmap *regmap;
};

#if IS_ENABLED(CONFIG_SND_SOC_WCD939X_SDW)
int wcd939x_sdw_free(struct wcd939x_sdw_priv *wcd,
		     struct snd_pcm_substream *substream,
		     struct snd_soc_dai *dai);
int wcd939x_sdw_set_sdw_stream(struct wcd939x_sdw_priv *wcd,
			       struct snd_soc_dai *dai,
			       void *stream, int direction);
int wcd939x_sdw_hw_params(struct wcd939x_sdw_priv *wcd,
			  struct snd_pcm_substream *substream,
			  struct snd_pcm_hw_params *params,
			  struct snd_soc_dai *dai);

struct device *wcd939x_sdw_device_get(struct device_node *np);
unsigned int wcd939x_swr_get_current_bank(struct sdw_slave *sdev);

struct regmap *wcd939x_swr_get_regmap(struct wcd939x_sdw_priv *wcd);
#else

static inline int wcd939x_sdw_free(struct wcd939x_sdw_priv *wcd,
				   struct snd_pcm_substream *substream,
				   struct snd_soc_dai *dai)
{
	return -EOPNOTSUPP;
}

static inline int wcd939x_sdw_set_sdw_stream(struct wcd939x_sdw_priv *wcd,
					     struct snd_soc_dai *dai,
					     void *stream, int direction)
{
	return -EOPNOTSUPP;
}

static inline int wcd939x_sdw_hw_params(struct wcd939x_sdw_priv *wcd,
					struct snd_pcm_substream *substream,
					struct snd_pcm_hw_params *params,
					struct snd_soc_dai *dai)
{
	return -EOPNOTSUPP;
}

static inline struct device *wcd939x_sdw_device_get(struct device_node *np)
{
	return NULL;
}

static inline unsigned int wcd939x_swr_get_current_bank(struct sdw_slave *sdev)
{
	return 0;
}

struct regmap *wcd939x_swr_get_regmap(struct wcd939x_sdw_priv *wcd)
{
	return PTR_ERR(-EINVAL);
}
#endif /* CONFIG_SND_SOC_WCD939X_SDW */

#endif /* __WCD939X_H__ */
