/* session.c generated by valac 0.56.17, the Vala compiler
 * generated from session.vala, do not modify */

/* libenchant: Session
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <sys/types.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _enchant_pwl_unref0(var) ((var == NULL) ? NULL : (var = (enchant_pwl_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _enchant_provider_unref0(var) ((var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL)))
typedef struct _ParamSpecEnchantSession ParamSpecEnchantSession;

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
	gchar* language_tag;
	gchar* error;
	gboolean is_pwl;
	EnchantProvider* provider;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _ParamSpecEnchantSession {
	GParamSpec parent_instance;
};

static gpointer enchant_session_parent_class = NULL;

VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
static EnchantSession* enchant_session_new (void);
static EnchantSession* enchant_session_construct (GType object_type);
static void _g_free0_ (gpointer var);
VALA_EXTERN EnchantSession* enchant_session_with_implicit_pwl (EnchantProvider* provider,
                                                   const gchar* lang,
                                                   const gchar* pwl);
VALA_EXTERN gchar* enchant_get_user_config_dir (void);
VALA_EXTERN EnchantSession* enchant_session_with_pwl (EnchantProvider* provider,
                                          const gchar* pwlname,
                                          const gchar* exclname,
                                          const gchar* lang,
                                          gboolean fail_if_no_pwl);
VALA_EXTERN EnchantPWL* enchant_pwl_init_with_file (const gchar* file);
VALA_EXTERN EnchantPWL* enchant_pwl_init (void);
VALA_EXTERN void enchant_session_add (EnchantSession* self,
                          const gchar* word);
VALA_EXTERN void enchant_session_remove (EnchantSession* self,
                             const gchar* word);
VALA_EXTERN gboolean enchant_session_exclude (EnchantSession* self,
                                  const gchar* word);
VALA_EXTERN gint enchant_pwl_check (EnchantPWL* self,
                        const gchar* word_buf,
                        ssize_t len);
VALA_EXTERN gboolean enchant_session_contains (EnchantSession* self,
                                   const gchar* word);
VALA_EXTERN void enchant_session_clear_error (EnchantSession* self);
static void enchant_session_finalize (EnchantSession * obj);
static GType enchant_session_get_type_once (void);

static void
_g_free0_ (gpointer var)
{
#line 45 "session.vala"
	var = (g_free (var), NULL);
#line 199 "session.c"
}

static EnchantSession*
enchant_session_construct (GType object_type)
{
	EnchantSession* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
#line 44 "session.vala"
	self = (EnchantSession*) g_type_create_instance (object_type);
#line 45 "session.vala"
	_tmp0_ = g_str_hash;
#line 45 "session.vala"
	_tmp1_ = g_str_equal;
#line 45 "session.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
#line 45 "session.vala"
	_g_hash_table_unref0 (self->session_include);
#line 45 "session.vala"
	self->session_include = _tmp2_;
#line 46 "session.vala"
	_tmp3_ = g_str_hash;
#line 46 "session.vala"
	_tmp4_ = g_str_equal;
#line 46 "session.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
#line 46 "session.vala"
	_g_hash_table_unref0 (self->session_exclude);
#line 46 "session.vala"
	self->session_exclude = _tmp5_;
#line 44 "session.vala"
	return self;
#line 236 "session.c"
}

static EnchantSession*
enchant_session_new (void)
{
#line 44 "session.vala"
	return enchant_session_construct (TYPE_ENCHANT_SESSION);
#line 244 "session.c"
}

EnchantSession*
enchant_session_with_implicit_pwl (EnchantProvider* provider,
                                   const gchar* lang,
                                   const gchar* pwl)
{
	gchar* user_config_dir = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	EnchantSession* _tmp16_;
	EnchantSession* result;
#line 49 "session.vala"
	g_return_val_if_fail (lang != NULL, NULL);
#line 50 "session.vala"
	_tmp0_ = enchant_get_user_config_dir ();
#line 50 "session.vala"
	user_config_dir = _tmp0_;
#line 51 "session.vala"
	_tmp2_ = user_config_dir;
#line 51 "session.vala"
	if (_tmp2_ == NULL) {
#line 51 "session.vala"
		_tmp1_ = TRUE;
#line 271 "session.c"
	} else {
#line 51 "session.vala"
		_tmp1_ = lang == NULL;
#line 275 "session.c"
	}
#line 51 "session.vala"
	if (_tmp1_) {
#line 52 "session.vala"
		result = NULL;
#line 52 "session.vala"
		_g_free0 (user_config_dir);
#line 52 "session.vala"
		return result;
#line 285 "session.c"
	}
#line 54 "session.vala"
	_tmp3_ = user_config_dir;
#line 54 "session.vala"
	g_mkdir_with_parents (_tmp3_, 0700);
#line 55 "session.vala"
	if (pwl == NULL) {
#line 293 "session.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		EnchantSession* _tmp14_;
		EnchantSession* _tmp15_;
#line 56 "session.vala"
		_tmp4_ = user_config_dir;
#line 56 "session.vala"
		_tmp5_ = g_strdup_printf ("%s.dic", lang);
#line 56 "session.vala"
		_tmp6_ = _tmp5_;
#line 56 "session.vala"
		_tmp7_ = g_build_filename (_tmp4_, _tmp6_, NULL);
#line 56 "session.vala"
		_tmp8_ = _tmp7_;
#line 56 "session.vala"
		_tmp9_ = user_config_dir;
#line 56 "session.vala"
		_tmp10_ = g_strdup_printf ("%s.exc", lang);
#line 56 "session.vala"
		_tmp11_ = _tmp10_;
#line 56 "session.vala"
		_tmp12_ = g_build_filename (_tmp9_, _tmp11_, NULL);
#line 56 "session.vala"
		_tmp13_ = _tmp12_;
#line 56 "session.vala"
		_tmp14_ = enchant_session_with_pwl (provider, _tmp8_, _tmp13_, lang, FALSE);
#line 56 "session.vala"
		_tmp15_ = _tmp14_;
#line 56 "session.vala"
		_g_free0 (_tmp13_);
#line 56 "session.vala"
		_g_free0 (_tmp11_);
#line 56 "session.vala"
		_g_free0 (_tmp8_);
#line 56 "session.vala"
		_g_free0 (_tmp6_);
#line 56 "session.vala"
		result = _tmp15_;
#line 56 "session.vala"
		_g_free0 (user_config_dir);
#line 56 "session.vala"
		return result;
#line 344 "session.c"
	}
#line 63 "session.vala"
	_tmp16_ = enchant_session_with_pwl (provider, pwl, NULL, lang, TRUE);
#line 63 "session.vala"
	result = _tmp16_;
#line 63 "session.vala"
	_g_free0 (user_config_dir);
#line 63 "session.vala"
	return result;
#line 354 "session.c"
}

static gpointer
_enchant_provider_ref0 (gpointer self)
{
#line 92 "session.vala"
	return self ? enchant_provider_ref (self) : NULL;
#line 362 "session.c"
}

EnchantSession*
enchant_session_with_pwl (EnchantProvider* provider,
                          const gchar* pwlname,
                          const gchar* exclname,
                          const gchar* lang,
                          gboolean fail_if_no_pwl)
{
	EnchantPWL* pwl = NULL;
	EnchantPWL* _tmp1_;
	EnchantPWL* exclude_pwl = NULL;
	EnchantPWL* _tmp4_;
	EnchantSession* session = NULL;
	EnchantSession* _tmp6_;
	EnchantSession* _tmp7_;
	EnchantPWL* _tmp8_;
	EnchantSession* _tmp9_;
	EnchantPWL* _tmp10_;
	EnchantSession* _tmp11_;
	EnchantProvider* _tmp12_;
	EnchantSession* _tmp13_;
	gchar* _tmp14_;
	EnchantSession* _tmp15_;
	gchar* _tmp16_;
	EnchantSession* _tmp17_;
	gchar* _tmp18_;
	EnchantSession* result;
#line 66 "session.vala"
	g_return_val_if_fail (lang != NULL, NULL);
#line 73 "session.vala"
	pwl = NULL;
#line 74 "session.vala"
	if (pwlname != NULL) {
#line 397 "session.c"
		EnchantPWL* _tmp0_;
#line 75 "session.vala"
		_tmp0_ = enchant_pwl_init_with_file (pwlname);
#line 75 "session.vala"
		_enchant_pwl_unref0 (pwl);
#line 75 "session.vala"
		pwl = _tmp0_;
#line 405 "session.c"
	}
#line 76 "session.vala"
	_tmp1_ = pwl;
#line 76 "session.vala"
	if (_tmp1_ == NULL) {
#line 77 "session.vala"
		if (fail_if_no_pwl) {
#line 78 "session.vala"
			result = NULL;
#line 78 "session.vala"
			_enchant_pwl_unref0 (pwl);
#line 78 "session.vala"
			return result;
#line 419 "session.c"
		} else {
			EnchantPWL* _tmp2_;
#line 80 "session.vala"
			_tmp2_ = enchant_pwl_init ();
#line 80 "session.vala"
			_enchant_pwl_unref0 (pwl);
#line 80 "session.vala"
			pwl = _tmp2_;
#line 428 "session.c"
		}
	}
#line 83 "session.vala"
	exclude_pwl = NULL;
#line 84 "session.vala"
	if (exclname != NULL) {
#line 435 "session.c"
		EnchantPWL* _tmp3_;
#line 85 "session.vala"
		_tmp3_ = enchant_pwl_init_with_file (exclname);
#line 85 "session.vala"
		_enchant_pwl_unref0 (exclude_pwl);
#line 85 "session.vala"
		exclude_pwl = _tmp3_;
#line 443 "session.c"
	}
#line 86 "session.vala"
	_tmp4_ = exclude_pwl;
#line 86 "session.vala"
	if (_tmp4_ == NULL) {
#line 449 "session.c"
		EnchantPWL* _tmp5_;
#line 87 "session.vala"
		_tmp5_ = enchant_pwl_init ();
#line 87 "session.vala"
		_enchant_pwl_unref0 (exclude_pwl);
#line 87 "session.vala"
		exclude_pwl = _tmp5_;
#line 457 "session.c"
	}
#line 89 "session.vala"
	_tmp6_ = enchant_session_new ();
#line 89 "session.vala"
	session = _tmp6_;
#line 90 "session.vala"
	_tmp7_ = session;
#line 90 "session.vala"
	_tmp8_ = pwl;
#line 90 "session.vala"
	pwl = NULL;
#line 90 "session.vala"
	_enchant_pwl_unref0 (_tmp7_->pwl);
#line 90 "session.vala"
	_tmp7_->pwl = _tmp8_;
#line 91 "session.vala"
	_tmp9_ = session;
#line 91 "session.vala"
	_tmp10_ = exclude_pwl;
#line 91 "session.vala"
	exclude_pwl = NULL;
#line 91 "session.vala"
	_enchant_pwl_unref0 (_tmp9_->exclude_pwl);
#line 91 "session.vala"
	_tmp9_->exclude_pwl = _tmp10_;
#line 92 "session.vala"
	_tmp11_ = session;
#line 92 "session.vala"
	_tmp12_ = _enchant_provider_ref0 (provider);
#line 92 "session.vala"
	_enchant_provider_unref0 (_tmp11_->provider);
#line 92 "session.vala"
	_tmp11_->provider = _tmp12_;
#line 93 "session.vala"
	_tmp13_ = session;
#line 93 "session.vala"
	_tmp14_ = g_strdup (lang);
#line 93 "session.vala"
	_g_free0 (_tmp13_->language_tag);
#line 93 "session.vala"
	_tmp13_->language_tag = _tmp14_;
#line 94 "session.vala"
	_tmp15_ = session;
#line 94 "session.vala"
	_tmp16_ = g_strdup (pwlname);
#line 94 "session.vala"
	_g_free0 (_tmp15_->personal_filename);
#line 94 "session.vala"
	_tmp15_->personal_filename = _tmp16_;
#line 95 "session.vala"
	_tmp17_ = session;
#line 95 "session.vala"
	_tmp18_ = g_strdup (exclname);
#line 95 "session.vala"
	_g_free0 (_tmp17_->exclude_filename);
#line 95 "session.vala"
	_tmp17_->exclude_filename = _tmp18_;
#line 97 "session.vala"
	result = session;
#line 97 "session.vala"
	_enchant_pwl_unref0 (exclude_pwl);
#line 97 "session.vala"
	_enchant_pwl_unref0 (pwl);
#line 97 "session.vala"
	return result;
#line 523 "session.c"
}

void
enchant_session_add (EnchantSession* self,
                     const gchar* word)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
#line 100 "session.vala"
	g_return_if_fail (self != NULL);
#line 100 "session.vala"
	g_return_if_fail (word != NULL);
#line 101 "session.vala"
	_tmp0_ = self->session_exclude;
#line 101 "session.vala"
	g_hash_table_remove (_tmp0_, word);
#line 102 "session.vala"
	_tmp1_ = self->session_include;
#line 102 "session.vala"
	_tmp2_ = g_strdup (word);
#line 102 "session.vala"
	g_hash_table_add (_tmp1_, _tmp2_);
#line 547 "session.c"
}

void
enchant_session_remove (EnchantSession* self,
                        const gchar* word)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
#line 105 "session.vala"
	g_return_if_fail (self != NULL);
#line 105 "session.vala"
	g_return_if_fail (word != NULL);
#line 106 "session.vala"
	_tmp0_ = self->session_include;
#line 106 "session.vala"
	g_hash_table_remove (_tmp0_, word);
#line 107 "session.vala"
	_tmp1_ = self->session_exclude;
#line 107 "session.vala"
	_tmp2_ = g_strdup (word);
#line 107 "session.vala"
	g_hash_table_add (_tmp1_, _tmp2_);
#line 571 "session.c"
}

gboolean
enchant_session_exclude (EnchantSession* self,
                         const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
#line 110 "session.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "session.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 111 "session.vala"
	_tmp1_ = self->session_include;
#line 111 "session.vala"
	if (!g_hash_table_contains (_tmp1_, word)) {
#line 589 "session.c"
		gboolean _tmp2_ = FALSE;
		GHashTable* _tmp3_;
#line 112 "session.vala"
		_tmp3_ = self->session_exclude;
#line 112 "session.vala"
		if (g_hash_table_contains (_tmp3_, word)) {
#line 112 "session.vala"
			_tmp2_ = TRUE;
#line 598 "session.c"
		} else {
			EnchantPWL* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
#line 113 "session.vala"
			_tmp4_ = self->exclude_pwl;
#line 113 "session.vala"
			_tmp5_ = strlen (word);
#line 113 "session.vala"
			_tmp6_ = _tmp5_;
#line 113 "session.vala"
			_tmp2_ = enchant_pwl_check (_tmp4_, word, (ssize_t) _tmp6_) == 0;
#line 611 "session.c"
		}
#line 112 "session.vala"
		_tmp0_ = _tmp2_;
#line 615 "session.c"
	} else {
#line 111 "session.vala"
		_tmp0_ = FALSE;
#line 619 "session.c"
	}
#line 111 "session.vala"
	result = _tmp0_;
#line 111 "session.vala"
	return result;
#line 625 "session.c"
}

gboolean
enchant_session_contains (EnchantSession* self,
                          const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
#line 116 "session.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "session.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 117 "session.vala"
	_tmp1_ = self->session_include;
#line 117 "session.vala"
	if (g_hash_table_contains (_tmp1_, word)) {
#line 117 "session.vala"
		_tmp0_ = TRUE;
#line 645 "session.c"
	} else {
		gboolean _tmp2_ = FALSE;
		EnchantPWL* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 118 "session.vala"
		_tmp3_ = self->pwl;
#line 118 "session.vala"
		_tmp4_ = strlen (word);
#line 118 "session.vala"
		_tmp5_ = _tmp4_;
#line 118 "session.vala"
		if (enchant_pwl_check (_tmp3_, word, (ssize_t) _tmp5_) == 0) {
#line 659 "session.c"
			EnchantPWL* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 119 "session.vala"
			_tmp6_ = self->exclude_pwl;
#line 119 "session.vala"
			_tmp7_ = strlen (word);
#line 119 "session.vala"
			_tmp8_ = _tmp7_;
#line 119 "session.vala"
			_tmp2_ = enchant_pwl_check (_tmp6_, word, (ssize_t) _tmp8_) != 0;
#line 671 "session.c"
		} else {
#line 118 "session.vala"
			_tmp2_ = FALSE;
#line 675 "session.c"
		}
#line 118 "session.vala"
		_tmp0_ = _tmp2_;
#line 679 "session.c"
	}
#line 117 "session.vala"
	result = _tmp0_;
#line 117 "session.vala"
	return result;
#line 685 "session.c"
}

void
enchant_session_clear_error (EnchantSession* self)
{
#line 122 "session.vala"
	g_return_if_fail (self != NULL);
#line 123 "session.vala"
	_g_free0 (self->error);
#line 123 "session.vala"
	self->error = NULL;
#line 697 "session.c"
}

static void
value_enchant_session_init (GValue* value)
{
#line 30 "session.vala"
	value->data[0].v_pointer = NULL;
#line 705 "session.c"
}

static void
value_enchant_session_free_value (GValue* value)
{
#line 30 "session.vala"
	if (value->data[0].v_pointer) {
#line 30 "session.vala"
		enchant_session_unref (value->data[0].v_pointer);
#line 715 "session.c"
	}
}

static void
value_enchant_session_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 30 "session.vala"
	if (src_value->data[0].v_pointer) {
#line 30 "session.vala"
		dest_value->data[0].v_pointer = enchant_session_ref (src_value->data[0].v_pointer);
#line 727 "session.c"
	} else {
#line 30 "session.vala"
		dest_value->data[0].v_pointer = NULL;
#line 731 "session.c"
	}
}

static gpointer
value_enchant_session_peek_pointer (const GValue* value)
{
#line 30 "session.vala"
	return value->data[0].v_pointer;
#line 740 "session.c"
}

static gchar*
value_enchant_session_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 30 "session.vala"
	if (collect_values[0].v_pointer) {
#line 751 "session.c"
		EnchantSession * object;
		object = collect_values[0].v_pointer;
#line 30 "session.vala"
		if (object->parent_instance.g_class == NULL) {
#line 30 "session.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 758 "session.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 30 "session.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 762 "session.c"
		}
#line 30 "session.vala"
		value->data[0].v_pointer = enchant_session_ref (object);
#line 766 "session.c"
	} else {
#line 30 "session.vala"
		value->data[0].v_pointer = NULL;
#line 770 "session.c"
	}
#line 30 "session.vala"
	return NULL;
#line 774 "session.c"
}

static gchar*
value_enchant_session_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	EnchantSession ** object_p;
	object_p = collect_values[0].v_pointer;
#line 30 "session.vala"
	if (!object_p) {
#line 30 "session.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 789 "session.c"
	}
#line 30 "session.vala"
	if (!value->data[0].v_pointer) {
#line 30 "session.vala"
		*object_p = NULL;
#line 795 "session.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 30 "session.vala"
		*object_p = value->data[0].v_pointer;
#line 799 "session.c"
	} else {
#line 30 "session.vala"
		*object_p = enchant_session_ref (value->data[0].v_pointer);
#line 803 "session.c"
	}
#line 30 "session.vala"
	return NULL;
#line 807 "session.c"
}

GParamSpec*
param_spec_enchant_session (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecEnchantSession* spec;
#line 30 "session.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_SESSION), NULL);
#line 30 "session.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 30 "session.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 30 "session.vala"
	return G_PARAM_SPEC (spec);
#line 826 "session.c"
}

gpointer
value_get_enchant_session (const GValue* value)
{
#line 30 "session.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_SESSION), NULL);
#line 30 "session.vala"
	return value->data[0].v_pointer;
#line 836 "session.c"
}

void
value_set_enchant_session (GValue* value,
                           gpointer v_object)
{
	EnchantSession * old;
#line 30 "session.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_SESSION));
#line 30 "session.vala"
	old = value->data[0].v_pointer;
#line 30 "session.vala"
	if (v_object) {
#line 30 "session.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_SESSION));
#line 30 "session.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "session.vala"
		value->data[0].v_pointer = v_object;
#line 30 "session.vala"
		enchant_session_ref (value->data[0].v_pointer);
#line 858 "session.c"
	} else {
#line 30 "session.vala"
		value->data[0].v_pointer = NULL;
#line 862 "session.c"
	}
#line 30 "session.vala"
	if (old) {
#line 30 "session.vala"
		enchant_session_unref (old);
#line 868 "session.c"
	}
}

void
value_take_enchant_session (GValue* value,
                            gpointer v_object)
{
	EnchantSession * old;
#line 30 "session.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_SESSION));
#line 30 "session.vala"
	old = value->data[0].v_pointer;
#line 30 "session.vala"
	if (v_object) {
#line 30 "session.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_SESSION));
#line 30 "session.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "session.vala"
		value->data[0].v_pointer = v_object;
#line 889 "session.c"
	} else {
#line 30 "session.vala"
		value->data[0].v_pointer = NULL;
#line 893 "session.c"
	}
#line 30 "session.vala"
	if (old) {
#line 30 "session.vala"
		enchant_session_unref (old);
#line 899 "session.c"
	}
}

static void
enchant_session_class_init (EnchantSessionClass * klass,
                            gpointer klass_data)
{
#line 30 "session.vala"
	enchant_session_parent_class = g_type_class_peek_parent (klass);
#line 30 "session.vala"
	((EnchantSessionClass *) klass)->finalize = enchant_session_finalize;
#line 911 "session.c"
}

static void
enchant_session_instance_init (EnchantSession * self,
                               gpointer klass)
{
#line 30 "session.vala"
	self->ref_count = 1;
#line 920 "session.c"
}

static void
enchant_session_finalize (EnchantSession * obj)
{
	EnchantSession * self;
#line 30 "session.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_SESSION, EnchantSession);
#line 30 "session.vala"
	g_signal_handlers_destroy (self);
#line 31 "session.vala"
	_g_hash_table_unref0 (self->session_include);
#line 32 "session.vala"
	_g_hash_table_unref0 (self->session_exclude);
#line 33 "session.vala"
	_enchant_pwl_unref0 (self->pwl);
#line 34 "session.vala"
	_enchant_pwl_unref0 (self->exclude_pwl);
#line 36 "session.vala"
	_g_free0 (self->personal_filename);
#line 37 "session.vala"
	_g_free0 (self->exclude_filename);
#line 38 "session.vala"
	_g_free0 (self->language_tag);
#line 40 "session.vala"
	_g_free0 (self->error);
#line 42 "session.vala"
	_enchant_provider_unref0 (self->provider);
#line 949 "session.c"
}

static GType
enchant_session_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_session_init, value_enchant_session_free_value, value_enchant_session_copy_value, value_enchant_session_peek_pointer, "p", value_enchant_session_collect_value, "p", value_enchant_session_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantSession), 0, (GInstanceInitFunc) enchant_session_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_session_type_id;
	enchant_session_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantSession", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_session_type_id;
}

GType
enchant_session_get_type (void)
{
	static volatile gsize enchant_session_type_id__once = 0;
	if (g_once_init_enter (&enchant_session_type_id__once)) {
		GType enchant_session_type_id;
		enchant_session_type_id = enchant_session_get_type_once ();
		g_once_init_leave (&enchant_session_type_id__once, enchant_session_type_id);
	}
	return enchant_session_type_id__once;
}

gpointer
enchant_session_ref (gpointer instance)
{
	EnchantSession * self;
	self = instance;
#line 30 "session.vala"
	g_atomic_int_inc (&self->ref_count);
#line 30 "session.vala"
	return instance;
#line 984 "session.c"
}

void
enchant_session_unref (gpointer instance)
{
	EnchantSession * self;
	self = instance;
#line 30 "session.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 30 "session.vala"
		ENCHANT_SESSION_GET_CLASS (self)->finalize (self);
#line 30 "session.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 998 "session.c"
	}
}

