# setup.py - Distutils interface for building Bhtree Python extension and
# creating a distribution.

from distutils.core import setup, Extension
from distutils.command.build import build
from distutils.command.sdist import sdist
import sys
from os import path

pack_name = "bhtree"
ext_name = "_bhtreelib"
#source = [path.join(pack_name, "bhtreelib.i"),  path.join(pack_name, "bhtree.c")]
source = [path.join(pack_name, "bhtreelib.i"),  path.join("src", "bhtree.c")]
#include_dirs = [path.join(".",pack_name)]
import numpy
numpy_include =  numpy.get_include()
include_dirs = [path.join(".", "src"), numpy_include]

#if sys.platform == "darwin":
    #include_dirs.append("/usr/include/sys") # for malloc.h
    
# Change the order of commands that are called by "build"
# so that "build_py" command is called after "build_ext". In this case
# "build_py" will install (copy to the build directory) python
# modules generated by "build_ext'.

class modified_build(build):

    sub_commands = [('build_clib',    build.has_c_libraries),
                    ('build_ext',     build.has_ext_modules),
                    ('build_py',      build.has_pure_modules),
                    ('build_scripts', build.has_scripts),
                    ]

# Overwrite the prune_file_list method of sdist to not
# remove automatically the RCS/CVS directory from the distribution.

class modified_sdist(sdist):
    def prune_file_list(self):

        build = self.get_finalized_command('build')
        base_dir = self.distribution.get_fullname()
        self.filelist.exclude_pattern(None, prefix=build.build_base)
        self.filelist.exclude_pattern(None, prefix=base_dir)

try:   
    from version import VERSION
except:
    VERSION = "1.0"
# setup()      
dist = setup(name="bhtree",
             version=VERSION,
             description = "Bhtree library extension module",
             author = "Molecular Graphics Laboratory",
             author_email = "mgltools@scripps.edu",
             url = "http://www.scripps.edu/~sanner/python/packager.html",
             py_modules = ['bhtree.bhtreelib', 'bhtree.__init__'],
             packages = ["bhtree.Tests"],
             cmdclass = {"build" : modified_build,
                         'sdist' : modified_sdist},
             ext_package = pack_name,
             ext_modules = [Extension (ext_name, source,
                                  include_dirs = include_dirs,
                                  #define_macros = [('UNIX', None),],
                                       ) ] ,)

# cp built .so from ./build/lib.platform to ./pack_name/ - for testing.

##  from distutils.util import get_platform
##  from distutils.file_util import copy_file

##  plat_specifier = ".%s-%s" % (get_platform(), sys.version[0:3])
##  orig_ext = path.join(".", "build", "lib"+plat_specifier , pack_name, ext_name+".so")
##  cp_ext = path.join(pack_name, ext_name+".so")
##  if path.isfile(orig_ext):
##      copy_file(orig_ext, cp_ext, update=1)

