/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Stack;
import org.fest.swing.query.ComponentShowingQuery;

class MouseInfo {
    static final int BUTTON_MASK = 28;
    private Point location = new Point(0, 0);
    private Point locationOnScreen = new Point(0, 0);
    private final Stack<WeakReference<Component>> componentStack = new Stack();
    private final Stack<Point> locationStack = new Stack();
    private final Stack<Point> screenLocationStack = new Stack();
    private int buttons;
    private int modifiers;
    private int clickCount;

    MouseInfo() {
    }

    void clear() {
        this.clickCount = 0;
        this.modifiers = 0;
        this.buttons = 0;
        this.componentStack.clear();
        this.locationStack.clear();
        this.screenLocationStack.clear();
    }

    void update(MouseEvent event, Point eventScreenLocation) {
        this.clickCount(event.getClickCount());
        this.updateOnMousePressed(event);
        this.updateOnMouseReleased(event);
        this.updateOnMouseEntered(event, eventScreenLocation);
        this.updateOnMouseExited(event);
        if (eventScreenLocation == null) {
            return;
        }
        Point where = event.getPoint();
        this.location = this.componentStack.empty() ? null : new Point(where);
        this.locationOnScreen.setLocation(eventScreenLocation);
        this.locationOnScreen.translate(where.x, where.y);
    }

    private void updateOnMousePressed(MouseEvent event) {
        if (event.getID() != 501) {
            return;
        }
        int buttonUsed = this.buttonUsed(event);
        this.buttons |= buttonUsed;
        this.modifiers |= buttonUsed;
    }

    private void updateOnMouseReleased(MouseEvent event) {
        if (event.getID() != 502) {
            return;
        }
        int buttonUsed = this.buttonUsed(event);
        this.buttons &= ~buttonUsed;
        this.modifiers &= ~buttonUsed;
    }

    private int buttonUsed(MouseEvent event) {
        return event.getModifiers() & 0x1C;
    }

    private void updateOnMouseEntered(MouseEvent event, Point eventScreenLocation) {
        if (event.getID() != 504) {
            return;
        }
        this.componentStack.push(new WeakReference<Component>(event.getComponent()));
        Point eventPoint = event.getPoint();
        this.locationStack.push(eventPoint);
        this.screenLocationStack.push(eventScreenLocation != null ? eventScreenLocation : eventPoint);
    }

    private void updateOnMouseExited(MouseEvent event) {
        if (event.getID() != 505 || this.componentStack.empty()) {
            return;
        }
        this.componentStack.pop();
        this.locationStack.pop();
        this.screenLocationStack.pop();
    }

    public Component component() {
        if (this.componentStack.empty()) {
            return null;
        }
        Component c = (Component)this.componentStack.peek().get();
        if (c != null && ComponentShowingQuery.isShowing(c)) {
            return c;
        }
        this.componentStack.pop();
        this.locationStack.pop();
        this.screenLocationStack.pop();
        c = this.component();
        if (c != null) {
            this.location = this.locationStack.peek();
            this.locationOnScreen = this.screenLocationStack.peek();
        }
        return c;
    }

    int buttons() {
        return this.buttons;
    }

    void buttons(int newButtons) {
        this.buttons = newButtons;
    }

    int modifiers() {
        return this.modifiers;
    }

    void modifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    int clickCount() {
        return this.clickCount;
    }

    void clickCount(int newClickCount) {
        this.clickCount = newClickCount;
    }

    Point location() {
        return this.pointFrom(this.location);
    }

    Point locationOnScreen() {
        return this.pointFrom(this.locationOnScreen);
    }

    private Point pointFrom(Point source) {
        return source != null ? new Point(source) : null;
    }
}

