/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JProgressBar;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JProgressBarValueQuery;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.util.Strings;

final class JProgressBarWaitUntilValueIsEqualToExpectedTask {
    @RunsInEDT
    static void waitUntilValueIsEqualToExpected(final JProgressBar progressBar, final int expected, Timeout timeout) {
        Pause.pause(new Condition(JProgressBarWaitUntilValueIsEqualToExpectedTask.untilValueIsEqualTo(progressBar, expected)){

            public boolean test() {
                return JProgressBarValueQuery.valueOf(progressBar) == expected;
            }
        }, timeout);
    }

    private static Description untilValueIsEqualTo(final JProgressBar progressBar, final int expected) {
        return new GuiLazyLoadingDescription(){

            protected String loadDescription() {
                return Strings.concat((Object[])new Object[]{"value of ", Formatting.format(progressBar), " to be equal to ", expected});
            }
        };
    }

    private JProgressBarWaitUntilValueIsEqualToExpectedTask() {
    }
}

