// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SADDL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SADDL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_saddl2_4S[] = {
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0000fffb, 0x0000fffd, 0x00007fff, 0x00000001,
  0x0000fffc, 0x00007ffe, 0x00008000, 0x00000002,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00000010,
  0x00007ffe, 0x00008000, 0x0000800f, 0x0000007d,
  0x00007fff, 0x0000800e, 0x0000807c, 0x0000007e,
  0x0000800d, 0x0000807b, 0x0000807d, 0x0000007f,
  0x0000807a, 0x0000807c, 0x0000807e, 0x00003333,
  0x0000807b, 0x0000807d, 0x0000b332, 0x00005555,
  0x0000807c, 0x0000b331, 0x0000d554, 0x00007ffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0x00007ffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0x00007fff,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff8000,
  0x0000fffb, 0x0000fffd, 0xffffffff, 0xffff8001,
  0x0000fffc, 0xfffffffe, 0x00000000, 0xffffaaaa,
  0xfffffffd, 0xffffffff, 0x00002aa9, 0xffffcccc,
  0xfffffffe, 0x00002aa8, 0x00004ccb, 0xffffff80,
  0x00002aa7, 0x00004cca, 0x00007f7f, 0xffffff81,
  0x00004cc9, 0x00007f7e, 0x00007f80, 0xffffff82,
  0x00007f7d, 0x00007f7f, 0x00007f81, 0xffffff83,
  0x00007f7e, 0x00007f80, 0x00007f82, 0xfffffff0,
  0x00007f7f, 0x00007f81, 0x00007fef, 0xfffffffd,
  0x00007f80, 0x00007fee, 0x00007ffc, 0xfffffffe,
  0x00007fed, 0x00007ffb, 0x00007ffd, 0xffffffff,
  0x00007ffb, 0x00007ffd, 0xffffffff, 0x00000001,
  0x00007ffc, 0x00007ffe, 0x00000000, 0x00000002,
  0x00007ffd, 0x00007fff, 0x00000001, 0x00000003,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000011,
  0x00007fff, 0x00008001, 0x00000010, 0x0000007e,
  0x00008000, 0x0000800f, 0x0000007d, 0x0000007f,
  0x0000800e, 0x0000807c, 0x0000007e, 0x00000080,
  0x0000807b, 0x0000807d, 0x0000007f, 0x00003334,
  0x0000807c, 0x0000807e, 0x00003333, 0x00005556,
  0x0000807d, 0x0000b332, 0x00005555, 0x00007ffe,
  0x0000b331, 0x0000d554, 0x00007ffd, 0x00007fff,
  0x0000d553, 0x0000fffc, 0x00007ffe, 0x00008000,
  0x0000fffb, 0x0000fffd, 0x00007fff, 0xffff8001,
  0x0000fffc, 0x0000fffe, 0xffff8000, 0xffff8002,
  0x0000fffd, 0xffffffff, 0xffff8001, 0xffffaaab,
  0xfffffffe, 0x00000000, 0xffffaaaa, 0xffffcccd,
  0xffffffff, 0x00002aa9, 0xffffcccc, 0xffffff81,
  0x00002aa8, 0x00004ccb, 0xffffff80, 0xffffff82,
  0x00004cca, 0x00007f7f, 0xffffff81, 0xffffff83,
  0x00007f7e, 0x00007f80, 0xffffff82, 0xffffff84,
  0x00007f7f, 0x00007f81, 0xffffff83, 0xfffffff1,
  0x00007f80, 0x00007f82, 0xfffffff0, 0xfffffffe,
  0x00007f81, 0x00007fef, 0xfffffffd, 0xffffffff,
  0x00007fee, 0x00007ffc, 0xfffffffe, 0x00000000,
  0x00007ffc, 0xfffffffe, 0x00000000, 0x00000002,
  0x00007ffd, 0xffffffff, 0x00000001, 0x00000003,
  0x00007ffe, 0x00000000, 0x00000002, 0x00000004,
  0x00007fff, 0x00000001, 0x00000003, 0x00000012,
  0x00008000, 0x00000002, 0x00000011, 0x0000007f,
  0x00008001, 0x00000010, 0x0000007e, 0x00000080,
  0x0000800f, 0x0000007d, 0x0000007f, 0x00000081,
  0x0000807c, 0x0000007e, 0x00000080, 0x00003335,
  0x0000807d, 0x0000007f, 0x00003334, 0x00005557,
  0x0000807e, 0x00003333, 0x00005556, 0x00007fff,
  0x0000b332, 0x00005555, 0x00007ffe, 0x00008000,
  0x0000d554, 0x00007ffd, 0x00007fff, 0x00008001,
  0x0000fffc, 0x00007ffe, 0x00008000, 0xffff8002,
  0x0000fffd, 0x00007fff, 0xffff8001, 0xffff8003,
  0x0000fffe, 0xffff8000, 0xffff8002, 0xffffaaac,
  0xffffffff, 0xffff8001, 0xffffaaab, 0xffffccce,
  0x00000000, 0xffffaaaa, 0xffffcccd, 0xffffff82,
  0x00002aa9, 0xffffcccc, 0xffffff81, 0xffffff83,
  0x00004ccb, 0xffffff80, 0xffffff82, 0xffffff84,
  0x00007f7f, 0xffffff81, 0xffffff83, 0xffffff85,
  0x00007f80, 0xffffff82, 0xffffff84, 0xfffffff2,
  0x00007f81, 0xffffff83, 0xfffffff1, 0xffffffff,
  0x00007f82, 0xfffffff0, 0xfffffffe, 0x00000000,
  0x00007fef, 0xfffffffd, 0xffffffff, 0x00000001,
  0xfffffffd, 0xffffffff, 0x00000001, 0x00000010,
  0xfffffffe, 0x00000000, 0x00000002, 0x00000011,
  0xffffffff, 0x00000001, 0x00000003, 0x00000012,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000001, 0x00000003, 0x00000012, 0x0000008d,
  0x00000002, 0x00000011, 0x0000007f, 0x0000008e,
  0x00000010, 0x0000007e, 0x00000080, 0x0000008f,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003343,
  0x0000007e, 0x00000080, 0x00003335, 0x00005565,
  0x0000007f, 0x00003334, 0x00005557, 0x0000800d,
  0x00003333, 0x00005556, 0x00007fff, 0x0000800e,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000800f,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8010,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8011,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaba,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccdc,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffff90,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffff91,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffff92,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffff93,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000000,
  0xffffff82, 0xffffff84, 0xfffffff2, 0x0000000d,
  0xffffff83, 0xfffffff1, 0xffffffff, 0x0000000e,
  0xfffffff0, 0xfffffffe, 0x00000000, 0x0000000f,
  0xfffffffe, 0x00000000, 0x0000000f, 0x0000007d,
  0xffffffff, 0x00000001, 0x00000010, 0x0000007e,
  0x00000000, 0x00000002, 0x00000011, 0x0000007f,
  0x00000001, 0x00000003, 0x00000012, 0x0000008d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000003, 0x00000012, 0x0000008d, 0x000000fb,
  0x00000011, 0x0000007f, 0x0000008e, 0x000000fc,
  0x0000007e, 0x00000080, 0x0000008f, 0x000033b0,
  0x0000007f, 0x00000081, 0x00003343, 0x000055d2,
  0x00000080, 0x00003335, 0x00005565, 0x0000807a,
  0x00003334, 0x00005557, 0x0000800d, 0x0000807b,
  0x00005556, 0x00007fff, 0x0000800e, 0x0000807c,
  0x00007ffe, 0x00008000, 0x0000800f, 0xffff807d,
  0x00007fff, 0x00008001, 0xffff8010, 0xffff807e,
  0x00008000, 0xffff8002, 0xffff8011, 0xffffab27,
  0xffff8001, 0xffff8003, 0xffffaaba, 0xffffcd49,
  0xffff8002, 0xffffaaac, 0xffffccdc, 0xfffffffd,
  0xffffaaab, 0xffffccce, 0xffffff90, 0xfffffffe,
  0xffffcccd, 0xffffff82, 0xffffff91, 0xffffffff,
  0xffffff81, 0xffffff83, 0xffffff92, 0x00000000,
  0xffffff82, 0xffffff84, 0xffffff93, 0x0000006d,
  0xffffff83, 0xffffff85, 0x00000000, 0x0000007a,
  0xffffff84, 0xfffffff2, 0x0000000d, 0x0000007b,
  0xfffffff1, 0xffffffff, 0x0000000e, 0x0000007c,
  0xffffffff, 0x0000000e, 0x0000007c, 0x0000007e,
  0x00000000, 0x0000000f, 0x0000007d, 0x0000007f,
  0x00000001, 0x00000010, 0x0000007e, 0x00000080,
  0x00000002, 0x00000011, 0x0000007f, 0x0000008e,
  0x00000003, 0x00000012, 0x0000008d, 0x000000fb,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000012, 0x0000008d, 0x000000fb, 0x000000fd,
  0x0000007f, 0x0000008e, 0x000000fc, 0x000033b1,
  0x00000080, 0x0000008f, 0x000033b0, 0x000055d3,
  0x00000081, 0x00003343, 0x000055d2, 0x0000807b,
  0x00003335, 0x00005565, 0x0000807a, 0x0000807c,
  0x00005557, 0x0000800d, 0x0000807b, 0x0000807d,
  0x00007fff, 0x0000800e, 0x0000807c, 0xffff807e,
  0x00008000, 0x0000800f, 0xffff807d, 0xffff807f,
  0x00008001, 0xffff8010, 0xffff807e, 0xffffab28,
  0xffff8002, 0xffff8011, 0xffffab27, 0xffffcd4a,
  0xffff8003, 0xffffaaba, 0xffffcd49, 0xfffffffe,
  0xffffaaac, 0xffffccdc, 0xfffffffd, 0xffffffff,
  0xffffccce, 0xffffff90, 0xfffffffe, 0x00000000,
  0xffffff82, 0xffffff91, 0xffffffff, 0x00000001,
  0xffffff83, 0xffffff92, 0x00000000, 0x0000006e,
  0xffffff84, 0xffffff93, 0x0000006d, 0x0000007b,
  0xffffff85, 0x00000000, 0x0000007a, 0x0000007c,
  0xfffffff2, 0x0000000d, 0x0000007b, 0x0000007d,
  0x0000000d, 0x0000007b, 0x0000007d, 0x0000007f,
  0x0000000e, 0x0000007c, 0x0000007e, 0x00000080,
  0x0000000f, 0x0000007d, 0x0000007f, 0x00000081,
  0x00000010, 0x0000007e, 0x00000080, 0x0000008f,
  0x00000011, 0x0000007f, 0x0000008e, 0x000000fc,
  0x00000012, 0x0000008d, 0x000000fb, 0x000000fd,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x0000008d, 0x000000fb, 0x000000fd, 0x000033b2,
  0x0000008e, 0x000000fc, 0x000033b1, 0x000055d4,
  0x0000008f, 0x000033b0, 0x000055d3, 0x0000807c,
  0x00003343, 0x000055d2, 0x0000807b, 0x0000807d,
  0x00005565, 0x0000807a, 0x0000807c, 0x0000807e,
  0x0000800d, 0x0000807b, 0x0000807d, 0xffff807f,
  0x0000800e, 0x0000807c, 0xffff807e, 0xffff8080,
  0x0000800f, 0xffff807d, 0xffff807f, 0xffffab29,
  0xffff8010, 0xffff807e, 0xffffab28, 0xffffcd4b,
  0xffff8011, 0xffffab27, 0xffffcd4a, 0xffffffff,
  0xffffaaba, 0xffffcd49, 0xfffffffe, 0x00000000,
  0xffffccdc, 0xfffffffd, 0xffffffff, 0x00000001,
  0xffffff90, 0xfffffffe, 0x00000000, 0x00000002,
  0xffffff91, 0xffffffff, 0x00000001, 0x0000006f,
  0xffffff92, 0x00000000, 0x0000006e, 0x0000007c,
  0xffffff93, 0x0000006d, 0x0000007b, 0x0000007d,
  0x00000000, 0x0000007a, 0x0000007c, 0x0000007e,
  0x0000007a, 0x0000007c, 0x0000007e, 0x00003333,
  0x0000007b, 0x0000007d, 0x0000007f, 0x00003334,
  0x0000007c, 0x0000007e, 0x00000080, 0x00003335,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003343,
  0x0000007e, 0x00000080, 0x0000008f, 0x000033b0,
  0x0000007f, 0x0000008e, 0x000000fc, 0x000033b1,
  0x0000008d, 0x000000fb, 0x000000fd, 0x000033b2,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000000fb, 0x000000fd, 0x000033b2, 0x00008888,
  0x000000fc, 0x000033b1, 0x000055d4, 0x0000b330,
  0x000033b0, 0x000055d3, 0x0000807c, 0x0000b331,
  0x000055d2, 0x0000807b, 0x0000807d, 0x0000b332,
  0x0000807a, 0x0000807c, 0x0000807e, 0xffffb333,
  0x0000807b, 0x0000807d, 0xffff807f, 0xffffb334,
  0x0000807c, 0xffff807e, 0xffff8080, 0xffffdddd,
  0xffff807d, 0xffff807f, 0xffffab29, 0xffffffff,
  0xffff807e, 0xffffab28, 0xffffcd4b, 0x000032b3,
  0xffffab27, 0xffffcd4a, 0xffffffff, 0x000032b4,
  0xffffcd49, 0xfffffffe, 0x00000000, 0x000032b5,
  0xfffffffd, 0xffffffff, 0x00000001, 0x000032b6,
  0xfffffffe, 0x00000000, 0x00000002, 0x00003323,
  0xffffffff, 0x00000001, 0x0000006f, 0x00003330,
  0x00000000, 0x0000006e, 0x0000007c, 0x00003331,
  0x0000006d, 0x0000007b, 0x0000007d, 0x00003332,
  0x0000007b, 0x0000007d, 0x00003332, 0x00005555,
  0x0000007c, 0x0000007e, 0x00003333, 0x00005556,
  0x0000007d, 0x0000007f, 0x00003334, 0x00005557,
  0x0000007e, 0x00000080, 0x00003335, 0x00005565,
  0x0000007f, 0x00000081, 0x00003343, 0x000055d2,
  0x00000080, 0x0000008f, 0x000033b0, 0x000055d3,
  0x0000008e, 0x000000fc, 0x000033b1, 0x000055d4,
  0x000000fb, 0x000000fd, 0x000033b2, 0x00008888,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x0000807b, 0x0000807d, 0x0000b332, 0xffffd555,
  0x0000807c, 0x0000807e, 0xffffb333, 0xffffd556,
  0x0000807d, 0xffff807f, 0xffffb334, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffffdddd, 0x00002221,
  0xffff807f, 0xffffab29, 0xffffffff, 0x000054d5,
  0xffffab28, 0xffffcd4b, 0x000032b3, 0x000054d6,
  0xffffcd4a, 0xffffffff, 0x000032b4, 0x000054d7,
  0xfffffffe, 0x00000000, 0x000032b5, 0x000054d8,
  0xffffffff, 0x00000001, 0x000032b6, 0x00005545,
  0x00000000, 0x00000002, 0x00003323, 0x00005552,
  0x00000001, 0x0000006f, 0x00003330, 0x00005553,
  0x0000006e, 0x0000007c, 0x00003331, 0x00005554,
  0x0000007c, 0x00003331, 0x00005554, 0x00007ffd,
  0x0000007d, 0x00003332, 0x00005555, 0x00007ffe,
  0x0000007e, 0x00003333, 0x00005556, 0x00007fff,
  0x0000007f, 0x00003334, 0x00005557, 0x0000800d,
  0x00000080, 0x00003335, 0x00005565, 0x0000807a,
  0x00000081, 0x00003343, 0x000055d2, 0x0000807b,
  0x0000008f, 0x000033b0, 0x000055d3, 0x0000807c,
  0x000000fc, 0x000033b1, 0x000055d4, 0x0000b330,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000033b2, 0x00008888, 0x0000d552, 0x0000fffb,
  0x000055d4, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x0000807c, 0x0000b331, 0x0000d554, 0xfffffffd,
  0x0000807d, 0x0000b332, 0xffffd555, 0xfffffffe,
  0x0000807e, 0xffffb333, 0xffffd556, 0x00002aa7,
  0xffff807f, 0xffffb334, 0xffffffff, 0x00004cc9,
  0xffff8080, 0xffffdddd, 0x00002221, 0x00007f7d,
  0xffffab29, 0xffffffff, 0x000054d5, 0x00007f7e,
  0xffffcd4b, 0x000032b3, 0x000054d6, 0x00007f7f,
  0xffffffff, 0x000032b4, 0x000054d7, 0x00007f80,
  0x00000000, 0x000032b5, 0x000054d8, 0x00007fed,
  0x00000001, 0x000032b6, 0x00005545, 0x00007ffa,
  0x00000002, 0x00003323, 0x00005552, 0x00007ffb,
  0x0000006f, 0x00003330, 0x00005553, 0x00007ffc,
  0x00003330, 0x00005553, 0x00007ffc, 0x00007ffe,
  0x00003331, 0x00005554, 0x00007ffd, 0x00007fff,
  0x00003332, 0x00005555, 0x00007ffe, 0x00008000,
  0x00003333, 0x00005556, 0x00007fff, 0x0000800e,
  0x00003334, 0x00005557, 0x0000800d, 0x0000807b,
  0x00003335, 0x00005565, 0x0000807a, 0x0000807c,
  0x00003343, 0x000055d2, 0x0000807b, 0x0000807d,
  0x000033b0, 0x000055d3, 0x0000807c, 0x0000b331,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000033b2, 0x00008888, 0x0000d552, 0x0000fffb,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00008888, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0xfffffffe,
  0x0000b331, 0x0000d554, 0xfffffffd, 0xffffffff,
  0x0000b332, 0xffffd555, 0xfffffffe, 0x00002aa8,
  0xffffb333, 0xffffd556, 0x00002aa7, 0x00004cca,
  0xffffb334, 0xffffffff, 0x00004cc9, 0x00007f7e,
  0xffffdddd, 0x00002221, 0x00007f7d, 0x00007f7f,
  0xffffffff, 0x000054d5, 0x00007f7e, 0x00007f80,
  0x000032b3, 0x000054d6, 0x00007f7f, 0x00007f81,
  0x000032b4, 0x000054d7, 0x00007f80, 0x00007fee,
  0x000032b5, 0x000054d8, 0x00007fed, 0x00007ffb,
  0x000032b6, 0x00005545, 0x00007ffa, 0x00007ffc,
  0x00003323, 0x00005552, 0x00007ffb, 0x00007ffd,
  0x00005552, 0x00007ffb, 0x00007ffd, 0x00007fff,
  0x00005553, 0x00007ffc, 0x00007ffe, 0x00008000,
  0x00005554, 0x00007ffd, 0x00007fff, 0x00008001,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000800f,
  0x00005556, 0x00007fff, 0x0000800e, 0x0000807c,
  0x00005557, 0x0000800d, 0x0000807b, 0x0000807d,
  0x00005565, 0x0000807a, 0x0000807c, 0x0000807e,
  0x000055d2, 0x0000807b, 0x0000807d, 0x0000b332,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x000055d4, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x00008888, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0xffffffff,
  0x0000d553, 0x0000fffc, 0xfffffffe, 0x00000000,
  0x0000d554, 0xfffffffd, 0xffffffff, 0x00002aa9,
  0xffffd555, 0xfffffffe, 0x00002aa8, 0x00004ccb,
  0xffffd556, 0x00002aa7, 0x00004cca, 0x00007f7f,
  0xffffffff, 0x00004cc9, 0x00007f7e, 0x00007f80,
  0x00002221, 0x00007f7d, 0x00007f7f, 0x00007f81,
  0x000054d5, 0x00007f7e, 0x00007f80, 0x00007f82,
  0x000054d6, 0x00007f7f, 0x00007f81, 0x00007fef,
  0x000054d7, 0x00007f80, 0x00007fee, 0x00007ffc,
  0x000054d8, 0x00007fed, 0x00007ffb, 0x00007ffd,
  0x00005545, 0x00007ffa, 0x00007ffc, 0x00007ffe,
  0x00007ffa, 0x00007ffc, 0x00007ffe, 0xffff8000,
  0x00007ffb, 0x00007ffd, 0x00007fff, 0xffff8001,
  0x00007ffc, 0x00007ffe, 0x00008000, 0xffff8002,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8010,
  0x00007ffe, 0x00008000, 0x0000800f, 0xffff807d,
  0x00007fff, 0x0000800e, 0x0000807c, 0xffff807e,
  0x0000800d, 0x0000807b, 0x0000807d, 0xffff807f,
  0x0000807a, 0x0000807c, 0x0000807e, 0xffffb333,
  0x0000807b, 0x0000807d, 0x0000b332, 0xffffd555,
  0x0000807c, 0x0000b331, 0x0000d554, 0xfffffffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0xfffffffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0xffffffff,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0000fffb, 0x0000fffd, 0xffffffff, 0xffff0001,
  0x0000fffc, 0xfffffffe, 0x00000000, 0xffff2aaa,
  0xfffffffd, 0xffffffff, 0x00002aa9, 0xffff4ccc,
  0xfffffffe, 0x00002aa8, 0x00004ccb, 0xffff7f80,
  0x00002aa7, 0x00004cca, 0x00007f7f, 0xffff7f81,
  0x00004cc9, 0x00007f7e, 0x00007f80, 0xffff7f82,
  0x00007f7d, 0x00007f7f, 0x00007f81, 0xffff7f83,
  0x00007f7e, 0x00007f80, 0x00007f82, 0xffff7ff0,
  0x00007f7f, 0x00007f81, 0x00007fef, 0xffff7ffd,
  0x00007f80, 0x00007fee, 0x00007ffc, 0xffff7ffe,
  0x00007fed, 0x00007ffb, 0x00007ffd, 0xffff7fff,
  0x00007ffb, 0x00007ffd, 0xffff7fff, 0xffff8001,
  0x00007ffc, 0x00007ffe, 0xffff8000, 0xffff8002,
  0x00007ffd, 0x00007fff, 0xffff8001, 0xffff8003,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8011,
  0x00007fff, 0x00008001, 0xffff8010, 0xffff807e,
  0x00008000, 0x0000800f, 0xffff807d, 0xffff807f,
  0x0000800e, 0x0000807c, 0xffff807e, 0xffff8080,
  0x0000807b, 0x0000807d, 0xffff807f, 0xffffb334,
  0x0000807c, 0x0000807e, 0xffffb333, 0xffffd556,
  0x0000807d, 0x0000b332, 0xffffd555, 0xfffffffe,
  0x0000b331, 0x0000d554, 0xfffffffd, 0xffffffff,
  0x0000d553, 0x0000fffc, 0xfffffffe, 0x00000000,
  0x0000fffb, 0x0000fffd, 0xffffffff, 0xffff0001,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0000fffd, 0xffffffff, 0xffff0001, 0xffff2aab,
  0xfffffffe, 0x00000000, 0xffff2aaa, 0xffff4ccd,
  0xffffffff, 0x00002aa9, 0xffff4ccc, 0xffff7f81,
  0x00002aa8, 0x00004ccb, 0xffff7f80, 0xffff7f82,
  0x00004cca, 0x00007f7f, 0xffff7f81, 0xffff7f83,
  0x00007f7e, 0x00007f80, 0xffff7f82, 0xffff7f84,
  0x00007f7f, 0x00007f81, 0xffff7f83, 0xffff7ff1,
  0x00007f80, 0x00007f82, 0xffff7ff0, 0xffff7ffe,
  0x00007f81, 0x00007fef, 0xffff7ffd, 0xffff7fff,
  0x00007fee, 0x00007ffc, 0xffff7ffe, 0xffff8000,
  0x00007ffc, 0xffff7ffe, 0xffff8000, 0xffffaaaa,
  0x00007ffd, 0xffff7fff, 0xffff8001, 0xffffaaab,
  0x00007ffe, 0xffff8000, 0xffff8002, 0xffffaaac,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaba,
  0x00008000, 0xffff8002, 0xffff8011, 0xffffab27,
  0x00008001, 0xffff8010, 0xffff807e, 0xffffab28,
  0x0000800f, 0xffff807d, 0xffff807f, 0xffffab29,
  0x0000807c, 0xffff807e, 0xffff8080, 0xffffdddd,
  0x0000807d, 0xffff807f, 0xffffb334, 0xffffffff,
  0x0000807e, 0xffffb333, 0xffffd556, 0x00002aa7,
  0x0000b332, 0xffffd555, 0xfffffffe, 0x00002aa8,
  0x0000d554, 0xfffffffd, 0xffffffff, 0x00002aa9,
  0x0000fffc, 0xfffffffe, 0x00000000, 0xffff2aaa,
  0x0000fffd, 0xffffffff, 0xffff0001, 0xffff2aab,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0xffffffff, 0xffff0001, 0xffff2aab, 0xffff7776,
  0x00000000, 0xffff2aaa, 0xffff4ccd, 0xffffaa2a,
  0x00002aa9, 0xffff4ccc, 0xffff7f81, 0xffffaa2b,
  0x00004ccb, 0xffff7f80, 0xffff7f82, 0xffffaa2c,
  0x00007f7f, 0xffff7f81, 0xffff7f83, 0xffffaa2d,
  0x00007f80, 0xffff7f82, 0xffff7f84, 0xffffaa9a,
  0x00007f81, 0xffff7f83, 0xffff7ff1, 0xffffaaa7,
  0x00007f82, 0xffff7ff0, 0xffff7ffe, 0xffffaaa8,
  0x00007fef, 0xffff7ffd, 0xffff7fff, 0xffffaaa9,
  0xffff7ffd, 0xffff7fff, 0xffffaaa9, 0xffffcccc,
  0xffff7ffe, 0xffff8000, 0xffffaaaa, 0xffffcccd,
  0xffff7fff, 0xffff8001, 0xffffaaab, 0xffffccce,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccdc,
  0xffff8001, 0xffff8003, 0xffffaaba, 0xffffcd49,
  0xffff8002, 0xffff8011, 0xffffab27, 0xffffcd4a,
  0xffff8010, 0xffff807e, 0xffffab28, 0xffffcd4b,
  0xffff807d, 0xffff807f, 0xffffab29, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffffdddd, 0x00002221,
  0xffff807f, 0xffffb334, 0xffffffff, 0x00004cc9,
  0xffffb333, 0xffffd556, 0x00002aa7, 0x00004cca,
  0xffffd555, 0xfffffffe, 0x00002aa8, 0x00004ccb,
  0xfffffffd, 0xffffffff, 0x00002aa9, 0xffff4ccc,
  0xfffffffe, 0x00000000, 0xffff2aaa, 0xffff4ccd,
  0xffffffff, 0xffff0001, 0xffff2aab, 0xffff7776,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xffff0001, 0xffff2aab, 0xffff7776, 0xffffcc4c,
  0xffff2aaa, 0xffff4ccd, 0xffffaa2a, 0xffffcc4d,
  0xffff4ccc, 0xffff7f81, 0xffffaa2b, 0xffffcc4e,
  0xffff7f80, 0xffff7f82, 0xffffaa2c, 0xffffcc4f,
  0xffff7f81, 0xffff7f83, 0xffffaa2d, 0xffffccbc,
  0xffff7f82, 0xffff7f84, 0xffffaa9a, 0xffffccc9,
  0xffff7f83, 0xffff7ff1, 0xffffaaa7, 0xffffccca,
  0xffff7ff0, 0xffff7ffe, 0xffffaaa8, 0xffffcccb,
  0xffff7ffe, 0xffffaaa8, 0xffffcccb, 0xffffff80,
  0xffff7fff, 0xffffaaa9, 0xffffcccc, 0xffffff81,
  0xffff8000, 0xffffaaaa, 0xffffcccd, 0xffffff82,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffff90,
  0xffff8002, 0xffffaaac, 0xffffccdc, 0xfffffffd,
  0xffff8003, 0xffffaaba, 0xffffcd49, 0xfffffffe,
  0xffff8011, 0xffffab27, 0xffffcd4a, 0xffffffff,
  0xffff807e, 0xffffab28, 0xffffcd4b, 0x000032b3,
  0xffff807f, 0xffffab29, 0xffffffff, 0x000054d5,
  0xffff8080, 0xffffdddd, 0x00002221, 0x00007f7d,
  0xffffb334, 0xffffffff, 0x00004cc9, 0x00007f7e,
  0xffffd556, 0x00002aa7, 0x00004cca, 0x00007f7f,
  0xfffffffe, 0x00002aa8, 0x00004ccb, 0xffff7f80,
  0xffffffff, 0x00002aa9, 0xffff4ccc, 0xffff7f81,
  0x00000000, 0xffff2aaa, 0xffff4ccd, 0xffffaa2a,
  0xffff0001, 0xffff2aab, 0xffff7776, 0xffffcc4c,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xffff2aab, 0xffff7776, 0xffffcc4c, 0xffffff01,
  0xffff4ccd, 0xffffaa2a, 0xffffcc4d, 0xffffff02,
  0xffff7f81, 0xffffaa2b, 0xffffcc4e, 0xffffff03,
  0xffff7f82, 0xffffaa2c, 0xffffcc4f, 0xffffff70,
  0xffff7f83, 0xffffaa2d, 0xffffccbc, 0xffffff7d,
  0xffff7f84, 0xffffaa9a, 0xffffccc9, 0xffffff7e,
  0xffff7ff1, 0xffffaaa7, 0xffffccca, 0xffffff7f,
  0xffffaaa7, 0xffffccca, 0xffffff7f, 0xffffff81,
  0xffffaaa8, 0xffffcccb, 0xffffff80, 0xffffff82,
  0xffffaaa9, 0xffffcccc, 0xffffff81, 0xffffff83,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffff91,
  0xffffaaab, 0xffffccce, 0xffffff90, 0xfffffffe,
  0xffffaaac, 0xffffccdc, 0xfffffffd, 0xffffffff,
  0xffffaaba, 0xffffcd49, 0xfffffffe, 0x00000000,
  0xffffab27, 0xffffcd4a, 0xffffffff, 0x000032b4,
  0xffffab28, 0xffffcd4b, 0x000032b3, 0x000054d6,
  0xffffab29, 0xffffffff, 0x000054d5, 0x00007f7e,
  0xffffdddd, 0x00002221, 0x00007f7d, 0x00007f7f,
  0xffffffff, 0x00004cc9, 0x00007f7e, 0x00007f80,
  0x00002aa7, 0x00004cca, 0x00007f7f, 0xffff7f81,
  0x00002aa8, 0x00004ccb, 0xffff7f80, 0xffff7f82,
  0x00002aa9, 0xffff4ccc, 0xffff7f81, 0xffffaa2b,
  0xffff2aaa, 0xffff4ccd, 0xffffaa2a, 0xffffcc4d,
  0xffff2aab, 0xffff7776, 0xffffcc4c, 0xffffff01,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xffff7776, 0xffffcc4c, 0xffffff01, 0xffffff03,
  0xffffaa2a, 0xffffcc4d, 0xffffff02, 0xffffff04,
  0xffffaa2b, 0xffffcc4e, 0xffffff03, 0xffffff71,
  0xffffaa2c, 0xffffcc4f, 0xffffff70, 0xffffff7e,
  0xffffaa2d, 0xffffccbc, 0xffffff7d, 0xffffff7f,
  0xffffaa9a, 0xffffccc9, 0xffffff7e, 0xffffff80,
  0xffffccc9, 0xffffff7e, 0xffffff80, 0xffffff82,
  0xffffccca, 0xffffff7f, 0xffffff81, 0xffffff83,
  0xffffcccb, 0xffffff80, 0xffffff82, 0xffffff84,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffff92,
  0xffffcccd, 0xffffff82, 0xffffff91, 0xffffffff,
  0xffffccce, 0xffffff90, 0xfffffffe, 0x00000000,
  0xffffccdc, 0xfffffffd, 0xffffffff, 0x00000001,
  0xffffcd49, 0xfffffffe, 0x00000000, 0x000032b5,
  0xffffcd4a, 0xffffffff, 0x000032b4, 0x000054d7,
  0xffffcd4b, 0x000032b3, 0x000054d6, 0x00007f7f,
  0xffffffff, 0x000054d5, 0x00007f7e, 0x00007f80,
  0x00002221, 0x00007f7d, 0x00007f7f, 0x00007f81,
  0x00004cc9, 0x00007f7e, 0x00007f80, 0xffff7f82,
  0x00004cca, 0x00007f7f, 0xffff7f81, 0xffff7f83,
  0x00004ccb, 0xffff7f80, 0xffff7f82, 0xffffaa2c,
  0xffff4ccc, 0xffff7f81, 0xffffaa2b, 0xffffcc4e,
  0xffff4ccd, 0xffffaa2a, 0xffffcc4d, 0xffffff02,
  0xffff7776, 0xffffcc4c, 0xffffff01, 0xffffff03,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffffcc4c, 0xffffff01, 0xffffff03, 0xffffff05,
  0xffffcc4d, 0xffffff02, 0xffffff04, 0xffffff72,
  0xffffcc4e, 0xffffff03, 0xffffff71, 0xffffff7f,
  0xffffcc4f, 0xffffff70, 0xffffff7e, 0xffffff80,
  0xffffccbc, 0xffffff7d, 0xffffff7f, 0xffffff81,
  0xffffff7d, 0xffffff7f, 0xffffff81, 0xffffff83,
  0xffffff7e, 0xffffff80, 0xffffff82, 0xffffff84,
  0xffffff7f, 0xffffff81, 0xffffff83, 0xffffff85,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffff93,
  0xffffff81, 0xffffff83, 0xffffff92, 0x00000000,
  0xffffff82, 0xffffff91, 0xffffffff, 0x00000001,
  0xffffff90, 0xfffffffe, 0x00000000, 0x00000002,
  0xfffffffd, 0xffffffff, 0x00000001, 0x000032b6,
  0xfffffffe, 0x00000000, 0x000032b5, 0x000054d8,
  0xffffffff, 0x000032b4, 0x000054d7, 0x00007f80,
  0x000032b3, 0x000054d6, 0x00007f7f, 0x00007f81,
  0x000054d5, 0x00007f7e, 0x00007f80, 0x00007f82,
  0x00007f7d, 0x00007f7f, 0x00007f81, 0xffff7f83,
  0x00007f7e, 0x00007f80, 0xffff7f82, 0xffff7f84,
  0x00007f7f, 0xffff7f81, 0xffff7f83, 0xffffaa2d,
  0xffff7f80, 0xffff7f82, 0xffffaa2c, 0xffffcc4f,
  0xffff7f81, 0xffffaa2b, 0xffffcc4e, 0xffffff03,
  0xffffaa2a, 0xffffcc4d, 0xffffff02, 0xffffff04,
  0xffffcc4c, 0xffffff01, 0xffffff03, 0xffffff05,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xffffff01, 0xffffff03, 0xffffff05, 0xffffff73,
  0xffffff02, 0xffffff04, 0xffffff72, 0xffffff80,
  0xffffff03, 0xffffff71, 0xffffff7f, 0xffffff81,
  0xffffff70, 0xffffff7e, 0xffffff80, 0xffffff82,
  0xffffff7e, 0xffffff80, 0xffffff82, 0xfffffff0,
  0xffffff7f, 0xffffff81, 0xffffff83, 0xfffffff1,
  0xffffff80, 0xffffff82, 0xffffff84, 0xfffffff2,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000000,
  0xffffff82, 0xffffff84, 0xffffff93, 0x0000006d,
  0xffffff83, 0xffffff92, 0x00000000, 0x0000006e,
  0xffffff91, 0xffffffff, 0x00000001, 0x0000006f,
  0xfffffffe, 0x00000000, 0x00000002, 0x00003323,
  0xffffffff, 0x00000001, 0x000032b6, 0x00005545,
  0x00000000, 0x000032b5, 0x000054d8, 0x00007fed,
  0x000032b4, 0x000054d7, 0x00007f80, 0x00007fee,
  0x000054d6, 0x00007f7f, 0x00007f81, 0x00007fef,
  0x00007f7e, 0x00007f80, 0x00007f82, 0xffff7ff0,
  0x00007f7f, 0x00007f81, 0xffff7f83, 0xffff7ff1,
  0x00007f80, 0xffff7f82, 0xffff7f84, 0xffffaa9a,
  0xffff7f81, 0xffff7f83, 0xffffaa2d, 0xffffccbc,
  0xffff7f82, 0xffffaa2c, 0xffffcc4f, 0xffffff70,
  0xffffaa2b, 0xffffcc4e, 0xffffff03, 0xffffff71,
  0xffffcc4d, 0xffffff02, 0xffffff04, 0xffffff72,
  0xffffff01, 0xffffff03, 0xffffff05, 0xffffff73,
  0xffffff02, 0xffffff04, 0xffffff06, 0xffffffe0,
  0xffffff03, 0xffffff05, 0xffffff73, 0xffffffed,
  0xffffff04, 0xffffff72, 0xffffff80, 0xffffffee,
  0xffffff71, 0xffffff7f, 0xffffff81, 0xffffffef,
  0xffffff7f, 0xffffff81, 0xffffffef, 0xfffffffd,
  0xffffff80, 0xffffff82, 0xfffffff0, 0xfffffffe,
  0xffffff81, 0xffffff83, 0xfffffff1, 0xffffffff,
  0xffffff82, 0xffffff84, 0xfffffff2, 0x0000000d,
  0xffffff83, 0xffffff85, 0x00000000, 0x0000007a,
  0xffffff84, 0xffffff93, 0x0000006d, 0x0000007b,
  0xffffff92, 0x00000000, 0x0000006e, 0x0000007c,
  0xffffffff, 0x00000001, 0x0000006f, 0x00003330,
  0x00000000, 0x00000002, 0x00003323, 0x00005552,
  0x00000001, 0x000032b6, 0x00005545, 0x00007ffa,
  0x000032b5, 0x000054d8, 0x00007fed, 0x00007ffb,
  0x000054d7, 0x00007f80, 0x00007fee, 0x00007ffc,
  0x00007f7f, 0x00007f81, 0x00007fef, 0xffff7ffd,
  0x00007f80, 0x00007f82, 0xffff7ff0, 0xffff7ffe,
  0x00007f81, 0xffff7f83, 0xffff7ff1, 0xffffaaa7,
  0xffff7f82, 0xffff7f84, 0xffffaa9a, 0xffffccc9,
  0xffff7f83, 0xffffaa2d, 0xffffccbc, 0xffffff7d,
  0xffffaa2c, 0xffffcc4f, 0xffffff70, 0xffffff7e,
  0xffffcc4e, 0xffffff03, 0xffffff71, 0xffffff7f,
  0xffffff02, 0xffffff04, 0xffffff72, 0xffffff80,
  0xffffff03, 0xffffff05, 0xffffff73, 0xffffffed,
  0xffffff04, 0xffffff06, 0xffffffe0, 0xfffffffa,
  0xffffff05, 0xffffff73, 0xffffffed, 0xfffffffb,
  0xffffff72, 0xffffff80, 0xffffffee, 0xfffffffc,
  0xffffff80, 0xffffffee, 0xfffffffc, 0xfffffffe,
  0xffffff81, 0xffffffef, 0xfffffffd, 0xffffffff,
  0xffffff82, 0xfffffff0, 0xfffffffe, 0x00000000,
  0xffffff83, 0xfffffff1, 0xffffffff, 0x0000000e,
  0xffffff84, 0xfffffff2, 0x0000000d, 0x0000007b,
  0xffffff85, 0x00000000, 0x0000007a, 0x0000007c,
  0xffffff93, 0x0000006d, 0x0000007b, 0x0000007d,
  0x00000000, 0x0000006e, 0x0000007c, 0x00003331,
  0x00000001, 0x0000006f, 0x00003330, 0x00005553,
  0x00000002, 0x00003323, 0x00005552, 0x00007ffb,
  0x000032b6, 0x00005545, 0x00007ffa, 0x00007ffc,
  0x000054d8, 0x00007fed, 0x00007ffb, 0x00007ffd,
  0x00007f80, 0x00007fee, 0x00007ffc, 0xffff7ffe,
  0x00007f81, 0x00007fef, 0xffff7ffd, 0xffff7fff,
  0x00007f82, 0xffff7ff0, 0xffff7ffe, 0xffffaaa8,
  0xffff7f83, 0xffff7ff1, 0xffffaaa7, 0xffffccca,
  0xffff7f84, 0xffffaa9a, 0xffffccc9, 0xffffff7e,
  0xffffaa2d, 0xffffccbc, 0xffffff7d, 0xffffff7f,
  0xffffcc4f, 0xffffff70, 0xffffff7e, 0xffffff80,
  0xffffff03, 0xffffff71, 0xffffff7f, 0xffffff81,
  0xffffff04, 0xffffff72, 0xffffff80, 0xffffffee,
  0xffffff05, 0xffffff73, 0xffffffed, 0xfffffffb,
  0xffffff06, 0xffffffe0, 0xfffffffa, 0xfffffffc,
  0xffffff73, 0xffffffed, 0xfffffffb, 0xfffffffd,
  0xffffffed, 0xfffffffb, 0xfffffffd, 0xffffffff,
  0xffffffee, 0xfffffffc, 0xfffffffe, 0x00000000,
  0xffffffef, 0xfffffffd, 0xffffffff, 0x00000001,
  0xfffffff0, 0xfffffffe, 0x00000000, 0x0000000f,
  0xfffffff1, 0xffffffff, 0x0000000e, 0x0000007c,
  0xfffffff2, 0x0000000d, 0x0000007b, 0x0000007d,
  0x00000000, 0x0000007a, 0x0000007c, 0x0000007e,
  0x0000006d, 0x0000007b, 0x0000007d, 0x00003332,
  0x0000006e, 0x0000007c, 0x00003331, 0x00005554,
  0x0000006f, 0x00003330, 0x00005553, 0x00007ffc,
  0x00003323, 0x00005552, 0x00007ffb, 0x00007ffd,
  0x00005545, 0x00007ffa, 0x00007ffc, 0x00007ffe,
  0x00007fed, 0x00007ffb, 0x00007ffd, 0xffff7fff,
  0x00007fee, 0x00007ffc, 0xffff7ffe, 0xffff8000,
  0x00007fef, 0xffff7ffd, 0xffff7fff, 0xffffaaa9,
  0xffff7ff0, 0xffff7ffe, 0xffffaaa8, 0xffffcccb,
  0xffff7ff1, 0xffffaaa7, 0xffffccca, 0xffffff7f,
  0xffffaa9a, 0xffffccc9, 0xffffff7e, 0xffffff80,
  0xffffccbc, 0xffffff7d, 0xffffff7f, 0xffffff81,
  0xffffff70, 0xffffff7e, 0xffffff80, 0xffffff82,
  0xffffff71, 0xffffff7f, 0xffffff81, 0xffffffef,
  0xffffff72, 0xffffff80, 0xffffffee, 0xfffffffc,
  0xffffff73, 0xffffffed, 0xfffffffb, 0xfffffffd,
  0xffffffe0, 0xfffffffa, 0xfffffffc, 0xfffffffe,
};
const unsigned kExpectedCount_NEON_saddl2_4S = 576;

#endif  // VIXL_SIM_SADDL2_4S_TRACE_AARCH64_H_
