// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use ctypes::{c_char, c_void};
use shared::basetsd::{SIZE_T, UINT64};
use shared::minwindef::{BOOL, FLOAT, UINT};
use um::d3d12::ID3D12Resource;
use um::unknwnbase::{IUnknown, IUnknownVtbl};
use um::winnt::{HRESULT, LPCSTR};
RIDL!{#[uuid(0x344488b7, 0x6846, 0x474b, 0xb9, 0x89, 0xf0, 0x27, 0x44, 0x82, 0x45, 0xe0)]
interface ID3D12Debug(ID3D12DebugVtbl): IUnknown(IUnknownVtbl) {
    fn EnableDebugLayer() -> (),
}}
RIDL!{#[uuid(0xaffaa4ca, 0x63fe, 0x4d8e, 0xb8, 0xad, 0x15, 0x90, 0x00, 0xaf, 0x43, 0x04)]
interface ID3D12Debug1(ID3D12Debug1Vtbl): IUnknown(IUnknownVtbl) {
    fn EnableDebugLayer() -> (),
    fn SetEnableGPUBasedValidation(
        Enable: BOOL,
    ) -> (),
    fn SetEnableSynchronizedCommandQueueValidation(
        Enable: BOOL,
    ) -> (),
}}
ENUM!{enum D3D12_GPU_BASED_VALIDATION_FLAGS {
    D3D12_GPU_BASED_VALIDATION_FLAGS_NONE = 0,
    D3D12_GPU_BASED_VALIDATION_FLAGS_DISABLE_STATE_TRACKING = 0x01,
}}
RIDL!{#[uuid(0x93a665c4, 0xa3b2, 0x4e5d, 0xb6, 0x92, 0xa2, 0x6a, 0xe1, 0x4e, 0x33, 0x74)]
interface ID3D12Debug2(ID3D12Debug2Vtbl): IUnknown(IUnknownVtbl) {
    fn SetGPUBasedValidationFlags(
        Flags: D3D12_GPU_BASED_VALIDATION_FLAGS,
    ) -> (),
}}
ENUM!{enum D3D12_RLDO_FLAGS {
    D3D12_RLDO_NONE = 0,
    D3D12_RLDO_SUMMARY = 0x1,
    D3D12_RLDO_DETAIL = 0x2,
    D3D12_RLDO_IGNORE_INTERNAL = 0x4,
}}
ENUM!{enum D3D12_DEBUG_DEVICE_PARAMETER_TYPE {
    D3D12_DEBUG_DEVICE_PARAMETER_FEATURE_FLAGS = 0,
    D3D12_DEBUG_DEVICE_PARAMETER_GPU_BASED_VALIDATION_SETTINGS = 1,
    D3D12_DEBUG_DEVICE_PARAMETER_GPU_SLOWDOWN_PERFORMANCE_FACTOR = 2,
}}
ENUM!{enum D3D12_DEBUG_FEATURE {
    D3D12_DEBUG_FEATURE_NONE = 0,
    D3D12_DEBUG_FEATURE_TREAT_BUNDLE_AS_DRAW = 0x1,
    D3D12_DEBUG_FEATURE_TREAT_BUNDLE_AS_DISPATCH = 0x2,
    D3D12_DEBUG_FEATURE_DISABLE_VIRTUALIZED_BUNDLES_VALIDATION = 0x04,
    D3D12_DEBUG_FEATURE_VALID_MASK = 0x7,
}}
ENUM!{enum D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE {
    D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_NONE = 0,
    D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_STATE_TRACKING_ONLY = 1,
    D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_UNGUARDED_VALIDATION = 2,
    D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_GUARDED_VALIDATION = 3,
    NUM_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODES = 4,
}}
ENUM!{enum D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS {
    D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_NONE = 0,
    D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_TRACKING_ONLY_SHADERS
        = 0x01,
    D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_UNGUARDED_VALIDATION_SHADERS = 0x02,
    D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_GUARDED_VALIDATION_SHADERS = 0x04,
    D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_VALID_MASK = 0x07,
}}
STRUCT!{struct D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    MaxMessagesPerCommandList: UINT,
    DefaultShaderPatchMode: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE,
    PipelineStateCreateFlags: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS,
}}
STRUCT!{struct D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    SlowdownFactor: FLOAT,
}}
RIDL!{#[uuid(0x3febd6dd, 0x4973, 0x4787, 0x81, 0x94, 0xe4, 0x5f, 0x9e, 0x28, 0x92, 0x3e)]
interface ID3D12DebugDevice1(ID3D12DebugDevice1Vtbl): IUnknown(IUnknownVtbl) {
    fn SetDebugParameter(
        Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
        pData: *const c_void,
        DataSize: UINT,
    ) -> HRESULT,
    fn GetDebugParameter(
        Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
        pData: *mut c_void,
        DataSize: UINT,
    ) -> HRESULT,
    fn ReportLiveDeviceObjects(
        Flags: D3D12_RLDO_FLAGS,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0x3febd6dd, 0x4973, 0x4787, 0x81, 0x94, 0xe4, 0x5f, 0x9e, 0x28, 0x92, 0x3e)]
interface ID3D12DebugDevice(ID3D12DebugDeviceVtbl): IUnknown(IUnknownVtbl) {
    fn SetFeatureMask(
        Mask: D3D12_DEBUG_FEATURE,
    ) -> HRESULT,
    fn GetFeatureMask() -> D3D12_DEBUG_FEATURE,
    fn ReportLiveDeviceObjects(
        Flags: D3D12_RLDO_FLAGS,
    ) -> HRESULT,
}}
DEFINE_GUID!{DXGI_DEBUG_D3D12,
    0xcf59a98c, 0xa950, 0x4326, 0x91, 0xef, 0x9b, 0xba, 0xa1, 0x7b, 0xfd, 0x95}
RIDL!{#[uuid(0x09e0bf36, 0x54ac, 0x484f, 0x88, 0x47, 0x4b, 0xae, 0xea, 0xb6, 0x05, 0x3a)]
interface ID3D12DebugCommandQueue(ID3D12DebugCommandQueueVtbl): IUnknown(IUnknownVtbl) {
    fn AssertResourceState(
        pResource: *mut ID3D12Resource,
        Subresource: UINT,
        State: UINT,
    ) -> BOOL,
}}
ENUM!{enum D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE {
    D3D12_DEBUG_COMMAND_LIST_PARAMETER_GPU_BASED_VALIDATION_SETTINGS = 0,
}}
STRUCT!{struct D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    ShaderPatchMode: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE,
}}
RIDL!{#[uuid(0x102ca951, 0x311b, 0x4b01, 0xb1, 0x1f, 0xec, 0xb8, 0x3e, 0x06, 0x1b, 0x37)]
interface ID3D12DebugCommandList1(ID3D12DebugCommandList1Vtbl): IUnknown(IUnknownVtbl) {
    fn AssertResourceState(
        pResource: *mut ID3D12Resource,
        Subresource: UINT,
        State: UINT,
    ) -> BOOL,
    fn SetDebugParameter(
        Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
        pData: *const c_void,
        DataSize: UINT,
    ) -> HRESULT,
    fn GetDebugParameter(
        Type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE,
        pData: *mut c_void,
        DataSize: UINT,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0x09e0bf36, 0x54ac, 0x484f, 0x88, 0x47, 0x4b, 0xae, 0xea, 0xb6, 0x05, 0x3f)]
interface ID3D12DebugCommandList(ID3D12DebugCommandListVtbl): IUnknown(IUnknownVtbl) {
    fn AssertResourceState(
        pResource: *mut ID3D12Resource,
        Subresource: UINT,
        State: UINT,
    ) -> BOOL,
    fn SetFeatureMask(
        Mask: D3D12_DEBUG_FEATURE,
    ) -> HRESULT,
    fn GetFeatureMask() -> D3D12_DEBUG_FEATURE,
}}
ENUM!{enum D3D12_MESSAGE_CATEGORY {
    D3D12_MESSAGE_CATEGORY_APPLICATION_DEFINED = 0,
    D3D12_MESSAGE_CATEGORY_MISCELLANEOUS = 1,
    D3D12_MESSAGE_CATEGORY_INITIALIZATION = 2,
    D3D12_MESSAGE_CATEGORY_CLEANUP = 3,
    D3D12_MESSAGE_CATEGORY_COMPILATION = 4,
    D3D12_MESSAGE_CATEGORY_STATE_CREATION = 5,
    D3D12_MESSAGE_CATEGORY_STATE_SETTING = 6,
    D3D12_MESSAGE_CATEGORY_STATE_GETTING = 7,
    D3D12_MESSAGE_CATEGORY_RESOURCE_MANIPULATION = 8,
    D3D12_MESSAGE_CATEGORY_EXECUTION = 9,
    D3D12_MESSAGE_CATEGORY_SHADER = 10,
}}
ENUM!{enum D3D12_MESSAGE_SEVERITY {
    D3D12_MESSAGE_SEVERITY_CORRUPTION = 0,
    D3D12_MESSAGE_SEVERITY_ERROR = 1,
    D3D12_MESSAGE_SEVERITY_WARNING = 2,
    D3D12_MESSAGE_SEVERITY_INFO = 3,
    D3D12_MESSAGE_SEVERITY_MESSAGE = 4,
}}
ENUM!{enum D3D12_MESSAGE_ID {
    D3D12_MESSAGE_ID_UNKNOWN = 0,
    D3D12_MESSAGE_ID_STRING_FROM_APPLICATION = 1,
    D3D12_MESSAGE_ID_CORRUPTED_THIS = 2,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER1 = 3,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER2 = 4,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER3 = 5,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER4 = 6,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER5 = 7,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER6 = 8,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER7 = 9,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER8 = 10,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER9 = 11,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER10 = 12,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER11 = 13,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER12 = 14,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER13 = 15,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER14 = 16,
    D3D12_MESSAGE_ID_CORRUPTED_PARAMETER15 = 17,
    D3D12_MESSAGE_ID_CORRUPTED_MULTITHREADING = 18,
    D3D12_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY = 19,
    D3D12_MESSAGE_ID_GETPRIVATEDATA_MOREDATA = 20,
    D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA = 21,
    D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN = 22,
    D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS = 23,
    D3D12_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS = 24,
    D3D12_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY = 25,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT = 26,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC = 27,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT = 28,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANESLICE = 29,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANESLICE = 30,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS = 31,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE = 32,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN = 33,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN = 34,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT = 35,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT = 36,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC = 37,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT = 38,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANESLICE = 39,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANESLICE = 40,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS = 41,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE = 42,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN = 43,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN = 44,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT = 45,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC = 46,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT = 47,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS = 48,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE = 49,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN = 50,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN = 51,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY = 52,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS = 53,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT = 54,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT = 55,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT = 56,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS = 57,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH = 58,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE = 59,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE = 60,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT = 61,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC = 62,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE = 63,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC = 64,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT = 65,
    D3D12_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY = 66,
    D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE = 67,
    D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE = 68,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY = 69,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE = 70,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE = 71,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY = 72,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE = 73,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE = 74,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES = 75,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED = 76,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL = 77,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL = 78,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED = 79,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT = 80,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT = 81,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT = 82,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT
        = 83,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION = 84,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT = 85,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE = 86,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC = 87,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH = 88,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS = 89,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX = 90,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE = 91,
    D3D12_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY = 92,
    D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE = 93,
    D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE = 94,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE = 95,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE = 96,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP = 97,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS = 98,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC = 99,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK = 100,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC = 101,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP = 102,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP = 103,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP = 104,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC = 105,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP = 106,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP = 107,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP = 108,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC = 109,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC = 110,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND = 111,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND = 112,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP = 113,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA = 114,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA = 115,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA = 116,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK = 117,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC = 118,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER = 119,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU = 120,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV = 121,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW = 122,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS = 123,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY = 124,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC = 125,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD = 126,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD = 127,
    D3D12_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC = 128,
    D3D12_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED = 129,
    D3D12_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED = 130,
    D3D12_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT = 131,
    D3D12_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR = 132,
    D3D12_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH = 133,
    D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH = 134,
    D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID = 135,
    D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE = 136,
    D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE = 137,
    D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE = 138,
    D3D12_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE = 139,
    D3D12_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX = 140,
    D3D12_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE = 141,
    D3D12_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID = 142,
    D3D12_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID = 143,
    D3D12_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID = 144,
    D3D12_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID = 145,
    D3D12_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID = 146,
    D3D12_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE = 147,
    D3D12_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS = 148,
    D3D12_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED = 149,
    D3D12_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN = 150,
    D3D12_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED = 151,
    D3D12_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE = 152,
    D3D12_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE = 153,
    D3D12_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS = 154,
    D3D12_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED = 155,
    D3D12_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN = 156,
    D3D12_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE = 157,
    D3D12_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED = 158,
    D3D12_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE = 159,
    D3D12_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE = 160,
    D3D12_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS = 161,
    D3D12_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED = 162,
    D3D12_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN = 163,
    D3D12_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE = 164,
    D3D12_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED = 165,
    D3D12_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE = 166,
    D3D12_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE = 167,
    D3D12_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS = 168,
    D3D12_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED = 169,
    D3D12_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN = 170,
    D3D12_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE = 171,
    D3D12_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED = 172,
    D3D12_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED = 173,
    D3D12_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED = 174,
    D3D12_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS = 175,
    D3D12_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN = 176,
    D3D12_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN = 177,
    D3D12_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE = 178,
    D3D12_MESSAGE_ID_REF_THREADING_MODE = 179,
    D3D12_MESSAGE_ID_REF_UMDRIVER_EXCEPTION = 180,
    D3D12_MESSAGE_ID_REF_KMDRIVER_EXCEPTION = 181,
    D3D12_MESSAGE_ID_REF_HARDWARE_EXCEPTION = 182,
    D3D12_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE = 183,
    D3D12_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER = 184,
    D3D12_MESSAGE_ID_REF_OUT_OF_MEMORY = 185,
    D3D12_MESSAGE_ID_REF_INFO = 186,
    D3D12_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW = 187,
    D3D12_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW = 188,
    D3D12_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW = 189,
    D3D12_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW = 190,
    D3D12_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW = 191,
    D3D12_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW = 192,
    D3D12_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET = 193,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND = 194,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX = 195,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE = 196,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK = 197,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE = 198,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS = 199,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_NOT_SET = 200,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_MISMATCH = 201,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_NOT_SET = 202,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INPUTLAYOUT_NOT_SET = 203,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_CONSTANT_BUFFER_NOT_SET = 204,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_CONSTANT_BUFFER_TOO_SMALL = 205,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_SAMPLER_NOT_SET = 206,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_SHADERRESOURCEVIEW_NOT_SET = 207,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VIEW_DIMENSION_MISMATCH = 208,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL = 209,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_TOO_SMALL = 210,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_NOT_SET = 211,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_FORMAT_INVALID = 212,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_TOO_SMALL = 213,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_GS_INPUT_PRIMITIVE_MISMATCH = 214,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RESOURCE_RETURN_TYPE_MISMATCH = 215,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_POSITION_NOT_PRESENT = 216,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_OUTPUT_STREAM_NOT_SET = 217,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_BOUND_RESOURCE_MAPPED = 218,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INVALID_PRIMITIVETOPOLOGY = 219,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_OFFSET_UNALIGNED = 220,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_STRIDE_UNALIGNED = 221,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_OFFSET_UNALIGNED = 222,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED = 223,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED = 224,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED = 225,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED = 226,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED = 227,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE = 228,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_SO_STRIDE_LARGER_THAN_BUFFER = 229,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING = 230,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 = 231,
    D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT = 232,
    D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT = 233,
    D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT = 234,
    D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN = 235,
    D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN = 236,
    D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN = 237,
    D3D12_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET = 238,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC = 239,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC = 240,
    D3D12_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH = 241,
    D3D12_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW = 242,
    D3D12_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS = 243,
    D3D12_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH = 244,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH = 245,
    D3D12_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY = 246,
    D3D12_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY = 247,
    D3D12_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH = 248,
    D3D12_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED = 249,
    D3D12_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN = 250,
    D3D12_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE = 251,
    D3D12_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE = 252,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT = 253,
    D3D12_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH = 254,
    D3D12_MESSAGE_ID_LIVE_OBJECT_SUMMARY = 255,
    D3D12_MESSAGE_ID_LIVE_BUFFER = 256,
    D3D12_MESSAGE_ID_LIVE_TEXTURE1D = 257,
    D3D12_MESSAGE_ID_LIVE_TEXTURE2D = 258,
    D3D12_MESSAGE_ID_LIVE_TEXTURE3D = 259,
    D3D12_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW = 260,
    D3D12_MESSAGE_ID_LIVE_RENDERTARGETVIEW = 261,
    D3D12_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW = 262,
    D3D12_MESSAGE_ID_LIVE_VERTEXSHADER = 263,
    D3D12_MESSAGE_ID_LIVE_GEOMETRYSHADER = 264,
    D3D12_MESSAGE_ID_LIVE_PIXELSHADER = 265,
    D3D12_MESSAGE_ID_LIVE_INPUTLAYOUT = 266,
    D3D12_MESSAGE_ID_LIVE_SAMPLER = 267,
    D3D12_MESSAGE_ID_LIVE_BLENDSTATE = 268,
    D3D12_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE = 269,
    D3D12_MESSAGE_ID_LIVE_RASTERIZERSTATE = 270,
    D3D12_MESSAGE_ID_LIVE_QUERY = 271,
    D3D12_MESSAGE_ID_LIVE_PREDICATE = 272,
    D3D12_MESSAGE_ID_LIVE_COUNTER = 273,
    D3D12_MESSAGE_ID_LIVE_DEVICE = 274,
    D3D12_MESSAGE_ID_LIVE_SWAPCHAIN = 275,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS = 276,
    D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE = 277,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE = 278,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTREAMS = 279,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER = 280,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTREAMS = 281,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCLASSLINKAGE = 282,
    D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE = 283,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM = 284,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES = 285,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES = 286,
    D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES = 287,
    D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDCALL = 288,
    D3D12_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY = 289,
    D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE = 290,
    D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE = 291,
    D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE = 292,
    D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCALL = 293,
    D3D12_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY = 294,
    D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE = 295,
    D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE = 296,
    D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE = 297,
    D3D12_MESSAGE_ID_DEVICE_DRAW_HS_XOR_DS_MISMATCH = 298,
    D3D12_MESSAGE_ID_DEVICE_DRAWINDIRECT_INVALID_ARG_BUFFER = 299,
    D3D12_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_UNALIGNED = 300,
    D3D12_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_OVERFLOW = 301,
    D3D12_MESSAGE_ID_RESOURCE_MAP_INVALIDMAPTYPE = 302,
    D3D12_MESSAGE_ID_RESOURCE_MAP_INVALIDSUBRESOURCE = 303,
    D3D12_MESSAGE_ID_RESOURCE_MAP_INVALIDFLAGS = 304,
    D3D12_MESSAGE_ID_RESOURCE_MAP_ALREADYMAPPED = 305,
    D3D12_MESSAGE_ID_RESOURCE_MAP_DEVICEREMOVED_RETURN = 306,
    D3D12_MESSAGE_ID_RESOURCE_MAP_OUTOFMEMORY_RETURN = 307,
    D3D12_MESSAGE_ID_RESOURCE_MAP_WITHOUT_INITIAL_DISCARD = 308,
    D3D12_MESSAGE_ID_RESOURCE_UNMAP_INVALIDSUBRESOURCE = 309,
    D3D12_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED = 310,
    D3D12_MESSAGE_ID_DEVICE_DRAW_RASTERIZING_CONTROL_POINTS = 311,
    D3D12_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNSUPPORTED = 312,
    D3D12_MESSAGE_ID_DEVICE_DRAW_HS_DS_SIGNATURE_MISMATCH = 313,
    D3D12_MESSAGE_ID_DEVICE_DRAW_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH = 314,
    D3D12_MESSAGE_ID_DEVICE_DRAW_HS_DS_CONTROL_POINT_COUNT_MISMATCH = 315,
    D3D12_MESSAGE_ID_DEVICE_DRAW_HS_DS_TESSELLATOR_DOMAIN_MISMATCH = 316,
    D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_UNRECOGNIZED_FEATURE = 317,
    D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE = 318,
    D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_INVALIDARG_RETURN = 319,
    D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCALL = 320,
    D3D12_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY = 321,
    D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE = 322,
    D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE = 323,
    D3D12_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_VIEWS_EMPTY = 324,
    D3D12_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFER = 325,
    D3D12_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_BUFFERS_EMPTY = 326,
    D3D12_MESSAGE_ID_DEVICE_CSSETSAMPLERS_SAMPLERS_EMPTY = 327,
    D3D12_MESSAGE_ID_DEVICE_CSGETSHADERRESOURCES_VIEWS_EMPTY = 328,
    D3D12_MESSAGE_ID_DEVICE_CSGETCONSTANTBUFFERS_BUFFERS_EMPTY = 329,
    D3D12_MESSAGE_ID_DEVICE_CSGETSAMPLERS_SAMPLERS_EMPTY = 330,
    D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 331,
    D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 332,
    D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 333,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 334,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED = 335,
    D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED = 336,
    D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED = 337,
    D3D12_MESSAGE_ID_CREATEBUFFER_INVALIDSTRUCTURESTRIDE = 338,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFLAGS = 339,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE = 340,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC = 341,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT = 342,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANESLICE = 343,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANESLICE = 344,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS = 345,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT = 346,
    D3D12_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_OVERLAPPING_OLD_SLOTS = 347,
    D3D12_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NO_OP = 348,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDARG_RETURN = 349,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_OUTOFMEMORY_RETURN = 350,
    D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_DENORMFLUSH = 351,
    D3D12_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSS_VIEWS_EMPTY = 352,
    D3D12_MESSAGE_ID_DEVICE_CSGETUNORDEREDACCESSS_VIEWS_EMPTY = 353,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS = 354,
    D3D12_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_INVALID_ARG_BUFFER = 355,
    D3D12_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_UNALIGNED = 356,
    D3D12_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_OVERFLOW = 357,
    D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DEPTH_READONLY = 358,
    D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_STENCIL_READONLY = 359,
    D3D12_MESSAGE_ID_CHECKFEATURESUPPORT_FORMAT_DEPRECATED = 360,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RETURN_TYPE_MISMATCH = 361,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET = 362,
    D3D12_MESSAGE_ID_DEVICE_DRAW_UNORDEREDACCESSVIEW_RENDERTARGETVIEW_OVERLAP = 363,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_DIMENSION_MISMATCH = 364,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_APPEND_UNSUPPORTED = 365,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMICS_UNSUPPORTED = 366,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_STRUCTURE_STRIDE_MISMATCH = 367,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_BUFFER_TYPE_MISMATCH = 368,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RAW_UNSUPPORTED = 369,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_LD_UNSUPPORTED = 370,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_STORE_UNSUPPORTED = 371,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_ADD_UNSUPPORTED = 372,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_BITWISE_OPS_UNSUPPORTED = 373,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_CMPSTORE_CMPEXCHANGE_UNSUPPORTED = 374,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_EXCHANGE_UNSUPPORTED = 375,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_SIGNED_MINMAX_UNSUPPORTED = 376,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_UNSIGNED_MINMAX_UNSUPPORTED = 377,
    D3D12_MESSAGE_ID_DEVICE_DISPATCH_BOUND_RESOURCE_MAPPED = 378,
    D3D12_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_OVERFLOW = 379,
    D3D12_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_ZERO = 380,
    D3D12_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_STRUCTURE_STRIDE_MISMATCH = 381,
    D3D12_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_BUFFER_TYPE_MISMATCH = 382,
    D3D12_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_RAW_UNSUPPORTED = 383,
    D3D12_MESSAGE_ID_DEVICE_DISPATCH_UNSUPPORTED = 384,
    D3D12_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_UNSUPPORTED = 385,
    D3D12_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDOFFSET = 386,
    D3D12_MESSAGE_ID_COPYSTRUCTURECOUNT_LARGEOFFSET = 387,
    D3D12_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDDESTINATIONSTATE = 388,
    D3D12_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDSOURCESTATE = 389,
    D3D12_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_NOT_SUPPORTED = 390,
    D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_INVALIDFORMAT = 391,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_COUNTER_UNSUPPORTED = 392,
    D3D12_MESSAGE_ID_DEVICE_DRAW_PIXEL_SHADER_WITHOUT_RTV_OR_DSV = 393,
    D3D12_MESSAGE_ID_SHADER_ABORT = 394,
    D3D12_MESSAGE_ID_SHADER_MESSAGE = 395,
    D3D12_MESSAGE_ID_SHADER_ERROR = 396,
    D3D12_MESSAGE_ID_OFFERRESOURCES_INVALIDRESOURCE = 397,
    D3D12_MESSAGE_ID_ENQUEUESETEVENT_INVALIDARG_RETURN = 398,
    D3D12_MESSAGE_ID_ENQUEUESETEVENT_OUTOFMEMORY_RETURN = 399,
    D3D12_MESSAGE_ID_ENQUEUESETEVENT_ACCESSDENIED_RETURN = 400,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT = 401,
    D3D12_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_FORCED_SAMPLE_COUNT = 402,
    D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS = 403,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDARRAYWITHDECODER = 404,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDARRAYWITHDECODER = 405,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDARRAYWITHDECODER = 406,
    D3D12_MESSAGE_ID_DEVICE_LOCKEDOUT_INTERFACE = 407,
    D3D12_MESSAGE_ID_OFFERRESOURCES_INVALIDPRIORITY = 408,
    D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDVIEW = 409,
    D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 410,
    D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_SHADEREXTENSIONSNOTSUPPORTED = 411,
    D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 412,
    D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_SHADEREXTENSIONSNOTSUPPORTED = 413,
    D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 414,
    D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_SHADEREXTENSIONSNOTSUPPORTED = 415,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 416,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_SHADEREXTENSIONSNOTSUPPORTED = 417,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED
        = 418,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_SHADEREXTENSIONSNOTSUPPORTED
        = 419,
    D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 420,
    D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_SHADEREXTENSIONSNOTSUPPORTED = 421,
    D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED = 422,
    D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_SHADEREXTENSIONSNOTSUPPORTED = 423,
    D3D12_MESSAGE_ID_DEVICE_SHADER_LINKAGE_MINPRECISION = 424,
    D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED = 425,
    D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED = 426,
    D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED = 427,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED = 428,
    D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED = 429,
    D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED = 430,
    D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED = 431,
    D3D12_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_INVALIDOFFSET = 432,
    D3D12_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_TOOMANYVIEWS = 433,
    D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_NOTSUPPORTED = 434,
    D3D12_MESSAGE_ID_SWAPDEVICECONTEXTSTATE_NOTSUPPORTED = 435,
    D3D12_MESSAGE_ID_UPDATESUBRESOURCE_PREFERUPDATESUBRESOURCE1 = 436,
    D3D12_MESSAGE_ID_GETDC_INACCESSIBLE = 437,
    D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDRECT = 438,
    D3D12_MESSAGE_ID_DEVICE_DRAW_SAMPLE_MASK_IGNORED_ON_FL9 = 439,
    D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE1_NOT_SUPPORTED = 440,
    D3D12_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BY_NAME_NOT_SUPPORTED = 441,
    D3D12_MESSAGE_ID_ENQUEUESETEVENT_NOT_SUPPORTED = 442,
    D3D12_MESSAGE_ID_OFFERRELEASE_NOT_SUPPORTED = 443,
    D3D12_MESSAGE_ID_OFFERRESOURCES_INACCESSIBLE = 444,
    D3D12_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMSAA = 445,
    D3D12_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMSAA = 446,
    D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT = 447,
    D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT = 448,
    D3D12_MESSAGE_ID_UPDATESUBRESOURCE_EMPTYDESTBOX = 449,
    D3D12_MESSAGE_ID_COPYSUBRESOURCEREGION_EMPTYSOURCEBOX = 450,
    D3D12_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS = 451,
    D3D12_MESSAGE_ID_DEVICE_DRAW_DEPTHSTENCILVIEW_NOT_SET = 452,
    D3D12_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET = 453,
    D3D12_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET_DUE_TO_FLIP_PRESENT = 454,
    D3D12_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET_DUE_TO_FLIP_PRESENT = 455,
    D3D12_MESSAGE_ID_GETDATAFORNEWHARDWAREKEY_NULLPARAM = 456,
    D3D12_MESSAGE_ID_CHECKCRYPTOSESSIONSTATUS_NULLPARAM = 457,
    D3D12_MESSAGE_ID_SETEVENTONHARDWARECONTENTPROTECTIONTILT_NULLPARAM = 458,
    D3D12_MESSAGE_ID_GETVIDEODECODERCAPS_NULLPARAM = 459,
    D3D12_MESSAGE_ID_GETVIDEODECODERCAPS_ZEROWIDTHHEIGHT = 460,
    D3D12_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_NULLPARAM = 461,
    D3D12_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE = 462,
    D3D12_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT = 463,
    D3D12_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_NULLPARAM = 464,
    D3D12_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_UNSUPPORTED = 465,
    D3D12_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_NULLPARAM = 466,
    D3D12_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_UNSUPPORTED = 467,
    D3D12_MESSAGE_ID_CHECKVIDEOPROCESSORFORMATCONVERSION_NULLPARAM = 468,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE1_NULLPARAM = 469,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE1_NULLPARAM = 470,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_NULLPARAM = 471,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_INVALIDSTREAM = 472,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_NULLPARAM = 473,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_INVALIDSTREAM = 474,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_UNSUPPORTED = 475,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_NULLPARAM = 476,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_NULLPARAM = 477,
    D3D12_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_NULLPARAM = 478,
    D3D12_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE = 479,
    D3D12_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT = 480,
    D3D12_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSHADERUSAGE_NULLPARAM = 481,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSHADERUSAGE_NULLPARAM = 482,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_NULLPARAM = 483,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSTREAMCOUNT = 484,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_TARGETRECT = 485,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSOURCERECT = 486,
    D3D12_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDDESTRECT = 487,
    D3D12_MESSAGE_ID_CREATEBUFFER_INVALIDUSAGE = 488,
    D3D12_MESSAGE_ID_CREATETEXTURE1D_INVALIDUSAGE = 489,
    D3D12_MESSAGE_ID_CREATETEXTURE2D_INVALIDUSAGE = 490,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_STEPRATE_NOT_1 = 491,
    D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_INSTANCING_NOT_SUPPORTED = 492,
    D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER = 493,
    D3D12_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER = 494,
    D3D12_MESSAGE_ID_COPYTILES_INVALID_PARAMETER = 495,
    D3D12_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_WARNING = 496,
    D3D12_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_ERROR = 497,
    D3D12_MESSAGE_ID_DIRTY_TILE_MAPPING_ACCESS = 498,
    D3D12_MESSAGE_ID_DUPLICATE_TILE_MAPPINGS_IN_COVERED_AREA = 499,
    D3D12_MESSAGE_ID_TILE_MAPPINGS_IN_COVERED_AREA_DUPLICATED_OUTSIDE = 500,
    D3D12_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INCOMPATIBLE_RESOURCES = 501,
    D3D12_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INPUT_AND_OUTPUT = 502,
    D3D12_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_INVALIDFLAGS = 503,
    D3D12_MESSAGE_ID_GETRESOURCETILING_NONTILED_RESOURCE = 504,
    D3D12_MESSAGE_ID_NEED_TO_CALL_TILEDRESOURCEBARRIER = 505,
    D3D12_MESSAGE_ID_CREATEDEVICE_INVALIDARGS = 506,
    D3D12_MESSAGE_ID_CREATEDEVICE_WARNING = 507,
    D3D12_MESSAGE_ID_TILED_RESOURCE_TIER_1_BUFFER_TEXTURE_MISMATCH = 508,
    D3D12_MESSAGE_ID_CREATE_CRYPTOSESSION = 509,
    D3D12_MESSAGE_ID_CREATE_AUTHENTICATEDCHANNEL = 510,
    D3D12_MESSAGE_ID_LIVE_CRYPTOSESSION = 511,
    D3D12_MESSAGE_ID_LIVE_AUTHENTICATEDCHANNEL = 512,
    D3D12_MESSAGE_ID_DESTROY_CRYPTOSESSION = 513,
    D3D12_MESSAGE_ID_DESTROY_AUTHENTICATEDCHANNEL = 514,
    D3D12_MESSAGE_ID_MAP_INVALID_SUBRESOURCE = 515,
    D3D12_MESSAGE_ID_MAP_INVALID_TYPE = 516,
    D3D12_MESSAGE_ID_MAP_UNSUPPORTED_TYPE = 517,
    D3D12_MESSAGE_ID_UNMAP_INVALID_SUBRESOURCE = 518,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_TYPE = 519,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_NULL_POINTER = 520,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SUBRESOURCE = 521,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_RESERVED_BITS = 522,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISSING_BIND_FLAGS = 523,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_MISC_FLAGS = 524,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_MATCHING_STATES = 525,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINATION = 526,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_BEFORE_AFTER_MISMATCH = 527,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_RESOURCE = 528,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_SAMPLE_COUNT = 529,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS = 530,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINED_FLAGS = 531,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS_FOR_FORMAT = 532,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SPLIT_BARRIER = 533,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_END = 534,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_BEGIN = 535,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAG = 536,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMMAND_LIST_TYPE = 537,
    D3D12_MESSAGE_ID_INVALID_SUBRESOURCE_STATE = 538,
    D3D12_MESSAGE_ID_INEFFICIENT_PRESENT = 539,
    D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CONTENTION = 540,
    D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET = 541,
    D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET_BUNDLE = 542,
    D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CANNOT_RESET = 543,
    D3D12_MESSAGE_ID_COMMAND_LIST_OPEN = 544,
    D3D12_MESSAGE_ID_QUERY_STATE_MISMATCH = 545,
    D3D12_MESSAGE_ID_INVALID_BUNDLE_API = 546,
    D3D12_MESSAGE_ID_COMMAND_LIST_CLOSED = 547,
    D3D12_MESSAGE_ID_COMMAND_LIST_CLOSED_WITH_INVALID_RESOURCE = 548,
    D3D12_MESSAGE_ID_WRONG_COMMAND_ALLOCATOR_TYPE = 549,
    D3D12_MESSAGE_ID_INVALID_INDIRECT_ARGUMENT_BUFFER = 550,
    D3D12_MESSAGE_ID_COMPUTE_AND_GRAPHICS_PIPELINE = 551,
    D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_SYNC = 552,
    D3D12_MESSAGE_ID_COMMAND_LIST_SYNC = 553,
    D3D12_MESSAGE_ID_SET_DESCRIPTOR_HEAP_INVALID = 554,
    D3D12_MESSAGE_ID_CREATE_QUEUE_IMAGE_NOT_SUPPORTED = 555,
    D3D12_MESSAGE_ID_CREATE_COMMAND_ALLOCATOR_IMAGE_NOT_SUPPORTED = 556,
    D3D12_MESSAGE_ID_CREATE_COMMANDQUEUE = 557,
    D3D12_MESSAGE_ID_CREATE_COMMANDALLOCATOR = 558,
    D3D12_MESSAGE_ID_CREATE_PIPELINESTATE = 559,
    D3D12_MESSAGE_ID_CREATE_COMMANDLIST12 = 560,
    D3D12_MESSAGE_ID_CREATE_IMAGECOMMANDLIST = 561,
    D3D12_MESSAGE_ID_CREATE_RESOURCE = 562,
    D3D12_MESSAGE_ID_CREATE_DESCRIPTORHEAP = 563,
    D3D12_MESSAGE_ID_CREATE_ROOTSIGNATURE = 564,
    D3D12_MESSAGE_ID_CREATE_LIBRARY = 565,
    D3D12_MESSAGE_ID_CREATE_HEAP = 566,
    D3D12_MESSAGE_ID_CREATE_MONITOREDFENCE = 567,
    D3D12_MESSAGE_ID_CREATE_QUERYHEAP = 568,
    D3D12_MESSAGE_ID_CREATE_COMMANDSIGNATURE = 569,
    D3D12_MESSAGE_ID_LIVE_COMMANDQUEUE = 570,
    D3D12_MESSAGE_ID_LIVE_COMMANDALLOCATOR = 571,
    D3D12_MESSAGE_ID_LIVE_PIPELINESTATE = 572,
    D3D12_MESSAGE_ID_LIVE_COMMANDLIST12 = 573,
    D3D12_MESSAGE_ID_LIVE_IMAGECOMMANDLIST = 574,
    D3D12_MESSAGE_ID_LIVE_RESOURCE = 575,
    D3D12_MESSAGE_ID_LIVE_DESCRIPTORHEAP = 576,
    D3D12_MESSAGE_ID_LIVE_ROOTSIGNATURE = 577,
    D3D12_MESSAGE_ID_LIVE_LIBRARY = 578,
    D3D12_MESSAGE_ID_LIVE_HEAP = 579,
    D3D12_MESSAGE_ID_LIVE_MONITOREDFENCE = 580,
    D3D12_MESSAGE_ID_LIVE_QUERYHEAP = 581,
    D3D12_MESSAGE_ID_LIVE_COMMANDSIGNATURE = 582,
    D3D12_MESSAGE_ID_DESTROY_COMMANDQUEUE = 583,
    D3D12_MESSAGE_ID_DESTROY_COMMANDALLOCATOR = 584,
    D3D12_MESSAGE_ID_DESTROY_PIPELINESTATE = 585,
    D3D12_MESSAGE_ID_DESTROY_COMMANDLIST12 = 586,
    D3D12_MESSAGE_ID_DESTROY_IMAGECOMMANDLIST = 587,
    D3D12_MESSAGE_ID_DESTROY_RESOURCE = 588,
    D3D12_MESSAGE_ID_DESTROY_DESCRIPTORHEAP = 589,
    D3D12_MESSAGE_ID_DESTROY_ROOTSIGNATURE = 590,
    D3D12_MESSAGE_ID_DESTROY_LIBRARY = 591,
    D3D12_MESSAGE_ID_DESTROY_HEAP = 592,
    D3D12_MESSAGE_ID_DESTROY_MONITOREDFENCE = 593,
    D3D12_MESSAGE_ID_DESTROY_QUERYHEAP = 594,
    D3D12_MESSAGE_ID_DESTROY_COMMANDSIGNATURE = 595,
    D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDHEAPTYPE = 596,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONS = 597,
    D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDMISCFLAGS = 598,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMISCFLAGS = 599,
    D3D12_MESSAGE_ID_CREATERESOURCE_LARGEALLOCATION = 600,
    D3D12_MESSAGE_ID_CREATERESOURCE_SMALLALLOCATION = 601,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDARG_RETURN = 602,
    D3D12_MESSAGE_ID_CREATERESOURCE_OUTOFMEMORY_RETURN = 603,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDESC = 604,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDINITIALSTATE = 605,
    D3D12_MESSAGE_ID_RESOURCE_HAS_PENDING_INITIAL_DATA = 606,
    D3D12_MESSAGE_ID_POSSIBLY_INVALID_SUBRESOURCE_STATE = 607,
    D3D12_MESSAGE_ID_INVALID_USE_OF_NON_RESIDENT_RESOURCE = 608,
    D3D12_MESSAGE_ID_POSSIBLE_INVALID_USE_OF_NON_RESIDENT_RESOURCE = 609,
    D3D12_MESSAGE_ID_BUNDLE_PIPELINE_STATE_MISMATCH = 610,
    D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_MISMATCH_PIPELINE_STATE = 611,
    D3D12_MESSAGE_ID_RENDER_TARGET_NUMBER_MISMATCH_PIPELINE_STATE = 612,
    D3D12_MESSAGE_ID_RENDER_TARGET_FORMAT_MISMATCH_PIPELINE_STATE = 613,
    D3D12_MESSAGE_ID_RENDER_TARGET_SAMPLE_DESC_MISMATCH_PIPELINE_STATE = 614,
    D3D12_MESSAGE_ID_DEPTH_STENCIL_FORMAT_MISMATCH_PIPELINE_STATE = 615,
    D3D12_MESSAGE_ID_DEPTH_STENCIL_SAMPLE_DESC_MISMATCH_PIPELINE_STATE = 616,
    D3D12_MESSAGE_ID_RENDER_TARGET_NUMBER_MISMATCH_BUNDLE_PIPELINE_STATE = 617,
    D3D12_MESSAGE_ID_RENDER_TARGET_FORMAT_MISMATCH_BUNDLE_PIPELINE_STATE = 618,
    D3D12_MESSAGE_ID_RENDER_TARGET_SAMPLE_DESC_MISMATCH_BUNDLE_PIPELINE_STATE = 619,
    D3D12_MESSAGE_ID_DEPTH_STENCIL_FORMAT_MISMATCH_BUNDLE_PIPELINE_STATE = 620,
    D3D12_MESSAGE_ID_DEPTH_STENCIL_SAMPLE_DESC_MISMATCH_BUNDLE_PIPELINE_STATE = 621,
    D3D12_MESSAGE_ID_CREATESHADER_INVALIDBYTECODE = 622,
    D3D12_MESSAGE_ID_CREATEHEAP_NULLDESC = 623,
    D3D12_MESSAGE_ID_CREATEHEAP_INVALIDSIZE = 624,
    D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDHEAPTYPE = 625,
    D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES = 626,
    D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMEMORYPOOL = 627,
    D3D12_MESSAGE_ID_CREATEHEAP_INVALIDPROPERTIES = 628,
    D3D12_MESSAGE_ID_CREATEHEAP_INVALIDALIGNMENT = 629,
    D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMISCFLAGS = 630,
    D3D12_MESSAGE_ID_CREATEHEAP_INVALIDMISCFLAGS = 631,
    D3D12_MESSAGE_ID_CREATEHEAP_INVALIDARG_RETURN = 632,
    D3D12_MESSAGE_ID_CREATEHEAP_OUTOFMEMORY_RETURN = 633,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAPPROPERTIES = 634,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPTYPE = 635,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES = 636,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDMEMORYPOOL = 637,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPPROPERTIES = 638,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPMISCFLAGS = 639,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPMISCFLAGS = 640,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDARG_RETURN = 641,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_OUTOFMEMORY_RETURN = 642,
    D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_UNRECOGNIZEDHEAPTYPE = 643,
    D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_INVALIDHEAPTYPE = 644,
    D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_INVALID_DESC = 645,
    D3D12_MESSAGE_ID_INVALID_DESCRIPTOR_HANDLE = 646,
    D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE = 647,
    D3D12_MESSAGE_ID_DEVICE_DRAW_INVALID_SYSTEMVALUE = 648,
    D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_RESOURCE = 649,
    D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_DESC = 650,
    D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_LARGE_OFFSET = 651,
    D3D12_MESSAGE_ID_CREATE_UNORDEREDACCESS_VIEW_INVALID_COUNTER_USAGE = 652,
    D3D12_MESSAGE_ID_COPY_DESCRIPTORS_INVALID_RANGES = 653,
    D3D12_MESSAGE_ID_COPY_DESCRIPTORS_WRITE_ONLY_DESCRIPTOR = 654,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RTV_FORMAT_NOT_UNKNOWN = 655,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_RENDER_TARGET_COUNT = 656,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VERTEX_SHADER_NOT_SET = 657,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_NOT_SET = 658,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_HS_DS_SIGNATURE_MISMATCH = 659,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERINDEX = 660,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_COMPONENTTYPE = 661,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERMASK = 662,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SYSTEMVALUE = 663,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS = 664,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_MINPRECISION = 665,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND = 666,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_XOR_DS_MISMATCH = 667,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH = 668,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_CONTROL_POINT_COUNT_MISMATCH = 669,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_TESSELLATOR_DOMAIN_MISMATCH = 670,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN = 671,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_FORCED_SAMPLE_COUNT = 672,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_PRIMITIVETOPOLOGY = 673,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SYSTEMVALUE = 674,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0
        = 675,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING = 676,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_TYPE_MISMATCH = 677,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS = 678,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDERTARGETVIEW_NOT_SET = 679,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DEPTHSTENCILVIEW_NOT_SET = 680,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_INPUT_PRIMITIVE_MISMATCH = 681,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_POSITION_NOT_PRESENT = 682,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE_FLAGS = 683,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_INDEX_BUFFER_PROPERTIES = 684,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SAMPLE_DESC = 685,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_ROOT_SIGNATURE_MISMATCH = 686,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DS_ROOT_SIGNATURE_MISMATCH = 687,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VS_ROOT_SIGNATURE_MISMATCH = 688,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_ROOT_SIGNATURE_MISMATCH = 689,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_ROOT_SIGNATURE_MISMATCH = 690,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE = 691,
    D3D12_MESSAGE_ID_EXECUTE_BUNDLE_OPEN_BUNDLE = 692,
    D3D12_MESSAGE_ID_EXECUTE_BUNDLE_DESCRIPTOR_HEAP_MISMATCH = 693,
    D3D12_MESSAGE_ID_EXECUTE_BUNDLE_TYPE = 694,
    D3D12_MESSAGE_ID_DRAW_EMPTY_SCISSOR_RECTANGLE = 695,
    D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_BLOB_NOT_FOUND = 696,
    D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_DESERIALIZE_FAILED = 697,
    D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_INVALID_CONFIGURATION = 698,
    D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_SUPPORTED_ON_DEVICE = 699,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLRESOURCEPROPERTIES = 700,
    D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAP = 701,
    D3D12_MESSAGE_ID_GETRESOURCEALLOCATIONINFO_INVALIDRDESCS = 702,
    D3D12_MESSAGE_ID_MAKERESIDENT_NULLOBJECTARRAY = 703,
    D3D12_MESSAGE_ID_MAKERESIDENT_INVALIDOBJECT = 704,
    D3D12_MESSAGE_ID_EVICT_NULLOBJECTARRAY = 705,
    D3D12_MESSAGE_ID_EVICT_INVALIDOBJECT = 706,
    D3D12_MESSAGE_ID_HEAPS_UNSUPPORTED = 707,
    D3D12_MESSAGE_ID_SET_DESCRIPTOR_TABLE_INVALID = 708,
    D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_INVALID = 709,
    D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_BUFFER_VIEW_INVALID = 710,
    D3D12_MESSAGE_ID_SET_ROOT_SHADER_RESOURCE_VIEW_INVALID = 711,
    D3D12_MESSAGE_ID_SET_ROOT_UNORDERED_ACCESS_VIEW_INVALID = 712,
    D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID_DESC = 713,
    D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_LARGE_OFFSET = 714,
    D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID_DESC = 715,
    D3D12_MESSAGE_ID_SET_INDEX_BUFFER_LARGE_OFFSET = 716,
    D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID_DESC = 717,
    D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDDIMENSIONALITY = 718,
    D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDLAYOUT = 719,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONALITY = 720,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT = 721,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMIPLEVELS = 722,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDSAMPLEDESC = 723,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDLAYOUT = 724,
    D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID = 725,
    D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID = 726,
    D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID = 727,
    D3D12_MESSAGE_ID_SET_RENDER_TARGETS_INVALID = 728,
    D3D12_MESSAGE_ID_CREATEQUERY_HEAP_INVALID_PARAMETERS = 729,
    D3D12_MESSAGE_ID_CREATEQUERY_HEAP_JPEG_NOT_SUPPORTED = 730,
    D3D12_MESSAGE_ID_BEGIN_END_QUERY_INVALID_PARAMETERS = 731,
    D3D12_MESSAGE_ID_CLOSE_COMMAND_LIST_OPEN_QUERY = 732,
    D3D12_MESSAGE_ID_RESOLVE_QUERY_DATA_INVALID_PARAMETERS = 733,
    D3D12_MESSAGE_ID_SET_PREDICATION_INVALID_PARAMETERS = 734,
    D3D12_MESSAGE_ID_TIMESTAMPS_NOT_SUPPORTED = 735,
    D3D12_MESSAGE_ID_UNSTABLE_POWER_STATE = 736,
    D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDFORMAT = 737,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDFORMAT = 738,
    D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDSUBRESOURCERANGE = 739,
    D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDBASEOFFSET = 740,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_HEAP = 741,
    D3D12_MESSAGE_ID_CREATE_SAMPLER_INVALID = 742,
    D3D12_MESSAGE_ID_CREATECOMMANDSIGNATURE_INVALID = 743,
    D3D12_MESSAGE_ID_EXECUTE_INDIRECT_INVALID_PARAMETERS = 744,
    D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_RESOURCE_DIMENSION = 745,
    D3D12_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDCONTEXTTYPE = 746,
    D3D12_MESSAGE_ID_CREATEQUERYORPREDICATE_DECODENOTSUPPORTED = 747,
    D3D12_MESSAGE_ID_CREATEQUERYORPREDICATE_ENCODENOTSUPPORTED = 748,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANEINDEX = 749,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANEINDEX = 750,
    D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_AMBIGUOUSVIDEOPLANEINDEX = 751,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANEINDEX = 752,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANEINDEX = 753,
    D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_AMBIGUOUSVIDEOPLANEINDEX = 754,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANEINDEX = 755,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANEINDEX = 756,
    D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_AMBIGUOUSVIDEOPLANEINDEX = 757,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDSCANDATAOFFSET = 758,
    D3D12_MESSAGE_ID_JPEGDECODE_NOTSUPPORTED = 759,
    D3D12_MESSAGE_ID_JPEGDECODE_DIMENSIONSTOOLARGE = 760,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDCOMPONENTS = 761,
    D3D12_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDCOMPONENTS = 762,
    D3D12_MESSAGE_ID_JPEGDECODE_DESTINATIONNOT2D = 763,
    D3D12_MESSAGE_ID_JPEGDECODE_TILEDRESOURCESUNSUPPORTED = 764,
    D3D12_MESSAGE_ID_JPEGDECODE_GUARDRECTSUNSUPPORTED = 765,
    D3D12_MESSAGE_ID_JPEGDECODE_FORMATUNSUPPORTED = 766,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDSUBRESOURCE = 767,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDMIPLEVEL = 768,
    D3D12_MESSAGE_ID_JPEGDECODE_EMPTYDESTBOX = 769,
    D3D12_MESSAGE_ID_JPEGDECODE_DESTBOXNOT2D = 770,
    D3D12_MESSAGE_ID_JPEGDECODE_DESTBOXNOTSUB = 771,
    D3D12_MESSAGE_ID_JPEGDECODE_DESTBOXESINTERSECT = 772,
    D3D12_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEMISMATCH = 773,
    D3D12_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEMISMATCH = 774,
    D3D12_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEODD = 775,
    D3D12_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEODD = 776,
    D3D12_MESSAGE_ID_JPEGDECODE_UPSCALEUNSUPPORTED = 777,
    D3D12_MESSAGE_ID_JPEGDECODE_TIER4DOWNSCALETOLARGE = 778,
    D3D12_MESSAGE_ID_JPEGDECODE_TIER3DOWNSCALEUNSUPPORTED = 779,
    D3D12_MESSAGE_ID_JPEGDECODE_CHROMASIZEMISMATCH = 780,
    D3D12_MESSAGE_ID_JPEGDECODE_LUMACHROMASIZEMISMATCH = 781,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDNUMDESTINATIONS = 782,
    D3D12_MESSAGE_ID_JPEGDECODE_SUBBOXUNSUPPORTED = 783,
    D3D12_MESSAGE_ID_JPEGDECODE_1DESTUNSUPPORTEDFORMAT = 784,
    D3D12_MESSAGE_ID_JPEGDECODE_3DESTUNSUPPORTEDFORMAT = 785,
    D3D12_MESSAGE_ID_JPEGDECODE_SCALEUNSUPPORTED = 786,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDSOURCESIZE = 787,
    D3D12_MESSAGE_ID_JPEGDECODE_INVALIDCOPYFLAGS = 788,
    D3D12_MESSAGE_ID_JPEGDECODE_HAZARD = 789,
    D3D12_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERUSAGE = 790,
    D3D12_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERMISCFLAGS = 791,
    D3D12_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDDSTTEXTUREUSAGE = 792,
    D3D12_MESSAGE_ID_JPEGDECODE_BACKBUFFERNOTSUPPORTED = 793,
    D3D12_MESSAGE_ID_JPEGDECODE_UNSUPPRTEDCOPYFLAGS = 794,
    D3D12_MESSAGE_ID_JPEGENCODE_NOTSUPPORTED = 795,
    D3D12_MESSAGE_ID_JPEGENCODE_INVALIDSCANDATAOFFSET = 796,
    D3D12_MESSAGE_ID_JPEGENCODE_INVALIDCOMPONENTS = 797,
    D3D12_MESSAGE_ID_JPEGENCODE_SOURCENOT2D = 798,
    D3D12_MESSAGE_ID_JPEGENCODE_TILEDRESOURCESUNSUPPORTED = 799,
    D3D12_MESSAGE_ID_JPEGENCODE_GUARDRECTSUNSUPPORTED = 800,
    D3D12_MESSAGE_ID_JPEGENCODE_XSUBSAMPLEMISMATCH = 801,
    D3D12_MESSAGE_ID_JPEGENCODE_YSUBSAMPLEMISMATCH = 802,
    D3D12_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDCOMPONENTS = 803,
    D3D12_MESSAGE_ID_JPEGENCODE_FORMATUNSUPPORTED = 804,
    D3D12_MESSAGE_ID_JPEGENCODE_INVALIDSUBRESOURCE = 805,
    D3D12_MESSAGE_ID_JPEGENCODE_INVALIDMIPLEVEL = 806,
    D3D12_MESSAGE_ID_JPEGENCODE_DIMENSIONSTOOLARGE = 807,
    D3D12_MESSAGE_ID_JPEGENCODE_HAZARD = 808,
    D3D12_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERUSAGE = 809,
    D3D12_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERMISCFLAGS = 810,
    D3D12_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDSRCTEXTUREUSAGE = 811,
    D3D12_MESSAGE_ID_JPEGENCODE_BACKBUFFERNOTSUPPORTED = 812,
    D3D12_MESSAGE_ID_CREATEQUERYORPREDICATE_UNSUPPORTEDCONTEXTTTYPEFORQUERY = 813,
    D3D12_MESSAGE_ID_FLUSH1_INVALIDCONTEXTTYPE = 814,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUE = 815,
    D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDCLEARVALUEFORMAT = 816,
    D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUEFORMAT = 817,
    D3D12_MESSAGE_ID_CREATERESOURCE_CLEARVALUEDENORMFLUSH = 818,
    D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALIDDEPTH = 819,
    D3D12_MESSAGE_ID_CLEARRENDERTARGETVIEW_MISMATCHINGCLEARVALUE = 820,
    D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_MISMATCHINGCLEARVALUE = 821,
    D3D12_MESSAGE_ID_MAP_INVALIDHEAP = 822,
    D3D12_MESSAGE_ID_UNMAP_INVALIDHEAP = 823,
    D3D12_MESSAGE_ID_MAP_INVALIDRESOURCE = 824,
    D3D12_MESSAGE_ID_UNMAP_INVALIDRESOURCE = 825,
    D3D12_MESSAGE_ID_MAP_INVALIDSUBRESOURCE = 826,
    D3D12_MESSAGE_ID_UNMAP_INVALIDSUBRESOURCE = 827,
    D3D12_MESSAGE_ID_MAP_INVALIDRANGE = 828,
    D3D12_MESSAGE_ID_UNMAP_INVALIDRANGE = 829,
    D3D12_MESSAGE_ID_MAP_NULLRANGE = 830,
    D3D12_MESSAGE_ID_UNMAP_NULLRANGE = 831,
    D3D12_MESSAGE_ID_MAP_INVALIDDATAPOINTER = 832,
    D3D12_MESSAGE_ID_MAP_INVALIDARG_RETURN = 833,
    D3D12_MESSAGE_ID_MAP_OUTOFMEMORY_RETURN = 834,
    D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_BUNDLENOTSUPPORTED = 835,
    D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_COMMANDLISTMISMATCH = 836,
    D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_OPENCOMMANDLIST = 837,
    D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_FAILEDCOMMANDLIST = 838,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLDST = 839,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDDSTRESOURCEDIMENSION = 840,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_DSTRANGEOUTOFBOUNDS = 841,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLSRC = 842,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDSRCRESOURCEDIMENSION = 843,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_SRCRANGEOUTOFBOUNDS = 844,
    D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDCOPYFLAGS = 845,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLDST = 846,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTTYPE = 847,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCEDIMENSION = 848,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCE = 849,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTSUBRESOURCE = 850,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTOFFSET = 851,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTFORMAT = 852,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTFORMAT = 853,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDIMENSIONS = 854,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTROWPITCH = 855,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTPLACEMENT = 856,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDSPLACEDFOOTPRINTFORMAT = 857,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_DSTREGIONOUTOFBOUNDS = 858,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLSRC = 859,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCTYPE = 860,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCEDIMENSION = 861,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCE = 862,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCSUBRESOURCE = 863,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCOFFSET = 864,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCFORMAT = 865,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCFORMAT = 866,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDIMENSIONS = 867,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCROWPITCH = 868,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCPLACEMENT = 869,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDSPLACEDFOOTPRINTFORMAT = 870,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_SRCREGIONOUTOFBOUNDS = 871,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTCOORDINATES = 872,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCBOX = 873,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_FORMATMISMATCH = 874,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_EMPTYBOX = 875,
    D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDCOPYFLAGS = 876,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SUBRESOURCE_INDEX = 877,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_FORMAT = 878,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_MISMATCH = 879,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SAMPLE_COUNT = 880,
    D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_INVALID_SHADER = 881,
    D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_CS_ROOT_SIGNATURE_MISMATCH = 882,
    D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_MISSING_ROOT_SIGNATURE = 883,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALIDCACHEDBLOB = 884,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBADAPTERMISMATCH = 885,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDRIVERVERSIONMISMATCH = 886,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDESCMISMATCH = 887,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBIGNORED = 888,
    D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDHEAP = 889,
    D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDRESOURCE = 890,
    D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDBOX = 891,
    D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDSUBRESOURCE = 892,
    D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_EMPTYBOX = 893,
    D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDHEAP = 894,
    D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDRESOURCE = 895,
    D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDBOX = 896,
    D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDSUBRESOURCE = 897,
    D3D12_MESSAGE_ID_READFROMSUBRESOURCE_EMPTYBOX = 898,
    D3D12_MESSAGE_ID_TOO_MANY_NODES_SPECIFIED = 899,
    D3D12_MESSAGE_ID_INVALID_NODE_INDEX = 900,
    D3D12_MESSAGE_ID_GETHEAPPROPERTIES_INVALIDRESOURCE = 901,
    D3D12_MESSAGE_ID_NODE_MASK_MISMATCH = 902,
    D3D12_MESSAGE_ID_COMMAND_LIST_OUTOFMEMORY = 903,
    D3D12_MESSAGE_ID_COMMAND_LIST_MULTIPLE_SWAPCHAIN_BUFFER_REFERENCES = 904,
    D3D12_MESSAGE_ID_COMMAND_LIST_TOO_MANY_SWAPCHAIN_REFERENCES = 905,
    D3D12_MESSAGE_ID_COMMAND_QUEUE_TOO_MANY_SWAPCHAIN_REFERENCES = 906,
    D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_WRONGSWAPCHAINBUFFERREFERENCE = 907,
    D3D12_MESSAGE_ID_COMMAND_LIST_SETRENDERTARGETS_INVALIDNUMRENDERTARGETS = 908,
    D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_TYPE = 909,
    D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_FLAGS = 910,
    D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFLAGS = 911,
    D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFORMAT = 912,
    D3D12_MESSAGE_ID_CREATESHAREDHEAP_INVALIDFLAGS = 913,
    D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_UNRECOGNIZEDPROPERTIES = 914,
    D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDSIZE = 915,
    D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDOBJECT = 916,
    D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDOBJECT = 917,
    D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDKEY = 918,
    D3D12_MESSAGE_ID_KEYEDMUTEX_WRONGSTATE = 919,
    D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_PRIORITY = 920,
    D3D12_MESSAGE_ID_OBJECT_DELETED_WHILE_STILL_IN_USE = 921,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_FLAGS = 922,
    D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_HAS_NO_RESOURCE = 923,
    D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RENDER_TARGET_DELETED = 924,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_ALL_RENDER_TARGETS_HAVE_UNKNOWN_FORMAT = 925,
    D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_INTERSECTS_MULTIPLE_BUFFERS = 926,
    D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_GPU_WRITTEN_READBACK_RESOURCE_MAPPED = 927,
    D3D12_MESSAGE_ID_UNMAP_RANGE_NOT_NEEDED = 928,
    D3D12_MESSAGE_ID_UNMAP_RANGE_NOT_EMPTY = 929,
    D3D12_MESSAGE_ID_MAP_INVALID_NULLRANGE = 930,
    D3D12_MESSAGE_ID_UNMAP_INVALID_NULLRANGE = 931,
    D3D12_MESSAGE_ID_NO_GRAPHICS_API_SUPPORT = 932,
    D3D12_MESSAGE_ID_NO_COMPUTE_API_SUPPORT = 933,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_FLAGS_NOT_SUPPORTED = 934,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_ARGUMENT_UNINITIALIZED = 935,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_HEAP_INDEX_OUT_OF_BOUNDS = 936,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TABLE_REGISTER_INDEX_OUT_OF_BOUNDS = 937,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_UNINITIALIZED = 938,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TYPE_MISMATCH = 939,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SRV_RESOURCE_DIMENSION_MISMATCH = 940,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UAV_RESOURCE_DIMENSION_MISMATCH = 941,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_RESOURCE_STATE = 942,
    D3D12_MESSAGE_ID_COPYRESOURCE_NULLDST = 943,
    D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDDSTRESOURCE = 944,
    D3D12_MESSAGE_ID_COPYRESOURCE_NULLSRC = 945,
    D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSRCRESOURCE = 946,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLDST = 947,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDDSTRESOURCE = 948,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLSRC = 949,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDSRCRESOURCE = 950,
    D3D12_MESSAGE_ID_PIPELINE_STATE_TYPE_MISMATCH = 951,
    D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_NOT_SET = 952,
    D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_MISMATCH = 953,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_ZERO_BARRIERS = 954,
    D3D12_MESSAGE_ID_BEGIN_END_EVENT_MISMATCH = 955,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_POSSIBLE_BEFORE_AFTER_MISMATCH = 956,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_BEGIN_END = 957,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INVALID_RESOURCE = 958,
    D3D12_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT = 959,
    D3D12_MESSAGE_ID_OBJECT_EVICTED_WHILE_STILL_IN_USE = 960,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_DESCRIPTOR_ACCESS_OUT_OF_BOUNDS = 961,
    D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_INVALIDLIBRARYBLOB = 962,
    D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_DRIVERVERSIONMISMATCH = 963,
    D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_ADAPTERVERSIONMISMATCH = 964,
    D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_UNSUPPORTED = 965,
    D3D12_MESSAGE_ID_CREATE_PIPELINELIBRARY = 966,
    D3D12_MESSAGE_ID_LIVE_PIPELINELIBRARY = 967,
    D3D12_MESSAGE_ID_DESTROY_PIPELINELIBRARY = 968,
    D3D12_MESSAGE_ID_STOREPIPELINE_NONAME = 969,
    D3D12_MESSAGE_ID_STOREPIPELINE_DUPLICATENAME = 970,
    D3D12_MESSAGE_ID_LOADPIPELINE_NAMENOTFOUND = 971,
    D3D12_MESSAGE_ID_LOADPIPELINE_INVALIDDESC = 972,
    D3D12_MESSAGE_ID_PIPELINELIBRARY_SERIALIZE_NOTENOUGHMEMORY = 973,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_RT_OUTPUT_MISMATCH = 974,
    D3D12_MESSAGE_ID_SETEVENTONMULTIPLEFENCECOMPLETION_INVALIDFLAGS = 975,
    D3D12_MESSAGE_ID_CREATE_QUEUE_VIDEO_NOT_SUPPORTED = 976,
    D3D12_MESSAGE_ID_CREATE_COMMAND_ALLOCATOR_VIDEO_NOT_SUPPORTED = 977,
    D3D12_MESSAGE_ID_CREATEQUERY_HEAP_VIDEO_DECODE_STATISTICS_NOT_SUPPORTED = 978,
    D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDLIST = 979,
    D3D12_MESSAGE_ID_CREATE_VIDEODECODER = 980,
    D3D12_MESSAGE_ID_CREATE_VIDEODECODESTREAM = 981,
    D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDLIST = 982,
    D3D12_MESSAGE_ID_LIVE_VIDEODECODER = 983,
    D3D12_MESSAGE_ID_LIVE_VIDEODECODESTREAM = 984,
    D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDLIST = 985,
    D3D12_MESSAGE_ID_DESTROY_VIDEODECODER = 986,
    D3D12_MESSAGE_ID_DESTROY_VIDEODECODESTREAM = 987,
    D3D12_MESSAGE_ID_DECODE_FRAME_INVALID_PARAMETERS = 988,
    D3D12_MESSAGE_ID_DEPRECATED_API = 989,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_COMMAND_LIST_TYPE = 990,
    D3D12_MESSAGE_ID_COMMAND_LIST_DESCRIPTOR_TABLE_NOT_SET = 991,
    D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_CONSTANT_BUFFER_VIEW_NOT_SET = 992,
    D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_SHADER_RESOURCE_VIEW_NOT_SET = 993,
    D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_UNORDERED_ACCESS_VIEW_NOT_SET = 994,
    D3D12_MESSAGE_ID_DISCARD_INVALID_SUBRESOURCE_RANGE = 995,
    D3D12_MESSAGE_ID_DISCARD_ONE_SUBRESOURCE_FOR_MIPS_WITH_RECTS = 996,
    D3D12_MESSAGE_ID_DISCARD_NO_RECTS_FOR_NON_TEXTURE2D = 997,
    D3D12_MESSAGE_ID_COPY_ON_SAME_SUBRESOURCE = 998,
    D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PAGEABLE = 999,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UNSUPPORTED = 1000,
    D3D12_MESSAGE_ID_STATIC_DESCRIPTOR_INVALID_DESCRIPTOR_CHANGE = 1001,
    D3D12_MESSAGE_ID_DATA_STATIC_DESCRIPTOR_INVALID_DATA_CHANGE = 1002,
    D3D12_MESSAGE_ID_DATA_STATIC_WHILE_SET_AT_EXECUTE_DESCRIPTOR_INVALID_DATA_CHANGE = 1003,
    D3D12_MESSAGE_ID_EXECUTE_BUNDLE_STATIC_DESCRIPTOR_DATA_STATIC_NOT_SET = 1004,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_ACCESS_OUT_OF_BOUNDS = 1005,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SAMPLER_MODE_MISMATCH = 1006,
    D3D12_MESSAGE_ID_CREATE_FENCE_INVALID_FLAGS = 1007,
    D3D12_MESSAGE_ID_RESOURCE_BARRIER_DUPLICATE_SUBRESOURCE_TRANSITIONS = 1008,
    D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PRIORITY = 1009,
    D3D12_MESSAGE_ID_CREATE_PASS = 1010,
    D3D12_MESSAGE_ID_DESTROY_PASS = 1011,
    D3D12_MESSAGE_ID_LIVE_PASS = 1012,
    D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_LARGE_NUM_DESCRIPTORS = 1013,
    D3D12_MESSAGE_ID_BEGIN_EVENT = 1014,
    D3D12_MESSAGE_ID_END_EVENT = 1015,
    D3D12_MESSAGE_ID_CREATEDEVICE_DEBUG_LAYER_STARTUP_OPTIONS = 1016,
    D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_DEPTHBOUNDSTEST_UNSUPPORTED = 1017,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_DUPLICATE_SUBOBJECT = 1018,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_UNKNOWN_SUBOBJECT = 1019,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_ZERO_SIZE_STREAM = 1020,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_STREAM = 1021,
    D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CANNOT_DEDUCE_TYPE = 1022,
    D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_RESOURCE_DIMENSION_MISMATCH = 1023,
    D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_PRIVILEGE_FOR_GLOBAL_REALTIME = 1024,
    D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_HARDWARE_SUPPORT_FOR_GLOBAL_REALTIME = 1025,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_ARCHITECTURE = 1026,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DST = 1027,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE_DIMENSION = 1028,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DST_RANGE_OUT_OF_BOUNDS = 1029,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_SRC = 1030,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE_DIMENSION = 1031,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_SRC_RANGE_OUT_OF_BOUNDS = 1032,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_OFFSET_ALIGNMENT = 1033,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_RESOURCES = 1034,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_SUBRESOURCE_RANGES = 1035,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_RESOURCE = 1036,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_SUBRESOURCE_RANGE = 1037,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_SUBRESOURCE_OUT_OF_BOUNDS = 1038,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_RANGE_OUT_OF_BOUNDS = 1039,
    D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_ZERO_DEPENDENCIES = 1040,
    D3D12_MESSAGE_ID_DEVICE_CREATE_SHARED_HANDLE_INVALIDARG = 1041,
    D3D12_MESSAGE_ID_DESCRIPTOR_HANDLE_WITH_INVALID_RESOURCE = 1042,
    D3D12_MESSAGE_ID_SETDEPTHBOUNDS_INVALIDARGS = 1043,
    D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_STATE_IMPRECISE = 1044,
    D3D12_MESSAGE_ID_COMMAND_LIST_PIPELINE_STATE_NOT_SET = 1045,
    D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_MODEL_MISMATCH = 1046,
    D3D12_MESSAGE_ID_OBJECT_ACCESSED_WHILE_STILL_IN_USE = 1047,
    D3D12_MESSAGE_ID_PROGRAMMABLE_MSAA_UNSUPPORTED = 1048,
    D3D12_MESSAGE_ID_SETSAMPLEPOSITIONS_INVALIDARGS = 1049,
    D3D12_MESSAGE_ID_RESOLVESUBRESOURCEREGION_INVALID_RECT = 1050,
    D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDQUEUE = 1051,
    D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDLIST = 1052,
    D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDQUEUE = 1053,
    D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDQUEUE = 1054,
    D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDLIST = 1055,
    D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDQUEUE = 1056,
    D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDQUEUE = 1057,
    D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDLIST = 1058,
    D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDQUEUE = 1059,
    D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSOR = 1060,
    D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSSTREAM = 1061,
    D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSOR = 1062,
    D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSSTREAM = 1063,
    D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSOR = 1064,
    D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSSTREAM = 1065,
    D3D12_MESSAGE_ID_PROCESS_FRAME_INVALID_PARAMETERS = 1066,
    D3D12_MESSAGE_ID_COPY_INVALIDLAYOUT = 1067,
    D3D12_MESSAGE_ID_D3D12_MESSAGES_END = 1068,
}}
STRUCT!{struct D3D12_MESSAGE {
    Category: D3D12_MESSAGE_CATEGORY,
    Severity: D3D12_MESSAGE_SEVERITY,
    ID: D3D12_MESSAGE_ID,
    pDescription: *const c_char,
    DescriptionByteLength: SIZE_T,
}}
STRUCT!{struct D3D12_INFO_QUEUE_FILTER_DESC {
    NumCategories: UINT,
    pCategoryList: *mut D3D12_MESSAGE_CATEGORY,
    NumSeverities: UINT,
    pSeverityList: *mut D3D12_MESSAGE_SEVERITY,
    NumIDs: UINT,
    pIDList: *mut D3D12_MESSAGE_ID,
}}
STRUCT!{struct D3D12_INFO_QUEUE_FILTER {
    AllowList: D3D12_INFO_QUEUE_FILTER_DESC,
    DenyList: D3D12_INFO_QUEUE_FILTER_DESC,
}}
pub const D3D12_INFO_QUEUE_DEFAULT_MESSAGE_COUNT_LIMIT: UINT = 1024;
RIDL!{#[uuid(0x0742a90b, 0xc387, 0x483f, 0xb9, 0x46, 0x30, 0xa7, 0xe4, 0xe6, 0x14, 0x58)]
interface ID3D12InfoQueue(ID3D12InfoQueueVtbl): IUnknown(IUnknownVtbl) {
    fn SetMessageCountLimit(
        MessageCountLimit: UINT64,
    ) -> HRESULT,
    fn ClearStoredMessages() -> (),
    fn GetMessage(
        MessageIndex: UINT64,
        pMessage: *mut D3D12_MESSAGE,
        pMessageByteLength: *mut SIZE_T,
    ) -> HRESULT,
    fn GetNumMessagesAllowedByStorageFilter() -> UINT64,
    fn GetNumMessagesDeniedByStorageFilter() -> UINT64,
    fn GetNumStoredMessages() -> UINT64,
    fn GetNumStoredMessagesAllowedByRetrievalFilter() -> UINT64,
    fn GetNumMessagesDiscardedByMessageCountLimit() -> UINT64,
    fn GetMessageCountLimit() -> UINT64,
    fn AddStorageFilterEntries(
        pFilter: *mut D3D12_INFO_QUEUE_FILTER,
    ) -> HRESULT,
    fn GetStorageFilter(
        pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        pFilterByteLength: *mut SIZE_T,
    ) -> HRESULT,
    fn ClearStorageFilter() -> (),
    fn PushEmptyStorageFilter() -> HRESULT,
    fn PushCopyOfStorageFilter() -> HRESULT,
    fn PushStorageFilter(
        pFilter: *mut D3D12_INFO_QUEUE_FILTER,
    ) -> HRESULT,
    fn PopStorageFilter() -> (),
    fn GetStorageFilterStackSize() -> UINT,
    fn AddRetrievalFilterEntries(
        pFilter: *mut D3D12_INFO_QUEUE_FILTER,
    ) -> HRESULT,
    fn GetRetrievalFilter(
        pFilter: *mut D3D12_INFO_QUEUE_FILTER,
        pFilterByteLength: *mut SIZE_T,
    ) -> HRESULT,
    fn ClearRetrievalFilter() -> (),
    fn PushEmptyRetrievalFilter() -> HRESULT,
    fn PushCopyOfRetrievalFilter() -> HRESULT,
    fn PushRetrievalFilter(
        pFilter: *mut D3D12_INFO_QUEUE_FILTER,
    ) -> HRESULT,
    fn PopRetrievalFilter() -> (),
    fn GetRetrievalFilterStackSize() -> UINT,
    fn AddMessage(
        Category: D3D12_MESSAGE_CATEGORY,
        Severity: D3D12_MESSAGE_SEVERITY,
        ID: D3D12_MESSAGE_ID,
        pDescription: LPCSTR,
    ) -> HRESULT,
    fn AddApplicationMessage(
        Severity: D3D12_MESSAGE_SEVERITY,
        pDescription: LPCSTR,
    ) -> HRESULT,
    fn SetBreakOnCategory(
        Category: D3D12_MESSAGE_CATEGORY,
        bEnable: BOOL,
    ) -> HRESULT,
    fn SetBreakOnSeverity(
        Severity: D3D12_MESSAGE_SEVERITY,
        bEnable: BOOL,
    ) -> HRESULT,
    fn SetBreakOnID(
        ID: D3D12_MESSAGE_ID,
        bEnable: BOOL,
    ) -> HRESULT,
    fn GetBreakOnCategory(
        Category: D3D12_MESSAGE_CATEGORY,
    ) -> BOOL,
    fn GetBreakOnSeverity(
        Severity: D3D12_MESSAGE_SEVERITY,
    ) -> BOOL,
    fn GetBreakOnID(
        ID: D3D12_MESSAGE_ID,
    ) -> BOOL,
    fn SetMuteDebugOutput(
        bMute: BOOL,
    ) -> (),
    fn GetMuteDebugOutput() -> BOOL,
}}
DEFINE_GUID!{IID_ID3D12Debug,
    0x344488b7, 0x6846, 0x474b, 0xb9, 0x89, 0xf0, 0x27, 0x44, 0x82, 0x45, 0xe0}
DEFINE_GUID!{IID_ID3D12Debug1,
    0xaffaa4ca, 0x63fe, 0x4d8e, 0xb8, 0xad, 0x15, 0x90, 0x00, 0xaf, 0x43, 0x04}
DEFINE_GUID!{IID_ID3D12Debug2,
    0x93a665c4, 0xa3b2, 0x4e5d, 0xb6, 0x92, 0xa2, 0x6a, 0xe1, 0x4e, 0x33, 0x74}
DEFINE_GUID!{IID_ID3D12DebugDevice1,
    0xa9b71770, 0xd099, 0x4a65, 0xa6, 0x98, 0x3d, 0xee, 0x10, 0x02, 0x0f, 0x88}
DEFINE_GUID!{IID_ID3D12DebugDevice,
    0x3febd6dd, 0x4973, 0x4787, 0x81, 0x94, 0xe4, 0x5f, 0x9e, 0x28, 0x92, 0x3e}
DEFINE_GUID!{IID_ID3D12DebugCommandQueue,
    0x09e0bf36, 0x54ac, 0x484f, 0x88, 0x47, 0x4b, 0xae, 0xea, 0xb6, 0x05, 0x3a}
DEFINE_GUID!{IID_ID3D12DebugCommandList1,
    0x102ca951, 0x311b, 0x4b01, 0xb1, 0x1f, 0xec, 0xb8, 0x3e, 0x06, 0x1b, 0x37}
DEFINE_GUID!{IID_ID3D12DebugCommandList,
    0x09e0bf36, 0x54ac, 0x484f, 0x88, 0x47, 0x4b, 0xae, 0xea, 0xb6, 0x05, 0x3f}
DEFINE_GUID!{IID_ID3D12InfoQueue,
    0x0742a90b, 0xc387, 0x483f, 0xb9, 0x46, 0x30, 0xa7, 0xe4, 0xe6, 0x14, 0x58}
