% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{permutations}
\alias{permutations}
\title{Permutation sampling}
\usage{
permutations(data, permute = NULL, times = 25, apparent = FALSE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{permute}{One or more columns to shuffle. This argument supports
\code{tidyselect} selectors. Multiple expressions can be combined with \code{c()}.
Variable names can be used as if they were positions in the data frame, so
expressions like \code{x:y} can be used to select a range of variables.
See \code{\link[tidyselect]{language}} for more details.}

\item{times}{The number of permutation samples.}

\item{apparent}{A logical. Should an extra resample be added where the
analysis is the standard data set.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A \code{tibble} with classes \code{permutations}, \code{rset}, \code{tbl_df}, \code{tbl}, and
\code{data.frame}. The results include a column for the data split objects and a
column called \code{id} that has a character string with the resample
identifier.
}
\description{
A permutation sample is the same size as the original data set and is made
by permuting/shuffling one or more columns. This results in analysis
samples where some columns are in their original order and some columns
are permuted to a random order. Unlike other sampling functions in
\code{rsample}, there is no assessment set and calling \code{assessment()} on a
permutation split will throw an error.
}
\details{
The argument \code{apparent} enables the option of an additional
"resample" where the analysis data set is the same as the original data
set. Permutation-based resampling can be especially helpful for computing
a statistic under the null hypothesis (e.g. t-statistic). This forms the
basis of a permutation test, which computes a test statistic under all
possible permutations of the data.
}
\examples{
permutations(mtcars, mpg, times = 2)
permutations(mtcars, mpg, times = 2, apparent = TRUE)

library(purrr)
resample1 <- permutations(mtcars, starts_with("c"), times = 1)
resample1$splits[[1]] \%>\% analysis()

resample2 <- permutations(mtcars, hp, times = 10, apparent = TRUE)
map_dbl(resample2$splits, function(x) {
  t.test(hp ~ vs, data = analysis(x))$statistic
})
}
