% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicore.R
\name{multicore}
\alias{multicore}
\title{Create a multicore future whose value will be resolved asynchronously in a forked parallel process}
\usage{
multicore(
  ...,
  workers = availableCores(constraints = "multicore"),
  envir = parent.frame()
)
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[=Future]{Future()}}.}

\item{workers}{Ignored in \strong{future} (>= 1.31.0).}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{MulticoreFuture}.
If \code{workers == 1}, then all processing using done in the
current/main \R session and we therefore fall back to using a
sequential future. To override this fallback, use \code{workers = I(1)}.
This is also the case whenever multicore processing is not supported,
e.g. on Windows.
}
\description{
A multicore future is a future that uses multicore evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function is \emph{not} meant to be called directly.  Instead, the
typical usages are:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Evaluate futures in parallel on the local machine via as many forked
# processes as available to the current R process
plan(multicore)

# Evaluate futures in parallel on the local machine via two forked processes
plan(multicore, workers = 2)
}\if{html}{\out{</div>}}
}
\section{Support for forked ("multicore") processing}{

Not all operating systems support process forking and thereby not multicore
futures.  For instance, forking is not supported on Microsoft Windows.
Moreover, process forking may break some R environments such as RStudio.
Because of this, the future package disables process forking also in
such cases.  See \code{\link[parallelly:supportsMulticore]{parallelly::supportsMulticore()}} for details.
Trying to create multicore futures on non-supported systems or when
forking is disabled will result in multicore futures falling back to
becoming \link{sequential} futures.  If used in RStudio, there will be an
informative warning:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{> plan(multicore)
Warning message:
In supportsMulticoreAndRStudio(...) :
  [ONE-TIME WARNING] Forked processing ('multicore') is not supported when
running R from RStudio because it is considered unstable. For more details,
how to control forked processing or not, and how to silence this warning in
future R sessions, see ?parallelly::supportsMulticore
}\if{html}{\out{</div>}}
}

\examples{
## Use multicore futures
plan(multicore)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multicore future is evaluated in a separate forked
## process.  Changing the value of a global variable
## will not affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
\seealso{
For processing in multiple background \R sessions, see
\link{multisession} futures.

Use \code{\link[parallelly:availableCores]{parallelly::availableCores()}} to see the total number of
cores that are available for the current \R session.
Use \code{\link[parallelly:availableCores]{availableCores}("multicore") > 1L} to check
whether multicore futures are supported or not on the current
system.
}
