% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential.R
\name{sequential}
\alias{sequential}
\alias{uniprocess}
\alias{transparent}
\title{Create a sequential future whose value will be in the current \R session}
\usage{
sequential(..., envir = parent.frame())

transparent(..., envir = parent.frame())
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[=Future]{Future()}}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{SequentialFuture}.
}
\description{
A sequential future is a future that is evaluated sequentially in the
current \R session similarly to how \R expressions are evaluated in \R.
The only difference to \R itself is that globals are validated
by default just as for all other types of futures in this package.
}
\details{
The preferred way to create a sequential future is not to call these functions
directly, but to register them via \code{\link{plan}(sequential)} such that
it becomes the default mechanism for all futures.  After this
\code{\link[=future]{future()}} and \code{\link{\%<-\%}} will create
\emph{sequential futures}.
}
\section{transparent futures}{

Transparent futures are sequential futures configured to emulate how R
evaluates expressions as far as possible.  For instance, errors and
warnings are signaled immediately and assignments are done to the
calling environment (without \code{local()} as default for all other
types of futures).  This makes transparent futures ideal for
troubleshooting, especially when there are errors.
}

\examples{
## Use sequential futures
plan(sequential)

## A global variable
a <- 0

## Create a sequential future
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## Since 'a' is a global variable in future 'f' which
## is eagerly resolved (default), this global has already
## been resolved / incorporated, and any changes to 'a'
## at this point will _not_ affect the value of 'f'.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
