% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_net}
\alias{plot_net}
\title{Microbiome Network Plot using ggplot2}
\usage{
plot_net(physeq, distance = "bray", type = "samples", maxdist = 0.7,
  laymeth = "fruchterman.reingold", color = NULL, shape = NULL,
  rescale = FALSE, point_size = 5, point_alpha = 1,
  point_label = NULL, hjust = 1.35, title = NULL)
}
\arguments{
\item{physeq}{(Required). 
The \code{\link{phyloseq-class}} object that you want to represent as a network.}

\item{distance}{(Optional). Default is \code{"bray"}. 
Can be either a distance method supported by \code{\link[phyloseq]{distance}},
or an already-computed \code{\link{dist}}-class with labels that match
the indices implied by both the \code{physeq} and \code{type} arguments
(that is, either sample or taxa names).
If you used \code{\link[phyloseq]{distance}} to pre-calculate your \code{\link{dist}}ance,
and the same \code{type} argument as provided here, then they will match.}

\item{type}{(Optional). Default \code{"samples"}.
Whether the network represented in the primary argument, \code{g},
is samples or taxa/OTUs.
Supported arguments are \code{"samples"}, \code{"taxa"},
where \code{"taxa"} indicates using the taxa indices,
whether they actually represent species or some other taxonomic rank.}

\item{maxdist}{(Optional). Default \code{0.7}. 
The maximum distance value between two vertices
to connect with an edge in the graphic.}

\item{laymeth}{(Optional). Default \code{"fruchterman.reingold"}.
A character string that indicates the method that will determine
the placement of vertices, typically based on conectedness of vertices
and the number of vertices.
This is an interesting topic, and there are lots of options.
See \code{\link{igraph-package}} for related topics in general, 
and see \code{\link[igraph]{layout.auto}} for descriptions of various
alternative layout method options supported here.
The character string argument should match exactly the
layout function name with the \code{"layout."} omitted.
Try \code{laymeth="list"} to see a list of options.}

\item{color}{(Optional). Default \code{NULL}.
The name of the sample variable in \code{physeq} to use for color mapping
of points (graph vertices).}

\item{shape}{(Optional). Default \code{NULL}.
The name of the sample variable in \code{physeq} to use for shape mapping.
of points (graph vertices).}

\item{rescale}{(Optional). Logical. Default \code{FALSE}.
Whether to rescale the distance values to be \code{[0, 1]}, in which the
min value is close to zero and the max value is 1.}

\item{point_size}{(Optional). Default \code{5}. 
The size of the vertex points.}

\item{point_alpha}{(Optional). Default \code{1}.
A value between 0 and 1 for the alpha transparency of the vertex points.}

\item{point_label}{(Optional). Default \code{NULL}.
The variable name in \code{physeq} covariate data to map to vertex labels.}

\item{hjust}{(Optional). Default \code{1.35}.
The amount of horizontal justification to use for each label.}

\item{title}{(Optional). Default \code{NULL}. Character string.
The main title for the graphic.}
}
\value{
A \code{\link{ggplot}}2 network plot.
 Will render to default graphic device automatically as print side effect.
 Can also be saved, further manipulated, or rendered to
 a vector or raster file using \code{\link{ggsave}}.
}
\description{
There are many useful examples of phyloseq network graphics in the
\href{http://joey711.github.io/phyloseq/plot_net-examples}{phyloseq online tutorials}.
A custom plotting function for displaying networks
using advanced \code{\link[ggplot2]{ggplot}}2 formatting.
Note that this function is a performance and interface revision to
\code{\link{plot_network}}, which requires an \code{\link[igraph]{igraph}}
object as its first argument.
This new function is more in-line with other
\code{plot_*} functions in the \code{\link{phyloseq-package}}, in that its
first/main argument is a \code{\link{phyloseq-class}} instance.
Edges in the network are created if the distance between
nodes is below a (potentially arbitrary) threshold,
and special care should be given to considering the choice of this threshold.
However, network line thickness and opacity is scaled according to the
similarity of vertices (either samples or taxa),
helping to temper, somewhat, the effect of the threshold.
Also note that the choice of network layout algorithm can have a large effect
on the impression and interpretability of the network graphic,
and you may want to familiarize yourself with some of these options
(see the \code{laymeth} argument).
}
\examples{
data(enterotype)
plot_net(enterotype, color="SeqTech", maxdist = 0.3)
plot_net(enterotype, color="SeqTech", maxdist = 0.3, laymeth = "auto")
plot_net(enterotype, color="SeqTech", maxdist = 0.3, laymeth = "svd")
plot_net(enterotype, color="SeqTech", maxdist = 0.3, laymeth = "circle")
plot_net(enterotype, color="SeqTech", shape="Enterotype", maxdist = 0.3, laymeth = "circle")
}
\seealso{
Original network plotting functions:

 \code{\link{make_network}}

 \code{\link{plot_network}}
}
