% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackgroundSubtractionFunctions.R
\docType{methods}
\name{subtractBackground,RccSet-method}
\alias{subtractBackground,RccSet-method}
\alias{subtractBackground}
\title{Subtract background estimates for a NanoString RccSet}
\usage{
\S4method{subtractBackground}{RccSet}(rccSet, bgEstimates,
  bgEstimatesParams = list(), inputMatrix = c("posCtrlData", "exprs"),
  quietly = FALSE)
}
\arguments{
\item{rccSet}{NanoString RccSet object}

\item{bgEstimates}{Matrix containing the background estimates to subtract.}

\item{bgEstimatesParams}{A list with the parameters that were used to generate the background
estimates (see getBackground()):

\itemize{
  \item bgReference
  \item summaryFunction
  \item stringency
  \item nSolverBackground.w1
  \item nSolverBackground.shrink
  \item inputMatrix
}

The values of these list elements will be assigned to corresponding elements
in the output's experimentData@preprocessing list. If any element is NULL,
the corresponding element in the output's preprocessing list will be NA.}

\item{inputMatrix}{Name of the matrix in the RccSet's assayData to use as input for subtracting
background estimates (one of "exprs" or "posCtrlData"). If posCtrlData is
specified but not found in the assayData, an error will be generated.}

\item{quietly}{Boolean specifying whether or not messages and warnings should be omitted.}
}
\value{
A NanoString \code{linkS4class{RccSet}} object with background estimates
subtracted from the count data.
}
\description{
Returns a NanoString \code{\linkS4class{RccSet}} with background-corrected
count data. During subtraction, any counts below 1 will be truncated to 1 to
enable subsequent log transformation of the data.
}
\examples{

data(example_rccSet)

pcnorm_rccSet <- posCtrlNorm(example_rccSet)

bg1 <- getBackground(pcnorm_rccSet, bgReference="negatives", summaryFunction="mean")
bg2 <- getBackground(pcnorm_rccSet, bgReference="blanks")
bg3 <- getBackground(pcnorm_rccSet, bgReference="both", stringency=1)

bgCor1 <- subtractBackground(pcnorm_rccSet, bgEstimates=bg1)
bgCor2 <- subtractBackground(pcnorm_rccSet, bgEstimates=bg2)
bgCor3 <- subtractBackground(pcnorm_rccSet, bgEstimates=bg3)

}
\seealso{
\code{\link{getBackground}}
}
\author{
Dorothee Nickles
}
