-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2015 Statoil

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 09 Jan 07  14:25
--           Input File : C:\GAP\B2H.OUT
--          Output File : Z:\res\sim\ior\linn\gap\B2H.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : Tubing
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : Full System
--
--           Completion : Cased Hole
--          Gravel Pack : No
--
--          Inflow Type : Single Branch
--           Gas Coning : No
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : B-2H
--             Platform : Treasure Prospect
--              Analyst : Arild Stokkenes
--                 Date : 30 May 06  10:55
--
--
--
--  Surface Equipment Correlation :  GRE (modified by PE)
--      Vertical Lift Correlation :  Petroleum Experts 2
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1            Xmas Tree      392.3 (m)
--                      Last Node :   20               Tubing       3000 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
--    38       2654.25       'LIQ'      'WCT'      'GOR'            /

-- Prosper files are corrected from RKB to MSL depth. Correlations are not matched due to no BHP gauge in well. lmarr       

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
      38       2629.25       'LIQ'      'WCT'      'GOR'            /



-- 'LIQ' units - SM3/DAY
  200.0   500.0  1000.0  1500.0  2000.0 
 2500.0  3000.0  3500.0  4000.0  4500.0 
 5000.0  5500.0  6000.0  6500.0  7000.0 
 7500.0  8000.0 10000.0 14000.0 /

-- 'THP' units - BARSA
  21.01   51.01   61.01   81.01  101.01 
 121.01  141.01  161.01  181.01  201.01 /

-- 'WCT' units - FRACTION
      0     0.1     0.2     0.3     0.4 
    0.5     0.6     0.7     0.8       1 /

-- 'GOR' units - SM3/SM3
     90     100     150     200     300 
    500    1000    2000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1  128.86  103.23  102.30  105.04  109.01 
             113.75  118.96  124.71  130.84  137.10 
             143.83  150.52  157.70  165.11  172.21 
             179.39  187.12  217.22  281.52 
/
 1  1  2  1  114.60   94.44   94.91   98.34  102.84 
             107.90  113.54  119.61  126.06  132.63 
             139.64  146.93  154.45  161.80  169.67 
             177.27  185.45  217.82  284.85 
/
 1  1  3  1   71.33   70.76   75.39   80.74   86.57 
              92.82   99.50  106.58  114.00  121.89 
             129.97  138.54  147.17  156.02  165.07 
             174.32  183.73  222.37  303.25 
/
 1  1  4  1   60.33   63.26   68.98   75.09   81.44 
              88.14   95.25  102.77  110.86  119.68 
             128.73  138.13  147.68  157.70  167.70 
             178.28  188.73  232.24  324.45 
/
 1  1  5  1   54.61   59.29   65.48   72.26   79.60 
              87.46   95.83  104.69  114.01  123.75 
             133.91  144.46  155.37  167.59  179.95 
             192.44  205.35  257.51  368.99 
/
 1  1  6  1   48.97   55.60   63.38   71.61   81.04 
              91.45  102.66  114.57  127.09  140.18 
             153.80  167.92  182.51  197.40  212.47 
             227.88  243.75  314.39  466.42 
/
 1  1  7  1   42.60   50.69   65.18   80.49   97.51 
             113.99  133.09  153.08  172.50  193.95 
             216.13  239.03  262.69  287.13  312.37 
             335.99  363.91  478.78  741.32 
/
 1  1  8  1   36.37   53.58   85.93  116.06  145.78 
             177.31  210.21  246.65  283.54  321.12 
             362.61  404.57  449.84  497.17  545.09 
             596.33  649.28  886.44 1440.39 
/
 1  2  1  1  142.11  112.64  110.61  112.70  116.24 
             120.69  125.61  130.96  136.82  143.04 
             149.29  156.05  162.69  169.81  176.67 
             183.60  191.13  220.56  284.06 
/
 1  2  2  1  129.40  103.00  102.39  105.28  109.37 
             114.14  119.54  125.40  131.47  138.01 
             144.86  151.67  158.98  166.11  173.79 
             181.17  189.11  220.02  285.74 
/
 1  2  3  1   77.71   75.54   79.48   84.64   90.30 
              96.42  102.96  109.88  117.30  124.94 
             132.87  141.08  149.52  158.51  167.04 
             176.09  185.31  223.20  301.62 
/
 1  2  4  1   63.28   65.69   71.08   77.07   83.34 
              89.96   96.98  104.57  112.75  121.28 
             130.09  139.33  148.63  158.47  168.28 
             178.29  188.48  231.02  320.26 
/
 1  2  5  1   55.55   60.27   66.50   73.20   80.36 
              87.98   96.07  104.62  113.61  123.04 
             132.88  143.10  154.35  166.10  177.89 
             189.84  202.17  252.68  360.95 
/
 1  2  6  1   49.88   56.51   64.02   71.90   80.90 
              90.79  101.43  112.72  124.60  137.02 
             149.96  163.37  177.15  191.25  205.69 
             220.35  236.07  303.15  446.80 
/
 1  2  7  1   43.28   51.20   64.08   78.24   93.13 
             109.70  127.40  144.89  164.12  184.07 
             204.70  225.98  247.94  270.45  293.44 
             317.37  340.03  442.35  686.46 
/
 1  2  8  1   38.03   51.82   81.29  108.53  135.99 
             165.22  195.14  228.27  259.64  295.59 
             332.86  370.63  411.26  452.60  496.19 
             542.01  589.34  799.29 1289.46 
/
 1  3  1  1  154.28  123.40  120.53  121.87  124.88 
             128.79  133.41  138.41  143.97  149.66 
             155.59  162.00  168.28  175.10  181.66 
             188.33  195.62  224.25  285.54 
/
 1  3  2  1  143.71  113.57  111.53  113.71  117.32 
             121.70  126.76  132.17  138.08  144.14 
             150.68  157.51  164.23  171.11  178.48 
             185.55  193.22  223.25  287.90 
/
 1  3  3  1   90.20   82.02   84.98   89.77   95.17 
             101.09  107.45  114.23  121.35  128.81 
             136.56  144.57  152.82  161.29  169.96 
             178.82  187.38  224.38  301.14 
/
 1  3  4  1   68.12   69.20   74.14   79.93   86.07 
              92.58   99.74  107.29  115.17  123.51 
             132.01  141.03  150.12  159.44  169.33 
             179.11  189.08  230.06  317.18 
/
 1  3  5  1   57.03   61.40   67.66   74.28   81.27 
              88.65   96.49  104.78  113.51  122.66 
             132.21  142.68  153.66  164.74  176.01 
             187.66  199.22  248.00  351.90 
/
 1  3  6  1   50.95   57.53   64.76   72.34   80.92 
              90.31  100.38  111.06  122.30  134.05 
             146.30  158.95  171.94  185.27  198.95 
             212.96  228.71  292.02  427.31 
/
 1  3  7  1   44.10   51.87   63.67   76.17   89.87 
             104.90  121.07  138.10  155.87  174.31 
             193.21  212.76  232.90  252.81  273.70 
             294.89  317.00  411.97  636.07 
/
 1  3  8  1   39.66   50.40   76.91  102.12  127.05 
             153.50  180.27  210.39  238.58  270.93 
             303.98  338.01  374.19  411.21  449.45 
             490.09  531.99  715.68 1149.27 
/
 1  4  1  1  169.13  136.37  132.16  132.86  135.14 
             138.49  142.64  147.18  152.09  157.54 
             163.03  168.75  175.02  181.10  187.32 
             193.67  200.68  228.35  288.33 
/
 1  4  2  1  159.31  125.76  122.79  124.09  126.99 
             130.97  135.47  140.43  145.96  151.64 
             157.84  164.03  170.35  177.22  183.83 
             190.57  197.92  226.91  289.03 
/
 1  4  3  1  108.12   90.92   92.46   96.63  101.68 
             107.31  113.41  119.93  126.82  134.03 
             141.33  149.07  157.05  165.26  173.28 
             181.83  190.59  225.98  299.71 
/
 1  4  4  1   75.65   74.41   78.63   84.23   90.29 
              96.74  103.61  110.96  118.57  126.53 
             134.98  143.54  152.36  161.40  170.66 
             180.12  189.76  229.46  314.17 
/
 1  4  5  1   59.56   63.30   69.30   75.83   82.67 
              89.89   97.52  105.58  114.04  122.90 
             132.85  142.88  153.21  163.92  174.58 
             185.84  196.98  244.11  343.71 
/
 1  4  6  1   52.29   58.75   65.72   73.07   81.25 
              90.13   99.61  109.66  120.24  131.31 
             142.80  154.66  166.91  179.51  192.45 
             206.73  221.32  280.99  408.90 
/
 1  4  7  1   45.14   52.85   63.85   74.91   87.10 
             100.59  115.18  130.66  146.88  163.75 
             181.13  199.03  217.50  236.54  256.10 
             275.95  296.18  382.73  586.02 
/
 1  4  8  1   39.83   49.60   72.79   95.28  117.12 
             140.70  166.07  192.06  218.18  247.09 
             276.31  306.03  337.87  370.42  404.83 
             440.54  477.36  635.42 1018.49 
/
 1  5  1  1  182.82  150.66  145.25  145.49  147.28 
             149.99  153.38  157.30  161.65  166.35 
             171.31  176.88  182.33  187.95  193.80 
             199.75  206.41  232.13  290.15 
/
 1  5  2  1  173.88  140.33  136.06  136.64  138.83 
             142.03  145.92  150.35  155.37  160.53 
             165.95  171.92  177.80  183.83  190.03 
             196.88  203.36  231.10  291.51 
/
 1  5  3  1  128.66  102.95  102.79  106.06  110.54 
             115.61  121.29  127.42  133.77  140.60 
             147.74  154.88  162.50  170.36  178.02 
             186.26  194.18  228.25  299.52 
/
 1  5  4  1   89.41   82.52   85.65   90.74   96.40 
             102.53  109.09  116.06  123.38  131.03 
             139.19  147.45  155.97  164.71  173.29 
             182.40  191.70  229.40  311.30 
/
 1  5  5  1   63.78   66.64   72.27   78.58   85.23 
              92.24   99.63  107.41  115.97  124.90 
             134.15  143.64  153.58  163.56  174.11 
             184.59  195.27  239.94  335.39 
/
 1  5  6  1   53.99   60.23   67.02   74.19   81.98 
              90.34   99.24  108.65  118.53  128.85 
             139.59  150.75  162.28  174.15  187.47 
             200.82  214.31  270.65  390.50 
/
 1  5  7  1   46.46   54.23   64.41   74.39   85.39 
              97.61  110.83  124.86  139.59  154.95 
             170.89  187.33  204.19  221.56  239.29 
             257.36  275.80  354.65  538.44 
/
 1  5  8  1   40.40   49.67   69.38   89.01  109.04 
             129.46  151.80  173.81  198.34  223.83 
             248.66  275.88  304.00  332.31  362.32 
             393.37  425.40  561.99  891.96 
/
 1  6  1  1  195.07  165.71  159.68  159.45  160.74 
             162.90  165.71  169.01  172.73  176.84 
             181.22  185.87  190.82  195.93  201.29 
             207.32  213.00  237.28  293.37 
/
 1  6  2  1  188.67  156.70  150.92  151.16  152.72 
             155.24  158.40  162.06  166.39  170.90 
             175.71  180.80  186.09  192.07  197.78 
             203.65  209.72  235.95  293.13 
/
 1  6  3  1  152.37  118.76  116.77  118.79  122.34 
             126.81  131.76  137.31  143.11  149.44 
             155.83  162.75  169.59  177.00  184.19 
             191.51  199.50  231.24  299.63 
/
 1  6  4  1  114.72   94.72   96.10  100.24  105.24 
             110.85  116.96  123.49  130.41  137.66 
             145.22  152.80  160.86  169.15  177.67 
             185.94  194.82  230.87  307.57 
/
 1  6  5  1   71.82   72.44   77.39   83.33   89.67 
              96.45  103.74  111.43  119.48  127.92 
             136.60  145.78  155.06  164.58  174.67 
             184.68  194.89  237.03  327.22 
/
 1  6  6  1   56.29   62.04   68.75   75.74   83.15 
              91.00   99.31  108.10  117.34  127.01 
             137.10  147.57  158.88  170.86  182.98 
             195.21  207.75  260.27  372.10 
/
 1  6  7  1   48.18   56.12   65.32   74.27   84.17 
              95.17  107.04  119.64  132.88  146.71 
             161.09  175.97  191.35  207.02  222.95 
             239.23  255.86  328.44  492.96 
/
 1  6  8  1   41.79   51.03   66.51   83.01  100.45 
             118.80  137.27  157.95  178.31  200.32 
             223.24  246.89  271.31  296.51  322.49 
             348.55  376.06  492.12  767.22 
/
 1  7  1  1  208.85  181.38  175.13  174.60  175.47 
             177.14  179.38  182.13  185.30  188.77 
             192.61  196.69  201.07  205.64  210.47 
             215.46  220.69  243.23  296.28 
/
 1  7  2  1  203.58  174.20  167.69  167.28  168.38 
             170.31  172.85  175.89  179.32  183.16 
             187.27  191.72  196.38  201.31  206.41 
             211.76  217.24  241.69  296.26 
/
 1  7  3  1  175.57  138.20  135.16  135.95  138.33 
             141.70  145.89  150.50  155.53  160.90 
             166.82  172.77  178.94  185.72  192.30 
             199.04  206.48  235.24  300.23 
/
 1  7  4  1  144.82  112.97  111.76  114.39  118.44 
             123.20  128.60  134.35  140.62  147.06 
             154.00  161.24  168.42  176.15  183.68 
             191.84  199.67  232.88  305.37 
/
 1  7  5  1   88.78   83.22   86.60   91.88   97.72 
             104.03  110.75  117.88  125.52  133.39 
             141.58  150.05  158.78  167.76  176.96 
             186.39  195.55  235.18  319.44 
/
 1  7  6  1   61.01   65.39   71.58   78.29   85.34 
              92.78  100.62  108.88  117.54  126.60 
             136.61  146.93  157.45  168.26  179.48 
             190.66  202.48  250.46  354.67 
/
 1  7  7  1   50.61   58.49   66.70   74.70   83.66 
              93.47  104.01  115.19  126.94  139.22 
             152.01  165.23  178.82  192.76  207.07 
             221.73  236.62  303.07  448.99 
/
 1  7  8  1   43.78   52.45   65.13   78.26   92.61 
             107.89  124.49  142.01  160.30  179.26 
             198.85  217.95  239.61  259.92  281.31 
             305.70  326.18  423.08  654.04 
/
 1  8  1  1  218.77  197.95  191.48  190.75  191.24 
             192.46  194.21  196.41  198.99  201.85 
             205.07  208.57  212.28  216.30  220.55 
             224.96  229.64  250.22  299.73 
/
 1  8  2  1  216.13  192.17  185.49  184.86  185.49 
             186.89  188.82  191.24  193.96  197.11 
             200.52  204.28  208.25  212.52  217.02 
             221.69  226.62  248.12  299.88 
/
 1  8  3  1  198.67  163.84  157.53  157.66  159.20 
             161.59  164.61  168.16  172.15  176.49 
             181.45  186.46  191.71  197.20  202.91 
             208.79  214.87  241.52  301.48 
/
 1  8  4  1  176.71  137.63  134.81  135.69  138.16 
             141.61  145.79  150.61  155.73  161.21 
             167.26  173.33  179.63  186.14  193.28 
             200.17  207.22  237.58  305.05 
/
 1  8  5  1  129.56  103.24  103.55  107.19  111.86 
             117.24  123.15  129.39  136.12  143.22 
             150.64  158.09  166.05  174.26  182.30 
             190.93  199.80  235.21  313.60 
/
 1  8  6  1   72.33   73.49   78.59   84.69   91.21 
              98.07  105.54  113.40  121.67  130.31 
             139.19  148.59  158.10  168.17  178.22 
             188.51  199.02  242.52  337.31 
/
 1  8  7  1   54.26   61.49   68.77   76.17   84.25 
              92.92  102.14  111.88  122.12  132.80 
             143.90  155.42  167.33  179.60  192.20 
             205.84  220.30  278.85  406.49 
/
 1  8  8  1   46.67   55.04   65.83   76.21   87.51 
             100.01  113.54  127.91  142.98  158.68 
             174.95  191.69  208.89  226.60  244.82 
             263.41  282.36  362.05  551.21 
/
 1  9  1  1  227.99  214.19  208.46  207.69  207.96 
             208.84  210.18  211.90  213.95  216.30 
             218.87  221.76  224.90  228.29  231.91 
             235.70  239.77  258.04  303.69 
/
 1  9  2  1  226.28  210.49  204.29  203.52  203.83 
             204.78  206.22  208.05  210.23  212.67 
             215.45  218.51  221.82  225.33  229.13 
             233.15  237.40  256.38  303.38 
/
 1  9  3  1  217.42  191.36  184.08  183.54  184.26 
             185.71  187.77  190.26  193.19  196.49 
             200.06  203.99  208.20  212.61  217.32 
             222.20  227.36  249.85  303.16 
/
 1  9  4  1  206.36  172.16  165.13  165.20  166.47 
             168.63  171.41  174.68  178.40  182.50 
             186.91  191.62  197.00  202.28  207.79 
             213.52  219.44  244.96  304.73 
/
 1  9  5  1  177.35  137.20  134.48  135.44  138.02 
             141.58  145.83  150.60  155.97  161.55 
             167.44  173.92  180.34  186.98  194.28 
             201.32  208.53  239.60  308.44 
/
 1  9  6  1  113.54   95.56   97.39  101.83  107.06 
             112.89  119.22  125.97  133.11  140.63 
             148.47  156.36  164.74  173.38  182.28 
             190.96  200.27  238.30  321.15 
/
 1  9  7  1   61.87   66.65   73.08   79.98   87.19 
              94.78  102.78  111.19  120.02  129.25 
             138.94  149.63  160.47  171.60  183.14 
             194.61  206.33  256.19  364.27 
/
 1  9  8  1   51.33   59.56   68.07   76.25   85.38 
              95.37  106.08  117.43  129.36  141.82 
             154.78  168.22  182.06  196.25  210.80 
             225.70  240.81  306.56  457.28 
/
 1 10  1  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  2  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  3  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  4  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  5  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  6  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  7  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 1 10  8  1  243.54  242.25  241.84  242.08  242.67 
             243.50  244.56  245.83  247.31  248.98 
             250.84  252.91  255.16  257.60  260.24 
             263.06  266.08  280.04  317.01 
/
 2  1  1  1  208.17  182.77  177.85  177.27  178.17 
             179.97  182.42  185.38  188.74  192.54 
             196.67  201.14  205.84  210.80  216.03 
             221.44  227.05  251.33  307.37 
/
 2  1  2  1  203.66  173.92  169.44  169.08  170.26 
             172.30  175.09  178.44  182.23  186.44 
             190.99  195.86  201.01  206.40  212.02 
             217.85  223.85  250.30  309.29 
/
 2  1  3  1  170.51  140.94  138.03  138.98  141.50 
             145.09  149.46  154.43  160.02  165.92 
             172.38  178.97  186.11  193.24  200.96 
             208.54  216.76  250.13  322.54 
/
 2  1  4  1  132.59  120.38  119.89  122.89  127.11 
             132.14  137.80  144.00  150.81  157.97 
             165.52  173.45  181.71  190.28  199.15 
             207.90  217.26  256.48  341.61 
/
 2  1  5  1  101.81  101.49  106.03  111.45  117.39 
             123.84  130.81  138.29  146.28  154.73 
             164.22  174.08  184.29  194.73  205.70 
             216.71  228.41  276.50  383.14 
/
 2  1  6  1   90.83   94.83  100.98  108.18  116.08 
             124.66  133.94  143.93  154.60  165.93 
             177.87  190.34  203.32  216.80  230.74 
             245.48  261.38  328.26  476.57 
/
 2  1  7  1   84.13   90.88  100.21  111.09  123.85 
             138.36  154.28  171.44  189.73  209.05 
             229.39  250.70  272.97  296.21  320.36 
             345.20  370.74  483.75  749.32 
/
 2  1  8  1   78.60   88.43  107.52  130.43  157.28 
             186.55  218.28  252.49  288.72  326.97 
             367.47  409.84  452.87  499.45  547.49 
             597.94  650.31  885.29 1437.21 
/
 2  2  1  1  213.82  190.46  185.44  184.81  185.59 
             187.22  189.45  192.18  195.36  198.88 
             202.80  206.96  211.46  216.16  221.10 
             226.31  231.69  255.13  309.97 
/
 2  2  2  1  209.71  182.01  177.30  176.90  177.95 
             179.88  182.41  185.50  188.97  192.90 
             197.18  201.77  206.63  211.78  217.12 
             222.73  228.49  253.41  311.39 
/
 2  2  3  1  181.93  149.09  145.75  146.43  148.60 
             151.79  155.73  160.43  165.55  171.12 
             177.27  183.56  190.45  197.31  204.40 
             212.13  219.65  252.04  322.82 
/
 2  2  4  1  146.49  127.41  126.10  128.34  132.09 
             136.77  142.07  147.99  154.41  161.29 
             168.57  176.22  184.22  192.54  200.78 
             209.63  218.74  256.39  339.35 
/
 2  2  5  1  107.27  105.12  108.77  113.79  119.43 
             125.63  132.35  139.58  147.46  156.07 
             165.07  174.50  184.27  194.25  204.86 
             215.50  226.43  272.79  374.75 
/
 2  2  6  1   91.88   95.78  101.90  108.92  116.49 
             124.66  133.48  142.96  153.07  163.78 
             175.04  186.83  199.12  211.87  225.07 
             239.74  254.84  317.87  457.46 
/
 2  2  7  1   85.02   91.65  100.36  110.42  122.19 
             135.55  150.21  166.00  182.83  200.65 
             219.39  239.03  259.55  280.94  303.14 
             325.96  349.41  452.83  695.93 
/
 2  2  8  1   79.20   88.42  105.72  125.80  149.05 
             175.18  203.70  234.27  266.70  300.92 
             336.94  374.78  414.51  456.10  499.60 
             544.64  591.20  799.21 1287.43 
/
 2  3  1  1  219.65  198.61  193.50  192.84  193.50 
             194.96  197.00  199.47  202.40  205.70 
             209.28  213.21  217.37  221.83  226.49 
             231.42  236.53  258.98  312.30 
/
 2  3  2  1  215.95  190.83  185.78  185.28  186.16 
             187.87  190.20  193.00  196.28  199.92 
             203.90  208.22  212.78  217.66  222.73 
             228.02  233.57  257.57  313.71 
/
 2  3  3  1  192.77  158.29  154.58  154.99  156.87 
             159.75  163.34  167.54  172.25  177.40 
             183.18  189.10  195.33  202.19  208.96 
             215.96  223.16  254.34  322.25 
/
 2  3  4  1  161.61  135.88  133.89  135.39  138.52 
             142.66  147.62  153.10  159.18  165.73 
             172.50  179.82  187.50  195.17  203.43 
             211.98  220.33  256.68  336.19 
/
 2  3  5  1  114.91  110.23  112.71  117.16  122.42 
             128.29  134.79  141.98  149.67  157.84 
             166.34  175.41  184.66  194.53  204.47 
             214.71  225.23  269.96  367.49 
/
 2  3  6  1   93.77   96.94  102.98  109.83  117.08 
             124.85  133.21  142.18  151.72  161.83 
             172.47  183.62  195.24  207.30  220.43 
             234.27  248.38  307.72  439.65 
/
 2  3  7  1   86.06   92.53  100.66  109.94  120.78 
             133.05  146.48  160.95  176.37  192.69 
             209.87  227.89  246.71  266.32  286.59 
             307.42  328.84  422.95  644.35 
/
 2  3  8  1   79.93   88.63  104.21  122.00  142.57 
             165.74  191.09  218.33  247.24  277.72 
             309.75  343.33  378.50  415.29  453.73 
             493.72  535.00  716.41 1148.05 
/
 2  4  1  1  226.63  207.41  202.06  201.38  201.94 
             203.23  205.08  207.32  210.00  213.03 
             216.32  219.97  223.89  228.01  232.43 
             237.03  241.89  263.31  314.88 
/
 2  4  2  1  223.32  200.13  194.88  194.29  195.00 
             196.49  198.56  201.12  204.04  207.39 
             211.02  215.01  219.24  223.77  228.51 
             233.52  238.71  261.57  315.82 
/
 2  4  3  1  205.68  168.39  164.66  164.73  166.37 
             168.93  172.07  175.88  180.35  185.12 
             190.28  195.78  201.59  207.69  214.05 
             221.12  227.97  257.13  322.86 
/
 2  4  4  1  178.07  145.88  143.29  144.32  146.88 
             150.41  154.74  159.83  165.34  171.48 
             177.84  184.79  191.80  199.41  206.96 
             214.72  223.13  257.48  334.23 
/
 2  4  5  1  124.73  117.75  118.44  122.13  126.95 
             132.51  138.71  145.47  152.72  160.39 
             168.65  177.16  186.02  195.21  204.71 
             214.51  224.58  266.89  360.37 
/
 2  4  6  1   97.06   99.00  104.44  110.99  117.91 
             125.30  133.23  141.72  150.75  160.31 
             170.37  180.89  191.84  203.98  216.58 
             229.37  242.62  297.84  420.99 
/
 2  4  7  1   87.31   93.52  101.13  109.69  119.67 
             130.89  143.14  156.32  170.37  185.23 
             200.89  217.31  234.47  252.30  270.66 
             289.57  309.02  394.05  595.52 
/
 2  4  8  1   80.84   89.09  103.05  118.64  136.66 
             156.98  179.27  203.27  228.76  255.67 
             283.90  313.45  344.34  376.57  410.19 
             445.20  481.37  637.13 1018.15 
/
 2  5  1  1  234.10  216.80  211.18  210.44  210.89 
             212.04  213.65  215.72  218.15  220.92 
             223.94  227.30  230.93  234.77  238.89 
             243.25  247.79  268.15  317.91 
/
 2  5  2  1  231.20  210.40  204.61  203.94  204.49 
             205.79  207.63  209.87  212.55  215.58 
             218.88  222.54  226.42  230.61  235.06 
             239.68  244.59  266.19  318.35 
/
 2  5  3  1  216.42  179.64  176.01  175.90  177.26 
             179.40  182.27  185.70  189.60  193.94 
             198.65  203.70  209.08  214.74  220.67 
             226.84  233.21  261.32  323.84 
/
 2  5  4  1  195.26  157.76  154.50  155.09  157.22 
             160.29  164.08  168.48  173.41  178.79 
             184.81  190.99  197.49  204.61  211.67 
             218.97  226.97  259.70  332.53 
/
 2  5  5  1  144.48  127.75  126.95  129.54  133.65 
             138.59  144.26  150.49  157.25  164.46 
             172.09  180.11  188.50  197.21  206.23 
             215.56  224.73  265.02  353.43 
/
 2  5  6  1  102.58  102.71  107.32  113.33  119.78 
             126.71  134.17  142.16  150.65  159.62 
             169.05  179.27  190.25  201.53  213.19 
             225.12  237.16  288.88  403.56 
/
 2  5  7  1   88.88   94.77  101.96  109.87  119.05 
             129.24  140.33  152.23  164.91  178.35 
             192.51  207.36  222.84  238.85  255.38 
             272.43  289.97  367.16  548.17 
/
 2  5  8  1   82.03   90.02  102.41  115.86  131.41 
             148.97  168.32  189.18  211.37  234.79 
             259.39  285.14  311.99  339.97  369.08 
             399.34  430.62  565.09  892.65 
/
 2  6  1  1  241.67  226.65  220.71  219.97  220.32 
             221.32  222.79  224.65  226.86  229.33 
             232.14  235.23  238.58  242.13  245.97 
             250.04  254.29  273.56  321.38 
/
 2  6  2  1  239.19  220.93  214.95  214.22  214.64 
             215.74  217.36  219.39  221.73  224.46 
             227.50  230.77  234.37  238.23  242.27 
             246.61  251.18  271.48  321.39 
/
 2  6  3  1  226.72  193.68  188.65  188.42  189.49 
             191.37  193.87  196.88  200.34  204.21 
             208.46  213.02  217.86  223.02  228.43 
             234.09  239.98  265.61  325.21 
/
 2  6  4  1  213.04  171.46  167.90  168.05  169.75 
             172.34  175.51  179.35  183.86  188.67 
             193.89  199.46  205.36  211.56  218.03 
             225.22  232.21  262.24  331.27 
/
 2  6  5  1  169.52  140.65  138.82  140.40  143.44 
             147.54  152.50  158.01  164.15  170.77 
             177.65  185.09  192.92  200.76  209.21 
             217.55  226.56  264.04  346.87 
/
 2  6  6  1  112.35  109.34  112.56  117.67  123.46 
             129.82  136.71  144.10  151.98  160.78 
             170.02  179.60  189.58  200.05  210.63 
             221.53  233.14  281.07  387.40 
/
 2  6  7  1   90.88   96.38  103.14  110.59  119.02 
             128.24  138.18  148.83  160.17  172.19 
             184.86  198.09  211.85  226.14  240.91 
             256.16  271.86  342.33  503.21 
/
 2  6  8  1   83.60   91.48  102.24  113.70  126.94 
             141.91  158.44  176.27  195.26  215.33 
             236.40  258.46  281.49  305.48  330.40 
             356.24  382.88  496.97  773.95 
/
 2  7  1  1  249.14  236.42  230.72  229.96  230.22 
             231.08  232.39  234.06  236.06  238.35 
             240.92  243.70  246.79  250.12  253.69 
             257.48  261.45  279.60  325.43 
/
 2  7  2  1  247.13  232.33  225.87  225.11  225.41 
             226.36  227.77  229.57  231.65  234.10 
             236.84  239.85  243.07  246.60  250.36 
             254.36  258.54  277.55  325.04 
/
 2  7  3  1  237.03  209.39  202.92  202.49  203.28 
             204.80  206.85  209.37  212.30  215.59 
             219.22  223.18  227.44  231.97  236.78 
             241.86  247.13  270.53  326.34 
/
 2  7  4  1  226.59  187.40  183.65  183.56  184.80 
             186.91  189.61  192.89  196.65  200.83 
             205.40  210.33  215.58  221.13  226.97 
             233.07  239.41  267.01  331.19 
/
 2  7  5  1  195.74  157.44  154.45  155.32  157.62 
             160.78  164.83  169.43  174.58  180.21 
             186.47  192.91  199.99  207.08  214.44 
             222.49  230.35  264.47  342.05 
/
 2  7  6  1  128.47  121.34  121.94  125.67  130.56 
             136.21  142.50  149.34  156.68  164.63 
             172.89  181.55  190.59  199.98  210.03 
             220.11  230.07  274.28  371.70 
/
 2  7  7  1   94.47   98.51  104.92  112.07  119.79 
             128.03  136.85  146.28  156.30  166.90 
             178.05  189.73  201.90  214.54  227.61 
             241.10  255.36  318.96  460.40 
/
 2  7  8  1   85.90   93.57  102.62  112.32  123.42 
             136.03  149.89  164.83  180.74  197.58 
             215.27  233.80  253.15  273.29  294.23 
             315.85  338.07  433.10  663.14 
/
 2  8  1  1  256.29  246.73  241.08  240.35  240.55 
             241.31  242.48  243.99  245.80  247.88 
             250.23  252.78  255.62  258.70  262.00 
             265.53  269.27  286.32  329.99 
/
 2  8  2  1  254.77  243.55  237.36  236.57  236.78 
             237.58  238.80  240.39  242.29  244.48 
             246.94  249.61  252.58  255.79  259.24 
             262.92  266.76  284.48  329.47 
/
 2  8  3  1  247.13  226.34  218.91  218.24  218.70 
             219.85  221.47  223.53  225.97  228.76 
             231.81  235.22  238.91  242.81  247.04 
             251.46  256.17  277.18  328.75 
/
 2  8  4  1  239.28  208.59  201.99  201.70  202.58 
             204.20  206.38  209.02  212.10  215.55 
             219.37  223.52  227.96  232.67  237.68 
             242.96  248.47  272.85  331.13 
/
 2  8  5  1  223.05  178.46  175.02  175.16  176.69 
             179.15  182.30  186.02  190.25  194.93 
             200.01  205.46  211.26  217.37  223.77 
             230.43  237.35  267.97  337.50 
/
 2  8  6  1  168.60  140.82  139.29  141.05  144.31 
             148.63  153.72  159.50  165.85  172.55 
             179.82  187.51  195.60  203.72  212.46 
             221.53  230.44  269.37  356.87 
/
 2  8  7  1  103.33  104.11  109.05  115.40  122.17 
             129.40  137.14  145.41  154.19  163.47 
             173.22  183.42  194.03  205.81  218.05 
             230.52  243.29  297.70  419.61 
/
 2  8  8  1   89.37   96.24  103.84  111.97  121.35 
             131.79  143.15  155.33  168.31  182.04 
             196.50  211.65  227.49  243.96  260.95 
             278.46  296.49  373.64  561.20 
/
 2  9  1  1  262.89  256.32  251.74  251.06  251.24 
             251.91  252.97  254.33  255.98  257.88 
             260.04  262.43  265.05  267.89  270.90 
             274.17  277.67  293.69  335.26 
/
 2  9  2  1  261.88  254.57  249.26  248.50  248.64 
             249.32  250.39  251.79  253.49  255.45 
             257.67  260.13  262.83  265.76  268.91 
             272.28  275.86  292.26  334.72 
/
 2  9  3  1  256.76  243.51  236.37  235.51  235.71 
             236.53  237.82  239.49  241.49  243.81 
             246.41  249.22  252.36  255.75  259.39 
             263.27  267.32  285.93  332.94 
/
 2  9  4  1  251.55  231.64  223.71  223.08  223.54 
             224.63  226.22  228.23  230.61  233.32 
             236.30  239.63  243.19  247.08  251.24 
             255.59  260.26  281.13  332.92 
/
 2  9  5  1  240.83  207.16  201.22  200.96  201.90 
             203.58  205.84  208.58  211.76  215.34 
             219.29  223.58  228.19  233.12  238.33 
             243.82  249.57  275.03  335.90 
/
 2  9  6  1  215.29  170.73  167.31  167.80  169.67 
             172.49  176.02  180.16  184.82  189.96 
             195.52  201.74  208.08  214.73  221.68 
             228.90  236.89  269.19  345.17 
/
 2  9  7  1  128.69  121.84  122.88  126.91  131.94 
             137.77  144.24  151.24  158.81  166.84 
             175.29  184.35  193.62  203.28  213.28 
             223.62  234.29  279.39  381.33 
/
 2  9  8  1   95.40   99.93  106.62  113.94  121.82 
             130.21  139.18  148.75  158.93  169.68 
             180.98  192.82  205.17  217.99  231.28 
             245.00  259.13  322.79  468.86 
/
 2 10  1  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  2  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  3  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  4  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  5  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  6  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  7  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 2 10  8  1  273.69  272.40  271.99  272.23  272.81 
             273.65  274.71  275.98  277.45  279.12 
             280.99  283.05  285.30  287.74  290.37 
             293.20  296.21  310.16  347.11 
/
 3  1  1  1  221.69  201.65  196.80  196.04  196.65 
             198.05  200.08  202.61  205.50  208.82 
             212.47  216.38  220.62  225.07  229.76 
             234.73  239.88  262.54  316.41 
/
 3  1  2  1  217.87  193.65  188.96  188.36  189.20 
             190.89  193.23  196.08  199.37  203.05 
             207.09  211.43  216.10  220.99  226.12 
             231.52  237.10  261.46  318.41 
/
 3  1  3  1  195.83  162.16  158.37  158.71  160.68 
             163.54  167.19  171.47  176.43  181.72 
             187.43  193.48  200.15  206.84  213.78 
             221.37  228.78  260.88  330.65 
/
 3  1  4  1  160.96  140.85  138.99  140.56  143.81 
             148.08  153.15  158.75  164.97  171.66 
             178.79  186.32  194.22  202.15  210.66 
             219.47  228.12  265.70  349.07 
/
 3  1  5  1  121.42  117.88  120.60  125.21  130.61 
             136.64  143.24  150.38  158.26  166.83 
             175.82  185.19  195.01  205.31  215.73 
             226.47  237.52  284.57  388.83 
/
 3  1  6  1  103.90  107.23  113.33  120.33  127.85 
             136.04  144.93  154.54  164.83  175.76 
             187.30  199.40  212.04  225.18  238.81 
             253.94  269.55  334.92  480.88 
/
 3  1  7  1   97.30  103.40  112.04  122.36  134.59 
             148.51  163.82  180.38  198.08  216.87 
             236.71  257.56  279.41  302.25  325.99 
             350.44  375.62  487.70  752.22 
/
 3  1  8  1   91.47  100.77  118.62  139.87  164.82 
             193.00  223.86  257.07  292.47  330.00 
             369.70  411.57  455.65  501.98  550.52 
             600.99  653.42  888.53 1439.51 
/
 3  2  1  1  226.95  208.71  203.78  203.04  203.59 
             204.91  206.80  209.11  211.86  214.97 
             218.35  222.09  226.04  230.32  234.79 
             239.53  244.46  266.29  318.77 
/
 3  2  2  1  223.43  201.07  196.29  195.66  196.38 
             197.93  200.07  202.72  205.77  209.20 
             213.00  217.07  221.43  226.10  230.96 
             236.11  241.44  264.87  320.26 
/
 3  2  3  1  205.45  169.81  166.02  166.21  167.90 
             170.58  173.99  178.00  182.52  187.50 
             192.88  198.62  204.67  211.38  218.03 
             224.92  232.04  263.03  331.16 
/
 3  2  4  1  174.54  148.20  145.85  147.09  149.77 
             153.56  158.22  163.46  169.35  175.75 
             182.39  189.61  196.93  204.83  213.06 
             221.18  229.97  265.89  347.07 
/
 3  2  5  1  128.41  122.78  124.32  128.37  133.39 
             139.08  145.46  152.57  160.20  168.34 
             176.85  185.93  195.24  205.18  215.22 
             225.58  236.24  281.73  381.68 
/
 3  2  6  1  105.85  108.36  114.34  121.14  128.35 
             136.16  144.61  153.72  163.45  173.79 
             184.70  196.16  208.13  220.58  233.97 
             248.31  262.95  324.83  463.16 
/
 3  2  7  1   98.21  104.14  112.27  121.83  133.13 
             145.96  160.04  175.26  191.55  208.85 
             227.10  246.30  266.40  287.41  309.18 
             331.60  354.70  456.94  698.68 
/
 3  2  8  1   92.11  100.90  117.05  135.99  158.22 
             183.40  211.05  240.83  272.57  306.18 
             341.66  379.04  418.35  459.58  502.75 
             547.68  594.23  802.27 1290.03 
/
 3  3  1  1  232.40  215.92  211.14  210.43  210.93 
             212.14  213.89  216.07  218.58  221.48 
             224.70  228.16  231.94  235.93  240.22 
             244.73  249.43  270.41  321.48 
/
 3  3  2  1  229.19  208.95  204.10  203.45  204.08 
             205.48  207.41  209.85  212.69  215.85 
             219.39  223.19  227.32  231.67  236.32 
             241.16  246.27  268.70  322.45 
/
 3  3  3  1  212.93  178.36  174.66  174.62  176.07 
             178.50  181.62  185.31  189.51  194.16 
             199.20  204.60  210.32  216.34  222.63 
             229.17  235.95  265.58  331.91 
/
 3  3  4  1  187.61  156.80  153.90  154.76  157.16 
             160.52  164.63  169.41  174.88  180.71 
             187.16  193.78  200.73  208.28  215.80 
             223.96  231.97  267.17  344.14 
/
 3  3  5  1  137.14  129.44  129.51  132.84  137.40 
             142.81  148.88  155.58  162.83  170.50 
             178.62  187.36  196.30  205.59  215.22 
             225.16  235.40  278.60  374.69 
/
 3  3  6  1  109.01  110.28  115.67  122.15  129.04 
             136.48  144.50  153.13  162.35  172.15 
             182.47  193.31  204.61  216.72  229.87 
             243.26  256.97  315.00  444.57 
/
 3  3  7  1   99.27  105.00  112.65  121.49  131.93 
             143.71  156.61  170.54  185.45  201.28 
             218.01  235.59  254.00  273.20  293.04 
             313.49  334.57  427.49  647.25 
/
 3  3  8  1   92.89  101.23  115.76  132.50  152.14 
             174.42  198.95  225.43  253.65  283.51 
             315.00  348.10  382.83  419.24  457.34 
             497.01  538.04  719.60 1150.73 
/
 3  4  1  1  239.01  224.01  218.96  218.27  218.70 
             219.80  221.41  223.42  225.74  228.44 
             231.45  234.74  238.24  242.05  246.10 
             250.34  254.85  274.95  324.44 
/
 3  4  2  1  236.11  217.76  212.47  211.77  212.31 
             213.53  215.31  217.54  220.15  223.06 
             226.35  229.93  233.73  237.86  242.18 
             246.79  251.59  273.01  325.00 
/
 3  4  3  1  221.60  187.87  184.20  184.07  185.37 
             187.50  190.29  193.66  197.52  201.82 
             206.50  211.54  216.91  222.57  228.51 
             234.71  241.11  268.71  332.26 
/
 3  4  4  1  202.67  166.76  163.34  163.85  165.85 
             168.84  172.54  176.87  181.88  187.23 
             193.01  199.15  205.93  212.75  219.84 
             227.62  235.23  268.35  342.44 
/
 3  4  5  1  152.46  137.74  136.90  139.19  143.08 
             147.94  153.48  159.69  166.55  173.82 
             181.54  189.67  198.19  207.06  215.93 
             225.40  235.18  276.54  367.88 
/
 3  4  6  1  114.02  113.52  117.98  123.88  130.33 
             137.36  144.95  153.11  161.83  171.07 
             180.81  191.01  202.32  214.04  226.20 
             238.59  251.40  305.49  427.29 
/
 3  4  7  1  100.54  105.99  113.20  121.40  131.03 
             141.81  153.57  166.26  179.82  194.23 
             209.46  225.46  242.23  259.61  277.57 
             296.12  315.25  399.62  598.83 
/
 3  4  8  1   93.83  101.80  114.78  129.44  146.63 
             166.13  187.66  210.94  235.77  262.07 
             289.74  318.80  349.24  381.08  414.34 
             449.01  484.85  640.47 1021.01 
/
 3  5  1  1  246.16  232.68  227.20  226.52  226.88 
             227.88  229.35  231.20  233.40  235.85 
             238.65  241.72  245.06  248.59  252.42 
             256.48  260.71  279.94  327.81 
/
 3  5  2  1  243.58  226.97  221.35  220.64  221.06 
             222.16  223.78  225.80  228.14  230.86 
             233.89  237.21  240.75  244.59  248.69 
             252.98  257.53  277.85  327.96 
/
 3  5  3  1  230.87  199.13  194.82  194.56  195.62 
             197.49  199.99  203.00  206.48  210.37 
             214.63  219.25  224.17  229.37  234.83 
             240.55  246.51  272.49  332.97 
/
 3  5  4  1  217.78  177.89  174.35  174.57  176.21 
             178.82  182.13  186.02  190.44  195.31 
             200.60  206.25  212.24  218.55  225.14 
             232.44  239.58  270.29  341.08 
/
 3  5  5  1  173.01  148.19  146.48  148.07  151.10 
             155.20  160.11  165.75  171.97  178.71 
             185.72  193.32  201.31  209.36  218.01 
             226.99  235.84  274.44  361.28 
/
 3  5  6  1  121.53  118.91  121.99  127.13  133.01 
             139.51  146.58  154.20  162.34  170.97 
             180.53  190.56  201.07  211.88  223.12 
             234.53  246.66  296.95  410.25 
/
 3  5  7  1  102.09  107.23  114.05  121.73  130.61 
             140.41  151.05  162.50  174.75  187.77 
             201.52  215.97  231.02  246.63  262.80 
             279.51  296.74  373.53  551.93 
/
 3  5  8  1   95.04  102.76  114.24  126.92  141.76 
             158.61  177.27  197.47  219.02  241.86 
             265.92  291.16  317.56  345.13  373.87 
             403.79  434.73  568.14  895.80 
/
 3  6  1  1  253.40  241.40  235.91  235.17  235.47 
             236.37  237.71  239.38  241.40  243.72 
             246.32  249.19  252.31  255.62  259.22 
             263.06  267.11  285.41  331.59 
/
 3  6  2  1  251.19  236.68  230.78  230.03  230.35 
             231.32  232.76  234.59  236.77  239.26 
             242.04  245.05  248.37  251.95  255.72 
             259.78  264.06  283.31  331.39 
/
 3  6  3  1  240.37  212.31  206.62  206.28  207.14 
             208.74  210.90  213.53  216.56  219.96 
             223.72  227.82  232.22  236.90  241.86 
             247.08  252.53  276.61  333.85 
/
 3  6  4  1  229.24  190.64  187.13  187.10  188.43 
             190.61  193.48  196.91  200.83  205.20 
             209.96  215.10  220.56  226.35  232.42 
             238.77  245.37  274.10  340.21 
/
 3  6  5  1  196.62  161.38  158.68  159.65  162.10 
             165.51  169.66  174.46  179.83  185.87 
             192.20  199.16  206.24  213.96  221.66 
             230.05  238.28  273.96  355.08 
/
 3  6  6  1  133.75  127.69  128.84  132.83  137.90 
             143.69  150.10  157.35  165.10  173.34 
             182.07  191.28  200.78  210.93  221.20 
             231.82  242.76  289.62  394.55 
/
 3  6  7  1  104.51  108.85  115.33  122.66  130.83 
             139.66  149.19  159.44  170.39  182.02 
             194.27  207.11  220.52  234.46  248.91 
             263.85  279.24  349.10  507.54 
/
 3  6  8  1   96.73  104.29  114.17  125.04  137.67 
             152.05  167.97  185.20  203.61  223.11 
             243.67  265.25  287.84  311.42  335.96 
             361.45  387.72  500.68  776.98 
/
 3  7  1  1  260.55  250.80  244.92  244.21  244.45 
             245.25  246.46  248.02  249.89  252.05 
             254.46  257.08  260.00  263.15  266.54 
             270.15  273.98  291.38  335.85 
/
 3  7  2  1  258.75  246.77  240.70  239.92  240.16 
             241.00  242.29  243.94  245.92  248.19 
             250.75  253.56  256.58  259.90  263.45 
             267.24  271.25  289.39  335.36 
/
 3  7  3  1  249.91  226.52  219.92  219.35  219.94 
             221.22  223.02  225.26  227.87  230.84 
             234.15  237.78  241.65  245.86  250.28 
             255.01  259.93  282.00  335.71 
/
 3  7  4  1  240.87  206.49  201.85  201.60  202.62 
             204.41  206.80  209.70  213.05  216.80 
             220.94  225.43  230.24  235.36  240.78 
             246.47  252.43  278.50  340.03 
/
 3  7  5  1  220.89  177.57  174.18  174.54  176.41 
             179.11  182.58  186.65  191.24  196.51 
             202.04  207.95  214.23  220.83  228.13 
             235.34  242.81  275.67  350.75 
/
 3  7  6  1  156.93  141.33  140.64  142.95  146.86 
             151.78  157.45  163.77  170.65  178.03 
             185.89  194.17  202.87  211.93  221.36 
             230.74  240.79  283.41  378.27 
/
 3  7  7  1  109.84  111.83  117.48  124.42  131.80 
             139.69  148.16  157.24  166.93  177.19 
             188.02  199.38  211.23  223.56  236.32 
             249.50  264.23  326.49  465.34 
/
 3  7  8  1   99.21  106.34  114.69  123.91  134.56 
             146.69  160.03  174.44  189.83  206.16 
             223.38  241.46  260.40  280.15  300.71 
             321.93  343.78  437.65  666.21 
/
 3  8  1  1  267.37  259.77  254.31  253.60  253.79 
             254.51  255.62  257.05  258.78  260.77 
             263.02  265.51  268.24  271.14  274.32 
             277.72  281.33  297.88  340.53 
/
 3  8  2  1  266.01  257.04  251.01  250.26  250.44 
             251.19  252.34  253.84  255.64  257.72 
             260.06  262.59  265.43  268.50  271.80 
             275.32  279.07  296.13  339.97 
/
 3  8  3  1  259.27  241.68  234.51  233.74  234.08 
             235.08  236.56  238.45  240.69  243.21 
             246.08  249.25  252.64  256.35  260.32 
             264.48  268.93  288.95  338.77 
/
 3  8  4  1  252.41  225.95  218.86  218.51  219.26 
             220.69  222.63  225.00  227.74  230.86 
             234.32  238.09  242.17  246.53  251.19 
             256.08  261.26  284.30  340.40 
/
 3  8  5  1  238.35  197.11  193.68  193.64  194.92 
             197.05  199.84  203.10  206.92  211.17 
             215.83  220.87  226.25  231.96  237.98 
             244.28  250.85  279.58  347.35 
/
 3  8  6  1  196.30  161.26  158.92  160.13  162.70 
             166.27  170.59  175.69  181.30  187.59 
             194.18  201.41  208.78  216.79  224.81 
             233.52  242.09  279.93  365.11 
/
 3  8  7  1  121.88  120.03  123.62  129.15  135.35 
             142.14  149.49  157.39  165.82  174.76 
             184.17  194.04  204.97  216.41  228.15 
             240.22  252.73  305.83  425.33 
/
 3  8  8  1  102.69  108.81  116.04  123.89  132.97 
             143.03  153.94  165.67  178.20  191.49 
             205.53  220.29  235.74  251.78  268.39 
             285.55  303.25  379.27  565.02 
/
 3  9  1  1  273.64  267.70  263.93  263.26  263.42 
             264.07  265.09  266.41  268.01  269.86 
             271.95  274.27  276.82  279.59  282.58 
             285.77  289.18  304.87  345.76 
/
 3  9  2  1  272.73  266.15  261.75  261.00  261.12 
             261.79  262.84  264.20  265.84  267.75 
             269.89  272.22  274.84  277.68  280.74 
             284.02  287.51  303.56  345.25 
/
 3  9  3  1  268.18  257.28  250.24  249.37  249.52 
             250.29  251.49  253.06  254.96  257.14 
             259.62  262.35  265.29  268.53  272.01 
             275.73  279.68  297.62  343.40 
/
 3  9  4  1  263.58  246.64  238.89  238.15  238.48 
             239.46  240.92  242.77  244.98  247.45 
             250.28  253.41  256.81  260.42  264.36 
             268.49  272.92  292.92  343.07 
/
 3  9  5  1  254.19  224.70  218.07  217.74  218.54 
             220.02  222.04  224.52  227.39  230.65 
             234.26  238.20  242.47  247.03  251.88 
             257.02  262.42  286.52  345.17 
/
 3  9  6  1  234.83  189.76  186.45  186.59  188.11 
             190.48  193.59  197.29  201.50  206.19 
             211.30  216.80  222.67  228.87  235.39 
             242.67  249.80  280.82  354.27 
/
 3  9  7  1  155.35  141.73  141.27  143.89  148.05 
             153.17  159.02  165.53  172.58  180.14 
             188.19  196.69  205.60  214.91  224.58 
             234.62  245.00  289.19  389.04 
/
 3  9  8  1  110.57  113.17  119.19  126.38  133.95 
             141.99  150.59  159.80  169.61  180.01 
             190.97  202.48  214.51  227.02  240.00 
             253.41  267.24  330.23  474.96 
/
 3 10  1  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  2  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  3  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  4  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  5  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  6  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  7  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 3 10  8  1  283.74  282.45  282.04  282.28  282.86 
             283.70  284.76  286.03  287.50  289.17 
             291.04  293.10  295.34  297.79  300.42 
             303.24  306.26  320.20  357.14 
/
 4  1  1  1  245.74  233.68  229.39  228.63  229.01 
             230.07  231.60  233.58  235.93  238.61 
             241.54  244.81  248.36  252.11  256.16 
             260.44  264.91  285.09  335.06 
/
 4  1  2  1  242.68  227.12  222.75  221.97  222.45 
             223.63  225.40  227.62  230.23  233.14 
             236.44  239.98  243.86  248.01  252.36 
             257.00  261.84  283.45  336.25 
/
 4  1  3  1  227.84  198.53  194.71  194.51  195.80 
             198.00  200.92  204.35  208.34  212.78 
             217.53  222.75  228.30  234.17  240.34 
             246.78  253.46  282.17  348.42 
/
 4  1  4  1  210.71  178.69  175.25  175.81  177.89 
             180.99  184.86  189.37  194.45  200.19 
             206.24  212.70  219.79  226.96  234.80 
             242.58  250.61  285.57  364.91 
/
 4  1  5  1  161.91  152.67  151.98  154.51  158.65 
             163.76  169.68  176.24  183.45  191.14 
             199.32  208.16  217.26  226.76  236.63 
             246.86  257.42  302.31  403.49 
/
 4  1  6  1  133.25  132.84  137.96  144.24  151.14 
             158.72  167.00  175.99  185.65  195.97 
             206.92  218.44  230.52  243.20  257.33 
             271.86  286.69  349.77  492.43 
/
 4  1  7  1  122.94  127.71  135.50  145.01  156.45 
             169.41  183.71  199.28  216.05  233.96 
             252.98  273.07  294.20  316.34  339.29 
             363.04  387.60  497.99  758.96 
/
 4  1  8  1  116.70  125.17  141.00  160.35  183.53 
             210.03  239.37  271.20  305.37  341.82 
             380.55  421.54  464.85  510.48  558.35 
             608.19  660.08  894.32 1445.47 
/
 4  2  1  1  250.58  239.62  235.36  234.68  235.05 
             236.07  237.57  239.46  241.71  244.24 
             247.06  250.20  253.60  257.20  261.10 
             265.23  269.55  289.13  337.95 
/
 4  2  2  1  247.72  233.57  229.12  228.41  228.85 
             230.00  231.67  233.72  236.19  239.00 
             242.07  245.49  249.19  253.10  257.31 
             261.77  266.41  287.29  338.78 
/
 4  2  3  1  233.98  205.62  201.87  201.60  202.74 
             204.75  207.43  210.66  214.37  218.53 
             223.08  228.01  233.27  238.85  244.73 
             250.84  257.19  284.74  348.70 
/
 4  2  4  1  220.09  185.73  182.26  182.60  184.45 
             187.30  190.89  195.11  199.88  205.13 
             210.83  216.93  223.67  230.48  237.61 
             245.02  253.15  286.31  363.31 
/
 4  2  5  1  171.02  158.83  157.64  159.55  163.08 
             167.73  173.20  179.36  186.13  193.45 
             201.26  209.52  218.21  227.30  236.76 
             246.57  256.74  299.37  396.76 
/
 4  2  6  1  137.35  135.55  139.72  145.50  152.01 
             159.19  167.06  175.58  184.74  194.52 
             204.87  215.77  227.18  240.06  253.22 
             266.73  280.64  340.17  475.15 
/
 4  2  7  1  123.87  128.50  135.86  144.72  155.32 
             167.26  180.40  194.70  210.10  226.55 
             244.02  262.47  281.88  302.14  323.15 
             344.90  367.39  468.22  707.25 
/
 4  2  8  1  117.40  125.47  139.74  156.95  177.57 
             201.18  227.38  255.82  286.34  318.87 
             353.38  389.88  428.40  468.91  511.43 
             555.69  601.68  808.46 1296.00 
/
 4  3  1  1  255.62  246.15  241.66  241.04  241.42 
             242.40  243.84  245.59  247.73  250.17 
             252.89  255.89  259.09  262.60  266.35 
             270.33  274.49  293.46  341.13 
/
 4  3  2  1  252.96  240.43  235.87  235.21  235.62 
             236.70  238.27  240.24  242.57  245.17 
             248.13  251.37  254.83  258.61  262.64 
             266.85  271.35  291.47  341.51 
/
 4  3  3  1  240.40  213.40  209.76  209.44  210.43 
             212.25  214.69  217.66  221.08  224.93 
             229.16  233.75  238.66  243.86  249.33 
             255.07  261.06  287.25  348.88 
/
 4  3  4  1  227.70  193.69  190.26  190.37  191.99 
             194.57  197.88  201.66  206.08  210.97 
             216.51  222.26  228.37  234.82  241.56 
             248.60  255.91  288.20  360.86 
/
 4  3  5  1  185.15  166.22  164.44  165.99  168.94 
             173.00  177.90  183.59  189.92  196.66 
             204.03  211.86  220.12  228.79  237.50 
             246.87  256.58  297.42  390.21 
/
 4  3  6  1  142.39  139.64  142.47  147.58  153.58 
             160.31  167.71  175.75  184.38  193.60 
             203.35  213.72  225.35  237.21  249.41 
             261.96  275.16  330.88  457.08 
/
 4  3  7  1  124.96  129.42  136.36  144.64  154.46 
             165.41  177.44  190.51  204.58  219.62 
             235.59  252.45  270.16  288.59  307.71 
             327.52  348.02  439.86  656.42 
/
 4  3  8  1  118.25  125.96  138.73  153.95  172.12 
             192.96  216.14  241.33  268.36  297.15 
             327.66  359.88  393.83  429.53  466.96 
             505.95  546.38  726.63 1157.75 
/
 4  4  1  1  261.83  253.08  248.35  247.77  248.12 
             249.04  250.39  252.11  254.14  256.46 
             259.02  261.86  264.98  268.34  271.94 
             275.72  279.77  298.11  344.59 
/
 4  4  2  1  259.39  247.99  243.07  242.42  242.80 
             243.80  245.26  247.11  249.31  251.81 
             254.54  257.61  260.95  264.54  268.32 
             272.40  276.70  296.04  344.62 
/
 4  4  3  1  248.03  222.52  218.44  218.07  218.94 
             220.57  222.79  225.49  228.63  232.15 
             236.01  240.21  244.74  249.56  254.66 
             260.02  265.65  290.39  349.53 
/
 4  4  4  1  236.58  202.70  199.20  199.21  200.63 
             202.94  205.91  209.43  213.50  218.04 
             223.00  228.35  234.06  240.10  246.44 
             253.09  260.00  290.13  360.16 
/
 4  4  5  1  203.42  175.11  172.64  173.76  176.32 
             179.88  184.29  189.33  194.97  201.30 
             208.17  215.30  223.05  230.92  239.45 
             247.95  257.16  295.38  383.89 
/
 4  4  6  1  149.83  145.50  146.72  150.93  156.29 
             162.45  169.31  176.79  184.85  193.45 
             203.15  213.27  223.84  234.82  246.10 
             258.08  270.14  322.56  440.36 
/
 4  4  7  1  126.31  130.48  137.02  144.84  153.90 
             163.91  174.86  186.75  199.55  213.21 
             227.72  243.02  259.01  275.67  292.99 
             310.94  329.50  412.78  608.70 
/
 4  4  8  1  119.33  126.68  138.00  151.35  167.23 
             185.44  205.72  227.80  251.51  276.74 
             303.46  331.64  361.30  392.42  425.02 
             459.03  494.22  648.33 1027.93 
/
 4  5  1  1  268.63  260.52  255.46  254.86  255.17 
             256.02  257.29  258.91  260.83  263.04 
             265.51  268.24  271.22  274.38  277.83 
             281.50  285.40  303.10  348.34 
/
 4  5  2  1  266.46  255.84  250.71  250.07  250.39 
             251.31  252.67  254.40  256.45  258.81 
             261.44  264.28  267.44  270.85  274.50 
             278.33  282.44  301.03  348.09 
/
 4  5  3  1  256.35  232.92  227.99  227.55  228.28 
             229.70  231.67  234.10  236.92  240.11 
             243.63  247.50  251.65  256.11  260.82 
             265.83  271.05  294.33  350.76 
/
 4  5  4  1  246.22  212.86  209.37  209.21  210.38 
             212.38  215.02  218.20  221.85  225.96 
             230.46  235.34  240.57  246.13  252.00 
             258.16  264.60  292.88  358.89 
/
 4  5  5  1  223.27  185.73  182.54  183.24  185.43 
             188.49  192.36  196.86  202.07  207.69 
             213.76  220.50  227.41  234.68  242.63 
             250.56  258.77  294.70  377.87 
/
 4  5  6  1  160.74  153.16  153.31  156.28  160.79 
             166.23  172.41  179.52  187.21  195.43 
             204.21  213.51  223.16  233.50  244.01 
             254.91  266.17  314.73  424.98 
/
 4  5  7  1  128.83  131.74  137.94  145.40  153.74 
             162.84  172.76  183.51  195.06  207.39 
             220.42  234.14  248.51  263.50  279.08 
             295.23  311.91  387.49  562.64 
/
 4  5  8  1  120.71  127.69  137.61  149.23  162.95 
             178.70  196.24  215.33  235.83  257.68 
             280.82  305.21  330.84  357.69  385.78 
             415.04  445.30  576.62  901.58 
/
 4  6  1  1  275.52  268.23  262.91  262.28  262.55 
             263.34  264.52  266.05  267.86  269.96 
             272.31  274.90  277.74  280.82  284.12 
             287.60  291.34  308.45  352.39 
/
 4  6  2  1  273.65  264.45  258.76  258.10  258.38 
             259.22  260.48  262.10  264.02  266.23 
             268.65  271.38  274.37  277.60  281.06 
             284.76  288.63  306.46  351.93 
/
 4  6  3  1  264.93  244.44  238.53  237.95  238.49 
             239.72  241.44  243.61  246.13  249.02 
             252.18  255.71  259.54  263.59  267.97 
             272.54  277.43  299.16  352.69 
/
 4  6  4  1  256.22  224.61  220.94  220.66  221.60 
             223.30  225.59  228.37  231.60  235.23 
             239.24  243.61  248.31  253.34  258.66 
             264.28  270.17  296.11  357.99 
/
 4  6  5  1  238.57  197.87  194.65  194.92  196.63 
             199.23  202.59  206.57  211.08  216.09 
             221.54  227.41  233.65  240.24  247.54 
             254.81  262.36  295.16  372.46 
/
 4  6  6  1  178.23  163.94  162.99  165.01  168.45 
             173.04  178.51  184.72  191.56  198.97 
             206.90  215.31  224.18  233.47  243.15 
             253.23  263.66  308.27  408.89 
/
 4  6  7  1  134.07  134.47  139.70  146.66  154.21 
             162.41  171.31  180.92  191.23  202.22 
             213.85  226.10  238.92  252.30  266.19 
             280.58  295.45  364.00  519.17 
/
 4  6  8  1  122.55  129.16  137.77  147.75  159.45 
             172.92  187.86  204.10  221.55  240.15 
             259.86  280.65  302.51  325.38  349.27 
             374.04  399.65  510.48  783.59 
/
 4  7  1  1  282.31  275.34  270.66  270.02  270.24 
             270.97  272.08  273.51  275.23  277.21 
             279.45  281.92  284.63  287.56  290.72 
             294.05  297.65  314.13  356.75 
/
 4  7  2  1  280.78  272.90  267.25  266.55  266.76 
             267.51  268.67  270.16  271.96  274.03 
             276.36  278.93  281.75  284.81  288.09 
             291.55  295.28  312.34  356.24 
/
 4  7  3  1  273.57  256.96  250.00  249.30  249.68 
             250.71  252.22  254.13  256.34  258.93 
             261.83  264.96  268.43  272.17  276.11 
             280.36  284.85  304.99  355.52 
/
 4  7  4  1  266.41  239.75  234.07  233.73  234.48 
             235.92  237.89  240.30  243.11  246.29 
             249.82  253.66  257.79  262.24  266.98 
             271.97  277.24  300.79  358.24 
/
 4  7  5  1  251.86  212.47  209.09  209.08  210.40 
             212.57  215.40  218.80  222.70  227.06 
             231.85  237.04  242.59  248.50  254.72 
             261.25  268.08  298.03  369.16 
/
 4  7  6  1  209.74  178.50  176.27  177.53  180.18 
             183.82  188.24  193.45  199.19  205.64 
             212.47  219.94  227.89  235.97  244.73 
             253.49  262.97  303.13  394.51 
/
 4  7  7  1  143.12  140.85  144.17  149.82  156.31 
             163.48  171.31  179.79  188.88  198.57 
             208.81  219.60  230.88  242.63  255.24 
             269.01  282.90  342.59  479.08 
/
 4  7  8  1  125.03  130.96  138.52  147.01  157.05 
             168.42  180.91  194.45  208.99  224.50 
             240.95  258.31  276.55  295.65  315.47 
             336.00  357.23  449.01  674.41 
/
 4  8  1  1  288.76  282.50  278.71  278.04  278.21 
             278.87  279.91  281.25  282.87  284.75 
             286.87  289.22  291.80  294.60  297.62 
             300.86  304.30  320.16  361.48 
/
 4  8  2  1  287.60  280.62  276.06  275.35  275.51 
             276.19  277.25  278.64  280.31  282.25 
             284.44  286.87  289.52  292.41  295.52 
             298.85  302.40  318.65  360.96 
/
 4  8  3  1  282.05  269.79  262.44  261.63  261.86 
             262.70  264.00  265.66  267.61  269.91 
             272.50  275.36  278.49  281.81  285.44 
             289.31  293.41  312.00  359.37 
/
 4  8  4  1  276.54  256.53  249.22  248.67  249.17 
             250.30  251.92  253.94  256.32  259.02 
             262.03  265.37  269.01  272.86  277.06 
             281.45  286.16  307.28  360.01 
/
 4  8  5  1  265.36  230.15  226.72  226.45  227.38 
             229.05  231.29  234.02  237.20  240.78 
             244.74  249.07  253.73  258.73  264.03 
             269.63  275.51  301.71  365.45 
/
 4  8  6  1  242.71  197.85  194.70  195.13  197.00 
             199.82  203.28  207.43  212.14  217.53 
             223.25  229.40  235.94  242.84  250.10 
             258.09  266.01  301.07  382.46 
/
 4  8  7  1  160.54  153.88  154.50  157.96  162.83 
             168.60  175.09  182.21  189.91  198.35 
             207.57  217.30  227.46  238.04  248.95 
             260.61  272.37  323.20  440.23 
/
 4  8  8  1  129.47  133.44  140.08  147.65  156.26 
             165.63  175.80  186.80  198.61  211.21 
             224.57  238.64  253.37  268.74  284.72 
             301.30  318.46  392.48  575.90 
/
 4  9  1  1  294.63  289.56  286.87  286.23  286.38 
             287.01  287.99  289.26  290.79  292.57 
             294.58  296.82  299.28  301.95  304.83 
             307.93  311.23  326.47  366.45 
/
 4  9  2  1  293.86  288.29  285.10  284.41  284.54 
             285.16  286.15  287.44  289.00  290.81 
             292.87  295.15  297.66  300.39  303.33 
             306.49  309.86  325.39  366.02 
/
 4  9  3  1  290.09  281.81  275.77  274.88  274.98 
             275.65  276.75  278.19  279.94  281.98 
             284.28  286.83  289.64  292.68  295.95 
             299.46  303.14  320.22  364.31 
/
 4  9  4  1  286.34  274.42  266.28  265.47  265.68 
             266.51  267.79  269.45  271.44  273.68 
             276.26  279.12  282.24  285.63  289.21 
             293.09  297.21  315.95  363.74 
/
 4  9  5  1  278.75  256.11  248.20  247.87  248.52 
             249.79  251.53  253.68  256.21  259.07 
             262.26  265.76  269.55  273.62  277.97 
             282.59  287.49  309.58  364.83 
/
 4  9  6  1  263.32  223.44  220.09  219.95  221.08 
             223.01  225.56  228.64  232.21  236.21 
             240.63  245.44  250.62  256.14  262.00 
             268.16  274.63  303.27  372.17 
/
 4  9  7  1  207.61  178.63  176.67  178.16  180.96 
             184.76  189.36  194.77  200.76  207.45 
             214.70  222.26  230.47  239.13  247.88 
             257.34  266.76  309.00  404.39 
/
 4  9  8  1  143.55  141.72  145.63  151.63  158.35 
             165.70  173.69  182.30  191.52  201.35 
             211.75  222.69  234.16  246.11  258.54 
             271.42  284.73  346.64  487.84 
/
 4 10  1  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  2  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  3  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  4  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  5  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  6  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  7  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 4 10  8  1  303.83  302.54  302.13  302.38  302.96 
             303.80  304.86  306.12  307.60  309.27 
             311.13  313.19  315.44  317.88  320.51 
             323.33  326.34  340.28  377.21 
/
 5  1  1  1  267.70  261.08  257.13  256.53  256.86 
             257.78  259.14  260.87  262.93  265.28 
             267.92  270.82  273.92  277.33  280.98 
             284.86  288.97  307.59  354.88 
/
 5  1  2  1  265.02  255.59  251.65  250.99  251.36 
             252.37  253.86  255.75  257.99  260.50 
             263.35  266.49  269.90  273.52  277.44 
             281.61  285.96  305.79  355.57 
/
 5  1  3  1  252.92  230.19  226.55  226.14  227.05 
             228.78  231.13  234.01  237.35  241.11 
             245.26  249.75  254.55  259.67  265.09 
             270.78  276.71  302.80  365.24 
/
 5  1  4  1  240.98  211.50  208.02  208.13  209.72 
             212.20  215.47  219.25  223.66  228.57 
             233.93  239.71  245.86  252.37  259.21 
             266.35  273.79  306.84  381.59 
/
 5  1  5  1  201.62  186.11  184.06  185.52  188.42 
             192.43  197.27  202.96  209.35  216.21 
             223.74  231.78  240.28  249.23  258.27 
             267.99  278.10  320.88  419.27 
/
 5  1  6  1  164.58  161.42  163.65  168.68  174.80 
             181.75  189.48  197.94  207.10  216.90 
             227.33  238.35  250.59  263.45  276.83 
             290.51  304.55  365.82  505.53 
/
 5  1  7  1  147.85  151.59  158.70  167.72  178.50 
             190.67  204.17  218.96  234.99  252.20 
             270.54  290.00  310.53  331.96  354.27 
             377.44  401.49  510.64  769.25 
/
 5  1  8  1  141.51  149.18  163.37  181.33  203.11 
             228.26  256.33  287.01  320.13  355.63 
             393.53  433.77  476.40  521.42  568.62 
             617.87  669.24  901.62 1450.39 
/
 5  2  1  1  272.35  266.29  262.47  261.95  262.31 
             263.21  264.54  266.22  268.21  270.49 
             273.04  275.86  278.92  282.17  285.72 
             289.50  293.50  311.68  358.09 
/
 5  2  2  1  269.82  261.49  257.34  256.74  257.13 
             258.12  259.55  261.32  263.47  265.93 
             268.67  271.69  274.93  278.47  282.26 
             286.29  290.51  309.77  358.45 
/
 5  2  3  1  258.50  236.73  233.25  232.84  233.67 
             235.28  237.48  240.17  243.29  246.78 
             250.65  254.86  259.39  264.23  269.36 
             274.75  280.41  305.38  365.72 
/
 5  2  4  1  247.37  218.23  214.74  214.73  216.13 
             218.44  221.46  225.07  229.21  233.83 
             238.89  244.35  250.20  256.40  262.92 
             269.76  276.89  307.82  380.23 
/
 5  2  5  1  216.22  192.68  190.06  191.20  193.84 
             197.49  201.95  207.12  213.04  219.43 
             226.51  234.12  241.95  250.44  259.03 
             268.30  277.55  318.41  412.90 
/
 5  2  6  1  169.39  165.71  166.75  171.03  176.59 
             183.05  190.28  198.23  206.83  216.06 
             225.87  236.79  248.40  260.44  272.91 
             285.96  299.13  356.63  488.58 
/
 5  2  7  1  148.78  152.43  159.15  167.65  177.62 
             188.81  201.21  214.78  229.48  245.26 
             262.09  279.93  298.69  318.28  338.68 
             359.88  381.86  481.47  716.77 
/
 5  2  8  1  142.31  149.60  162.34  178.32  197.65 
             220.01  245.01  272.34  301.84  333.44 
             367.12  402.90  440.74  480.63  522.52 
             566.16  611.59  816.77 1302.75 
/
 5  3  1  1  277.20  272.04  268.11  267.63  268.01 
             268.90  270.19  271.81  273.74  275.95 
             278.42  281.14  284.05  287.27  290.71 
             294.38  298.28  316.01  361.45 
/
 5  3  2  1  274.83  267.51  263.32  262.79  263.17 
             264.12  265.49  267.23  269.29  271.66 
             274.29  277.14  280.30  283.72  287.37 
             291.27  295.34  314.04  361.57 
/
 5  3  3  1  264.35  244.27  240.55  240.12  240.86 
             242.34  244.36  246.83  249.71  252.97 
             256.58  260.52  264.78  269.34  274.19 
             279.29  284.64  308.47  366.64 
/
 5  3  4  1  254.12  225.74  222.27  222.15  223.37 
             225.45  228.19  231.49  235.29  239.55 
             244.23  249.30  254.75  260.54  266.65 
             273.07  279.79  309.34  378.30 
/
 5  3  5  1  231.87  200.09  197.09  197.93  200.23 
             203.53  207.62  212.38  217.76  223.83 
             230.26  237.16  244.72  252.44  260.85 
             269.29  278.04  316.99  405.67 
/
 5  3  6  1  176.76  170.91  171.21  174.51  179.38 
             185.24  191.90  199.27  207.28  216.17 
             225.88  236.09  246.74  257.94  269.44 
             281.73  294.14  347.79  471.93 
/
 5  3  7  1  150.24  153.39  159.76  167.79  176.99 
             187.26  198.60  210.99  224.41  238.81 
             254.17  270.40  287.43  305.24  323.80 
             343.10  363.10  453.95  667.72 
/
 5  3  8  1  143.28  150.20  161.56  175.67  192.70 
             212.40  234.47  258.60  284.65  312.54 
             342.24  373.73  407.03  442.12  478.95 
             517.30  557.15  735.79 1163.55 
/
 5  4  1  1  283.23  278.12  274.13  273.66  274.03 
             274.89  276.14  277.70  279.56  281.69 
             284.02  286.66  289.53  292.64  295.98 
             299.54  303.33  320.60  365.09 
/
 5  4  2  1  281.03  274.22  269.76  269.23  269.60 
             270.51  271.83  273.49  275.41  277.66 
             280.19  282.98  286.02  289.30  292.77 
             296.53  300.51  318.62  364.91 
/
 5  4  3  1  271.41  252.64  248.50  248.01  248.64 
             249.97  251.81  254.08  256.76  259.79 
             263.15  266.83  270.83  275.07  279.66 
             284.44  289.54  312.13  368.02 
/
 5  4  4  1  262.13  234.12  230.72  230.50  231.55 
             233.40  235.87  238.87  242.33  246.23 
             250.53  255.20  260.23  265.60  271.29 
             277.28  283.57  311.29  376.87 
/
 5  4  5  1  243.63  208.45  205.39  205.90  207.88 
             210.78  214.48  218.83  223.75  229.20 
             235.14  241.75  248.57  255.76  263.31 
             271.19  279.83  315.57  400.89 
/
 5  4  6  1  186.83  177.52  177.26  179.66  183.65 
             188.77  194.86  201.78  209.44  217.70 
             226.53  235.82  245.85  256.15  266.91 
             278.45  290.09  339.99  455.62 
/
 5  4  7  1  153.12  154.64  160.58  168.19  176.66 
             186.05  196.37  207.64  219.82  232.88 
             246.75  261.40  276.79  292.91  309.71 
             327.16  345.24  427.75  620.58 
/
 5  4  8  1  144.45  151.01  161.05  173.43  188.29 
             205.49  224.77  245.85  268.62  292.99 
             318.93  346.41  375.41  405.93  437.97 
             471.32  505.93  658.63 1034.64 
/
 5  5  1  1  289.90  284.36  280.51  280.03  280.35 
             281.15  282.34  283.83  285.62  287.67 
             289.97  292.51  295.29  298.29  301.53 
             304.98  308.62  325.46  368.97 
/
 5  5  2  1  287.94  281.45  276.63  276.05  276.38 
             277.22  278.47  280.04  281.92  284.08 
             286.50  289.11  292.02  295.18  298.57 
             302.19  306.03  323.54  368.60 
/
 5  5  3  1  279.28  262.19  257.15  256.60  257.12 
             258.31  259.95  262.04  264.52  267.33 
             270.41  273.85  277.53  281.54  285.77 
             290.31  295.10  316.50  369.95 
/
 5  5  4  1  270.99  243.45  240.18  239.89  240.78 
             242.42  244.63  247.33  250.47  254.01 
             257.92  262.20  266.81  271.76  277.01 
             282.55  288.36  314.11  376.15 
/
 5  5  5  1  254.38  218.22  215.05  215.33  216.98 
             219.57  222.81  226.72  231.19  236.16 
             241.60  247.47  253.74  260.38  267.37 
             274.69  282.33  315.70  395.50 
/
 5  5  6  1  198.15  186.29  185.15  187.06  190.36 
             194.70  200.00  206.12  212.94  220.41 
             228.45  237.03  246.09  255.64  265.62 
             276.03  286.85  333.39  439.69 
/
 5  5  7  1  158.24  157.26  162.01  168.95  176.70 
             185.23  194.59  204.76  215.73  227.47 
             239.94  253.12  266.97  281.44  296.52 
             312.19  328.40  403.10  575.17 
/
 5  5  8  1  145.87  151.99  160.85  171.62  184.47 
             199.37  216.01  234.20  253.85  274.90 
             297.29  320.99  345.97  372.23  399.76 
             428.38  458.06  587.50  910.67 
/
 5  6  1  1  296.64  290.83  287.23  286.69  286.95 
             287.73  288.86  290.29  292.01  293.98 
             296.14  298.59  301.27  304.17  307.31 
             310.66  314.22  330.59  373.09 
/
 5  6  2  1  294.96  288.32  283.85  283.22  283.49 
             284.28  285.45  286.94  288.73  290.78 
             293.09  295.65  298.44  301.41  304.67 
             308.15  311.85  328.81  372.65 
/
 5  6  3  1  287.41  272.75  266.60  265.93  266.32 
             267.35  268.85  270.76  273.02  275.60 
             278.43  281.61  285.07  288.74  292.73 
             296.97  301.40  321.61  372.52 
/
 5  6  4  1  280.22  255.31  250.78  250.44  251.20 
             252.65  254.62  257.03  259.85  263.04 
             266.58  270.44  274.61  279.07  283.84 
             288.88  294.21  318.01  376.32 
/
 5  6  5  1  265.77  229.69  226.40  226.41  227.74 
             229.93  232.78  236.20  240.13  244.53 
             249.38  254.63  260.27  266.28  272.63 
             279.31  286.29  317.09  390.82 
/
 5  6  6  1  223.91  197.57  195.41  196.71  199.41 
             203.11  207.61  212.91  218.79  225.38 
             232.56  240.09  248.30  256.99  265.81 
             275.34  284.86  327.08  425.26 
/
 5  6  7  1  165.27  162.66  165.50  171.18  177.90 
             185.45  193.78  202.85  212.63  223.09 
             234.20  245.93  258.25  271.12  284.51 
             298.42  313.96  380.48  533.49 
/
 5  6  8  1  147.66  153.21  161.10  170.39  181.45 
             194.22  208.37  223.82  240.50  258.37 
             277.40  297.55  318.78  341.07  364.34 
             388.49  413.54  522.53  793.80 
/
 5  7  1  1  303.27  297.46  294.21  293.62  293.83 
             294.52  295.61  296.98  298.62  300.51 
             302.64  304.94  307.53  310.34  313.36 
             316.61  320.06  335.97  377.44 
/
 5  7  2  1  301.91  295.38  291.40  290.74  290.95 
             291.67  292.77  294.18  295.88  297.83 
             300.03  302.42  305.10  307.99  311.12 
             314.47  318.03  334.40  376.95 
/
 5  7  3  1  295.62  283.83  276.81  276.03  276.32 
             277.22  278.53  280.24  282.29  284.65 
             287.30  290.22  293.35  296.80  300.50 
             304.44  308.56  327.53  375.86 
/
 5  7  4  1  289.65  269.12  262.77  262.33  262.92 
             264.15  265.85  267.96  270.44  273.26 
             276.40  279.83  283.57  287.61  291.91 
             296.51  301.33  323.18  377.56 
/
 5  7  5  1  277.61  243.18  239.91  239.71  240.73 
             242.51  244.89  247.79  251.14  254.92 
             259.10  263.66  268.58  273.84  279.43 
             285.34  291.55  319.19  386.58 
/
 5  7  6  1  253.71  211.83  208.85  209.51  211.59 
             214.65  218.45  222.92  227.98  233.58 
             239.68  246.25  253.51  260.94  268.74 
             276.89  285.81  323.55  411.59 
/
 5  7  7  1  176.09  171.96  172.76  176.58  181.92 
             188.23  195.34  203.16  211.64  220.74 
             230.41  240.63  251.40  263.54  276.06 
             288.95  302.27  359.78  493.13 
/
 5  7  8  1  150.66  155.03  162.01  170.03  179.62 
             190.36  202.15  215.00  228.87  243.75 
             259.58  276.34  294.00  312.45  331.67 
             351.64  372.36  462.36  685.86 
/
 5  8  1  1  309.55  304.14  301.41  300.77  300.94 
             301.59  302.59  303.88  305.44  307.25 
             309.29  311.56  314.06  316.77  319.69 
             322.82  326.17  341.60  382.06 
/
 5  8  2  1  308.52  302.54  299.27  298.56  298.70 
             299.36  300.38  301.71  303.31  305.17 
             307.27  309.60  312.15  314.93  317.93 
             321.14  324.56  340.32  381.60 
/
 5  8  3  1  303.66  294.50  287.74  286.93  287.10 
             287.85  289.04  290.57  292.43  294.57 
             296.93  299.61  302.53  305.71  309.12 
             312.77  316.60  334.36  380.03 
/
 5  8  4  1  299.02  284.37  276.39  275.67  276.04 
             276.99  278.42  280.24  282.40  284.89 
             287.62  290.69  294.04  297.60  301.49 
             305.63  309.97  329.88  380.16 
/
 5  8  5  1  289.67  260.86  256.03  255.72  256.48 
             257.92  259.88  262.28  265.09  268.28 
             271.81  275.69  279.90  284.42  289.25 
             294.38  299.78  324.15  384.41 
/
 5  8  6  1  270.91  229.69  226.49  226.63  228.12 
             230.47  233.52  237.16  241.34  246.02 
             251.16  256.74  262.72  269.09  275.64 
             282.69  290.07  322.58  400.12 
/
 5  8  7  1  196.68  186.69  186.07  188.22  191.72 
             196.34  201.98  208.43  215.60  223.40 
             231.88  240.81  250.26  260.21  270.62 
             281.48  292.78  342.06  455.21 
/
 5  8  8  1  158.80  158.62  163.96  171.26  179.34 
             188.15  197.76  208.20  219.43  231.45 
             244.22  257.72  271.90  286.75  302.24 
             318.34  335.03  407.34  588.72 
/
 5  9  1  1  315.22  310.71  308.48  307.99  308.21 
             308.87  309.84  311.10  312.60  314.35 
             316.31  318.50  320.90  323.51  326.32 
             329.35  332.58  347.50  386.81 
/
 5  9  2  1  314.54  309.62  307.11  306.51  306.67 
             307.30  308.27  309.53  311.05  312.82 
             314.81  317.04  319.48  322.13  325.00 
             328.08  331.36  346.55  386.47 
/
 5  9  3  1  311.25  304.07  299.47  298.53  298.61 
             299.24  300.28  301.65  303.32  305.26 
             307.45  309.90  312.58  315.49  318.63 
             322.00  325.54  342.06  385.06 
/
 5  9  4  1  308.06  298.57  291.34  290.46  290.60 
             291.33  292.51  294.04  295.89  298.05 
             300.47  303.17  306.06  309.26  312.71 
             316.40  320.33  338.25  384.37 
/
 5  9  5  1  301.63  284.04  275.43  275.03  275.60 
             276.72  278.29  280.23  282.53  285.13 
             288.04  291.25  294.75  298.52  302.57 
             306.87  311.45  332.26  385.13 
/
 5  9  6  1  288.69  253.22  250.02  249.77  250.67 
             252.30  254.49  257.17  260.30  263.83 
             267.75  272.04  276.68  281.67  286.98 
             292.61  298.54  325.12  390.60 
/
 5  9  7  1  253.99  212.13  209.21  210.04  212.28 
             215.43  219.39  224.02  229.26  235.22 
             241.57  248.41  255.95  263.68  271.81 
             280.69  289.57  328.87  421.66 
/
 5  9  8  1  176.33  172.55  173.72  178.03  183.68 
             190.22  197.52  205.52  214.16  223.43 
             233.28  243.69  254.63  266.07  278.00 
             291.07  304.91  364.24  502.18 
/
 5 10  1  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  2  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  3  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  4  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  5  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  6  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  7  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 5 10  8  1  323.93  322.64  322.23  322.48  323.06 
             323.90  324.95  326.22  327.69  329.36 
             331.23  333.28  335.53  337.97  340.61 
             343.42  346.43  360.37  397.27 
/
 6  1  1  1  288.61  284.99  281.92  281.50  281.89 
             282.78  284.05  285.66  287.56  289.74 
             292.18  294.88  297.77  300.94  304.36 
             308.00  311.87  329.54  375.12 
/
 6  1  2  1  286.11  281.01  277.37  276.85  277.23 
             278.17  279.52  281.24  283.27  285.60 
             288.21  291.08  294.17  297.55  301.17 
             305.04  309.15  327.79  375.54 
/
 6  1  3  1  275.58  258.65  255.30  254.83  255.55 
             257.00  259.00  261.47  264.35  267.63 
             271.25  275.21  279.48  284.07  288.91 
             294.09  299.47  323.57  383.05 
/
 6  1  4  1  265.67  241.15  237.74  237.61  238.83 
             240.93  243.70  247.05  250.91  255.24 
             260.00  265.17  270.73  276.65  282.91 
             289.50  296.40  326.76  397.97 
/
 6  1  5  1  246.44  217.15  214.32  215.17  217.55 
             220.96  225.20  230.15  235.73  242.04 
             248.76  256.17  263.86  271.96  280.77 
             289.64  299.28  340.00  435.66 
/
 6  1  6  1  195.51  190.67  190.94  194.31  199.42 
             205.61  212.69  220.57  229.17  238.44 
             248.82  259.95  271.59  283.76  296.61 
             309.67  323.61  382.60  520.65 
/
 6  1  7  1  172.33  175.13  181.67  190.38  200.52 
             212.04  224.90  239.05  254.46  271.08 
             288.87  307.77  327.66  348.50  370.28 
             392.98  416.58  524.62  779.94 
/
 6  1  8  1  166.02  172.82  185.72  202.55  223.18 
             247.20  274.20  303.86  336.08  370.80 
             407.96  447.57  489.61  534.07  580.67 
             629.37  680.26  911.52 1456.91 
/
 6  2  1  1  293.20  289.70  286.89  286.52  286.93 
             287.81  289.06  290.63  292.49  294.62 
             297.00  299.64  302.51  305.62  308.91 
             312.48  316.27  333.61  378.40 
/
 6  2  2  1  290.82  286.26  282.59  282.14  282.54 
             283.46  284.78  286.45  288.42  290.68 
             293.22  296.01  299.00  302.29  305.82 
             309.59  313.58  331.79  378.61 
/
 6  2  3  1  280.84  264.91  261.55  261.07  261.72 
             263.07  264.95  267.28  270.00  273.09 
             276.52  280.29  284.32  288.71  293.32 
             298.21  303.41  326.56  384.11 
/
 6  2  4  1  271.56  247.55  244.21  244.02  245.12 
             247.05  249.61  252.72  256.31  260.35 
             264.81  269.66  274.89  280.47  286.38 
             292.62  299.16  327.98  396.30 
/
 6  2  5  1  253.40  223.28  220.41  221.02  223.14 
             226.28  230.14  234.74  239.94  245.86 
             252.16  258.95  266.17  274.09  282.14 
             290.54  299.29  337.97  428.62 
/
 6  2  6  1  203.73  195.25  195.24  197.88  202.25 
             207.83  214.31  221.59  229.77  238.85 
             248.55  258.79  269.75  281.02  293.11 
             305.41  318.19  373.77  502.93 
/
 6  2  7  1  174.20  175.99  182.23  190.43  199.81 
             210.40  222.21  235.18  249.30  264.53 
             280.81  298.06  316.21  335.25  355.16 
             375.89  397.44  496.16  729.10 
/
 6  2  8  1  166.83  173.31  184.87  199.84  218.13 
             239.45  263.45  289.81  318.44  349.27 
             382.27  417.40  454.65  494.00  535.29 
             578.38  623.32  827.09 1309.89 
/
 6  3  1  1  297.96  294.63  292.08  291.77  292.19 
             293.06  294.29  295.82  297.64  299.72 
             302.04  304.62  307.42  310.46  313.72 
             317.16  320.87  337.87  381.91 
/
 6  3  2  1  295.73  291.53  288.09  287.70  288.11 
             289.01  290.30  291.92  293.84  296.03 
             298.48  301.14  304.09  307.28  310.72 
             314.38  318.27  336.03  381.83 
/
 6  3  3  1  286.38  271.89  268.30  267.80  268.39 
             269.64  271.40  273.54  276.12  279.05 
             282.25  285.83  289.64  293.80  298.24 
             302.88  307.84  330.00  385.49 
/
 6  3  4  1  277.81  254.63  251.39  251.14  252.13 
             253.89  256.24  259.11  262.44  266.20 
             270.35  274.88  279.77  285.00  290.56 
             296.43  302.59  329.78  395.12 
/
 6  3  5  1  260.89  230.31  227.36  227.82  229.66 
             232.46  236.06  240.32  245.16  250.54 
             256.43  262.77  269.54  276.72  284.27 
             292.18  300.43  337.13  422.84 
/
 6  3  6  1  210.04  201.03  200.46  202.69  206.35 
             211.24  217.22  224.05  231.64  239.94 
             248.85  258.30  268.53  279.09  290.14 
             301.67  313.66  365.93  486.58 
/
 6  3  7  1  177.52  177.37  182.98  190.70  199.37 
             209.08  219.87  231.71  244.58  258.43 
             273.21  288.87  305.38  322.69  340.78 
             359.63  379.20  469.15  680.45 
/
 6  3  8  1  167.81  173.95  184.26  197.48  213.57 
             232.35  253.48  276.71  301.93  329.08 
             358.10  388.98  421.69  456.25  492.50 
             530.28  569.63  747.07 1171.39 
/
 6  4  1  1  303.92  300.19  297.70  297.37  297.77 
             298.61  299.80  301.29  303.06  305.07 
             307.34  309.84  312.58  315.54  318.72 
             322.08  325.71  342.35  385.62 
/
 6  4  2  1  301.83  297.33  294.02  293.63  294.00 
             294.87  296.14  297.71  299.50  301.62 
             303.99  306.61  309.48  312.58  315.91 
             319.46  323.25  340.55  385.36 
/
 6  4  3  1  293.11  279.86  275.60  275.09  275.61 
             276.76  278.35  280.40  282.81  285.56 
             288.56  291.93  295.58  299.45  303.65 
             308.05  312.76  333.95  387.36 
/
 6  4  4  1  285.29  262.46  259.35  259.07  259.94 
             261.54  263.69  266.33  269.40  272.87 
             276.72  280.92  285.47  290.35  295.52 
             300.96  306.69  332.28  394.51 
/
 6  4  5  1  269.75  238.40  235.31  235.56  237.19 
             239.72  242.98  246.86  251.31  256.26 
             261.70  267.59  273.77  280.45  287.50 
             294.91  302.66  336.70  417.92 
/
 6  4  6  1  217.82  208.31  207.07  208.90  212.12 
             216.45  221.63  227.68  234.50  242.02 
             250.16  258.90  268.17  277.96  288.23 
             298.98  310.17  358.60  470.61 
/
 6  4  7  1  181.92  179.99  184.39  191.29  199.22 
             208.09  217.91  228.65  240.30  252.82 
             266.18  280.34  295.26  310.90  327.24 
             344.25  361.90  443.55  633.77 
/
 6  4  8  1  168.99  174.70  183.91  195.51  209.55 
             225.95  244.38  264.63  286.62  310.27 
             335.55  362.42  390.86  420.86  452.34 
             485.13  519.23  670.65 1043.16 
/
 6  5  1  1  310.54  306.18  303.66  303.28  303.62 
             304.41  305.54  307.02  308.73  310.69 
             312.89  315.27  317.93  320.81  323.92 
             327.24  330.78  347.06  389.47 
/
 6  5  2  1  308.69  303.62  300.39  299.92  300.26 
             301.08  302.26  303.75  305.53  307.57 
             309.86  312.39  315.17  318.17  321.39 
             324.85  328.48  345.34  389.13 
/
 6  5  3  1  300.77  288.66  283.57  282.99  283.42 
             284.46  285.96  287.86  290.11  292.61 
             295.48  298.64  302.01  305.71  309.68 
             313.84  318.30  338.52  389.74 
/
 6  5  4  1  293.73  271.68  268.17  267.88  268.65 
             270.09  272.06  274.47  277.29  280.48 
             283.99  287.84  291.99  296.47  301.25 
             306.30  311.63  335.58  394.58 
/
 6  5  5  1  279.70  247.73  244.56  244.61  245.95 
             248.15  251.00  254.43  258.39  262.82 
             267.70  273.00  278.71  284.79  291.24 
             298.03  305.15  336.66  412.73 
/
 6  5  6  1  240.14  217.53  215.31  216.65  219.39 
             223.15  227.74  233.15  239.16  245.93 
             253.15  261.08  269.56  278.29  287.74 
             297.66  307.63  351.97  456.12 
/
 6  5  7  1  187.59  184.81  187.27  192.95  199.90 
             207.82  216.63  226.29  236.76  248.01 
             260.00  272.69  286.06  300.07  314.70 
             329.91  346.45  419.45  588.85 
/
 6  5  8  1  170.44  175.67  183.87  193.97  206.15 
             220.36  236.23  253.67  272.61  292.97 
             314.72  337.83  362.27  388.02  414.99 
             443.05  472.22  600.03  920.26 
/
 6  6  1  1  317.24  312.39  309.94  309.45  309.74 
             310.49  311.57  312.95  314.60  316.49 
             318.62  320.98  323.57  326.38  329.40 
             332.64  336.09  352.00  393.57 
/
 6  6  2  1  315.66  310.18  307.10  306.53  306.81 
             307.56  308.68  310.10  311.80  313.76 
             315.97  318.41  321.09  324.00  327.12 
             330.47  334.03  350.43  393.16 
/
 6  6  3  1  308.70  298.31  292.17  291.53  291.87 
             292.79  294.17  295.91  297.99  300.38 
             302.99  305.94  309.16  312.63  316.31 
             320.29  324.51  343.69  392.72 
/
 6  6  4  1  302.55  283.10  278.05  277.67  278.31 
             279.58  281.33  283.49  286.02  288.88 
             292.09  295.61  299.43  303.53  307.94 
             312.63  317.55  339.87  395.47 
/
 6  6  5  1  290.26  258.53  255.37  255.24  256.33 
             258.20  260.67  263.66  267.14  271.05 
             275.37  280.10  285.20  290.65  296.45 
             302.59  309.04  337.81  408.16 
/
 6  6  6  1  266.28  228.45  225.72  226.50  228.74 
             231.96  235.89  240.66  245.97  251.86 
             258.29  265.20  272.83  280.68  288.93 
             297.93  306.97  347.01  442.21 
/
 6  6  7  1  195.12  191.86  192.79  196.76  202.45 
             209.23  216.90  225.38  234.61  244.54 
             255.13  266.35  278.17  290.56  303.97 
             318.47  333.44  397.60  547.74 
/
 6  6  8  1  172.67  176.93  184.22  192.95  203.54 
             215.70  229.19  243.97  260.02  277.28 
             295.73  315.32  336.02  357.76  380.45 
             404.09  428.66  536.04  805.69 
/
 6  7  1  1  323.82  318.76  316.38  315.86  316.09 
             316.78  317.81  319.13  320.71  322.54 
             324.60  326.89  329.40  332.13  335.10 
             338.25  341.62  357.14  397.88 
/
 6  7  2  1  322.53  316.93  314.09  313.43  313.65 
             314.35  315.40  316.75  318.38  320.26 
             322.38  324.74  327.32  330.12  333.14 
             336.39  339.84  355.77  397.43 
/
 6  7  3  1  316.72  307.86  301.49  300.74  300.98 
             301.80  303.05  304.60  306.51  308.72 
             311.20  313.95  316.96  320.21  323.65 
             327.39  331.37  349.52  396.32 
/
 6  7  4  1  311.58  296.03  289.17  288.59  289.04 
             290.10  291.63  293.55  295.84  298.39 
             301.30  304.52  307.96  311.74  315.79 
             320.05  324.62  345.26  397.38 
/
 6  7  5  1  301.26  271.07  268.03  267.79  268.65 
             270.22  272.33  274.92  277.93  281.34 
             285.13  289.27  293.77  298.59  303.75 
             309.21  314.98  340.90  405.09 
/
 6  7  6  1  280.86  241.75  238.80  239.18  240.93 
             243.57  246.92  250.94  255.55  260.51 
             266.11  272.17  278.67  285.59  292.89 
             300.57  308.59  344.61  429.42 
/
 6  7  7  1  210.57  201.74  201.95  204.55  208.59 
             213.88  220.15  227.23  235.04  243.51 
             252.79  263.06  273.78  285.09  296.93 
             309.10  322.13  377.63  508.01 
/
 6  7  8  1  178.12  178.93  185.21  192.93  202.09 
             212.27  223.52  235.81  249.14  263.48 
             278.79  295.00  312.08  330.00  348.73 
             368.25  388.53  476.97  698.79 
/
 6  8  1  1  330.02  325.17  322.90  322.43  322.67 
             323.34  324.34  325.63  327.16  328.93 
             330.93  333.15  335.59  338.23  341.09 
             344.15  347.42  362.54  402.34 
/
 6  8  2  1  329.07  323.76  321.18  320.58  320.76 
             321.41  322.40  323.69  325.25  327.05 
             329.09  331.35  333.84  336.55  339.47 
             342.60  345.94  361.39  401.97 
/
 6  8  3  1  324.59  316.65  311.43  310.61  310.74 
             311.44  312.55  314.00  315.75  317.79 
             320.08  322.64  325.44  328.48  331.75 
             335.25  338.94  356.09  400.56 
/
 6  8  4  1  320.55  309.61  301.47  300.70  300.96 
             301.82  303.12  304.81  306.82  309.15 
             311.76  314.60  317.76  321.18  324.86 
             328.73  332.91  351.91  400.46 
/
 6  8  5  1  312.46  288.69  282.92  282.63  283.33 
             284.63  286.43  288.63  291.21  294.15 
             297.42  301.02  304.92  309.13  313.64 
             318.44  323.52  346.44  404.02 
/
 6  8  6  1  296.34  258.68  255.51  255.48  256.70 
             258.71  261.36  264.56  268.26  272.43 
             277.03  282.06  287.48  293.28  299.45 
             305.96  312.82  343.35  417.79 
/
 6  8  7  1  235.78  217.80  216.15  217.78  220.75 
             224.73  229.61  235.21  241.60  248.68 
             256.41  264.75  273.67  282.85  292.77 
             303.19  314.07  360.89  471.93 
/
 6  8  8  1  188.13  185.65  188.82  195.05  202.40 
             210.65  219.76  229.70  240.45  251.99 
             264.29  277.32  291.05  305.45  320.49 
             336.16  352.43  423.80  602.76 
/
 6  9  1  1  335.59  331.45  329.50  329.14  329.42 
             330.11  331.10  332.35  333.85  335.57 
             337.51  339.67  342.03  344.60  347.38 
             350.35  353.53  368.24  407.07 
/
 6  9  2  1  334.98  330.49  328.31  327.86  328.09 
             328.76  329.74  331.00  332.50  334.24 
             336.21  338.39  340.79  343.39  346.21 
             349.22  352.45  367.37  406.71 
/
 6  9  3  1  331.97  325.58  321.95  321.07  321.11 
             321.72  322.71  324.03  325.64  327.51 
             329.63  332.00  334.60  337.42  340.47 
             343.75  347.24  363.32  405.52 
/
 6  9  4  1  329.16  320.76  314.94  314.01  314.09 
             314.78  315.88  317.34  319.11  321.10 
             323.42  326.00  328.84  331.92  335.23 
             338.79  342.57  359.91  404.87 
/
 6  9  5  1  323.55  310.03  300.88  300.36  300.78 
             301.78  303.20  305.01  307.15  309.61 
             312.31  315.36  318.69  322.22  326.08 
             330.21  334.54  354.51  405.55 
/
 6  9  6  1  312.32  280.46  277.48  277.20  277.99 
             279.45  281.43  283.87  286.72  289.95 
             293.55  297.49  301.78  306.40  311.34 
             316.59  322.15  347.22  410.01 
/
 6  9  7  1  284.73  242.12  239.26  239.74  241.59 
             244.35  247.90  252.01  256.79  262.11 
             267.96  274.30  281.09  288.31  296.29 
             304.35  312.78  349.93  439.60 
/
 6  9  8  1  210.28  202.32  202.74  205.50  209.89 
             215.50  222.02  229.34  237.37  246.05 
             255.35  265.22  275.65  286.94  299.36 
             311.98  325.23  382.41  518.49 
/
 6 10  1  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  2  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  3  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  4  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  5  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  6  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  7  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 6 10  8  1  344.03  342.74  342.33  342.58  343.16 
             343.99  345.05  346.32  347.79  349.46 
             351.32  353.38  355.63  358.07  360.70 
             363.52  366.52  380.45  417.34 
/
 7  1  1  1  309.03  306.59  304.82  304.56  305.00 
             305.88  307.16  308.70  310.52  312.60 
             314.93  317.51  320.32  323.37  326.64 
             330.13  333.82  350.92  395.34 
/
 7  1  2  1  306.59  303.46  300.95  300.62  301.04 
             301.99  303.28  304.91  306.83  309.03 
             311.49  314.21  317.12  320.33  323.78 
             327.46  331.37  349.29  395.62 
/
 7  1  3  1  296.79  284.69  281.65  281.16  281.76 
             283.04  284.84  287.01  289.63  292.62 
             295.87  299.51  303.39  307.62  312.08 
             316.87  321.87  344.62  401.74 
/
 7  1  4  1  288.33  268.41  265.28  265.07  266.11 
             267.93  270.37  273.35  276.80  280.69 
             285.00  289.69  294.76  300.19  305.96 
             312.04  318.39  346.59  414.74 
/
 7  1  5  1  271.87  245.45  242.68  243.28  245.31 
             248.31  252.07  256.58  261.72  267.42 
             273.66  280.39  287.58  295.21  303.24 
             311.67  320.45  359.58  451.42 
/
 7  1  6  1  226.93  218.74  218.50  220.97  224.96 
             230.24  236.57  243.94  252.30  261.39 
             271.14  281.59  292.53  304.32  316.45 
             329.10  342.66  399.87  535.35 
/
 7  1  7  1  198.23  198.50  204.54  212.85  222.47 
             233.44  245.76  259.38  274.26  290.37 
             307.62  325.95  345.31  365.67  387.01 
             409.28  432.69  539.49  793.09 
/
 7  1  8  1  190.12  196.11  207.98  223.89  243.55 
             266.61  292.67  321.46  352.91  386.94 
             423.46  462.51  504.03  547.94  593.98 
             642.21  692.99  922.09 1466.79 
/
 7  2  1  1  313.59  311.18  309.53  309.34  309.80 
             310.69  311.91  313.43  315.21  317.26 
             319.54  322.07  324.83  327.82  331.04 
             334.47  338.13  354.93  398.73 
/
 7  2  2  1  311.25  308.21  305.89  305.61  306.07 
             306.98  308.25  309.84  311.71  313.86 
             316.26  318.92  321.82  324.95  328.27 
             331.87  335.70  353.26  398.78 
/
 7  2  3  1  301.87  290.61  287.51  287.03  287.59 
             288.80  290.50  292.61  295.05  297.88 
             301.04  304.45  308.21  312.25  316.52 
             321.12  325.93  347.83  403.16 
/
 7  2  4  1  293.92  274.52  271.49  271.26  272.21 
             273.91  276.19  278.98  282.21  285.87 
             289.92  294.34  299.13  304.26  309.67 
             315.40  321.42  348.26  413.66 
/
 7  2  5  1  278.34  251.47  248.60  249.02  250.85 
             253.62  257.16  261.37  266.11  271.45 
             277.31  283.64  290.31  297.50  305.09 
             313.06  321.40  358.09  446.18 
/
 7  2  6  1  232.31  223.82  223.09  225.22  228.85 
             233.62  239.42  246.17  253.76  262.10 
             271.24  280.91  291.17  301.99  313.36 
             325.60  337.64  391.96  518.90 
/
 7  2  7  1  201.32  199.97  205.21  212.96  221.87 
             231.97  243.27  255.76  269.38  284.08 
             299.82  316.56  334.24  352.83  372.30 
             392.62  413.77  511.71  742.52 
/
 7  2  8  1  190.90  196.55  207.26  221.40  238.82 
             259.28  282.41  307.96  335.84  366.00 
             398.39  432.97  469.69  508.53  549.25 
             591.86  636.36  838.88 1318.57 
/
 7  3  1  1  318.33  315.99  314.49  314.32  314.79 
             315.67  316.86  318.35  320.10  322.10 
             324.35  326.82  329.53  332.47  335.62 
             338.99  342.58  359.11  402.20 
/
 7  3  2  1  316.12  313.20  311.09  310.85  311.31 
             312.21  313.45  315.00  316.83  318.93 
             321.27  323.86  326.68  329.75  333.04 
             336.55  340.25  357.45  402.14 
/
 7  3  3  1  307.23  297.15  293.80  293.34  293.86 
             294.99  296.59  298.60  300.96  303.59 
             306.59  309.89  313.41  317.27  321.41 
             325.75  330.41  351.46  404.94 
/
 7  3  4  1  299.85  281.24  278.33  278.09  278.96 
             280.53  282.65  285.25  288.27  291.69 
             295.49  299.63  304.08  308.85  313.94 
             319.34  325.04  350.46  413.07 
/
 7  3  5  1  285.30  258.31  255.36  255.61  257.20 
             259.68  262.88  266.70  271.09  276.00 
             281.39  287.24  293.53  300.22  307.31 
             314.77  322.59  357.16  440.35 
/
 7  3  6  1  238.59  230.06  228.69  230.47  233.70 
             238.00  243.26  249.30  256.17  263.77 
             272.07  280.99  290.52  300.60  311.21 
             322.33  333.95  383.91  502.80 
/
 7  3  7  1  205.08  202.63  206.57  213.43  221.57 
             230.81  241.13  252.50  264.89  278.25 
             292.56  307.76  323.82  340.71  358.38 
             376.81  396.18  485.11  694.18 
/
 7  3  8  1  191.87  197.18  206.78  219.27  234.58 
             252.61  272.94  295.41  319.93  346.42 
             374.84  405.18  437.40  471.46  507.14 
             544.42  583.33  759.55 1182.01 
/
 7  4  1  1  324.26  321.41  319.86  319.65  320.08 
             320.93  322.09  323.54  325.25  327.20 
             329.39  331.82  334.47  337.34  340.43 
             343.74  347.26  363.49  405.92 
/
 7  4  2  1  322.20  318.83  316.72  316.46  316.87 
             317.76  318.96  320.46  322.24  324.27 
             326.55  329.07  331.83  334.81  338.02 
             341.45  345.06  361.87  405.66 
/
 7  4  3  1  313.77  304.75  300.63  300.16  300.63 
             301.68  303.19  305.07  307.30  309.78 
             312.62  315.76  319.17  322.78  326.73 
             330.93  335.33  355.55  407.08 
/
 7  4  4  1  307.00  288.69  285.87  285.62  286.41 
             287.86  289.83  292.21  294.99  298.14 
             301.64  305.48  309.63  314.11  318.87 
             323.95  329.29  353.34  413.04 
/
 7  4  5  1  293.59  266.11  263.11  263.19  264.56 
             266.76  269.62  273.07  277.04  281.50 
             286.41  291.76  297.52  303.68  310.22 
             317.11  324.35  356.54  434.72 
/
 7  4  6  1  255.32  237.69  235.49  236.84  239.64 
             243.46  248.21  253.67  259.93  266.76 
             274.35  282.35  291.10  300.41  309.93 
             320.23  331.02  377.04  487.14 
/
 7  4  7  1  209.77  206.91  209.09  214.80  221.98 
             230.28  239.58  249.86  261.04  273.11 
             286.01  299.72  314.20  329.41  345.33 
             361.93  380.08  460.32  647.85 
/
 7  4  8  1  193.05  197.98  206.57  217.53  230.91 
             246.65  264.34  283.89  305.22  328.26 
             352.96  379.29  407.24  436.77  467.69 
             499.98  533.63  684.74 1054.32 
/
 7  5  1  1  330.88  327.27  325.54  325.28  325.67 
             326.46  327.58  328.98  330.64  332.54 
             334.68  337.04  339.63  342.44  345.46 
             348.71  352.16  368.08  409.81 
/
 7  5  2  1  329.05  324.96  322.80  322.41  322.77 
             323.58  324.72  326.16  327.88  329.85 
             332.06  334.50  337.18  340.09  343.21 
             346.56  350.13  366.55  409.45 
/
 7  5  3  1  321.37  313.25  308.09  307.55  307.95 
             308.93  310.32  312.09  314.13  316.52 
             319.21  322.17  325.41  328.84  332.59 
             336.59  340.84  360.16  409.78 
/
 7  5  4  1  315.23  297.86  294.22  293.88  294.56 
             295.85  297.63  299.82  302.38  305.27 
             308.53  312.09  315.97  320.13  324.61 
             329.32  334.36  356.95  413.67 
/
 7  5  5  1  303.05  275.02  272.02  271.97  273.11 
             275.04  277.59  280.66  284.22  288.24 
             292.68  297.53  302.76  308.38  314.35 
             320.67  327.32  357.05  429.96 
/
 7  5  6  1  279.70  246.33  243.84  244.76  247.12 
             250.44  254.61  259.49  265.02  271.29 
             278.02  285.28  293.03  301.52  310.20 
             319.67  329.20  371.58  473.04 
/
 7  5  7  1  215.73  212.50  213.57  217.71  223.72 
             230.93  239.14  248.26  258.22  268.97 
             280.49  292.71  305.62  319.19  333.38 
             349.23  365.66  436.56  604.44 
/
 7  5  8  1  194.82  199.01  206.67  216.21  227.88 
             241.48  256.71  273.50  291.82  311.61 
             332.82  355.41  379.38  404.63  431.05 
             458.63  487.37  614.06  932.49 
/
 7  6  1  1  337.57  333.35  331.46  331.15  331.50 
             332.26  333.34  334.70  336.31  338.16 
             340.24  342.54  345.07  347.81  350.77 
             353.93  357.30  372.89  413.83 
/
 7  6  2  1  336.02  331.34  329.11  328.66  328.95 
             329.70  330.79  332.19  333.84  335.74 
             337.88  340.26  342.86  345.68  348.72 
             351.98  355.45  371.48  413.47 
/
 7  6  3  1  329.28  321.54  316.09  315.50  315.82 
             316.69  317.98  319.62  321.58  323.83 
             326.36  329.09  332.15  335.46  339.01 
             342.82  346.86  365.30  412.92 
/
 7  6  4  1  323.84  308.90  303.49  303.04  303.57 
             304.71  306.27  308.27  310.63  313.32 
             316.26  319.58  323.19  327.01  331.17 
             335.55  340.25  361.44  415.08 
/
 7  6  5  1  313.11  285.24  282.31  282.15  283.11 
             284.77  287.01  289.73  292.89  296.48 
             300.45  304.80  309.52  314.58  319.98 
             325.72  331.77  358.99  426.34 
/
 7  6  6  1  292.19  256.71  254.02  254.60  256.54 
             259.36  262.99  267.30  272.22  277.55 
             283.53  290.02  296.97  304.36  312.51 
             320.77  329.41  367.50  459.80 
/
 7  6  7  1  225.06  219.92  220.36  223.31  227.82 
             233.69  240.62  248.44  257.07  266.44 
             276.50  287.22  298.58  311.41  324.73 
             338.51  352.84  415.23  562.68 
/
 7  6  8  1  198.87  200.35  207.14  215.44  225.64 
             237.23  250.15  264.38  279.87  296.61 
             314.56  333.66  353.84  375.04  397.25 
             420.45  444.61  550.56  817.53 
/
 7  7  1  1  344.13  339.57  337.57  337.23  337.55 
             338.28  339.33  340.64  342.21  344.01 
             346.04  348.28  350.75  353.42  356.30 
             359.40  362.69  377.93  418.08 
/
 7  7  2  1  342.89  337.91  335.62  335.15  335.41 
             336.12  337.16  338.49  340.09  341.92 
             343.99  346.29  348.81  351.55  354.50 
             357.67  361.05  376.66  417.69 
/
 7  7  3  1  337.29  329.66  324.78  324.04  324.28 
             325.05  326.23  327.75  329.57  331.68 
             334.05  336.62  339.51  342.63  346.00 
             349.60  353.43  370.99  416.64 
/
 7  7  4  1  332.68  320.91  313.80  313.17  313.54 
             314.51  315.92  317.71  319.85  322.30 
             324.99  328.02  331.34  334.86  338.70 
             342.81  347.11  366.89  417.43 
/
 7  7  5  1  323.60  296.99  294.24  294.01  294.80 
             296.24  298.19  300.58  303.36  306.53 
             310.05  313.92  318.11  322.64  327.48 
             332.62  338.07  362.71  424.17 
/
 7  7  6  1  305.73  269.55  266.60  266.80  268.28 
             270.60  273.61  277.22  281.38  286.05 
             291.19  296.80  302.84  309.29  316.15 
             323.38  330.98  364.77  446.93 
/
 7  7  7  1  239.84  230.51  229.95  232.12  235.61 
             240.14  245.60  252.04  259.43  267.56 
             276.39  285.89  296.00  306.65  318.15 
             329.94  342.26  396.51  524.55 
/
 7  7  8  1  205.71  203.88  208.52  215.72  224.41 
             234.14  244.92  256.75  269.60  283.44 
             298.25  313.98  330.60  348.08  366.39 
             385.50  405.40  492.43  712.76 
/
 7  8  1  1  350.31  345.82  343.84  343.50  343.81 
             344.52  345.54  346.82  348.34  350.10 
             352.07  354.26  356.66  359.27  362.08 
             365.10  368.32  383.22  422.55 
/
 7  8  2  1  349.39  344.54  342.32  341.87  342.13 
             342.82  343.83  345.12  346.66  348.44 
             350.44  352.67  355.11  357.76  360.63 
             363.70  366.98  382.15  422.15 
/
 7  8  3  1  345.12  338.08  334.02  333.20  333.31 
             333.98  335.05  336.44  338.13  340.10 
             342.32  344.78  347.49  350.44  353.61 
             356.96  360.59  377.31  420.92 
/
 7  8  4  1  341.46  331.96  325.18  324.35  324.57 
             325.37  326.60  328.20  330.06  332.27 
             334.76  337.52  340.55  343.83  347.30 
             351.08  355.09  373.43  420.79 
/
 7  8  5  1  334.29  315.06  308.14  307.90  308.57 
             309.80  311.49  313.57  316.01  318.78 
             321.85  325.21  328.89  332.85  337.10 
             341.63  346.44  368.32  423.88 
/
 7  8  6  1  320.07  285.61  282.59  282.49  283.55 
             285.35  287.74  290.64  294.02  297.84 
             302.08  306.71  311.73  317.12  322.88 
             328.98  335.41  364.34  436.02 
/
 7  8  7  1  279.59  247.21  244.72  245.90  248.50 
             252.04  256.43  261.64  267.46  274.05 
             281.13  288.96  297.15  306.10  315.28 
             325.25  335.33  380.69  489.13 
/
 7  8  8  1  216.29  213.37  214.77  219.51  225.97 
             233.56  242.10  251.54  261.82  272.90 
             284.75  297.34  310.64  324.62  339.25 
             354.52  370.41  441.52  617.64 
/
 7  9  1  1  355.84  351.93  350.17  349.90  350.24 
             350.95  351.95  353.20  354.69  356.40 
             358.33  360.47  362.81  365.35  368.10 
             371.05  374.20  388.76  427.27 
/
 7  9  2  1  355.26  351.07  349.13  348.78  349.07 
             349.76  350.75  352.01  353.51  355.23 
             357.18  359.34  361.71  364.28  367.06 
             370.05  373.23  387.97  426.92 
/
 7  9  3  1  352.42  346.61  343.59  342.78  342.85 
             343.44  344.40  345.69  347.25  349.07 
             351.14  353.45  355.99  358.75  361.74 
             364.94  368.36  384.18  425.77 
/
 7  9  4  1  349.87  342.28  337.58  336.56  336.61 
             337.24  338.28  339.67  341.37  343.35 
             345.59  348.09  350.84  353.82  357.05 
             360.49  364.17  381.08  425.23 
/
 7  9  5  1  344.86  333.85  324.95  324.33  324.66 
             325.57  326.91  328.57  330.60  332.94 
             335.58  338.49  341.62  345.08  348.79 
             352.70  356.93  376.23  425.92 
/
 7  9  6  1  334.87  307.31  303.22  302.96  303.69 
             305.05  306.90  309.17  311.84  314.87 
             318.25  321.97  326.01  330.37  335.05 
             340.02  345.30  369.26  429.99 
/
 7  9  7  1  310.44  270.05  267.13  267.43  269.05 
             271.55  274.75  278.59  283.01  287.96 
             293.42  299.36  305.77  312.61  319.87 
             327.54  335.59  371.36  458.16 
/
 7  9  8  1  240.54  230.80  230.74  233.06  236.70 
             241.41  247.09  253.66  261.03  269.10 
             277.83  287.56  298.12  309.19  320.77 
             332.97  345.59  401.60  534.32 
/
 7 10  1  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  2  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  3  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  4  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  5  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  6  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  7  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 7 10  8  1  364.13  362.84  362.43  362.67  363.26 
             364.09  365.15  366.42  367.89  369.55 
             371.42  373.47  375.72  378.16  380.79 
             383.61  386.62  400.53  437.41 
/
 8  1  1  1  329.26  327.50  326.41  326.36  326.88 
             327.79  329.02  330.53  332.31  334.34 
             336.61  339.11  341.85  344.82  348.01 
             351.42  355.05  371.77  415.51 
/
 8  1  2  1  326.78  324.62  323.14  322.97  323.46 
             324.38  325.69  327.27  329.12  331.24 
             333.62  336.24  339.10  342.20  345.53 
             349.10  352.89  370.30  415.75 
/
 8  1  3  1  317.09  308.81  306.16  305.76  306.33 
             307.51  309.16  311.22  313.58  316.34 
             319.43  322.82  326.44  330.42  334.61 
             339.14  343.93  365.62  420.96 
/
 8  1  4  1  309.71  293.87  291.11  290.93  291.87 
             293.53  295.76  298.49  301.66  305.25 
             309.22  313.52  318.17  323.18  328.50 
             334.13  340.08  366.63  432.46 
/
 8  1  5  1  295.34  272.04  269.33  269.73  271.50 
             274.20  277.66  281.77  286.49  291.77 
             297.55  303.84  310.59  317.79  325.40 
             333.42  341.82  379.02  468.41 
/
 8  1  6  1  253.82  246.05  245.18  247.28  250.88 
             255.66  261.45  268.23  275.83  284.24 
             293.40  303.44  313.97  325.12  336.85 
             349.15  362.01  418.07  551.63 
/
 8  1  7  1  224.48  222.52  227.42  235.17  244.32 
             254.82  266.66  279.81  294.22  309.82 
             326.58  344.45  363.37  383.32  404.25 
             426.14  450.26  555.54  807.07 
/
 8  1  8  1  213.80  219.05  230.17  245.27  264.10 
             286.34  311.57  339.62  370.39  403.78 
             439.76  478.29  519.35  562.70  608.26 
             656.06  707.10  934.60 1476.48 
/
 8  2  1  1  333.81  332.04  331.01  331.01  331.54 
             332.45  333.67  335.16  336.91  338.90 
             341.13  343.60  346.29  349.20  352.34 
             355.70  359.28  375.73  418.85 
/
 8  2  2  1  331.44  329.30  327.93  327.78  328.27 
             329.21  330.46  332.01  333.82  335.90 
             338.22  340.79  343.60  346.64  349.91 
             353.40  357.12  374.24  418.90 
/
 8  2  3  1  322.09  314.56  311.71  311.33  311.87 
             313.00  314.57  316.54  318.86  321.50 
             324.39  327.64  331.18  335.00  339.03 
             343.39  348.01  368.96  422.58 
/
 8  2  4  1  315.10  299.74  297.09  296.91  297.79 
             299.35  301.46  304.01  306.98  310.30 
             314.03  318.09  322.50  327.23  332.27 
             337.63  343.27  368.65  431.83 
/
 8  2  5  1  301.47  277.93  275.16  275.43  277.01 
             279.47  282.64  286.42  290.78  295.66 
             301.04  306.88  313.17  319.88  327.01 
             334.52  342.41  377.47  462.30 
/
 8  2  6  1  259.17  251.41  249.99  251.76  254.99 
             259.36  264.64  270.83  277.84  285.61 
             294.10  303.27  313.08  323.23  334.20 
             345.70  357.75  409.89  534.31 
/
 8  2  7  1  227.73  225.20  228.60  235.44  243.82 
             253.47  264.33  276.37  289.54  303.80 
             319.09  335.39  352.66  370.84  389.92 
             409.86  431.91  527.54  756.75 
/
 8  2  8  1  214.59  219.48  229.51  242.95  259.65 
             279.38  301.74  326.59  353.82  383.39 
             415.22  449.29  485.55  523.87  564.11 
             606.26  650.38  851.96 1330.08 
/
 8  3  1  1  338.54  336.78  335.82  335.85  336.39 
             337.30  338.50  339.97  341.69  343.65 
             345.85  348.27  350.91  353.78  356.86 
             360.16  363.68  379.87  422.34 
/
 8  3  2  1  336.30  334.20  332.92  332.81  333.31 
             334.21  335.45  336.96  338.74  340.77 
             343.05  345.56  348.31  351.28  354.49 
             357.91  361.56  378.36  422.28 
/
 8  3  3  1  327.38  320.89  317.67  317.32  317.85 
             318.93  320.43  322.31  324.46  326.99 
             329.81  332.93  336.26  339.92  343.85 
             348.04  352.43  372.67  424.59 
/
 8  3  4  1  320.83  306.25  303.63  303.42  304.22 
             305.65  307.59  309.96  312.73  315.87 
             319.38  323.20  327.36  331.82  336.60 
             341.70  347.03  371.13  431.69 
/
 8  3  5  1  308.06  284.58  281.78  281.92  283.31 
             285.53  288.41  291.88  295.87  300.36 
             305.32  310.71  316.54  322.78  329.40 
             336.40  343.77  376.64  456.73 
/
 8  3  6  1  270.33  257.82  255.71  257.12  260.01 
             263.90  268.75  274.36  280.70  287.83 
             295.65  303.93  312.99  322.65  332.55 
             343.28  354.13  402.80  518.44 
/
 8  3  7  1  231.67  228.84  230.86  236.57  243.99 
             252.69  262.53  273.45  285.41  298.35 
             312.22  327.01  342.65  359.13  376.41 
             394.53  414.83  501.95  708.65 
/
 8  3  8  1  215.51  220.09  229.12  241.00  255.68 
             273.05  292.70  314.51  338.41  364.34 
             392.23  422.09  453.86  487.39  522.58 
             559.43  597.93  773.37 1192.36 
/
 8  4  1  1  344.46  342.14  341.04  341.03  341.55 
             342.43  343.61  345.04  346.73  348.65 
             350.80  353.17  355.76  358.58  361.60 
             364.84  368.30  384.22  426.02 
/
 8  4  2  1  342.37  339.74  338.36  338.23  338.69 
             339.56  340.74  342.21  343.94  345.92 
             348.14  350.59  353.28  356.18  359.32 
             362.67  366.25  382.72  425.83 
/
 8  4  3  1  333.85  328.15  324.15  323.77  324.25 
             325.27  326.69  328.47  330.58  332.92 
             335.62  338.59  341.84  345.34  349.05 
             353.06  357.33  376.80  426.98 
/
 8  4  4  1  327.76  313.56  310.81  310.53  311.23 
             312.53  314.33  316.54  319.13  322.07 
             325.33  328.95  332.82  337.05  341.52 
             346.34  351.37  374.26  432.08 
/
 8  4  5  1  315.95  292.11  289.30  289.33  290.54 
             292.52  295.13  298.27  301.91  306.01 
             310.55  315.51  320.87  326.62  332.74 
             339.23  346.06  376.69  451.86 
/
 8  4  6  1  293.65  264.83  262.62  263.62  266.10 
             269.61  273.89  278.96  284.83  291.24 
             298.25  305.82  314.15  322.77  331.88 
             341.78  351.79  396.41  504.09 
/
 8  4  7  1  236.54  233.41  234.63  238.91  245.22 
             252.86  261.62  271.39  282.11  293.72 
             306.19  319.46  333.51  348.31  363.83 
             381.12  399.06  476.83  662.60 
/
 8  4  8  1  216.98  220.94  229.02  239.43  252.30 
             267.44  284.52  303.47  324.22  346.72 
             370.92  396.78  424.30  453.31  483.74 
             515.59  548.85  699.10 1065.16 
/
 8  5  1  1  351.08  347.93  346.59  346.50  346.98 
             347.82  348.96  350.35  352.00  353.87 
             355.98  358.30  360.84  363.60  366.57 
             369.75  373.14  388.77  429.90 
/
 8  5  2  1  349.24  345.78  344.17  343.97  344.40 
             345.22  346.37  347.79  349.47  351.39 
             353.55  355.94  358.56  361.39  364.45 
             367.73  371.22  387.32  429.60 
/
 8  5  3  1  341.51  335.43  331.23  330.77  331.19 
             332.13  333.46  335.14  337.13  339.36 
             341.92  344.75  347.84  351.19  354.79 
             358.63  362.67  381.40  429.80 
/
 8  5  4  1  335.90  322.51  318.75  318.37  318.96 
             320.15  321.80  323.80  326.21  328.96 
             332.04  335.36  339.04  342.94  347.19 
             351.71  356.45  378.06  433.12 
/
 8  5  5  1  325.11  300.65  297.89  297.82  298.86 
             300.62  302.96  305.79  309.08  312.80 
             316.93  321.45  326.34  331.61  337.22 
             343.18  349.48  377.82  447.88 
/
 8  5  6  1  304.42  273.21  270.79  271.54  273.64 
             276.68  280.55  285.03  290.22  296.00 
             302.34  309.22  316.60  324.45  332.76 
             341.49  350.65  391.68  489.49 
/
 8  5  7  1  242.68  239.23  239.90  243.17  248.12 
             254.52  262.07  270.60  280.02  290.27 
             301.30  313.07  325.53  338.79  353.57 
             368.93  384.84  454.08  619.50 
/
 8  5  8  1  220.14  222.02  229.22  238.30  249.58 
             262.63  277.30  293.56  311.35  330.63 
             351.37  373.52  397.02  421.76  447.72 
             474.89  503.24  629.61  945.75 
/
 8  6  1  1  357.78  353.94  352.37  352.21  352.63 
             353.43  354.53  355.89  357.49  359.32 
             361.38  363.65  366.14  368.84  371.75 
             374.86  378.19  393.53  433.97 
/
 8  6  2  1  356.22  352.07  350.25  349.99  350.37 
             351.15  352.25  353.62  355.25  357.12 
             359.22  361.55  364.10  366.86  369.85 
             373.04  376.45  392.18  433.58 
/
 8  6  3  1  349.48  342.94  338.90  338.31  338.63 
             339.47  340.70  342.27  344.14  346.30 
             348.73  351.42  354.36  357.55  360.99 
             364.60  368.51  386.47  433.07 
/
 8  6  4  1  344.44  333.00  327.54  327.02  327.50 
             328.52  330.01  331.88  334.10  336.65 
             339.43  342.57  346.00  349.70  353.60 
             357.84  362.33  382.66  434.90 
/
 8  6  5  1  334.87  310.38  307.73  307.59  308.48 
             310.03  312.10  314.64  317.60  320.95 
             324.67  328.76  333.20  337.97  343.08 
             348.52  354.27  380.28  445.03 
/
 8  6  6  1  316.27  283.34  280.66  281.07  282.78 
             285.37  288.68  292.63  297.16  302.24 
             307.84  313.93  320.49  327.50  334.94 
             342.79  351.04  387.70  476.96 
/
 8  6  7  1  255.38  246.86  247.00  249.55  253.53 
             258.66  264.82  271.93  279.92  288.71 
             298.30  309.10  320.57  332.66  345.36 
             358.52  372.61  433.24  579.19 
/
 8  6  8  1  225.19  224.12  229.83  237.81  247.62 
             258.72  271.16  284.91  299.94  316.22 
             333.69  352.29  372.00  392.77  414.57 
             437.38  461.17  565.83  831.50 
/
 8  7  1  1  364.33  360.08  358.34  358.12  358.50 
             359.27  360.33  361.64  363.20  364.99 
             367.00  369.22  371.65  374.29  377.14 
             380.20  383.46  398.51  438.25 
/
 8  7  2  1  363.10  358.53  356.58  356.26  356.60 
             357.34  358.40  359.73  361.31  363.12 
             365.17  367.43  369.91  372.60  375.51 
             378.62  381.95  397.31  437.81 
/
 8  7  3  1  357.55  350.85  347.11  346.39  346.60 
             347.35  348.48  349.94  351.70  353.73 
             356.02  358.57  361.36  364.39  367.66 
             371.16  374.89  392.03  436.85 
/
 8  7  4  1  353.22  343.86  337.22  336.57  336.88 
             337.78  339.11  340.80  342.83  345.17 
             347.79  350.63  353.80  357.24  360.93 
             364.87  369.00  388.11  437.49 
/
 8  7  5  1  345.08  322.62  319.06  318.87  319.63 
             320.99  322.83  325.09  327.72  330.72 
             334.05  337.72  341.71  346.01  350.62 
             355.51  360.67  384.19  443.55 
/
 8  7  6  1  329.11  295.72  292.88  292.99  294.30 
             296.40  299.15  302.45  306.27  310.58 
             315.35  320.56  326.19  332.24  338.68 
             345.49  352.68  384.89  464.41 
/
 8  7  7  1  267.01  258.25  257.04  258.84  262.01 
             266.21  271.34  277.28  284.05  291.58 
             299.82  308.75  318.33  328.54  339.35 
             350.73  362.67  415.12  540.43 
/
 8  7  8  1  232.37  229.93  232.57  238.80  246.79 
             256.00  266.32  277.71  290.14  303.56 
             317.94  333.26  349.48  366.57  384.50 
             403.25  422.77  508.52  727.47 
/
 8  8  1  1  370.50  366.24  364.46  364.21  364.57 
             365.30  366.33  367.61  369.13  370.88 
             372.84  375.01  377.39  379.98  382.76 
             385.76  388.95  403.71  442.74 
/
 8  8  2  1  369.61  365.06  363.08  362.75  363.07 
             363.79  364.81  366.10  367.63  369.39 
             371.38  373.58  375.99  378.62  381.45 
             384.49  387.73  402.71  442.31 
/
 8  8  3  1  365.41  359.04  355.86  355.00  355.11 
             355.75  356.77  358.12  359.75  361.72 
             363.88  366.28  368.92  371.80  374.90 
             378.23  381.77  398.13  441.16 
/
 8  8  4  1  361.96  353.43  347.92  347.05  347.22 
             347.96  349.13  350.65  352.49  354.61 
             357.01  359.68  362.61  365.72  369.13 
             372.79  376.68  394.53  441.00 
/
 8  8  5  1  355.49  340.17  332.31  332.02  332.62 
             333.77  335.34  337.30  339.60  342.20 
             345.12  348.35  351.87  355.67  359.74 
             364.09  368.73  389.83  443.82 
/
 8  8  6  1  342.69  311.03  308.21  308.09  309.06 
             310.72  312.94  315.64  318.79  322.36 
             326.33  330.69  335.41  340.51  345.95 
             351.73  357.85  385.52  454.94 
/
 8  8  7  1  312.46  274.26  271.93  272.78  275.09 
             278.34  282.44  287.25  292.73  298.83 
             305.53  312.78  320.80  329.12  337.92 
             347.18  357.28  400.89  506.75 
/
 8  8  8  1  243.32  240.14  241.12  244.64  250.05 
             256.89  264.82  273.72  283.50  294.12 
             305.53  317.69  330.56  344.14  358.38 
             373.27  388.79  460.13  633.12 
/
 8  9  1  1  376.02  372.26  370.63  370.42  370.79 
             371.51  372.52  373.78  375.27  376.97 
             378.89  381.02  383.34  385.88  388.61 
             391.54  394.67  409.14  447.44 
/
 8  9  2  1  375.45  371.46  369.68  369.41  369.74 
             370.45  371.46  372.71  374.21  375.93 
             377.86  380.00  382.35  384.91  387.67 
             390.63  393.79  408.41  447.09 
/
 8  9  3  1  372.71  367.32  364.63  363.97  364.11 
             364.73  365.71  366.99  368.54  370.33 
             372.37  374.64  377.13  379.85  382.78 
             385.93  389.29  404.84  445.84 
/
 8  9  4  1  370.30  363.34  359.44  358.45  358.46 
             359.05  360.06  361.40  363.05  364.97 
             367.15  369.59  372.26  375.18  378.32 
             381.70  385.30  401.92  445.48 
/
 8  9  5  1  365.75  355.69  348.10  347.36  347.61 
             348.44  349.70  351.32  353.27  355.53 
             358.00  360.82  363.90  367.25  370.86 
             374.65  378.75  397.55  446.18 
/
 8  9  6  1  356.70  332.96  327.72  327.50  328.21 
             329.50  331.26  333.43  335.96  338.85 
             342.08  345.63  349.50  353.67  358.15 
             362.93  368.00  391.12  450.35 
/
 8  9  7  1  334.65  296.41  293.54  293.72  295.15 
             297.40  300.33  303.85  307.91  312.49 
             317.56  323.09  329.08  335.49  342.33 
             349.56  357.19  391.34  475.43 
/
 8  9  8  1  267.89  258.54  257.67  259.65  262.91 
             267.18  272.33  278.31  285.31  293.07 
             301.55  310.78  320.63  331.25  342.32 
             353.98  366.21  420.55  551.68 
/
 8 10  1  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  2  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  3  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  4  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  5  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  6  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  7  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 8 10  8  1  384.23  382.94  382.53  382.77  383.35 
             384.19  385.25  386.51  387.98  389.65 
             391.51  393.57  395.81  398.25  400.88 
             403.70  406.70  420.61  457.48 
/
 9  1  1  1  349.53  348.03  347.29  347.43  348.04 
             349.00  350.26  351.77  353.53  355.54 
             357.77  360.24  362.93  365.84  368.98 
             372.33  375.91  392.35  435.52 
/
 9  1  2  1  346.93  345.31  344.36  344.39  344.97 
             345.92  347.19  348.75  350.57  352.64 
             354.96  357.53  360.32  363.35  366.61 
             370.10  373.82  390.92  435.74 
/
 9  1  3  1  336.94  331.53  329.29  329.02  329.60 
             330.73  332.30  334.24  336.53  339.15 
             342.07  345.23  348.74  352.53  356.59 
             360.86  365.47  386.43  440.38 
/
 9  1  4  1  330.23  318.04  315.58  315.44  316.32 
             317.86  319.91  322.42  325.34  328.65 
             332.34  336.37  340.76  345.45  350.44 
             355.81  361.42  386.72  450.79 
/
 9  1  5  1  317.50  297.27  294.72  295.03  296.62 
             299.07  302.23  306.00  310.35  315.23 
             320.61  326.46  332.78  339.54  346.72 
             354.30  362.28  397.93  484.26 
/
 9  1  6  1  279.34  272.53  270.97  272.78  276.07 
             280.49  285.87  292.20  299.37  307.33 
             316.05  325.30  335.38  346.11  357.47 
             369.08  381.57  435.96  567.21 
/
 9  1  7  1  249.92  247.45  250.60  257.46  266.07 
             276.14  287.55  300.27  314.25  329.43 
             345.77  363.23  381.76  401.32  421.88 
             444.25  468.14  571.39  821.56 
/
 9  1  8  1  237.06  241.70  252.20  266.63  284.76 
             306.27  330.79  358.18  388.35  421.17 
             456.65  494.72  535.30  578.15  623.27 
             670.69  721.91  947.97 1486.71 
/
 9  2  1  1  354.06  352.55  351.84  352.00  352.62 
             353.58  354.82  356.31  358.05  360.03 
             362.23  364.66  367.31  370.18  373.27 
             376.57  380.10  396.31  438.91 
/
 9  2  2  1  351.58  349.95  349.05  349.11  349.69 
             350.64  351.90  353.42  355.21  357.25 
             359.53  362.04  364.79  367.76  370.96 
             374.39  378.04  394.84  438.92 
/
 9  2  3  1  341.93  337.26  334.63  334.39  334.95 
             336.05  337.56  339.43  341.63  344.15 
             346.90  350.00  353.38  357.04  360.96 
             365.09  369.53  389.82  442.24 
/
 9  2  4  1  335.49  323.78  321.33  321.16  321.95 
             323.40  325.32  327.69  330.46  333.60 
             337.08  340.94  345.06  349.50  354.31 
             359.36  364.76  388.96  450.54 
/
 9  2  5  1  323.38  303.03  300.46  300.67  302.10 
             304.34  307.25  310.74  314.77  319.30 
             324.30  329.77  335.66  341.98  348.70 
             355.82  363.32  396.90  478.75 
/
 9  2  6  1  286.60  277.73  275.88  277.37  280.31 
             284.34  289.28  295.05  301.67  308.91 
             316.99  325.74  334.93  344.93  355.24 
             366.39  377.71  428.67  551.10 
/
 9  2  7  1  253.28  250.56  252.59  258.32  266.01 
             275.13  285.53  297.13  309.88  323.73 
             338.62  354.52  371.39  389.19  407.90 
             428.60  450.26  544.36  771.59 
/
 9  2  8  1  237.86  242.18  251.64  264.47  280.55 
             299.63  321.34  345.56  372.22  401.26 
             432.61  466.21  502.01  539.83  579.62 
             621.39  665.16  865.35 1340.96 
/
 9  3  1  1  358.77  357.26  356.60  356.77  357.39 
             358.34  359.57  361.04  362.75  364.70 
             366.87  369.26  371.87  374.69  377.73 
             380.99  384.46  400.44  442.44 
/
 9  3  2  1  356.44  354.81  353.96  354.05  354.63 
             355.57  356.81  358.31  360.07  362.07 
             364.30  366.76  369.46  372.37  375.51 
             378.88  382.46  398.96  442.28 
/
 9  3  3  1  347.21  343.32  340.34  340.10  340.64 
             341.69  343.13  344.92  347.04  349.45 
             352.16  355.14  358.39  361.91  365.63 
             369.67  373.96  393.57  444.35 
/
 9  3  4  1  341.10  330.04  327.59  327.38  328.10 
             329.45  331.27  333.45  336.08  339.06 
             342.32  345.97  349.86  354.13  358.63 
             363.48  368.56  391.69  450.70 
/
 9  3  5  1  329.72  309.50  306.93  307.05  308.32 
             310.36  313.02  316.23  319.94  324.12 
             328.76  333.82  339.29  345.17  351.44 
             358.08  365.09  396.59  473.81 
/
 9  3  6  1  308.55  283.63  281.72  282.84  285.42 
             289.07  293.53  298.81  304.80  311.58 
             318.90  326.80  335.27  344.54  354.08 
             364.11  375.00  422.04  535.48 
/
 9  3  7  1  257.34  254.37  255.78  260.20  266.80 
             274.89  284.21  294.67  306.18  318.69 
             332.15  346.52  361.77  377.86  394.88 
             413.82  433.50  518.46  723.67 
/
 9  3  8  1  239.08  242.79  251.28  262.64  276.82 
             293.61  312.66  333.90  357.25  382.67 
             410.11  439.53  470.83  503.87  538.62 
             575.08  613.24  787.85 1203.74 
/
 9  4  1  1  364.67  362.58  361.75  361.87  362.46 
             363.38  364.57  366.01  367.69  369.60 
             371.73  374.08  376.64  379.42  382.41 
             385.62  389.03  404.76  446.16 
/
 9  4  2  1  362.50  360.30  359.30  359.34  359.90 
             360.81  362.01  363.48  365.19  367.15 
             369.33  371.74  374.38  377.24  380.31 
             383.61  387.12  403.30  445.86 
/
 9  4  3  1  353.67  349.49  346.57  346.30  346.82 
             347.81  349.19  350.90  352.93  355.24 
             357.77  360.63  363.75  367.14  370.77 
             374.66  378.79  397.71  446.86 
/
 9  4  4  1  347.87  337.15  334.47  334.20  334.86 
             336.05  337.74  339.84  342.30  345.03 
             348.15  351.59  355.26  359.29  363.61 
             368.14  373.00  395.00  451.40 
/
 9  4  5  1  337.31  316.79  314.25  314.27  315.40 
             317.24  319.66  322.59  325.99  329.84 
             334.10  338.77  343.82  349.26  355.07 
             361.24  367.75  397.15  469.59 
/
 9  4  6  1  317.32  290.57  288.42  289.33  291.61 
             294.86  298.89  303.70  309.07  315.15 
             321.82  329.06  336.84  345.12  353.88 
             363.48  373.19  416.24  521.63 
/
 9  4  7  1  262.33  259.09  259.99  263.57  268.92 
             275.83  283.98  293.21  303.44  314.59 
             326.61  339.46  353.10  367.50  383.81 
             400.54  418.04  494.31  677.84 
/
 9  4  8  1  241.56  243.60  251.24  261.20  273.66 
             288.27  304.83  323.26  343.51  365.54 
             389.29  414.75  441.79  470.31  500.32 
             531.79  564.70  714.46 1078.17 
/
 9  5  1  1  371.28  368.34  367.23  367.26  367.80 
             368.67  369.82  371.23  372.87  374.73 
             376.82  379.12  381.64  384.37  387.30 
             390.45  393.81  409.28  450.06 
/
 9  5  2  1  369.38  366.29  365.02  364.97  365.47 
             366.34  367.50  368.92  370.59  372.49 
             374.63  376.98  379.56  382.36  385.37 
             388.59  392.03  407.89  449.66 
/
 9  5  3  1  361.42  356.45  353.42  353.04  353.47 
             354.39  355.69  357.30  359.23  361.43 
             363.91  366.64  369.63  372.82  376.31 
             380.05  384.02  402.28  449.79 
/
 9  5  4  1  355.99  345.96  342.10  341.72  342.27 
             343.39  344.95  346.84  349.13  351.74 
             354.67  357.82  361.34  365.13  369.14 
             373.46  378.06  398.94  452.72 
/
 9  5  5  1  346.30  325.02  322.55  322.50  323.48 
             325.14  327.33  329.99  333.09  336.60 
             340.50  344.78  349.43  354.42  359.77 
             365.45  371.47  398.66  466.23 
/
 9  5  6  1  327.69  298.80  296.42  297.02  298.93 
             301.75  305.32  309.56  314.42  319.87 
             325.86  332.38  339.41  346.91  354.88 
             363.29  372.12  411.46  507.54 
/
 9  5  7  1  270.40  265.06  265.48  268.39  272.83 
             278.53  285.37  293.27  302.13  311.86 
             322.40  333.70  346.38  359.88  373.98 
             388.71  404.18  471.93  635.02 
/
 9  5  8  1  245.48  245.03  251.54  260.24  271.17 
             283.74  297.94  313.74  331.09  349.93 
             370.25  391.96  414.98  439.29  464.85 
             491.65  519.66  645.57  958.41 
/
 9  6  1  1  377.96  374.31  372.93  372.87  373.35 
             374.18  375.29  376.65  378.25  380.07 
             382.12  384.37  386.84  389.52  392.40 
             395.49  398.79  414.00  454.15 
/
 9  6  2  1  376.38  372.53  371.00  370.86  371.31 
             372.13  373.24  374.62  376.24  378.09 
             380.17  382.47  384.99  387.72  390.66 
             393.82  397.18  412.72  453.68 
/
 9  6  3  1  369.48  363.84  360.83  360.28  360.60 
             361.42  362.66  364.18  366.00  368.10 
             370.45  373.06  375.86  378.97  382.31 
             385.90  389.71  407.28  453.16 
/
 9  6  4  1  364.55  356.27  350.49  349.98  350.40 
             351.38  352.80  354.58  356.70  359.13 
             361.86  364.87  368.09  371.65  375.47 
             379.54  383.81  403.60  454.74 
/
 9  6  5  1  355.90  334.36  332.00  331.90  332.76 
             334.24  336.21  338.62  341.43  344.61 
             348.16  352.05  356.29  360.86  365.74 
             370.95  376.44  401.32  463.97 
/
 9  6  6  1  339.11  308.68  306.11  306.43  307.97 
             310.34  313.38  317.03  321.24  325.98 
             331.21  336.91  343.08  349.70  356.74 
             364.19  372.04  407.21  493.99 
/
 9  6  7  1  281.37  273.05  272.76  275.03  278.65 
             283.37  289.05  295.64  303.41  311.94 
             321.32  331.46  342.37  353.85  365.98 
             379.08  392.51  452.09  594.99 
/
 9  6  8  1  250.74  248.72  252.78  260.12  269.43 
             280.12  292.14  305.48  320.09  335.93 
             352.97  371.16  390.47  410.87  432.31 
             454.77  478.21  582.59  846.15 
/
 9  7  1  1  384.51  380.41  378.83  378.68  379.11 
             379.90  380.97  382.30  383.85  385.63 
             387.63  389.84  392.25  394.88  397.71 
             400.74  403.98  418.93  458.43 
/
 9  7  2  1  383.26  378.94  377.21  377.00  377.39 
             378.16  379.24  380.57  382.14  383.95 
             385.97  388.21  390.67  393.34  396.21 
             399.30  402.59  417.79  457.95 
/
 9  7  3  1  377.63  371.63  368.71  368.04  368.24 
             368.98  370.09  371.51  373.23  375.21 
             377.44  379.93  382.65  385.61  388.81 
             392.24  395.89  412.75  456.93 
/
 9  7  4  1  373.37  365.10  359.74  359.08  359.36 
             360.23  361.51  363.09  365.04  367.28 
             369.81  372.61  375.67  378.99  382.57 
             386.33  390.39  409.04  457.50 
/
 9  7  5  1  365.97  347.05  342.83  342.71  343.46 
             344.78  346.55  348.71  351.23  354.07 
             357.24  360.73  364.51  368.61  373.00 
             377.69  382.67  405.35  463.04 
/
 9  7  6  1  351.47  320.64  317.98  318.05  319.26 
             321.21  323.76  326.85  330.43  334.47 
             338.96  343.88  349.20  354.92  361.04 
             367.53  374.39  405.33  482.60 
/
 9  7  7  1  298.37  285.10  283.13  284.66  287.55 
             291.47  296.26  301.85  308.28  315.46 
             323.21  331.76  340.99  350.60  361.04 
             372.08  383.31  434.57  557.70 
/
 9  7  8  1  258.16  255.53  257.34  262.33  269.51 
             278.12  287.93  298.88  310.88  323.89 
             337.89  352.81  368.65  385.37  402.94 
             421.34  440.54  526.24  742.75 
/
 9  8  1  1  390.66  386.52  384.86  384.67  385.06 
             385.81  386.85  388.14  389.66  391.40 
             393.35  395.51  397.88  400.45  403.23 
             406.20  409.38  424.07  462.91 
/
 9  8  2  1  389.77  385.40  383.60  383.34  383.70 
             384.44  385.48  386.77  388.30  390.06 
             392.03  394.22  396.61  399.22  402.03 
             405.04  408.26  423.13  462.46 
/
 9  8  3  1  385.56  379.69  376.90  376.23  376.40 
             377.06  378.09  379.42  381.03  382.90 
             385.02  387.38  389.97  392.79  395.83 
             399.10  402.59  418.71  461.16 
/
 9  8  4  1  382.16  374.42  369.87  369.04  369.17 
             369.87  370.99  372.49  374.27  376.27 
             378.60  381.19  384.03  387.12  390.45 
             394.02  397.83  415.36  461.10 
/
 9  8  5  1  376.24  364.00  355.67  355.25  355.75 
             356.82  358.31  360.18  362.33  364.86 
             367.69  370.75  374.16  377.86  381.76 
             386.00  390.51  411.00  463.72 
/
 9  8  6  1  364.55  335.32  332.72  332.62  333.53 
             335.10  337.20  339.76  342.75  346.14 
             349.91  354.06  358.57  363.43  368.64 
             374.18  380.06  406.73  474.28 
/
 9  8  7  1  336.95  300.09  297.79  298.58  300.70 
             303.72  307.59  312.08  317.29  323.12 
             329.52  336.50  344.01  352.02  360.53 
             369.51  378.94  421.47  523.90 
/
 9  8  8  1  269.36  266.05  266.75  269.89  274.58 
             280.60  287.87  296.19  305.46  315.60 
             326.55  338.29  350.76  363.93  377.80 
             392.33  407.50  478.55  649.04 
/
 9  9  1  1  396.16  392.48  390.94  390.77  391.15 
             391.89  392.91  394.17  395.66  397.36 
             399.27  401.39  403.71  406.24  408.96 
             411.88  414.99  429.41  467.59 
/
 9  9  2  1  395.61  391.74  390.07  389.85  390.21 
             390.94  391.95  393.21  394.70  396.42 
             398.34  400.47  402.81  405.36  408.10 
             411.04  414.19  428.73  467.23 
/
 9  9  3  1  392.90  387.83  385.39  384.84  385.04 
             385.69  386.69  387.96  389.50  391.28 
             393.29  395.53  397.99  400.67  403.57 
             406.68  410.00  425.35  465.92 
/
 9  9  4  1  390.54  384.08  380.71  379.78  379.80 
             380.38  381.35  382.66  384.26  386.14 
             388.27  390.66  393.28  396.14  399.23 
             402.54  406.09  422.46  465.53 
/
 9  9  5  1  386.34  377.04  370.54  369.71  369.89 
             370.66  371.87  373.38  375.26  377.44 
             379.90  382.64  385.64  388.91  392.36 
             396.12  400.13  418.52  466.33 
/
 9  9  6  1  378.03  357.68  351.30  351.13  351.83 
             353.09  354.79  356.87  359.32  362.11 
             365.22  368.64  372.38  376.42  380.75 
             385.37  390.29  412.75  470.58 
/
 9  9  7  1  357.82  321.57  318.80  318.92  320.23 
             322.32  325.04  328.33  332.13  336.43 
             341.21  346.43  352.09  358.17  364.67 
             371.57  378.85  411.68  493.43 
/
 9  9  8  1  293.95  285.33  283.81  285.53  288.54 
             292.56  297.46  303.20  309.74  317.08 
             325.13  333.88  343.32  353.41  364.14 
             375.48  387.42  440.33  568.30 
/
 9 10  1  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  2  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  3  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  4  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  5  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  6  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  7  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
 9 10  8  1  404.32  403.03  402.63  402.87  403.45 
             404.29  405.35  406.62  408.08  409.75 
             411.61  413.66  415.91  418.34  420.97 
             423.79  426.79  440.70  477.54 
/
10  1  1  1  369.83  368.39  367.78  368.02  368.69 
             369.69  370.96  372.49  374.25  376.25 
             378.48  380.93  383.60  386.50  389.61 
             392.94  396.49  412.81  455.71 
/
10  1  2  1  367.22  365.75  365.08  365.27  365.93 
             366.93  368.22  369.78  371.59  373.64 
             375.94  378.46  381.22  384.21  387.43 
             390.87  394.53  411.40  455.73 
/
10  1  3  1  356.61  353.44  351.41  351.27  351.91 
             353.03  354.56  356.43  358.63  361.14 
             363.89  366.99  370.37  374.03  377.96 
             382.16  386.61  407.00  459.95 
/
10  1  4  1  350.16  341.11  338.89  338.76  339.57 
             341.02  342.97  345.36  348.08  351.24 
             354.69  358.55  362.67  367.18  371.92 
             377.04  382.39  406.90  469.56 
/
10  1  5  1  338.76  321.41  319.10  319.39  320.86 
             323.13  326.07  329.60  333.67  338.25 
             343.31  348.85  354.82  361.24  368.07 
             375.32  382.96  417.29  500.85 
/
10  1  6  1  303.78  297.52  295.99  297.53  300.58 
             304.71  309.81  315.84  322.60  330.10 
             338.46  347.35  357.10  367.24  378.26 
             389.55  401.37  454.68  584.19 
/
10  1  7  1  274.62  272.06  274.20  280.03  288.00 
             297.57  308.54  320.85  334.43  349.23 
             365.19  382.26  400.41  419.61  440.56 
             463.02  486.22  588.31  836.51 
/
10  1  8  1  259.91  264.07  274.05  287.90  305.46 
             326.34  350.25  377.06  406.66  439.01 
             474.04  511.68  551.75  594.15  638.88 
             686.04  737.17  961.26 1499.73 
/
10  2  1  1  374.35  372.90  372.32  372.57  373.24 
             374.23  375.48  376.99  378.73  380.70 
             382.89  385.31  387.95  390.80  393.87 
             397.15  400.65  416.76  459.10 
/
10  2  2  1  371.85  370.37  369.73  369.94  370.59 
             371.58  372.86  374.39  376.17  378.19 
             380.45  382.93  385.64  388.58  391.74 
             395.12  398.72  415.32  458.95 
/
10  2  3  1  361.61  358.70  356.61  356.48  357.07 
             358.14  359.66  361.47  363.60  365.96 
             368.67  371.67  374.94  378.47  382.28 
             386.34  390.66  410.43  461.90 
/
10  2  4  1  355.35  346.65  344.46  344.32  345.09 
             346.41  348.24  350.50  353.14  356.07 
             359.41  363.02  367.00  371.30  375.83 
             380.70  385.82  409.31  469.52 
/
10  2  5  1  344.46  327.05  324.74  324.95  326.28 
             328.38  331.10  334.37  338.16  342.42 
             347.15  352.32  357.91  363.92  370.33 
             377.14  384.32  416.65  495.81 
/
10  2  6  1  324.44  302.56  300.92  302.19  304.91 
             308.68  313.37  318.87  325.12  332.08 
             339.68  347.93  357.00  366.44  376.42 
             386.93  398.33  447.24  568.35 
/
10  2  7  1  278.07  275.28  276.90  281.57  288.49 
             297.04  306.94  318.10  330.42  343.86 
             358.36  373.87  390.35  407.79  427.12 
             447.45  468.66  561.52  786.92 
/
10  2  8  1  260.95  264.59  273.58  285.89  301.48 
             319.97  341.11  364.78  390.93  419.49 
             450.39  483.59  518.90  556.27  595.67 
             637.09  680.84  879.96 1352.77 
/
10  3  1  1  379.05  377.60  377.05  377.30  377.97 
             378.95  380.19  381.67  383.38  385.32 
             387.49  389.87  392.46  395.27  398.30 
             401.53  404.98  420.86  462.64 
/
10  3  2  1  376.68  375.21  374.60  374.82  375.47 
             376.45  377.70  379.21  380.96  382.94 
             385.16  387.60  390.26  393.15  396.25 
             399.57  403.11  419.43  462.35 
/
10  3  3  1  366.92  364.10  362.15  362.03  362.61 
             363.65  365.06  366.80  368.84  371.18 
             373.80  376.69  379.84  383.26  386.93 
             390.86  395.04  414.19  464.16 
/
10  3  4  1  360.88  352.71  350.50  350.31  351.00 
             352.28  354.00  356.13  358.63  361.40 
             364.56  368.04  371.76  375.84  380.21 
             384.80  389.74  412.19  469.96 
/
10  3  5  1  350.62  333.37  331.07  331.20  332.41 
             334.32  336.83  339.86  343.36  347.32 
             351.71  356.51  361.73  367.32  373.31 
             379.67  386.40  416.69  491.38 
/
10  3  6  1  331.45  308.42  306.55  307.61  310.05 
             313.48  317.75  322.71  328.45  334.85 
             341.86  349.48  357.67  366.40  375.65 
             385.40  395.64  441.08  553.09 
/
10  3  7  1  282.21  279.20  280.35  284.25  290.00 
             297.40  306.17  316.11  327.17  339.24 
             352.29  366.26  381.12  397.11  414.81 
             433.10  452.16  535.90  739.13 
/
10  3  8  1  262.99  265.25  273.31  284.19  297.96 
             314.21  332.74  353.48  376.35  401.33 
             428.35  457.35  488.17  520.77  555.13 
             591.24  629.08  802.84 1217.19 
/
10  4  1  1  384.93  382.89  382.17  382.36  382.99 
             383.94  385.15  386.60  388.27  390.18 
             392.30  394.64  397.19  399.96  402.94 
             406.12  409.51  425.16  466.36 
/
10  4  2  1  382.72  380.67  379.89  380.05  380.67 
             381.61  382.83  384.31  386.01  387.95 
             390.12  392.51  395.13  397.95  401.00 
             404.26  407.74  423.76  465.96 
/
10  4  3  1  373.38  370.19  368.23  368.04  368.56 
             369.58  370.93  372.60  374.56  376.81 
             379.32  382.10  385.14  388.43  391.98 
             395.77  399.75  418.32  466.76 
/
10  4  4  1  367.52  359.70  357.13  356.90  357.53 
             358.71  360.32  362.32  364.67  367.28 
             370.26  373.55  377.14  380.94  385.09 
             389.52  394.16  415.61  470.90 
/
10  4  5  1  357.97  340.46  338.20  338.26  339.34 
             341.08  343.38  346.16  349.39  353.04 
             357.10  361.55  366.38  371.57  377.14 
             383.05  389.32  417.51  487.68 
/
10  4  6  1  339.85  315.28  313.19  313.98  316.06 
             319.09  322.89  327.40  332.56  338.34 
             344.70  351.62  359.07  367.04  375.50 
             384.43  393.83  435.72  538.58 
/
10  4  7  1  287.34  284.03  284.72  287.98  292.88 
             299.14  306.64  315.30  325.01  335.68 
             347.26  359.68  373.28  388.23  403.81 
             420.02  437.22  512.05  693.48 
/
10  4  8  1  266.12  266.19  273.27  282.86  294.97 
             309.12  325.21  343.19  363.01  384.61 
             407.97  432.98  459.56  487.69  517.32 
             548.44  581.03  730.08 1090.57 
/
10  5  1  1  391.52  388.63  387.62  387.71  388.28 
             389.18  390.34  391.76  393.39  395.26 
             397.34  399.63  402.14  404.86  407.78 
             410.91  414.25  429.66  470.26 
/
10  5  2  1  389.59  386.64  385.56  385.61  386.17 
             387.06  388.24  389.67  391.33  393.23 
             395.34  397.68  400.24  403.01  405.99 
             409.19  412.60  428.33  469.79 
/
10  5  3  1  381.22  377.09  374.91  374.61  375.06 
             375.96  377.23  378.80  380.67  382.82 
             385.23  387.90  390.82  393.98  397.40 
             401.05  404.94  422.86  469.74 
/
10  5  4  1  375.68  368.67  364.52  364.17  364.72 
             365.80  367.24  369.10  371.29  373.80 
             376.61  379.71  383.02  386.68  390.61 
             394.81  399.21  419.62  472.42 
/
10  5  5  1  366.86  348.44  346.25  346.26  347.21 
             348.80  350.89  353.44  356.40  359.75 
             363.48  367.58  372.03  376.83  381.96 
             387.42  393.17  419.24  484.85 
/
10  5  6  1  349.95  323.37  321.09  321.61  323.37 
             325.97  329.29  333.25  337.80  342.92 
             348.57  354.72  361.38  368.51  376.10 
             384.13  392.59  430.52  524.33 
/
10  5  7  1  297.55  290.10  290.35  293.00  297.10 
             302.41  308.79  316.17  324.48  333.67 
             344.16  355.57  367.72  380.61  394.29 
             408.82  423.75  490.61  650.86 
/
10  5  8  1  270.18  268.60  273.80  282.06  292.62 
             304.80  318.61  334.01  350.96  369.41 
             389.30  410.58  433.20  457.14  482.36 
             508.82  536.51  662.35  972.98 
/
10  6  1  1  398.17  394.57  393.28  393.27  393.78 
             394.63  395.75  397.12  398.72  400.54 
             402.58  404.83  407.29  409.95  412.83 
             415.91  419.19  434.34  474.34 
/
10  6  2  1  396.56  392.85  391.48  391.43  391.92 
             392.76  393.89  395.28  396.89  398.74 
             400.81  403.09  405.59  408.30  411.22 
             414.36  417.70  433.12  473.83 
/
10  6  3  1  389.38  384.43  382.10  381.65  381.98 
             382.80  383.98  385.46  387.24  389.28 
             391.58  394.14  396.93  399.97  403.25 
             406.77  410.51  427.79  473.11 
/
10  6  4  1  384.31  377.18  372.63  372.15  372.55 
             373.53  374.91  376.57  378.61  380.95 
             383.58  386.49  389.67  393.12  396.77 
             400.74  404.97  424.30  474.57 
/
10  6  5  1  376.40  357.46  355.39  355.35  356.20 
             357.64  359.54  361.85  364.55  367.61 
             371.02  374.73  378.75  383.12  387.78 
             392.75  398.04  422.07  483.06 
/
10  6  6  1  361.06  333.00  330.59  330.87  332.30 
             334.51  337.37  340.80  344.76  349.23 
             354.18  359.60  365.45  371.75  378.47 
             385.60  393.13  427.06  511.71 
/
10  6  7  1  306.31  298.60  297.87  299.92  303.31 
             307.80  313.27  319.65  326.92  334.99 
             343.87  353.68  364.09  375.21  387.01 
             399.47  412.58  470.59  611.13 
/
10  6  8  1  275.59  273.43  276.18  282.65  291.30 
             301.51  313.12  326.06  340.29  355.76 
             372.43  390.26  409.21  429.26  450.36 
             472.49  495.63  599.94  861.34 
/
10  7  1  1  404.69  400.64  399.14  399.03  399.48 
             400.29  401.37  402.70  404.25  406.03 
             408.03  410.23  412.64  415.26  418.08 
             421.10  424.33  439.23  478.61 
/
10  7  2  1  403.43  399.22  397.62  397.48  397.91 
             398.71  399.79  401.13  402.70  404.50 
             406.52  408.75  411.19  413.84  416.70 
             419.77  423.04  438.15  478.10 
/
10  7  3  1  397.62  392.15  389.67  389.15  389.42 
             390.16  391.26  392.66  394.34  396.29 
             398.48  400.92  403.59  406.50  409.64 
             413.01  416.60  433.20  476.89 
/
10  7  4  1  393.24  385.86  381.58  380.92  381.18 
             382.01  383.24  384.81  386.70  388.87 
             391.33  394.05  397.03  400.21  403.70 
             407.44  411.42  429.73  477.45 
/
10  7  5  1  386.41  370.80  365.94  365.76  366.45 
             367.68  369.35  371.40  373.79  376.52 
             379.58  382.94  386.61  390.57  394.84 
             399.34  404.19  426.21  482.55 
/
10  7  6  1  373.11  344.61  342.14  342.22  343.36 
             345.20  347.62  350.54  353.94  357.79 
             362.06  366.75  371.84  377.31  383.17 
             389.41  396.01  425.90  501.29 
/
10  7  7  1  342.76  310.25  308.38  309.67  312.36 
             316.03  320.59  325.93  332.01  338.91 
             346.36  354.64  363.36  372.67  382.81 
             393.24  404.55  453.80  575.35 
/
10  7  8  1  283.17  280.46  281.99  286.23  292.51 
             300.48  309.77  320.24  331.81  344.42 
             358.03  372.59  388.05  404.42  421.65 
             439.71  458.60  544.32  758.46 
/
10  8  1  1  410.82  406.73  405.12  404.96  405.37 
             406.14  407.18  408.47  409.99  411.73 
             413.68  415.84  418.20  420.77  423.54 
             426.51  429.68  444.32  483.07 
/
10  8  2  1  409.92  405.65  403.94  403.74  404.13 
             404.89  405.93  407.23  408.76  410.51 
             412.48  414.65  417.04  419.63  422.43 
             425.43  428.63  443.44  482.61 
/
10  8  3  1  405.64  400.14  397.64  397.11  397.34 
             398.04  399.08  400.41  402.01  403.87 
             405.96  408.28  410.84  413.62  416.62 
             419.84  423.28  439.18  481.14 
/
10  8  4  1  402.17  395.06  391.36  390.49  390.60 
             391.28  392.36  393.78  395.51  397.52 
             399.79  402.32  405.10  408.13  411.40 
             414.90  418.64  435.89  481.12 
/
10  8  5  1  396.65  386.05  378.28  377.77  378.18 
             379.17  380.59  382.38  384.50  386.95 
             389.62  392.65  395.97  399.49  403.35 
             407.48  411.80  431.86  483.57 
/
10  8  6  1  385.86  358.75  356.38  356.31  357.19 
             358.71  360.72  363.18  366.04  369.30 
             372.92  376.91  381.25  385.94  390.96 
             396.31  402.00  427.88  494.02 
/
10  8  7  1  360.38  324.94  322.66  323.33  325.29 
             328.16  331.79  336.11  341.06  346.63 
             352.77  359.46  366.69  374.43  382.67 
             391.38  400.55  441.59  542.50 
/
10  8  8  1  296.82  291.18  291.70  294.57  298.91 
             304.49  311.18  318.91  327.64  337.29 
             347.79  359.09  371.16  383.95  397.44 
             411.62  427.21  497.32  666.39 
/
10  9  1  1  416.30  412.65  411.15  411.00  411.40 
             412.15  413.17  414.43  415.92  417.62 
             419.53  421.65  423.97  426.48  429.20 
             432.12  435.23  449.62  487.73 
/
10  9  2  1  415.74  411.94  410.34  410.16  410.54 
             411.27  412.29  413.56  415.05  416.76 
             418.68  420.81  423.14  425.68  428.41 
             431.35  434.48  448.98  487.37 
/
10  9  3  1  413.03  408.19  405.94  405.49  405.73 
             406.41  407.41  408.69  410.22  411.99 
             413.99  416.21  418.65  421.30  424.17 
             427.25  430.53  445.75  485.99 
/
10  9  4  1  410.66  404.59  401.53  400.73  400.82 
             401.42  402.41  403.72  405.31  407.16 
             409.26  411.61  414.19  417.00  420.04 
             423.31  426.80  442.93  485.46 
/
10  9  5  1  406.72  398.04  392.46  391.51  391.63 
             392.35  393.50  395.00  396.82  398.95 
             401.35  404.02  406.96  410.15  413.52 
             417.21  421.15  439.25  486.31 
/
10  9  6  1  398.99  382.00  374.19  374.07  374.77 
             376.01  377.66  379.70  382.08  384.78 
             387.81  391.14  394.78  398.71  402.93 
             407.44  412.23  434.19  490.74 
/
10  9  7  1  380.26  345.81  343.17  343.26  344.49 
             346.45  349.03  352.14  355.75  359.84 
             364.39  369.37  374.78  380.60  386.83 
             393.46  400.47  432.20  511.96 
/
10  9  8  1  327.64  311.21  309.15  310.61  313.42 
             317.20  321.87  327.39  333.60  340.63 
             348.26  356.70  365.83  375.62  385.77 
             396.80  408.44  459.75  586.26 
/
10 10  1  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  2  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  3  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  4  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  5  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  6  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  7  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
10 10  8  1  424.42  423.13  422.72  422.97  423.55 
             424.39  425.45  426.71  428.18  429.84 
             431.70  433.76  436.00  438.44  441.06 
             443.88  446.88  460.78  497.61 
/
