program intrinsics_214
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    real(sp) :: a, b, c
    real(dp) :: d, e, f
    integer :: i

    real(dp) :: w(19)
    real(sp) :: x(19)
    real(dp) :: expected_w(19)
    real(sp) :: expected_x(19)
         
    real(dp), parameter :: res(19) = sind([18.7234114226922479_dp, 31.7355871858161613_dp, 46.7189879975828859_dp, &
    -18.7234114226922479_dp, -31.7355871858161613_dp, -46.7189879975828859_dp, -90.0000000000000000_dp, &
    -88.1889782219856926_dp, -87.4387217993888584_dp, -86.8629570229495442_dp, -86.3775039053440139_dp, &
    -85.9497575149846398_dp, -85.5629967823348778_dp, -85.2072890476047604_dp, -84.8761629060389708_dp, &
    -84.5651234927047142_dp, -84.2708982602068915_dp, -83.9910168022338581_dp, -83.7235599383380418_dp])

    real(sp), parameter :: res_sp(19) = sind([17.7966309_sp, 27.7443714_sp, 36.0546188_sp, &
        -17.7966309_sp, -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp])

    expected_w = [0.32100000000000001_dp, 0.52600000000000002_dp, 0.72799999999999998_dp, &
    -0.32100000000000001_dp, -0.52600000000000002_dp, -0.72799999999999998_dp, -1.0000000000000000_dp, &
    -0.99950049950049946_dp, -0.99900099900099903_dp, -0.99850149850149850_dp, -0.99800199800199796_dp, &
    -0.99750249750249753_dp, -0.99700299700299699_dp, -0.99650349650349646_dp, -0.99600399600399603_dp, &
    -0.99550449550449549_dp, -0.99500499500499495_dp, -0.99450549450549453_dp, -0.99400599400599399_dp]

    w = [18.7234114226922479_dp, 31.7355871858161613_dp, 46.7189879975828859_dp, -18.7234114226922479_dp, &
    -31.7355871858161613_dp, -46.7189879975828859_dp, -90.0000000000000000_dp, -88.1889782219856926_dp, -87.4387217993888584_dp, &
    -86.8629570229495442_dp, -86.3775039053440139_dp, -85.9497575149846398_dp, -85.5629967823348778_dp, -85.2072890476047604_dp, &
    -84.8761629060389708_dp, -84.5651234927047142_dp, -84.2708982602068915_dp, -83.9910168022338581_dp, &
    -83.7235599383380418_dp]

    x = [17.7966309_sp, 27.7443714_sp, 36.0546188_sp, -17.7966309_sp, &
        -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp]

    expected_x = [0.305639327, 0.465527594, 0.588556170, -0.305639327, &
        -0.465527594, -0.588556170, -0.707106769, -0.706752896, -0.706752896, &
        -0.706398606, -0.706398606, -0.706043661, -0.706043661, -0.705688298, &
        -0.705688298, -0.705332398, -0.705332398, -0.704975843, -0.704975843]

    do i = 1, size(res)
        print *, res(i)
        if (abs(res(i) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(w)
        print *, sind(w(i))
        if (abs(sind(w(i)) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(res_sp)
        print *, res_sp(i)
        if (abs(res_sp(i) - expected_x(i)) > 1e-5) error stop
    end do

    do i = 1, size(x)
        print *, sind(x(i))
        if (abs(sind(x(i)) - expected_x(i)) > 1e-5) error stop
    end do

    a = 18.928_sp
    b = 32.627_sp
    c = 47.123_sp

    d = 18.829262783_dp
    e = 32.727262783_dp
    f = 47.223262783_dp

    print *, sind(a)
    if (abs(sind(a) - 0.324379712) > 1e-3) error stop

    print *, sind(b)
    if (abs(sind(b) - 0.539167702) > 1e-3) error stop

    print *, sind(c)
    if (abs(sind(c) - 0.732816100) > 1e-3) error stop

    print *, sind(18.928_sp)
    if (abs(sind(18.928_sp) - 0.324379712) > 1e-3) error stop

    print *, sind(32.627_sp)
    if (abs(sind(32.627_sp) - 0.539167702) > 1e-3) error stop

    print *, sind(47.123_sp)
    if (abs(sind(47.123_sp) - 0.732816100) > 1e-3) error stop

    print *, sind(d)
    if (abs(sind(d) - 0.32274913716473685) > 1e-3) error stop

    print *, sind(e)
    if (abs(sind(e) - 0.54064067144737327) > 1e-3) error stop

    print *, sind(f)
    if (abs(sind(f) - 0.73400566544830548) > 1e-3) error stop

    print *, sind(18.829262783_dp)
    if (abs(sind(18.829262783_dp) - 0.32274913716473685) > 1e-3) error stop

    print *, sind(32.727262783_dp)
    if (abs(sind(32.727262783_dp) - 0.54064067144737327) > 1e-3) error stop

    print *, sind(47.223262783_dp)
    if (abs(sind(47.223262783_dp) - 0.73400566544830548) > 1e-3) error stop

end program