; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s

declare <2 x i64> @llvm.cttz.v2i64(<2 x i64>, i1)
declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1)
declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)

define <2 x i64> @footz(<2 x i64> %a) nounwind {
; CHECK-LABEL: footz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm1, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    psubq %xmm0, %xmm2
; CHECK-NEXT:    pand %xmm0, %xmm2
; CHECK-NEXT:    pcmpeqd %xmm3, %xmm3
; CHECK-NEXT:    paddq %xmm2, %xmm3
; CHECK-NEXT:    movdqa %xmm3, %xmm0
; CHECK-NEXT:    psrlq $1, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psubq %xmm0, %xmm3
; CHECK-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; CHECK-NEXT:    movdqa %xmm3, %xmm2
; CHECK-NEXT:    pand %xmm0, %xmm2
; CHECK-NEXT:    psrlq $2, %xmm3
; CHECK-NEXT:    pand %xmm0, %xmm3
; CHECK-NEXT:    paddq %xmm2, %xmm3
; CHECK-NEXT:    movdqa %xmm3, %xmm0
; CHECK-NEXT:    psrlq $4, %xmm0
; CHECK-NEXT:    paddq %xmm3, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psadbw %xmm1, %xmm0
; CHECK-NEXT:    retq
  %c = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
  ret <2 x i64> %c

}
define <2 x i64> @foolz(<2 x i64> %a) nounwind {
; CHECK-LABEL: foolz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $1, %xmm1
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    psrlq $2, %xmm0
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $4, %xmm1
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    psrlq $8, %xmm0
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $16, %xmm1
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    psrlq $32, %xmm0
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm1
; CHECK-NEXT:    pxor %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    psrlq $1, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psubq %xmm0, %xmm1
; CHECK-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; CHECK-NEXT:    movdqa %xmm1, %xmm2
; CHECK-NEXT:    pand %xmm0, %xmm2
; CHECK-NEXT:    psrlq $2, %xmm1
; CHECK-NEXT:    pand %xmm0, %xmm1
; CHECK-NEXT:    paddq %xmm2, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm2
; CHECK-NEXT:    psrlq $4, %xmm2
; CHECK-NEXT:    paddq %xmm1, %xmm2
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm2
; CHECK-NEXT:    pxor %xmm0, %xmm0
; CHECK-NEXT:    psadbw %xmm2, %xmm0
; CHECK-NEXT:    retq
  %c = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
  ret <2 x i64> %c

}

define <2 x i64> @foopop(<2 x i64> %a) nounwind {
; CHECK-LABEL: foopop:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $1, %xmm1
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm1
; CHECK-NEXT:    psubq %xmm1, %xmm0
; CHECK-NEXT:    movdqa {{.*#+}} xmm1 = [3689348814741910323,3689348814741910323]
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    pand %xmm1, %xmm2
; CHECK-NEXT:    psrlq $2, %xmm0
; CHECK-NEXT:    pand %xmm1, %xmm0
; CHECK-NEXT:    paddq %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $4, %xmm1
; CHECK-NEXT:    paddq %xmm0, %xmm1
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm1
; CHECK-NEXT:    pxor %xmm0, %xmm0
; CHECK-NEXT:    psadbw %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %c = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  ret <2 x i64> %c
}

declare <2 x i32> @llvm.cttz.v2i32(<2 x i32>, i1)
declare <2 x i32> @llvm.ctlz.v2i32(<2 x i32>, i1)
declare <2 x i32> @llvm.ctpop.v2i32(<2 x i32>)

define <2 x i32> @promtz(<2 x i32> %a) nounwind {
; CHECK-LABEL: promtz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    por {{.*}}(%rip), %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    psubq %xmm0, %xmm2
; CHECK-NEXT:    pand %xmm0, %xmm2
; CHECK-NEXT:    pcmpeqd %xmm3, %xmm3
; CHECK-NEXT:    paddq %xmm2, %xmm3
; CHECK-NEXT:    movdqa %xmm3, %xmm0
; CHECK-NEXT:    psrlq $1, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psubq %xmm0, %xmm3
; CHECK-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; CHECK-NEXT:    movdqa %xmm3, %xmm2
; CHECK-NEXT:    pand %xmm0, %xmm2
; CHECK-NEXT:    psrlq $2, %xmm3
; CHECK-NEXT:    pand %xmm0, %xmm3
; CHECK-NEXT:    paddq %xmm2, %xmm3
; CHECK-NEXT:    movdqa %xmm3, %xmm0
; CHECK-NEXT:    psrlq $4, %xmm0
; CHECK-NEXT:    paddq %xmm3, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psadbw %xmm1, %xmm0
; CHECK-NEXT:    retq
  %c = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a, i1 false)
  ret <2 x i32> %c

}
define <2 x i32> @promlz(<2 x i32> %a) nounwind {
; CHECK-LABEL: promlz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm1
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    psrlq $1, %xmm2
; CHECK-NEXT:    por %xmm0, %xmm2
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    psrlq $2, %xmm0
; CHECK-NEXT:    por %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    psrlq $4, %xmm2
; CHECK-NEXT:    por %xmm0, %xmm2
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    psrlq $8, %xmm0
; CHECK-NEXT:    por %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    psrlq $16, %xmm2
; CHECK-NEXT:    por %xmm0, %xmm2
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    psrlq $32, %xmm0
; CHECK-NEXT:    por %xmm2, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm2, %xmm2
; CHECK-NEXT:    pxor %xmm0, %xmm2
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    psrlq $1, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psubq %xmm0, %xmm2
; CHECK-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; CHECK-NEXT:    movdqa %xmm2, %xmm3
; CHECK-NEXT:    pand %xmm0, %xmm3
; CHECK-NEXT:    psrlq $2, %xmm2
; CHECK-NEXT:    pand %xmm0, %xmm2
; CHECK-NEXT:    paddq %xmm3, %xmm2
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    psrlq $4, %xmm0
; CHECK-NEXT:    paddq %xmm2, %xmm0
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    psadbw %xmm1, %xmm0
; CHECK-NEXT:    psubq {{.*}}(%rip), %xmm0
; CHECK-NEXT:    retq
  %c = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a, i1 false)
  ret <2 x i32> %c

}

define <2 x i32> @prompop(<2 x i32> %a) nounwind {
; CHECK-LABEL: prompop:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm0
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $1, %xmm1
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm1
; CHECK-NEXT:    psubq %xmm1, %xmm0
; CHECK-NEXT:    movdqa {{.*#+}} xmm1 = [3689348814741910323,3689348814741910323]
; CHECK-NEXT:    movdqa %xmm0, %xmm3
; CHECK-NEXT:    pand %xmm1, %xmm3
; CHECK-NEXT:    psrlq $2, %xmm0
; CHECK-NEXT:    pand %xmm1, %xmm0
; CHECK-NEXT:    paddq %xmm3, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm1
; CHECK-NEXT:    psrlq $4, %xmm1
; CHECK-NEXT:    paddq %xmm0, %xmm1
; CHECK-NEXT:    pand {{.*}}(%rip), %xmm1
; CHECK-NEXT:    psadbw %xmm2, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %c = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a)
  ret <2 x i32> %c
}
