/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import org.jetbrains.annotations.NotNull;

/**
 * @author Denis Zhdanov
 * @since 9/20/12 8:37 PM
 */
public interface DocCommentFixer {

  LanguageExtension<DocCommentFixer> EXTENSION = new LanguageExtension<>("com.intellij.lang.documentationFixer");

  // TODO den add doc
  void fixComment(@NotNull Project project, @NotNull Editor editor, @NotNull PsiComment comment);
}
