/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.util.SmartList;

import java.util.List;

public class CompositeRunnable implements Runnable {
  private List<Runnable> list = new SmartList<>();

  public boolean add(Runnable runnable) {
    return list.add(runnable);
  }

  public void clear() {
    list = new SmartList<>();
  }

  @Override
  public void run() {
    for (Runnable runnable : list) {
      runnable.run();
    }
  }
}