Components.utils.import("chrome://flashblock/content/Flashblock.jsm"); // FBlockUtils, FBlockState

var Flashblock = {

  prefObserver : {
    observe: function(subject, topic, data) {
      switch(data) {
        case "flashblock.enabled":
        case "javascript.enabled":
        Flashblock.setButtonState(FBlockState.enabled && FBlockUtils.isJavascriptEnabled());
        break;
      }
    },

    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsIObserver) ||
          aIID.equals(Components.interfaces.nsISupports) ||
          aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    }
  },

  // was addFlashblockPrefObserver
  addPrefObserver : function () {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    var pbi = prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
    pbi.addObserver("flashblock.", Flashblock.prefObserver, true);
    pbi.addObserver("javascript.enabled", Flashblock.prefObserver, true);
  },

  // Gets the hostname from the URI of the current page
  getHost : function () {
    var pageURI;
    if (gContextMenu)
      pageURI = gContextMenu.target.baseURI;
    else
      pageURI = content.location;

    // Work around about: and file:// URIs.
    // If we do uri.spec = "about:blank", the URI ends up as about://blank/
    if(/about:|file:|news:|snews:/i.test(pageURI.protocol))
      return null;

    var uri = Components.classes['@mozilla.org/network/standard-url;1']
                        .createInstance(Components.interfaces.nsIURI);
    uri.spec = pageURI;

    // Phil: use asciiHost until we change the pref from char to complex
    var host = uri.asciiHost;
    if (uri.port > 0)
      host += ":" + uri.port;

    return host;
  },

  // Adds the host of the current URI to the whitelist
  addSiteToWhitelist : function (site) {
    var host = site || this.getHost();
    if( (!host) || (host == "") )
      return;

    var prefStr = FBlockUtils.getWhitelist();
    var re = new RegExp("(^|,)" + host + "(,|$)");
    if(! re.test(prefStr)) {
      if(prefStr && prefStr.length > 0)
        prefStr += "," + host;
      else
        prefStr = host;
      FBlockUtils.setWhitelist(prefStr);
    }
  },

  // Removes the host of the current URI from the whitelist
  removeSiteFromWhitelist : function () {
    var host = this.getHost();
    if( (!host) || (host == "") )
      return;

    var prefStr = FBlockUtils.getWhitelist();
    var regex = new RegExp("(^|,)(" + host + ")(,|$)", "g");

    prefStr = prefStr.replace(regex, "$3");
    FBlockUtils.setWhitelist(prefStr);
  },

  // Toggles the whitelist status of the host of the current URI
  toggleSiteWhitelisted : function () {
    host = this.getHost();
    if(FBlockState.checkHostInWhitelist(host))
      this.removeSiteFromWhitelist();
    else
      this.addSiteToWhitelist();
  },

/// CONTEXT MENU FUNCTIONS

    contextMenuInit : function () {
      var items = ["contentAreaContextMenu", "messagePaneContext"];
      for (var i = 0; i < items.length; i++) {
        var cm = document.getElementById(items[i]);
        if (cm)
          cm.addEventListener("popupshowing", Flashblock.contextMenu, false);
      }
      Flashblock.setButtonState(FBlockState.enabled && FBlockUtils.isJavascriptEnabled());
    },

    // was flashblockContextMenu()
    contextMenu : function () {
      var cm = gContextMenu;
      var onFlash = cm.hasBGImage &&
        cm.bgImageURL.indexOf("chrome://flashblock") == 0;

      // Workaround for Mozilla Bug 482941 and Bug 422851
      if (!onFlash && (cm.target instanceof HTMLDivElement)) {
        var style = cm.target.getAttribute("style");
        if ((style != null) && style.indexOf("chrome://flashblock") >= 0)
          onFlash = true;
      }
      var nukeItem = document.getElementById("nukeanything-do-nuke");

      var itemsToShow = ["context-flashAllow", "context-flashLocation", "context-flashWhitelist"];
      for (var ii = 0; ii < itemsToShow.length; ii++) {
        cm.showItem(itemsToShow[ii], onFlash);
      }
      cm.showItem("context-flashRemove", onFlash && !nukeItem);

      if (onFlash) {
        var itemsToHide = ["context-back", "context-forward", "context-reload",
          "context-stop", "context-sep-stop",
          "context-bookmarkpage", "context-savepage", "context-sendpage",
          "context-viewbgimage", "context-viewbgimage-menu", "context-sep-viewbgimage",
          "context-selectall", "context-viewsource", "context-viewinfo",
          "context-metadata", "context-sep-properties",
          "switchToTrident", "context-print" ];
        for (var ii = 0; ii < itemsToHide.length; ii++) {
          cm.showItem(itemsToHide[ii], false);
        }

        var thisURI = Components.classes['@mozilla.org/network/standard-url;1']
                                .createInstance(Components.interfaces.nsIURI);
        thisURI.spec = gContextMenu.target.baseURI;
        document.getElementById("context-flashAllow")
                .setAttribute("tooltiptext", thisURI.prePath);

        var cmLocationItem = document.getElementById("context-flashLocation");
        if (cmLocationItem && gContextMenu.target.title) {
          cmLocationItem.setAttribute("tooltiptext",
                                      Flashblock.getAbsoluteURL(gContextMenu.target));
        }

        Flashblock.checkWhitelistToggle();
      }
    },

    getAbsoluteURL : function(target) {
        var absURL = target.title;
        if (!/^http(s?):/i.test(absURL)) {
          var ios = Components.classes["@mozilla.org/network/io-service;1"]
                              .getService(Components.interfaces.nsIIOService);
          var baseURI  = ios.newURI(target.baseURI, null, null);
          absURL = ios.newURI(baseURI.resolve(absURL), null, null).spec;
        }
        return absURL;
    },

    // was flashblockOptions()
    showOptions : function() {
        window.openDialog("chrome://flashblock/content/options.xul",
                          "FlashblockOptions",
                          "chrome,titlebar,toolbar,centerscreen,resizable");
    },

    copyLocation : function() {
      var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                                .getService(Components.interfaces.nsIClipboardHelper);
      clipboard.copyString(Flashblock.getAbsoluteURL(gContextMenu.target));
    },

/// INITIALIZATION CODE
    onInstall : function() {
        window.removeEventListener("load", Flashblock.onInstall, true);

        var sss = Components.classes["@mozilla.org/content/style-sheet-service;1"]
                            .getService(Components.interfaces.nsIStyleSheetService);
        var ios = Components.classes["@mozilla.org/network/io-service;1"]
                            .getService(Components.interfaces.nsIIOService);
        var u = ios.newURI("chrome://flashblock/content/flashblock.css", null, null);
        if(!sss.sheetRegistered(u, sss.USER_SHEET)) {
          sss.loadAndRegisterSheet(u, sss.USER_SHEET);
        }
    },

    browserInit: function() {
      Flashblock.addPrefObserver();
      window.addEventListener("load", Flashblock.onInstall, true);
      window.addEventListener("load", Flashblock.contextMenuInit, true);
    },

/// TOOLBARBUTTON CODE

  //was flashblockToggleButton()
    toggleButton : function(event) {
      var state = !FBlockState.enabled;
      FBlockUtils.setEnabled(state);
      Flashblock.setButtonState(state);
      if (event.metaKey || event.ctrlKey || event.shiftKey) {
        BrowserReload();
      }
    },

  //was flashblockSetButtonState(state)
    setButtonState : function(state) {
      var isJavascriptEnabled = FBlockUtils.isJavascriptEnabled();
        var button = document.getElementById("flashblockToggle-button");
        if (button) {
            button.setAttribute("state", state ? "enabled" : "disabled");
            button.setAttribute("disabled", !isJavascriptEnabled);
            button.setAttribute("label",
              button.getAttribute(state ? "labelon" :"labeloff"));
        }
        button = document.getElementById("flashblockMozToggle-button");
        if (button) {
            button.setAttribute("state", state ? "enabled" : "disabled");
            button.setAttribute("disabled", !isJavascriptEnabled);
            button.setAttribute("label",
              button.getAttribute(state ? "labelon" :"labeloff"));
        }
    },

    setTooltipSite : function() {
    var thisURI = Components.classes['@mozilla.org/network/standard-url;1']
                            .createInstance(Components.interfaces.nsIURI);
        thisURI.spec = content.location;
        var menu = document.getElementById("buttonmenu-flashblockAllow");
        if (menu) {
            menu.setAttribute("tooltiptext", thisURI.prePath)
        };
    },

    // workaround for bug 147670
    fixParentTip : function(state, pnode) {
        var tip;
        if (state == "hide") {
            tip = pnode.getAttribute("tooltiptext");
            if (tip) {
                pnode.setAttribute("temptip", tip);
                pnode.removeAttribute("tooltiptext");
            };
            Flashblock.setTooltipSite();
        } else if (state == "show") {
            tip = pnode.getAttribute("temptip");
            if (tip) {
                pnode.setAttribute("tooltiptext", tip);
                pnode.removeAttribute("temptip");
            };
        }
    },

  checkWhitelistToggle : function () {
    var host = this.getHost();
    var toolbarWhitelistItem = document.getElementById("buttonmenu-flashblockAllow");
    var contextmenuWhitelistItem = document.getElementById("context-flashAllow");

    if(host) {
      var whitelisted = FBlockState.checkHostInWhitelist(host);
      contextmenuWhitelistItem.setAttribute("disabled", false);
      if(toolbarWhitelistItem) {
        toolbarWhitelistItem.setAttribute("disabled", false);
        toolbarWhitelistItem.setAttribute("checked", whitelisted)
      }

      if (gContextMenu) {
        var thisURI = Components.classes['@mozilla.org/network/standard-url;1']
                                .createInstance(Components.interfaces.nsIURI);
        thisURI.spec = gContextMenu.target.baseURI;
        whitelisted = FBlockState.checkHostInWhitelist(thisURI.host);
        contextmenuWhitelistItem.setAttribute("checked", whitelisted);
      }
    } else {
      contextmenuWhitelistItem.setAttribute("disabled", true);
      if(toolbarWhitelistItem)
        toolbarWhitelistItem.setAttribute("disabled", true);
    }
  },

/// MISC

  //was flashblockHideObject()
  hideObject : function() {
    if(gContextMenu) {
      var obj = gContextMenu.target;
      if(obj) {
        obj.style.display = "none";
      }
    }
  }
}
