var EXPORTED_SYMBOLS = ["FBlockUtils", "FBlockState"];

const { interfaces: Ci, classes: Cc, utils: Cu } = Components;

Components.utils.import("resource://gre/modules/Services.jsm");
Services.scriptloader.loadSubScript("chrome://flashblock/content/flashblock-prefs.js"); // FBlockUtils

if (Services.appinfo.processType == Services.appinfo.PROCESS_TYPE_DEFAULT) {
  Components.classes["@mozilla.org/globalmessagemanager;1"]
            .getService(Components.interfaces.nsIMessageListenerManager)
            .loadFrameScript("chrome://flashblock/content/frame.js", true);
}

var prefObserver = {
  observe: function(subject, topic, data) {
    switch(data) {
      case "flashblock.whitelist":
      Whitelist.load();
      break;

      case "flashblock.enabled":
      FBlockState.enabled = FBlockUtils.isEnabled();
      break;

      case "flashblock.html5video.blocked":
      FBlockState.videoblockEnabled = FBlockUtils.isVideoEnabled();
      break;

      case "flashblock.silverlight.blocked":
      FBlockState.silverblockEnabled = FBlockUtils.isSilverlightEnabled();
      break;

      case "flashblock.whitelist.includeTarget":
      FBlockState.targetEnabled = FBlockUtils.isTargetEnabled();
      break;
    }
  },

  QueryInterface : function (aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
      return this;
    throw Components.results.NS_NOINTERFACE;
  }
};

Services.prefs.addObserver("flashblock.", prefObserver, true);

const Whitelist = {
  rx: null,

  load: function () {
    const wl = FBlockUtils.getWhitelist();
    this.rx = wl && new RegExp(
        "^(?:" + wl.split(",").map(function(s) s.replace(/[.?+-]/g, "\\$&").replace(/\*/g, '.*')).join("|") + ")"
      );
  },

  checkHost: function (host) host && this.rx && this.rx.test(host),

  check: function (url) !FBlockUtils.isLocalBlocked() && url.protocol == "file:" || this.checkHost(url.host) ||  this.checkHost(url.spec)
}
Whitelist.load();

const FBlockState = {
  enabled: FBlockUtils.isEnabled(),
  videoblockEnabled: FBlockUtils.isVideoEnabled(),
  silverblockEnabled: FBlockUtils.isSilverlightEnabled(),
  targetEnabled: FBlockUtils.isTargetEnabled(),
  checkWhitelist: function (url) Whitelist.check(url),
  checkHostInWhitelist: function (host) Whitelist.checkHost(host),
  whitelist: Whitelist,
};

