;;; hanja-jis.el --- Quail package for inputting Korean Hanja (JISX0208)  -*- lexical-binding: t -*-

;; Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
;;   2006, 2007, 2008, 2009, 2010, 2011
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H14PRO021

;; Keywords: multilingual, input method, Korean, Hangul

;; This file is part of GNU Emacs.

;; GNU Emacs is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

(require 'quail)

(quail-define-package
 "korean-hanja-jis" "Korean" "漢2" t
 "2벌식JIS漢字: 該當하는 漢字의 韻을 한글2벌式으로 呼出하여 選擇"
 nil nil nil nil nil nil t)

(quail-define-rules
 ("rk"	"榎仮伽価佳加可嘉嫁家暇架歌珂稼苛茄迦駕街袈个假價呵哥枷柯珈痂笳舸葭訶謌賈跏軻")
 ("rkr"	"各格殻覚角較閣却脚刻塙卻咯埆恪愨擱桷殼狢覺貉鬥")
 ("rks"	"斡乾侃刊姦干幹澗看竿簡肝間墾懇艮菅奸慳揀杆柬栞桿狠癇稈繝艱諫鶫齦")
 ("rkf"	"介喝渇葛褐掲丐曷碣竭羯蝎鞨頡")
 ("rka"	"勘堪感憾敢柑甘監鑑欠鹸減紺凵坎坩嵌戡撼橄歉淦疳瞰緘蚶轗酣鑒龕")
 ("rkq"	"押蓋甲合岬匣盖胛閘")
 ("rkd"	"岡橿強彊慶康控江糠綱腔講鋼降剛虹亢僵啌姜崗慷扛杠棡疆矼絳繦羌薑襁跫鱇")
 ("ro"	"佳箇介解改皆芥開階凱咳慨概蓋鎧個丐个价剴愾懈揩楷漑疥盖觧")
 ("ror"	"客喀")
 ("rod"	"坑更粳羹羮鏗")
 ("ri"	"茄")
 ("rir"	"醵")
 ("rj"	"去居巨拒拠渠距鋸車据裾俥倨墟據擧舉欅炬秬筥苣踞遽醵鉅")
 ("rjs"	"乾巾件健建鍵愆搴腱虔謇蹇騫")
 ("rjf"	"渇掲傑乞担桝偈杰桀气竭")
 ("rja"	"柑倹剣検鹸儉劍劔劒剱檢瞼臉黔")
 ("rjq"	"笈怯劫拾刧")
 ("rp"	"憩掲偈憇碣")
 ("rur"	"仮格隔革撃激假挌檄膈茖覡闃骼鬲鴃鵙")
 ("rus"	"樫鰹堅牽犬絹肩見遣縛繭鑓俔幵悁枅狷甄筧羂譴鵑")
 ("ruf"	"桔契決潔結訣孟决抉拮挈缺髻")
 ("rua"	"鎌兼謙慊拑歉箝蒹鉗")
 ("ruq"	"恰頬慊鋏")
 ("rud"	"京競卿境鏡驚傾径慶敬景経茎荊警軽頚鯨庚更梗硬耕頃亰竸冂冏剄勁勍哽徑憬檠煢瓊畊痙磬絅經綮耿脛莖謦輕逕竟頸黥")
 ("rP"	"戒械界階季係啓契桂渓稽系継繋計鶏堺届屆彑悸枅溪畍癸禊笄綮繼薊誡谿髻鷄")
 ("rh"	"苦古固姑孤庫故枯袴股菰鈷雇顧鼓稿考膏高拷告皐縞尻叩藁估凅刳呱攷敲杲柧桍栲槁槹沽痼皋睾瞽稾箍罟羔胯蛄蠱觚詁誥賈辜錮靠鴣鵁皷")
 ("rhr"	"曲告穀酷鵠谷硲哭斛梏槲轂髷")
 ("rhs"	"困坤昆梱混壼崑悃棍滾菎褌鯀鯤鶤")
 ("rhf"	"滑骨榾汨鶻")
 ("rhd"	"供共恐恭空公功孔工控攻貢倥廾拱椌槓箜蚣蛩蛬跫鞏")
 ("rhk"	"瓜寡科果菓課過袴誇跨鍋堝夥夸戈胯萪蝌裹踝顆")
 ("rhkr"	"廓郭擴攫椁槨癨矍钁霍")
 ("rhks"	"冠官寛慣棺款潅管莞観貫関館舘串菅丱冦毋灌盥綸綰罐觀鑵關鸛")
 ("rhkf"	"括活筈桧刮檜聒")
 ("rhkd"	"拡匡狂光広鉱砿壙廣擴曠昿框洸礦筐筺絋絖胱誑鑛")
 ("rho"	"掛卦罫咼戈挂枴褂")
 ("rhl"	"会塊壊怪恢拐魁乖傀壞恠愧槐瑰詼")
 ("rhlr"	"膕馘")
 ("rhld"	"宏紘肱轟浤軣鍠")
 ("ry"	"撹覚較噛糾僑叫喬教橋矯蕎交佼孝巧校絞郊酵鮫招咬嬌攪敲橇澆狡皎磽窖翹膠蛟轎釖餃驕驍")
 ("rn"	"臼厩欧殴鴎鈎亀丘久仇救求灸球究旧拒九倶句区狗玖矩躯駆駈駒具粂勾口垢拘構溝購叩韮鳩釦傴冓劬區咎嘔媾嫗寇嶇廐廏怐惧懼扣搆柩枸歐毆毬甌疚瞿窶篝舅舊苟蒟蚯衢裘覯詬謳逑遘邱鉤韭颶馗驅鬮齲龜")
 ("rnr"	"掬菊鞠局麹国囗國椈鬻鞫跼")
 ("rns"	"君群軍郡桾皸皹窘羣裙")
 ("rnf"	"屈掘窟堀倔厥崛")
 ("rnd"	"宮弓窮穹躬")
 ("rnjs"	"勧巻挙倦券圏拳捲権劵勸卷圈惓椦權眷綣蜷顴")
 ("rnjf"	"掘蕨亅厥獗蹶闕")
 ("rnp"	"机帰軌凧潰几匱椢櫃歸皈簣臾詭跪蹶餽饋")
 ("rnl"	"帰貴鬼亀喟椢歸皈龜")
 ("rnlr"	"掴幗")
 ("rb"	"葵窺規糾叫九圭珪頃槻奎揆摎樛癸硅竅糺繆袿赳逵閨馗鬮")
 ("rbs"	"亀均菌箘鈞麕龜")
 ("rbf"	"橘")
 ("rmr"	"可革極劇戟隙克亟剋尅屐棘蕀郤")
 ("rms"	"僅勤巾斤筋芹謹近根懃槿瑾矜菫覲釿饉")
 ("rmf"	"契訖")
 ("rma"	"錦琴禁禽衿襟金檎今噤擒衾黔")
 ("rmq"	"扱及急汲笈級給岌")
 ("rmd"	"恒肯亙亘兢恆矜")
 ("rl"	"磯企伎器基奇寄岐幾忌旗既期棋棄機気汽畿祈紀記起飢騎妓技欺祇居祁己碁乞崎埼碕示其肌鰭箕亟俟冀剞嗜噐圻竒嵜弃掎旡曁朞杞枳棊榿气氣沂淇畸祺稘綺羈羇耆覊覬譏豈跂饑騏驥鮨麒")
 ("rlr"	"喫")
 ("rls"	"緊")
 ("rlf"	"吉桔詰佶拮")
 ("rla"	"金")
 ("Rlr"	"喫")
 ("sk"	"奈那難儺娜懦扨拏拿梛糯")
 ("skr"	"諾")
 ("sks"	"暖難攤煖赧")
 ("skf"	"捺捏涅")
 ("ska"	"男南楠喃娚遖")
 ("skq"	"納衲")
 ("skd"	"嚢娘曩")
 ("so"	"耐奈内匂乃廼能迺")
 ("sid"	"嬢孃")
 ("su"	"女拏拿茹")
 ("sus"	"年撚碾輾")
 ("suf"	"捏涅")
 ("sua"	"念恬拈棯")
 ("suq"	"摂捻攝躡鑷")
 ("sud"	"寧嚀濘獰聹")
 ("sP"	"禰昵")
 ("sh"	"努奴怒脳呶孥帑弩瑙碯腦臑駑")
 ("shd"	"濃膿農儂")
 ("shk"	"雫")
 ("shl"	"悩脳惱腦餒")
 ("sy"	"溺尿嫋撓橈鐃閙鬧")
 ("sn"	"耨")
 ("sns"	"嫩")
 ("snf"	"吶肭訥")
 ("sb"	"紐忸狃鈕")
 ("sbr"	"忸衄衂")
 ("smd"	"能")
 ("sl"	"泥尼禰祢怩濔瀰膩")
 ("slr"	"溺匿")
 ("slf"	"尼怩昵")
 ("sla"	"賃恁")
 ("ek"	"多大茶夛")
 ("eks"	"円但丹単担旦短端箪胆蛋鍛団壇断檀段椴敦亶單團彖愽慱斷槫湍猯疸緞葮蜑袒襌褝鄲鶉")
 ("ekf"	"達咄妲怛撻燵獺逹闥靼韃")
 ("eka"	"担淡湛耽談曇啖啗壜憺擔毯潭澹痰眈膽蕁覃譚餤")
 ("ekq"	"沓搭答踏剳荅")
 ("ekd"	"党唐塘当糖堂撞儻幢档棠溏當瞠礑螳蟷襠鐺黨")
 ("eo"	"碓対岱帯待戴袋貸隊黛代大敦垈對帶擡抬玳臺薹鐓隶")
 ("ejr"	"徳悳")
 ("eh"	"稲図挑跳堵塗屠徒渡菟賭途都鍍度倒刀島嶋悼桃梼盗淘涛祷到逃陶導萄道叨圖嶌掏掉搗擣朷檮棹櫂盜濤滔睹稻絛綢綯纛荼莵覩跿蹈迯闍韜饕")
 ("ehr"	"竺涜督禿篤毒独読牘犢獨纛讀髑黷")
 ("ehs"	"純噸惇敦沌豚遁頓暾燉瓲遯飩")
 ("ehf"	"突頓咄柮")
 ("ehd"	"諌桐冬凍東棟董働動同憧洞瞳童胴銅僮橦潼疼粡艟苳鮗鶇鼕")
 ("en"	"吋兜逗斗杜土痘豆頭読亠抖竇肚荳蚪蠹蠧讀酘鬥")
 ("ens"	"屯遁頓鈍臀遯")
 ("emr"	"得")
 ("emd"	"登灯燈等藤謄鐙騰嶝橙滕疼磴籐籘縢")
 ("fk"	"刺羅螺裸喇懶瘰癩蘿邏鑼陏騾")
 ("fkr"	"格楽洛絡落酪咯樂烙犖珞駱")
 ("fks"	"乱卵欄蘭亂嬾欒瀾燗爛襴鑾闌鸞")
 ("fkf"	"剌喇埒埓糲辣")
 ("fka"	"嵐濫藍覧儖婪攬欖籃繿纜襤覽醂")
 ("fkq"	"摺蝋拉柆臘臈鑞")
 ("fkd"	"滝瀧廊朗榔浪狼郎朖琅瑯莨螂跟踉")
 ("fo"	"來徠")
 ("fod"	"冷")
 ("fir"	"掠略擽畧")
 ("fid"	"椋掠亮両梁涼糧良諒量倆兩凉喨粱粮裲跟踉輛輌魎")
 ("fu"	"芦蛎砺麿侶慮旅励麗呂録儷勵唳廬梠櫚犂犁癘礪糲絽綟膂臚茘藜蘆蠣蠡鑢閭驢驪")
 ("fur"	"力暦歴屶朸櫟檪櫪瀝癧礫轢轣靂鬲")
 ("fus"	"怜零恋憐漣煉練聯蓮連錬嗹戀揀攣楝聨臠輦鏈鰊")
 ("fuf"	"列劣烈裂冽捩洌")
 ("fua"	"鎌廉簾匳奩斂濂瀲")
 ("fuq"	"猟獵鬣")
 ("fud"	"領令伶嶺怜玲苓鈴零霊齢囹櫺澪羚聆蛉靈鴒齡")
 ("fP"	"豊例礼隷禮茘醴隸鱧")
 ("fh"	"芦鷺櫨蕗虜魯櫓炉賂路露労牢老勞咾撈枦滷潦濾瀘爐癆盧艪艫舮蘆輅轤鑪鈩顱驢鱸鹵")
 ("fhr"	"角漉鹿谷緑麓禄録梺碌祿轆")
 ("fhs"	"論淪")
 ("fhd"	"滝瀧竜龍弄篭聾哢垰壟朧槞瓏籠蘢隴")
 ("fhl"	"瀬頼雷塁賂儡壘擂櫑癩磊籟罍耒蕾藾誄賚")
 ("fy"	"了僚寮料療瞭遼寥廖撩暸燎繚聊蓼醪鐐鷯")
 ("fyd"	"竜龍蘢")
 ("fn"	"屡涙累婁楼漏僂樓犂犁瘻簍縷縲螻褸鏤陋髏")
 ("fnl"	"涙泪")
 ("fb"	"謬柳劉流溜琉留硫瑠塁累類勠嚠壘廖旒榴泪瀏璢瘤繆縲茆鉚鏐霤餾")
 ("fbr"	"陸六勠戮蓼")
 ("fbs"	"倫輪論侖崙崘棆淪綸")
 ("fbf"	"栗律率葎慄篥")
 ("fbd"	"隆嶐窿")
 ("fmr"	"肋仂勒")
 ("fma"	"凛廩懍菻")
 ("fmd"	"綾菱睦凌稜陵崚楞蔆薐")
 ("fl"	"浬鯉糎狸提哩利吏履李梨理璃痢裏裡里離厘麗俚俐悧罹漓犂犁竰籬羸莅莉蜊蠡詈貍釐驪魑鯏黐")
 ("fls"	"燐隣鱗麟吝悋藺躙躪鄰")
 ("fla"	"林淋琳臨痳霖")
 ("flq"	"笠立粒苙")
 ("ak"	"罵馬摩磨魔麻嘛媽麼瑪痲碼蟇蟆")
 ("akr"	"漠莫貌幕膜摸寞藐")
 ("aks"	"鰻挽晩蛮娩万慢満漫蔓湾卍曼巒幔彎弯懣滿灣瞞縵萬蠻謾蹣輓鏝饅鬘")
 ("akf"	"抹末沫眛秣茉襪靺韈")
 ("akd"	"亡忘忙望妄網惘网罔芒茫莽蠎蟒鋩魍")
 ("ao"	"罵媒梅楳煤買売呆某埋妹昧枚毎魅寐瑁苺莓賣邁霾")
 ("aor"	"莫麦百脈獏脉貊貘陌驀麥")
 ("aod"	"虻萌盟猛盲儚氓甍萠黽")
 ("aur"	"冖冪幎汨羃覓")
 ("aus"	"勉眠免棉綿緬面麺俛冕宀湎眄瞑緜麪")
 ("auf"	"蔑滅")
 ("aud"	"皿冥名命明銘鳴暝榠溟瞑茗螟酩黽")
 ("aP"	"袂")
 ("ah"	"姥牡茅莫侮募墓慕暮母帽某冒謀貌鉾膜粍牟矛摸模毛耗姆旄獏瑁瓱皃眸竓糢耄冐莽謨髦鴾")
 ("ahr"	"匹牧穆木目凩朷沐繆苜鶩")
 ("ahf"	"没勿歿沒")
 ("ahd"	"夢蒙冢梦曚朦檬濛矇艨")
 ("ay"	"卯畝猫廟描秒苗錨墓妙杳昴渺眇緲茆藐")
 ("an"	"畝謬撫武舞蕪戊母亡某謀貿務無牟矛霧鵡茂姆巫廡憮懋拇无楙眸繆莽袤誣")
 ("anr"	"冒墨万黙默冐")
 ("ans"	"蚊吻文聞娩免問紋門匁們刎悗懣捫紊")
 ("anf"	"物勿")
 ("al"	"梶謎尾微眉美米味未迷弥媚嵋弭彌濔瀰糜縻薇躾麋靡黴")
 ("als"	"敏民悶岷愍憫旻泯緡罠閔黽")
 ("alf"	"密蜜樒謐")
 ("qkr"	"狛剥博拍泊箔粕舶薄迫爆駁簿撲朴亳搏摶樸溥珀璞膊雹駮魄鰒")
 ("qks"	"伴半反叛搬斑班畔繁般頒飯盤磐扮返弁拌攀槃潘瘢竝絆胖蟠襷蹣")
 ("qkf"	"鉢溌発醗髪抜勃孛悖拔撥渤癶發秡跋髮魃")
 ("qkd"	"倣放方芳訪邦傍坊妨房棒紡肪防匚厖尨幇彭彷旁枋榜滂磅竝膀舫蒡蚌謗錺髣魴")
 ("qo"	"俳拝排杯盃背輩配倍培賠陪白北坏徘憊拜湃焙琲胚裴")
 ("qor"	"栢覇伯拍柏白舶百佰帛霸珀瓸竡粨魄")
 ("qjs"	"幡反繁藩煩番蕃翻旛旙樊潘燔礬繙飜膰袢鐇鷭")
 ("qjf"	"伐罰筏閥罸")
 ("qja"	"帆氾汎犯範凡梵泛笵范")
 ("qjq"	"法琺")
 ("qur"	"副幅僻壁癖碧劈擘檗璧甓薜襞躄辟闢霹")
 ("qus"	"釆変編辺便弁来辨卞扁抃變汳辮胼褊諞辯邊邉駢")
 ("quf"	"批閉別瞥丿暼鼈")
 ("qud"	"病浜瓶丙併兵柄並餅屏并枋榜炳秉竝絣迸餠駢")
 ("qh"	"捗鴇埠普父譜保歩甫補輔菩報宝堡寶寳葆褓鞴黼")
 ("qhr"	"伏副復幅服福腹複覆僕卜撲匐攴攵樸殕濮箙茯蔔蝠蝮袱蹼輻輹馥鰒")
 ("qhs"	"本夲賁")
 ("qhd"	"逢汎封俸奉峰峯捧縫蓬蜂鋒鳳棒泛烽笂篷")
 ("qn"	"釜缶蔀専培否不付埠夫婦富冨府扶敷斧浮父符腐膚芙負賦赴阜附撫部伏副復複覆簿報剖仆俘俯傅咐嘸坿孚孵抔拊枹柎桴榑殕溥罘腑艀苻蜉訃賻趺輻郛釡鳧鳬麩麸黼")
 ("qnr"	"北")
 ("qns"	"体頒匪分噴墳憤扮焚奮粉糞紛雰奔盆吩忿枌氛汾濆犇瓰畚竕笨芬賁")
 ("qnf"	"不弗払沸仏佛彿怫拂朏狒祓髴黻")
 ("qnd"	"棚鮒崩朋鵬堋弸硼繃")
 ("qmr"	"匐")
 ("ql"	"轡匪卑否妃庇悲扉批斐比泌碑秘緋肥誹費非飛備枇毘琵鼻沸箆丕俾匕嚊妣婢屁憊朏榧狒痞痺睥砒祕秕篦粃糒紕羆翡脾腓臂菲蓖蜚裨譬貔豼賁贔鄙隗霏鞁鞴髀鯡")
 ("qls"	"鋲彬斌瀕貧賓頻牝嬪擯檳殯濱繽蘋顰鬢")
 ("qld"	"氷冫冰凭娉憑聘馮騁")
 ("tk"	"卸献些唆沙砂詐鎖裟咋仕伺使司史嗣四士師思斯死獅私糸詞賜飼事似寺璽辞舎写射捨赦斜社紗謝蛇邪食笥乍覗巳蓑貰亊俟冩厶嗄奢娑寫徙柤梭槎泗洒渣瀉灑犧獻畭祀祠竢篩簑簔絲耜肆舍莎乕辭釶鉈駟駛鯊鰤麝")
 ("tkr"	"削朔索数嗽數槊爍鑠")
 ("tks"	"傘山撒散珊産算酸蒜刪杣汕疝繖跚閂閊")
 ("tkf"	"殺薩撒蔡")
 ("tka"	"三参森杉參彡滲糂纔罧芟蔘衫")
 ("tkq"	"扱渋挿插歃澁澀霎颯")
 ("tkd"	"桑向傷償商嘗尚床湘祥裳詳象賞上常状双喪爽想相霜像滝瀧湯峠橡箱様雙嫦孀庠廂慯樣殤牀甞翔裃觴謫鱶")
 ("to"	"塞璽洒灑腮賽顋鰓")
 ("tor"	"塞咋索色嗇愬槭穡薔")
 ("tod"	"甥省牲生猩笙")
 ("tid"	"餉")
 ("tj"	"黍犀暑曙庶緒署書薯藷叙序徐恕鋤瑞棲栖西誓逝鼠挑婿舒噬墅壻嶼抒敍敘筮絮耡聟胥黎鼡")
 ("tjr"	"潟汐射釈錫席惜昔析石碩夕淅皙蓆蜥螫裼釋鉐")
 ("tjs"	"還蝉仙先宣扇撰洗煽旋線羨腺船選銑鮮善禅繕膳単亘僊單嬋尠愃洒燹癬禪綫譱舩蘚跣霰")
 ("tjf"	"洩屑契折設説雪舌鱈苫囓挈楔泄渫紲絏緤薛褻齧")
 ("tja"	"繊閃孅暹歙殲殱笘纖纎蟾譫贍銛")
 ("tjq"	"拾渉摺摂燮囁慴懾攝聶躡鑷顳")
 ("tjd"	"省城姓性成星盛聖声誠醒惺晟猩筬聲腥")
 ("tp"	"歳細笹世勢税説洗貰彗洒蛻")
 ("th"	"鯵繰咲篠所召哨宵小少昭梢沼消焼硝笑紹肖鞘塑疏疎素蘇訴遡掃掻巣燥騒蛸疋劭嘯嫂愬梳樔毟泝溯瀟燒甦筱簫艘蔬蕭蘓譟踈逍邵釖銷霄韶騷鮹鰺")
 ("thr"	"粟束速俗属続屬續謖贖")
 ("ths"	"餐孫損遜巽")
 ("thf"	"率蟀")
 ("thd"	"松訟宋送悚枩淞竦舂蚣誦鎹頌鬆")
 ("thkf"	"刷")
 ("tho"	"鎖砕刷殺晒洒灑瑣碎")
 ("thl"	"粋衰夊")
 ("tn"	"守手殊狩首受寿授樹綬需囚収修愁秀繍蒐讐酬獣宿須垂帥水睡遂随瑞髄数捜痩袖竪誰嬬穂薮輸率叟售嗾嗽埀壽嫂岫戍搜收數殳泅洙溲漱燧獸祟穗籔粹綉綏繻羞脩隋膸茱莎蓚藪雖讎豎隨酥銖銹鏥陲隧髓鬚")
 ("tnr"	"叔夙宿淑縮粛塾熟俶孰倏肅菽蓿")
 ("tns"	"瞬舜駿循旬楯殉淳盾純巡醇順馴徇恂洵筍笋脣荀蓴蕣詢諄鐓鶉")
 ("tnf"	"術述率恤戌朮")
 ("tnd"	"崇嵩菘")
 ("tnl"	"倅伜淬")
 ("tmf"	"膝瑟虱蝨")
 ("tmq"	"湿拾習襲濕褶隰")
 ("tmd"	"勝升承昇丞乗剰僧縄蝿乘剩甸枡繩蠅陞")
 ("tl"	"飴柿匙殺使始屍市施視詩試侍寺時示蒔偲柴是提矢厮啻嗜嘶尸屎廝弑恃撕猜翅腮舐葹蓍諡豕豺顋")
 ("tlr"	"喰式識埴飾拭植殖食蝕息寔熄軾餝")
 ("tls"	"榊伸信娠慎新申神紳臣薪身辛腎訊迅辰矧噺呻哂宸愼抻晨燼蜃贐頤鰰")
 ("tlf"	"失室悉実實榁蟋")
 ("tla"	"参審心深芯尋甚參忱椹沁潯瀋蕈鐔")
 ("tlq"	"拾什十渋辻卅丗澁澀瓧竍籵")
 ("Tkd"	"双雙")
 ("Tl"	"氏")
 ("dk"	"亜唖阿俄峨我牙芽蛾雅餓涯御児亞兒哦娥婀峩椏猗痾莪衙襾訝錏鐚鴉鵝鵞")
 ("dkr"	"亜悪握渥岳楽顎鍔鰐亞咢堊嶽幄惡愕樂萼蕚葯諤鄂鶚齷齶")
 ("dks"	"安按案鞍岸眼贋雁顔諺偐晏殷顏鮟鴈鳫")
 ("dkf"	"斡按謁戛戞蘗蘖歹訐軋遏閼靄")
 ("dka"	"庵暗闇厭俺巌癌岩嵒巖菴諳頷黯黶")
 ("dkq"	"姶圧押鴨哈壓狎")
 ("dkd"	"央仰昂怏殃泱秧鞅鴦")
 ("do"	"哀愛挨崖涯碍喝啀嗄噫埃崕曖欸皚睚瞹磑礙艾藹阨隘靄靉饐")
 ("dor"	"液額夜厄扼掖腋軛阨隘")
 ("dod"	"嚶櫻罌鶯鸚")
 ("di"	"射斜邪若惹埜也冶夜爺耶野揶椰鵺")
 ("dir"	"鰯若弱約薬躍嫋搦籥葯蒻藥鑰鶸龠")
 ("did"	"詳壌嬢穣譲醸揚楊様洋羊陽養佯壤孃恙攘昜暘樣漾瀁煬痒瘍癢禳穰襄讓釀驤")
 ("dj"	"於漁禦魚御語唹圄圉淤飫馭鯲齬")
 ("djr"	"億憶臆疑抑檍")
 ("djs"	"堰言諺這彦偃嫣焉篶")
 ("djf"	"蘗蘖")
 ("dja"	"奄掩俺巌岩験厳儼厂嚴巖广淹罨閹驗")
 ("djq"	"業")
 ("dp"	"恚殪")
 ("du"	"汝如予余与誉輿預豫歟洳畭絮舁與茹蕷蜍譽餘")
 ("dur"	"易域疫駅逆射亦役訳懌繹蜴譯閠閾霓驛鯣")
 ("dus"	"咽宴延沿演煙燕縁鉛研硯次然鳶軟燃淵吮嚥妍娟悁捐掾椽櫞衍涓涎渊烟筵臙莚蜒蠕讌")
 ("duf"	"咽悦閲説熱吶噎齧")
 ("dua"	"厭炎焔艶塩染稔冉檐艷苒閻髯魘鯰鹽黶")
 ("duq"	"厭葉囁曄靨")
 ("dud"	"営嬰影映栄永泳瑛盈穎頴英詠景迎咏營塋佞侫暎楹榮潁瀛瑩瓔珱纓蠑贏郢霙")
 ("dP"	"医叡曳洩鋭刈詣芸児蕊誉預乂豫倪兒兌囈曵泄猊睨睿穢翳艾蘂蕋藝蚋裔譽貎霓鯢麑")
 ("dh"	"悪烏迂於汚奥襖五伍午呉吾娯悟梧誤傲唔嗚嗷塢墺奧媼寤忤惡懊敖晤澳熬燠牾珸蜈螯遨鏖鰲鼇")
 ("dhr"	"阿屋玉獄沃")
 ("dhs"	"温穏慍瘟穩薀蘊褞鰮鰛")
 ("dhf"	"兀榲膃")
 ("dhd"	"翁擁壅廱瓮甕癰禺蓊雍鶲")
 ("dhk"	"娃渦臥蛙瓦窪哇囮窩萵蝸訛譌")
 ("dhks"	"宛完緩莞関玩翫頑椀碗腕婉浣澣蜿豌關")
 ("dhkf"	"曰")
 ("dhkd"	"往旺王皇尢徃枉汪")
 ("dho"	"娃蛙倭哇矮蝸")
 ("dhl"	"畏外隈嵬巍猥磑薈鮠")
 ("dy"	"凹楽尭腰擾銚陶約妖揺曜窯耀要謡遥僥夭姚嬲嫐嶢幺徭徼拗搖撓樂橈殀澆燿瑶窈窰繞蕘蟯謠遶邀饒鷂堯遙瑤")
 ("dyr"	"辱谷慾欲浴峪溽縟蓐褥")
 ("dyd"	"桶茸勇湧涌傭容庸溶熔用蓉踊俑慂慵榕甬聳舂蛹踴鎔頌")
 ("dn"	"芋右宇羽迂雨欧殴牛区愚虞偶寓遇隅枢又尤佑優友憂祐郵于傴吁吽嵎樞歐毆疣盂禹禺紆肬藕謳麌齲")
 ("dnr"	"旭郁勗墺澳燠")
 ("dns"	"員韻云運雲暈殞熕紜耘隕韵")
 ("dnf"	"宛尉欝蔚鬱熨")
 ("dnd"	"熊雄")
 ("dnjs"	"宛員院園怨援猿苑薗遠鴛垣願元原源媛冤圓圜婉寃愿湲爰芫蜿袁諢轅鋺阮隕")
 ("dnjf"	"越月戉曰粤鉞")
 ("dnl"	"葦位偉囲委威尉慰為緯胃萎謂違蔚衛危偽倭僞喟囗圍幃渭爲痿縅莠蝟衞逶韋魏")
 ("db"	"惟維遺桜儒柔嬬酉楢肉乳濡鮪愉愈油癒諭輸唯宥幽悠有柚猶猷由裕誘遊幼侑兪喩囿孺帷懦揉揄攸楡渝游瑜瘉糅綏腴臾萸蕕蚰蝓蝣蠕襦覦諛蹂踰逾釉鍮鞣黝鼬")
 ("dbr"	"育粥肉囿毓鬻")
 ("dbs"	"允胤閏潤尹贇酳")
 ("dbf"	"聿鴪")
 ("dbd"	"戎融絨")
 ("dms"	"隠恩銀听圻垠慇憖殷犹隱齦")
 ("dmf"	"乙疑")
 ("dma"	"飲淫蔭陰音疑吟吽婬崟飮霪")
 ("dmq"	"泣揖邑悒")
 ("dmd"	"応疑凝鷹蝿應膺蠅軅軈")
 ("dml"	"依意椅衣涯毅儀宜擬疑義蟻誼議歪倚崕嶬嶷懿欹熨猗矣礒縊艤醫饐")
 ("dl"	"飴以伊夷易異移餌施爾而耳蛇食詑台弛寅二迩弍姨尓已彝彜怡洟珥甅痍肄苡詒貽貳貮轜邇隶")
 ("dlr"	"益翌翼嶷弋杙翊謚鷁")
 ("dls"	"印咽因姻引煙人仁刃靭寅忍認籾仞仭儿刄堙孕廴氤湮烟茵荵蚓靱")
 ("dlf"	"一壱溢逸日弌佚壹衵釼鎰")
 ("dla"	"荏壬賃任妊稔姙恁衽袵")
 ("dlq"	"込廿入叺圦鳰")
 ("dld"	"剰仍剩孕")
 ("wk"	"梓茨佐左査剤作仔刺姉姿子孜紫諮資雌字慈滋磁自煮者斉積柘髭偖劑呰咨孳恣滓炙瓷疵眥眦粢苴茲蔗藉薺觜貲齎赭鮓鷓齊")
 ("wkr"	"作昨勺杓灼爵酌酢雀嚼妁寉斫柞炸筰綽芍醋鵲")
 ("wks"	"桟残孱戔棧殘潺盞")
 ("wka"	"蚕暫潜湛岑潛濳箴簪蠶賺鏨")
 ("wkq"	"雑匝挿喋囃插箚襍雜")
 ("wkd"	"匠奨将庄掌樟章粧蒋醤障丈場杖状壮荘葬装臓蔵帳張腸長撞仗塲墻壯奘奬妝將嶂弉橦檣淙漿爿牆獎璋瘴膓臟臧艢莊萇薔藏裝贓賍鏘鱆")
 ("wo"	"再哉宰才災斎裁載在材財柴斉存滓齋縡纔豺齎齊")
 ("wod"	"噌槍争鎗崢幀爭瞠箏筝諍錚")
 ("wj"	"姐且杵煮渚藷諸鋤除岨狙樗瀦猪苧著貯低底抵邸屠這箸儲佇咀弖抒杼柢楮沮潴牴疽砠竚紵羝耡苴蛆觝詆豬躇雎齟")
 ("wjr"	"荻借寂積籍績赤跡蹟賊逐嫡弔吊摘敵滴的笛適鏑躍勣廸炙狄癪磧糴芍藉覿迪迹逖")
 ("wjs"	"鴫竣戦栓栴煎箭詮銭前全揃樽佃典填展纏転顛伝殿澱田電縛畑槙淀傳剪甸吮囀奠專巓廛悛戔戰畋旃氈沺濺牋甎痊癜癲磚筌箋篆纒羶翦腆趁躔輾轉鈿銓錢鐫雋靦顫餞饌鷆鷏槇")
 ("wjf"	"準切拙折窃節絶窒姪凖卩咥截晢晰浙竊耋跌軼")
 ("wja"	"鮎占漸店点苫粘岾簟霑黏點")
 ("wjq"	"接蝶慴椄楫楪沾渫聶鰈")
 ("wjd"	"井鯖晶証鉦情浄錠征政整正精静打丁町頂亭停偵貞呈定庭廷挺汀碇禎程艇訂鄭釘鼎瀞柾靖淀丼叮幀掟旌梃淨渟甼疔睛穽聢菁蟶逞遉酊酲鐺霆靜")
 ("wp"	"鵜栽済祭際剤諸除制製斉折第醍題堤帝弟悌提梯蹄俤儕劑擠晢濟眥眦睇臍薺齎躋霽齏韲齊")
 ("wh"	"竃繰錯惨篠助昭照詔条岨措祖租粗組阻操早曹槽漕燥糟藻遭造鯛兆凋弔彫朝潮眺調跳銚鳥蔦爪吊釣敦蚤肇佻俎嘲噪徂慘慥懆找抓晁條梍棗棹澡爼砠祚稠窕竈笊糶絛罩耡胙艚蜩詛誂譟趙躁鑿雕髞")
 ("whr"	"足族簇蔟鏃")
 ("whs"	"尊拵")
 ("whf"	"拙卒枠卆猝")
 ("whd"	"種腫宗終従縦鍾鐘綜柊从從慫棕椶樅淙粽縱螽踵蹤踪鑁")
 ("whk"	"佐左坐座挫")
 ("whl"	"罪")
 ("wy"	"釖")
 ("wn"	"株作主朱珠酒呪周州洲舟週住祝厨奏走足族宙昼柱注註酎鋳駐調紬肘湊丶侏做儔冑嗾廚晝疇畴稠籌籀紂綢胄蔟蛛誅赱躊輳遒鑄麈")
 ("wnr"	"粥竹鬻")
 ("wns"	"噂俊峻竣駿準純遵屯隼鱒儁凖墫恂悛惷浚濬皴蠢蹲逡")
 ("wnd"	"衆重中仲")
 ("wmr"	"即賊")
 ("wmf"	"櫛")
 ("wma"	"怎")
 ("wmq"	"輯汁葺揖楫緝")
 ("wmd"	"絵甑症証蒸噌曾曽増憎贈徴拯橙烝證")
 ("wl"	"岐祇志指支旨枝止祉紙肢脂至誌持識質芝織只知地智池蜘遅漬底抵砥之咫址塒帋弖摯枳沚痣祗耆胝舐觝貭贄趾踟躓輊遲阯鮨鷙")
 ("wlr"	"織職直喞稙稷")
 ("wls"	"唇振晋榛疹真秦診進震塵尽陣辰珍鎮陳津填賑侭儘嗔晉殄燼珎甄畛盡眞瞋縉臻蓁袗趁軫鎭")
 ("wlf"	"叱嫉疾質秩窒迭蛭姪佚咥喞垤帙桎耋膣腟貭跌軼")
 ("wla"	"朕斟酖鴆")
 ("wlq"	"執輯集汁緝")
 ("wld"	"澄徴懲澂")
 ("ck"	"且此叉嵯差瑳車遮借詫侘嗟岔嵳扠搓朿槎磋箚苴蹉釵")
 ("ckr"	"搾窄錯昔捉濁着著戳縒躇鑿齣齪")
 ("cks"	"燦纂讃賛餐撰簒攅爨竄粲纉讚贊鏨鑽鑚饌")
 ("ckf"	"察拶擦札刹扎獺紮")
 ("cka"	"参惨斬漸僭僣參塹嶄巉慘慙慚懺懴槧站譖譛讒讖驂")
 ("ckd"	"唱娼廠彰昌菖椙創倉槍窓蒼暢脹畠倡剏厰悵愴搶敞昶淌滄漲猖瘡窗艙蹌鬯")
 ("co"	"差債彩採采砦祭菜柴責莱寨綵蔡豸釵靫")
 ("cor"	"咋柵窄策冊責措册嘖拆柞磔筴簀")
 ("cj"	"妻処凄狙處悽淒絮萋")
 ("cjr"	"刺尺隻戚斥脊捗剔呎彳擲滌瘠蜴跖蹐蹠躑陟鶺")
 ("cjs"	"茜粁串釧蚕千川撰泉浅穿舛薦賎践遷辿天仟倩刋喘巛擅栫楾淺湶濺瓩竏荐賤踐闡阡韆")
 ("cjf"	"綴哲徹撤轍鉄凸畷啜屮掣輟銕錣鐵鐡餮")
 ("cja"	"鹸尖添甜僉忝恬槧檐沾瞻簷簽籤籖蟾覘諂譫")
 ("cjq"	"妾捷畳喋帖牒諜貼疊疉疂睫褶輒輙")
 ("cjd"	"鯖錆晴清請青庁聴廳廰聽菁蜻")
 ("cp"	"切体替滞逮綴剃締諦逓薙畷啼嚔嚏掣楴涕滯睇砌蒂蔕裼躰軆遞靆體髢")
 ("ch"	"鍬初哨抄招樵焦硝礁肖蕉鞘酢楚礎草超銚秒剿劭勦屮峭悄愀憔杪椒湫炒稍艸誚貂迢醋鈔髫鷦齠")
 ("chr"	"趣嘱燭触数促属囑屬數矗矚簇蜀觸躅鏃髑")
 ("chs"	"吋寸村忖邨")
 ("chd"	"従銃叢惣総聡寵塚憧葱竜龍从偬匆從怱愡總縱聰")
 ("chl"	"催最崔摧榱洒")
 ("cn"	"穐丑鰍取趣就愁秋臭酋醜出諏推錐錘枢趨雛粗畜抽墜椎槌追鎚萩鷲啾娵婢帚惆掫捶楸樞湫甃皺龝箒簇縋聚芻蒭鄒陬隹鞦騅驟鰌麁")
 ("cnr"	"丑竺軸蹴祝縮築畜筑蓄逐柚槭舳蹙")
 ("cns"	"春椿鰆")
 ("cnf"	"出朮黜")
 ("cnd"	"沖充銃衝忠虫衷傭冲狆艟蟲")
 ("cnp"	"悴忰惴瘁萃贅")
 ("cnl"	"取趣就臭吹炊翠酔脆鷲嘴娶惴揣橇毳瘁翆聚膵萃觜醉驟")
 ("cmr"	"側則測捗仄惻昃")
 ("cms"	"齔")
 ("cma"	"闖")
 ("cmd"	"曾曽層")
 ("cl"	"嵯差歯治痔埴植織値恥痴稚置致馳徴直薙侈卮厠嗤夂峙巵幟廁梔熾畄畤癡碪穉笞紕緇緻耻蚩褫豸跂輜錙雉魑鯔鴟鵄黹齒")
 ("clr"	"則測勅飭厠廁惻敕")
 ("cls"	"親襯齔")
 ("clf"	"七漆")
 ("cla"	"砧侵寝浸針湛沈枕寢忱斟椹鍼鍖闖駸")
 ("clq"	"蟄")
 ("cld"	"称秤稱袮騁")
 ("cho"	"快夬獪")
 ("xk"	"蛇他詑唾堕妥惰打柁舵楕陀駄騨池詫佗咤墮它捶揣朶橢沱隋躱駝鴕")
 ("xkr"	"卓啄托拓沢濯琢託鐸濁擢度倬啅拆柝澤鈬魄")
 ("xks"	"騨嘆坦歎炭綻誕弾呑灘彈憚攤殫袒")
 ("xkf"	"奪脱")
 ("xka"	"探耽眈貪")
 ("xkq"	"塔搭搨榻鞜鞳鰈")
 ("xkd"	"宕湯糖蕩帑盪蝪")
 ("xo"	"税太汰怠態泰胎苔逮台大能殆戻兌棣笞紿蛻詒颱駘")
 ("xor"	"宅択沢擇澤")
 ("xh"	"兎吐菟土套討兔莵")
 ("xhs"	"褪")
 ("xhd"	"桶痛通筒統樋恫慟")
 ("xhl"	"推堆腿退槌追鎚敦褪頽")
 ("xn"	"妬投透闘愉偸綉鍮骰鬪")
 ("xmr"	"貸特慝")
 ("vk"	"頗巴把播杷波派琶破婆芭罷簸坡怕擺霸爬玻碆笆耙膰菠葩袙跛陂")
 ("vks"	"坂阪判板版販辧汳瓣鈑")
 ("vkf"	"捌八叭杁釟")
 ("vo"	"唄貝派敗牌背倍狽抜罷稗佩孛悖拔旆霸沛珮霈")
 ("vod"	"棚烹傍膨弸彭旁澎磅繃")
 ("vir"	"愎")
 ("vus"	"平偏片篇編遍便鞭扁翩苹蝙褊諞騙")
 ("vua"	"貶")
 ("vud"	"坪評浜平怦泙硼苹萍鮃")
 ("vP"	"柿廃肺幣弊蔽閉陛吠嬖幤廢敝斃癈薜髀")
 ("vh"	"浦鞄蒲曝爆布怖葡舗鋪圃捕包庖抱泡砲胞褒飽暴勹匍匏咆哺垉抛枹瀑炮疱皰脯舖苞袍襃逋鉋靤餔髱鮑鯆麭")
 ("vhr"	"曝爆幅暴瀑")
 ("vy"	"杓俵彪標漂瓢票表豹剽嫖慓殍縹飄飃飆驃驫髟鰾")
 ("vns"	"分")
 ("vna"	"品稟禀")
 ("vnd"	"楓風豊瘋諷豐颪馮")
 ("vb"	"彪")
 ("vl"	"彼披疲皮罷被避跛辟陂")
 ("vlf"	"嘩比泌匹疋弼必畢筆払仏佛拂篳譁蹕鵯")
 ("vlq"	"逼幅乏泛")
 ("gk"	"下何夏河荷蝦霞賀嚇雫厦呀廈渮瑕緞罅訶谺遐鍜鰕")
 ("gkr"	"鴬学虐鶴壑學斈涸狢瘧謔貉鷽")
 ("gks"	"寒汗漢翰閑韓限恨嫺嫻悍扞捍旱桿瀚狠皖罕邯駻骭鼾")
 ("gkf"	"害割喝轄劼瞎蝎黠")
 ("gka"	"艦陥含函濫凾咸啣喊嵌檻涵緘莟邯銜陷頷餡鰔鹹")
 ("gkq"	"蓋閤合蛤呷哈溘盍盖盒葢闔鴿")
 ("gkd"	"桁巷恒抗杭港航行降項虹亢伉吭恆缸肛閧頏鬨")
 ("go"	"亥解械海蟹劾咳害該骸鮭偕垓夥奚孩廨懈楷薤蠏觧諧邂醢駭")
 ("gor"	"劾核硅覈輅")
 ("god"	"杏倖幸行絎裄鵆")
 ("gid"	"享郷響饗向香嚮餉")
 ("gj"	"嘘虚許墟栩歔滸")
 ("gjs"	"憲献軒掀獻")
 ("gjf"	"歇蝎蠍")
 ("gja"	"険験嶮險驗")
 ("gur"	"嚇赫革恵奕洫鬩")
 ("gus"	"絢懸県見賢顕弦玄現絃舷項頁俔呟洵痃眩縣蜆衒鉉顯")
 ("guf"	"穴血冗頁孟孑襭頡")
 ("gua"	"嫌")
 ("guq"	"袷叶侠協峡挟狭脅頬脇夾峽慊挾浹狹筴篋莢鋏陜陝")
 ("gud"	"馨亨刑兄型形荊蛍桁衡夐炯烱瑩脛螢迥")
 ("gP"	"慧繋兮匸奚彗惠盻禊蹊醯鞋")
 ("gh"	"穫乎呼弧戸湖狐糊胡虎雇互吾瑚護醐好浩号壕濠豪冴皐縞壷冱壺怙戲昊晧楜毫沍滬滸犒琥瓠皋皓葫蒿虍號蝴扈鎬餬")
 ("ghr"	"或酷鵠惑寉斛")
 ("ghs"	"婚昏昆混魂棍棔渾溷焜琿")
 ("ghf"	"核忽惚歿笏鶻")
 ("ghq"	"恰")
 ("ghd"	"弘洪紅鴻哄汞泓訌閧鬨")
 ("ghk"	"化火禍禾花華貨画椛樺靴樗和話啝崋畫糀錵")
 ("ghkr"	"拡獲確穫擴攫癨矍蠖霍")
 ("ghks"	"喚患換桓歓環還丸幻亘圜奐宦寰懽歡渙湲煥皖眩矜讙豢鐶驩鬟鰥")
 ("ghkf"	"越活滑撮猾磆蛞豁闊濶")
 ("ghkd"	"黄況兄慌晃皇荒幌况凰徨恍惶晄湟滉煌篁簧肓蝗遑隍鰉")
 ("gho"	"画罫獪畫")
 ("ghl"	"会回壊廻悔恢懐晦灰准桧賄會囘匯壞徊懷檜槐淮繪膾茴薈蛔詼誨迴鱠")
 ("ghlr"	"画劃獲畫")
 ("ghld"	"横弘衡轟薨軣鍠黌")
 ("gy"	"暁佼効校酵肴傚哮嚆囂效曉梟淆烋爻驕驍")
 ("gn"	"芋朽後侯候厚后喉佝吼嗅嘔涸煦猴篌詬逅")
 ("gns"	"勲薫訓馴勳熏燻葷醺")
 ("gnd"	"薨")
 ("gnjs"	"萱喧暖愃暄萓諠讙")
 ("gnp"	"虫卉喙毀燬")
 ("gnl"	"揮徽輝彙戲暉麾諱")
 ("gb"	"休携畦畜攜烋虧貅")
 ("gbr"	"畜")
 ("gbf"	"恤譎鷸")
 ("gbd"	"兇凶胸匈恟洶")
 ("gmr"	"黒釛")
 ("gms"	"欣痕很忻掀釁")
 ("gmf"	"汽吃迄屹訖")
 ("gma"	"欽欠")
 ("gmq"	"吸歙洽皀翕")
 ("gmd"	"興虹")
 ("gml"	"喜嬉希稀戯犠姫僖咥唏噫愾憙戲晞曦欷煕熈熹燹犧禧羲釐鯑")
 ("glf"	"詰纈襭頡黠")
 ("unknown"	"苅宍栂栃凪弐塀俣杢刔夘咒哘唸囎圀圷圸垳垪埔埖埣塰堽墹墸壗壥嬶屓乢妛岫岻岶岼峅峇峺嵶彁怺恷恊抂挧掵擶暃杤桙梹椥椨椪椚椣椡槝樮櫁樌橲樶橸樢檸欟歛汢渕淕溂潸澑犲畉畆畩蘯眤瞶硴碚碵礇禝穃邃笶筅箟篏簓簗籏粐粭粫糘綛縺繧纃緕纐罎膤艝茣莇菷萢蒄蓙蘰蚫蛯蟐袞袰褄諚戝轌辷迚逧逎鍄錻閇閖陦隲靹鞆鞐饂馼駲鮖鮴鯒鯱鰄鰡鱚鵈鵤鵐"))

;;; hanja-jis.el ends here
