/* ANTLRToken.h
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 *
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.33
 * Terence Parr
 * Parr Research Corporation
 * with Purdue University and AHPCRC, University of Minnesota
 * 1989-1998
 */

#ifndef ATOKEN_H_GATE
#define ATOKEN_H_GATE

#include "pcctscfg.h"

#include "pccts_string.h"
#include "pccts_stdio.h"
#include "pccts_stdlib.h"

PCCTS_NAMESPACE_STD

#ifndef ANTLRCommonTokenTEXTSIZE
#define ANTLRCommonTokenTEXTSIZE        	100
#endif

/* must define what a char looks like; can make this a class too */
typedef char ANTLRChar;

/* D E F I N E  S M A R T  P O I N T E R S */

#include "pcctscfg.h"

//#include ATOKPTR_H   not tested yet, leave out
class ANTLRAbstractToken;
typedef ANTLRAbstractToken *_ANTLRTokenPtr;

class DllExportPCCTS ANTLRAbstractToken {
public:
    virtual ~ANTLRAbstractToken() {;}
    virtual ANTLRTokenType getType() = 0;
    virtual void setType(ANTLRTokenType t) = 0;
    virtual int getLine() = 0;
    virtual void setLine(int line) = 0;
    virtual ANTLRChar *getText() = 0;
    virtual void setText(ANTLRChar *) = 0;

    /* This function will disappear when I can use templates */
	virtual ANTLRAbstractToken *makeToken(ANTLRTokenType tt,
										  ANTLRChar *text,
										  int line) = 0;

	/* define to satisfy ANTLRTokenBuffer's need to determine whether or
	   not a token object can be destroyed.  If nref()==0, no one has
	   a reference, and the object may be destroyed.  This function defaults
	   to 1, hence, if you use deleteTokens() message with a token object
	   not derived from ANTLRCommonRefCountToken, the parser will compile
	   but will not delete objects after they leave the token buffer.
    */
	virtual unsigned nref() { return 1; }
	virtual void ref() {;}
	virtual void deref() {;}

	virtual void panic(char *msg)
		{
			fprintf(stderr, "ANTLRAbstractToken panic: %s\n", msg);
			exit(PCCTS_EXIT_FAILURE);
		}
};

/* This class should be subclassed.  It cannot store token type or text */

class DllExportPCCTS ANTLRRefCountToken : public ANTLRAbstractToken {
public:
#ifdef DBG_REFCOUNTTOKEN
	static int ctor;
	static int dtor;
#endif
protected:
    unsigned refcnt_;
#ifdef DBG_REFCOUNTTOKEN
	char object[200];
#endif

public:
	ANTLRRefCountToken(ANTLRTokenType t, ANTLRChar *s)
#ifndef DBG_REFCOUNTTOKEN
		{
			refcnt_ = 0;
		}
#else
	{
		ctor++;
		refcnt_ = 0;
		if ( t==1 ) sprintf(object,"tok_EOF");
		else sprintf(object,"tok_%s",s);
		fprintf(stderr, "ctor %s #%d\n",object,ctor);
	}
#endif
	ANTLRRefCountToken()
#ifndef DBG_REFCOUNTTOKEN
		{ refcnt_ = 0; }
#else
		{
			ctor++;
			refcnt_ = 0;
			sprintf(object,"tok_blank");
			fprintf(stderr, "ctor %s #%d\n",object,ctor);
		}
	virtual ~ANTLRRefCountToken()
		{
			dtor++;
			if ( dtor>ctor ) fprintf(stderr, "WARNING: dtor>ctor\n");
			fprintf(stderr, "dtor %s #%d\n", object, dtor);
			object[0]='\0';
		}
#endif

	// reference counting stuff needed by ANTLRTokenPtr.
	// User should not access these; for C++ language reasons, we had
	// to make these public.  Yuck.
	void ref()		{ refcnt_++; }
	void deref()	{ refcnt_--; }
	unsigned nref()	{ return refcnt_; }

	virtual ANTLRAbstractToken *makeToken(ANTLRTokenType tt,
										  ANTLRChar *txt,
										  int line)
	{
		panic("call to ANTLRRefCountToken::makeToken()\n");
		return NULL;
	}
};

class DllExportPCCTS ANTLRCommonNoRefCountToken : public ANTLRAbstractToken {
protected:
	ANTLRTokenType _type;
	int _line;
	ANTLRChar _text[ANTLRCommonTokenTEXTSIZE+1];

public:
	ANTLRCommonNoRefCountToken(ANTLRTokenType t, ANTLRChar *s)
		{ setType(t); _line = 0; setText(s); }
	ANTLRCommonNoRefCountToken()
		{ setType((ANTLRTokenType)0); _line = 0; setText(""); }

	ANTLRTokenType getType() 	{ return _type; }
	void setType(ANTLRTokenType t)	{ _type = t; }
	virtual int getLine() 		{ return _line; }
	void setLine(int line)		{ _line = line; }
	ANTLRChar *getText() 		{ return _text; }
	void setText(ANTLRChar *s)
		{ strncpy((char *)_text, (char *)s, ANTLRCommonTokenTEXTSIZE); }
	virtual ANTLRAbstractToken *makeToken(ANTLRTokenType tt,
										  ANTLRChar *txt,
										  int line)
		{
			ANTLRAbstractToken *t = new ANTLRCommonNoRefCountToken;
			t->setType(tt); t->setText(txt); t->setLine(line);
			return t;
		}
};

class DllExportPCCTS ANTLRCommonToken : public ANTLRRefCountToken {
protected:
	ANTLRTokenType _type;
	int _line;
	ANTLRChar _text[ANTLRCommonTokenTEXTSIZE+1];

public:
	ANTLRCommonToken(ANTLRTokenType t, ANTLRChar *s) : ANTLRRefCountToken(t,s)
		{ setType(t); _line = 0; setText(s); }
	ANTLRCommonToken()
		{ setType((ANTLRTokenType)0); _line = 0; setText(""); }
	virtual ~ANTLRCommonToken() {;}

	ANTLRTokenType getType() 	{ return _type; }
	void setType(ANTLRTokenType t)	{ _type = t; }
	virtual int getLine() 		{ return _line; }
	void setLine(int line)		{ _line = line; }
	ANTLRChar *getText() 		{ return _text; }
	void setText(ANTLRChar *s)
		{ strncpy((char *)_text, (char *)s, ANTLRCommonTokenTEXTSIZE); }
	virtual ANTLRAbstractToken *makeToken(ANTLRTokenType tt,
										  ANTLRChar *txt,
										  int line)
		{
			ANTLRAbstractToken *t = new ANTLRCommonToken(tt,txt);
			t->setLine(line);
			return t;
		}
};

// used for backward compatibility
typedef ANTLRCommonToken ANTLRCommonBacktrackingToken;

#endif
