/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.tool.re.Node;
import net.sf.jiapi.tool.re.SimpleStatement;
import net.sf.jiapi.tool.re.SimpleStatementBuilder;
import net.sf.jiapi.tool.re.Statement;

class BlockStatement
extends Statement {
    BlockStatement(Node n) {
        super(n);
    }

    @Override
    Node getNextNode() {
        if (this.getStartNode().getSuccessors().size() == 0) {
            return null;
        }
        return this.getStartNode().getSuccessors().iterator().next();
    }

    public List<SimpleStatement> getSimpleStatements() {
        Node n = this.getStartNode();
        if (n.equals(Node.EXIT_NODE)) {
            return new LinkedList<SimpleStatement>();
        }
        SimpleStatementBuilder ssb = new SimpleStatementBuilder();
        return ssb.createSimpleStatements(n.getBasicBlock().getInstructionList());
    }

    public String toString() {
        return "BlockStatement(" + this.getStartNode().getId() + ")" + this.getSimpleStatements();
    }
}

