/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.AnnotationBase;

public class ParameterAnnotationsAttribute
extends AnnotationBase {
    private List<AnnotationBase.Annotation>[] parameter_annotations;

    public ParameterAnnotationsAttribute(ConstantPool cp, short nameIndex, int length, DataInputStream dis) throws IOException {
        super(cp, nameIndex, length, dis);
        dis = this.getDataInputStream();
        int num_parameters = dis.readByte();
        this.parameter_annotations = new List[num_parameters];
        for (int i = 0; i < num_parameters; ++i) {
            LinkedList<AnnotationBase.Annotation> annotations = new LinkedList<AnnotationBase.Annotation>();
            int num_annotations = dis.readShort();
            for (int j = 0; j < num_annotations; ++j) {
                annotations.add(this.readAnnotation(dis));
            }
            this.parameter_annotations[i] = annotations;
        }
        if (dis.available() != 0) {
            System.out.println("Read annotations, dis.available(): " + dis.available() + ". Some part of annotation structure is not read");
        }
    }

    public List<AnnotationBase.Annotation>[] getParameterAnnotations() {
        return this.parameter_annotations;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + ":");
        for (int i = 0; i < this.parameter_annotations.length; ++i) {
            sb.append(this.parameter_annotations[i]);
        }
        return sb.toString();
    }
}

