/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_nport_ip_h__
#define __ls10_dev_nport_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_NPORT          0x00007fff:0x00000000 /* RW--D */
#define NV_NPORT_CTRL                                      0x00000040      /* RW-4R */
#define NV_NPORT_CTRL_TRUNKLINKENB                         0:0             /* RWEVF */
#define NV_NPORT_CTRL_TRUNKLINKENB_TRUNKLINK               0x00000001      /* RW--V */
#define NV_NPORT_CTRL_TRUNKLINKENB_ACCESSLINK              0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_TRUNKLINKENB__TPROD                  0x00000001      /* RW--V */
#define NV_NPORT_CTRL_EGDRAINENB                           1:1             /* RWEVF */
#define NV_NPORT_CTRL_EGDRAINENB_ENABLE                    0x00000001      /* RW--V */
#define NV_NPORT_CTRL_EGDRAINENB_DISABLE                   0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_RTDRAINENB                           2:2             /* RWEVF */
#define NV_NPORT_CTRL_RTDRAINENB_ENABLE                    0x00000001      /* RW--V */
#define NV_NPORT_CTRL_RTDRAINENB_DISABLE                   0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_SPARE                                13:9            /* RWEVF */
#define NV_NPORT_CTRL_SPARE_INIT                           0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_ENROUTEDBI                           16:16           /* RWEVF */
#define NV_NPORT_CTRL_ENROUTEDBI_ENABLE                    0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_ENROUTEDBI_DISABLE                   0x00000000      /* RW--V */
#define NV_NPORT_CTRL_ENEGRESSDBI                          17:17           /* RWEVF */
#define NV_NPORT_CTRL_ENEGRESSDBI_ENABLE                   0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_ENEGRESSDBI_DISABLE                  0x00000000      /* RW--V */
#define NV_NPORT_CTRL_BUFFER_READY                         0x00000044      /* RW-4R */
#define NV_NPORT_CTRL_BUFFER_READY_BUFFERRDY               0:0             /* RWEVF */
#define NV_NPORT_CTRL_BUFFER_READY_BUFFERRDY_ENABLE        0x00000001      /* RW--V */
#define NV_NPORT_CTRL_BUFFER_READY_BUFFERRDY_DISABLE       0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP                                 0x00000048      /* RW-4R */
#define NV_NPORT_CTRL_STOP_INGRESS_STOP                    0:0             /* RWEVF */
#define NV_NPORT_CTRL_STOP_INGRESS_STOP_STOP               0x00000001      /* RW--V */
#define NV_NPORT_CTRL_STOP_INGRESS_STOP_ALLOWTRAFFIC       0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP_EGRESS_STOP                     8:8             /* RWEVF */
#define NV_NPORT_CTRL_STOP_EGRESS_STOP_STOP                0x00000001      /* RW--V */
#define NV_NPORT_CTRL_STOP_EGRESS_STOP_ALLOWTRAFFIC        0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC                   23:16           /* RWEVF */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_ALLOWTRAFFIC      0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC0           0x00000001      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC1           0x00000002      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC2           0x00000004      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC3           0x00000008      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC4           0x00000010      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC5           0x00000020      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC6           0x00000040      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC7           0x00000080      /* RW--V */
#define NV_NPORT_INITIALIZATION                            0x0000004c      /* RW-4R */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0              0:0             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1              1:1             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2              2:2             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3              3:3             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4              4:4             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5              5:5             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6              6:6             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT              8:8             /* RWEVF */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT__ONWRITE     "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT               9:9             /* RWEVF */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT__ONWRITE      "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT_HWINIT        0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_RIDTABINIT                 10:10           /* RWEVF */
#define NV_NPORT_INITIALIZATION_RIDTABINIT__ONWRITE        "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_RIDTABINIT_INIT            0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_RIDTABINIT_HWINIT          0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_RLANTABINIT                11:11           /* RWEVF */
#define NV_NPORT_INITIALIZATION_RLANTABINIT__ONWRITE       "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_RLANTABINIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_RLANTABINIT_HWINIT         0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_MCREMAPTABINIT             12:12           /* RWEVF */
#define NV_NPORT_INITIALIZATION_MCREMAPTABINIT__ONWRITE    "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_MCREMAPTABINIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_MCREMAPTABINIT_HWINIT      0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_MCTAGSTATEINIT             13:13           /* RWEVF */
#define NV_NPORT_INITIALIZATION_MCTAGSTATEINIT__ONWRITE    "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_MCTAGSTATEINIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_MCTAGSTATEINIT_HWINIT      0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_RDTAGSTATEINIT             14:14           /* RWEVF */
#define NV_NPORT_INITIALIZATION_RDTAGSTATEINIT__ONWRITE    "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_RDTAGSTATEINIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_RDTAGSTATEINIT_HWINIT      0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_MCREDSGTINIT               15:15           /* RWEVF */
#define NV_NPORT_INITIALIZATION_MCREDSGTINIT__ONWRITE      "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_MCREDSGTINIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_MCREDSGTINIT_HWINIT        0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_MCREDBUFINIT               16:16           /* RWEVF */
#define NV_NPORT_INITIALIZATION_MCREDBUFINIT__ONWRITE      "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_MCREDBUFINIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_MCREDBUFINIT_HWINIT        0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_MCRIDINIT                  17:17           /* RWEVF */
#define NV_NPORT_INITIALIZATION_MCRIDINIT__ONWRITE         "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_MCRIDINIT_INIT             0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_MCRIDINIT_HWINIT           0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_EXTMCRIDINIT               18:18           /* RWEVF */
#define NV_NPORT_INITIALIZATION_EXTMCRIDINIT__ONWRITE      "oneToClear"    /*       */
#define NV_NPORT_INITIALIZATION_EXTMCRIDINIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_EXTMCRIDINIT_HWINIT        0x00000001      /* RW--V */
#define NV_NPORT_CTRL_SLCG                                 0x00000050      /* RW-4R */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS                  0:0             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS_ENABLE           0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS_DISABLE          0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS__PROD            0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE                    1:1             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE_ENABLE             0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE_DISABLE            0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE__PROD              0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS                   2:2             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS_ENABLE            0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS_DISABLE           0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS__PROD             0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK                   3:3             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK_ENABLE            0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK_DISABLE           0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK__PROD             0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE                 4:4             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE_ENABLE          0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE_DISABLE         0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE__PROD           0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX                     5:5             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX_ENABLE              0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX_DISABLE             0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX__PROD               0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_MCTAGSTATE               6:6             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_MCTAGSTATE_ENABLE        0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_MCTAGSTATE_DISABLE       0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_MCTAGSTATE__PROD         0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_RDTAGSTATE               7:7             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_RDTAGSTATE_ENABLE        0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_RDTAGSTATE_DISABLE       0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_RDTAGSTATE__PROD         0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_WATCHPOINT               31:31           /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_WATCHPOINT_ENABLE        0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_WATCHPOINT_DISABLE       0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_WATCHPOINT__PROD         0x00000000      /* RW--V */
#define NV_NPORT_REQLINKID                                 0x00000054      /* RW-4R */
#define NV_NPORT_REQLINKID_REQROUTINGID                    8:0             /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGID_INIT               0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID_REQROUTINGID_UPPER              10:9            /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGID_UPPER_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID_REQROUTINGLAN                   18:15           /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGLAN_INIT              0x00000000      /* RWE-V */
#define NV_NPORT_CONTAIN_AND_DRAIN                         0x0000005c      /* RW-4R */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR                   18:18           /* RWIVF */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR__ONWRITE          "oneToClear"    /*       */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR_ENABLE            0x00000001      /* RW--V */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR_DISABLE           0x00000000      /* RWI-V */
#define NV_NPORT_CONTAIN_AND_DRAIN_DIRTY                   19:19           /* R-IVF */
#define NV_NPORT_CONTAIN_AND_DRAIN_DIRTY_DIRTY             0x00000001      /* R---V */
#define NV_NPORT_CONTAIN_AND_DRAIN_DIRTY_CLEAN             0x00000000      /* R-I-V */
#define NV_NPORT_SRC_PORT_TYPE0                            0x00000074      /* RW-4R */
#define NV_NPORT_SRC_PORT_TYPE0_TRUNKPORT                  31:0            /* RWEVF */
#define NV_NPORT_SRC_PORT_TYPE0_TRUNKPORT_TRUNKPORT        0x00000001      /* RW--V */
#define NV_NPORT_SRC_PORT_TYPE0_TRUNKPORT_ACCESSPORT       0x00000000      /* RWE-V */
#define NV_NPORT_SRC_PORT_TYPE1                            0x00000078      /* RW-4R */
#define NV_NPORT_SRC_PORT_TYPE1_TRUNKPORT                  31:0            /* RWEVF */
#define NV_NPORT_SRC_PORT_TYPE1_TRUNKPORT_TRUNKPORT        0x00000001      /* RW--V */
#define NV_NPORT_SRC_PORT_TYPE1_TRUNKPORT_ACCESSPORT       0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_CONTROL                          0x00000100      /* RW-4R */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT              3:0             /* RWEVF */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS13TO0    0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS15TO2    0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS17TO4    0x00000002      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS19TO6    0x00000003      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS21TO8    0x00000004      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS23TO10   0x00000005      /* RW--V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL                     0x00000104      /* RW-4R */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_STARTCOUNTER        0:0             /* RWEVF */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_STARTCOUNTER_ENABLE 0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_STARTCOUNTER_DISABLE 0x00000000     /* RWE-V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_SNAPONDEMAND        4:4             /* RWEVF */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_SNAPONDEMAND_ENABLE 0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_SNAPONDEMAND_DISABLE 0x00000000     /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0                      0x00000108      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0                   0x0000010c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0                     0x00000110      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_0                 0x00000114      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_1                 0x00000118      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_0                    0x0000011c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_1                    0x00000120      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_0                 0x00000124      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_1                 0x00000128      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_0                   0x0000012c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_1                   0x00000130      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_0                  0x00000134      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_1                  0x00000138      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1                      0x0000013c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1                   0x00000140      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1                     0x00000144      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_0                 0x00000148      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_1                 0x0000014c      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_0                    0x00000150      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_1                    0x00000154      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_0                 0x00000158      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_1                 0x0000015c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_0                   0x00000160      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_1                   0x00000164      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_0                  0x00000168      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_1                  0x0000016c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2                      0x00000170      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2                   0x00000174      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2                     0x00000178      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_2_0                 0x0000017c      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_2_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_2_1                 0x00000180      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_2_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_2_0                    0x00000184      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_2_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_2_1                    0x00000188      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_2_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_2_0                 0x0000018c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_2_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_2_1                 0x00000190      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_2_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_2_0                   0x00000194      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_2_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_2_1                   0x00000198      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_2_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_2_0                  0x0000019c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_2_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_2_1                  0x000001a0      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_2_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3                      0x000001a4      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3                   0x000001a8      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3                     0x000001ac      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_3_0                 0x000001b0      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_3_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_3_1                 0x000001b4      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_3_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_3_0                    0x000001b8      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_3_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_3_1                    0x000001bc      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_3_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_3_0                 0x000001c0      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_3_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_3_1                 0x000001c4      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_3_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_3_0                   0x000001c8      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_3_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_3_1                   0x000001cc      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_3_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_3_0                  0x000001d0      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_3_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_3_1                  0x000001d4      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_3_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4                      0x000001d8      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4                   0x000001dc      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4                     0x000001e0      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_4_0                 0x000001e4      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_4_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_4_1                 0x000001e8      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_4_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_4_0                    0x000001ec      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_4_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_4_1                    0x000001f0      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_4_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_4_0                 0x000001f4      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_4_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_4_1                 0x000001f8      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_4_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_4_0                   0x000001fc      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_4_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_4_1                   0x00000200      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_4_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_4_0                  0x00000204      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_4_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_4_1                  0x00000208      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_4_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5                      0x0000020c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5                   0x00000210      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5                     0x00000214      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_5_0                 0x00000218      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_5_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_5_1                 0x0000021c      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_5_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_5_0                    0x00000220      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_5_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_5_1                    0x00000224      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_5_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_5_0                 0x00000228      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_5_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_5_1                 0x0000022c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_5_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_5_0                   0x00000230      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_5_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_5_1                   0x00000234      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_5_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_5_0                  0x00000238      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_5_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_5_1                  0x0000023c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_5_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6                      0x00000240      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6                   0x00000244      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6                     0x00000248      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_6_0                 0x0000024c      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_6_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_6_1                 0x00000250      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_6_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_6_0                    0x00000254      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_6_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_6_1                    0x00000258      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_6_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_6_0                 0x0000025c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_6_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_6_1                 0x00000260      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_6_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_6_0                   0x00000264      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_6_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_6_1                   0x00000268      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_6_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_6_0                  0x0000026c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_6_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_6_1                  0x00000270      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_6_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7                      0x00000274      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7_LIMIT_INIT           0x000000c0      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7                   0x00000278      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7_LIMIT_INIT        0x00000140      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7                     0x0000027c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7_LIMIT_INIT          0x00000680      /* RWE-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_7_0                 0x00000280      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_7_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_7_1                 0x00000284      /* RW-4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_7_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_7_0                    0x00000288      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_7_0_PACKETCOUNT        31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_7_1                    0x0000028c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_7_1_PACKETCOUNT        15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_7_0                 0x00000290      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_7_0_PACKETCOUNT     31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_7_1                 0x00000294      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_7_1_PACKETCOUNT     15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_7_0                   0x00000298      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_7_0_PACKETCOUNT       31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_7_1                   0x0000029c      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_7_1_PACKETCOUNT       15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_7_0                  0x000002a0      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_7_0_PACKETCOUNT      31:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_7_1                  0x000002a4      /* RW-4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_7_1_PACKETCOUNT      15:0            /* RWXVF */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_0                  0x000002a8      /* RW-4R */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_0_SRCFILTERBIT     31:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_0_SRCFILTERBIT_INIT 0x00000000     /* RWE-V */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_1                  0x000002ac      /* RW-4R */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_1_SRCFILTERBIT     31:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_1_SRCFILTERBIT_INIT 0x00000000     /* RWE-V */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT                  0x00000470      /* RW-4R */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_CORRECTABLEENABLE 0:0            /* RWEVF */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_CORRECTABLEENABLE_INIT 0x00000001 /* RWE-V */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_FATALENABLE      1:1             /* RWEVF */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_FATALENABLE_INIT 0x00000001      /* RWE-V */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_NONFATALENABLE   2:2             /* RWEVF */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_NONFATALENABLE_INIT 0x00000001   /* RWE-V */
#define NV_NPORT_MCID_ERROR_VECTOR(i)                      (0x00000480+(i)*0x4) /* RW-4A */
#define NV_NPORT_MCID_ERROR_VECTOR__SIZE_1                 4               /*       */
#define NV_NPORT_MCID_ERROR_VECTOR_STATUS                  31:0            /* RWEVF */
#define NV_NPORT_MCID_ERROR_VECTOR_STATUS__ONWRITE         "oneToClear"    /*       */
#define NV_NPORT_MCID_ERROR_VECTOR_STATUS_INIT             0x00000000      /* RWE-V */
#define NV_NPORT_MCID_ERROR_VECTOR_STATUS_CLEAR            0x00000001      /* RW--V */
#define NV_NPORT_SCRATCH_WARM                              0x00000fc0      /* RW-4R */
#define NV_NPORT_SCRATCH_WARM_DATA                         31:0            /* RWEVF */
#define NV_NPORT_SCRATCH_WARM_DATA_INIT                    0xdeadbaad      /* RWE-V */
#endif // __ls10_dev_nport_ip_h__
