/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_GES.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgi_getErrorString(int errnr)

	Return a string corresponding to the error number.

ob: cfgi_getErrorString
ty: L
su: inifile
sh: Return a human readeble string associated with a cfg error number
wa: The returned string must not be modified.
va: NULL: invalid cfg error number
re: cfgViewErrorINI
fi: cfgi_ges.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <stdio.h>
#include "inifile.loc"
#include "msgs.lng"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_GES.C 1.5 2001/02/27 01:27:49 ska Exp ska $";
#endif

static char *tbl[] = {
#include "cfgi_tbl.loc"
	0
};

char *cfgi_getErrorString(int errnr)
{	DBG_ENTER("cfgi_getErrorString", Suppl_inifile)
	DBG_ARGUMENTS( ("errnr=%d", errnr) )

	if(errnr < 0)
		errnr = -errnr;
	DBG_RETURN_BS( errnr > CFG_ERR_MAXNUM? 0: tbl[errnr])
}
