/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is generated by nnapi/codegen.py
#ifndef NNAPI_WRAPPER_H_
#define NNAPI_WRAPPER_H_
#include <stddef.h>
#include <stdint.h>
#include <ATen/nnapi/NeuralNetworks.h>
struct nnapi_wrapper {
  int(*_getDeviceCount)(uint32_t* numDevices);
  int(*_getDevice)(uint32_t devIndex, ANeuralNetworksDevice** device);
  int(*Device_getName)(const ANeuralNetworksDevice* device, const char** name);
  int(*Device_getVersion)(const ANeuralNetworksDevice* device, const char** version);
  int(*Device_getFeatureLevel)(const ANeuralNetworksDevice* device, int64_t* featureLevel);
  int(*Model_getSupportedOperationsForDevices)( const ANeuralNetworksModel* model, const ANeuralNetworksDevice* const* devices, uint32_t numDevices, bool* supportedOps);
  int(*Compilation_createForDevices)(ANeuralNetworksModel* model, const ANeuralNetworksDevice* const* devices, uint32_t numDevices, ANeuralNetworksCompilation** compilation);
  int(*Execution_compute)(ANeuralNetworksExecution* execution);
  int(*Memory_createFromFd)(size_t size, int protect, int fd, size_t offset, ANeuralNetworksMemory** memory);
  void(*Memory_free)(ANeuralNetworksMemory* memory);
  int(*Model_create)(ANeuralNetworksModel** model);
  void(*Model_free)(ANeuralNetworksModel* model);
  int(*Model_finish)(ANeuralNetworksModel* model);
  int(*Model_addOperand)(ANeuralNetworksModel* model, const ANeuralNetworksOperandType* type);
  int(*Model_setOperandValue)(ANeuralNetworksModel* model, int32_t index, const void* buffer, size_t length);
  int(*Model_setOperandValueFromMemory)(ANeuralNetworksModel* model, int32_t index, const ANeuralNetworksMemory* memory, size_t offset, size_t length);
  int(*Model_addOperation)(ANeuralNetworksModel* model, ANeuralNetworksOperationType type, uint32_t inputCount, const uint32_t* inputs, uint32_t outputCount, const uint32_t* outputs);
  int(*Model_identifyInputsAndOutputs)(ANeuralNetworksModel* model, uint32_t inputCount, const uint32_t* inputs, uint32_t outputCount, const uint32_t* outputs);
  int(*Model_relaxComputationFloat32toFloat16)(ANeuralNetworksModel* model, bool allow);
  int(*Compilation_create)(ANeuralNetworksModel* model, ANeuralNetworksCompilation** compilation);
  void(*Compilation_free)(ANeuralNetworksCompilation* compilation);
  int(*Compilation_setPreference)(ANeuralNetworksCompilation* compilation, int32_t preference);
  int(*Compilation_finish)(ANeuralNetworksCompilation* compilation);
  int(*Execution_create)(ANeuralNetworksCompilation* compilation, ANeuralNetworksExecution** execution);
  void(*Execution_free)(ANeuralNetworksExecution* execution);
  int(*Execution_setInput)(ANeuralNetworksExecution* execution, int32_t index, const ANeuralNetworksOperandType* type, const void* buffer, size_t length);
  int(*Execution_setInputFromMemory)(ANeuralNetworksExecution* execution, int32_t index, const ANeuralNetworksOperandType* type, const ANeuralNetworksMemory* memory, size_t offset, size_t length);
  int(*Execution_setOutput)(ANeuralNetworksExecution* execution, int32_t index, const ANeuralNetworksOperandType* type, void* buffer, size_t length);
  int(*Execution_setOutputFromMemory)(ANeuralNetworksExecution* execution, int32_t index, const ANeuralNetworksOperandType* type, const ANeuralNetworksMemory* memory, size_t offset, size_t length);
  int(*Execution_startCompute)(ANeuralNetworksExecution* execution, ANeuralNetworksEvent** event);
  int(*Event_wait)(ANeuralNetworksEvent* event);
  void(*Event_free)(ANeuralNetworksEvent* event);
  int(*Execution_getOutputOperandRank)(ANeuralNetworksExecution* execution, int32_t index, uint32_t* rank);
  int(*Execution_getOutputOperandDimensions)(ANeuralNetworksExecution* execution, int32_t index, uint32_t* dimensions);
};
#ifdef __cplusplus
void nnapi_wrapper_load(struct nnapi_wrapper** nnapi, struct nnapi_wrapper** check_nnapi);
#endif
#endif
