#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "CYCReader.h"
#include "BaseCommunication.h"

#include "memory_placements.h"


#define base CRFSReader

CCYCReader::CCYCReader(CReader *Owner, CBaseCommunication *Communicator)
	:base(Owner, Communicator)
{}

CCYCReader::~CCYCReader(void)
{
}

void CCYCReader::SetNFCSpeedLimit()
{
	uint32_t l = 1;
	uint8_t s = (uint8_t)GetEnviroment("NFCSpeedLimit", 0xff);
	Escape(MODULE_ID_KERNEL, CCID_ESCAPE_NFC_SPEED_LIMIT, &s, 1, NULL, &s, &l);// Fire and forgot
}

CJ_RESULT CCYCReader::BuildReaderInfo()
{
	CJ_RESULT Res;
	uint8_t disablesync = 0;
	uint32_t Result;

	Res = base::BuildReaderInfo();

	m_ReaderInfo.HardwareMask &= ~(RSCT_READER_HARDWARE_MASK_PACE);

	Escape(MODULE_ID_KERNEL, CCID_ESCAPE_CTRL_SYNC, &disablesync, sizeof(disablesync), &Result, 0, 0);
	return Res;
}


void CCYCReader::SetHWString(char *String)
{
	SetNFCSpeedLimit();
	strcpy(String, "CYC_");
}

void CCYCReader::GetProductString(uint8_t *Product)
{
	memcpy(Product, "CJCYC", 5);
}

CJ_RESULT CCYCReader::CtSetBacklight(EBacklight eBacklight, uint32_t *Result)
{
	CJ_RESULT Res;
	switch (eBacklight)
	{
	case BacklightOff:
		Res = _CtSetBacklight(0, Result);
		break;
	case BacklightVeryLow:
		Res = _CtSetBacklight(70, Result);
		break;
	case BacklightLow:
		Res = _CtSetBacklight(100, Result);
		break;
	case BacklightMedium:
		Res = _CtSetBacklight(120, Result);
		break;
	case BacklightHigh:
		Res = _CtSetBacklight(160, Result);
		break;
	case BacklightVeryHigh:
		Res = _CtSetBacklight(255, Result);
		break;
	default:
		Res = CJ_ERR_WRONG_PARAMETER;
	}
	return Res;
}

CJ_RESULT CCYCReader::CtSelfTest2(const uint8_t *TransportKey, uint8_t KeyNr)
{
	uint32_t Res;
	uint8_t buffer[256];
	struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime *DateTime = (struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime *)buffer;
	struct tm *t;
	time_t tim;
	CJ_RESULT Result;

	time(&tim);
	t = localtime(&tim);

	DateTime->Nr = 1;
	sprintf((char *)DateTime->dtDate.ProductionDate, "%02d.%02d.%04d", t->tm_mday, t->tm_mon + 1, t->tm_year + 1900);
	sprintf((char *)DateTime->dtDate.ProductionTime, "%02d:%02d", t->tm_hour, t->tm_min);
	memcpy(buffer + sizeof(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime), TransportKey, 16);
	buffer[16 + sizeof(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime)] = KeyNr;

	Result = Escape(MODULE_ID_KERNEL, CCID_ESCAPE_SELF_TEST, buffer, sizeof(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime) + 17, &Res, 0, 0);
	if (Result != CJ_SUCCESS && Result != CJ_ERR_CHECK_RESULT)
	{
		//m_Owner->DebugLeveled(DEBUG_MASK_COMMUNICATION_ERROR, "Error Selftest");
		return CJ_ERR_DEVICE_LOST;
	}
	return Res;
}

#ifdef WITH_SECODER_INFO_OVERRIDE
CJ_RESULT CCYCReader::KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr)
{
	return base::KTLightCall(sad, dad, cmd, lenc, Lc, data_ptr, Le, response, lenr);
}
#endif
