/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_TEXTVIEW_DIARY_THEME_HEADER
#define LIFEOGRAPH_TEXTVIEW_DIARY_THEME_HEADER


#include "widget_textview.hpp"


namespace LIFEO
{

// FORWARD DECLERATIONS
class TextviewDiaryTheme;

// LINKS ===========================================================================================
class LinkTheme : public Link // for theme editing
{
    public:
        LinkTheme( const Glib::RefPtr< Gtk::TextMark >&, const Glib::RefPtr< Gtk::TextMark >&,
                   const char, TextviewDiaryTheme* );

        void                        go() override;

    protected:
        void                        launch_color_dialog( Color& );
        void                        launch_font_dialog( Pango::FontDescription& );
        void                        launch_file_dialog( std::string& );

        char                        m_type;
        TextviewDiaryTheme*         m_TvD;
};

// TEXTBUFFER ======================================================================================
class TextbufferDiaryTheme : public TextbufferDiary
{
    public:
                                    TextbufferDiaryTheme();

    protected:
        // PARSING
        void                        apply_link() override;
        void                        apply_link_hidden() override;
        void                        apply_date() override;
        void                        apply_inline_tag() override;

        // TAGS
        Glib::RefPtr< Tag >         m_tag_link_theme;
        TextviewDiaryTheme*         m_ptr2TvDT{ nullptr };

    friend class TextviewDiaryTheme;
};

// TEXTVIEW ========================================================================================
class TextviewDiaryTheme : public TextviewDiary
{
    public:
    typedef sigc::signal< void, Match& >
                                    Signal_void_Match;

        TextviewDiaryTheme();
        TextviewDiaryTheme( BaseObjectType*, const Glib::RefPtr< Gtk::Builder >& );
        ~TextviewDiaryTheme() {}

        TextbufferDiaryTheme*       get_buffer()
        { return m_buffer_theme; }

        bool                        is_derived() const override { return true; }

        void                        set_text_preview();
        void                        set_text_edit();

        SignalVoid                  signal_theme_edited()
        { return m_Sg_theme_edited; }
        void                        handle_theme_edited() // called from theme edit links
        { m_Sg_theme_edited.emit(); }

    protected:
        void                        init() override;

        bool                        on_button_press_event( GdkEventButton* ) override
        { return true; } // to block clicks
        bool                        on_motion_notify_event( GdkEventMotion* event ) override
        {
            if( m_buffer_theme->m_tag_link_theme->property_invisible() )
                m_buffer_theme->m_tag_link_theme->property_invisible() = false;
            return TextviewDiary::on_motion_notify_event( event );
        }
        bool                        on_leave_notify_event( GdkEventCrossing* event ) override
        {
            m_buffer_theme->m_tag_link_theme->property_invisible() = true;
            return Gtk::TextView::on_enter_notify_event( event );
        }
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& ) override;

        bool                        handle_query_tooltip(
                                        int, int, bool,
                                        const Glib::RefPtr< Gtk::Tooltip >& ) override;

        TextbufferDiaryTheme*       m_buffer_theme;

        bool                        m_flag_in_edit_mode{ false };

        SignalVoid                  m_Sg_theme_edited;

    friend class TextbufferDiary;
};

} // end of namespace LIFEO

#endif
