// Code generated by smithy-go-codegen DO NOT EDIT.

package resiliencehub

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/resiliencehub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a resiliency policy.
func (c *Client) UpdateResiliencyPolicy(ctx context.Context, params *UpdateResiliencyPolicyInput, optFns ...func(*Options)) (*UpdateResiliencyPolicyOutput, error) {
	if params == nil {
		params = &UpdateResiliencyPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateResiliencyPolicy", params, optFns, c.addOperationUpdateResiliencyPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateResiliencyPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateResiliencyPolicyInput struct {

	// The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN
	// is: arn:partition:resiliencehub:region:account:resiliency-policy/policy-id. For
	// more information about ARNs, see  Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the AWS General Reference.
	//
	// This member is required.
	PolicyArn *string

	// Specifies a high-level geographical location constraint for where your
	// resilience policy data can be stored.
	DataLocationConstraint types.DataLocationConstraint

	// The type of resiliency policy to be created, including the recovery time
	// objective (RTO) and recovery point objective (RPO) in seconds.
	Policy map[string]types.FailurePolicy

	// The description for the policy.
	PolicyDescription *string

	// The name of the policy
	PolicyName *string

	// The tier for this resiliency policy, ranging from the highest severity
	// (MissionCritical) to lowest (NonCritical).
	Tier types.ResiliencyPolicyTier

	noSmithyDocumentSerde
}

type UpdateResiliencyPolicyOutput struct {

	// The type of resiliency policy that was updated, including the recovery time
	// objective (RTO) and recovery point objective (RPO) in seconds.
	//
	// This member is required.
	Policy *types.ResiliencyPolicy

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateResiliencyPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateResiliencyPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateResiliencyPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateResiliencyPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateResiliencyPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateResiliencyPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "resiliencehub",
		OperationName: "UpdateResiliencyPolicy",
	}
}
