// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing Amazon Lightsail content delivery network (CDN)
// distribution. Use this action to update the configuration of your existing
// distribution.
func (c *Client) UpdateDistribution(ctx context.Context, params *UpdateDistributionInput, optFns ...func(*Options)) (*UpdateDistributionOutput, error) {
	if params == nil {
		params = &UpdateDistributionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDistribution", params, optFns, c.addOperationUpdateDistributionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDistributionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDistributionInput struct {

	// The name of the distribution to update. Use the GetDistributions action to get a
	// list of distribution names that you can specify.
	//
	// This member is required.
	DistributionName *string

	// An object that describes the cache behavior settings for the distribution. The
	// cacheBehaviorSettings specified in your UpdateDistributionRequest will replace
	// your distribution's existing settings.
	CacheBehaviorSettings *types.CacheSettings

	// An array of objects that describe the per-path cache behavior for the
	// distribution.
	CacheBehaviors []types.CacheBehaviorPerPath

	// An object that describes the default cache behavior for the distribution.
	DefaultCacheBehavior *types.CacheBehavior

	// Indicates whether to enable the distribution.
	IsEnabled *bool

	// An object that describes the origin resource for the distribution, such as a
	// Lightsail instance, bucket, or load balancer. The distribution pulls, caches,
	// and serves content from the origin.
	Origin *types.InputOrigin

	noSmithyDocumentSerde
}

type UpdateDistributionOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operation *types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDistributionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateDistribution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateDistribution{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDistributionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDistribution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDistribution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lightsail",
		OperationName: "UpdateDistribution",
	}
}
