/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright 2025 Yunsilicon Technology Co., Ltd.
 */

#ifndef XSC_DEFS_H_
#define XSC_DEFS_H_

#define XSC_PAGE_SIZE			4096
#define XSC_PHY_PORT_NUM		1

#define XSC_PCI_VENDOR_ID		0x1f67
#define XSC_PCI_DEV_ID_MS		0x1111
#define XSC_PCI_DEV_ID_MSVF		0x1112
#define XSC_PCI_DEV_ID_MVH		0x1151
#define XSC_PCI_DEV_ID_MVHVF		0x1152
#define XSC_PCI_DEV_ID_MVS		0x1153

#define XSC_VFREP_BASE_LOGICAL_PORT	1081
#define XSC_MAX_MAC_ADDRESSES		3

#define XSC_RSS_HASH_KEY_LEN		52
#define XSC_RSS_HASH_BIT_IPV4_SIP	(1ULL << 0)
#define XSC_RSS_HASH_BIT_IPV4_DIP	(1ULL << 1)
#define XSC_RSS_HASH_BIT_IPV6_SIP	(1ULL << 2)
#define XSC_RSS_HASH_BIT_IPV6_DIP	(1ULL << 3)
#define XSC_RSS_HASH_BIT_IPV4_SPORT	(1ULL << 4)
#define XSC_RSS_HASH_BIT_IPV4_DPORT	(1ULL << 5)
#define XSC_RSS_HASH_BIT_IPV6_SPORT	(1ULL << 6)
#define XSC_RSS_HASH_BIT_IPV6_DPORT	(1ULL << 7)
#define XSC_RSS_HASH_BIT_TNL_ID		(1ULL << 8)
#define XSC_RSS_HASH_BIT_NXT_PRO	(1ULL << 9)

#define XSC_EPAT_VLD_FLAG		(1ULL)
#define XSC_EPAT_RX_QP_ID_OFST_FLAG	(1ULL << 2)
#define XSC_EPAT_QP_NUM_FLAG		(1ULL << 3)
#define XSC_EPAT_RSS_EN_FLAG		(1ULL << 4)
#define XSC_EPAT_RSS_HASH_TEMPLATE_FLAG	(1ULL << 5)
#define XSC_EPAT_RSS_HASH_FUNC_FLAG	(1ULL << 6)
#define XSC_EPAT_HAS_PPH_FLAG		(1ULL << 9)
#define XSC_EPAT_MAC_FILTER_EN_FLAG	(1ULL << 15)

#define XSC_MAX_DESC_NUMBER		1024
#define XSC_SEND_WQE_DS			3
#define XSC_ESEG_EXTRA_DATA_SIZE	48u

#define XSC_PF_TX_DB_ADDR		0x4802000
#define XSC_PF_RX_DB_ADDR		0x4804000
#define XSC_PF_CQ_DB_ADDR		0x2120000
#define XSC_PF_CQ_PID_START_ADDR	0x2080000

#define XSC_VF_RX_DB_ADDR		0x8d4
#define XSC_VF_TX_DB_ADDR		0x8d0
#define XSC_VF_CQ_DB_ADDR		0x8c4
#define XSC_VF_CQ_PID_START_ADDR	0x60000

#define XSC_HIF_CMDQM_VECTOR_ID_MEM_ADDR	0x1034000

enum xsc_nic_mode {
	XSC_NIC_MODE_LEGACY,
	XSC_NIC_MODE_SWITCHDEV,
	XSC_NIC_MODE_SOC,
};

enum xsc_pph_type {
	XSC_PPH_NONE	= 0,
	XSC_RX_PPH	= 0x1,
	XSC_TX_PPH	= 0x2,
	XSC_VFREP_PPH	= 0x4,
	XSC_UPLINK_PPH	= 0x8,
};

enum xsc_funcid_type {
	XSC_FUNCID_TYPE_INVAL	= 0x0,
	XSC_EMU_FUNCID		= 0x1,
	XSC_PHYPORT_MAC_FUNCID	= 0x2,
	XSC_VF_IOCTL_FUNCID	= 0x3,
	XSC_PHYPORT_LAG_FUNCID	= 0x4,
	XSC_FUNCID_TYPE_UNKNOWN	= 0x5,
};

enum xsc_port_type {
	XSC_PORT_TYPE_NONE = 0,
	XSC_PORT_TYPE_UPLINK,
	XSC_PORT_TYPE_UPLINK_BOND,
	XSC_PORT_TYPE_PFVF,
	XSC_PORT_TYPE_PFHPF,
	XSC_PORT_TYPE_UNKNOWN,
};

enum xsc_tbm_cap {
	XSC_TBM_CAP_HASH_PPH = 0,
	XSC_TBM_CAP_RSS,
	XSC_TBM_CAP_PP_BYPASS,
	XSC_TBM_CAP_PCT_DROP_CONFIG,
};

enum xsc_rss_hf {
	XSC_RSS_HASH_KEY_UPDATE = 0,
	XSC_RSS_HASH_TEMP_UPDATE,
	XSC_RSS_HASH_FUNC_UPDATE,
	XSC_RSS_RXQ_UPDATE,
	XSC_RSS_RXQ_DROP,
};

#endif /* XSC_DEFS_H_ */
