/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef MERGEAXIS_H
#define MERGEAXIS_H
#include <vector>

#include "pmlist.h"

struct MergeVarKeys
{
  int vlistID, varID, gridID, zaxisID;
  char datatype;
};

struct MergeVarsOnAxis
{
  std::vector<MergeVarKeys> inputKeys;
  KeyValues inputNames;
  MergeVarKeys output;
  void *data;

  void check_axissize_consistency(std::vector<int> axissize);
  std::vector<int> define_new_axes(std::vector<int> axissize);
  void define_var_structure(int vlistID, int ntsteps, std::vector<int> axissize);
  void read_cmor_charvar(std::vector<int> axissize, int streamID, int oldgridsize);
};
#endif
