// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/talent/v4beta1/job.proto

package talent

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/type/postaladdress"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A Job resource represents a job posting (also referred to as a "job listing"
// or "job requisition"). A job belongs to a [Company][google.cloud.talent.v4beta1.Company], which is the hiring
// entity responsible for the job.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required during job update.
	//
	// The resource name for the job. This is generated by the service when a
	// job is created.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
	// example, "projects/foo/tenants/bar/jobs/baz".
	//
	// If tenant id is unspecified, the default tenant is used. For
	// example, "projects/foo/jobs/bar".
	//
	// Use of this field in job queries and API calls is preferred over the use of
	// [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id] since this value is unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name of the company listing the job.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
	// example, "projects/foo/tenants/bar/companies/baz".
	//
	// If tenant id is unspecified, the default tenant is used. For
	// example, "projects/foo/companies/bar".
	Company string `protobuf:"bytes,2,opt,name=company,proto3" json:"company,omitempty"`
	// Required. The requisition ID, also referred to as the posting ID, is assigned by the
	// client to identify a job. This field is intended to be used by clients
	// for client identification and tracking of postings. A job isn't allowed
	// to be created if there is another job with the same [company][google.cloud.talent.v4beta1.Job.name],
	// [language_code][google.cloud.talent.v4beta1.Job.language_code] and [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id].
	//
	// The maximum number of allowed characters is 255.
	RequisitionId string `protobuf:"bytes,3,opt,name=requisition_id,json=requisitionId,proto3" json:"requisition_id,omitempty"`
	// Required. The title of the job, such as "Software Engineer"
	//
	// The maximum number of allowed characters is 500.
	Title string `protobuf:"bytes,4,opt,name=title,proto3" json:"title,omitempty"`
	// Required. The description of the job, which typically includes a multi-paragraph
	// description of the company and related information. Separate fields are
	// provided on the job object for [responsibilities][google.cloud.talent.v4beta1.Job.responsibilities],
	// [qualifications][google.cloud.talent.v4beta1.Job.qualifications], and other job characteristics. Use of
	// these separate job fields is recommended.
	//
	// This field accepts and sanitizes HTML input, and also accepts
	// bold, italic, ordered list, and unordered list markup tags.
	//
	// The maximum number of allowed characters is 100,000.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Strongly recommended for the best service experience.
	//
	// Location(s) where the employer is looking to hire for this job posting.
	//
	// Specifying the full street address(es) of the hiring location enables
	// better API results, especially job searches by commute time.
	//
	// At most 50 locations are allowed for best search performance. If a job has
	// more locations, it is suggested to split it into multiple jobs with unique
	// [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id]s (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', and so on.) as
	// multiple jobs with the same [company][google.cloud.talent.v4beta1.Job.company], [language_code][google.cloud.talent.v4beta1.Job.language_code] and
	// [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id] are not allowed. If the original [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id] must
	// be preserved, a custom field should be used for storage. It is also
	// suggested to group the locations that close to each other in the same job
	// for better search experience.
	//
	// The maximum number of allowed characters is 500.
	Addresses []string `protobuf:"bytes,6,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// Job application information.
	ApplicationInfo *Job_ApplicationInfo `protobuf:"bytes,7,opt,name=application_info,json=applicationInfo,proto3" json:"application_info,omitempty"`
	// The benefits included with the job.
	JobBenefits []JobBenefit `protobuf:"varint,8,rep,packed,name=job_benefits,json=jobBenefits,proto3,enum=google.cloud.talent.v4beta1.JobBenefit" json:"job_benefits,omitempty"`
	// Job compensation information (a.k.a. "pay rate") i.e., the compensation
	// that will paid to the employee.
	CompensationInfo *CompensationInfo `protobuf:"bytes,9,opt,name=compensation_info,json=compensationInfo,proto3" json:"compensation_info,omitempty"`
	// A map of fields to hold both filterable and non-filterable custom job
	// attributes that are not covered by the provided structured fields.
	//
	// The keys of the map are strings up to 64 bytes and must match the
	// pattern: [a-zA-Z][a-zA-Z0-9_]*. For example, key0LikeThis or
	// KEY_1_LIKE_THIS.
	//
	// At most 100 filterable and at most 100 unfilterable keys are supported.
	// For filterable `string_values`, across all keys at most 200 values are
	// allowed, with each string no more than 255 characters. For unfilterable
	// `string_values`, the maximum total size of `string_values` across all keys
	// is 50KB.
	CustomAttributes map[string]*CustomAttribute `protobuf:"bytes,10,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The desired education degrees for the job, such as Bachelors, Masters.
	DegreeTypes []DegreeType `protobuf:"varint,11,rep,packed,name=degree_types,json=degreeTypes,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_types,omitempty"`
	// The department or functional area within the company with the open
	// position.
	//
	// The maximum number of allowed characters is 255.
	Department string `protobuf:"bytes,12,opt,name=department,proto3" json:"department,omitempty"`
	// The employment type(s) of a job, for example,
	// [full time][google.cloud.talent.v4beta1.EmploymentType.FULL_TIME] or
	// [part time][google.cloud.talent.v4beta1.EmploymentType.PART_TIME].
	EmploymentTypes []EmploymentType `protobuf:"varint,13,rep,packed,name=employment_types,json=employmentTypes,proto3,enum=google.cloud.talent.v4beta1.EmploymentType" json:"employment_types,omitempty"`
	// A description of bonus, commission, and other compensation
	// incentives associated with the job not including salary or pay.
	//
	// The maximum number of allowed characters is 10,000.
	Incentives string `protobuf:"bytes,14,opt,name=incentives,proto3" json:"incentives,omitempty"`
	// The language of the posting. This field is distinct from
	// any requirements for fluency that are associated with the job.
	//
	// Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
	// class="external" target="_blank" }.
	//
	// If this field is unspecified and [Job.description][google.cloud.talent.v4beta1.Job.description] is present, detected
	// language code based on [Job.description][google.cloud.talent.v4beta1.Job.description] is assigned, otherwise
	// defaults to 'en_US'.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The experience level associated with the job, such as "Entry Level".
	JobLevel JobLevel `protobuf:"varint,16,opt,name=job_level,json=jobLevel,proto3,enum=google.cloud.talent.v4beta1.JobLevel" json:"job_level,omitempty"`
	// A promotion value of the job, as determined by the client.
	// The value determines the sort order of the jobs returned when searching for
	// jobs using the featured jobs search call, with higher promotional values
	// being returned first and ties being resolved by relevance sort. Only the
	// jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH.
	//
	// Default value is 0, and negative values are treated as 0.
	PromotionValue int32 `protobuf:"varint,17,opt,name=promotion_value,json=promotionValue,proto3" json:"promotion_value,omitempty"`
	// A description of the qualifications required to perform the
	// job. The use of this field is recommended
	// as an alternative to using the more general [description][google.cloud.talent.v4beta1.Job.description] field.
	//
	// This field accepts and sanitizes HTML input, and also accepts
	// bold, italic, ordered list, and unordered list markup tags.
	//
	// The maximum number of allowed characters is 10,000.
	Qualifications string `protobuf:"bytes,18,opt,name=qualifications,proto3" json:"qualifications,omitempty"`
	// A description of job responsibilities. The use of this field is
	// recommended as an alternative to using the more general [description][google.cloud.talent.v4beta1.Job.description]
	// field.
	//
	// This field accepts and sanitizes HTML input, and also accepts
	// bold, italic, ordered list, and unordered list markup tags.
	//
	// The maximum number of allowed characters is 10,000.
	Responsibilities string `protobuf:"bytes,19,opt,name=responsibilities,proto3" json:"responsibilities,omitempty"`
	// The job [PostingRegion][google.cloud.talent.v4beta1.PostingRegion] (for example, state, country) throughout
	// which the job is available. If this field is set, a [LocationFilter][google.cloud.talent.v4beta1.LocationFilter]
	// in a search query within the job region finds this job posting if an
	// exact location match isn't specified. If this field is set to
	// [PostingRegion.NATION][google.cloud.talent.v4beta1.PostingRegion.NATION] or [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.PostingRegion.ADMINISTRATIVE_AREA],
	// setting job [Job.addresses][google.cloud.talent.v4beta1.Job.addresses] to the same location level as this field
	// is strongly recommended.
	PostingRegion PostingRegion `protobuf:"varint,20,opt,name=posting_region,json=postingRegion,proto3,enum=google.cloud.talent.v4beta1.PostingRegion" json:"posting_region,omitempty"`
	// Deprecated. The job is only visible to the owner.
	//
	// The visibility of the job.
	//
	// Defaults to [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4beta1.Visibility.ACCOUNT_ONLY] if not specified.
	//
	// Deprecated: Do not use.
	Visibility Visibility `protobuf:"varint,21,opt,name=visibility,proto3,enum=google.cloud.talent.v4beta1.Visibility" json:"visibility,omitempty"`
	// The start timestamp of the job in UTC time zone. Typically this field
	// is used for contracting engagements. Invalid timestamps are ignored.
	JobStartTime *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=job_start_time,json=jobStartTime,proto3" json:"job_start_time,omitempty"`
	// The end timestamp of the job. Typically this field is used for contracting
	// engagements. Invalid timestamps are ignored.
	JobEndTime *timestamppb.Timestamp `protobuf:"bytes,23,opt,name=job_end_time,json=jobEndTime,proto3" json:"job_end_time,omitempty"`
	// The timestamp this job posting was most recently published. The default
	// value is the time the request arrives at the server. Invalid timestamps are
	// ignored.
	PostingPublishTime *timestamppb.Timestamp `protobuf:"bytes,24,opt,name=posting_publish_time,json=postingPublishTime,proto3" json:"posting_publish_time,omitempty"`
	// Strongly recommended for the best service experience.
	//
	// The expiration timestamp of the job. After this timestamp, the
	// job is marked as expired, and it no longer appears in search results. The
	// expired job can't be listed by the [ListJobs][google.cloud.talent.v4beta1.JobService.ListJobs] API,
	// but it can be retrieved with the [GetJob][google.cloud.talent.v4beta1.JobService.GetJob] API or
	// updated with the [UpdateJob][google.cloud.talent.v4beta1.JobService.UpdateJob] API or deleted with
	// the [DeleteJob][google.cloud.talent.v4beta1.JobService.DeleteJob] API. An expired job can
	// be updated and opened again by using a future expiration timestamp.
	// Updating an expired job fails if there is another existing open job with
	// same [company][google.cloud.talent.v4beta1.Job.company], [language_code][google.cloud.talent.v4beta1.Job.language_code] and [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id].
	//
	// The expired jobs are retained in our system for 90 days. However, the
	// overall expired job count cannot exceed 3 times the maximum number of
	// open jobs over previous 7 days. If this threshold is exceeded,
	// expired jobs are cleaned out in order of earliest expire time.
	// Expired jobs are no longer accessible after they are cleaned
	// out.
	//
	// Invalid timestamps are ignored, and treated as expire time not provided.
	//
	// If the timestamp is before the instant request is made, the job
	// is treated as expired immediately on creation. This kind of job can
	// not be updated. And when creating a job with past timestamp, the
	// [posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time] must be set before
	// [posting_expire_time][google.cloud.talent.v4beta1.Job.posting_expire_time]. The purpose of this feature is
	// to allow other objects, such as [Application][google.cloud.talent.v4beta1.Application], to refer a job
	// that didn't exist in the system prior to becoming expired. If you
	// want to modify a job that was expired on creation,
	// delete it and create a new one.
	//
	// If this value isn't provided at the time of job creation or is invalid,
	// the job posting expires after 30 days from the job's creation time. For
	// example, if the job was created on 2017/01/01 13:00AM UTC with an
	// unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
	//
	// If this value isn't provided on job update, it depends on the field masks
	// set by [UpdateJobRequest.update_mask][google.cloud.talent.v4beta1.UpdateJobRequest.update_mask]. If the field masks include
	// [job_end_time][google.cloud.talent.v4beta1.Job.job_end_time], or the masks are empty meaning that every field is
	// updated, the job posting expires after 30 days from the job's last
	// update time. Otherwise the expiration date isn't updated.
	PostingExpireTime *timestamppb.Timestamp `protobuf:"bytes,25,opt,name=posting_expire_time,json=postingExpireTime,proto3" json:"posting_expire_time,omitempty"`
	// Output only. The timestamp when this job posting was created.
	PostingCreateTime *timestamppb.Timestamp `protobuf:"bytes,26,opt,name=posting_create_time,json=postingCreateTime,proto3" json:"posting_create_time,omitempty"`
	// Output only. The timestamp when this job posting was last updated.
	PostingUpdateTime *timestamppb.Timestamp `protobuf:"bytes,27,opt,name=posting_update_time,json=postingUpdateTime,proto3" json:"posting_update_time,omitempty"`
	// Output only. Display name of the company listing the job.
	CompanyDisplayName string `protobuf:"bytes,28,opt,name=company_display_name,json=companyDisplayName,proto3" json:"company_display_name,omitempty"`
	// Output only. Derived details about the job posting.
	DerivedInfo *Job_DerivedInfo `protobuf:"bytes,29,opt,name=derived_info,json=derivedInfo,proto3" json:"derived_info,omitempty"`
	// Options for job processing.
	ProcessingOptions *Job_ProcessingOptions `protobuf:"bytes,30,opt,name=processing_options,json=processingOptions,proto3" json:"processing_options,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetCompany() string {
	if x != nil {
		return x.Company
	}
	return ""
}

func (x *Job) GetRequisitionId() string {
	if x != nil {
		return x.RequisitionId
	}
	return ""
}

func (x *Job) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Job) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Job) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *Job) GetApplicationInfo() *Job_ApplicationInfo {
	if x != nil {
		return x.ApplicationInfo
	}
	return nil
}

func (x *Job) GetJobBenefits() []JobBenefit {
	if x != nil {
		return x.JobBenefits
	}
	return nil
}

func (x *Job) GetCompensationInfo() *CompensationInfo {
	if x != nil {
		return x.CompensationInfo
	}
	return nil
}

func (x *Job) GetCustomAttributes() map[string]*CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *Job) GetDegreeTypes() []DegreeType {
	if x != nil {
		return x.DegreeTypes
	}
	return nil
}

func (x *Job) GetDepartment() string {
	if x != nil {
		return x.Department
	}
	return ""
}

func (x *Job) GetEmploymentTypes() []EmploymentType {
	if x != nil {
		return x.EmploymentTypes
	}
	return nil
}

func (x *Job) GetIncentives() string {
	if x != nil {
		return x.Incentives
	}
	return ""
}

func (x *Job) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Job) GetJobLevel() JobLevel {
	if x != nil {
		return x.JobLevel
	}
	return JobLevel_JOB_LEVEL_UNSPECIFIED
}

func (x *Job) GetPromotionValue() int32 {
	if x != nil {
		return x.PromotionValue
	}
	return 0
}

func (x *Job) GetQualifications() string {
	if x != nil {
		return x.Qualifications
	}
	return ""
}

func (x *Job) GetResponsibilities() string {
	if x != nil {
		return x.Responsibilities
	}
	return ""
}

func (x *Job) GetPostingRegion() PostingRegion {
	if x != nil {
		return x.PostingRegion
	}
	return PostingRegion_POSTING_REGION_UNSPECIFIED
}

// Deprecated: Do not use.
func (x *Job) GetVisibility() Visibility {
	if x != nil {
		return x.Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *Job) GetJobStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.JobStartTime
	}
	return nil
}

func (x *Job) GetJobEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.JobEndTime
	}
	return nil
}

func (x *Job) GetPostingPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PostingPublishTime
	}
	return nil
}

func (x *Job) GetPostingExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PostingExpireTime
	}
	return nil
}

func (x *Job) GetPostingCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PostingCreateTime
	}
	return nil
}

func (x *Job) GetPostingUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PostingUpdateTime
	}
	return nil
}

func (x *Job) GetCompanyDisplayName() string {
	if x != nil {
		return x.CompanyDisplayName
	}
	return ""
}

func (x *Job) GetDerivedInfo() *Job_DerivedInfo {
	if x != nil {
		return x.DerivedInfo
	}
	return nil
}

func (x *Job) GetProcessingOptions() *Job_ProcessingOptions {
	if x != nil {
		return x.ProcessingOptions
	}
	return nil
}

// Application related details of a job posting.
type Job_ApplicationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Use this field to specify email address(es) to which resumes or
	// applications can be sent.
	//
	// The maximum number of allowed characters for each entry is 255.
	Emails []string `protobuf:"bytes,1,rep,name=emails,proto3" json:"emails,omitempty"`
	// Use this field to provide instructions, such as "Mail your application
	// to ...", that a candidate can follow to apply for the job.
	//
	// This field accepts and sanitizes HTML input, and also accepts
	// bold, italic, ordered list, and unordered list markup tags.
	//
	// The maximum number of allowed characters is 3,000.
	Instruction string `protobuf:"bytes,2,opt,name=instruction,proto3" json:"instruction,omitempty"`
	// Use this URI field to direct an applicant to a website, for example to
	// link to an online application form.
	//
	// The maximum number of allowed characters for each entry is 2,000.
	Uris []string `protobuf:"bytes,3,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *Job_ApplicationInfo) Reset() {
	*x = Job_ApplicationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job_ApplicationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job_ApplicationInfo) ProtoMessage() {}

func (x *Job_ApplicationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job_ApplicationInfo.ProtoReflect.Descriptor instead.
func (*Job_ApplicationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Job_ApplicationInfo) GetEmails() []string {
	if x != nil {
		return x.Emails
	}
	return nil
}

func (x *Job_ApplicationInfo) GetInstruction() string {
	if x != nil {
		return x.Instruction
	}
	return ""
}

func (x *Job_ApplicationInfo) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// Derived details about the job posting.
type Job_DerivedInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Structured locations of the job, resolved from [Job.addresses][google.cloud.talent.v4beta1.Job.addresses].
	//
	// [locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations] are exactly matched to [Job.addresses][google.cloud.talent.v4beta1.Job.addresses] in the same
	// order.
	Locations []*Location `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	// Job categories derived from [Job.title][google.cloud.talent.v4beta1.Job.title] and [Job.description][google.cloud.talent.v4beta1.Job.description].
	JobCategories []JobCategory `protobuf:"varint,3,rep,packed,name=job_categories,json=jobCategories,proto3,enum=google.cloud.talent.v4beta1.JobCategory" json:"job_categories,omitempty"`
}

func (x *Job_DerivedInfo) Reset() {
	*x = Job_DerivedInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job_DerivedInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job_DerivedInfo) ProtoMessage() {}

func (x *Job_DerivedInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job_DerivedInfo.ProtoReflect.Descriptor instead.
func (*Job_DerivedInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Job_DerivedInfo) GetLocations() []*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *Job_DerivedInfo) GetJobCategories() []JobCategory {
	if x != nil {
		return x.JobCategories
	}
	return nil
}

// Options for job processing.
type Job_ProcessingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to `true`, the service does not attempt to resolve a
	// more precise address for the job.
	DisableStreetAddressResolution bool `protobuf:"varint,1,opt,name=disable_street_address_resolution,json=disableStreetAddressResolution,proto3" json:"disable_street_address_resolution,omitempty"`
	// Option for job HTML content sanitization. Applied fields are:
	//
	// * description
	// * applicationInfo.instruction
	// * incentives
	// * qualifications
	// * responsibilities
	//
	// HTML tags in these fields may be stripped if sanitiazation isn't
	// disabled.
	//
	// Defaults to [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4beta1.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
	HtmlSanitization HtmlSanitization `protobuf:"varint,2,opt,name=html_sanitization,json=htmlSanitization,proto3,enum=google.cloud.talent.v4beta1.HtmlSanitization" json:"html_sanitization,omitempty"`
}

func (x *Job_ProcessingOptions) Reset() {
	*x = Job_ProcessingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job_ProcessingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job_ProcessingOptions) ProtoMessage() {}

func (x *Job_ProcessingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job_ProcessingOptions.ProtoReflect.Descriptor instead.
func (*Job_ProcessingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Job_ProcessingOptions) GetDisableStreetAddressResolution() bool {
	if x != nil {
		return x.DisableStreetAddressResolution
	}
	return false
}

func (x *Job_ProcessingOptions) GetHtmlSanitization() HtmlSanitization {
	if x != nil {
		return x.HtmlSanitization
	}
	return HtmlSanitization_HTML_SANITIZATION_UNSPECIFIED
}

var File_google_cloud_talent_v4beta1_job_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4beta1_job_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f,
	0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x88, 0x14, 0x0a, 0x03,
	0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d,
	0x0a, 0x1b, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x12, 0x5b, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x4a, 0x0a, 0x0c, 0x6a, 0x6f, 0x62, 0x5f, 0x62, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x42, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x52, 0x0b,
	0x6a, 0x6f, 0x62, 0x42, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x63,
	0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x63, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0c,
	0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x64, 0x65, 0x67,
	0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x61,
	0x72, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65,
	0x70, 0x61, 0x72, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x10, 0x65, 0x6d, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0f, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x42, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x08, 0x6a, 0x6f, 0x62, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x10, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6f, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0a, 0x76, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x0e, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x0c, 0x6a, 0x6f, 0x62, 0x5f,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6a, 0x6f, 0x62, 0x45,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x70,
	0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4f, 0x0a, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4f, 0x0a, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x64, 0x65, 0x72,
	0x69, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x2e, 0x44, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x61, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x5f, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x20, 0x0a,
	0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75,
	0x72, 0x69, 0x73, 0x1a, 0xa3, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x43, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x6a, 0x6f, 0x62, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0d, 0x6a, 0x6f, 0x62, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xba, 0x01, 0x0a, 0x11, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x49, 0x0a, 0x21, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x65,
	0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1e, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x65, 0x65, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x11, 0x68, 0x74,
	0x6d, 0x6c, 0x5f, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x48, 0x74, 0x6d, 0x6c, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x68, 0x74, 0x6d, 0x6c, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x71, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x17,
	0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x7d, 0x2f, 0x6a, 0x6f, 0x62,
	0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x12, 0x1d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73,
	0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x7e, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x10, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0xa2, 0x02, 0x03, 0x43, 0x54, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_talent_v4beta1_job_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4beta1_job_proto_rawDescData = file_google_cloud_talent_v4beta1_job_proto_rawDesc
)

func file_google_cloud_talent_v4beta1_job_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4beta1_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4beta1_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4beta1_job_proto_rawDescData)
	})
	return file_google_cloud_talent_v4beta1_job_proto_rawDescData
}

var file_google_cloud_talent_v4beta1_job_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_talent_v4beta1_job_proto_goTypes = []interface{}{
	(*Job)(nil),                   // 0: google.cloud.talent.v4beta1.Job
	(*Job_ApplicationInfo)(nil),   // 1: google.cloud.talent.v4beta1.Job.ApplicationInfo
	(*Job_DerivedInfo)(nil),       // 2: google.cloud.talent.v4beta1.Job.DerivedInfo
	(*Job_ProcessingOptions)(nil), // 3: google.cloud.talent.v4beta1.Job.ProcessingOptions
	nil,                           // 4: google.cloud.talent.v4beta1.Job.CustomAttributesEntry
	(JobBenefit)(0),               // 5: google.cloud.talent.v4beta1.JobBenefit
	(*CompensationInfo)(nil),      // 6: google.cloud.talent.v4beta1.CompensationInfo
	(DegreeType)(0),               // 7: google.cloud.talent.v4beta1.DegreeType
	(EmploymentType)(0),           // 8: google.cloud.talent.v4beta1.EmploymentType
	(JobLevel)(0),                 // 9: google.cloud.talent.v4beta1.JobLevel
	(PostingRegion)(0),            // 10: google.cloud.talent.v4beta1.PostingRegion
	(Visibility)(0),               // 11: google.cloud.talent.v4beta1.Visibility
	(*timestamppb.Timestamp)(nil), // 12: google.protobuf.Timestamp
	(*Location)(nil),              // 13: google.cloud.talent.v4beta1.Location
	(JobCategory)(0),              // 14: google.cloud.talent.v4beta1.JobCategory
	(HtmlSanitization)(0),         // 15: google.cloud.talent.v4beta1.HtmlSanitization
	(*CustomAttribute)(nil),       // 16: google.cloud.talent.v4beta1.CustomAttribute
}
var file_google_cloud_talent_v4beta1_job_proto_depIdxs = []int32{
	1,  // 0: google.cloud.talent.v4beta1.Job.application_info:type_name -> google.cloud.talent.v4beta1.Job.ApplicationInfo
	5,  // 1: google.cloud.talent.v4beta1.Job.job_benefits:type_name -> google.cloud.talent.v4beta1.JobBenefit
	6,  // 2: google.cloud.talent.v4beta1.Job.compensation_info:type_name -> google.cloud.talent.v4beta1.CompensationInfo
	4,  // 3: google.cloud.talent.v4beta1.Job.custom_attributes:type_name -> google.cloud.talent.v4beta1.Job.CustomAttributesEntry
	7,  // 4: google.cloud.talent.v4beta1.Job.degree_types:type_name -> google.cloud.talent.v4beta1.DegreeType
	8,  // 5: google.cloud.talent.v4beta1.Job.employment_types:type_name -> google.cloud.talent.v4beta1.EmploymentType
	9,  // 6: google.cloud.talent.v4beta1.Job.job_level:type_name -> google.cloud.talent.v4beta1.JobLevel
	10, // 7: google.cloud.talent.v4beta1.Job.posting_region:type_name -> google.cloud.talent.v4beta1.PostingRegion
	11, // 8: google.cloud.talent.v4beta1.Job.visibility:type_name -> google.cloud.talent.v4beta1.Visibility
	12, // 9: google.cloud.talent.v4beta1.Job.job_start_time:type_name -> google.protobuf.Timestamp
	12, // 10: google.cloud.talent.v4beta1.Job.job_end_time:type_name -> google.protobuf.Timestamp
	12, // 11: google.cloud.talent.v4beta1.Job.posting_publish_time:type_name -> google.protobuf.Timestamp
	12, // 12: google.cloud.talent.v4beta1.Job.posting_expire_time:type_name -> google.protobuf.Timestamp
	12, // 13: google.cloud.talent.v4beta1.Job.posting_create_time:type_name -> google.protobuf.Timestamp
	12, // 14: google.cloud.talent.v4beta1.Job.posting_update_time:type_name -> google.protobuf.Timestamp
	2,  // 15: google.cloud.talent.v4beta1.Job.derived_info:type_name -> google.cloud.talent.v4beta1.Job.DerivedInfo
	3,  // 16: google.cloud.talent.v4beta1.Job.processing_options:type_name -> google.cloud.talent.v4beta1.Job.ProcessingOptions
	13, // 17: google.cloud.talent.v4beta1.Job.DerivedInfo.locations:type_name -> google.cloud.talent.v4beta1.Location
	14, // 18: google.cloud.talent.v4beta1.Job.DerivedInfo.job_categories:type_name -> google.cloud.talent.v4beta1.JobCategory
	15, // 19: google.cloud.talent.v4beta1.Job.ProcessingOptions.html_sanitization:type_name -> google.cloud.talent.v4beta1.HtmlSanitization
	16, // 20: google.cloud.talent.v4beta1.Job.CustomAttributesEntry.value:type_name -> google.cloud.talent.v4beta1.CustomAttribute
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4beta1_job_proto_init() }
func file_google_cloud_talent_v4beta1_job_proto_init() {
	if File_google_cloud_talent_v4beta1_job_proto != nil {
		return
	}
	file_google_cloud_talent_v4beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4beta1_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job_ApplicationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job_DerivedInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job_ProcessingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4beta1_job_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_talent_v4beta1_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4beta1_job_proto_depIdxs,
		MessageInfos:      file_google_cloud_talent_v4beta1_job_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4beta1_job_proto = out.File
	file_google_cloud_talent_v4beta1_job_proto_rawDesc = nil
	file_google_cloud_talent_v4beta1_job_proto_goTypes = nil
	file_google_cloud_talent_v4beta1_job_proto_depIdxs = nil
}
