// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Cancels a specified openCypher query. See [Neptune openCypher status endpoint] for more information.
//
// When invoking this operation in a Neptune cluster that has IAM authentication
// enabled, the IAM user or role making the request must have a policy attached
// that allows the [neptune-db:CancelQuery]IAM action in that cluster.
//
// [neptune-db:CancelQuery]: https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery
// [Neptune openCypher status endpoint]: https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html
func (c *Client) CancelOpenCypherQuery(ctx context.Context, params *CancelOpenCypherQueryInput, optFns ...func(*Options)) (*CancelOpenCypherQueryOutput, error) {
	if params == nil {
		params = &CancelOpenCypherQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelOpenCypherQuery", params, optFns, c.addOperationCancelOpenCypherQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelOpenCypherQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CancelOpenCypherQueryInput struct {

	// The unique ID of the openCypher query to cancel.
	//
	// This member is required.
	QueryId *string

	// If set to TRUE , causes the cancelation of the openCypher query to happen
	// silently.
	Silent *bool

	noSmithyDocumentSerde
}

type CancelOpenCypherQueryOutput struct {

	// The cancelation payload for the openCypher query.
	Payload *bool

	// The cancellation status of the openCypher query.
	Status *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelOpenCypherQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCancelOpenCypherQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCancelOpenCypherQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelOpenCypherQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCancelOpenCypherQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelOpenCypherQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCancelOpenCypherQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelOpenCypherQuery",
	}
}
