//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragepool

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ACL.
func (a ACL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "initiatorIqn", a.InitiatorIqn)
	populate(objectMap, "mappedLuns", a.MappedLuns)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskPool.
func (d DiskPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "managedByExtended", d.ManagedByExtended)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskPoolCreate.
func (d DiskPoolCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "managedByExtended", d.ManagedByExtended)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskPoolCreateProperties.
func (d DiskPoolCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalCapabilities", d.AdditionalCapabilities)
	populate(objectMap, "availabilityZones", d.AvailabilityZones)
	populate(objectMap, "disks", d.Disks)
	populate(objectMap, "subnetId", d.SubnetID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskPoolProperties.
func (d DiskPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalCapabilities", d.AdditionalCapabilities)
	populate(objectMap, "availabilityZones", d.AvailabilityZones)
	populate(objectMap, "disks", d.Disks)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "subnetId", d.SubnetID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskPoolUpdate.
func (d DiskPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedBy", d.ManagedBy)
	populate(objectMap, "managedByExtended", d.ManagedByExtended)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskPoolUpdateProperties.
func (d DiskPoolUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disks", d.Disks)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IscsiTarget.
func (i IscsiTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "managedBy", i.ManagedBy)
	populate(objectMap, "managedByExtended", i.ManagedByExtended)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IscsiTargetCreate.
func (i IscsiTargetCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "managedBy", i.ManagedBy)
	populate(objectMap, "managedByExtended", i.ManagedByExtended)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IscsiTargetCreateProperties.
func (i IscsiTargetCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aclMode", i.ACLMode)
	populate(objectMap, "luns", i.Luns)
	populate(objectMap, "staticAcls", i.StaticACLs)
	populate(objectMap, "targetIqn", i.TargetIqn)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IscsiTargetProperties.
func (i IscsiTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aclMode", i.ACLMode)
	populate(objectMap, "endpoints", i.Endpoints)
	populate(objectMap, "luns", i.Luns)
	populate(objectMap, "port", i.Port)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sessions", i.Sessions)
	populate(objectMap, "staticAcls", i.StaticACLs)
	populate(objectMap, "status", i.Status)
	populate(objectMap, "targetIqn", i.TargetIqn)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IscsiTargetUpdate.
func (i IscsiTargetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "managedBy", i.ManagedBy)
	populate(objectMap, "managedByExtended", i.ManagedByExtended)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IscsiTargetUpdateProperties.
func (i IscsiTargetUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "luns", i.Luns)
	populate(objectMap, "staticAcls", i.StaticACLs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemMetadata.
func (s SystemMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemMetadata.
func (s *SystemMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
