//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybriddatamanager

const (
	moduleName    = "armhybriddatamanager"
	moduleVersion = "v1.0.0"
)

// IsJobCancellable - Describes whether the job is cancellable.
type IsJobCancellable string

const (
	IsJobCancellableNotCancellable IsJobCancellable = "NotCancellable"
	IsJobCancellableCancellable    IsJobCancellable = "Cancellable"
)

// PossibleIsJobCancellableValues returns the possible values for the IsJobCancellable const type.
func PossibleIsJobCancellableValues() []IsJobCancellable {
	return []IsJobCancellable{
		IsJobCancellableNotCancellable,
		IsJobCancellableCancellable,
	}
}

// JobStatus - Status of the job.
type JobStatus string

const (
	JobStatusNone               JobStatus = "None"
	JobStatusInProgress         JobStatus = "InProgress"
	JobStatusSucceeded          JobStatus = "Succeeded"
	JobStatusWaitingForAction   JobStatus = "WaitingForAction"
	JobStatusFailed             JobStatus = "Failed"
	JobStatusCancelled          JobStatus = "Cancelled"
	JobStatusCancelling         JobStatus = "Cancelling"
	JobStatusPartiallySucceeded JobStatus = "PartiallySucceeded"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusNone,
		JobStatusInProgress,
		JobStatusSucceeded,
		JobStatusWaitingForAction,
		JobStatusFailed,
		JobStatusCancelled,
		JobStatusCancelling,
		JobStatusPartiallySucceeded,
	}
}

// RunLocation - This is the preferred geo location for the job to run.
type RunLocation string

const (
	RunLocationNone               RunLocation = "none"
	RunLocationAustraliaeast      RunLocation = "australiaeast"
	RunLocationAustraliasoutheast RunLocation = "australiasoutheast"
	RunLocationBrazilsouth        RunLocation = "brazilsouth"
	RunLocationCanadacentral      RunLocation = "canadacentral"
	RunLocationCanadaeast         RunLocation = "canadaeast"
	RunLocationCentralindia       RunLocation = "centralindia"
	RunLocationCentralus          RunLocation = "centralus"
	RunLocationEastasia           RunLocation = "eastasia"
	RunLocationEastus             RunLocation = "eastus"
	RunLocationEastus2            RunLocation = "eastus2"
	RunLocationJapaneast          RunLocation = "japaneast"
	RunLocationJapanwest          RunLocation = "japanwest"
	RunLocationKoreacentral       RunLocation = "koreacentral"
	RunLocationKoreasouth         RunLocation = "koreasouth"
	RunLocationSoutheastasia      RunLocation = "southeastasia"
	RunLocationSouthcentralus     RunLocation = "southcentralus"
	RunLocationSouthindia         RunLocation = "southindia"
	RunLocationNorthcentralus     RunLocation = "northcentralus"
	RunLocationNortheurope        RunLocation = "northeurope"
	RunLocationUksouth            RunLocation = "uksouth"
	RunLocationUkwest             RunLocation = "ukwest"
	RunLocationWestcentralus      RunLocation = "westcentralus"
	RunLocationWesteurope         RunLocation = "westeurope"
	RunLocationWestindia          RunLocation = "westindia"
	RunLocationWestus             RunLocation = "westus"
	RunLocationWestus2            RunLocation = "westus2"
)

// PossibleRunLocationValues returns the possible values for the RunLocation const type.
func PossibleRunLocationValues() []RunLocation {
	return []RunLocation{
		RunLocationNone,
		RunLocationAustraliaeast,
		RunLocationAustraliasoutheast,
		RunLocationBrazilsouth,
		RunLocationCanadacentral,
		RunLocationCanadaeast,
		RunLocationCentralindia,
		RunLocationCentralus,
		RunLocationEastasia,
		RunLocationEastus,
		RunLocationEastus2,
		RunLocationJapaneast,
		RunLocationJapanwest,
		RunLocationKoreacentral,
		RunLocationKoreasouth,
		RunLocationSoutheastasia,
		RunLocationSouthcentralus,
		RunLocationSouthindia,
		RunLocationNorthcentralus,
		RunLocationNortheurope,
		RunLocationUksouth,
		RunLocationUkwest,
		RunLocationWestcentralus,
		RunLocationWesteurope,
		RunLocationWestindia,
		RunLocationWestus,
		RunLocationWestus2,
	}
}

// State - State of the data service.
type State string

const (
	StateDisabled  State = "Disabled"
	StateEnabled   State = "Enabled"
	StateSupported State = "Supported"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateDisabled,
		StateEnabled,
		StateSupported,
	}
}

// SupportedAlgorithm - The encryption algorithm used to encrypt data.
type SupportedAlgorithm string

const (
	SupportedAlgorithmNone      SupportedAlgorithm = "None"
	SupportedAlgorithmRSA15     SupportedAlgorithm = "RSA1_5"
	SupportedAlgorithmRSAOAEP   SupportedAlgorithm = "RSA_OAEP"
	SupportedAlgorithmPlainText SupportedAlgorithm = "PlainText"
)

// PossibleSupportedAlgorithmValues returns the possible values for the SupportedAlgorithm const type.
func PossibleSupportedAlgorithmValues() []SupportedAlgorithm {
	return []SupportedAlgorithm{
		SupportedAlgorithmNone,
		SupportedAlgorithmRSA15,
		SupportedAlgorithmRSAOAEP,
		SupportedAlgorithmPlainText,
	}
}

// UserConfirmation - Enum to detect if user confirmation is required. If not passed will default to NotRequired.
type UserConfirmation string

const (
	UserConfirmationNotRequired UserConfirmation = "NotRequired"
	UserConfirmationRequired    UserConfirmation = "Required"
)

// PossibleUserConfirmationValues returns the possible values for the UserConfirmation const type.
func PossibleUserConfirmationValues() []UserConfirmation {
	return []UserConfirmation{
		UserConfirmationNotRequired,
		UserConfirmationRequired,
	}
}
