//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AlertPropertiesDetails.
func (a AlertPropertiesDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "amount", a.Amount)
	populate(objectMap, "companyName", a.CompanyName)
	populate(objectMap, "contactEmails", a.ContactEmails)
	populate(objectMap, "contactGroups", a.ContactGroups)
	populate(objectMap, "contactRoles", a.ContactRoles)
	populate(objectMap, "currentSpend", a.CurrentSpend)
	populate(objectMap, "departmentName", a.DepartmentName)
	populate(objectMap, "enrollmentEndDate", a.EnrollmentEndDate)
	populate(objectMap, "enrollmentNumber", a.EnrollmentNumber)
	populate(objectMap, "enrollmentStartDate", a.EnrollmentStartDate)
	populate(objectMap, "invoicingThreshold", a.InvoicingThreshold)
	populate(objectMap, "meterFilter", a.MeterFilter)
	populate(objectMap, "operator", a.Operator)
	populate(objectMap, "overridingAlert", a.OverridingAlert)
	populate(objectMap, "periodStartDate", a.PeriodStartDate)
	populate(objectMap, "resourceFilter", a.ResourceFilter)
	populate(objectMap, "resourceGroupFilter", a.ResourceGroupFilter)
	populate(objectMap, "tagFilter", &a.TagFilter)
	populate(objectMap, "threshold", a.Threshold)
	populate(objectMap, "timeGrainType", a.TimeGrainType)
	populate(objectMap, "triggeredBy", a.TriggeredBy)
	populate(objectMap, "unit", a.Unit)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CommonExportProperties.
func (c CommonExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "definition", c.Definition)
	populate(objectMap, "deliveryInfo", c.DeliveryInfo)
	populate(objectMap, "format", c.Format)
	populateTimeRFC3339(objectMap, "nextRunTimeEstimate", c.NextRunTimeEstimate)
	populate(objectMap, "partitionData", c.PartitionData)
	populate(objectMap, "runHistory", c.RunHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonExportProperties.
func (c *CommonExportProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &c.Definition)
			delete(rawMsg, key)
		case "deliveryInfo":
			err = unpopulate(val, "DeliveryInfo", &c.DeliveryInfo)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &c.Format)
			delete(rawMsg, key)
		case "nextRunTimeEstimate":
			err = unpopulateTimeRFC3339(val, "NextRunTimeEstimate", &c.NextRunTimeEstimate)
			delete(rawMsg, key)
		case "partitionData":
			err = unpopulate(val, "PartitionData", &c.PartitionData)
			delete(rawMsg, key)
		case "runHistory":
			err = unpopulate(val, "RunHistory", &c.RunHistory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DimensionProperties.
func (d *DimensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &d.Category)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &d.Data)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "filterEnabled":
			err = unpopulate(val, "FilterEnabled", &d.FilterEnabled)
			delete(rawMsg, key)
		case "groupingEnabled":
			err = unpopulate(val, "GroupingEnabled", &d.GroupingEnabled)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "total":
			err = unpopulate(val, "Total", &d.Total)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulateTimeRFC3339(val, "UsageEnd", &d.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulateTimeRFC3339(val, "UsageStart", &d.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DismissAlertPayload.
func (d DismissAlertPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURL.
func (d *DownloadURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadUrl":
			err = unpopulate(val, "DownloadURL", &d.DownloadURL)
			delete(rawMsg, key)
		case "validTill":
			err = unpopulateTimeRFC3339(val, "ValidTill", &d.ValidTill)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDatasetConfiguration.
func (e ExportDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "columns", e.Columns)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ExportExecutionListResult.
func (e ExportExecutionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ExportExecutionProperties.
func (e ExportExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", e.Error)
	populate(objectMap, "executionType", e.ExecutionType)
	populate(objectMap, "fileName", e.FileName)
	populateTimeRFC3339(objectMap, "processingEndTime", e.ProcessingEndTime)
	populateTimeRFC3339(objectMap, "processingStartTime", e.ProcessingStartTime)
	populate(objectMap, "runSettings", e.RunSettings)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "submittedBy", e.SubmittedBy)
	populateTimeRFC3339(objectMap, "submittedTime", e.SubmittedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportExecutionProperties.
func (e *ExportExecutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "executionType":
			err = unpopulate(val, "ExecutionType", &e.ExecutionType)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &e.FileName)
			delete(rawMsg, key)
		case "processingEndTime":
			err = unpopulateTimeRFC3339(val, "ProcessingEndTime", &e.ProcessingEndTime)
			delete(rawMsg, key)
		case "processingStartTime":
			err = unpopulateTimeRFC3339(val, "ProcessingStartTime", &e.ProcessingStartTime)
			delete(rawMsg, key)
		case "runSettings":
			err = unpopulate(val, "RunSettings", &e.RunSettings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		case "submittedBy":
			err = unpopulate(val, "SubmittedBy", &e.SubmittedBy)
			delete(rawMsg, key)
		case "submittedTime":
			err = unpopulateTimeRFC3339(val, "SubmittedTime", &e.SubmittedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportProperties.
func (e ExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "definition", e.Definition)
	populate(objectMap, "deliveryInfo", e.DeliveryInfo)
	populate(objectMap, "format", e.Format)
	populateTimeRFC3339(objectMap, "nextRunTimeEstimate", e.NextRunTimeEstimate)
	populate(objectMap, "partitionData", e.PartitionData)
	populate(objectMap, "runHistory", e.RunHistory)
	populate(objectMap, "schedule", e.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportProperties.
func (e *ExportProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &e.Definition)
			delete(rawMsg, key)
		case "deliveryInfo":
			err = unpopulate(val, "DeliveryInfo", &e.DeliveryInfo)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &e.Format)
			delete(rawMsg, key)
		case "nextRunTimeEstimate":
			err = unpopulateTimeRFC3339(val, "NextRunTimeEstimate", &e.NextRunTimeEstimate)
			delete(rawMsg, key)
		case "partitionData":
			err = unpopulate(val, "PartitionData", &e.PartitionData)
			delete(rawMsg, key)
		case "runHistory":
			err = unpopulate(val, "RunHistory", &e.RunHistory)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &e.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportRecurrencePeriod.
func (e ExportRecurrencePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "from", e.From)
	populateTimeRFC3339(objectMap, "to", e.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportRecurrencePeriod.
func (e *ExportRecurrencePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateTimeRFC3339(val, "From", &e.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateTimeRFC3339(val, "To", &e.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportTimePeriod.
func (e ExportTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "from", e.From)
	populateTimeRFC3339(objectMap, "to", e.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportTimePeriod.
func (e *ExportTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateTimeRFC3339(val, "From", &e.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateTimeRFC3339(val, "To", &e.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastDataset.
func (f ForecastDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregation", f.Aggregation)
	populate(objectMap, "configuration", f.Configuration)
	populate(objectMap, "filter", f.Filter)
	populate(objectMap, "granularity", f.Granularity)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryComparisonExpression.
func (q QueryComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", q.Name)
	populate(objectMap, "operator", q.Operator)
	populate(objectMap, "values", q.Values)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryDataset.
func (q QueryDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregation", q.Aggregation)
	populate(objectMap, "configuration", q.Configuration)
	populate(objectMap, "filter", q.Filter)
	populate(objectMap, "granularity", q.Granularity)
	populate(objectMap, "grouping", q.Grouping)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryDatasetConfiguration.
func (q QueryDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "columns", q.Columns)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryFilter.
func (q QueryFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "and", q.And)
	populate(objectMap, "dimensions", q.Dimensions)
	populate(objectMap, "or", q.Or)
	populate(objectMap, "tags", q.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type QueryTimePeriod.
func (q QueryTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "from", q.From)
	populateTimeRFC3339(objectMap, "to", q.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryTimePeriod.
func (q *QueryTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateTimeRFC3339(val, "From", &q.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateTimeRFC3339(val, "To", &q.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigComparisonExpression.
func (r ReportConfigComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "values", r.Values)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigDataset.
func (r ReportConfigDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aggregation", r.Aggregation)
	populate(objectMap, "configuration", r.Configuration)
	populate(objectMap, "filter", r.Filter)
	populate(objectMap, "granularity", r.Granularity)
	populate(objectMap, "grouping", r.Grouping)
	populate(objectMap, "sorting", r.Sorting)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigDatasetConfiguration.
func (r ReportConfigDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "columns", r.Columns)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigFilter.
func (r ReportConfigFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "and", r.And)
	populate(objectMap, "dimensions", r.Dimensions)
	populate(objectMap, "or", r.Or)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigTimePeriod.
func (r ReportConfigTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "from", r.From)
	populateTimeRFC3339(objectMap, "to", r.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigTimePeriod.
func (r *ReportConfigTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateTimeRFC3339(val, "From", &r.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateTimeRFC3339(val, "To", &r.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportURL.
func (r *ReportURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reportUrl":
			err = unpopulate(val, "ReportURL", &r.ReportURL)
			delete(rawMsg, key)
		case "validUntil":
			err = unpopulateTimeRFC3339(val, "ValidUntil", &r.ValidUntil)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ViewProperties.
func (v ViewProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accumulated", v.Accumulated)
	populate(objectMap, "chart", v.Chart)
	populateTimeRFC3339(objectMap, "createdOn", v.CreatedOn)
	populate(objectMap, "currency", v.Currency)
	populate(objectMap, "dateRange", v.DateRange)
	populate(objectMap, "displayName", v.DisplayName)
	populate(objectMap, "kpis", v.Kpis)
	populate(objectMap, "metric", v.Metric)
	populateTimeRFC3339(objectMap, "modifiedOn", v.ModifiedOn)
	populate(objectMap, "pivots", v.Pivots)
	populate(objectMap, "query", v.Query)
	populate(objectMap, "scope", v.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ViewProperties.
func (v *ViewProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accumulated":
			err = unpopulate(val, "Accumulated", &v.Accumulated)
			delete(rawMsg, key)
		case "chart":
			err = unpopulate(val, "Chart", &v.Chart)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateTimeRFC3339(val, "CreatedOn", &v.CreatedOn)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &v.Currency)
			delete(rawMsg, key)
		case "dateRange":
			err = unpopulate(val, "DateRange", &v.DateRange)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &v.DisplayName)
			delete(rawMsg, key)
		case "kpis":
			err = unpopulate(val, "Kpis", &v.Kpis)
			delete(rawMsg, key)
		case "metric":
			err = unpopulate(val, "Metric", &v.Metric)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateTimeRFC3339(val, "ModifiedOn", &v.ModifiedOn)
			delete(rawMsg, key)
		case "pivots":
			err = unpopulate(val, "Pivots", &v.Pivots)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &v.Query)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &v.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
