//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapplicationinsights

import "time"

// APIKeyRequest - An Application Insights component API Key creation request definition.
type APIKeyRequest struct {
	// The read access rights of this API Key.
	LinkedReadProperties []*string `json:"linkedReadProperties,omitempty"`

	// The write access rights of this API Key.
	LinkedWriteProperties []*string `json:"linkedWriteProperties,omitempty"`

	// The name of the API Key.
	Name *string `json:"name,omitempty"`
}

// APIKeysClientCreateOptions contains the optional parameters for the APIKeysClient.Create method.
type APIKeysClientCreateOptions struct {
	// placeholder for future optional parameters
}

// APIKeysClientDeleteOptions contains the optional parameters for the APIKeysClient.Delete method.
type APIKeysClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIKeysClientGetOptions contains the optional parameters for the APIKeysClient.Get method.
type APIKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIKeysClientListOptions contains the optional parameters for the APIKeysClient.List method.
type APIKeysClientListOptions struct {
	// placeholder for future optional parameters
}

// AnalyticsItemsClientDeleteOptions contains the optional parameters for the AnalyticsItemsClient.Delete method.
type AnalyticsItemsClientDeleteOptions struct {
	// The Id of a specific item defined in the Application Insights component
	ID *string
	// The name of a specific item defined in the Application Insights component
	Name *string
}

// AnalyticsItemsClientGetOptions contains the optional parameters for the AnalyticsItemsClient.Get method.
type AnalyticsItemsClientGetOptions struct {
	// The Id of a specific item defined in the Application Insights component
	ID *string
	// The name of a specific item defined in the Application Insights component
	Name *string
}

// AnalyticsItemsClientListOptions contains the optional parameters for the AnalyticsItemsClient.List method.
type AnalyticsItemsClientListOptions struct {
	// Flag indicating whether or not to return the content of each applicable item. If false, only return the item information.
	IncludeContent *bool
	// Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application
	// Insights component.
	Scope *ItemScope
	// Enum indicating the type of the Analytics item.
	Type *ItemTypeParameter
}

// AnalyticsItemsClientPutOptions contains the optional parameters for the AnalyticsItemsClient.Put method.
type AnalyticsItemsClientPutOptions struct {
	// Flag indicating whether or not to force save an item. This allows overriding an item if it already exists.
	OverrideItem *bool
}

// Annotation associated with an application insights resource.
type Annotation struct {
	// Name of annotation
	AnnotationName *string `json:"AnnotationName,omitempty"`

	// Category of annotation, free form
	Category *string `json:"Category,omitempty"`

	// Time when event occurred
	EventTime *time.Time `json:"EventTime,omitempty"`

	// Unique Id for annotation
	ID *string `json:"Id,omitempty"`

	// Serialized JSON object for detailed properties
	Properties *string `json:"Properties,omitempty"`

	// Related parent annotation if any
	RelatedAnnotation *string `json:"RelatedAnnotation,omitempty"`
}

// AnnotationError - Error associated with trying to create annotation with Id that already exist
type AnnotationError struct {
	// Error detail code and explanation
	Code *string `json:"code,omitempty"`

	// Inner error
	Innererror *InnerError `json:"innererror,omitempty"`

	// Error message
	Message *string `json:"message,omitempty"`
}

// AnnotationsClientCreateOptions contains the optional parameters for the AnnotationsClient.Create method.
type AnnotationsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// AnnotationsClientDeleteOptions contains the optional parameters for the AnnotationsClient.Delete method.
type AnnotationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AnnotationsClientGetOptions contains the optional parameters for the AnnotationsClient.Get method.
type AnnotationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AnnotationsClientListOptions contains the optional parameters for the AnnotationsClient.List method.
type AnnotationsClientListOptions struct {
	// placeholder for future optional parameters
}

// AnnotationsListResult - Annotations list result.
type AnnotationsListResult struct {
	// READ-ONLY; An array of annotations.
	Value []*Annotation `json:"value,omitempty" azure:"ro"`
}

// Component - An Application Insights component definition.
type Component struct {
	// REQUIRED; The kind of application that this component refers to, used to customize UI. This value is a freeform string,
	// values should typically be one of the following: web, ios, other, store, java, phone.
	Kind *string `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Properties that define an Application Insights component resource.
	Properties *ComponentProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ComponentAPIKey - Properties that define an API key of an Application Insights Component.
type ComponentAPIKey struct {
	// The create date of this API key.
	CreatedDate *string `json:"createdDate,omitempty"`

	// The read access rights of this API Key.
	LinkedReadProperties []*string `json:"linkedReadProperties,omitempty"`

	// The write access rights of this API Key.
	LinkedWriteProperties []*string `json:"linkedWriteProperties,omitempty"`

	// The name of the API key.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The API key value. It will be only return once when the API Key was created.
	APIKey *string `json:"apiKey,omitempty" azure:"ro"`

	// READ-ONLY; The unique ID of the API key inside an Application Insights component. It is auto generated when the API key
	// is created.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// ComponentAPIKeyListResult - Describes the list of API Keys of an Application Insights Component.
type ComponentAPIKeyListResult struct {
	// REQUIRED; List of API Key definitions.
	Value []*ComponentAPIKey `json:"value,omitempty"`
}

// ComponentAnalyticsItem - Properties that define an Analytics item that is associated to an Application Insights component.
type ComponentAnalyticsItem struct {
	// The content of this item
	Content *string `json:"Content,omitempty"`

	// Internally assigned unique id of the item definition.
	ID *string `json:"Id,omitempty"`

	// The user-defined name of the item.
	Name *string `json:"Name,omitempty"`

	// A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
	Properties *ComponentAnalyticsItemProperties `json:"Properties,omitempty"`

	// Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application
	// Insights component.
	Scope *ItemScope `json:"Scope,omitempty"`

	// Enum indicating the type of the Analytics item.
	Type *ItemType `json:"Type,omitempty"`

	// READ-ONLY; Date and time in UTC when this item was created.
	TimeCreated *string `json:"TimeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Date and time in UTC of the last modification that was made to this item.
	TimeModified *string `json:"TimeModified,omitempty" azure:"ro"`

	// READ-ONLY; This instance's version of the data model. This can change as new features are added.
	Version *string `json:"Version,omitempty" azure:"ro"`
}

// ComponentAnalyticsItemProperties - A set of properties that can be defined in the context of a specific item type. Each
// type may have its own properties.
type ComponentAnalyticsItemProperties struct {
	// A function alias, used when the type of the item is Function
	FunctionAlias *string `json:"functionAlias,omitempty"`
}

// ComponentAvailableFeatures - An Application Insights component available features.
type ComponentAvailableFeatures struct {
	// READ-ONLY; A list of Application Insights component feature.
	Result []*ComponentFeature `json:"Result,omitempty" azure:"ro"`
}

// ComponentAvailableFeaturesClientGetOptions contains the optional parameters for the ComponentAvailableFeaturesClient.Get
// method.
type ComponentAvailableFeaturesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComponentBillingFeatures - An Application Insights component billing features
type ComponentBillingFeatures struct {
	// Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application
	// Insights Enterprise'.
	CurrentBillingFeatures []*string `json:"CurrentBillingFeatures,omitempty"`

	// An Application Insights component daily data volume cap
	DataVolumeCap *ComponentDataVolumeCap `json:"DataVolumeCap,omitempty"`
}

// ComponentCurrentBillingFeaturesClientGetOptions contains the optional parameters for the ComponentCurrentBillingFeaturesClient.Get
// method.
type ComponentCurrentBillingFeaturesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComponentCurrentBillingFeaturesClientUpdateOptions contains the optional parameters for the ComponentCurrentBillingFeaturesClient.Update
// method.
type ComponentCurrentBillingFeaturesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ComponentDataVolumeCap - An Application Insights component daily data volume cap
type ComponentDataVolumeCap struct {
	// Daily data volume cap in GB.
	Cap *float32 `json:"Cap,omitempty"`

	// Do not send a notification email when the daily data volume cap is met.
	StopSendNotificationWhenHitCap *bool `json:"StopSendNotificationWhenHitCap,omitempty"`

	// Reserved, not used for now.
	StopSendNotificationWhenHitThreshold *bool `json:"StopSendNotificationWhenHitThreshold,omitempty"`

	// Reserved, not used for now.
	WarningThreshold *int32 `json:"WarningThreshold,omitempty"`

	// READ-ONLY; Maximum daily data volume cap that the user can set for this component.
	MaxHistoryCap *float32 `json:"MaxHistoryCap,omitempty" azure:"ro"`

	// READ-ONLY; Daily data volume cap UTC reset hour.
	ResetTime *int32 `json:"ResetTime,omitempty" azure:"ro"`
}

// ComponentExportConfiguration - Properties that define a Continuous Export configuration.
type ComponentExportConfiguration struct {
	// Deprecated
	NotificationQueueEnabled *string `json:"NotificationQueueEnabled,omitempty"`

	// This comma separated list of document types that will be exported. The possible values include 'Requests', 'Event', 'Exceptions',
	// 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd',
	// 'PerformanceCounters', 'Availability', 'Messages'.
	RecordTypes *string `json:"RecordTypes,omitempty"`

	// READ-ONLY; The name of the Application Insights component.
	ApplicationName *string `json:"ApplicationName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the destination storage container.
	ContainerName *string `json:"ContainerName,omitempty" azure:"ro"`

	// READ-ONLY; The name of destination account.
	DestinationAccountID *string `json:"DestinationAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The destination account location ID.
	DestinationStorageLocationID *string `json:"DestinationStorageLocationId,omitempty" azure:"ro"`

	// READ-ONLY; The destination storage account subscription ID.
	DestinationStorageSubscriptionID *string `json:"DestinationStorageSubscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; The destination type.
	DestinationType *string `json:"DestinationType,omitempty" azure:"ro"`

	// READ-ONLY; The unique ID of the export configuration inside an Application Insights component. It is auto generated when
	// the Continuous Export configuration is created.
	ExportID *string `json:"ExportId,omitempty" azure:"ro"`

	// READ-ONLY; This indicates current Continuous Export configuration status. The possible values are 'Preparing', 'Success',
	// 'Failure'.
	ExportStatus *string `json:"ExportStatus,omitempty" azure:"ro"`

	// READ-ONLY; The instrumentation key of the Application Insights component.
	InstrumentationKey *string `json:"InstrumentationKey,omitempty" azure:"ro"`

	// READ-ONLY; This will be 'true' if the Continuous Export configuration is enabled, otherwise it will be 'false'.
	IsUserEnabled *string `json:"IsUserEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The last time the Continuous Export configuration started failing.
	LastGapTime *string `json:"LastGapTime,omitempty" azure:"ro"`

	// READ-ONLY; The last time data was successfully delivered to the destination storage container for this Continuous Export
	// configuration.
	LastSuccessTime *string `json:"LastSuccessTime,omitempty" azure:"ro"`

	// READ-ONLY; Last time the Continuous Export configuration was updated.
	LastUserUpdate *string `json:"LastUserUpdate,omitempty" azure:"ro"`

	// READ-ONLY; This is the reason the Continuous Export configuration started failing. It can be 'AzureStorageNotFound' or
	// 'AzureStorageAccessDenied'.
	PermanentErrorReason *string `json:"PermanentErrorReason,omitempty" azure:"ro"`

	// READ-ONLY; The resource group of the Application Insights component.
	ResourceGroup *string `json:"ResourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; The name of the destination storage account.
	StorageName *string `json:"StorageName,omitempty" azure:"ro"`

	// READ-ONLY; The subscription of the Application Insights component.
	SubscriptionID *string `json:"SubscriptionId,omitempty" azure:"ro"`
}

// ComponentExportRequest - An Application Insights component Continuous Export configuration request definition.
type ComponentExportRequest struct {
	// The name of destination storage account.
	DestinationAccountID *string `json:"DestinationAccountId,omitempty"`

	// The SAS URL for the destination storage container. It must grant write permission.
	DestinationAddress *string `json:"DestinationAddress,omitempty"`

	// The location ID of the destination storage container.
	DestinationStorageLocationID *string `json:"DestinationStorageLocationId,omitempty"`

	// The subscription ID of the destination storage container.
	DestinationStorageSubscriptionID *string `json:"DestinationStorageSubscriptionId,omitempty"`

	// The Continuous Export destination type. This has to be 'Blob'.
	DestinationType *string `json:"DestinationType,omitempty"`

	// Set to 'true' to create a Continuous Export configuration as enabled, otherwise set it to 'false'.
	IsEnabled *string `json:"IsEnabled,omitempty"`

	// Deprecated
	NotificationQueueEnabled *string `json:"NotificationQueueEnabled,omitempty"`

	// Deprecated
	NotificationQueueURI *string `json:"NotificationQueueUri,omitempty"`

	// The document types to be exported, as comma separated values. Allowed values include 'Requests', 'Event', 'Exceptions',
	// 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters',
	// 'Availability', 'Messages'.
	RecordTypes *string `json:"RecordTypes,omitempty"`
}

// ComponentFavorite - Properties that define a favorite that is associated to an Application Insights component.
type ComponentFavorite struct {
	// Favorite category, as defined by the user at creation time.
	Category *string `json:"Category,omitempty"`

	// Configuration of this particular favorite, which are driven by the Azure portal UX. Configuration data is a string containing
	// valid JSON
	Config *string `json:"Config,omitempty"`

	// Enum indicating if this favorite definition is owned by a specific user or is shared between all users with access to the
	// Application Insights component.
	FavoriteType *FavoriteType `json:"FavoriteType,omitempty"`

	// Flag denoting wether or not this favorite was generated from a template.
	IsGeneratedFromTemplate *bool `json:"IsGeneratedFromTemplate,omitempty"`

	// The user-defined name of the favorite.
	Name *string `json:"Name,omitempty"`

	// The source of the favorite definition.
	SourceType *string `json:"SourceType,omitempty"`

	// A list of 0 or more tags that are associated with this favorite definition
	Tags []*string `json:"Tags,omitempty"`

	// This instance's version of the data model. This can change as new features are added that can be marked favorite. Current
	// examples include MetricsExplorer (ME) and Search.
	Version *string `json:"Version,omitempty"`

	// READ-ONLY; Internally assigned unique id of the favorite definition.
	FavoriteID *string `json:"FavoriteId,omitempty" azure:"ro"`

	// READ-ONLY; Date and time in UTC of the last modification that was made to this favorite definition.
	TimeModified *string `json:"TimeModified,omitempty" azure:"ro"`

	// READ-ONLY; Unique user id of the specific user that owns this favorite.
	UserID *string `json:"UserId,omitempty" azure:"ro"`
}

// ComponentFeature - An Application Insights component daily data volume cap status
type ComponentFeature struct {
	// READ-ONLY; A list of Application Insights component feature capability.
	Capabilities []*ComponentFeatureCapability `json:"Capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The pricing feature name.
	FeatureName *string `json:"FeatureName,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	IsHidden *bool `json:"IsHidden,omitempty" azure:"ro"`

	// READ-ONLY; Whether can apply addon feature on to it.
	IsMainFeature *bool `json:"IsMainFeature,omitempty" azure:"ro"`

	// READ-ONLY; The meter id used for the feature.
	MeterID *string `json:"MeterId,omitempty" azure:"ro"`

	// READ-ONLY; The meter rate for the feature's meter.
	MeterRateFrequency *string `json:"MeterRateFrequency,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	ResouceID *string `json:"ResouceId,omitempty" azure:"ro"`

	// READ-ONLY; The add on features on main feature.
	SupportedAddonFeatures *string `json:"SupportedAddonFeatures,omitempty" azure:"ro"`

	// READ-ONLY; Display name of the feature.
	Title *string `json:"Title,omitempty" azure:"ro"`
}

// ComponentFeatureCapabilities - An Application Insights component feature capabilities
type ComponentFeatureCapabilities struct {
	// READ-ONLY; Reserved, not used now.
	APIAccessLevel *string `json:"ApiAccessLevel,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	AnalyticsIntegration *bool `json:"AnalyticsIntegration,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	ApplicationMap *bool `json:"ApplicationMap,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	BurstThrottlePolicy *string `json:"BurstThrottlePolicy,omitempty" azure:"ro"`

	// READ-ONLY; Daily data volume cap in GB.
	DailyCap *float32 `json:"DailyCap,omitempty" azure:"ro"`

	// READ-ONLY; Daily data volume cap UTC reset hour.
	DailyCapResetTime *float32 `json:"DailyCapResetTime,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	LiveStreamMetrics *bool `json:"LiveStreamMetrics,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	MetadataClass *string `json:"MetadataClass,omitempty" azure:"ro"`

	// READ-ONLY; Whether allow to use multiple steps web test feature.
	MultipleStepWebTest *bool `json:"MultipleStepWebTest,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	OpenSchema *bool `json:"OpenSchema,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	PowerBIIntegration *bool `json:"PowerBIIntegration,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	ProactiveDetection *bool `json:"ProactiveDetection,omitempty" azure:"ro"`

	// READ-ONLY; Whether allow to use continuous export feature.
	SupportExportData *bool `json:"SupportExportData,omitempty" azure:"ro"`

	// READ-ONLY; Reserved, not used now.
	ThrottleRate *float32 `json:"ThrottleRate,omitempty" azure:"ro"`

	// READ-ONLY; The application insights component used tracking type.
	TrackingType *string `json:"TrackingType,omitempty" azure:"ro"`

	// READ-ONLY; Whether allow to use work item integration feature.
	WorkItemIntegration *bool `json:"WorkItemIntegration,omitempty" azure:"ro"`
}

// ComponentFeatureCapabilitiesClientGetOptions contains the optional parameters for the ComponentFeatureCapabilitiesClient.Get
// method.
type ComponentFeatureCapabilitiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComponentFeatureCapability - An Application Insights component feature capability
type ComponentFeatureCapability struct {
	// READ-ONLY; The description of the capability.
	Description *string `json:"Description,omitempty" azure:"ro"`

	// READ-ONLY; The meter used for the capability.
	MeterID *string `json:"MeterId,omitempty" azure:"ro"`

	// READ-ONLY; The meter rate of the meter.
	MeterRateFrequency *string `json:"MeterRateFrequency,omitempty" azure:"ro"`

	// READ-ONLY; The name of the capability.
	Name *string `json:"Name,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the capability.
	Unit *string `json:"Unit,omitempty" azure:"ro"`

	// READ-ONLY; The value of the capability.
	Value *string `json:"Value,omitempty" azure:"ro"`
}

// ComponentLinkedStorageAccounts - An Application Insights component linked storage accounts
type ComponentLinkedStorageAccounts struct {
	// The properties of the linked storage accounts.
	Properties *LinkedStorageAccountsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ComponentLinkedStorageAccountsClientCreateAndUpdateOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.CreateAndUpdate
// method.
type ComponentLinkedStorageAccountsClientCreateAndUpdateOptions struct {
	// placeholder for future optional parameters
}

// ComponentLinkedStorageAccountsClientDeleteOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.Delete
// method.
type ComponentLinkedStorageAccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ComponentLinkedStorageAccountsClientGetOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.Get
// method.
type ComponentLinkedStorageAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComponentLinkedStorageAccountsClientUpdateOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.Update
// method.
type ComponentLinkedStorageAccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ComponentLinkedStorageAccountsPatch - An Application Insights component linked storage accounts patch
type ComponentLinkedStorageAccountsPatch struct {
	// The properties of the linked storage accounts.
	Properties *LinkedStorageAccountsProperties `json:"properties,omitempty"`
}

// ComponentListResult - Describes the list of Application Insights Resources.
type ComponentListResult struct {
	// REQUIRED; List of Application Insights component definitions.
	Value []*Component `json:"value,omitempty"`

	// The URI to get the next set of Application Insights component definitions if too many components where returned in the
	// result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// ComponentProactiveDetectionConfiguration - Properties that define a ProactiveDetection configuration.
type ComponentProactiveDetectionConfiguration struct {
	// Custom email addresses for this rule notifications
	CustomEmails []*string `json:"CustomEmails,omitempty"`

	// A flag that indicates whether this rule is enabled by the user
	Enabled *bool `json:"Enabled,omitempty"`

	// The last time this rule was updated
	LastUpdatedTime *string `json:"LastUpdatedTime,omitempty"`

	// The rule name
	Name *string `json:"Name,omitempty"`

	// Static definitions of the ProactiveDetection configuration rule (same values for all components).
	RuleDefinitions *ComponentProactiveDetectionConfigurationRuleDefinitions `json:"RuleDefinitions,omitempty"`

	// A flag that indicated whether notifications on this rule should be sent to subscription owners
	SendEmailsToSubscriptionOwners *bool `json:"SendEmailsToSubscriptionOwners,omitempty"`
}

// ComponentProactiveDetectionConfigurationRuleDefinitions - Static definitions of the ProactiveDetection configuration rule
// (same values for all components).
type ComponentProactiveDetectionConfigurationRuleDefinitions struct {
	// The rule description
	Description *string `json:"Description,omitempty"`

	// The rule name as it is displayed in UI
	DisplayName *string `json:"DisplayName,omitempty"`

	// URL which displays additional info about the proactive detection rule
	HelpURL *string `json:"HelpUrl,omitempty"`

	// A flag indicating whether the rule is enabled by default
	IsEnabledByDefault *bool `json:"IsEnabledByDefault,omitempty"`

	// A flag indicating whether the rule is hidden (from the UI)
	IsHidden *bool `json:"IsHidden,omitempty"`

	// A flag indicating whether the rule is in preview
	IsInPreview *bool `json:"IsInPreview,omitempty"`

	// The rule name
	Name *string `json:"Name,omitempty"`

	// A flag indicating whether email notifications are supported for detections for this rule
	SupportsEmailNotifications *bool `json:"SupportsEmailNotifications,omitempty"`
}

// ComponentProperties - Properties that define an Application Insights component resource.
type ComponentProperties struct {
	// REQUIRED; Type of application being monitored.
	ApplicationType *ApplicationType `json:"Application_Type,omitempty"`

	// Disable IP masking.
	DisableIPMasking *bool `json:"DisableIpMasking,omitempty"`

	// Disable Non-AAD based Auth.
	DisableLocalAuth *bool `json:"DisableLocalAuth,omitempty"`

	// Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set
	// to 'Bluefield' when creating/updating a component via the REST API.
	FlowType *FlowType `json:"Flow_Type,omitempty"`

	// Force users to create their own storage account for profiler and debugger.
	ForceCustomerStorageForProfiler *bool `json:"ForceCustomerStorageForProfiler,omitempty"`

	// The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
	HockeyAppID *string `json:"HockeyAppId,omitempty"`

	// Purge data immediately after 30 days.
	ImmediatePurgeDataOn30Days *bool `json:"ImmediatePurgeDataOn30Days,omitempty"`

	// Indicates the flow of the ingestion.
	IngestionMode *IngestionMode `json:"IngestionMode,omitempty"`

	// The network access type for accessing Application Insights ingestion.
	PublicNetworkAccessForIngestion *PublicNetworkAccessType `json:"publicNetworkAccessForIngestion,omitempty"`

	// The network access type for accessing Application Insights query.
	PublicNetworkAccessForQuery *PublicNetworkAccessType `json:"publicNetworkAccessForQuery,omitempty"`

	// Describes what tool created this Application Insights component. Customers using this API should set this to the default
	// 'rest'.
	RequestSource *RequestSource `json:"Request_Source,omitempty"`

	// Retention period in days.
	RetentionInDays *int32 `json:"RetentionInDays,omitempty"`

	// Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
	SamplingPercentage *float64 `json:"SamplingPercentage,omitempty"`

	// Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application
	// with this API version. Applications from older versions will not have
	// this property.
	WorkspaceResourceID *string `json:"WorkspaceResourceId,omitempty"`

	// READ-ONLY; Application Insights Unique ID for your Application.
	AppID *string `json:"AppId,omitempty" azure:"ro"`

	// READ-ONLY; The unique ID of your application. This field mirrors the 'Name' field and cannot be changed.
	ApplicationID *string `json:"ApplicationId,omitempty" azure:"ro"`

	// READ-ONLY; Application Insights component connection string.
	ConnectionString *string `json:"ConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; Creation Date for the Application Insights component, in ISO 8601 format.
	CreationDate *time.Time `json:"CreationDate,omitempty" azure:"ro"`

	// READ-ONLY; Token used to authenticate communications with between Application Insights and HockeyApp.
	HockeyAppToken *string `json:"HockeyAppToken,omitempty" azure:"ro"`

	// READ-ONLY; Application Insights Instrumentation key. A read-only value that applications can use to identify the destination
	// for all telemetry sent to Azure Application Insights. This value will be supplied upon
	// construction of each new Application Insights component.
	InstrumentationKey *string `json:"InstrumentationKey,omitempty" azure:"ro"`

	// READ-ONLY; The date which the component got migrated to LA, in ISO 8601 format.
	LaMigrationDate *time.Time `json:"LaMigrationDate,omitempty" azure:"ro"`

	// READ-ONLY; Application name.
	Name *string `json:"Name,omitempty" azure:"ro"`

	// READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources []*PrivateLinkScopedResource `json:"PrivateLinkScopedResources,omitempty" azure:"ro"`

	// READ-ONLY; Current state of this component: whether or not is has been provisioned within the resource group it is defined.
	// Users cannot change this value but are able to read from it. Values will include
	// Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Azure Tenant Id.
	TenantID *string `json:"TenantId,omitempty" azure:"ro"`
}

// ComponentPurgeBody - Describes the body of a purge request for an App Insights component
type ComponentPurgeBody struct {
	// REQUIRED; The set of columns and filters (queries) to run over them to purge the resulting data.
	Filters []*ComponentPurgeBodyFilters `json:"filters,omitempty"`

	// REQUIRED; Table from which to purge data.
	Table *string `json:"table,omitempty"`
}

// ComponentPurgeBodyFilters - User-defined filters to return data which will be purged from the table.
type ComponentPurgeBodyFilters struct {
	// The column of the table over which the given query should run
	Column *string `json:"column,omitempty"`

	// When filtering over custom dimensions, this key will be used as the name of the custom dimension.
	Key *string `json:"key,omitempty"`

	// A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >, >=, <,
	// <=, between, and have the same behavior as they would in a KQL query.
	Operator *string `json:"operator,omitempty"`

	// the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >= '2017-09-01') or
	// array of values.
	Value interface{} `json:"value,omitempty"`
}

// ComponentPurgeResponse - Response containing operationId for a specific purge action.
type ComponentPurgeResponse struct {
	// REQUIRED; Id to use when querying for status for a particular purge operation.
	OperationID *string `json:"operationId,omitempty"`
}

// ComponentPurgeStatusResponse - Response containing status for a specific purge operation.
type ComponentPurgeStatusResponse struct {
	// REQUIRED; Status of the operation represented by the requested Id.
	Status *PurgeState `json:"status,omitempty"`
}

// ComponentQuotaStatus - An Application Insights component daily data volume cap status
type ComponentQuotaStatus struct {
	// READ-ONLY; The Application ID for the Application Insights component.
	AppID *string `json:"AppId,omitempty" azure:"ro"`

	// READ-ONLY; Date and time when the daily data volume cap will be reset, and data ingestion will resume.
	ExpirationTime *string `json:"ExpirationTime,omitempty" azure:"ro"`

	// READ-ONLY; The daily data volume cap is met, and data ingestion will be stopped.
	ShouldBeThrottled *bool `json:"ShouldBeThrottled,omitempty" azure:"ro"`
}

// ComponentQuotaStatusClientGetOptions contains the optional parameters for the ComponentQuotaStatusClient.Get method.
type ComponentQuotaStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComponentWebTestLocation - Properties that define a web test location available to an Application Insights Component.
type ComponentWebTestLocation struct {
	// READ-ONLY; The display name of the web test location.
	DisplayName *string `json:"DisplayName,omitempty" azure:"ro"`

	// READ-ONLY; Internally defined geographic location tag.
	Tag *string `json:"Tag,omitempty" azure:"ro"`
}

// ComponentsClientCreateOrUpdateOptions contains the optional parameters for the ComponentsClient.CreateOrUpdate method.
type ComponentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientDeleteOptions contains the optional parameters for the ComponentsClient.Delete method.
type ComponentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientGetOptions contains the optional parameters for the ComponentsClient.Get method.
type ComponentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientGetPurgeStatusOptions contains the optional parameters for the ComponentsClient.GetPurgeStatus method.
type ComponentsClientGetPurgeStatusOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientListByResourceGroupOptions contains the optional parameters for the ComponentsClient.ListByResourceGroup
// method.
type ComponentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientListOptions contains the optional parameters for the ComponentsClient.List method.
type ComponentsClientListOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientPurgeOptions contains the optional parameters for the ComponentsClient.Purge method.
type ComponentsClientPurgeOptions struct {
	// placeholder for future optional parameters
}

// ComponentsClientUpdateTagsOptions contains the optional parameters for the ComponentsClient.UpdateTags method.
type ComponentsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ComponentsResource - An azure resource object
type ComponentsResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	Innererror interface{} `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates Insights service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

type ErrorResponseComponents struct {
	// Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error
	// message.
	Error *ErrorResponseComponentsError `json:"error,omitempty"`
}

// ErrorResponseComponentsError - Error response indicates Insights service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponseComponentsError struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

type ErrorResponseLinkedStorage struct {
	// Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error
	// message.
	Error *ErrorResponseLinkedStorageError `json:"error,omitempty"`
}

// ErrorResponseLinkedStorageError - Error response indicates Insights service is not able to process the incoming request.
// The reason is provided in the error message.
type ErrorResponseLinkedStorageError struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ExportConfigurationsClientCreateOptions contains the optional parameters for the ExportConfigurationsClient.Create method.
type ExportConfigurationsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ExportConfigurationsClientDeleteOptions contains the optional parameters for the ExportConfigurationsClient.Delete method.
type ExportConfigurationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ExportConfigurationsClientGetOptions contains the optional parameters for the ExportConfigurationsClient.Get method.
type ExportConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExportConfigurationsClientListOptions contains the optional parameters for the ExportConfigurationsClient.List method.
type ExportConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExportConfigurationsClientUpdateOptions contains the optional parameters for the ExportConfigurationsClient.Update method.
type ExportConfigurationsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// FavoritesClientAddOptions contains the optional parameters for the FavoritesClient.Add method.
type FavoritesClientAddOptions struct {
	// placeholder for future optional parameters
}

// FavoritesClientDeleteOptions contains the optional parameters for the FavoritesClient.Delete method.
type FavoritesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FavoritesClientGetOptions contains the optional parameters for the FavoritesClient.Get method.
type FavoritesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FavoritesClientListOptions contains the optional parameters for the FavoritesClient.List method.
type FavoritesClientListOptions struct {
	// Flag indicating whether or not to return the full content for each applicable favorite. If false, only return summary content
	// for favorites.
	CanFetchContent *bool
	// The type of favorite. Value can be either shared or user.
	FavoriteType *FavoriteType
	// Source type of favorite to return. When left out, the source type defaults to 'other' (not present in this enum).
	SourceType *FavoriteSourceType
	// Tags that must be present on each favorite returned.
	Tags []string
}

// FavoritesClientUpdateOptions contains the optional parameters for the FavoritesClient.Update method.
type FavoritesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// InnerError - Inner error
type InnerError struct {
	// Provides correlation for request
	Diagnosticcontext *string `json:"diagnosticcontext,omitempty"`

	// Request time
	Time *time.Time `json:"time,omitempty"`
}

// InnerErrorTrace - Error details
type InnerErrorTrace struct {
	// READ-ONLY; detailed error trace
	Trace []*string `json:"trace,omitempty" azure:"ro"`
}

// LinkedStorageAccountsProperties - An Application Insights component linked storage account
type LinkedStorageAccountsProperties struct {
	// Linked storage account resource ID
	LinkedStorageAccount *string `json:"linkedStorageAccount,omitempty"`
}

// LiveTokenClientGetOptions contains the optional parameters for the LiveTokenClient.Get method.
type LiveTokenClientGetOptions struct {
	// placeholder for future optional parameters
}

// LiveTokenResponse - The response to a live token query.
type LiveTokenResponse struct {
	// READ-ONLY; JWT token for accessing live metrics stream data.
	LiveToken *string `json:"liveToken,omitempty" azure:"ro"`
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MyWorkbook - An Application Insights private workbook definition.
type MyWorkbook struct {
	// Resource etag
	Etag map[string]*string `json:"etag,omitempty"`

	// Azure resource Id
	ID *string `json:"id,omitempty"`

	// Identity used for BYOS
	Identity *MyWorkbookManagedIdentity `json:"identity,omitempty"`

	// The kind of workbook. Choices are user and shared.
	Kind *Kind `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Azure resource name
	Name *string `json:"name,omitempty"`

	// Metadata describing a workbook for an Azure resource.
	Properties *MyWorkbookProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Azure resource type
	Type *string `json:"type,omitempty"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// MyWorkbookError - Error response.
type MyWorkbookError struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// MyWorkbookManagedIdentity - Customer Managed Identity
type MyWorkbookManagedIdentity struct {
	// The identity type.
	Type *MyWorkbookManagedIdentityType `json:"type,omitempty"`

	// Customer Managed Identity
	UserAssignedIdentities *MyWorkbookUserAssignedIdentities `json:"userAssignedIdentities,omitempty"`
}

// MyWorkbookProperties - Properties that contain a private workbook.
type MyWorkbookProperties struct {
	// REQUIRED; Workbook category, as defined by the user at creation time.
	Category *string `json:"category,omitempty"`

	// REQUIRED; The user-defined name of the private workbook.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Configuration of this particular private workbook. Configuration data is a string containing valid JSON
	SerializedData *string `json:"serializedData,omitempty"`

	// Optional resourceId for a source resource.
	SourceID *string `json:"sourceId,omitempty"`

	// BYOS Storage Account URI
	StorageURI *string `json:"storageUri,omitempty"`

	// A list of 0 or more tags that are associated with this private workbook definition
	Tags []*string `json:"tags,omitempty"`

	// This instance's version of the data model. This can change as new features are added that can be marked private workbook.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Date and time in UTC of the last modification that was made to this private workbook definition.
	TimeModified *string `json:"timeModified,omitempty" azure:"ro"`

	// READ-ONLY; Unique user id of the specific user that owns this private workbook.
	UserID *string `json:"userId,omitempty" azure:"ro"`
}

// MyWorkbookResource - An azure resource object
type MyWorkbookResource struct {
	// Resource etag
	Etag map[string]*string `json:"etag,omitempty"`

	// Azure resource Id
	ID *string `json:"id,omitempty"`

	// Identity used for BYOS
	Identity *MyWorkbookManagedIdentity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Azure resource name
	Name *string `json:"name,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Azure resource type
	Type *string `json:"type,omitempty"`
}

// MyWorkbookUserAssignedIdentities - Customer Managed Identity
type MyWorkbookUserAssignedIdentities struct {
	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MyWorkbooksClientCreateOrUpdateOptions contains the optional parameters for the MyWorkbooksClient.CreateOrUpdate method.
type MyWorkbooksClientCreateOrUpdateOptions struct {
	// Azure Resource Id that will fetch all linked workbooks.
	SourceID *string
}

// MyWorkbooksClientDeleteOptions contains the optional parameters for the MyWorkbooksClient.Delete method.
type MyWorkbooksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MyWorkbooksClientGetOptions contains the optional parameters for the MyWorkbooksClient.Get method.
type MyWorkbooksClientGetOptions struct {
	// placeholder for future optional parameters
}

// MyWorkbooksClientListByResourceGroupOptions contains the optional parameters for the MyWorkbooksClient.ListByResourceGroup
// method.
type MyWorkbooksClientListByResourceGroupOptions struct {
	// Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content
	// for workbooks.
	CanFetchContent *bool
	// Azure Resource Id that will fetch all linked workbooks.
	SourceID *string
	// Tags presents on each workbook returned.
	Tags []string
}

// MyWorkbooksClientListBySubscriptionOptions contains the optional parameters for the MyWorkbooksClient.ListBySubscription
// method.
type MyWorkbooksClientListBySubscriptionOptions struct {
	// Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content
	// for workbooks.
	CanFetchContent *bool
	// Tags presents on each workbook returned.
	Tags []string
}

// MyWorkbooksClientUpdateOptions contains the optional parameters for the MyWorkbooksClient.Update method.
type MyWorkbooksClientUpdateOptions struct {
	// Azure Resource Id that will fetch all linked workbooks.
	SourceID *string
}

// MyWorkbooksListResult - Workbook list result.
type MyWorkbooksListResult struct {
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; An array of private workbooks.
	Value []*MyWorkbook `json:"value,omitempty" azure:"ro"`
}

// Operation - CDN REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationInfo - Information about an operation
type OperationInfo struct {
	// Description of the operation
	Description *string `json:"description,omitempty"`

	// Name of the operation
	Operation *string `json:"operation,omitempty"`

	// Name of the provider
	Provider *string `json:"provider,omitempty"`

	// Name of the resource type
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list CDN operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of CDN operations supported by the CDN resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationLive - Represents an operation returned by the GetOperations request
type OperationLive struct {
	// Display name of the operation
	Display *OperationInfo `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsListResult - Result of the List Operations operation
type OperationsListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of operations
	Value []*OperationLive `json:"value,omitempty"`
}

// PrivateLinkScopedResource - The private link scope resource reference.
type PrivateLinkScopedResource struct {
	// The full resource Id of the private link scope resource.
	ResourceID *string `json:"ResourceId,omitempty"`

	// The private link scope unique Identifier.
	ScopeID *string `json:"ScopeId,omitempty"`
}

// ProactiveDetectionConfigurationsClientGetOptions contains the optional parameters for the ProactiveDetectionConfigurationsClient.Get
// method.
type ProactiveDetectionConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProactiveDetectionConfigurationsClientListOptions contains the optional parameters for the ProactiveDetectionConfigurationsClient.List
// method.
type ProactiveDetectionConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProactiveDetectionConfigurationsClientUpdateOptions contains the optional parameters for the ProactiveDetectionConfigurationsClient.Update
// method.
type ProactiveDetectionConfigurationsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a WebTest instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// WebTest - An Application Insights web test definition.
type WebTest struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The kind of web test that this web test watches. Choices are ping and multistep.
	Kind *WebTestKind `json:"kind,omitempty"`

	// Metadata describing a web test for an Azure resource.
	Properties *WebTestProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebTestGeolocation - Geo-physical location to run a web test from. You must specify one or more locations for the test
// to run from.
type WebTestGeolocation struct {
	// Location ID for the webtest to run from.
	Location *string `json:"Id,omitempty"`
}

// WebTestListResult - A list of 0 or more Application Insights web test definitions.
type WebTestListResult struct {
	// REQUIRED; Set of Application Insights web test definitions.
	Value []*WebTest `json:"value,omitempty"`

	// The link to get the next part of the returned list of web tests, should the return set be too large for a single request.
	// May be null.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebTestLocationsClientListOptions contains the optional parameters for the WebTestLocationsClient.List method.
type WebTestLocationsClientListOptions struct {
	// placeholder for future optional parameters
}

// WebTestLocationsListResult - Describes the list of web test locations available to an Application Insights Component.
type WebTestLocationsListResult struct {
	// REQUIRED; List of web test locations.
	Value []*ComponentWebTestLocation `json:"value,omitempty"`
}

// WebTestProperties - Metadata describing a web test for an Azure resource.
type WebTestProperties struct {
	// REQUIRED; A list of where to physically run the tests from to give global coverage for accessibility of your application.
	Locations []*WebTestGeolocation `json:"Locations,omitempty"`

	// REQUIRED; Unique ID of this WebTest. This is typically the same value as the Name field.
	SyntheticMonitorID *string `json:"SyntheticMonitorId,omitempty"`

	// REQUIRED; The kind of web test this is, valid choices are ping and multistep.
	WebTestKind *WebTestKind `json:"Kind,omitempty"`

	// REQUIRED; User defined name if this WebTest.
	WebTestName *string `json:"Name,omitempty"`

	// An XML configuration specification for a WebTest.
	Configuration *WebTestPropertiesConfiguration `json:"Configuration,omitempty"`

	// Purpose/user defined descriptive test for this WebTest.
	Description *string `json:"Description,omitempty"`

	// Is the test actively being monitored.
	Enabled *bool `json:"Enabled,omitempty"`

	// Interval in seconds between test runs for this WebTest. Default value is 300.
	Frequency *int32 `json:"Frequency,omitempty"`

	// Allow for retries should this WebTest fail.
	RetryEnabled *bool `json:"RetryEnabled,omitempty"`

	// Seconds until this WebTest will timeout and fail. Default value is 30.
	Timeout *int32 `json:"Timeout,omitempty"`

	// READ-ONLY; Current state of this component, whether or not is has been provisioned within the resource group it is defined.
	// Users cannot change this value but are able to read from it. Values will include
	// Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// WebTestPropertiesConfiguration - An XML configuration specification for a WebTest.
type WebTestPropertiesConfiguration struct {
	// The XML specification of a WebTest to run against an application.
	WebTest *string `json:"WebTest,omitempty"`
}

// WebTestsClientCreateOrUpdateOptions contains the optional parameters for the WebTestsClient.CreateOrUpdate method.
type WebTestsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WebTestsClientDeleteOptions contains the optional parameters for the WebTestsClient.Delete method.
type WebTestsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WebTestsClientGetOptions contains the optional parameters for the WebTestsClient.Get method.
type WebTestsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WebTestsClientListByComponentOptions contains the optional parameters for the WebTestsClient.ListByComponent method.
type WebTestsClientListByComponentOptions struct {
	// placeholder for future optional parameters
}

// WebTestsClientListByResourceGroupOptions contains the optional parameters for the WebTestsClient.ListByResourceGroup method.
type WebTestsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WebTestsClientListOptions contains the optional parameters for the WebTestsClient.List method.
type WebTestsClientListOptions struct {
	// placeholder for future optional parameters
}

// WebTestsClientUpdateTagsOptions contains the optional parameters for the WebTestsClient.UpdateTags method.
type WebTestsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// WebtestsResource - An azure resource object
type WebtestsResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkItemConfiguration - Work item configuration associated with an application insights resource.
type WorkItemConfiguration struct {
	// Configuration friendly name
	ConfigDisplayName *string `json:"ConfigDisplayName,omitempty"`

	// Serialized JSON object for detailed properties
	ConfigProperties *string `json:"ConfigProperties,omitempty"`

	// Connector identifier where work item is created
	ConnectorID *string `json:"ConnectorId,omitempty"`

	// Unique Id for work item
	ID *string `json:"Id,omitempty"`

	// Boolean value indicating whether configuration is default
	IsDefault *bool `json:"IsDefault,omitempty"`
}

// WorkItemConfigurationError - Error associated with trying to get work item configuration or configurations
type WorkItemConfigurationError struct {
	// Error detail code and explanation
	Code *string `json:"code,omitempty"`

	// Inner error
	Innererror *InnerError `json:"innererror,omitempty"`

	// Error message
	Message *string `json:"message,omitempty"`
}

// WorkItemConfigurationsClientCreateOptions contains the optional parameters for the WorkItemConfigurationsClient.Create
// method.
type WorkItemConfigurationsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// WorkItemConfigurationsClientDeleteOptions contains the optional parameters for the WorkItemConfigurationsClient.Delete
// method.
type WorkItemConfigurationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkItemConfigurationsClientGetDefaultOptions contains the optional parameters for the WorkItemConfigurationsClient.GetDefault
// method.
type WorkItemConfigurationsClientGetDefaultOptions struct {
	// placeholder for future optional parameters
}

// WorkItemConfigurationsClientGetItemOptions contains the optional parameters for the WorkItemConfigurationsClient.GetItem
// method.
type WorkItemConfigurationsClientGetItemOptions struct {
	// placeholder for future optional parameters
}

// WorkItemConfigurationsClientListOptions contains the optional parameters for the WorkItemConfigurationsClient.List method.
type WorkItemConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkItemConfigurationsClientUpdateItemOptions contains the optional parameters for the WorkItemConfigurationsClient.UpdateItem
// method.
type WorkItemConfigurationsClientUpdateItemOptions struct {
	// placeholder for future optional parameters
}

// WorkItemConfigurationsListResult - Work item configuration list result.
type WorkItemConfigurationsListResult struct {
	// READ-ONLY; An array of work item configurations.
	Value []*WorkItemConfiguration `json:"value,omitempty" azure:"ro"`
}

// WorkItemCreateConfiguration - Work item configuration creation payload
type WorkItemCreateConfiguration struct {
	// Serialized JSON object for detailed properties
	ConnectorDataConfiguration *string `json:"ConnectorDataConfiguration,omitempty"`

	// Unique connector id
	ConnectorID *string `json:"ConnectorId,omitempty"`

	// Boolean indicating validate only
	ValidateOnly *bool `json:"ValidateOnly,omitempty"`

	// Custom work item properties
	WorkItemProperties map[string]*string `json:"WorkItemProperties,omitempty"`
}

// Workbook - A workbook definition.
type Workbook struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Identity used for BYOS
	Identity *WorkbookResourceIdentity `json:"identity,omitempty"`

	// The kind of workbook. Only valid value is shared.
	Kind *WorkbookSharedTypeKind `json:"kind,omitempty"`

	// Metadata describing a workbook for an Azure resource.
	Properties *WorkbookProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkbookError - Error response.
type WorkbookError struct {
	// The error details.
	Error *WorkbookErrorDefinition `json:"error,omitempty"`
}

// WorkbookErrorDefinition - Error definition.
type WorkbookErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	InnerError interface{} `json:"innerError,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// WorkbookInnerErrorTrace - Error details
type WorkbookInnerErrorTrace struct {
	// READ-ONLY; detailed error trace
	Trace []*string `json:"trace,omitempty" azure:"ro"`
}

// WorkbookProperties - Properties that contain a workbook.
type WorkbookProperties struct {
	// REQUIRED; Workbook category, as defined by the user at creation time.
	Category *string `json:"category,omitempty"`

	// REQUIRED; The user-defined name (display name) of the workbook.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Configuration of this particular workbook. Configuration data is a string containing valid JSON
	SerializedData *string `json:"serializedData,omitempty"`

	// The description of the workbook.
	Description *string `json:"description,omitempty"`

	// ResourceId for a source resource.
	SourceID *string `json:"sourceId,omitempty"`

	// The resourceId to the storage account when bring your own storage is used
	StorageURI *string `json:"storageUri,omitempty"`

	// Being deprecated, please use the other tags field
	Tags []*string `json:"tags,omitempty"`

	// Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The unique revision id for this workbook definition
	Revision *string `json:"revision,omitempty" azure:"ro"`

	// READ-ONLY; Date and time in UTC of the last modification that was made to this workbook definition.
	TimeModified *time.Time `json:"timeModified,omitempty" azure:"ro"`

	// READ-ONLY; Unique user id of the specific user that owns this workbook.
	UserID *string `json:"userId,omitempty" azure:"ro"`
}

// WorkbookPropertiesUpdateParameters - Properties that contain a workbook for PATCH operation.
type WorkbookPropertiesUpdateParameters struct {
	// Workbook category, as defined by the user at creation time.
	Category *string `json:"category,omitempty"`

	// The description of the workbook.
	Description *string `json:"description,omitempty"`

	// The user-defined name (display name) of the workbook.
	DisplayName *string `json:"displayName,omitempty"`

	// The unique revision id for this workbook definition
	Revision *string `json:"revision,omitempty"`

	// Configuration of this particular workbook. Configuration data is a string containing valid JSON
	SerializedData *string `json:"serializedData,omitempty"`

	// A list of 0 or more tags that are associated with this workbook definition
	Tags []*string `json:"tags,omitempty"`
}

// WorkbookResource - An azure resource object
type WorkbookResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Identity used for BYOS
	Identity *WorkbookResourceIdentity `json:"identity,omitempty"`

	// The kind of workbook. Only valid value is shared.
	Kind *WorkbookSharedTypeKind `json:"kind,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkbookResourceIdentity - Identity used for BYOS
type WorkbookResourceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// WorkbookTemplate - An Application Insights workbook template definition.
type WorkbookTemplate struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Metadata describing a workbook template for an Azure resource.
	Properties *WorkbookTemplateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkbookTemplateError - Error message that will indicate why the operation failed.
type WorkbookTemplateError struct {
	// Error message object that will indicate why the operation failed.
	Error *WorkbookTemplateErrorBody `json:"error,omitempty"`
}

// WorkbookTemplateErrorBody - Error message body that will indicate why the operation failed.
type WorkbookTemplateErrorBody struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`

	// The list of invalid fields send in request, in case of validation error.
	Details []*WorkbookTemplateErrorFieldContract `json:"details,omitempty"`

	// Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// WorkbookTemplateErrorFieldContract - Error Field contract.
type WorkbookTemplateErrorFieldContract struct {
	// Property level error code.
	Code *string `json:"code,omitempty"`

	// Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`

	// Property name.
	Target *string `json:"target,omitempty"`
}

// WorkbookTemplateGallery - Gallery information for a workbook template.
type WorkbookTemplateGallery struct {
	// Category for the gallery.
	Category *string `json:"category,omitempty"`

	// Name of the workbook template in the gallery.
	Name *string `json:"name,omitempty"`

	// Order of the template within the gallery.
	Order *int32 `json:"order,omitempty"`

	// Azure resource type supported by the gallery.
	ResourceType *string `json:"resourceType,omitempty"`

	// Type of workbook supported by the workbook template.
	Type *string `json:"type,omitempty"`
}

// WorkbookTemplateLocalizedGallery - Localized template data and gallery information.
type WorkbookTemplateLocalizedGallery struct {
	// Workbook galleries supported by the template.
	Galleries []*WorkbookTemplateGallery `json:"galleries,omitempty"`

	// Valid JSON object containing workbook template payload.
	TemplateData interface{} `json:"templateData,omitempty"`
}

// WorkbookTemplateProperties - Properties that contain a workbook template.
type WorkbookTemplateProperties struct {
	// REQUIRED; Workbook galleries supported by the template.
	Galleries []*WorkbookTemplateGallery `json:"galleries,omitempty"`

	// REQUIRED; Valid JSON object containing workbook template payload.
	TemplateData interface{} `json:"templateData,omitempty"`

	// Information about the author of the workbook template.
	Author *string `json:"author,omitempty"`

	// Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
	Localized map[string][]*WorkbookTemplateLocalizedGallery `json:"localized,omitempty"`

	// Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
	Priority *int32 `json:"priority,omitempty"`
}

// WorkbookTemplateResource - An azure resource object
type WorkbookTemplateResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkbookTemplateUpdateParameters - The parameters that can be provided when updating workbook template.
type WorkbookTemplateUpdateParameters struct {
	// Metadata describing a workbook for an Azure resource.
	Properties *WorkbookTemplateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// WorkbookTemplatesClientCreateOrUpdateOptions contains the optional parameters for the WorkbookTemplatesClient.CreateOrUpdate
// method.
type WorkbookTemplatesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// WorkbookTemplatesClientDeleteOptions contains the optional parameters for the WorkbookTemplatesClient.Delete method.
type WorkbookTemplatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkbookTemplatesClientGetOptions contains the optional parameters for the WorkbookTemplatesClient.Get method.
type WorkbookTemplatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkbookTemplatesClientListByResourceGroupOptions contains the optional parameters for the WorkbookTemplatesClient.ListByResourceGroup
// method.
type WorkbookTemplatesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkbookTemplatesClientUpdateOptions contains the optional parameters for the WorkbookTemplatesClient.Update method.
type WorkbookTemplatesClientUpdateOptions struct {
	// Properties that need to be specified to patch a workbook template.
	WorkbookTemplateUpdateParameters *WorkbookTemplateUpdateParameters
}

// WorkbookTemplatesListResult - WorkbookTemplate list result.
type WorkbookTemplatesListResult struct {
	// An array of workbook templates.
	Value []*WorkbookTemplate `json:"value,omitempty"`
}

// WorkbookUpdateParameters - The parameters that can be provided when updating workbook properties properties.
type WorkbookUpdateParameters struct {
	// The kind of workbook. Only valid value is shared.
	Kind *WorkbookUpdateSharedTypeKind `json:"kind,omitempty"`

	// Metadata describing a workbook for an Azure resource.
	Properties *WorkbookPropertiesUpdateParameters `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// WorkbooksClientCreateOrUpdateOptions contains the optional parameters for the WorkbooksClient.CreateOrUpdate method.
type WorkbooksClientCreateOrUpdateOptions struct {
	// Azure Resource Id that will fetch all linked workbooks.
	SourceID *string
}

// WorkbooksClientDeleteOptions contains the optional parameters for the WorkbooksClient.Delete method.
type WorkbooksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkbooksClientGetOptions contains the optional parameters for the WorkbooksClient.Get method.
type WorkbooksClientGetOptions struct {
	// Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content
	// for workbooks.
	CanFetchContent *bool
}

// WorkbooksClientListByResourceGroupOptions contains the optional parameters for the WorkbooksClient.ListByResourceGroup
// method.
type WorkbooksClientListByResourceGroupOptions struct {
	// Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content
	// for workbooks.
	CanFetchContent *bool
	// Azure Resource Id that will fetch all linked workbooks.
	SourceID *string
	// Tags presents on each workbook returned.
	Tags []string
}

// WorkbooksClientListBySubscriptionOptions contains the optional parameters for the WorkbooksClient.ListBySubscription method.
type WorkbooksClientListBySubscriptionOptions struct {
	// Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content
	// for workbooks.
	CanFetchContent *bool
	// Tags presents on each workbook returned.
	Tags []string
}

// WorkbooksClientRevisionGetOptions contains the optional parameters for the WorkbooksClient.RevisionGet method.
type WorkbooksClientRevisionGetOptions struct {
	// placeholder for future optional parameters
}

// WorkbooksClientRevisionsListOptions contains the optional parameters for the WorkbooksClient.RevisionsList method.
type WorkbooksClientRevisionsListOptions struct {
	// placeholder for future optional parameters
}

// WorkbooksClientUpdateOptions contains the optional parameters for the WorkbooksClient.Update method.
type WorkbooksClientUpdateOptions struct {
	// Azure Resource Id that will fetch all linked workbooks.
	SourceID *string
	// Properties that need to be specified to create a new workbook.
	WorkbookUpdateParameters *WorkbookUpdateParameters
}

// WorkbooksListResult - Workbook list result.
type WorkbooksListResult struct {
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; An array of workbooks.
	Value []*Workbook `json:"value,omitempty" azure:"ro"`
}
