// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"fmt"

	"code.forgejo.org/f3/gof3/v3/f3"
)

func NewUserPath[T any](id T) Path {
	return NewPathFromString(NewUserPathString(id))
}

func NewUserPathString[T any](id T) string {
	return fmt.Sprintf("/forge/users/%v", id)
}

func NewUserReference[T any](id T) *f3.Reference {
	return f3.NewReference(NewUserPathString(id))
}
