//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384 32 '2^384 - 2^128 - 2^96 + 2^32 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: p384
//! machine_wordsize = 32 (from "32")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in
//!                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/** fiat_p384_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_p384_u1 = u8;
/** fiat_p384_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_p384_i1 = i8;
/** fiat_p384_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_p384_u2 = u8;
/** fiat_p384_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_p384_i2 = i8;

/** The type fiat_p384_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p384_montgomery_domain_field_element(pub [u32; 12]);

impl core::ops::Index<usize> for fiat_p384_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p384_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/** The type fiat_p384_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p384_non_montgomery_domain_field_element(pub [u32; 12]);

impl core::ops::Index<usize> for fiat_p384_non_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p384_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_p384_addcarryx_u32 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^32
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p384_addcarryx_u32(out1: &mut u32, out2: &mut fiat_p384_u1, arg1: fiat_p384_u1, arg2: u32, arg3: u32) {
  let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: fiat_p384_u1 = ((x1 >> 32) as fiat_p384_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p384_subborrowx_u32 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^32
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p384_subborrowx_u32(out1: &mut u32, out2: &mut fiat_p384_u1, arg1: fiat_p384_u1, arg2: u32, arg3: u32) {
  let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
  let x2: fiat_p384_i1 = ((x1 >> 32) as fiat_p384_i1);
  let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p384_i2) - (x2 as fiat_p384_i2)) as fiat_p384_u1);
}

/// The function fiat_p384_mulx_u32 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^32
///   out2 = ⌊arg1 * arg2 / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p384_mulx_u32(out1: &mut u32, out2: &mut u32, arg1: u32, arg2: u32) {
  let x1: u64 = ((arg1 as u64) * (arg2 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: u32 = ((x1 >> 32) as u32);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p384_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p384_cmovznz_u32(out1: &mut u32, arg1: fiat_p384_u1, arg2: u32, arg3: u32) {
  let x1: fiat_p384_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_p384_i2) - (x1 as fiat_p384_i2)) as fiat_p384_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p384_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_mul(out1: &mut fiat_p384_montgomery_domain_field_element, arg1: &fiat_p384_montgomery_domain_field_element, arg2: &fiat_p384_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[8]);
  let x9: u32 = (arg1[9]);
  let x10: u32 = (arg1[10]);
  let x11: u32 = (arg1[11]);
  let x12: u32 = (arg1[0]);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p384_mulx_u32(&mut x13, &mut x14, x12, (arg2[11]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p384_mulx_u32(&mut x15, &mut x16, x12, (arg2[10]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p384_mulx_u32(&mut x17, &mut x18, x12, (arg2[9]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p384_mulx_u32(&mut x19, &mut x20, x12, (arg2[8]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p384_mulx_u32(&mut x21, &mut x22, x12, (arg2[7]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p384_mulx_u32(&mut x23, &mut x24, x12, (arg2[6]));
  let mut x25: u32 = 0;
  let mut x26: u32 = 0;
  fiat_p384_mulx_u32(&mut x25, &mut x26, x12, (arg2[5]));
  let mut x27: u32 = 0;
  let mut x28: u32 = 0;
  fiat_p384_mulx_u32(&mut x27, &mut x28, x12, (arg2[4]));
  let mut x29: u32 = 0;
  let mut x30: u32 = 0;
  fiat_p384_mulx_u32(&mut x29, &mut x30, x12, (arg2[3]));
  let mut x31: u32 = 0;
  let mut x32: u32 = 0;
  fiat_p384_mulx_u32(&mut x31, &mut x32, x12, (arg2[2]));
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p384_mulx_u32(&mut x33, &mut x34, x12, (arg2[1]));
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p384_mulx_u32(&mut x35, &mut x36, x12, (arg2[0]));
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x37, &mut x38, 0x0, x36, x33);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x39, &mut x40, x38, x34, x31);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x41, &mut x42, x40, x32, x29);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x43, &mut x44, x42, x30, x27);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x45, &mut x46, x44, x28, x25);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x47, &mut x48, x46, x26, x23);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x49, &mut x50, x48, x24, x21);
  let mut x51: u32 = 0;
  let mut x52: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x51, &mut x52, x50, x22, x19);
  let mut x53: u32 = 0;
  let mut x54: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x53, &mut x54, x52, x20, x17);
  let mut x55: u32 = 0;
  let mut x56: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x55, &mut x56, x54, x18, x15);
  let mut x57: u32 = 0;
  let mut x58: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x57, &mut x58, x56, x16, x13);
  let x59: u32 = ((x58 as u32) + x14);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_p384_mulx_u32(&mut x60, &mut x61, x35, 0xffffffff);
  let mut x62: u32 = 0;
  let mut x63: u32 = 0;
  fiat_p384_mulx_u32(&mut x62, &mut x63, x35, 0xffffffff);
  let mut x64: u32 = 0;
  let mut x65: u32 = 0;
  fiat_p384_mulx_u32(&mut x64, &mut x65, x35, 0xffffffff);
  let mut x66: u32 = 0;
  let mut x67: u32 = 0;
  fiat_p384_mulx_u32(&mut x66, &mut x67, x35, 0xffffffff);
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_p384_mulx_u32(&mut x68, &mut x69, x35, 0xffffffff);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_p384_mulx_u32(&mut x70, &mut x71, x35, 0xffffffff);
  let mut x72: u32 = 0;
  let mut x73: u32 = 0;
  fiat_p384_mulx_u32(&mut x72, &mut x73, x35, 0xffffffff);
  let mut x74: u32 = 0;
  let mut x75: u32 = 0;
  fiat_p384_mulx_u32(&mut x74, &mut x75, x35, 0xfffffffe);
  let mut x76: u32 = 0;
  let mut x77: u32 = 0;
  fiat_p384_mulx_u32(&mut x76, &mut x77, x35, 0xffffffff);
  let mut x78: u32 = 0;
  let mut x79: u32 = 0;
  fiat_p384_mulx_u32(&mut x78, &mut x79, x35, 0xffffffff);
  let mut x80: u32 = 0;
  let mut x81: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x80, &mut x81, 0x0, x77, x74);
  let mut x82: u32 = 0;
  let mut x83: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x82, &mut x83, x81, x75, x72);
  let mut x84: u32 = 0;
  let mut x85: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x84, &mut x85, x83, x73, x70);
  let mut x86: u32 = 0;
  let mut x87: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x86, &mut x87, x85, x71, x68);
  let mut x88: u32 = 0;
  let mut x89: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x88, &mut x89, x87, x69, x66);
  let mut x90: u32 = 0;
  let mut x91: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x90, &mut x91, x89, x67, x64);
  let mut x92: u32 = 0;
  let mut x93: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x92, &mut x93, x91, x65, x62);
  let mut x94: u32 = 0;
  let mut x95: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x94, &mut x95, x93, x63, x60);
  let x96: u32 = ((x95 as u32) + x61);
  let mut x97: u32 = 0;
  let mut x98: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x97, &mut x98, 0x0, x35, x78);
  let mut x99: u32 = 0;
  let mut x100: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x99, &mut x100, x98, x37, x79);
  let mut x101: u32 = 0;
  let mut x102: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x101, &mut x102, x100, x39, (0x0 as u32));
  let mut x103: u32 = 0;
  let mut x104: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x103, &mut x104, x102, x41, x76);
  let mut x105: u32 = 0;
  let mut x106: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x105, &mut x106, x104, x43, x80);
  let mut x107: u32 = 0;
  let mut x108: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x107, &mut x108, x106, x45, x82);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x109, &mut x110, x108, x47, x84);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x111, &mut x112, x110, x49, x86);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x113, &mut x114, x112, x51, x88);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x115, &mut x116, x114, x53, x90);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x117, &mut x118, x116, x55, x92);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x119, &mut x120, x118, x57, x94);
  let mut x121: u32 = 0;
  let mut x122: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x121, &mut x122, x120, x59, x96);
  let mut x123: u32 = 0;
  let mut x124: u32 = 0;
  fiat_p384_mulx_u32(&mut x123, &mut x124, x1, (arg2[11]));
  let mut x125: u32 = 0;
  let mut x126: u32 = 0;
  fiat_p384_mulx_u32(&mut x125, &mut x126, x1, (arg2[10]));
  let mut x127: u32 = 0;
  let mut x128: u32 = 0;
  fiat_p384_mulx_u32(&mut x127, &mut x128, x1, (arg2[9]));
  let mut x129: u32 = 0;
  let mut x130: u32 = 0;
  fiat_p384_mulx_u32(&mut x129, &mut x130, x1, (arg2[8]));
  let mut x131: u32 = 0;
  let mut x132: u32 = 0;
  fiat_p384_mulx_u32(&mut x131, &mut x132, x1, (arg2[7]));
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_p384_mulx_u32(&mut x133, &mut x134, x1, (arg2[6]));
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p384_mulx_u32(&mut x135, &mut x136, x1, (arg2[5]));
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_p384_mulx_u32(&mut x137, &mut x138, x1, (arg2[4]));
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_p384_mulx_u32(&mut x139, &mut x140, x1, (arg2[3]));
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_p384_mulx_u32(&mut x141, &mut x142, x1, (arg2[2]));
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_p384_mulx_u32(&mut x143, &mut x144, x1, (arg2[1]));
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_p384_mulx_u32(&mut x145, &mut x146, x1, (arg2[0]));
  let mut x147: u32 = 0;
  let mut x148: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x147, &mut x148, 0x0, x146, x143);
  let mut x149: u32 = 0;
  let mut x150: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x149, &mut x150, x148, x144, x141);
  let mut x151: u32 = 0;
  let mut x152: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x151, &mut x152, x150, x142, x139);
  let mut x153: u32 = 0;
  let mut x154: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x153, &mut x154, x152, x140, x137);
  let mut x155: u32 = 0;
  let mut x156: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x155, &mut x156, x154, x138, x135);
  let mut x157: u32 = 0;
  let mut x158: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x157, &mut x158, x156, x136, x133);
  let mut x159: u32 = 0;
  let mut x160: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x159, &mut x160, x158, x134, x131);
  let mut x161: u32 = 0;
  let mut x162: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x161, &mut x162, x160, x132, x129);
  let mut x163: u32 = 0;
  let mut x164: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x163, &mut x164, x162, x130, x127);
  let mut x165: u32 = 0;
  let mut x166: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x165, &mut x166, x164, x128, x125);
  let mut x167: u32 = 0;
  let mut x168: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x167, &mut x168, x166, x126, x123);
  let x169: u32 = ((x168 as u32) + x124);
  let mut x170: u32 = 0;
  let mut x171: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x170, &mut x171, 0x0, x99, x145);
  let mut x172: u32 = 0;
  let mut x173: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x172, &mut x173, x171, x101, x147);
  let mut x174: u32 = 0;
  let mut x175: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x174, &mut x175, x173, x103, x149);
  let mut x176: u32 = 0;
  let mut x177: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x176, &mut x177, x175, x105, x151);
  let mut x178: u32 = 0;
  let mut x179: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x178, &mut x179, x177, x107, x153);
  let mut x180: u32 = 0;
  let mut x181: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x180, &mut x181, x179, x109, x155);
  let mut x182: u32 = 0;
  let mut x183: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x182, &mut x183, x181, x111, x157);
  let mut x184: u32 = 0;
  let mut x185: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x184, &mut x185, x183, x113, x159);
  let mut x186: u32 = 0;
  let mut x187: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x186, &mut x187, x185, x115, x161);
  let mut x188: u32 = 0;
  let mut x189: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x188, &mut x189, x187, x117, x163);
  let mut x190: u32 = 0;
  let mut x191: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x190, &mut x191, x189, x119, x165);
  let mut x192: u32 = 0;
  let mut x193: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x192, &mut x193, x191, x121, x167);
  let mut x194: u32 = 0;
  let mut x195: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x194, &mut x195, x193, (x122 as u32), x169);
  let mut x196: u32 = 0;
  let mut x197: u32 = 0;
  fiat_p384_mulx_u32(&mut x196, &mut x197, x170, 0xffffffff);
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_p384_mulx_u32(&mut x198, &mut x199, x170, 0xffffffff);
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_p384_mulx_u32(&mut x200, &mut x201, x170, 0xffffffff);
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_p384_mulx_u32(&mut x202, &mut x203, x170, 0xffffffff);
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_p384_mulx_u32(&mut x204, &mut x205, x170, 0xffffffff);
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_p384_mulx_u32(&mut x206, &mut x207, x170, 0xffffffff);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_p384_mulx_u32(&mut x208, &mut x209, x170, 0xffffffff);
  let mut x210: u32 = 0;
  let mut x211: u32 = 0;
  fiat_p384_mulx_u32(&mut x210, &mut x211, x170, 0xfffffffe);
  let mut x212: u32 = 0;
  let mut x213: u32 = 0;
  fiat_p384_mulx_u32(&mut x212, &mut x213, x170, 0xffffffff);
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_p384_mulx_u32(&mut x214, &mut x215, x170, 0xffffffff);
  let mut x216: u32 = 0;
  let mut x217: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x216, &mut x217, 0x0, x213, x210);
  let mut x218: u32 = 0;
  let mut x219: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x218, &mut x219, x217, x211, x208);
  let mut x220: u32 = 0;
  let mut x221: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x220, &mut x221, x219, x209, x206);
  let mut x222: u32 = 0;
  let mut x223: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x222, &mut x223, x221, x207, x204);
  let mut x224: u32 = 0;
  let mut x225: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x224, &mut x225, x223, x205, x202);
  let mut x226: u32 = 0;
  let mut x227: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x226, &mut x227, x225, x203, x200);
  let mut x228: u32 = 0;
  let mut x229: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x228, &mut x229, x227, x201, x198);
  let mut x230: u32 = 0;
  let mut x231: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x230, &mut x231, x229, x199, x196);
  let x232: u32 = ((x231 as u32) + x197);
  let mut x233: u32 = 0;
  let mut x234: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x233, &mut x234, 0x0, x170, x214);
  let mut x235: u32 = 0;
  let mut x236: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x235, &mut x236, x234, x172, x215);
  let mut x237: u32 = 0;
  let mut x238: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x237, &mut x238, x236, x174, (0x0 as u32));
  let mut x239: u32 = 0;
  let mut x240: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x239, &mut x240, x238, x176, x212);
  let mut x241: u32 = 0;
  let mut x242: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x241, &mut x242, x240, x178, x216);
  let mut x243: u32 = 0;
  let mut x244: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x243, &mut x244, x242, x180, x218);
  let mut x245: u32 = 0;
  let mut x246: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x245, &mut x246, x244, x182, x220);
  let mut x247: u32 = 0;
  let mut x248: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x247, &mut x248, x246, x184, x222);
  let mut x249: u32 = 0;
  let mut x250: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x249, &mut x250, x248, x186, x224);
  let mut x251: u32 = 0;
  let mut x252: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x251, &mut x252, x250, x188, x226);
  let mut x253: u32 = 0;
  let mut x254: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x253, &mut x254, x252, x190, x228);
  let mut x255: u32 = 0;
  let mut x256: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x255, &mut x256, x254, x192, x230);
  let mut x257: u32 = 0;
  let mut x258: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x257, &mut x258, x256, x194, x232);
  let x259: u32 = ((x258 as u32) + (x195 as u32));
  let mut x260: u32 = 0;
  let mut x261: u32 = 0;
  fiat_p384_mulx_u32(&mut x260, &mut x261, x2, (arg2[11]));
  let mut x262: u32 = 0;
  let mut x263: u32 = 0;
  fiat_p384_mulx_u32(&mut x262, &mut x263, x2, (arg2[10]));
  let mut x264: u32 = 0;
  let mut x265: u32 = 0;
  fiat_p384_mulx_u32(&mut x264, &mut x265, x2, (arg2[9]));
  let mut x266: u32 = 0;
  let mut x267: u32 = 0;
  fiat_p384_mulx_u32(&mut x266, &mut x267, x2, (arg2[8]));
  let mut x268: u32 = 0;
  let mut x269: u32 = 0;
  fiat_p384_mulx_u32(&mut x268, &mut x269, x2, (arg2[7]));
  let mut x270: u32 = 0;
  let mut x271: u32 = 0;
  fiat_p384_mulx_u32(&mut x270, &mut x271, x2, (arg2[6]));
  let mut x272: u32 = 0;
  let mut x273: u32 = 0;
  fiat_p384_mulx_u32(&mut x272, &mut x273, x2, (arg2[5]));
  let mut x274: u32 = 0;
  let mut x275: u32 = 0;
  fiat_p384_mulx_u32(&mut x274, &mut x275, x2, (arg2[4]));
  let mut x276: u32 = 0;
  let mut x277: u32 = 0;
  fiat_p384_mulx_u32(&mut x276, &mut x277, x2, (arg2[3]));
  let mut x278: u32 = 0;
  let mut x279: u32 = 0;
  fiat_p384_mulx_u32(&mut x278, &mut x279, x2, (arg2[2]));
  let mut x280: u32 = 0;
  let mut x281: u32 = 0;
  fiat_p384_mulx_u32(&mut x280, &mut x281, x2, (arg2[1]));
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_p384_mulx_u32(&mut x282, &mut x283, x2, (arg2[0]));
  let mut x284: u32 = 0;
  let mut x285: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x284, &mut x285, 0x0, x283, x280);
  let mut x286: u32 = 0;
  let mut x287: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x286, &mut x287, x285, x281, x278);
  let mut x288: u32 = 0;
  let mut x289: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x288, &mut x289, x287, x279, x276);
  let mut x290: u32 = 0;
  let mut x291: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x290, &mut x291, x289, x277, x274);
  let mut x292: u32 = 0;
  let mut x293: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x292, &mut x293, x291, x275, x272);
  let mut x294: u32 = 0;
  let mut x295: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x294, &mut x295, x293, x273, x270);
  let mut x296: u32 = 0;
  let mut x297: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x296, &mut x297, x295, x271, x268);
  let mut x298: u32 = 0;
  let mut x299: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x298, &mut x299, x297, x269, x266);
  let mut x300: u32 = 0;
  let mut x301: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x300, &mut x301, x299, x267, x264);
  let mut x302: u32 = 0;
  let mut x303: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x302, &mut x303, x301, x265, x262);
  let mut x304: u32 = 0;
  let mut x305: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x304, &mut x305, x303, x263, x260);
  let x306: u32 = ((x305 as u32) + x261);
  let mut x307: u32 = 0;
  let mut x308: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x307, &mut x308, 0x0, x235, x282);
  let mut x309: u32 = 0;
  let mut x310: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x309, &mut x310, x308, x237, x284);
  let mut x311: u32 = 0;
  let mut x312: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x311, &mut x312, x310, x239, x286);
  let mut x313: u32 = 0;
  let mut x314: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x313, &mut x314, x312, x241, x288);
  let mut x315: u32 = 0;
  let mut x316: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x315, &mut x316, x314, x243, x290);
  let mut x317: u32 = 0;
  let mut x318: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x317, &mut x318, x316, x245, x292);
  let mut x319: u32 = 0;
  let mut x320: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x319, &mut x320, x318, x247, x294);
  let mut x321: u32 = 0;
  let mut x322: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x321, &mut x322, x320, x249, x296);
  let mut x323: u32 = 0;
  let mut x324: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x323, &mut x324, x322, x251, x298);
  let mut x325: u32 = 0;
  let mut x326: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x325, &mut x326, x324, x253, x300);
  let mut x327: u32 = 0;
  let mut x328: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x327, &mut x328, x326, x255, x302);
  let mut x329: u32 = 0;
  let mut x330: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x329, &mut x330, x328, x257, x304);
  let mut x331: u32 = 0;
  let mut x332: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x331, &mut x332, x330, x259, x306);
  let mut x333: u32 = 0;
  let mut x334: u32 = 0;
  fiat_p384_mulx_u32(&mut x333, &mut x334, x307, 0xffffffff);
  let mut x335: u32 = 0;
  let mut x336: u32 = 0;
  fiat_p384_mulx_u32(&mut x335, &mut x336, x307, 0xffffffff);
  let mut x337: u32 = 0;
  let mut x338: u32 = 0;
  fiat_p384_mulx_u32(&mut x337, &mut x338, x307, 0xffffffff);
  let mut x339: u32 = 0;
  let mut x340: u32 = 0;
  fiat_p384_mulx_u32(&mut x339, &mut x340, x307, 0xffffffff);
  let mut x341: u32 = 0;
  let mut x342: u32 = 0;
  fiat_p384_mulx_u32(&mut x341, &mut x342, x307, 0xffffffff);
  let mut x343: u32 = 0;
  let mut x344: u32 = 0;
  fiat_p384_mulx_u32(&mut x343, &mut x344, x307, 0xffffffff);
  let mut x345: u32 = 0;
  let mut x346: u32 = 0;
  fiat_p384_mulx_u32(&mut x345, &mut x346, x307, 0xffffffff);
  let mut x347: u32 = 0;
  let mut x348: u32 = 0;
  fiat_p384_mulx_u32(&mut x347, &mut x348, x307, 0xfffffffe);
  let mut x349: u32 = 0;
  let mut x350: u32 = 0;
  fiat_p384_mulx_u32(&mut x349, &mut x350, x307, 0xffffffff);
  let mut x351: u32 = 0;
  let mut x352: u32 = 0;
  fiat_p384_mulx_u32(&mut x351, &mut x352, x307, 0xffffffff);
  let mut x353: u32 = 0;
  let mut x354: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x353, &mut x354, 0x0, x350, x347);
  let mut x355: u32 = 0;
  let mut x356: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x355, &mut x356, x354, x348, x345);
  let mut x357: u32 = 0;
  let mut x358: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x357, &mut x358, x356, x346, x343);
  let mut x359: u32 = 0;
  let mut x360: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x359, &mut x360, x358, x344, x341);
  let mut x361: u32 = 0;
  let mut x362: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x361, &mut x362, x360, x342, x339);
  let mut x363: u32 = 0;
  let mut x364: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x363, &mut x364, x362, x340, x337);
  let mut x365: u32 = 0;
  let mut x366: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x365, &mut x366, x364, x338, x335);
  let mut x367: u32 = 0;
  let mut x368: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x367, &mut x368, x366, x336, x333);
  let x369: u32 = ((x368 as u32) + x334);
  let mut x370: u32 = 0;
  let mut x371: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x370, &mut x371, 0x0, x307, x351);
  let mut x372: u32 = 0;
  let mut x373: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x372, &mut x373, x371, x309, x352);
  let mut x374: u32 = 0;
  let mut x375: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x374, &mut x375, x373, x311, (0x0 as u32));
  let mut x376: u32 = 0;
  let mut x377: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x376, &mut x377, x375, x313, x349);
  let mut x378: u32 = 0;
  let mut x379: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x378, &mut x379, x377, x315, x353);
  let mut x380: u32 = 0;
  let mut x381: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x380, &mut x381, x379, x317, x355);
  let mut x382: u32 = 0;
  let mut x383: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x382, &mut x383, x381, x319, x357);
  let mut x384: u32 = 0;
  let mut x385: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x384, &mut x385, x383, x321, x359);
  let mut x386: u32 = 0;
  let mut x387: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x386, &mut x387, x385, x323, x361);
  let mut x388: u32 = 0;
  let mut x389: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x388, &mut x389, x387, x325, x363);
  let mut x390: u32 = 0;
  let mut x391: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x390, &mut x391, x389, x327, x365);
  let mut x392: u32 = 0;
  let mut x393: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x392, &mut x393, x391, x329, x367);
  let mut x394: u32 = 0;
  let mut x395: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x394, &mut x395, x393, x331, x369);
  let x396: u32 = ((x395 as u32) + (x332 as u32));
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_p384_mulx_u32(&mut x397, &mut x398, x3, (arg2[11]));
  let mut x399: u32 = 0;
  let mut x400: u32 = 0;
  fiat_p384_mulx_u32(&mut x399, &mut x400, x3, (arg2[10]));
  let mut x401: u32 = 0;
  let mut x402: u32 = 0;
  fiat_p384_mulx_u32(&mut x401, &mut x402, x3, (arg2[9]));
  let mut x403: u32 = 0;
  let mut x404: u32 = 0;
  fiat_p384_mulx_u32(&mut x403, &mut x404, x3, (arg2[8]));
  let mut x405: u32 = 0;
  let mut x406: u32 = 0;
  fiat_p384_mulx_u32(&mut x405, &mut x406, x3, (arg2[7]));
  let mut x407: u32 = 0;
  let mut x408: u32 = 0;
  fiat_p384_mulx_u32(&mut x407, &mut x408, x3, (arg2[6]));
  let mut x409: u32 = 0;
  let mut x410: u32 = 0;
  fiat_p384_mulx_u32(&mut x409, &mut x410, x3, (arg2[5]));
  let mut x411: u32 = 0;
  let mut x412: u32 = 0;
  fiat_p384_mulx_u32(&mut x411, &mut x412, x3, (arg2[4]));
  let mut x413: u32 = 0;
  let mut x414: u32 = 0;
  fiat_p384_mulx_u32(&mut x413, &mut x414, x3, (arg2[3]));
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_p384_mulx_u32(&mut x415, &mut x416, x3, (arg2[2]));
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_p384_mulx_u32(&mut x417, &mut x418, x3, (arg2[1]));
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_p384_mulx_u32(&mut x419, &mut x420, x3, (arg2[0]));
  let mut x421: u32 = 0;
  let mut x422: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x421, &mut x422, 0x0, x420, x417);
  let mut x423: u32 = 0;
  let mut x424: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x423, &mut x424, x422, x418, x415);
  let mut x425: u32 = 0;
  let mut x426: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x425, &mut x426, x424, x416, x413);
  let mut x427: u32 = 0;
  let mut x428: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x427, &mut x428, x426, x414, x411);
  let mut x429: u32 = 0;
  let mut x430: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x429, &mut x430, x428, x412, x409);
  let mut x431: u32 = 0;
  let mut x432: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x431, &mut x432, x430, x410, x407);
  let mut x433: u32 = 0;
  let mut x434: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x433, &mut x434, x432, x408, x405);
  let mut x435: u32 = 0;
  let mut x436: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x435, &mut x436, x434, x406, x403);
  let mut x437: u32 = 0;
  let mut x438: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x437, &mut x438, x436, x404, x401);
  let mut x439: u32 = 0;
  let mut x440: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x439, &mut x440, x438, x402, x399);
  let mut x441: u32 = 0;
  let mut x442: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x441, &mut x442, x440, x400, x397);
  let x443: u32 = ((x442 as u32) + x398);
  let mut x444: u32 = 0;
  let mut x445: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x444, &mut x445, 0x0, x372, x419);
  let mut x446: u32 = 0;
  let mut x447: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x446, &mut x447, x445, x374, x421);
  let mut x448: u32 = 0;
  let mut x449: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x448, &mut x449, x447, x376, x423);
  let mut x450: u32 = 0;
  let mut x451: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x450, &mut x451, x449, x378, x425);
  let mut x452: u32 = 0;
  let mut x453: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x452, &mut x453, x451, x380, x427);
  let mut x454: u32 = 0;
  let mut x455: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x454, &mut x455, x453, x382, x429);
  let mut x456: u32 = 0;
  let mut x457: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x456, &mut x457, x455, x384, x431);
  let mut x458: u32 = 0;
  let mut x459: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x458, &mut x459, x457, x386, x433);
  let mut x460: u32 = 0;
  let mut x461: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x460, &mut x461, x459, x388, x435);
  let mut x462: u32 = 0;
  let mut x463: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x462, &mut x463, x461, x390, x437);
  let mut x464: u32 = 0;
  let mut x465: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x464, &mut x465, x463, x392, x439);
  let mut x466: u32 = 0;
  let mut x467: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x466, &mut x467, x465, x394, x441);
  let mut x468: u32 = 0;
  let mut x469: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x468, &mut x469, x467, x396, x443);
  let mut x470: u32 = 0;
  let mut x471: u32 = 0;
  fiat_p384_mulx_u32(&mut x470, &mut x471, x444, 0xffffffff);
  let mut x472: u32 = 0;
  let mut x473: u32 = 0;
  fiat_p384_mulx_u32(&mut x472, &mut x473, x444, 0xffffffff);
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_p384_mulx_u32(&mut x474, &mut x475, x444, 0xffffffff);
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_p384_mulx_u32(&mut x476, &mut x477, x444, 0xffffffff);
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_p384_mulx_u32(&mut x478, &mut x479, x444, 0xffffffff);
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_p384_mulx_u32(&mut x480, &mut x481, x444, 0xffffffff);
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_p384_mulx_u32(&mut x482, &mut x483, x444, 0xffffffff);
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_p384_mulx_u32(&mut x484, &mut x485, x444, 0xfffffffe);
  let mut x486: u32 = 0;
  let mut x487: u32 = 0;
  fiat_p384_mulx_u32(&mut x486, &mut x487, x444, 0xffffffff);
  let mut x488: u32 = 0;
  let mut x489: u32 = 0;
  fiat_p384_mulx_u32(&mut x488, &mut x489, x444, 0xffffffff);
  let mut x490: u32 = 0;
  let mut x491: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x490, &mut x491, 0x0, x487, x484);
  let mut x492: u32 = 0;
  let mut x493: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x492, &mut x493, x491, x485, x482);
  let mut x494: u32 = 0;
  let mut x495: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x494, &mut x495, x493, x483, x480);
  let mut x496: u32 = 0;
  let mut x497: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x496, &mut x497, x495, x481, x478);
  let mut x498: u32 = 0;
  let mut x499: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x498, &mut x499, x497, x479, x476);
  let mut x500: u32 = 0;
  let mut x501: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x500, &mut x501, x499, x477, x474);
  let mut x502: u32 = 0;
  let mut x503: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x502, &mut x503, x501, x475, x472);
  let mut x504: u32 = 0;
  let mut x505: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x504, &mut x505, x503, x473, x470);
  let x506: u32 = ((x505 as u32) + x471);
  let mut x507: u32 = 0;
  let mut x508: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x507, &mut x508, 0x0, x444, x488);
  let mut x509: u32 = 0;
  let mut x510: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x509, &mut x510, x508, x446, x489);
  let mut x511: u32 = 0;
  let mut x512: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x511, &mut x512, x510, x448, (0x0 as u32));
  let mut x513: u32 = 0;
  let mut x514: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x513, &mut x514, x512, x450, x486);
  let mut x515: u32 = 0;
  let mut x516: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x515, &mut x516, x514, x452, x490);
  let mut x517: u32 = 0;
  let mut x518: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x517, &mut x518, x516, x454, x492);
  let mut x519: u32 = 0;
  let mut x520: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x519, &mut x520, x518, x456, x494);
  let mut x521: u32 = 0;
  let mut x522: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x521, &mut x522, x520, x458, x496);
  let mut x523: u32 = 0;
  let mut x524: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x523, &mut x524, x522, x460, x498);
  let mut x525: u32 = 0;
  let mut x526: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x525, &mut x526, x524, x462, x500);
  let mut x527: u32 = 0;
  let mut x528: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x527, &mut x528, x526, x464, x502);
  let mut x529: u32 = 0;
  let mut x530: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x529, &mut x530, x528, x466, x504);
  let mut x531: u32 = 0;
  let mut x532: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x531, &mut x532, x530, x468, x506);
  let x533: u32 = ((x532 as u32) + (x469 as u32));
  let mut x534: u32 = 0;
  let mut x535: u32 = 0;
  fiat_p384_mulx_u32(&mut x534, &mut x535, x4, (arg2[11]));
  let mut x536: u32 = 0;
  let mut x537: u32 = 0;
  fiat_p384_mulx_u32(&mut x536, &mut x537, x4, (arg2[10]));
  let mut x538: u32 = 0;
  let mut x539: u32 = 0;
  fiat_p384_mulx_u32(&mut x538, &mut x539, x4, (arg2[9]));
  let mut x540: u32 = 0;
  let mut x541: u32 = 0;
  fiat_p384_mulx_u32(&mut x540, &mut x541, x4, (arg2[8]));
  let mut x542: u32 = 0;
  let mut x543: u32 = 0;
  fiat_p384_mulx_u32(&mut x542, &mut x543, x4, (arg2[7]));
  let mut x544: u32 = 0;
  let mut x545: u32 = 0;
  fiat_p384_mulx_u32(&mut x544, &mut x545, x4, (arg2[6]));
  let mut x546: u32 = 0;
  let mut x547: u32 = 0;
  fiat_p384_mulx_u32(&mut x546, &mut x547, x4, (arg2[5]));
  let mut x548: u32 = 0;
  let mut x549: u32 = 0;
  fiat_p384_mulx_u32(&mut x548, &mut x549, x4, (arg2[4]));
  let mut x550: u32 = 0;
  let mut x551: u32 = 0;
  fiat_p384_mulx_u32(&mut x550, &mut x551, x4, (arg2[3]));
  let mut x552: u32 = 0;
  let mut x553: u32 = 0;
  fiat_p384_mulx_u32(&mut x552, &mut x553, x4, (arg2[2]));
  let mut x554: u32 = 0;
  let mut x555: u32 = 0;
  fiat_p384_mulx_u32(&mut x554, &mut x555, x4, (arg2[1]));
  let mut x556: u32 = 0;
  let mut x557: u32 = 0;
  fiat_p384_mulx_u32(&mut x556, &mut x557, x4, (arg2[0]));
  let mut x558: u32 = 0;
  let mut x559: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x558, &mut x559, 0x0, x557, x554);
  let mut x560: u32 = 0;
  let mut x561: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x560, &mut x561, x559, x555, x552);
  let mut x562: u32 = 0;
  let mut x563: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x562, &mut x563, x561, x553, x550);
  let mut x564: u32 = 0;
  let mut x565: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x564, &mut x565, x563, x551, x548);
  let mut x566: u32 = 0;
  let mut x567: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x566, &mut x567, x565, x549, x546);
  let mut x568: u32 = 0;
  let mut x569: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x568, &mut x569, x567, x547, x544);
  let mut x570: u32 = 0;
  let mut x571: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x570, &mut x571, x569, x545, x542);
  let mut x572: u32 = 0;
  let mut x573: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x572, &mut x573, x571, x543, x540);
  let mut x574: u32 = 0;
  let mut x575: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x574, &mut x575, x573, x541, x538);
  let mut x576: u32 = 0;
  let mut x577: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x576, &mut x577, x575, x539, x536);
  let mut x578: u32 = 0;
  let mut x579: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x578, &mut x579, x577, x537, x534);
  let x580: u32 = ((x579 as u32) + x535);
  let mut x581: u32 = 0;
  let mut x582: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x581, &mut x582, 0x0, x509, x556);
  let mut x583: u32 = 0;
  let mut x584: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x583, &mut x584, x582, x511, x558);
  let mut x585: u32 = 0;
  let mut x586: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x585, &mut x586, x584, x513, x560);
  let mut x587: u32 = 0;
  let mut x588: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x587, &mut x588, x586, x515, x562);
  let mut x589: u32 = 0;
  let mut x590: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x589, &mut x590, x588, x517, x564);
  let mut x591: u32 = 0;
  let mut x592: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x591, &mut x592, x590, x519, x566);
  let mut x593: u32 = 0;
  let mut x594: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x593, &mut x594, x592, x521, x568);
  let mut x595: u32 = 0;
  let mut x596: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x595, &mut x596, x594, x523, x570);
  let mut x597: u32 = 0;
  let mut x598: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x597, &mut x598, x596, x525, x572);
  let mut x599: u32 = 0;
  let mut x600: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x599, &mut x600, x598, x527, x574);
  let mut x601: u32 = 0;
  let mut x602: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x601, &mut x602, x600, x529, x576);
  let mut x603: u32 = 0;
  let mut x604: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x603, &mut x604, x602, x531, x578);
  let mut x605: u32 = 0;
  let mut x606: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x605, &mut x606, x604, x533, x580);
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_p384_mulx_u32(&mut x607, &mut x608, x581, 0xffffffff);
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_p384_mulx_u32(&mut x609, &mut x610, x581, 0xffffffff);
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_p384_mulx_u32(&mut x611, &mut x612, x581, 0xffffffff);
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_p384_mulx_u32(&mut x613, &mut x614, x581, 0xffffffff);
  let mut x615: u32 = 0;
  let mut x616: u32 = 0;
  fiat_p384_mulx_u32(&mut x615, &mut x616, x581, 0xffffffff);
  let mut x617: u32 = 0;
  let mut x618: u32 = 0;
  fiat_p384_mulx_u32(&mut x617, &mut x618, x581, 0xffffffff);
  let mut x619: u32 = 0;
  let mut x620: u32 = 0;
  fiat_p384_mulx_u32(&mut x619, &mut x620, x581, 0xffffffff);
  let mut x621: u32 = 0;
  let mut x622: u32 = 0;
  fiat_p384_mulx_u32(&mut x621, &mut x622, x581, 0xfffffffe);
  let mut x623: u32 = 0;
  let mut x624: u32 = 0;
  fiat_p384_mulx_u32(&mut x623, &mut x624, x581, 0xffffffff);
  let mut x625: u32 = 0;
  let mut x626: u32 = 0;
  fiat_p384_mulx_u32(&mut x625, &mut x626, x581, 0xffffffff);
  let mut x627: u32 = 0;
  let mut x628: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x627, &mut x628, 0x0, x624, x621);
  let mut x629: u32 = 0;
  let mut x630: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x629, &mut x630, x628, x622, x619);
  let mut x631: u32 = 0;
  let mut x632: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x631, &mut x632, x630, x620, x617);
  let mut x633: u32 = 0;
  let mut x634: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x633, &mut x634, x632, x618, x615);
  let mut x635: u32 = 0;
  let mut x636: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x635, &mut x636, x634, x616, x613);
  let mut x637: u32 = 0;
  let mut x638: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x637, &mut x638, x636, x614, x611);
  let mut x639: u32 = 0;
  let mut x640: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x639, &mut x640, x638, x612, x609);
  let mut x641: u32 = 0;
  let mut x642: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x641, &mut x642, x640, x610, x607);
  let x643: u32 = ((x642 as u32) + x608);
  let mut x644: u32 = 0;
  let mut x645: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x644, &mut x645, 0x0, x581, x625);
  let mut x646: u32 = 0;
  let mut x647: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x646, &mut x647, x645, x583, x626);
  let mut x648: u32 = 0;
  let mut x649: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x648, &mut x649, x647, x585, (0x0 as u32));
  let mut x650: u32 = 0;
  let mut x651: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x650, &mut x651, x649, x587, x623);
  let mut x652: u32 = 0;
  let mut x653: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x652, &mut x653, x651, x589, x627);
  let mut x654: u32 = 0;
  let mut x655: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x654, &mut x655, x653, x591, x629);
  let mut x656: u32 = 0;
  let mut x657: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x656, &mut x657, x655, x593, x631);
  let mut x658: u32 = 0;
  let mut x659: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x658, &mut x659, x657, x595, x633);
  let mut x660: u32 = 0;
  let mut x661: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x660, &mut x661, x659, x597, x635);
  let mut x662: u32 = 0;
  let mut x663: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x662, &mut x663, x661, x599, x637);
  let mut x664: u32 = 0;
  let mut x665: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x664, &mut x665, x663, x601, x639);
  let mut x666: u32 = 0;
  let mut x667: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x666, &mut x667, x665, x603, x641);
  let mut x668: u32 = 0;
  let mut x669: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x668, &mut x669, x667, x605, x643);
  let x670: u32 = ((x669 as u32) + (x606 as u32));
  let mut x671: u32 = 0;
  let mut x672: u32 = 0;
  fiat_p384_mulx_u32(&mut x671, &mut x672, x5, (arg2[11]));
  let mut x673: u32 = 0;
  let mut x674: u32 = 0;
  fiat_p384_mulx_u32(&mut x673, &mut x674, x5, (arg2[10]));
  let mut x675: u32 = 0;
  let mut x676: u32 = 0;
  fiat_p384_mulx_u32(&mut x675, &mut x676, x5, (arg2[9]));
  let mut x677: u32 = 0;
  let mut x678: u32 = 0;
  fiat_p384_mulx_u32(&mut x677, &mut x678, x5, (arg2[8]));
  let mut x679: u32 = 0;
  let mut x680: u32 = 0;
  fiat_p384_mulx_u32(&mut x679, &mut x680, x5, (arg2[7]));
  let mut x681: u32 = 0;
  let mut x682: u32 = 0;
  fiat_p384_mulx_u32(&mut x681, &mut x682, x5, (arg2[6]));
  let mut x683: u32 = 0;
  let mut x684: u32 = 0;
  fiat_p384_mulx_u32(&mut x683, &mut x684, x5, (arg2[5]));
  let mut x685: u32 = 0;
  let mut x686: u32 = 0;
  fiat_p384_mulx_u32(&mut x685, &mut x686, x5, (arg2[4]));
  let mut x687: u32 = 0;
  let mut x688: u32 = 0;
  fiat_p384_mulx_u32(&mut x687, &mut x688, x5, (arg2[3]));
  let mut x689: u32 = 0;
  let mut x690: u32 = 0;
  fiat_p384_mulx_u32(&mut x689, &mut x690, x5, (arg2[2]));
  let mut x691: u32 = 0;
  let mut x692: u32 = 0;
  fiat_p384_mulx_u32(&mut x691, &mut x692, x5, (arg2[1]));
  let mut x693: u32 = 0;
  let mut x694: u32 = 0;
  fiat_p384_mulx_u32(&mut x693, &mut x694, x5, (arg2[0]));
  let mut x695: u32 = 0;
  let mut x696: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x695, &mut x696, 0x0, x694, x691);
  let mut x697: u32 = 0;
  let mut x698: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x697, &mut x698, x696, x692, x689);
  let mut x699: u32 = 0;
  let mut x700: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x699, &mut x700, x698, x690, x687);
  let mut x701: u32 = 0;
  let mut x702: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x701, &mut x702, x700, x688, x685);
  let mut x703: u32 = 0;
  let mut x704: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x703, &mut x704, x702, x686, x683);
  let mut x705: u32 = 0;
  let mut x706: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x705, &mut x706, x704, x684, x681);
  let mut x707: u32 = 0;
  let mut x708: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x707, &mut x708, x706, x682, x679);
  let mut x709: u32 = 0;
  let mut x710: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x709, &mut x710, x708, x680, x677);
  let mut x711: u32 = 0;
  let mut x712: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x711, &mut x712, x710, x678, x675);
  let mut x713: u32 = 0;
  let mut x714: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x713, &mut x714, x712, x676, x673);
  let mut x715: u32 = 0;
  let mut x716: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x715, &mut x716, x714, x674, x671);
  let x717: u32 = ((x716 as u32) + x672);
  let mut x718: u32 = 0;
  let mut x719: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x718, &mut x719, 0x0, x646, x693);
  let mut x720: u32 = 0;
  let mut x721: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x720, &mut x721, x719, x648, x695);
  let mut x722: u32 = 0;
  let mut x723: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x722, &mut x723, x721, x650, x697);
  let mut x724: u32 = 0;
  let mut x725: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x724, &mut x725, x723, x652, x699);
  let mut x726: u32 = 0;
  let mut x727: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x726, &mut x727, x725, x654, x701);
  let mut x728: u32 = 0;
  let mut x729: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x728, &mut x729, x727, x656, x703);
  let mut x730: u32 = 0;
  let mut x731: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x730, &mut x731, x729, x658, x705);
  let mut x732: u32 = 0;
  let mut x733: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x732, &mut x733, x731, x660, x707);
  let mut x734: u32 = 0;
  let mut x735: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x734, &mut x735, x733, x662, x709);
  let mut x736: u32 = 0;
  let mut x737: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x736, &mut x737, x735, x664, x711);
  let mut x738: u32 = 0;
  let mut x739: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x738, &mut x739, x737, x666, x713);
  let mut x740: u32 = 0;
  let mut x741: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x740, &mut x741, x739, x668, x715);
  let mut x742: u32 = 0;
  let mut x743: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x742, &mut x743, x741, x670, x717);
  let mut x744: u32 = 0;
  let mut x745: u32 = 0;
  fiat_p384_mulx_u32(&mut x744, &mut x745, x718, 0xffffffff);
  let mut x746: u32 = 0;
  let mut x747: u32 = 0;
  fiat_p384_mulx_u32(&mut x746, &mut x747, x718, 0xffffffff);
  let mut x748: u32 = 0;
  let mut x749: u32 = 0;
  fiat_p384_mulx_u32(&mut x748, &mut x749, x718, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: u32 = 0;
  fiat_p384_mulx_u32(&mut x750, &mut x751, x718, 0xffffffff);
  let mut x752: u32 = 0;
  let mut x753: u32 = 0;
  fiat_p384_mulx_u32(&mut x752, &mut x753, x718, 0xffffffff);
  let mut x754: u32 = 0;
  let mut x755: u32 = 0;
  fiat_p384_mulx_u32(&mut x754, &mut x755, x718, 0xffffffff);
  let mut x756: u32 = 0;
  let mut x757: u32 = 0;
  fiat_p384_mulx_u32(&mut x756, &mut x757, x718, 0xffffffff);
  let mut x758: u32 = 0;
  let mut x759: u32 = 0;
  fiat_p384_mulx_u32(&mut x758, &mut x759, x718, 0xfffffffe);
  let mut x760: u32 = 0;
  let mut x761: u32 = 0;
  fiat_p384_mulx_u32(&mut x760, &mut x761, x718, 0xffffffff);
  let mut x762: u32 = 0;
  let mut x763: u32 = 0;
  fiat_p384_mulx_u32(&mut x762, &mut x763, x718, 0xffffffff);
  let mut x764: u32 = 0;
  let mut x765: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x764, &mut x765, 0x0, x761, x758);
  let mut x766: u32 = 0;
  let mut x767: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x766, &mut x767, x765, x759, x756);
  let mut x768: u32 = 0;
  let mut x769: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x768, &mut x769, x767, x757, x754);
  let mut x770: u32 = 0;
  let mut x771: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x770, &mut x771, x769, x755, x752);
  let mut x772: u32 = 0;
  let mut x773: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x772, &mut x773, x771, x753, x750);
  let mut x774: u32 = 0;
  let mut x775: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x774, &mut x775, x773, x751, x748);
  let mut x776: u32 = 0;
  let mut x777: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x776, &mut x777, x775, x749, x746);
  let mut x778: u32 = 0;
  let mut x779: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x778, &mut x779, x777, x747, x744);
  let x780: u32 = ((x779 as u32) + x745);
  let mut x781: u32 = 0;
  let mut x782: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x781, &mut x782, 0x0, x718, x762);
  let mut x783: u32 = 0;
  let mut x784: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x783, &mut x784, x782, x720, x763);
  let mut x785: u32 = 0;
  let mut x786: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x785, &mut x786, x784, x722, (0x0 as u32));
  let mut x787: u32 = 0;
  let mut x788: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x787, &mut x788, x786, x724, x760);
  let mut x789: u32 = 0;
  let mut x790: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x789, &mut x790, x788, x726, x764);
  let mut x791: u32 = 0;
  let mut x792: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x791, &mut x792, x790, x728, x766);
  let mut x793: u32 = 0;
  let mut x794: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x793, &mut x794, x792, x730, x768);
  let mut x795: u32 = 0;
  let mut x796: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x795, &mut x796, x794, x732, x770);
  let mut x797: u32 = 0;
  let mut x798: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x797, &mut x798, x796, x734, x772);
  let mut x799: u32 = 0;
  let mut x800: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x799, &mut x800, x798, x736, x774);
  let mut x801: u32 = 0;
  let mut x802: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x801, &mut x802, x800, x738, x776);
  let mut x803: u32 = 0;
  let mut x804: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x803, &mut x804, x802, x740, x778);
  let mut x805: u32 = 0;
  let mut x806: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x805, &mut x806, x804, x742, x780);
  let x807: u32 = ((x806 as u32) + (x743 as u32));
  let mut x808: u32 = 0;
  let mut x809: u32 = 0;
  fiat_p384_mulx_u32(&mut x808, &mut x809, x6, (arg2[11]));
  let mut x810: u32 = 0;
  let mut x811: u32 = 0;
  fiat_p384_mulx_u32(&mut x810, &mut x811, x6, (arg2[10]));
  let mut x812: u32 = 0;
  let mut x813: u32 = 0;
  fiat_p384_mulx_u32(&mut x812, &mut x813, x6, (arg2[9]));
  let mut x814: u32 = 0;
  let mut x815: u32 = 0;
  fiat_p384_mulx_u32(&mut x814, &mut x815, x6, (arg2[8]));
  let mut x816: u32 = 0;
  let mut x817: u32 = 0;
  fiat_p384_mulx_u32(&mut x816, &mut x817, x6, (arg2[7]));
  let mut x818: u32 = 0;
  let mut x819: u32 = 0;
  fiat_p384_mulx_u32(&mut x818, &mut x819, x6, (arg2[6]));
  let mut x820: u32 = 0;
  let mut x821: u32 = 0;
  fiat_p384_mulx_u32(&mut x820, &mut x821, x6, (arg2[5]));
  let mut x822: u32 = 0;
  let mut x823: u32 = 0;
  fiat_p384_mulx_u32(&mut x822, &mut x823, x6, (arg2[4]));
  let mut x824: u32 = 0;
  let mut x825: u32 = 0;
  fiat_p384_mulx_u32(&mut x824, &mut x825, x6, (arg2[3]));
  let mut x826: u32 = 0;
  let mut x827: u32 = 0;
  fiat_p384_mulx_u32(&mut x826, &mut x827, x6, (arg2[2]));
  let mut x828: u32 = 0;
  let mut x829: u32 = 0;
  fiat_p384_mulx_u32(&mut x828, &mut x829, x6, (arg2[1]));
  let mut x830: u32 = 0;
  let mut x831: u32 = 0;
  fiat_p384_mulx_u32(&mut x830, &mut x831, x6, (arg2[0]));
  let mut x832: u32 = 0;
  let mut x833: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x832, &mut x833, 0x0, x831, x828);
  let mut x834: u32 = 0;
  let mut x835: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x834, &mut x835, x833, x829, x826);
  let mut x836: u32 = 0;
  let mut x837: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x836, &mut x837, x835, x827, x824);
  let mut x838: u32 = 0;
  let mut x839: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x838, &mut x839, x837, x825, x822);
  let mut x840: u32 = 0;
  let mut x841: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x840, &mut x841, x839, x823, x820);
  let mut x842: u32 = 0;
  let mut x843: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x842, &mut x843, x841, x821, x818);
  let mut x844: u32 = 0;
  let mut x845: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x844, &mut x845, x843, x819, x816);
  let mut x846: u32 = 0;
  let mut x847: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x846, &mut x847, x845, x817, x814);
  let mut x848: u32 = 0;
  let mut x849: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x848, &mut x849, x847, x815, x812);
  let mut x850: u32 = 0;
  let mut x851: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x850, &mut x851, x849, x813, x810);
  let mut x852: u32 = 0;
  let mut x853: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x852, &mut x853, x851, x811, x808);
  let x854: u32 = ((x853 as u32) + x809);
  let mut x855: u32 = 0;
  let mut x856: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x855, &mut x856, 0x0, x783, x830);
  let mut x857: u32 = 0;
  let mut x858: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x857, &mut x858, x856, x785, x832);
  let mut x859: u32 = 0;
  let mut x860: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x859, &mut x860, x858, x787, x834);
  let mut x861: u32 = 0;
  let mut x862: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x861, &mut x862, x860, x789, x836);
  let mut x863: u32 = 0;
  let mut x864: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x863, &mut x864, x862, x791, x838);
  let mut x865: u32 = 0;
  let mut x866: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x865, &mut x866, x864, x793, x840);
  let mut x867: u32 = 0;
  let mut x868: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x867, &mut x868, x866, x795, x842);
  let mut x869: u32 = 0;
  let mut x870: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x869, &mut x870, x868, x797, x844);
  let mut x871: u32 = 0;
  let mut x872: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x871, &mut x872, x870, x799, x846);
  let mut x873: u32 = 0;
  let mut x874: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x873, &mut x874, x872, x801, x848);
  let mut x875: u32 = 0;
  let mut x876: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x875, &mut x876, x874, x803, x850);
  let mut x877: u32 = 0;
  let mut x878: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x877, &mut x878, x876, x805, x852);
  let mut x879: u32 = 0;
  let mut x880: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x879, &mut x880, x878, x807, x854);
  let mut x881: u32 = 0;
  let mut x882: u32 = 0;
  fiat_p384_mulx_u32(&mut x881, &mut x882, x855, 0xffffffff);
  let mut x883: u32 = 0;
  let mut x884: u32 = 0;
  fiat_p384_mulx_u32(&mut x883, &mut x884, x855, 0xffffffff);
  let mut x885: u32 = 0;
  let mut x886: u32 = 0;
  fiat_p384_mulx_u32(&mut x885, &mut x886, x855, 0xffffffff);
  let mut x887: u32 = 0;
  let mut x888: u32 = 0;
  fiat_p384_mulx_u32(&mut x887, &mut x888, x855, 0xffffffff);
  let mut x889: u32 = 0;
  let mut x890: u32 = 0;
  fiat_p384_mulx_u32(&mut x889, &mut x890, x855, 0xffffffff);
  let mut x891: u32 = 0;
  let mut x892: u32 = 0;
  fiat_p384_mulx_u32(&mut x891, &mut x892, x855, 0xffffffff);
  let mut x893: u32 = 0;
  let mut x894: u32 = 0;
  fiat_p384_mulx_u32(&mut x893, &mut x894, x855, 0xffffffff);
  let mut x895: u32 = 0;
  let mut x896: u32 = 0;
  fiat_p384_mulx_u32(&mut x895, &mut x896, x855, 0xfffffffe);
  let mut x897: u32 = 0;
  let mut x898: u32 = 0;
  fiat_p384_mulx_u32(&mut x897, &mut x898, x855, 0xffffffff);
  let mut x899: u32 = 0;
  let mut x900: u32 = 0;
  fiat_p384_mulx_u32(&mut x899, &mut x900, x855, 0xffffffff);
  let mut x901: u32 = 0;
  let mut x902: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x901, &mut x902, 0x0, x898, x895);
  let mut x903: u32 = 0;
  let mut x904: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x903, &mut x904, x902, x896, x893);
  let mut x905: u32 = 0;
  let mut x906: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x905, &mut x906, x904, x894, x891);
  let mut x907: u32 = 0;
  let mut x908: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x907, &mut x908, x906, x892, x889);
  let mut x909: u32 = 0;
  let mut x910: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x909, &mut x910, x908, x890, x887);
  let mut x911: u32 = 0;
  let mut x912: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x911, &mut x912, x910, x888, x885);
  let mut x913: u32 = 0;
  let mut x914: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x913, &mut x914, x912, x886, x883);
  let mut x915: u32 = 0;
  let mut x916: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x915, &mut x916, x914, x884, x881);
  let x917: u32 = ((x916 as u32) + x882);
  let mut x918: u32 = 0;
  let mut x919: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x918, &mut x919, 0x0, x855, x899);
  let mut x920: u32 = 0;
  let mut x921: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x920, &mut x921, x919, x857, x900);
  let mut x922: u32 = 0;
  let mut x923: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x922, &mut x923, x921, x859, (0x0 as u32));
  let mut x924: u32 = 0;
  let mut x925: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x924, &mut x925, x923, x861, x897);
  let mut x926: u32 = 0;
  let mut x927: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x926, &mut x927, x925, x863, x901);
  let mut x928: u32 = 0;
  let mut x929: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x928, &mut x929, x927, x865, x903);
  let mut x930: u32 = 0;
  let mut x931: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x930, &mut x931, x929, x867, x905);
  let mut x932: u32 = 0;
  let mut x933: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x932, &mut x933, x931, x869, x907);
  let mut x934: u32 = 0;
  let mut x935: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x934, &mut x935, x933, x871, x909);
  let mut x936: u32 = 0;
  let mut x937: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x936, &mut x937, x935, x873, x911);
  let mut x938: u32 = 0;
  let mut x939: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x938, &mut x939, x937, x875, x913);
  let mut x940: u32 = 0;
  let mut x941: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x940, &mut x941, x939, x877, x915);
  let mut x942: u32 = 0;
  let mut x943: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x942, &mut x943, x941, x879, x917);
  let x944: u32 = ((x943 as u32) + (x880 as u32));
  let mut x945: u32 = 0;
  let mut x946: u32 = 0;
  fiat_p384_mulx_u32(&mut x945, &mut x946, x7, (arg2[11]));
  let mut x947: u32 = 0;
  let mut x948: u32 = 0;
  fiat_p384_mulx_u32(&mut x947, &mut x948, x7, (arg2[10]));
  let mut x949: u32 = 0;
  let mut x950: u32 = 0;
  fiat_p384_mulx_u32(&mut x949, &mut x950, x7, (arg2[9]));
  let mut x951: u32 = 0;
  let mut x952: u32 = 0;
  fiat_p384_mulx_u32(&mut x951, &mut x952, x7, (arg2[8]));
  let mut x953: u32 = 0;
  let mut x954: u32 = 0;
  fiat_p384_mulx_u32(&mut x953, &mut x954, x7, (arg2[7]));
  let mut x955: u32 = 0;
  let mut x956: u32 = 0;
  fiat_p384_mulx_u32(&mut x955, &mut x956, x7, (arg2[6]));
  let mut x957: u32 = 0;
  let mut x958: u32 = 0;
  fiat_p384_mulx_u32(&mut x957, &mut x958, x7, (arg2[5]));
  let mut x959: u32 = 0;
  let mut x960: u32 = 0;
  fiat_p384_mulx_u32(&mut x959, &mut x960, x7, (arg2[4]));
  let mut x961: u32 = 0;
  let mut x962: u32 = 0;
  fiat_p384_mulx_u32(&mut x961, &mut x962, x7, (arg2[3]));
  let mut x963: u32 = 0;
  let mut x964: u32 = 0;
  fiat_p384_mulx_u32(&mut x963, &mut x964, x7, (arg2[2]));
  let mut x965: u32 = 0;
  let mut x966: u32 = 0;
  fiat_p384_mulx_u32(&mut x965, &mut x966, x7, (arg2[1]));
  let mut x967: u32 = 0;
  let mut x968: u32 = 0;
  fiat_p384_mulx_u32(&mut x967, &mut x968, x7, (arg2[0]));
  let mut x969: u32 = 0;
  let mut x970: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x969, &mut x970, 0x0, x968, x965);
  let mut x971: u32 = 0;
  let mut x972: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x971, &mut x972, x970, x966, x963);
  let mut x973: u32 = 0;
  let mut x974: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x973, &mut x974, x972, x964, x961);
  let mut x975: u32 = 0;
  let mut x976: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x975, &mut x976, x974, x962, x959);
  let mut x977: u32 = 0;
  let mut x978: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x977, &mut x978, x976, x960, x957);
  let mut x979: u32 = 0;
  let mut x980: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x979, &mut x980, x978, x958, x955);
  let mut x981: u32 = 0;
  let mut x982: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x981, &mut x982, x980, x956, x953);
  let mut x983: u32 = 0;
  let mut x984: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x983, &mut x984, x982, x954, x951);
  let mut x985: u32 = 0;
  let mut x986: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x985, &mut x986, x984, x952, x949);
  let mut x987: u32 = 0;
  let mut x988: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x987, &mut x988, x986, x950, x947);
  let mut x989: u32 = 0;
  let mut x990: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x989, &mut x990, x988, x948, x945);
  let x991: u32 = ((x990 as u32) + x946);
  let mut x992: u32 = 0;
  let mut x993: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x992, &mut x993, 0x0, x920, x967);
  let mut x994: u32 = 0;
  let mut x995: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x994, &mut x995, x993, x922, x969);
  let mut x996: u32 = 0;
  let mut x997: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x996, &mut x997, x995, x924, x971);
  let mut x998: u32 = 0;
  let mut x999: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x998, &mut x999, x997, x926, x973);
  let mut x1000: u32 = 0;
  let mut x1001: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1000, &mut x1001, x999, x928, x975);
  let mut x1002: u32 = 0;
  let mut x1003: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1002, &mut x1003, x1001, x930, x977);
  let mut x1004: u32 = 0;
  let mut x1005: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1004, &mut x1005, x1003, x932, x979);
  let mut x1006: u32 = 0;
  let mut x1007: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1006, &mut x1007, x1005, x934, x981);
  let mut x1008: u32 = 0;
  let mut x1009: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1008, &mut x1009, x1007, x936, x983);
  let mut x1010: u32 = 0;
  let mut x1011: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1010, &mut x1011, x1009, x938, x985);
  let mut x1012: u32 = 0;
  let mut x1013: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1012, &mut x1013, x1011, x940, x987);
  let mut x1014: u32 = 0;
  let mut x1015: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1014, &mut x1015, x1013, x942, x989);
  let mut x1016: u32 = 0;
  let mut x1017: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1016, &mut x1017, x1015, x944, x991);
  let mut x1018: u32 = 0;
  let mut x1019: u32 = 0;
  fiat_p384_mulx_u32(&mut x1018, &mut x1019, x992, 0xffffffff);
  let mut x1020: u32 = 0;
  let mut x1021: u32 = 0;
  fiat_p384_mulx_u32(&mut x1020, &mut x1021, x992, 0xffffffff);
  let mut x1022: u32 = 0;
  let mut x1023: u32 = 0;
  fiat_p384_mulx_u32(&mut x1022, &mut x1023, x992, 0xffffffff);
  let mut x1024: u32 = 0;
  let mut x1025: u32 = 0;
  fiat_p384_mulx_u32(&mut x1024, &mut x1025, x992, 0xffffffff);
  let mut x1026: u32 = 0;
  let mut x1027: u32 = 0;
  fiat_p384_mulx_u32(&mut x1026, &mut x1027, x992, 0xffffffff);
  let mut x1028: u32 = 0;
  let mut x1029: u32 = 0;
  fiat_p384_mulx_u32(&mut x1028, &mut x1029, x992, 0xffffffff);
  let mut x1030: u32 = 0;
  let mut x1031: u32 = 0;
  fiat_p384_mulx_u32(&mut x1030, &mut x1031, x992, 0xffffffff);
  let mut x1032: u32 = 0;
  let mut x1033: u32 = 0;
  fiat_p384_mulx_u32(&mut x1032, &mut x1033, x992, 0xfffffffe);
  let mut x1034: u32 = 0;
  let mut x1035: u32 = 0;
  fiat_p384_mulx_u32(&mut x1034, &mut x1035, x992, 0xffffffff);
  let mut x1036: u32 = 0;
  let mut x1037: u32 = 0;
  fiat_p384_mulx_u32(&mut x1036, &mut x1037, x992, 0xffffffff);
  let mut x1038: u32 = 0;
  let mut x1039: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1038, &mut x1039, 0x0, x1035, x1032);
  let mut x1040: u32 = 0;
  let mut x1041: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1040, &mut x1041, x1039, x1033, x1030);
  let mut x1042: u32 = 0;
  let mut x1043: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1042, &mut x1043, x1041, x1031, x1028);
  let mut x1044: u32 = 0;
  let mut x1045: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1044, &mut x1045, x1043, x1029, x1026);
  let mut x1046: u32 = 0;
  let mut x1047: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1046, &mut x1047, x1045, x1027, x1024);
  let mut x1048: u32 = 0;
  let mut x1049: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1048, &mut x1049, x1047, x1025, x1022);
  let mut x1050: u32 = 0;
  let mut x1051: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1050, &mut x1051, x1049, x1023, x1020);
  let mut x1052: u32 = 0;
  let mut x1053: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1052, &mut x1053, x1051, x1021, x1018);
  let x1054: u32 = ((x1053 as u32) + x1019);
  let mut x1055: u32 = 0;
  let mut x1056: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1055, &mut x1056, 0x0, x992, x1036);
  let mut x1057: u32 = 0;
  let mut x1058: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1057, &mut x1058, x1056, x994, x1037);
  let mut x1059: u32 = 0;
  let mut x1060: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1059, &mut x1060, x1058, x996, (0x0 as u32));
  let mut x1061: u32 = 0;
  let mut x1062: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1061, &mut x1062, x1060, x998, x1034);
  let mut x1063: u32 = 0;
  let mut x1064: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1063, &mut x1064, x1062, x1000, x1038);
  let mut x1065: u32 = 0;
  let mut x1066: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1065, &mut x1066, x1064, x1002, x1040);
  let mut x1067: u32 = 0;
  let mut x1068: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1067, &mut x1068, x1066, x1004, x1042);
  let mut x1069: u32 = 0;
  let mut x1070: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1069, &mut x1070, x1068, x1006, x1044);
  let mut x1071: u32 = 0;
  let mut x1072: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1071, &mut x1072, x1070, x1008, x1046);
  let mut x1073: u32 = 0;
  let mut x1074: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1073, &mut x1074, x1072, x1010, x1048);
  let mut x1075: u32 = 0;
  let mut x1076: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1075, &mut x1076, x1074, x1012, x1050);
  let mut x1077: u32 = 0;
  let mut x1078: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1077, &mut x1078, x1076, x1014, x1052);
  let mut x1079: u32 = 0;
  let mut x1080: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1079, &mut x1080, x1078, x1016, x1054);
  let x1081: u32 = ((x1080 as u32) + (x1017 as u32));
  let mut x1082: u32 = 0;
  let mut x1083: u32 = 0;
  fiat_p384_mulx_u32(&mut x1082, &mut x1083, x8, (arg2[11]));
  let mut x1084: u32 = 0;
  let mut x1085: u32 = 0;
  fiat_p384_mulx_u32(&mut x1084, &mut x1085, x8, (arg2[10]));
  let mut x1086: u32 = 0;
  let mut x1087: u32 = 0;
  fiat_p384_mulx_u32(&mut x1086, &mut x1087, x8, (arg2[9]));
  let mut x1088: u32 = 0;
  let mut x1089: u32 = 0;
  fiat_p384_mulx_u32(&mut x1088, &mut x1089, x8, (arg2[8]));
  let mut x1090: u32 = 0;
  let mut x1091: u32 = 0;
  fiat_p384_mulx_u32(&mut x1090, &mut x1091, x8, (arg2[7]));
  let mut x1092: u32 = 0;
  let mut x1093: u32 = 0;
  fiat_p384_mulx_u32(&mut x1092, &mut x1093, x8, (arg2[6]));
  let mut x1094: u32 = 0;
  let mut x1095: u32 = 0;
  fiat_p384_mulx_u32(&mut x1094, &mut x1095, x8, (arg2[5]));
  let mut x1096: u32 = 0;
  let mut x1097: u32 = 0;
  fiat_p384_mulx_u32(&mut x1096, &mut x1097, x8, (arg2[4]));
  let mut x1098: u32 = 0;
  let mut x1099: u32 = 0;
  fiat_p384_mulx_u32(&mut x1098, &mut x1099, x8, (arg2[3]));
  let mut x1100: u32 = 0;
  let mut x1101: u32 = 0;
  fiat_p384_mulx_u32(&mut x1100, &mut x1101, x8, (arg2[2]));
  let mut x1102: u32 = 0;
  let mut x1103: u32 = 0;
  fiat_p384_mulx_u32(&mut x1102, &mut x1103, x8, (arg2[1]));
  let mut x1104: u32 = 0;
  let mut x1105: u32 = 0;
  fiat_p384_mulx_u32(&mut x1104, &mut x1105, x8, (arg2[0]));
  let mut x1106: u32 = 0;
  let mut x1107: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1106, &mut x1107, 0x0, x1105, x1102);
  let mut x1108: u32 = 0;
  let mut x1109: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1108, &mut x1109, x1107, x1103, x1100);
  let mut x1110: u32 = 0;
  let mut x1111: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1110, &mut x1111, x1109, x1101, x1098);
  let mut x1112: u32 = 0;
  let mut x1113: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1112, &mut x1113, x1111, x1099, x1096);
  let mut x1114: u32 = 0;
  let mut x1115: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1114, &mut x1115, x1113, x1097, x1094);
  let mut x1116: u32 = 0;
  let mut x1117: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1116, &mut x1117, x1115, x1095, x1092);
  let mut x1118: u32 = 0;
  let mut x1119: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1118, &mut x1119, x1117, x1093, x1090);
  let mut x1120: u32 = 0;
  let mut x1121: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1120, &mut x1121, x1119, x1091, x1088);
  let mut x1122: u32 = 0;
  let mut x1123: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1122, &mut x1123, x1121, x1089, x1086);
  let mut x1124: u32 = 0;
  let mut x1125: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1124, &mut x1125, x1123, x1087, x1084);
  let mut x1126: u32 = 0;
  let mut x1127: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1126, &mut x1127, x1125, x1085, x1082);
  let x1128: u32 = ((x1127 as u32) + x1083);
  let mut x1129: u32 = 0;
  let mut x1130: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1129, &mut x1130, 0x0, x1057, x1104);
  let mut x1131: u32 = 0;
  let mut x1132: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1131, &mut x1132, x1130, x1059, x1106);
  let mut x1133: u32 = 0;
  let mut x1134: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1133, &mut x1134, x1132, x1061, x1108);
  let mut x1135: u32 = 0;
  let mut x1136: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1135, &mut x1136, x1134, x1063, x1110);
  let mut x1137: u32 = 0;
  let mut x1138: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1137, &mut x1138, x1136, x1065, x1112);
  let mut x1139: u32 = 0;
  let mut x1140: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1139, &mut x1140, x1138, x1067, x1114);
  let mut x1141: u32 = 0;
  let mut x1142: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1141, &mut x1142, x1140, x1069, x1116);
  let mut x1143: u32 = 0;
  let mut x1144: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1143, &mut x1144, x1142, x1071, x1118);
  let mut x1145: u32 = 0;
  let mut x1146: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1145, &mut x1146, x1144, x1073, x1120);
  let mut x1147: u32 = 0;
  let mut x1148: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1147, &mut x1148, x1146, x1075, x1122);
  let mut x1149: u32 = 0;
  let mut x1150: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1149, &mut x1150, x1148, x1077, x1124);
  let mut x1151: u32 = 0;
  let mut x1152: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1151, &mut x1152, x1150, x1079, x1126);
  let mut x1153: u32 = 0;
  let mut x1154: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1153, &mut x1154, x1152, x1081, x1128);
  let mut x1155: u32 = 0;
  let mut x1156: u32 = 0;
  fiat_p384_mulx_u32(&mut x1155, &mut x1156, x1129, 0xffffffff);
  let mut x1157: u32 = 0;
  let mut x1158: u32 = 0;
  fiat_p384_mulx_u32(&mut x1157, &mut x1158, x1129, 0xffffffff);
  let mut x1159: u32 = 0;
  let mut x1160: u32 = 0;
  fiat_p384_mulx_u32(&mut x1159, &mut x1160, x1129, 0xffffffff);
  let mut x1161: u32 = 0;
  let mut x1162: u32 = 0;
  fiat_p384_mulx_u32(&mut x1161, &mut x1162, x1129, 0xffffffff);
  let mut x1163: u32 = 0;
  let mut x1164: u32 = 0;
  fiat_p384_mulx_u32(&mut x1163, &mut x1164, x1129, 0xffffffff);
  let mut x1165: u32 = 0;
  let mut x1166: u32 = 0;
  fiat_p384_mulx_u32(&mut x1165, &mut x1166, x1129, 0xffffffff);
  let mut x1167: u32 = 0;
  let mut x1168: u32 = 0;
  fiat_p384_mulx_u32(&mut x1167, &mut x1168, x1129, 0xffffffff);
  let mut x1169: u32 = 0;
  let mut x1170: u32 = 0;
  fiat_p384_mulx_u32(&mut x1169, &mut x1170, x1129, 0xfffffffe);
  let mut x1171: u32 = 0;
  let mut x1172: u32 = 0;
  fiat_p384_mulx_u32(&mut x1171, &mut x1172, x1129, 0xffffffff);
  let mut x1173: u32 = 0;
  let mut x1174: u32 = 0;
  fiat_p384_mulx_u32(&mut x1173, &mut x1174, x1129, 0xffffffff);
  let mut x1175: u32 = 0;
  let mut x1176: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1175, &mut x1176, 0x0, x1172, x1169);
  let mut x1177: u32 = 0;
  let mut x1178: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1177, &mut x1178, x1176, x1170, x1167);
  let mut x1179: u32 = 0;
  let mut x1180: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1179, &mut x1180, x1178, x1168, x1165);
  let mut x1181: u32 = 0;
  let mut x1182: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1181, &mut x1182, x1180, x1166, x1163);
  let mut x1183: u32 = 0;
  let mut x1184: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1183, &mut x1184, x1182, x1164, x1161);
  let mut x1185: u32 = 0;
  let mut x1186: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1185, &mut x1186, x1184, x1162, x1159);
  let mut x1187: u32 = 0;
  let mut x1188: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1187, &mut x1188, x1186, x1160, x1157);
  let mut x1189: u32 = 0;
  let mut x1190: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1189, &mut x1190, x1188, x1158, x1155);
  let x1191: u32 = ((x1190 as u32) + x1156);
  let mut x1192: u32 = 0;
  let mut x1193: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1192, &mut x1193, 0x0, x1129, x1173);
  let mut x1194: u32 = 0;
  let mut x1195: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1194, &mut x1195, x1193, x1131, x1174);
  let mut x1196: u32 = 0;
  let mut x1197: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1196, &mut x1197, x1195, x1133, (0x0 as u32));
  let mut x1198: u32 = 0;
  let mut x1199: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1198, &mut x1199, x1197, x1135, x1171);
  let mut x1200: u32 = 0;
  let mut x1201: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1200, &mut x1201, x1199, x1137, x1175);
  let mut x1202: u32 = 0;
  let mut x1203: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1202, &mut x1203, x1201, x1139, x1177);
  let mut x1204: u32 = 0;
  let mut x1205: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1204, &mut x1205, x1203, x1141, x1179);
  let mut x1206: u32 = 0;
  let mut x1207: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1206, &mut x1207, x1205, x1143, x1181);
  let mut x1208: u32 = 0;
  let mut x1209: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1208, &mut x1209, x1207, x1145, x1183);
  let mut x1210: u32 = 0;
  let mut x1211: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1210, &mut x1211, x1209, x1147, x1185);
  let mut x1212: u32 = 0;
  let mut x1213: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1212, &mut x1213, x1211, x1149, x1187);
  let mut x1214: u32 = 0;
  let mut x1215: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1214, &mut x1215, x1213, x1151, x1189);
  let mut x1216: u32 = 0;
  let mut x1217: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1216, &mut x1217, x1215, x1153, x1191);
  let x1218: u32 = ((x1217 as u32) + (x1154 as u32));
  let mut x1219: u32 = 0;
  let mut x1220: u32 = 0;
  fiat_p384_mulx_u32(&mut x1219, &mut x1220, x9, (arg2[11]));
  let mut x1221: u32 = 0;
  let mut x1222: u32 = 0;
  fiat_p384_mulx_u32(&mut x1221, &mut x1222, x9, (arg2[10]));
  let mut x1223: u32 = 0;
  let mut x1224: u32 = 0;
  fiat_p384_mulx_u32(&mut x1223, &mut x1224, x9, (arg2[9]));
  let mut x1225: u32 = 0;
  let mut x1226: u32 = 0;
  fiat_p384_mulx_u32(&mut x1225, &mut x1226, x9, (arg2[8]));
  let mut x1227: u32 = 0;
  let mut x1228: u32 = 0;
  fiat_p384_mulx_u32(&mut x1227, &mut x1228, x9, (arg2[7]));
  let mut x1229: u32 = 0;
  let mut x1230: u32 = 0;
  fiat_p384_mulx_u32(&mut x1229, &mut x1230, x9, (arg2[6]));
  let mut x1231: u32 = 0;
  let mut x1232: u32 = 0;
  fiat_p384_mulx_u32(&mut x1231, &mut x1232, x9, (arg2[5]));
  let mut x1233: u32 = 0;
  let mut x1234: u32 = 0;
  fiat_p384_mulx_u32(&mut x1233, &mut x1234, x9, (arg2[4]));
  let mut x1235: u32 = 0;
  let mut x1236: u32 = 0;
  fiat_p384_mulx_u32(&mut x1235, &mut x1236, x9, (arg2[3]));
  let mut x1237: u32 = 0;
  let mut x1238: u32 = 0;
  fiat_p384_mulx_u32(&mut x1237, &mut x1238, x9, (arg2[2]));
  let mut x1239: u32 = 0;
  let mut x1240: u32 = 0;
  fiat_p384_mulx_u32(&mut x1239, &mut x1240, x9, (arg2[1]));
  let mut x1241: u32 = 0;
  let mut x1242: u32 = 0;
  fiat_p384_mulx_u32(&mut x1241, &mut x1242, x9, (arg2[0]));
  let mut x1243: u32 = 0;
  let mut x1244: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1243, &mut x1244, 0x0, x1242, x1239);
  let mut x1245: u32 = 0;
  let mut x1246: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1245, &mut x1246, x1244, x1240, x1237);
  let mut x1247: u32 = 0;
  let mut x1248: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1247, &mut x1248, x1246, x1238, x1235);
  let mut x1249: u32 = 0;
  let mut x1250: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1249, &mut x1250, x1248, x1236, x1233);
  let mut x1251: u32 = 0;
  let mut x1252: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1251, &mut x1252, x1250, x1234, x1231);
  let mut x1253: u32 = 0;
  let mut x1254: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1253, &mut x1254, x1252, x1232, x1229);
  let mut x1255: u32 = 0;
  let mut x1256: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1255, &mut x1256, x1254, x1230, x1227);
  let mut x1257: u32 = 0;
  let mut x1258: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1257, &mut x1258, x1256, x1228, x1225);
  let mut x1259: u32 = 0;
  let mut x1260: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1259, &mut x1260, x1258, x1226, x1223);
  let mut x1261: u32 = 0;
  let mut x1262: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1261, &mut x1262, x1260, x1224, x1221);
  let mut x1263: u32 = 0;
  let mut x1264: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1263, &mut x1264, x1262, x1222, x1219);
  let x1265: u32 = ((x1264 as u32) + x1220);
  let mut x1266: u32 = 0;
  let mut x1267: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1266, &mut x1267, 0x0, x1194, x1241);
  let mut x1268: u32 = 0;
  let mut x1269: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1268, &mut x1269, x1267, x1196, x1243);
  let mut x1270: u32 = 0;
  let mut x1271: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1270, &mut x1271, x1269, x1198, x1245);
  let mut x1272: u32 = 0;
  let mut x1273: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1272, &mut x1273, x1271, x1200, x1247);
  let mut x1274: u32 = 0;
  let mut x1275: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1274, &mut x1275, x1273, x1202, x1249);
  let mut x1276: u32 = 0;
  let mut x1277: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1276, &mut x1277, x1275, x1204, x1251);
  let mut x1278: u32 = 0;
  let mut x1279: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1278, &mut x1279, x1277, x1206, x1253);
  let mut x1280: u32 = 0;
  let mut x1281: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1280, &mut x1281, x1279, x1208, x1255);
  let mut x1282: u32 = 0;
  let mut x1283: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1282, &mut x1283, x1281, x1210, x1257);
  let mut x1284: u32 = 0;
  let mut x1285: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1284, &mut x1285, x1283, x1212, x1259);
  let mut x1286: u32 = 0;
  let mut x1287: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1286, &mut x1287, x1285, x1214, x1261);
  let mut x1288: u32 = 0;
  let mut x1289: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1288, &mut x1289, x1287, x1216, x1263);
  let mut x1290: u32 = 0;
  let mut x1291: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1290, &mut x1291, x1289, x1218, x1265);
  let mut x1292: u32 = 0;
  let mut x1293: u32 = 0;
  fiat_p384_mulx_u32(&mut x1292, &mut x1293, x1266, 0xffffffff);
  let mut x1294: u32 = 0;
  let mut x1295: u32 = 0;
  fiat_p384_mulx_u32(&mut x1294, &mut x1295, x1266, 0xffffffff);
  let mut x1296: u32 = 0;
  let mut x1297: u32 = 0;
  fiat_p384_mulx_u32(&mut x1296, &mut x1297, x1266, 0xffffffff);
  let mut x1298: u32 = 0;
  let mut x1299: u32 = 0;
  fiat_p384_mulx_u32(&mut x1298, &mut x1299, x1266, 0xffffffff);
  let mut x1300: u32 = 0;
  let mut x1301: u32 = 0;
  fiat_p384_mulx_u32(&mut x1300, &mut x1301, x1266, 0xffffffff);
  let mut x1302: u32 = 0;
  let mut x1303: u32 = 0;
  fiat_p384_mulx_u32(&mut x1302, &mut x1303, x1266, 0xffffffff);
  let mut x1304: u32 = 0;
  let mut x1305: u32 = 0;
  fiat_p384_mulx_u32(&mut x1304, &mut x1305, x1266, 0xffffffff);
  let mut x1306: u32 = 0;
  let mut x1307: u32 = 0;
  fiat_p384_mulx_u32(&mut x1306, &mut x1307, x1266, 0xfffffffe);
  let mut x1308: u32 = 0;
  let mut x1309: u32 = 0;
  fiat_p384_mulx_u32(&mut x1308, &mut x1309, x1266, 0xffffffff);
  let mut x1310: u32 = 0;
  let mut x1311: u32 = 0;
  fiat_p384_mulx_u32(&mut x1310, &mut x1311, x1266, 0xffffffff);
  let mut x1312: u32 = 0;
  let mut x1313: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1312, &mut x1313, 0x0, x1309, x1306);
  let mut x1314: u32 = 0;
  let mut x1315: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1314, &mut x1315, x1313, x1307, x1304);
  let mut x1316: u32 = 0;
  let mut x1317: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1316, &mut x1317, x1315, x1305, x1302);
  let mut x1318: u32 = 0;
  let mut x1319: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1318, &mut x1319, x1317, x1303, x1300);
  let mut x1320: u32 = 0;
  let mut x1321: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1320, &mut x1321, x1319, x1301, x1298);
  let mut x1322: u32 = 0;
  let mut x1323: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1322, &mut x1323, x1321, x1299, x1296);
  let mut x1324: u32 = 0;
  let mut x1325: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1324, &mut x1325, x1323, x1297, x1294);
  let mut x1326: u32 = 0;
  let mut x1327: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1326, &mut x1327, x1325, x1295, x1292);
  let x1328: u32 = ((x1327 as u32) + x1293);
  let mut x1329: u32 = 0;
  let mut x1330: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1329, &mut x1330, 0x0, x1266, x1310);
  let mut x1331: u32 = 0;
  let mut x1332: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1331, &mut x1332, x1330, x1268, x1311);
  let mut x1333: u32 = 0;
  let mut x1334: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1333, &mut x1334, x1332, x1270, (0x0 as u32));
  let mut x1335: u32 = 0;
  let mut x1336: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1335, &mut x1336, x1334, x1272, x1308);
  let mut x1337: u32 = 0;
  let mut x1338: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1337, &mut x1338, x1336, x1274, x1312);
  let mut x1339: u32 = 0;
  let mut x1340: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1339, &mut x1340, x1338, x1276, x1314);
  let mut x1341: u32 = 0;
  let mut x1342: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1341, &mut x1342, x1340, x1278, x1316);
  let mut x1343: u32 = 0;
  let mut x1344: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1343, &mut x1344, x1342, x1280, x1318);
  let mut x1345: u32 = 0;
  let mut x1346: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1345, &mut x1346, x1344, x1282, x1320);
  let mut x1347: u32 = 0;
  let mut x1348: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1347, &mut x1348, x1346, x1284, x1322);
  let mut x1349: u32 = 0;
  let mut x1350: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1349, &mut x1350, x1348, x1286, x1324);
  let mut x1351: u32 = 0;
  let mut x1352: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1351, &mut x1352, x1350, x1288, x1326);
  let mut x1353: u32 = 0;
  let mut x1354: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1353, &mut x1354, x1352, x1290, x1328);
  let x1355: u32 = ((x1354 as u32) + (x1291 as u32));
  let mut x1356: u32 = 0;
  let mut x1357: u32 = 0;
  fiat_p384_mulx_u32(&mut x1356, &mut x1357, x10, (arg2[11]));
  let mut x1358: u32 = 0;
  let mut x1359: u32 = 0;
  fiat_p384_mulx_u32(&mut x1358, &mut x1359, x10, (arg2[10]));
  let mut x1360: u32 = 0;
  let mut x1361: u32 = 0;
  fiat_p384_mulx_u32(&mut x1360, &mut x1361, x10, (arg2[9]));
  let mut x1362: u32 = 0;
  let mut x1363: u32 = 0;
  fiat_p384_mulx_u32(&mut x1362, &mut x1363, x10, (arg2[8]));
  let mut x1364: u32 = 0;
  let mut x1365: u32 = 0;
  fiat_p384_mulx_u32(&mut x1364, &mut x1365, x10, (arg2[7]));
  let mut x1366: u32 = 0;
  let mut x1367: u32 = 0;
  fiat_p384_mulx_u32(&mut x1366, &mut x1367, x10, (arg2[6]));
  let mut x1368: u32 = 0;
  let mut x1369: u32 = 0;
  fiat_p384_mulx_u32(&mut x1368, &mut x1369, x10, (arg2[5]));
  let mut x1370: u32 = 0;
  let mut x1371: u32 = 0;
  fiat_p384_mulx_u32(&mut x1370, &mut x1371, x10, (arg2[4]));
  let mut x1372: u32 = 0;
  let mut x1373: u32 = 0;
  fiat_p384_mulx_u32(&mut x1372, &mut x1373, x10, (arg2[3]));
  let mut x1374: u32 = 0;
  let mut x1375: u32 = 0;
  fiat_p384_mulx_u32(&mut x1374, &mut x1375, x10, (arg2[2]));
  let mut x1376: u32 = 0;
  let mut x1377: u32 = 0;
  fiat_p384_mulx_u32(&mut x1376, &mut x1377, x10, (arg2[1]));
  let mut x1378: u32 = 0;
  let mut x1379: u32 = 0;
  fiat_p384_mulx_u32(&mut x1378, &mut x1379, x10, (arg2[0]));
  let mut x1380: u32 = 0;
  let mut x1381: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1380, &mut x1381, 0x0, x1379, x1376);
  let mut x1382: u32 = 0;
  let mut x1383: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1382, &mut x1383, x1381, x1377, x1374);
  let mut x1384: u32 = 0;
  let mut x1385: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1384, &mut x1385, x1383, x1375, x1372);
  let mut x1386: u32 = 0;
  let mut x1387: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1386, &mut x1387, x1385, x1373, x1370);
  let mut x1388: u32 = 0;
  let mut x1389: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1388, &mut x1389, x1387, x1371, x1368);
  let mut x1390: u32 = 0;
  let mut x1391: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1390, &mut x1391, x1389, x1369, x1366);
  let mut x1392: u32 = 0;
  let mut x1393: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1392, &mut x1393, x1391, x1367, x1364);
  let mut x1394: u32 = 0;
  let mut x1395: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1394, &mut x1395, x1393, x1365, x1362);
  let mut x1396: u32 = 0;
  let mut x1397: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1396, &mut x1397, x1395, x1363, x1360);
  let mut x1398: u32 = 0;
  let mut x1399: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1398, &mut x1399, x1397, x1361, x1358);
  let mut x1400: u32 = 0;
  let mut x1401: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1400, &mut x1401, x1399, x1359, x1356);
  let x1402: u32 = ((x1401 as u32) + x1357);
  let mut x1403: u32 = 0;
  let mut x1404: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1403, &mut x1404, 0x0, x1331, x1378);
  let mut x1405: u32 = 0;
  let mut x1406: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1405, &mut x1406, x1404, x1333, x1380);
  let mut x1407: u32 = 0;
  let mut x1408: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1407, &mut x1408, x1406, x1335, x1382);
  let mut x1409: u32 = 0;
  let mut x1410: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1409, &mut x1410, x1408, x1337, x1384);
  let mut x1411: u32 = 0;
  let mut x1412: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1411, &mut x1412, x1410, x1339, x1386);
  let mut x1413: u32 = 0;
  let mut x1414: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1413, &mut x1414, x1412, x1341, x1388);
  let mut x1415: u32 = 0;
  let mut x1416: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1415, &mut x1416, x1414, x1343, x1390);
  let mut x1417: u32 = 0;
  let mut x1418: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1417, &mut x1418, x1416, x1345, x1392);
  let mut x1419: u32 = 0;
  let mut x1420: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1419, &mut x1420, x1418, x1347, x1394);
  let mut x1421: u32 = 0;
  let mut x1422: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1421, &mut x1422, x1420, x1349, x1396);
  let mut x1423: u32 = 0;
  let mut x1424: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1423, &mut x1424, x1422, x1351, x1398);
  let mut x1425: u32 = 0;
  let mut x1426: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1425, &mut x1426, x1424, x1353, x1400);
  let mut x1427: u32 = 0;
  let mut x1428: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1427, &mut x1428, x1426, x1355, x1402);
  let mut x1429: u32 = 0;
  let mut x1430: u32 = 0;
  fiat_p384_mulx_u32(&mut x1429, &mut x1430, x1403, 0xffffffff);
  let mut x1431: u32 = 0;
  let mut x1432: u32 = 0;
  fiat_p384_mulx_u32(&mut x1431, &mut x1432, x1403, 0xffffffff);
  let mut x1433: u32 = 0;
  let mut x1434: u32 = 0;
  fiat_p384_mulx_u32(&mut x1433, &mut x1434, x1403, 0xffffffff);
  let mut x1435: u32 = 0;
  let mut x1436: u32 = 0;
  fiat_p384_mulx_u32(&mut x1435, &mut x1436, x1403, 0xffffffff);
  let mut x1437: u32 = 0;
  let mut x1438: u32 = 0;
  fiat_p384_mulx_u32(&mut x1437, &mut x1438, x1403, 0xffffffff);
  let mut x1439: u32 = 0;
  let mut x1440: u32 = 0;
  fiat_p384_mulx_u32(&mut x1439, &mut x1440, x1403, 0xffffffff);
  let mut x1441: u32 = 0;
  let mut x1442: u32 = 0;
  fiat_p384_mulx_u32(&mut x1441, &mut x1442, x1403, 0xffffffff);
  let mut x1443: u32 = 0;
  let mut x1444: u32 = 0;
  fiat_p384_mulx_u32(&mut x1443, &mut x1444, x1403, 0xfffffffe);
  let mut x1445: u32 = 0;
  let mut x1446: u32 = 0;
  fiat_p384_mulx_u32(&mut x1445, &mut x1446, x1403, 0xffffffff);
  let mut x1447: u32 = 0;
  let mut x1448: u32 = 0;
  fiat_p384_mulx_u32(&mut x1447, &mut x1448, x1403, 0xffffffff);
  let mut x1449: u32 = 0;
  let mut x1450: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1449, &mut x1450, 0x0, x1446, x1443);
  let mut x1451: u32 = 0;
  let mut x1452: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1451, &mut x1452, x1450, x1444, x1441);
  let mut x1453: u32 = 0;
  let mut x1454: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1453, &mut x1454, x1452, x1442, x1439);
  let mut x1455: u32 = 0;
  let mut x1456: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1455, &mut x1456, x1454, x1440, x1437);
  let mut x1457: u32 = 0;
  let mut x1458: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1457, &mut x1458, x1456, x1438, x1435);
  let mut x1459: u32 = 0;
  let mut x1460: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1459, &mut x1460, x1458, x1436, x1433);
  let mut x1461: u32 = 0;
  let mut x1462: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1461, &mut x1462, x1460, x1434, x1431);
  let mut x1463: u32 = 0;
  let mut x1464: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1463, &mut x1464, x1462, x1432, x1429);
  let x1465: u32 = ((x1464 as u32) + x1430);
  let mut x1466: u32 = 0;
  let mut x1467: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1466, &mut x1467, 0x0, x1403, x1447);
  let mut x1468: u32 = 0;
  let mut x1469: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1468, &mut x1469, x1467, x1405, x1448);
  let mut x1470: u32 = 0;
  let mut x1471: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1470, &mut x1471, x1469, x1407, (0x0 as u32));
  let mut x1472: u32 = 0;
  let mut x1473: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1472, &mut x1473, x1471, x1409, x1445);
  let mut x1474: u32 = 0;
  let mut x1475: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1474, &mut x1475, x1473, x1411, x1449);
  let mut x1476: u32 = 0;
  let mut x1477: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1476, &mut x1477, x1475, x1413, x1451);
  let mut x1478: u32 = 0;
  let mut x1479: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1478, &mut x1479, x1477, x1415, x1453);
  let mut x1480: u32 = 0;
  let mut x1481: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1480, &mut x1481, x1479, x1417, x1455);
  let mut x1482: u32 = 0;
  let mut x1483: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1482, &mut x1483, x1481, x1419, x1457);
  let mut x1484: u32 = 0;
  let mut x1485: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1484, &mut x1485, x1483, x1421, x1459);
  let mut x1486: u32 = 0;
  let mut x1487: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1486, &mut x1487, x1485, x1423, x1461);
  let mut x1488: u32 = 0;
  let mut x1489: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1488, &mut x1489, x1487, x1425, x1463);
  let mut x1490: u32 = 0;
  let mut x1491: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1490, &mut x1491, x1489, x1427, x1465);
  let x1492: u32 = ((x1491 as u32) + (x1428 as u32));
  let mut x1493: u32 = 0;
  let mut x1494: u32 = 0;
  fiat_p384_mulx_u32(&mut x1493, &mut x1494, x11, (arg2[11]));
  let mut x1495: u32 = 0;
  let mut x1496: u32 = 0;
  fiat_p384_mulx_u32(&mut x1495, &mut x1496, x11, (arg2[10]));
  let mut x1497: u32 = 0;
  let mut x1498: u32 = 0;
  fiat_p384_mulx_u32(&mut x1497, &mut x1498, x11, (arg2[9]));
  let mut x1499: u32 = 0;
  let mut x1500: u32 = 0;
  fiat_p384_mulx_u32(&mut x1499, &mut x1500, x11, (arg2[8]));
  let mut x1501: u32 = 0;
  let mut x1502: u32 = 0;
  fiat_p384_mulx_u32(&mut x1501, &mut x1502, x11, (arg2[7]));
  let mut x1503: u32 = 0;
  let mut x1504: u32 = 0;
  fiat_p384_mulx_u32(&mut x1503, &mut x1504, x11, (arg2[6]));
  let mut x1505: u32 = 0;
  let mut x1506: u32 = 0;
  fiat_p384_mulx_u32(&mut x1505, &mut x1506, x11, (arg2[5]));
  let mut x1507: u32 = 0;
  let mut x1508: u32 = 0;
  fiat_p384_mulx_u32(&mut x1507, &mut x1508, x11, (arg2[4]));
  let mut x1509: u32 = 0;
  let mut x1510: u32 = 0;
  fiat_p384_mulx_u32(&mut x1509, &mut x1510, x11, (arg2[3]));
  let mut x1511: u32 = 0;
  let mut x1512: u32 = 0;
  fiat_p384_mulx_u32(&mut x1511, &mut x1512, x11, (arg2[2]));
  let mut x1513: u32 = 0;
  let mut x1514: u32 = 0;
  fiat_p384_mulx_u32(&mut x1513, &mut x1514, x11, (arg2[1]));
  let mut x1515: u32 = 0;
  let mut x1516: u32 = 0;
  fiat_p384_mulx_u32(&mut x1515, &mut x1516, x11, (arg2[0]));
  let mut x1517: u32 = 0;
  let mut x1518: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1517, &mut x1518, 0x0, x1516, x1513);
  let mut x1519: u32 = 0;
  let mut x1520: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1519, &mut x1520, x1518, x1514, x1511);
  let mut x1521: u32 = 0;
  let mut x1522: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1521, &mut x1522, x1520, x1512, x1509);
  let mut x1523: u32 = 0;
  let mut x1524: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1523, &mut x1524, x1522, x1510, x1507);
  let mut x1525: u32 = 0;
  let mut x1526: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1525, &mut x1526, x1524, x1508, x1505);
  let mut x1527: u32 = 0;
  let mut x1528: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1527, &mut x1528, x1526, x1506, x1503);
  let mut x1529: u32 = 0;
  let mut x1530: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1529, &mut x1530, x1528, x1504, x1501);
  let mut x1531: u32 = 0;
  let mut x1532: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1531, &mut x1532, x1530, x1502, x1499);
  let mut x1533: u32 = 0;
  let mut x1534: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1533, &mut x1534, x1532, x1500, x1497);
  let mut x1535: u32 = 0;
  let mut x1536: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1535, &mut x1536, x1534, x1498, x1495);
  let mut x1537: u32 = 0;
  let mut x1538: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1537, &mut x1538, x1536, x1496, x1493);
  let x1539: u32 = ((x1538 as u32) + x1494);
  let mut x1540: u32 = 0;
  let mut x1541: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1540, &mut x1541, 0x0, x1468, x1515);
  let mut x1542: u32 = 0;
  let mut x1543: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1542, &mut x1543, x1541, x1470, x1517);
  let mut x1544: u32 = 0;
  let mut x1545: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1544, &mut x1545, x1543, x1472, x1519);
  let mut x1546: u32 = 0;
  let mut x1547: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1546, &mut x1547, x1545, x1474, x1521);
  let mut x1548: u32 = 0;
  let mut x1549: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1548, &mut x1549, x1547, x1476, x1523);
  let mut x1550: u32 = 0;
  let mut x1551: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1550, &mut x1551, x1549, x1478, x1525);
  let mut x1552: u32 = 0;
  let mut x1553: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1552, &mut x1553, x1551, x1480, x1527);
  let mut x1554: u32 = 0;
  let mut x1555: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1554, &mut x1555, x1553, x1482, x1529);
  let mut x1556: u32 = 0;
  let mut x1557: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1556, &mut x1557, x1555, x1484, x1531);
  let mut x1558: u32 = 0;
  let mut x1559: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1558, &mut x1559, x1557, x1486, x1533);
  let mut x1560: u32 = 0;
  let mut x1561: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1560, &mut x1561, x1559, x1488, x1535);
  let mut x1562: u32 = 0;
  let mut x1563: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1562, &mut x1563, x1561, x1490, x1537);
  let mut x1564: u32 = 0;
  let mut x1565: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1564, &mut x1565, x1563, x1492, x1539);
  let mut x1566: u32 = 0;
  let mut x1567: u32 = 0;
  fiat_p384_mulx_u32(&mut x1566, &mut x1567, x1540, 0xffffffff);
  let mut x1568: u32 = 0;
  let mut x1569: u32 = 0;
  fiat_p384_mulx_u32(&mut x1568, &mut x1569, x1540, 0xffffffff);
  let mut x1570: u32 = 0;
  let mut x1571: u32 = 0;
  fiat_p384_mulx_u32(&mut x1570, &mut x1571, x1540, 0xffffffff);
  let mut x1572: u32 = 0;
  let mut x1573: u32 = 0;
  fiat_p384_mulx_u32(&mut x1572, &mut x1573, x1540, 0xffffffff);
  let mut x1574: u32 = 0;
  let mut x1575: u32 = 0;
  fiat_p384_mulx_u32(&mut x1574, &mut x1575, x1540, 0xffffffff);
  let mut x1576: u32 = 0;
  let mut x1577: u32 = 0;
  fiat_p384_mulx_u32(&mut x1576, &mut x1577, x1540, 0xffffffff);
  let mut x1578: u32 = 0;
  let mut x1579: u32 = 0;
  fiat_p384_mulx_u32(&mut x1578, &mut x1579, x1540, 0xffffffff);
  let mut x1580: u32 = 0;
  let mut x1581: u32 = 0;
  fiat_p384_mulx_u32(&mut x1580, &mut x1581, x1540, 0xfffffffe);
  let mut x1582: u32 = 0;
  let mut x1583: u32 = 0;
  fiat_p384_mulx_u32(&mut x1582, &mut x1583, x1540, 0xffffffff);
  let mut x1584: u32 = 0;
  let mut x1585: u32 = 0;
  fiat_p384_mulx_u32(&mut x1584, &mut x1585, x1540, 0xffffffff);
  let mut x1586: u32 = 0;
  let mut x1587: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1586, &mut x1587, 0x0, x1583, x1580);
  let mut x1588: u32 = 0;
  let mut x1589: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1588, &mut x1589, x1587, x1581, x1578);
  let mut x1590: u32 = 0;
  let mut x1591: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1590, &mut x1591, x1589, x1579, x1576);
  let mut x1592: u32 = 0;
  let mut x1593: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1592, &mut x1593, x1591, x1577, x1574);
  let mut x1594: u32 = 0;
  let mut x1595: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1594, &mut x1595, x1593, x1575, x1572);
  let mut x1596: u32 = 0;
  let mut x1597: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1596, &mut x1597, x1595, x1573, x1570);
  let mut x1598: u32 = 0;
  let mut x1599: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1598, &mut x1599, x1597, x1571, x1568);
  let mut x1600: u32 = 0;
  let mut x1601: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1600, &mut x1601, x1599, x1569, x1566);
  let x1602: u32 = ((x1601 as u32) + x1567);
  let mut x1603: u32 = 0;
  let mut x1604: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1603, &mut x1604, 0x0, x1540, x1584);
  let mut x1605: u32 = 0;
  let mut x1606: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1605, &mut x1606, x1604, x1542, x1585);
  let mut x1607: u32 = 0;
  let mut x1608: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1607, &mut x1608, x1606, x1544, (0x0 as u32));
  let mut x1609: u32 = 0;
  let mut x1610: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1609, &mut x1610, x1608, x1546, x1582);
  let mut x1611: u32 = 0;
  let mut x1612: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1611, &mut x1612, x1610, x1548, x1586);
  let mut x1613: u32 = 0;
  let mut x1614: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1613, &mut x1614, x1612, x1550, x1588);
  let mut x1615: u32 = 0;
  let mut x1616: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1615, &mut x1616, x1614, x1552, x1590);
  let mut x1617: u32 = 0;
  let mut x1618: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1617, &mut x1618, x1616, x1554, x1592);
  let mut x1619: u32 = 0;
  let mut x1620: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1619, &mut x1620, x1618, x1556, x1594);
  let mut x1621: u32 = 0;
  let mut x1622: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1621, &mut x1622, x1620, x1558, x1596);
  let mut x1623: u32 = 0;
  let mut x1624: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1623, &mut x1624, x1622, x1560, x1598);
  let mut x1625: u32 = 0;
  let mut x1626: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1625, &mut x1626, x1624, x1562, x1600);
  let mut x1627: u32 = 0;
  let mut x1628: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1627, &mut x1628, x1626, x1564, x1602);
  let x1629: u32 = ((x1628 as u32) + (x1565 as u32));
  let mut x1630: u32 = 0;
  let mut x1631: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1630, &mut x1631, 0x0, x1605, 0xffffffff);
  let mut x1632: u32 = 0;
  let mut x1633: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1632, &mut x1633, x1631, x1607, (0x0 as u32));
  let mut x1634: u32 = 0;
  let mut x1635: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1634, &mut x1635, x1633, x1609, (0x0 as u32));
  let mut x1636: u32 = 0;
  let mut x1637: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1636, &mut x1637, x1635, x1611, 0xffffffff);
  let mut x1638: u32 = 0;
  let mut x1639: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1638, &mut x1639, x1637, x1613, 0xfffffffe);
  let mut x1640: u32 = 0;
  let mut x1641: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1640, &mut x1641, x1639, x1615, 0xffffffff);
  let mut x1642: u32 = 0;
  let mut x1643: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1642, &mut x1643, x1641, x1617, 0xffffffff);
  let mut x1644: u32 = 0;
  let mut x1645: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1644, &mut x1645, x1643, x1619, 0xffffffff);
  let mut x1646: u32 = 0;
  let mut x1647: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1646, &mut x1647, x1645, x1621, 0xffffffff);
  let mut x1648: u32 = 0;
  let mut x1649: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1648, &mut x1649, x1647, x1623, 0xffffffff);
  let mut x1650: u32 = 0;
  let mut x1651: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1650, &mut x1651, x1649, x1625, 0xffffffff);
  let mut x1652: u32 = 0;
  let mut x1653: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1652, &mut x1653, x1651, x1627, 0xffffffff);
  let mut x1654: u32 = 0;
  let mut x1655: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1654, &mut x1655, x1653, x1629, (0x0 as u32));
  let mut x1656: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1656, x1655, x1630, x1605);
  let mut x1657: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1657, x1655, x1632, x1607);
  let mut x1658: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1658, x1655, x1634, x1609);
  let mut x1659: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1659, x1655, x1636, x1611);
  let mut x1660: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1660, x1655, x1638, x1613);
  let mut x1661: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1661, x1655, x1640, x1615);
  let mut x1662: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1662, x1655, x1642, x1617);
  let mut x1663: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1663, x1655, x1644, x1619);
  let mut x1664: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1664, x1655, x1646, x1621);
  let mut x1665: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1665, x1655, x1648, x1623);
  let mut x1666: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1666, x1655, x1650, x1625);
  let mut x1667: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1667, x1655, x1652, x1627);
  out1[0] = x1656;
  out1[1] = x1657;
  out1[2] = x1658;
  out1[3] = x1659;
  out1[4] = x1660;
  out1[5] = x1661;
  out1[6] = x1662;
  out1[7] = x1663;
  out1[8] = x1664;
  out1[9] = x1665;
  out1[10] = x1666;
  out1[11] = x1667;
}

/// The function fiat_p384_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_square(out1: &mut fiat_p384_montgomery_domain_field_element, arg1: &fiat_p384_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[8]);
  let x9: u32 = (arg1[9]);
  let x10: u32 = (arg1[10]);
  let x11: u32 = (arg1[11]);
  let x12: u32 = (arg1[0]);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p384_mulx_u32(&mut x13, &mut x14, x12, (arg1[11]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p384_mulx_u32(&mut x15, &mut x16, x12, (arg1[10]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p384_mulx_u32(&mut x17, &mut x18, x12, (arg1[9]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p384_mulx_u32(&mut x19, &mut x20, x12, (arg1[8]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p384_mulx_u32(&mut x21, &mut x22, x12, (arg1[7]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p384_mulx_u32(&mut x23, &mut x24, x12, (arg1[6]));
  let mut x25: u32 = 0;
  let mut x26: u32 = 0;
  fiat_p384_mulx_u32(&mut x25, &mut x26, x12, (arg1[5]));
  let mut x27: u32 = 0;
  let mut x28: u32 = 0;
  fiat_p384_mulx_u32(&mut x27, &mut x28, x12, (arg1[4]));
  let mut x29: u32 = 0;
  let mut x30: u32 = 0;
  fiat_p384_mulx_u32(&mut x29, &mut x30, x12, (arg1[3]));
  let mut x31: u32 = 0;
  let mut x32: u32 = 0;
  fiat_p384_mulx_u32(&mut x31, &mut x32, x12, (arg1[2]));
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p384_mulx_u32(&mut x33, &mut x34, x12, (arg1[1]));
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p384_mulx_u32(&mut x35, &mut x36, x12, (arg1[0]));
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x37, &mut x38, 0x0, x36, x33);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x39, &mut x40, x38, x34, x31);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x41, &mut x42, x40, x32, x29);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x43, &mut x44, x42, x30, x27);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x45, &mut x46, x44, x28, x25);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x47, &mut x48, x46, x26, x23);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x49, &mut x50, x48, x24, x21);
  let mut x51: u32 = 0;
  let mut x52: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x51, &mut x52, x50, x22, x19);
  let mut x53: u32 = 0;
  let mut x54: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x53, &mut x54, x52, x20, x17);
  let mut x55: u32 = 0;
  let mut x56: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x55, &mut x56, x54, x18, x15);
  let mut x57: u32 = 0;
  let mut x58: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x57, &mut x58, x56, x16, x13);
  let x59: u32 = ((x58 as u32) + x14);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_p384_mulx_u32(&mut x60, &mut x61, x35, 0xffffffff);
  let mut x62: u32 = 0;
  let mut x63: u32 = 0;
  fiat_p384_mulx_u32(&mut x62, &mut x63, x35, 0xffffffff);
  let mut x64: u32 = 0;
  let mut x65: u32 = 0;
  fiat_p384_mulx_u32(&mut x64, &mut x65, x35, 0xffffffff);
  let mut x66: u32 = 0;
  let mut x67: u32 = 0;
  fiat_p384_mulx_u32(&mut x66, &mut x67, x35, 0xffffffff);
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_p384_mulx_u32(&mut x68, &mut x69, x35, 0xffffffff);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_p384_mulx_u32(&mut x70, &mut x71, x35, 0xffffffff);
  let mut x72: u32 = 0;
  let mut x73: u32 = 0;
  fiat_p384_mulx_u32(&mut x72, &mut x73, x35, 0xffffffff);
  let mut x74: u32 = 0;
  let mut x75: u32 = 0;
  fiat_p384_mulx_u32(&mut x74, &mut x75, x35, 0xfffffffe);
  let mut x76: u32 = 0;
  let mut x77: u32 = 0;
  fiat_p384_mulx_u32(&mut x76, &mut x77, x35, 0xffffffff);
  let mut x78: u32 = 0;
  let mut x79: u32 = 0;
  fiat_p384_mulx_u32(&mut x78, &mut x79, x35, 0xffffffff);
  let mut x80: u32 = 0;
  let mut x81: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x80, &mut x81, 0x0, x77, x74);
  let mut x82: u32 = 0;
  let mut x83: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x82, &mut x83, x81, x75, x72);
  let mut x84: u32 = 0;
  let mut x85: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x84, &mut x85, x83, x73, x70);
  let mut x86: u32 = 0;
  let mut x87: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x86, &mut x87, x85, x71, x68);
  let mut x88: u32 = 0;
  let mut x89: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x88, &mut x89, x87, x69, x66);
  let mut x90: u32 = 0;
  let mut x91: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x90, &mut x91, x89, x67, x64);
  let mut x92: u32 = 0;
  let mut x93: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x92, &mut x93, x91, x65, x62);
  let mut x94: u32 = 0;
  let mut x95: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x94, &mut x95, x93, x63, x60);
  let x96: u32 = ((x95 as u32) + x61);
  let mut x97: u32 = 0;
  let mut x98: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x97, &mut x98, 0x0, x35, x78);
  let mut x99: u32 = 0;
  let mut x100: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x99, &mut x100, x98, x37, x79);
  let mut x101: u32 = 0;
  let mut x102: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x101, &mut x102, x100, x39, (0x0 as u32));
  let mut x103: u32 = 0;
  let mut x104: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x103, &mut x104, x102, x41, x76);
  let mut x105: u32 = 0;
  let mut x106: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x105, &mut x106, x104, x43, x80);
  let mut x107: u32 = 0;
  let mut x108: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x107, &mut x108, x106, x45, x82);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x109, &mut x110, x108, x47, x84);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x111, &mut x112, x110, x49, x86);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x113, &mut x114, x112, x51, x88);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x115, &mut x116, x114, x53, x90);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x117, &mut x118, x116, x55, x92);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x119, &mut x120, x118, x57, x94);
  let mut x121: u32 = 0;
  let mut x122: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x121, &mut x122, x120, x59, x96);
  let mut x123: u32 = 0;
  let mut x124: u32 = 0;
  fiat_p384_mulx_u32(&mut x123, &mut x124, x1, (arg1[11]));
  let mut x125: u32 = 0;
  let mut x126: u32 = 0;
  fiat_p384_mulx_u32(&mut x125, &mut x126, x1, (arg1[10]));
  let mut x127: u32 = 0;
  let mut x128: u32 = 0;
  fiat_p384_mulx_u32(&mut x127, &mut x128, x1, (arg1[9]));
  let mut x129: u32 = 0;
  let mut x130: u32 = 0;
  fiat_p384_mulx_u32(&mut x129, &mut x130, x1, (arg1[8]));
  let mut x131: u32 = 0;
  let mut x132: u32 = 0;
  fiat_p384_mulx_u32(&mut x131, &mut x132, x1, (arg1[7]));
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_p384_mulx_u32(&mut x133, &mut x134, x1, (arg1[6]));
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p384_mulx_u32(&mut x135, &mut x136, x1, (arg1[5]));
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_p384_mulx_u32(&mut x137, &mut x138, x1, (arg1[4]));
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_p384_mulx_u32(&mut x139, &mut x140, x1, (arg1[3]));
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_p384_mulx_u32(&mut x141, &mut x142, x1, (arg1[2]));
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_p384_mulx_u32(&mut x143, &mut x144, x1, (arg1[1]));
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_p384_mulx_u32(&mut x145, &mut x146, x1, (arg1[0]));
  let mut x147: u32 = 0;
  let mut x148: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x147, &mut x148, 0x0, x146, x143);
  let mut x149: u32 = 0;
  let mut x150: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x149, &mut x150, x148, x144, x141);
  let mut x151: u32 = 0;
  let mut x152: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x151, &mut x152, x150, x142, x139);
  let mut x153: u32 = 0;
  let mut x154: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x153, &mut x154, x152, x140, x137);
  let mut x155: u32 = 0;
  let mut x156: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x155, &mut x156, x154, x138, x135);
  let mut x157: u32 = 0;
  let mut x158: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x157, &mut x158, x156, x136, x133);
  let mut x159: u32 = 0;
  let mut x160: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x159, &mut x160, x158, x134, x131);
  let mut x161: u32 = 0;
  let mut x162: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x161, &mut x162, x160, x132, x129);
  let mut x163: u32 = 0;
  let mut x164: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x163, &mut x164, x162, x130, x127);
  let mut x165: u32 = 0;
  let mut x166: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x165, &mut x166, x164, x128, x125);
  let mut x167: u32 = 0;
  let mut x168: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x167, &mut x168, x166, x126, x123);
  let x169: u32 = ((x168 as u32) + x124);
  let mut x170: u32 = 0;
  let mut x171: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x170, &mut x171, 0x0, x99, x145);
  let mut x172: u32 = 0;
  let mut x173: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x172, &mut x173, x171, x101, x147);
  let mut x174: u32 = 0;
  let mut x175: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x174, &mut x175, x173, x103, x149);
  let mut x176: u32 = 0;
  let mut x177: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x176, &mut x177, x175, x105, x151);
  let mut x178: u32 = 0;
  let mut x179: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x178, &mut x179, x177, x107, x153);
  let mut x180: u32 = 0;
  let mut x181: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x180, &mut x181, x179, x109, x155);
  let mut x182: u32 = 0;
  let mut x183: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x182, &mut x183, x181, x111, x157);
  let mut x184: u32 = 0;
  let mut x185: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x184, &mut x185, x183, x113, x159);
  let mut x186: u32 = 0;
  let mut x187: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x186, &mut x187, x185, x115, x161);
  let mut x188: u32 = 0;
  let mut x189: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x188, &mut x189, x187, x117, x163);
  let mut x190: u32 = 0;
  let mut x191: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x190, &mut x191, x189, x119, x165);
  let mut x192: u32 = 0;
  let mut x193: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x192, &mut x193, x191, x121, x167);
  let mut x194: u32 = 0;
  let mut x195: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x194, &mut x195, x193, (x122 as u32), x169);
  let mut x196: u32 = 0;
  let mut x197: u32 = 0;
  fiat_p384_mulx_u32(&mut x196, &mut x197, x170, 0xffffffff);
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_p384_mulx_u32(&mut x198, &mut x199, x170, 0xffffffff);
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_p384_mulx_u32(&mut x200, &mut x201, x170, 0xffffffff);
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_p384_mulx_u32(&mut x202, &mut x203, x170, 0xffffffff);
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_p384_mulx_u32(&mut x204, &mut x205, x170, 0xffffffff);
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_p384_mulx_u32(&mut x206, &mut x207, x170, 0xffffffff);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_p384_mulx_u32(&mut x208, &mut x209, x170, 0xffffffff);
  let mut x210: u32 = 0;
  let mut x211: u32 = 0;
  fiat_p384_mulx_u32(&mut x210, &mut x211, x170, 0xfffffffe);
  let mut x212: u32 = 0;
  let mut x213: u32 = 0;
  fiat_p384_mulx_u32(&mut x212, &mut x213, x170, 0xffffffff);
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_p384_mulx_u32(&mut x214, &mut x215, x170, 0xffffffff);
  let mut x216: u32 = 0;
  let mut x217: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x216, &mut x217, 0x0, x213, x210);
  let mut x218: u32 = 0;
  let mut x219: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x218, &mut x219, x217, x211, x208);
  let mut x220: u32 = 0;
  let mut x221: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x220, &mut x221, x219, x209, x206);
  let mut x222: u32 = 0;
  let mut x223: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x222, &mut x223, x221, x207, x204);
  let mut x224: u32 = 0;
  let mut x225: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x224, &mut x225, x223, x205, x202);
  let mut x226: u32 = 0;
  let mut x227: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x226, &mut x227, x225, x203, x200);
  let mut x228: u32 = 0;
  let mut x229: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x228, &mut x229, x227, x201, x198);
  let mut x230: u32 = 0;
  let mut x231: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x230, &mut x231, x229, x199, x196);
  let x232: u32 = ((x231 as u32) + x197);
  let mut x233: u32 = 0;
  let mut x234: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x233, &mut x234, 0x0, x170, x214);
  let mut x235: u32 = 0;
  let mut x236: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x235, &mut x236, x234, x172, x215);
  let mut x237: u32 = 0;
  let mut x238: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x237, &mut x238, x236, x174, (0x0 as u32));
  let mut x239: u32 = 0;
  let mut x240: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x239, &mut x240, x238, x176, x212);
  let mut x241: u32 = 0;
  let mut x242: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x241, &mut x242, x240, x178, x216);
  let mut x243: u32 = 0;
  let mut x244: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x243, &mut x244, x242, x180, x218);
  let mut x245: u32 = 0;
  let mut x246: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x245, &mut x246, x244, x182, x220);
  let mut x247: u32 = 0;
  let mut x248: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x247, &mut x248, x246, x184, x222);
  let mut x249: u32 = 0;
  let mut x250: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x249, &mut x250, x248, x186, x224);
  let mut x251: u32 = 0;
  let mut x252: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x251, &mut x252, x250, x188, x226);
  let mut x253: u32 = 0;
  let mut x254: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x253, &mut x254, x252, x190, x228);
  let mut x255: u32 = 0;
  let mut x256: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x255, &mut x256, x254, x192, x230);
  let mut x257: u32 = 0;
  let mut x258: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x257, &mut x258, x256, x194, x232);
  let x259: u32 = ((x258 as u32) + (x195 as u32));
  let mut x260: u32 = 0;
  let mut x261: u32 = 0;
  fiat_p384_mulx_u32(&mut x260, &mut x261, x2, (arg1[11]));
  let mut x262: u32 = 0;
  let mut x263: u32 = 0;
  fiat_p384_mulx_u32(&mut x262, &mut x263, x2, (arg1[10]));
  let mut x264: u32 = 0;
  let mut x265: u32 = 0;
  fiat_p384_mulx_u32(&mut x264, &mut x265, x2, (arg1[9]));
  let mut x266: u32 = 0;
  let mut x267: u32 = 0;
  fiat_p384_mulx_u32(&mut x266, &mut x267, x2, (arg1[8]));
  let mut x268: u32 = 0;
  let mut x269: u32 = 0;
  fiat_p384_mulx_u32(&mut x268, &mut x269, x2, (arg1[7]));
  let mut x270: u32 = 0;
  let mut x271: u32 = 0;
  fiat_p384_mulx_u32(&mut x270, &mut x271, x2, (arg1[6]));
  let mut x272: u32 = 0;
  let mut x273: u32 = 0;
  fiat_p384_mulx_u32(&mut x272, &mut x273, x2, (arg1[5]));
  let mut x274: u32 = 0;
  let mut x275: u32 = 0;
  fiat_p384_mulx_u32(&mut x274, &mut x275, x2, (arg1[4]));
  let mut x276: u32 = 0;
  let mut x277: u32 = 0;
  fiat_p384_mulx_u32(&mut x276, &mut x277, x2, (arg1[3]));
  let mut x278: u32 = 0;
  let mut x279: u32 = 0;
  fiat_p384_mulx_u32(&mut x278, &mut x279, x2, (arg1[2]));
  let mut x280: u32 = 0;
  let mut x281: u32 = 0;
  fiat_p384_mulx_u32(&mut x280, &mut x281, x2, (arg1[1]));
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_p384_mulx_u32(&mut x282, &mut x283, x2, (arg1[0]));
  let mut x284: u32 = 0;
  let mut x285: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x284, &mut x285, 0x0, x283, x280);
  let mut x286: u32 = 0;
  let mut x287: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x286, &mut x287, x285, x281, x278);
  let mut x288: u32 = 0;
  let mut x289: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x288, &mut x289, x287, x279, x276);
  let mut x290: u32 = 0;
  let mut x291: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x290, &mut x291, x289, x277, x274);
  let mut x292: u32 = 0;
  let mut x293: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x292, &mut x293, x291, x275, x272);
  let mut x294: u32 = 0;
  let mut x295: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x294, &mut x295, x293, x273, x270);
  let mut x296: u32 = 0;
  let mut x297: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x296, &mut x297, x295, x271, x268);
  let mut x298: u32 = 0;
  let mut x299: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x298, &mut x299, x297, x269, x266);
  let mut x300: u32 = 0;
  let mut x301: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x300, &mut x301, x299, x267, x264);
  let mut x302: u32 = 0;
  let mut x303: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x302, &mut x303, x301, x265, x262);
  let mut x304: u32 = 0;
  let mut x305: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x304, &mut x305, x303, x263, x260);
  let x306: u32 = ((x305 as u32) + x261);
  let mut x307: u32 = 0;
  let mut x308: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x307, &mut x308, 0x0, x235, x282);
  let mut x309: u32 = 0;
  let mut x310: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x309, &mut x310, x308, x237, x284);
  let mut x311: u32 = 0;
  let mut x312: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x311, &mut x312, x310, x239, x286);
  let mut x313: u32 = 0;
  let mut x314: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x313, &mut x314, x312, x241, x288);
  let mut x315: u32 = 0;
  let mut x316: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x315, &mut x316, x314, x243, x290);
  let mut x317: u32 = 0;
  let mut x318: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x317, &mut x318, x316, x245, x292);
  let mut x319: u32 = 0;
  let mut x320: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x319, &mut x320, x318, x247, x294);
  let mut x321: u32 = 0;
  let mut x322: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x321, &mut x322, x320, x249, x296);
  let mut x323: u32 = 0;
  let mut x324: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x323, &mut x324, x322, x251, x298);
  let mut x325: u32 = 0;
  let mut x326: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x325, &mut x326, x324, x253, x300);
  let mut x327: u32 = 0;
  let mut x328: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x327, &mut x328, x326, x255, x302);
  let mut x329: u32 = 0;
  let mut x330: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x329, &mut x330, x328, x257, x304);
  let mut x331: u32 = 0;
  let mut x332: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x331, &mut x332, x330, x259, x306);
  let mut x333: u32 = 0;
  let mut x334: u32 = 0;
  fiat_p384_mulx_u32(&mut x333, &mut x334, x307, 0xffffffff);
  let mut x335: u32 = 0;
  let mut x336: u32 = 0;
  fiat_p384_mulx_u32(&mut x335, &mut x336, x307, 0xffffffff);
  let mut x337: u32 = 0;
  let mut x338: u32 = 0;
  fiat_p384_mulx_u32(&mut x337, &mut x338, x307, 0xffffffff);
  let mut x339: u32 = 0;
  let mut x340: u32 = 0;
  fiat_p384_mulx_u32(&mut x339, &mut x340, x307, 0xffffffff);
  let mut x341: u32 = 0;
  let mut x342: u32 = 0;
  fiat_p384_mulx_u32(&mut x341, &mut x342, x307, 0xffffffff);
  let mut x343: u32 = 0;
  let mut x344: u32 = 0;
  fiat_p384_mulx_u32(&mut x343, &mut x344, x307, 0xffffffff);
  let mut x345: u32 = 0;
  let mut x346: u32 = 0;
  fiat_p384_mulx_u32(&mut x345, &mut x346, x307, 0xffffffff);
  let mut x347: u32 = 0;
  let mut x348: u32 = 0;
  fiat_p384_mulx_u32(&mut x347, &mut x348, x307, 0xfffffffe);
  let mut x349: u32 = 0;
  let mut x350: u32 = 0;
  fiat_p384_mulx_u32(&mut x349, &mut x350, x307, 0xffffffff);
  let mut x351: u32 = 0;
  let mut x352: u32 = 0;
  fiat_p384_mulx_u32(&mut x351, &mut x352, x307, 0xffffffff);
  let mut x353: u32 = 0;
  let mut x354: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x353, &mut x354, 0x0, x350, x347);
  let mut x355: u32 = 0;
  let mut x356: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x355, &mut x356, x354, x348, x345);
  let mut x357: u32 = 0;
  let mut x358: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x357, &mut x358, x356, x346, x343);
  let mut x359: u32 = 0;
  let mut x360: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x359, &mut x360, x358, x344, x341);
  let mut x361: u32 = 0;
  let mut x362: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x361, &mut x362, x360, x342, x339);
  let mut x363: u32 = 0;
  let mut x364: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x363, &mut x364, x362, x340, x337);
  let mut x365: u32 = 0;
  let mut x366: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x365, &mut x366, x364, x338, x335);
  let mut x367: u32 = 0;
  let mut x368: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x367, &mut x368, x366, x336, x333);
  let x369: u32 = ((x368 as u32) + x334);
  let mut x370: u32 = 0;
  let mut x371: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x370, &mut x371, 0x0, x307, x351);
  let mut x372: u32 = 0;
  let mut x373: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x372, &mut x373, x371, x309, x352);
  let mut x374: u32 = 0;
  let mut x375: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x374, &mut x375, x373, x311, (0x0 as u32));
  let mut x376: u32 = 0;
  let mut x377: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x376, &mut x377, x375, x313, x349);
  let mut x378: u32 = 0;
  let mut x379: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x378, &mut x379, x377, x315, x353);
  let mut x380: u32 = 0;
  let mut x381: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x380, &mut x381, x379, x317, x355);
  let mut x382: u32 = 0;
  let mut x383: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x382, &mut x383, x381, x319, x357);
  let mut x384: u32 = 0;
  let mut x385: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x384, &mut x385, x383, x321, x359);
  let mut x386: u32 = 0;
  let mut x387: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x386, &mut x387, x385, x323, x361);
  let mut x388: u32 = 0;
  let mut x389: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x388, &mut x389, x387, x325, x363);
  let mut x390: u32 = 0;
  let mut x391: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x390, &mut x391, x389, x327, x365);
  let mut x392: u32 = 0;
  let mut x393: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x392, &mut x393, x391, x329, x367);
  let mut x394: u32 = 0;
  let mut x395: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x394, &mut x395, x393, x331, x369);
  let x396: u32 = ((x395 as u32) + (x332 as u32));
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_p384_mulx_u32(&mut x397, &mut x398, x3, (arg1[11]));
  let mut x399: u32 = 0;
  let mut x400: u32 = 0;
  fiat_p384_mulx_u32(&mut x399, &mut x400, x3, (arg1[10]));
  let mut x401: u32 = 0;
  let mut x402: u32 = 0;
  fiat_p384_mulx_u32(&mut x401, &mut x402, x3, (arg1[9]));
  let mut x403: u32 = 0;
  let mut x404: u32 = 0;
  fiat_p384_mulx_u32(&mut x403, &mut x404, x3, (arg1[8]));
  let mut x405: u32 = 0;
  let mut x406: u32 = 0;
  fiat_p384_mulx_u32(&mut x405, &mut x406, x3, (arg1[7]));
  let mut x407: u32 = 0;
  let mut x408: u32 = 0;
  fiat_p384_mulx_u32(&mut x407, &mut x408, x3, (arg1[6]));
  let mut x409: u32 = 0;
  let mut x410: u32 = 0;
  fiat_p384_mulx_u32(&mut x409, &mut x410, x3, (arg1[5]));
  let mut x411: u32 = 0;
  let mut x412: u32 = 0;
  fiat_p384_mulx_u32(&mut x411, &mut x412, x3, (arg1[4]));
  let mut x413: u32 = 0;
  let mut x414: u32 = 0;
  fiat_p384_mulx_u32(&mut x413, &mut x414, x3, (arg1[3]));
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_p384_mulx_u32(&mut x415, &mut x416, x3, (arg1[2]));
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_p384_mulx_u32(&mut x417, &mut x418, x3, (arg1[1]));
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_p384_mulx_u32(&mut x419, &mut x420, x3, (arg1[0]));
  let mut x421: u32 = 0;
  let mut x422: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x421, &mut x422, 0x0, x420, x417);
  let mut x423: u32 = 0;
  let mut x424: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x423, &mut x424, x422, x418, x415);
  let mut x425: u32 = 0;
  let mut x426: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x425, &mut x426, x424, x416, x413);
  let mut x427: u32 = 0;
  let mut x428: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x427, &mut x428, x426, x414, x411);
  let mut x429: u32 = 0;
  let mut x430: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x429, &mut x430, x428, x412, x409);
  let mut x431: u32 = 0;
  let mut x432: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x431, &mut x432, x430, x410, x407);
  let mut x433: u32 = 0;
  let mut x434: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x433, &mut x434, x432, x408, x405);
  let mut x435: u32 = 0;
  let mut x436: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x435, &mut x436, x434, x406, x403);
  let mut x437: u32 = 0;
  let mut x438: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x437, &mut x438, x436, x404, x401);
  let mut x439: u32 = 0;
  let mut x440: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x439, &mut x440, x438, x402, x399);
  let mut x441: u32 = 0;
  let mut x442: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x441, &mut x442, x440, x400, x397);
  let x443: u32 = ((x442 as u32) + x398);
  let mut x444: u32 = 0;
  let mut x445: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x444, &mut x445, 0x0, x372, x419);
  let mut x446: u32 = 0;
  let mut x447: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x446, &mut x447, x445, x374, x421);
  let mut x448: u32 = 0;
  let mut x449: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x448, &mut x449, x447, x376, x423);
  let mut x450: u32 = 0;
  let mut x451: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x450, &mut x451, x449, x378, x425);
  let mut x452: u32 = 0;
  let mut x453: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x452, &mut x453, x451, x380, x427);
  let mut x454: u32 = 0;
  let mut x455: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x454, &mut x455, x453, x382, x429);
  let mut x456: u32 = 0;
  let mut x457: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x456, &mut x457, x455, x384, x431);
  let mut x458: u32 = 0;
  let mut x459: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x458, &mut x459, x457, x386, x433);
  let mut x460: u32 = 0;
  let mut x461: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x460, &mut x461, x459, x388, x435);
  let mut x462: u32 = 0;
  let mut x463: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x462, &mut x463, x461, x390, x437);
  let mut x464: u32 = 0;
  let mut x465: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x464, &mut x465, x463, x392, x439);
  let mut x466: u32 = 0;
  let mut x467: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x466, &mut x467, x465, x394, x441);
  let mut x468: u32 = 0;
  let mut x469: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x468, &mut x469, x467, x396, x443);
  let mut x470: u32 = 0;
  let mut x471: u32 = 0;
  fiat_p384_mulx_u32(&mut x470, &mut x471, x444, 0xffffffff);
  let mut x472: u32 = 0;
  let mut x473: u32 = 0;
  fiat_p384_mulx_u32(&mut x472, &mut x473, x444, 0xffffffff);
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_p384_mulx_u32(&mut x474, &mut x475, x444, 0xffffffff);
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_p384_mulx_u32(&mut x476, &mut x477, x444, 0xffffffff);
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_p384_mulx_u32(&mut x478, &mut x479, x444, 0xffffffff);
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_p384_mulx_u32(&mut x480, &mut x481, x444, 0xffffffff);
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_p384_mulx_u32(&mut x482, &mut x483, x444, 0xffffffff);
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_p384_mulx_u32(&mut x484, &mut x485, x444, 0xfffffffe);
  let mut x486: u32 = 0;
  let mut x487: u32 = 0;
  fiat_p384_mulx_u32(&mut x486, &mut x487, x444, 0xffffffff);
  let mut x488: u32 = 0;
  let mut x489: u32 = 0;
  fiat_p384_mulx_u32(&mut x488, &mut x489, x444, 0xffffffff);
  let mut x490: u32 = 0;
  let mut x491: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x490, &mut x491, 0x0, x487, x484);
  let mut x492: u32 = 0;
  let mut x493: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x492, &mut x493, x491, x485, x482);
  let mut x494: u32 = 0;
  let mut x495: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x494, &mut x495, x493, x483, x480);
  let mut x496: u32 = 0;
  let mut x497: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x496, &mut x497, x495, x481, x478);
  let mut x498: u32 = 0;
  let mut x499: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x498, &mut x499, x497, x479, x476);
  let mut x500: u32 = 0;
  let mut x501: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x500, &mut x501, x499, x477, x474);
  let mut x502: u32 = 0;
  let mut x503: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x502, &mut x503, x501, x475, x472);
  let mut x504: u32 = 0;
  let mut x505: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x504, &mut x505, x503, x473, x470);
  let x506: u32 = ((x505 as u32) + x471);
  let mut x507: u32 = 0;
  let mut x508: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x507, &mut x508, 0x0, x444, x488);
  let mut x509: u32 = 0;
  let mut x510: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x509, &mut x510, x508, x446, x489);
  let mut x511: u32 = 0;
  let mut x512: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x511, &mut x512, x510, x448, (0x0 as u32));
  let mut x513: u32 = 0;
  let mut x514: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x513, &mut x514, x512, x450, x486);
  let mut x515: u32 = 0;
  let mut x516: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x515, &mut x516, x514, x452, x490);
  let mut x517: u32 = 0;
  let mut x518: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x517, &mut x518, x516, x454, x492);
  let mut x519: u32 = 0;
  let mut x520: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x519, &mut x520, x518, x456, x494);
  let mut x521: u32 = 0;
  let mut x522: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x521, &mut x522, x520, x458, x496);
  let mut x523: u32 = 0;
  let mut x524: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x523, &mut x524, x522, x460, x498);
  let mut x525: u32 = 0;
  let mut x526: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x525, &mut x526, x524, x462, x500);
  let mut x527: u32 = 0;
  let mut x528: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x527, &mut x528, x526, x464, x502);
  let mut x529: u32 = 0;
  let mut x530: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x529, &mut x530, x528, x466, x504);
  let mut x531: u32 = 0;
  let mut x532: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x531, &mut x532, x530, x468, x506);
  let x533: u32 = ((x532 as u32) + (x469 as u32));
  let mut x534: u32 = 0;
  let mut x535: u32 = 0;
  fiat_p384_mulx_u32(&mut x534, &mut x535, x4, (arg1[11]));
  let mut x536: u32 = 0;
  let mut x537: u32 = 0;
  fiat_p384_mulx_u32(&mut x536, &mut x537, x4, (arg1[10]));
  let mut x538: u32 = 0;
  let mut x539: u32 = 0;
  fiat_p384_mulx_u32(&mut x538, &mut x539, x4, (arg1[9]));
  let mut x540: u32 = 0;
  let mut x541: u32 = 0;
  fiat_p384_mulx_u32(&mut x540, &mut x541, x4, (arg1[8]));
  let mut x542: u32 = 0;
  let mut x543: u32 = 0;
  fiat_p384_mulx_u32(&mut x542, &mut x543, x4, (arg1[7]));
  let mut x544: u32 = 0;
  let mut x545: u32 = 0;
  fiat_p384_mulx_u32(&mut x544, &mut x545, x4, (arg1[6]));
  let mut x546: u32 = 0;
  let mut x547: u32 = 0;
  fiat_p384_mulx_u32(&mut x546, &mut x547, x4, (arg1[5]));
  let mut x548: u32 = 0;
  let mut x549: u32 = 0;
  fiat_p384_mulx_u32(&mut x548, &mut x549, x4, (arg1[4]));
  let mut x550: u32 = 0;
  let mut x551: u32 = 0;
  fiat_p384_mulx_u32(&mut x550, &mut x551, x4, (arg1[3]));
  let mut x552: u32 = 0;
  let mut x553: u32 = 0;
  fiat_p384_mulx_u32(&mut x552, &mut x553, x4, (arg1[2]));
  let mut x554: u32 = 0;
  let mut x555: u32 = 0;
  fiat_p384_mulx_u32(&mut x554, &mut x555, x4, (arg1[1]));
  let mut x556: u32 = 0;
  let mut x557: u32 = 0;
  fiat_p384_mulx_u32(&mut x556, &mut x557, x4, (arg1[0]));
  let mut x558: u32 = 0;
  let mut x559: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x558, &mut x559, 0x0, x557, x554);
  let mut x560: u32 = 0;
  let mut x561: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x560, &mut x561, x559, x555, x552);
  let mut x562: u32 = 0;
  let mut x563: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x562, &mut x563, x561, x553, x550);
  let mut x564: u32 = 0;
  let mut x565: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x564, &mut x565, x563, x551, x548);
  let mut x566: u32 = 0;
  let mut x567: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x566, &mut x567, x565, x549, x546);
  let mut x568: u32 = 0;
  let mut x569: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x568, &mut x569, x567, x547, x544);
  let mut x570: u32 = 0;
  let mut x571: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x570, &mut x571, x569, x545, x542);
  let mut x572: u32 = 0;
  let mut x573: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x572, &mut x573, x571, x543, x540);
  let mut x574: u32 = 0;
  let mut x575: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x574, &mut x575, x573, x541, x538);
  let mut x576: u32 = 0;
  let mut x577: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x576, &mut x577, x575, x539, x536);
  let mut x578: u32 = 0;
  let mut x579: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x578, &mut x579, x577, x537, x534);
  let x580: u32 = ((x579 as u32) + x535);
  let mut x581: u32 = 0;
  let mut x582: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x581, &mut x582, 0x0, x509, x556);
  let mut x583: u32 = 0;
  let mut x584: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x583, &mut x584, x582, x511, x558);
  let mut x585: u32 = 0;
  let mut x586: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x585, &mut x586, x584, x513, x560);
  let mut x587: u32 = 0;
  let mut x588: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x587, &mut x588, x586, x515, x562);
  let mut x589: u32 = 0;
  let mut x590: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x589, &mut x590, x588, x517, x564);
  let mut x591: u32 = 0;
  let mut x592: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x591, &mut x592, x590, x519, x566);
  let mut x593: u32 = 0;
  let mut x594: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x593, &mut x594, x592, x521, x568);
  let mut x595: u32 = 0;
  let mut x596: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x595, &mut x596, x594, x523, x570);
  let mut x597: u32 = 0;
  let mut x598: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x597, &mut x598, x596, x525, x572);
  let mut x599: u32 = 0;
  let mut x600: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x599, &mut x600, x598, x527, x574);
  let mut x601: u32 = 0;
  let mut x602: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x601, &mut x602, x600, x529, x576);
  let mut x603: u32 = 0;
  let mut x604: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x603, &mut x604, x602, x531, x578);
  let mut x605: u32 = 0;
  let mut x606: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x605, &mut x606, x604, x533, x580);
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_p384_mulx_u32(&mut x607, &mut x608, x581, 0xffffffff);
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_p384_mulx_u32(&mut x609, &mut x610, x581, 0xffffffff);
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_p384_mulx_u32(&mut x611, &mut x612, x581, 0xffffffff);
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_p384_mulx_u32(&mut x613, &mut x614, x581, 0xffffffff);
  let mut x615: u32 = 0;
  let mut x616: u32 = 0;
  fiat_p384_mulx_u32(&mut x615, &mut x616, x581, 0xffffffff);
  let mut x617: u32 = 0;
  let mut x618: u32 = 0;
  fiat_p384_mulx_u32(&mut x617, &mut x618, x581, 0xffffffff);
  let mut x619: u32 = 0;
  let mut x620: u32 = 0;
  fiat_p384_mulx_u32(&mut x619, &mut x620, x581, 0xffffffff);
  let mut x621: u32 = 0;
  let mut x622: u32 = 0;
  fiat_p384_mulx_u32(&mut x621, &mut x622, x581, 0xfffffffe);
  let mut x623: u32 = 0;
  let mut x624: u32 = 0;
  fiat_p384_mulx_u32(&mut x623, &mut x624, x581, 0xffffffff);
  let mut x625: u32 = 0;
  let mut x626: u32 = 0;
  fiat_p384_mulx_u32(&mut x625, &mut x626, x581, 0xffffffff);
  let mut x627: u32 = 0;
  let mut x628: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x627, &mut x628, 0x0, x624, x621);
  let mut x629: u32 = 0;
  let mut x630: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x629, &mut x630, x628, x622, x619);
  let mut x631: u32 = 0;
  let mut x632: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x631, &mut x632, x630, x620, x617);
  let mut x633: u32 = 0;
  let mut x634: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x633, &mut x634, x632, x618, x615);
  let mut x635: u32 = 0;
  let mut x636: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x635, &mut x636, x634, x616, x613);
  let mut x637: u32 = 0;
  let mut x638: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x637, &mut x638, x636, x614, x611);
  let mut x639: u32 = 0;
  let mut x640: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x639, &mut x640, x638, x612, x609);
  let mut x641: u32 = 0;
  let mut x642: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x641, &mut x642, x640, x610, x607);
  let x643: u32 = ((x642 as u32) + x608);
  let mut x644: u32 = 0;
  let mut x645: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x644, &mut x645, 0x0, x581, x625);
  let mut x646: u32 = 0;
  let mut x647: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x646, &mut x647, x645, x583, x626);
  let mut x648: u32 = 0;
  let mut x649: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x648, &mut x649, x647, x585, (0x0 as u32));
  let mut x650: u32 = 0;
  let mut x651: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x650, &mut x651, x649, x587, x623);
  let mut x652: u32 = 0;
  let mut x653: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x652, &mut x653, x651, x589, x627);
  let mut x654: u32 = 0;
  let mut x655: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x654, &mut x655, x653, x591, x629);
  let mut x656: u32 = 0;
  let mut x657: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x656, &mut x657, x655, x593, x631);
  let mut x658: u32 = 0;
  let mut x659: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x658, &mut x659, x657, x595, x633);
  let mut x660: u32 = 0;
  let mut x661: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x660, &mut x661, x659, x597, x635);
  let mut x662: u32 = 0;
  let mut x663: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x662, &mut x663, x661, x599, x637);
  let mut x664: u32 = 0;
  let mut x665: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x664, &mut x665, x663, x601, x639);
  let mut x666: u32 = 0;
  let mut x667: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x666, &mut x667, x665, x603, x641);
  let mut x668: u32 = 0;
  let mut x669: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x668, &mut x669, x667, x605, x643);
  let x670: u32 = ((x669 as u32) + (x606 as u32));
  let mut x671: u32 = 0;
  let mut x672: u32 = 0;
  fiat_p384_mulx_u32(&mut x671, &mut x672, x5, (arg1[11]));
  let mut x673: u32 = 0;
  let mut x674: u32 = 0;
  fiat_p384_mulx_u32(&mut x673, &mut x674, x5, (arg1[10]));
  let mut x675: u32 = 0;
  let mut x676: u32 = 0;
  fiat_p384_mulx_u32(&mut x675, &mut x676, x5, (arg1[9]));
  let mut x677: u32 = 0;
  let mut x678: u32 = 0;
  fiat_p384_mulx_u32(&mut x677, &mut x678, x5, (arg1[8]));
  let mut x679: u32 = 0;
  let mut x680: u32 = 0;
  fiat_p384_mulx_u32(&mut x679, &mut x680, x5, (arg1[7]));
  let mut x681: u32 = 0;
  let mut x682: u32 = 0;
  fiat_p384_mulx_u32(&mut x681, &mut x682, x5, (arg1[6]));
  let mut x683: u32 = 0;
  let mut x684: u32 = 0;
  fiat_p384_mulx_u32(&mut x683, &mut x684, x5, (arg1[5]));
  let mut x685: u32 = 0;
  let mut x686: u32 = 0;
  fiat_p384_mulx_u32(&mut x685, &mut x686, x5, (arg1[4]));
  let mut x687: u32 = 0;
  let mut x688: u32 = 0;
  fiat_p384_mulx_u32(&mut x687, &mut x688, x5, (arg1[3]));
  let mut x689: u32 = 0;
  let mut x690: u32 = 0;
  fiat_p384_mulx_u32(&mut x689, &mut x690, x5, (arg1[2]));
  let mut x691: u32 = 0;
  let mut x692: u32 = 0;
  fiat_p384_mulx_u32(&mut x691, &mut x692, x5, (arg1[1]));
  let mut x693: u32 = 0;
  let mut x694: u32 = 0;
  fiat_p384_mulx_u32(&mut x693, &mut x694, x5, (arg1[0]));
  let mut x695: u32 = 0;
  let mut x696: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x695, &mut x696, 0x0, x694, x691);
  let mut x697: u32 = 0;
  let mut x698: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x697, &mut x698, x696, x692, x689);
  let mut x699: u32 = 0;
  let mut x700: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x699, &mut x700, x698, x690, x687);
  let mut x701: u32 = 0;
  let mut x702: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x701, &mut x702, x700, x688, x685);
  let mut x703: u32 = 0;
  let mut x704: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x703, &mut x704, x702, x686, x683);
  let mut x705: u32 = 0;
  let mut x706: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x705, &mut x706, x704, x684, x681);
  let mut x707: u32 = 0;
  let mut x708: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x707, &mut x708, x706, x682, x679);
  let mut x709: u32 = 0;
  let mut x710: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x709, &mut x710, x708, x680, x677);
  let mut x711: u32 = 0;
  let mut x712: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x711, &mut x712, x710, x678, x675);
  let mut x713: u32 = 0;
  let mut x714: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x713, &mut x714, x712, x676, x673);
  let mut x715: u32 = 0;
  let mut x716: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x715, &mut x716, x714, x674, x671);
  let x717: u32 = ((x716 as u32) + x672);
  let mut x718: u32 = 0;
  let mut x719: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x718, &mut x719, 0x0, x646, x693);
  let mut x720: u32 = 0;
  let mut x721: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x720, &mut x721, x719, x648, x695);
  let mut x722: u32 = 0;
  let mut x723: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x722, &mut x723, x721, x650, x697);
  let mut x724: u32 = 0;
  let mut x725: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x724, &mut x725, x723, x652, x699);
  let mut x726: u32 = 0;
  let mut x727: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x726, &mut x727, x725, x654, x701);
  let mut x728: u32 = 0;
  let mut x729: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x728, &mut x729, x727, x656, x703);
  let mut x730: u32 = 0;
  let mut x731: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x730, &mut x731, x729, x658, x705);
  let mut x732: u32 = 0;
  let mut x733: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x732, &mut x733, x731, x660, x707);
  let mut x734: u32 = 0;
  let mut x735: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x734, &mut x735, x733, x662, x709);
  let mut x736: u32 = 0;
  let mut x737: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x736, &mut x737, x735, x664, x711);
  let mut x738: u32 = 0;
  let mut x739: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x738, &mut x739, x737, x666, x713);
  let mut x740: u32 = 0;
  let mut x741: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x740, &mut x741, x739, x668, x715);
  let mut x742: u32 = 0;
  let mut x743: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x742, &mut x743, x741, x670, x717);
  let mut x744: u32 = 0;
  let mut x745: u32 = 0;
  fiat_p384_mulx_u32(&mut x744, &mut x745, x718, 0xffffffff);
  let mut x746: u32 = 0;
  let mut x747: u32 = 0;
  fiat_p384_mulx_u32(&mut x746, &mut x747, x718, 0xffffffff);
  let mut x748: u32 = 0;
  let mut x749: u32 = 0;
  fiat_p384_mulx_u32(&mut x748, &mut x749, x718, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: u32 = 0;
  fiat_p384_mulx_u32(&mut x750, &mut x751, x718, 0xffffffff);
  let mut x752: u32 = 0;
  let mut x753: u32 = 0;
  fiat_p384_mulx_u32(&mut x752, &mut x753, x718, 0xffffffff);
  let mut x754: u32 = 0;
  let mut x755: u32 = 0;
  fiat_p384_mulx_u32(&mut x754, &mut x755, x718, 0xffffffff);
  let mut x756: u32 = 0;
  let mut x757: u32 = 0;
  fiat_p384_mulx_u32(&mut x756, &mut x757, x718, 0xffffffff);
  let mut x758: u32 = 0;
  let mut x759: u32 = 0;
  fiat_p384_mulx_u32(&mut x758, &mut x759, x718, 0xfffffffe);
  let mut x760: u32 = 0;
  let mut x761: u32 = 0;
  fiat_p384_mulx_u32(&mut x760, &mut x761, x718, 0xffffffff);
  let mut x762: u32 = 0;
  let mut x763: u32 = 0;
  fiat_p384_mulx_u32(&mut x762, &mut x763, x718, 0xffffffff);
  let mut x764: u32 = 0;
  let mut x765: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x764, &mut x765, 0x0, x761, x758);
  let mut x766: u32 = 0;
  let mut x767: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x766, &mut x767, x765, x759, x756);
  let mut x768: u32 = 0;
  let mut x769: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x768, &mut x769, x767, x757, x754);
  let mut x770: u32 = 0;
  let mut x771: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x770, &mut x771, x769, x755, x752);
  let mut x772: u32 = 0;
  let mut x773: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x772, &mut x773, x771, x753, x750);
  let mut x774: u32 = 0;
  let mut x775: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x774, &mut x775, x773, x751, x748);
  let mut x776: u32 = 0;
  let mut x777: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x776, &mut x777, x775, x749, x746);
  let mut x778: u32 = 0;
  let mut x779: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x778, &mut x779, x777, x747, x744);
  let x780: u32 = ((x779 as u32) + x745);
  let mut x781: u32 = 0;
  let mut x782: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x781, &mut x782, 0x0, x718, x762);
  let mut x783: u32 = 0;
  let mut x784: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x783, &mut x784, x782, x720, x763);
  let mut x785: u32 = 0;
  let mut x786: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x785, &mut x786, x784, x722, (0x0 as u32));
  let mut x787: u32 = 0;
  let mut x788: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x787, &mut x788, x786, x724, x760);
  let mut x789: u32 = 0;
  let mut x790: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x789, &mut x790, x788, x726, x764);
  let mut x791: u32 = 0;
  let mut x792: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x791, &mut x792, x790, x728, x766);
  let mut x793: u32 = 0;
  let mut x794: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x793, &mut x794, x792, x730, x768);
  let mut x795: u32 = 0;
  let mut x796: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x795, &mut x796, x794, x732, x770);
  let mut x797: u32 = 0;
  let mut x798: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x797, &mut x798, x796, x734, x772);
  let mut x799: u32 = 0;
  let mut x800: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x799, &mut x800, x798, x736, x774);
  let mut x801: u32 = 0;
  let mut x802: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x801, &mut x802, x800, x738, x776);
  let mut x803: u32 = 0;
  let mut x804: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x803, &mut x804, x802, x740, x778);
  let mut x805: u32 = 0;
  let mut x806: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x805, &mut x806, x804, x742, x780);
  let x807: u32 = ((x806 as u32) + (x743 as u32));
  let mut x808: u32 = 0;
  let mut x809: u32 = 0;
  fiat_p384_mulx_u32(&mut x808, &mut x809, x6, (arg1[11]));
  let mut x810: u32 = 0;
  let mut x811: u32 = 0;
  fiat_p384_mulx_u32(&mut x810, &mut x811, x6, (arg1[10]));
  let mut x812: u32 = 0;
  let mut x813: u32 = 0;
  fiat_p384_mulx_u32(&mut x812, &mut x813, x6, (arg1[9]));
  let mut x814: u32 = 0;
  let mut x815: u32 = 0;
  fiat_p384_mulx_u32(&mut x814, &mut x815, x6, (arg1[8]));
  let mut x816: u32 = 0;
  let mut x817: u32 = 0;
  fiat_p384_mulx_u32(&mut x816, &mut x817, x6, (arg1[7]));
  let mut x818: u32 = 0;
  let mut x819: u32 = 0;
  fiat_p384_mulx_u32(&mut x818, &mut x819, x6, (arg1[6]));
  let mut x820: u32 = 0;
  let mut x821: u32 = 0;
  fiat_p384_mulx_u32(&mut x820, &mut x821, x6, (arg1[5]));
  let mut x822: u32 = 0;
  let mut x823: u32 = 0;
  fiat_p384_mulx_u32(&mut x822, &mut x823, x6, (arg1[4]));
  let mut x824: u32 = 0;
  let mut x825: u32 = 0;
  fiat_p384_mulx_u32(&mut x824, &mut x825, x6, (arg1[3]));
  let mut x826: u32 = 0;
  let mut x827: u32 = 0;
  fiat_p384_mulx_u32(&mut x826, &mut x827, x6, (arg1[2]));
  let mut x828: u32 = 0;
  let mut x829: u32 = 0;
  fiat_p384_mulx_u32(&mut x828, &mut x829, x6, (arg1[1]));
  let mut x830: u32 = 0;
  let mut x831: u32 = 0;
  fiat_p384_mulx_u32(&mut x830, &mut x831, x6, (arg1[0]));
  let mut x832: u32 = 0;
  let mut x833: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x832, &mut x833, 0x0, x831, x828);
  let mut x834: u32 = 0;
  let mut x835: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x834, &mut x835, x833, x829, x826);
  let mut x836: u32 = 0;
  let mut x837: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x836, &mut x837, x835, x827, x824);
  let mut x838: u32 = 0;
  let mut x839: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x838, &mut x839, x837, x825, x822);
  let mut x840: u32 = 0;
  let mut x841: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x840, &mut x841, x839, x823, x820);
  let mut x842: u32 = 0;
  let mut x843: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x842, &mut x843, x841, x821, x818);
  let mut x844: u32 = 0;
  let mut x845: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x844, &mut x845, x843, x819, x816);
  let mut x846: u32 = 0;
  let mut x847: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x846, &mut x847, x845, x817, x814);
  let mut x848: u32 = 0;
  let mut x849: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x848, &mut x849, x847, x815, x812);
  let mut x850: u32 = 0;
  let mut x851: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x850, &mut x851, x849, x813, x810);
  let mut x852: u32 = 0;
  let mut x853: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x852, &mut x853, x851, x811, x808);
  let x854: u32 = ((x853 as u32) + x809);
  let mut x855: u32 = 0;
  let mut x856: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x855, &mut x856, 0x0, x783, x830);
  let mut x857: u32 = 0;
  let mut x858: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x857, &mut x858, x856, x785, x832);
  let mut x859: u32 = 0;
  let mut x860: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x859, &mut x860, x858, x787, x834);
  let mut x861: u32 = 0;
  let mut x862: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x861, &mut x862, x860, x789, x836);
  let mut x863: u32 = 0;
  let mut x864: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x863, &mut x864, x862, x791, x838);
  let mut x865: u32 = 0;
  let mut x866: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x865, &mut x866, x864, x793, x840);
  let mut x867: u32 = 0;
  let mut x868: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x867, &mut x868, x866, x795, x842);
  let mut x869: u32 = 0;
  let mut x870: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x869, &mut x870, x868, x797, x844);
  let mut x871: u32 = 0;
  let mut x872: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x871, &mut x872, x870, x799, x846);
  let mut x873: u32 = 0;
  let mut x874: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x873, &mut x874, x872, x801, x848);
  let mut x875: u32 = 0;
  let mut x876: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x875, &mut x876, x874, x803, x850);
  let mut x877: u32 = 0;
  let mut x878: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x877, &mut x878, x876, x805, x852);
  let mut x879: u32 = 0;
  let mut x880: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x879, &mut x880, x878, x807, x854);
  let mut x881: u32 = 0;
  let mut x882: u32 = 0;
  fiat_p384_mulx_u32(&mut x881, &mut x882, x855, 0xffffffff);
  let mut x883: u32 = 0;
  let mut x884: u32 = 0;
  fiat_p384_mulx_u32(&mut x883, &mut x884, x855, 0xffffffff);
  let mut x885: u32 = 0;
  let mut x886: u32 = 0;
  fiat_p384_mulx_u32(&mut x885, &mut x886, x855, 0xffffffff);
  let mut x887: u32 = 0;
  let mut x888: u32 = 0;
  fiat_p384_mulx_u32(&mut x887, &mut x888, x855, 0xffffffff);
  let mut x889: u32 = 0;
  let mut x890: u32 = 0;
  fiat_p384_mulx_u32(&mut x889, &mut x890, x855, 0xffffffff);
  let mut x891: u32 = 0;
  let mut x892: u32 = 0;
  fiat_p384_mulx_u32(&mut x891, &mut x892, x855, 0xffffffff);
  let mut x893: u32 = 0;
  let mut x894: u32 = 0;
  fiat_p384_mulx_u32(&mut x893, &mut x894, x855, 0xffffffff);
  let mut x895: u32 = 0;
  let mut x896: u32 = 0;
  fiat_p384_mulx_u32(&mut x895, &mut x896, x855, 0xfffffffe);
  let mut x897: u32 = 0;
  let mut x898: u32 = 0;
  fiat_p384_mulx_u32(&mut x897, &mut x898, x855, 0xffffffff);
  let mut x899: u32 = 0;
  let mut x900: u32 = 0;
  fiat_p384_mulx_u32(&mut x899, &mut x900, x855, 0xffffffff);
  let mut x901: u32 = 0;
  let mut x902: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x901, &mut x902, 0x0, x898, x895);
  let mut x903: u32 = 0;
  let mut x904: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x903, &mut x904, x902, x896, x893);
  let mut x905: u32 = 0;
  let mut x906: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x905, &mut x906, x904, x894, x891);
  let mut x907: u32 = 0;
  let mut x908: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x907, &mut x908, x906, x892, x889);
  let mut x909: u32 = 0;
  let mut x910: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x909, &mut x910, x908, x890, x887);
  let mut x911: u32 = 0;
  let mut x912: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x911, &mut x912, x910, x888, x885);
  let mut x913: u32 = 0;
  let mut x914: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x913, &mut x914, x912, x886, x883);
  let mut x915: u32 = 0;
  let mut x916: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x915, &mut x916, x914, x884, x881);
  let x917: u32 = ((x916 as u32) + x882);
  let mut x918: u32 = 0;
  let mut x919: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x918, &mut x919, 0x0, x855, x899);
  let mut x920: u32 = 0;
  let mut x921: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x920, &mut x921, x919, x857, x900);
  let mut x922: u32 = 0;
  let mut x923: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x922, &mut x923, x921, x859, (0x0 as u32));
  let mut x924: u32 = 0;
  let mut x925: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x924, &mut x925, x923, x861, x897);
  let mut x926: u32 = 0;
  let mut x927: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x926, &mut x927, x925, x863, x901);
  let mut x928: u32 = 0;
  let mut x929: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x928, &mut x929, x927, x865, x903);
  let mut x930: u32 = 0;
  let mut x931: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x930, &mut x931, x929, x867, x905);
  let mut x932: u32 = 0;
  let mut x933: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x932, &mut x933, x931, x869, x907);
  let mut x934: u32 = 0;
  let mut x935: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x934, &mut x935, x933, x871, x909);
  let mut x936: u32 = 0;
  let mut x937: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x936, &mut x937, x935, x873, x911);
  let mut x938: u32 = 0;
  let mut x939: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x938, &mut x939, x937, x875, x913);
  let mut x940: u32 = 0;
  let mut x941: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x940, &mut x941, x939, x877, x915);
  let mut x942: u32 = 0;
  let mut x943: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x942, &mut x943, x941, x879, x917);
  let x944: u32 = ((x943 as u32) + (x880 as u32));
  let mut x945: u32 = 0;
  let mut x946: u32 = 0;
  fiat_p384_mulx_u32(&mut x945, &mut x946, x7, (arg1[11]));
  let mut x947: u32 = 0;
  let mut x948: u32 = 0;
  fiat_p384_mulx_u32(&mut x947, &mut x948, x7, (arg1[10]));
  let mut x949: u32 = 0;
  let mut x950: u32 = 0;
  fiat_p384_mulx_u32(&mut x949, &mut x950, x7, (arg1[9]));
  let mut x951: u32 = 0;
  let mut x952: u32 = 0;
  fiat_p384_mulx_u32(&mut x951, &mut x952, x7, (arg1[8]));
  let mut x953: u32 = 0;
  let mut x954: u32 = 0;
  fiat_p384_mulx_u32(&mut x953, &mut x954, x7, (arg1[7]));
  let mut x955: u32 = 0;
  let mut x956: u32 = 0;
  fiat_p384_mulx_u32(&mut x955, &mut x956, x7, (arg1[6]));
  let mut x957: u32 = 0;
  let mut x958: u32 = 0;
  fiat_p384_mulx_u32(&mut x957, &mut x958, x7, (arg1[5]));
  let mut x959: u32 = 0;
  let mut x960: u32 = 0;
  fiat_p384_mulx_u32(&mut x959, &mut x960, x7, (arg1[4]));
  let mut x961: u32 = 0;
  let mut x962: u32 = 0;
  fiat_p384_mulx_u32(&mut x961, &mut x962, x7, (arg1[3]));
  let mut x963: u32 = 0;
  let mut x964: u32 = 0;
  fiat_p384_mulx_u32(&mut x963, &mut x964, x7, (arg1[2]));
  let mut x965: u32 = 0;
  let mut x966: u32 = 0;
  fiat_p384_mulx_u32(&mut x965, &mut x966, x7, (arg1[1]));
  let mut x967: u32 = 0;
  let mut x968: u32 = 0;
  fiat_p384_mulx_u32(&mut x967, &mut x968, x7, (arg1[0]));
  let mut x969: u32 = 0;
  let mut x970: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x969, &mut x970, 0x0, x968, x965);
  let mut x971: u32 = 0;
  let mut x972: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x971, &mut x972, x970, x966, x963);
  let mut x973: u32 = 0;
  let mut x974: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x973, &mut x974, x972, x964, x961);
  let mut x975: u32 = 0;
  let mut x976: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x975, &mut x976, x974, x962, x959);
  let mut x977: u32 = 0;
  let mut x978: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x977, &mut x978, x976, x960, x957);
  let mut x979: u32 = 0;
  let mut x980: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x979, &mut x980, x978, x958, x955);
  let mut x981: u32 = 0;
  let mut x982: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x981, &mut x982, x980, x956, x953);
  let mut x983: u32 = 0;
  let mut x984: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x983, &mut x984, x982, x954, x951);
  let mut x985: u32 = 0;
  let mut x986: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x985, &mut x986, x984, x952, x949);
  let mut x987: u32 = 0;
  let mut x988: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x987, &mut x988, x986, x950, x947);
  let mut x989: u32 = 0;
  let mut x990: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x989, &mut x990, x988, x948, x945);
  let x991: u32 = ((x990 as u32) + x946);
  let mut x992: u32 = 0;
  let mut x993: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x992, &mut x993, 0x0, x920, x967);
  let mut x994: u32 = 0;
  let mut x995: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x994, &mut x995, x993, x922, x969);
  let mut x996: u32 = 0;
  let mut x997: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x996, &mut x997, x995, x924, x971);
  let mut x998: u32 = 0;
  let mut x999: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x998, &mut x999, x997, x926, x973);
  let mut x1000: u32 = 0;
  let mut x1001: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1000, &mut x1001, x999, x928, x975);
  let mut x1002: u32 = 0;
  let mut x1003: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1002, &mut x1003, x1001, x930, x977);
  let mut x1004: u32 = 0;
  let mut x1005: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1004, &mut x1005, x1003, x932, x979);
  let mut x1006: u32 = 0;
  let mut x1007: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1006, &mut x1007, x1005, x934, x981);
  let mut x1008: u32 = 0;
  let mut x1009: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1008, &mut x1009, x1007, x936, x983);
  let mut x1010: u32 = 0;
  let mut x1011: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1010, &mut x1011, x1009, x938, x985);
  let mut x1012: u32 = 0;
  let mut x1013: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1012, &mut x1013, x1011, x940, x987);
  let mut x1014: u32 = 0;
  let mut x1015: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1014, &mut x1015, x1013, x942, x989);
  let mut x1016: u32 = 0;
  let mut x1017: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1016, &mut x1017, x1015, x944, x991);
  let mut x1018: u32 = 0;
  let mut x1019: u32 = 0;
  fiat_p384_mulx_u32(&mut x1018, &mut x1019, x992, 0xffffffff);
  let mut x1020: u32 = 0;
  let mut x1021: u32 = 0;
  fiat_p384_mulx_u32(&mut x1020, &mut x1021, x992, 0xffffffff);
  let mut x1022: u32 = 0;
  let mut x1023: u32 = 0;
  fiat_p384_mulx_u32(&mut x1022, &mut x1023, x992, 0xffffffff);
  let mut x1024: u32 = 0;
  let mut x1025: u32 = 0;
  fiat_p384_mulx_u32(&mut x1024, &mut x1025, x992, 0xffffffff);
  let mut x1026: u32 = 0;
  let mut x1027: u32 = 0;
  fiat_p384_mulx_u32(&mut x1026, &mut x1027, x992, 0xffffffff);
  let mut x1028: u32 = 0;
  let mut x1029: u32 = 0;
  fiat_p384_mulx_u32(&mut x1028, &mut x1029, x992, 0xffffffff);
  let mut x1030: u32 = 0;
  let mut x1031: u32 = 0;
  fiat_p384_mulx_u32(&mut x1030, &mut x1031, x992, 0xffffffff);
  let mut x1032: u32 = 0;
  let mut x1033: u32 = 0;
  fiat_p384_mulx_u32(&mut x1032, &mut x1033, x992, 0xfffffffe);
  let mut x1034: u32 = 0;
  let mut x1035: u32 = 0;
  fiat_p384_mulx_u32(&mut x1034, &mut x1035, x992, 0xffffffff);
  let mut x1036: u32 = 0;
  let mut x1037: u32 = 0;
  fiat_p384_mulx_u32(&mut x1036, &mut x1037, x992, 0xffffffff);
  let mut x1038: u32 = 0;
  let mut x1039: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1038, &mut x1039, 0x0, x1035, x1032);
  let mut x1040: u32 = 0;
  let mut x1041: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1040, &mut x1041, x1039, x1033, x1030);
  let mut x1042: u32 = 0;
  let mut x1043: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1042, &mut x1043, x1041, x1031, x1028);
  let mut x1044: u32 = 0;
  let mut x1045: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1044, &mut x1045, x1043, x1029, x1026);
  let mut x1046: u32 = 0;
  let mut x1047: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1046, &mut x1047, x1045, x1027, x1024);
  let mut x1048: u32 = 0;
  let mut x1049: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1048, &mut x1049, x1047, x1025, x1022);
  let mut x1050: u32 = 0;
  let mut x1051: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1050, &mut x1051, x1049, x1023, x1020);
  let mut x1052: u32 = 0;
  let mut x1053: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1052, &mut x1053, x1051, x1021, x1018);
  let x1054: u32 = ((x1053 as u32) + x1019);
  let mut x1055: u32 = 0;
  let mut x1056: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1055, &mut x1056, 0x0, x992, x1036);
  let mut x1057: u32 = 0;
  let mut x1058: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1057, &mut x1058, x1056, x994, x1037);
  let mut x1059: u32 = 0;
  let mut x1060: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1059, &mut x1060, x1058, x996, (0x0 as u32));
  let mut x1061: u32 = 0;
  let mut x1062: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1061, &mut x1062, x1060, x998, x1034);
  let mut x1063: u32 = 0;
  let mut x1064: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1063, &mut x1064, x1062, x1000, x1038);
  let mut x1065: u32 = 0;
  let mut x1066: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1065, &mut x1066, x1064, x1002, x1040);
  let mut x1067: u32 = 0;
  let mut x1068: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1067, &mut x1068, x1066, x1004, x1042);
  let mut x1069: u32 = 0;
  let mut x1070: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1069, &mut x1070, x1068, x1006, x1044);
  let mut x1071: u32 = 0;
  let mut x1072: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1071, &mut x1072, x1070, x1008, x1046);
  let mut x1073: u32 = 0;
  let mut x1074: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1073, &mut x1074, x1072, x1010, x1048);
  let mut x1075: u32 = 0;
  let mut x1076: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1075, &mut x1076, x1074, x1012, x1050);
  let mut x1077: u32 = 0;
  let mut x1078: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1077, &mut x1078, x1076, x1014, x1052);
  let mut x1079: u32 = 0;
  let mut x1080: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1079, &mut x1080, x1078, x1016, x1054);
  let x1081: u32 = ((x1080 as u32) + (x1017 as u32));
  let mut x1082: u32 = 0;
  let mut x1083: u32 = 0;
  fiat_p384_mulx_u32(&mut x1082, &mut x1083, x8, (arg1[11]));
  let mut x1084: u32 = 0;
  let mut x1085: u32 = 0;
  fiat_p384_mulx_u32(&mut x1084, &mut x1085, x8, (arg1[10]));
  let mut x1086: u32 = 0;
  let mut x1087: u32 = 0;
  fiat_p384_mulx_u32(&mut x1086, &mut x1087, x8, (arg1[9]));
  let mut x1088: u32 = 0;
  let mut x1089: u32 = 0;
  fiat_p384_mulx_u32(&mut x1088, &mut x1089, x8, (arg1[8]));
  let mut x1090: u32 = 0;
  let mut x1091: u32 = 0;
  fiat_p384_mulx_u32(&mut x1090, &mut x1091, x8, (arg1[7]));
  let mut x1092: u32 = 0;
  let mut x1093: u32 = 0;
  fiat_p384_mulx_u32(&mut x1092, &mut x1093, x8, (arg1[6]));
  let mut x1094: u32 = 0;
  let mut x1095: u32 = 0;
  fiat_p384_mulx_u32(&mut x1094, &mut x1095, x8, (arg1[5]));
  let mut x1096: u32 = 0;
  let mut x1097: u32 = 0;
  fiat_p384_mulx_u32(&mut x1096, &mut x1097, x8, (arg1[4]));
  let mut x1098: u32 = 0;
  let mut x1099: u32 = 0;
  fiat_p384_mulx_u32(&mut x1098, &mut x1099, x8, (arg1[3]));
  let mut x1100: u32 = 0;
  let mut x1101: u32 = 0;
  fiat_p384_mulx_u32(&mut x1100, &mut x1101, x8, (arg1[2]));
  let mut x1102: u32 = 0;
  let mut x1103: u32 = 0;
  fiat_p384_mulx_u32(&mut x1102, &mut x1103, x8, (arg1[1]));
  let mut x1104: u32 = 0;
  let mut x1105: u32 = 0;
  fiat_p384_mulx_u32(&mut x1104, &mut x1105, x8, (arg1[0]));
  let mut x1106: u32 = 0;
  let mut x1107: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1106, &mut x1107, 0x0, x1105, x1102);
  let mut x1108: u32 = 0;
  let mut x1109: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1108, &mut x1109, x1107, x1103, x1100);
  let mut x1110: u32 = 0;
  let mut x1111: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1110, &mut x1111, x1109, x1101, x1098);
  let mut x1112: u32 = 0;
  let mut x1113: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1112, &mut x1113, x1111, x1099, x1096);
  let mut x1114: u32 = 0;
  let mut x1115: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1114, &mut x1115, x1113, x1097, x1094);
  let mut x1116: u32 = 0;
  let mut x1117: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1116, &mut x1117, x1115, x1095, x1092);
  let mut x1118: u32 = 0;
  let mut x1119: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1118, &mut x1119, x1117, x1093, x1090);
  let mut x1120: u32 = 0;
  let mut x1121: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1120, &mut x1121, x1119, x1091, x1088);
  let mut x1122: u32 = 0;
  let mut x1123: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1122, &mut x1123, x1121, x1089, x1086);
  let mut x1124: u32 = 0;
  let mut x1125: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1124, &mut x1125, x1123, x1087, x1084);
  let mut x1126: u32 = 0;
  let mut x1127: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1126, &mut x1127, x1125, x1085, x1082);
  let x1128: u32 = ((x1127 as u32) + x1083);
  let mut x1129: u32 = 0;
  let mut x1130: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1129, &mut x1130, 0x0, x1057, x1104);
  let mut x1131: u32 = 0;
  let mut x1132: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1131, &mut x1132, x1130, x1059, x1106);
  let mut x1133: u32 = 0;
  let mut x1134: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1133, &mut x1134, x1132, x1061, x1108);
  let mut x1135: u32 = 0;
  let mut x1136: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1135, &mut x1136, x1134, x1063, x1110);
  let mut x1137: u32 = 0;
  let mut x1138: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1137, &mut x1138, x1136, x1065, x1112);
  let mut x1139: u32 = 0;
  let mut x1140: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1139, &mut x1140, x1138, x1067, x1114);
  let mut x1141: u32 = 0;
  let mut x1142: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1141, &mut x1142, x1140, x1069, x1116);
  let mut x1143: u32 = 0;
  let mut x1144: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1143, &mut x1144, x1142, x1071, x1118);
  let mut x1145: u32 = 0;
  let mut x1146: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1145, &mut x1146, x1144, x1073, x1120);
  let mut x1147: u32 = 0;
  let mut x1148: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1147, &mut x1148, x1146, x1075, x1122);
  let mut x1149: u32 = 0;
  let mut x1150: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1149, &mut x1150, x1148, x1077, x1124);
  let mut x1151: u32 = 0;
  let mut x1152: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1151, &mut x1152, x1150, x1079, x1126);
  let mut x1153: u32 = 0;
  let mut x1154: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1153, &mut x1154, x1152, x1081, x1128);
  let mut x1155: u32 = 0;
  let mut x1156: u32 = 0;
  fiat_p384_mulx_u32(&mut x1155, &mut x1156, x1129, 0xffffffff);
  let mut x1157: u32 = 0;
  let mut x1158: u32 = 0;
  fiat_p384_mulx_u32(&mut x1157, &mut x1158, x1129, 0xffffffff);
  let mut x1159: u32 = 0;
  let mut x1160: u32 = 0;
  fiat_p384_mulx_u32(&mut x1159, &mut x1160, x1129, 0xffffffff);
  let mut x1161: u32 = 0;
  let mut x1162: u32 = 0;
  fiat_p384_mulx_u32(&mut x1161, &mut x1162, x1129, 0xffffffff);
  let mut x1163: u32 = 0;
  let mut x1164: u32 = 0;
  fiat_p384_mulx_u32(&mut x1163, &mut x1164, x1129, 0xffffffff);
  let mut x1165: u32 = 0;
  let mut x1166: u32 = 0;
  fiat_p384_mulx_u32(&mut x1165, &mut x1166, x1129, 0xffffffff);
  let mut x1167: u32 = 0;
  let mut x1168: u32 = 0;
  fiat_p384_mulx_u32(&mut x1167, &mut x1168, x1129, 0xffffffff);
  let mut x1169: u32 = 0;
  let mut x1170: u32 = 0;
  fiat_p384_mulx_u32(&mut x1169, &mut x1170, x1129, 0xfffffffe);
  let mut x1171: u32 = 0;
  let mut x1172: u32 = 0;
  fiat_p384_mulx_u32(&mut x1171, &mut x1172, x1129, 0xffffffff);
  let mut x1173: u32 = 0;
  let mut x1174: u32 = 0;
  fiat_p384_mulx_u32(&mut x1173, &mut x1174, x1129, 0xffffffff);
  let mut x1175: u32 = 0;
  let mut x1176: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1175, &mut x1176, 0x0, x1172, x1169);
  let mut x1177: u32 = 0;
  let mut x1178: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1177, &mut x1178, x1176, x1170, x1167);
  let mut x1179: u32 = 0;
  let mut x1180: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1179, &mut x1180, x1178, x1168, x1165);
  let mut x1181: u32 = 0;
  let mut x1182: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1181, &mut x1182, x1180, x1166, x1163);
  let mut x1183: u32 = 0;
  let mut x1184: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1183, &mut x1184, x1182, x1164, x1161);
  let mut x1185: u32 = 0;
  let mut x1186: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1185, &mut x1186, x1184, x1162, x1159);
  let mut x1187: u32 = 0;
  let mut x1188: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1187, &mut x1188, x1186, x1160, x1157);
  let mut x1189: u32 = 0;
  let mut x1190: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1189, &mut x1190, x1188, x1158, x1155);
  let x1191: u32 = ((x1190 as u32) + x1156);
  let mut x1192: u32 = 0;
  let mut x1193: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1192, &mut x1193, 0x0, x1129, x1173);
  let mut x1194: u32 = 0;
  let mut x1195: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1194, &mut x1195, x1193, x1131, x1174);
  let mut x1196: u32 = 0;
  let mut x1197: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1196, &mut x1197, x1195, x1133, (0x0 as u32));
  let mut x1198: u32 = 0;
  let mut x1199: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1198, &mut x1199, x1197, x1135, x1171);
  let mut x1200: u32 = 0;
  let mut x1201: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1200, &mut x1201, x1199, x1137, x1175);
  let mut x1202: u32 = 0;
  let mut x1203: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1202, &mut x1203, x1201, x1139, x1177);
  let mut x1204: u32 = 0;
  let mut x1205: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1204, &mut x1205, x1203, x1141, x1179);
  let mut x1206: u32 = 0;
  let mut x1207: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1206, &mut x1207, x1205, x1143, x1181);
  let mut x1208: u32 = 0;
  let mut x1209: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1208, &mut x1209, x1207, x1145, x1183);
  let mut x1210: u32 = 0;
  let mut x1211: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1210, &mut x1211, x1209, x1147, x1185);
  let mut x1212: u32 = 0;
  let mut x1213: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1212, &mut x1213, x1211, x1149, x1187);
  let mut x1214: u32 = 0;
  let mut x1215: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1214, &mut x1215, x1213, x1151, x1189);
  let mut x1216: u32 = 0;
  let mut x1217: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1216, &mut x1217, x1215, x1153, x1191);
  let x1218: u32 = ((x1217 as u32) + (x1154 as u32));
  let mut x1219: u32 = 0;
  let mut x1220: u32 = 0;
  fiat_p384_mulx_u32(&mut x1219, &mut x1220, x9, (arg1[11]));
  let mut x1221: u32 = 0;
  let mut x1222: u32 = 0;
  fiat_p384_mulx_u32(&mut x1221, &mut x1222, x9, (arg1[10]));
  let mut x1223: u32 = 0;
  let mut x1224: u32 = 0;
  fiat_p384_mulx_u32(&mut x1223, &mut x1224, x9, (arg1[9]));
  let mut x1225: u32 = 0;
  let mut x1226: u32 = 0;
  fiat_p384_mulx_u32(&mut x1225, &mut x1226, x9, (arg1[8]));
  let mut x1227: u32 = 0;
  let mut x1228: u32 = 0;
  fiat_p384_mulx_u32(&mut x1227, &mut x1228, x9, (arg1[7]));
  let mut x1229: u32 = 0;
  let mut x1230: u32 = 0;
  fiat_p384_mulx_u32(&mut x1229, &mut x1230, x9, (arg1[6]));
  let mut x1231: u32 = 0;
  let mut x1232: u32 = 0;
  fiat_p384_mulx_u32(&mut x1231, &mut x1232, x9, (arg1[5]));
  let mut x1233: u32 = 0;
  let mut x1234: u32 = 0;
  fiat_p384_mulx_u32(&mut x1233, &mut x1234, x9, (arg1[4]));
  let mut x1235: u32 = 0;
  let mut x1236: u32 = 0;
  fiat_p384_mulx_u32(&mut x1235, &mut x1236, x9, (arg1[3]));
  let mut x1237: u32 = 0;
  let mut x1238: u32 = 0;
  fiat_p384_mulx_u32(&mut x1237, &mut x1238, x9, (arg1[2]));
  let mut x1239: u32 = 0;
  let mut x1240: u32 = 0;
  fiat_p384_mulx_u32(&mut x1239, &mut x1240, x9, (arg1[1]));
  let mut x1241: u32 = 0;
  let mut x1242: u32 = 0;
  fiat_p384_mulx_u32(&mut x1241, &mut x1242, x9, (arg1[0]));
  let mut x1243: u32 = 0;
  let mut x1244: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1243, &mut x1244, 0x0, x1242, x1239);
  let mut x1245: u32 = 0;
  let mut x1246: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1245, &mut x1246, x1244, x1240, x1237);
  let mut x1247: u32 = 0;
  let mut x1248: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1247, &mut x1248, x1246, x1238, x1235);
  let mut x1249: u32 = 0;
  let mut x1250: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1249, &mut x1250, x1248, x1236, x1233);
  let mut x1251: u32 = 0;
  let mut x1252: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1251, &mut x1252, x1250, x1234, x1231);
  let mut x1253: u32 = 0;
  let mut x1254: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1253, &mut x1254, x1252, x1232, x1229);
  let mut x1255: u32 = 0;
  let mut x1256: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1255, &mut x1256, x1254, x1230, x1227);
  let mut x1257: u32 = 0;
  let mut x1258: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1257, &mut x1258, x1256, x1228, x1225);
  let mut x1259: u32 = 0;
  let mut x1260: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1259, &mut x1260, x1258, x1226, x1223);
  let mut x1261: u32 = 0;
  let mut x1262: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1261, &mut x1262, x1260, x1224, x1221);
  let mut x1263: u32 = 0;
  let mut x1264: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1263, &mut x1264, x1262, x1222, x1219);
  let x1265: u32 = ((x1264 as u32) + x1220);
  let mut x1266: u32 = 0;
  let mut x1267: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1266, &mut x1267, 0x0, x1194, x1241);
  let mut x1268: u32 = 0;
  let mut x1269: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1268, &mut x1269, x1267, x1196, x1243);
  let mut x1270: u32 = 0;
  let mut x1271: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1270, &mut x1271, x1269, x1198, x1245);
  let mut x1272: u32 = 0;
  let mut x1273: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1272, &mut x1273, x1271, x1200, x1247);
  let mut x1274: u32 = 0;
  let mut x1275: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1274, &mut x1275, x1273, x1202, x1249);
  let mut x1276: u32 = 0;
  let mut x1277: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1276, &mut x1277, x1275, x1204, x1251);
  let mut x1278: u32 = 0;
  let mut x1279: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1278, &mut x1279, x1277, x1206, x1253);
  let mut x1280: u32 = 0;
  let mut x1281: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1280, &mut x1281, x1279, x1208, x1255);
  let mut x1282: u32 = 0;
  let mut x1283: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1282, &mut x1283, x1281, x1210, x1257);
  let mut x1284: u32 = 0;
  let mut x1285: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1284, &mut x1285, x1283, x1212, x1259);
  let mut x1286: u32 = 0;
  let mut x1287: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1286, &mut x1287, x1285, x1214, x1261);
  let mut x1288: u32 = 0;
  let mut x1289: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1288, &mut x1289, x1287, x1216, x1263);
  let mut x1290: u32 = 0;
  let mut x1291: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1290, &mut x1291, x1289, x1218, x1265);
  let mut x1292: u32 = 0;
  let mut x1293: u32 = 0;
  fiat_p384_mulx_u32(&mut x1292, &mut x1293, x1266, 0xffffffff);
  let mut x1294: u32 = 0;
  let mut x1295: u32 = 0;
  fiat_p384_mulx_u32(&mut x1294, &mut x1295, x1266, 0xffffffff);
  let mut x1296: u32 = 0;
  let mut x1297: u32 = 0;
  fiat_p384_mulx_u32(&mut x1296, &mut x1297, x1266, 0xffffffff);
  let mut x1298: u32 = 0;
  let mut x1299: u32 = 0;
  fiat_p384_mulx_u32(&mut x1298, &mut x1299, x1266, 0xffffffff);
  let mut x1300: u32 = 0;
  let mut x1301: u32 = 0;
  fiat_p384_mulx_u32(&mut x1300, &mut x1301, x1266, 0xffffffff);
  let mut x1302: u32 = 0;
  let mut x1303: u32 = 0;
  fiat_p384_mulx_u32(&mut x1302, &mut x1303, x1266, 0xffffffff);
  let mut x1304: u32 = 0;
  let mut x1305: u32 = 0;
  fiat_p384_mulx_u32(&mut x1304, &mut x1305, x1266, 0xffffffff);
  let mut x1306: u32 = 0;
  let mut x1307: u32 = 0;
  fiat_p384_mulx_u32(&mut x1306, &mut x1307, x1266, 0xfffffffe);
  let mut x1308: u32 = 0;
  let mut x1309: u32 = 0;
  fiat_p384_mulx_u32(&mut x1308, &mut x1309, x1266, 0xffffffff);
  let mut x1310: u32 = 0;
  let mut x1311: u32 = 0;
  fiat_p384_mulx_u32(&mut x1310, &mut x1311, x1266, 0xffffffff);
  let mut x1312: u32 = 0;
  let mut x1313: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1312, &mut x1313, 0x0, x1309, x1306);
  let mut x1314: u32 = 0;
  let mut x1315: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1314, &mut x1315, x1313, x1307, x1304);
  let mut x1316: u32 = 0;
  let mut x1317: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1316, &mut x1317, x1315, x1305, x1302);
  let mut x1318: u32 = 0;
  let mut x1319: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1318, &mut x1319, x1317, x1303, x1300);
  let mut x1320: u32 = 0;
  let mut x1321: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1320, &mut x1321, x1319, x1301, x1298);
  let mut x1322: u32 = 0;
  let mut x1323: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1322, &mut x1323, x1321, x1299, x1296);
  let mut x1324: u32 = 0;
  let mut x1325: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1324, &mut x1325, x1323, x1297, x1294);
  let mut x1326: u32 = 0;
  let mut x1327: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1326, &mut x1327, x1325, x1295, x1292);
  let x1328: u32 = ((x1327 as u32) + x1293);
  let mut x1329: u32 = 0;
  let mut x1330: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1329, &mut x1330, 0x0, x1266, x1310);
  let mut x1331: u32 = 0;
  let mut x1332: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1331, &mut x1332, x1330, x1268, x1311);
  let mut x1333: u32 = 0;
  let mut x1334: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1333, &mut x1334, x1332, x1270, (0x0 as u32));
  let mut x1335: u32 = 0;
  let mut x1336: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1335, &mut x1336, x1334, x1272, x1308);
  let mut x1337: u32 = 0;
  let mut x1338: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1337, &mut x1338, x1336, x1274, x1312);
  let mut x1339: u32 = 0;
  let mut x1340: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1339, &mut x1340, x1338, x1276, x1314);
  let mut x1341: u32 = 0;
  let mut x1342: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1341, &mut x1342, x1340, x1278, x1316);
  let mut x1343: u32 = 0;
  let mut x1344: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1343, &mut x1344, x1342, x1280, x1318);
  let mut x1345: u32 = 0;
  let mut x1346: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1345, &mut x1346, x1344, x1282, x1320);
  let mut x1347: u32 = 0;
  let mut x1348: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1347, &mut x1348, x1346, x1284, x1322);
  let mut x1349: u32 = 0;
  let mut x1350: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1349, &mut x1350, x1348, x1286, x1324);
  let mut x1351: u32 = 0;
  let mut x1352: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1351, &mut x1352, x1350, x1288, x1326);
  let mut x1353: u32 = 0;
  let mut x1354: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1353, &mut x1354, x1352, x1290, x1328);
  let x1355: u32 = ((x1354 as u32) + (x1291 as u32));
  let mut x1356: u32 = 0;
  let mut x1357: u32 = 0;
  fiat_p384_mulx_u32(&mut x1356, &mut x1357, x10, (arg1[11]));
  let mut x1358: u32 = 0;
  let mut x1359: u32 = 0;
  fiat_p384_mulx_u32(&mut x1358, &mut x1359, x10, (arg1[10]));
  let mut x1360: u32 = 0;
  let mut x1361: u32 = 0;
  fiat_p384_mulx_u32(&mut x1360, &mut x1361, x10, (arg1[9]));
  let mut x1362: u32 = 0;
  let mut x1363: u32 = 0;
  fiat_p384_mulx_u32(&mut x1362, &mut x1363, x10, (arg1[8]));
  let mut x1364: u32 = 0;
  let mut x1365: u32 = 0;
  fiat_p384_mulx_u32(&mut x1364, &mut x1365, x10, (arg1[7]));
  let mut x1366: u32 = 0;
  let mut x1367: u32 = 0;
  fiat_p384_mulx_u32(&mut x1366, &mut x1367, x10, (arg1[6]));
  let mut x1368: u32 = 0;
  let mut x1369: u32 = 0;
  fiat_p384_mulx_u32(&mut x1368, &mut x1369, x10, (arg1[5]));
  let mut x1370: u32 = 0;
  let mut x1371: u32 = 0;
  fiat_p384_mulx_u32(&mut x1370, &mut x1371, x10, (arg1[4]));
  let mut x1372: u32 = 0;
  let mut x1373: u32 = 0;
  fiat_p384_mulx_u32(&mut x1372, &mut x1373, x10, (arg1[3]));
  let mut x1374: u32 = 0;
  let mut x1375: u32 = 0;
  fiat_p384_mulx_u32(&mut x1374, &mut x1375, x10, (arg1[2]));
  let mut x1376: u32 = 0;
  let mut x1377: u32 = 0;
  fiat_p384_mulx_u32(&mut x1376, &mut x1377, x10, (arg1[1]));
  let mut x1378: u32 = 0;
  let mut x1379: u32 = 0;
  fiat_p384_mulx_u32(&mut x1378, &mut x1379, x10, (arg1[0]));
  let mut x1380: u32 = 0;
  let mut x1381: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1380, &mut x1381, 0x0, x1379, x1376);
  let mut x1382: u32 = 0;
  let mut x1383: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1382, &mut x1383, x1381, x1377, x1374);
  let mut x1384: u32 = 0;
  let mut x1385: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1384, &mut x1385, x1383, x1375, x1372);
  let mut x1386: u32 = 0;
  let mut x1387: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1386, &mut x1387, x1385, x1373, x1370);
  let mut x1388: u32 = 0;
  let mut x1389: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1388, &mut x1389, x1387, x1371, x1368);
  let mut x1390: u32 = 0;
  let mut x1391: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1390, &mut x1391, x1389, x1369, x1366);
  let mut x1392: u32 = 0;
  let mut x1393: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1392, &mut x1393, x1391, x1367, x1364);
  let mut x1394: u32 = 0;
  let mut x1395: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1394, &mut x1395, x1393, x1365, x1362);
  let mut x1396: u32 = 0;
  let mut x1397: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1396, &mut x1397, x1395, x1363, x1360);
  let mut x1398: u32 = 0;
  let mut x1399: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1398, &mut x1399, x1397, x1361, x1358);
  let mut x1400: u32 = 0;
  let mut x1401: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1400, &mut x1401, x1399, x1359, x1356);
  let x1402: u32 = ((x1401 as u32) + x1357);
  let mut x1403: u32 = 0;
  let mut x1404: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1403, &mut x1404, 0x0, x1331, x1378);
  let mut x1405: u32 = 0;
  let mut x1406: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1405, &mut x1406, x1404, x1333, x1380);
  let mut x1407: u32 = 0;
  let mut x1408: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1407, &mut x1408, x1406, x1335, x1382);
  let mut x1409: u32 = 0;
  let mut x1410: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1409, &mut x1410, x1408, x1337, x1384);
  let mut x1411: u32 = 0;
  let mut x1412: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1411, &mut x1412, x1410, x1339, x1386);
  let mut x1413: u32 = 0;
  let mut x1414: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1413, &mut x1414, x1412, x1341, x1388);
  let mut x1415: u32 = 0;
  let mut x1416: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1415, &mut x1416, x1414, x1343, x1390);
  let mut x1417: u32 = 0;
  let mut x1418: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1417, &mut x1418, x1416, x1345, x1392);
  let mut x1419: u32 = 0;
  let mut x1420: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1419, &mut x1420, x1418, x1347, x1394);
  let mut x1421: u32 = 0;
  let mut x1422: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1421, &mut x1422, x1420, x1349, x1396);
  let mut x1423: u32 = 0;
  let mut x1424: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1423, &mut x1424, x1422, x1351, x1398);
  let mut x1425: u32 = 0;
  let mut x1426: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1425, &mut x1426, x1424, x1353, x1400);
  let mut x1427: u32 = 0;
  let mut x1428: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1427, &mut x1428, x1426, x1355, x1402);
  let mut x1429: u32 = 0;
  let mut x1430: u32 = 0;
  fiat_p384_mulx_u32(&mut x1429, &mut x1430, x1403, 0xffffffff);
  let mut x1431: u32 = 0;
  let mut x1432: u32 = 0;
  fiat_p384_mulx_u32(&mut x1431, &mut x1432, x1403, 0xffffffff);
  let mut x1433: u32 = 0;
  let mut x1434: u32 = 0;
  fiat_p384_mulx_u32(&mut x1433, &mut x1434, x1403, 0xffffffff);
  let mut x1435: u32 = 0;
  let mut x1436: u32 = 0;
  fiat_p384_mulx_u32(&mut x1435, &mut x1436, x1403, 0xffffffff);
  let mut x1437: u32 = 0;
  let mut x1438: u32 = 0;
  fiat_p384_mulx_u32(&mut x1437, &mut x1438, x1403, 0xffffffff);
  let mut x1439: u32 = 0;
  let mut x1440: u32 = 0;
  fiat_p384_mulx_u32(&mut x1439, &mut x1440, x1403, 0xffffffff);
  let mut x1441: u32 = 0;
  let mut x1442: u32 = 0;
  fiat_p384_mulx_u32(&mut x1441, &mut x1442, x1403, 0xffffffff);
  let mut x1443: u32 = 0;
  let mut x1444: u32 = 0;
  fiat_p384_mulx_u32(&mut x1443, &mut x1444, x1403, 0xfffffffe);
  let mut x1445: u32 = 0;
  let mut x1446: u32 = 0;
  fiat_p384_mulx_u32(&mut x1445, &mut x1446, x1403, 0xffffffff);
  let mut x1447: u32 = 0;
  let mut x1448: u32 = 0;
  fiat_p384_mulx_u32(&mut x1447, &mut x1448, x1403, 0xffffffff);
  let mut x1449: u32 = 0;
  let mut x1450: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1449, &mut x1450, 0x0, x1446, x1443);
  let mut x1451: u32 = 0;
  let mut x1452: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1451, &mut x1452, x1450, x1444, x1441);
  let mut x1453: u32 = 0;
  let mut x1454: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1453, &mut x1454, x1452, x1442, x1439);
  let mut x1455: u32 = 0;
  let mut x1456: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1455, &mut x1456, x1454, x1440, x1437);
  let mut x1457: u32 = 0;
  let mut x1458: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1457, &mut x1458, x1456, x1438, x1435);
  let mut x1459: u32 = 0;
  let mut x1460: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1459, &mut x1460, x1458, x1436, x1433);
  let mut x1461: u32 = 0;
  let mut x1462: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1461, &mut x1462, x1460, x1434, x1431);
  let mut x1463: u32 = 0;
  let mut x1464: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1463, &mut x1464, x1462, x1432, x1429);
  let x1465: u32 = ((x1464 as u32) + x1430);
  let mut x1466: u32 = 0;
  let mut x1467: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1466, &mut x1467, 0x0, x1403, x1447);
  let mut x1468: u32 = 0;
  let mut x1469: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1468, &mut x1469, x1467, x1405, x1448);
  let mut x1470: u32 = 0;
  let mut x1471: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1470, &mut x1471, x1469, x1407, (0x0 as u32));
  let mut x1472: u32 = 0;
  let mut x1473: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1472, &mut x1473, x1471, x1409, x1445);
  let mut x1474: u32 = 0;
  let mut x1475: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1474, &mut x1475, x1473, x1411, x1449);
  let mut x1476: u32 = 0;
  let mut x1477: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1476, &mut x1477, x1475, x1413, x1451);
  let mut x1478: u32 = 0;
  let mut x1479: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1478, &mut x1479, x1477, x1415, x1453);
  let mut x1480: u32 = 0;
  let mut x1481: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1480, &mut x1481, x1479, x1417, x1455);
  let mut x1482: u32 = 0;
  let mut x1483: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1482, &mut x1483, x1481, x1419, x1457);
  let mut x1484: u32 = 0;
  let mut x1485: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1484, &mut x1485, x1483, x1421, x1459);
  let mut x1486: u32 = 0;
  let mut x1487: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1486, &mut x1487, x1485, x1423, x1461);
  let mut x1488: u32 = 0;
  let mut x1489: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1488, &mut x1489, x1487, x1425, x1463);
  let mut x1490: u32 = 0;
  let mut x1491: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1490, &mut x1491, x1489, x1427, x1465);
  let x1492: u32 = ((x1491 as u32) + (x1428 as u32));
  let mut x1493: u32 = 0;
  let mut x1494: u32 = 0;
  fiat_p384_mulx_u32(&mut x1493, &mut x1494, x11, (arg1[11]));
  let mut x1495: u32 = 0;
  let mut x1496: u32 = 0;
  fiat_p384_mulx_u32(&mut x1495, &mut x1496, x11, (arg1[10]));
  let mut x1497: u32 = 0;
  let mut x1498: u32 = 0;
  fiat_p384_mulx_u32(&mut x1497, &mut x1498, x11, (arg1[9]));
  let mut x1499: u32 = 0;
  let mut x1500: u32 = 0;
  fiat_p384_mulx_u32(&mut x1499, &mut x1500, x11, (arg1[8]));
  let mut x1501: u32 = 0;
  let mut x1502: u32 = 0;
  fiat_p384_mulx_u32(&mut x1501, &mut x1502, x11, (arg1[7]));
  let mut x1503: u32 = 0;
  let mut x1504: u32 = 0;
  fiat_p384_mulx_u32(&mut x1503, &mut x1504, x11, (arg1[6]));
  let mut x1505: u32 = 0;
  let mut x1506: u32 = 0;
  fiat_p384_mulx_u32(&mut x1505, &mut x1506, x11, (arg1[5]));
  let mut x1507: u32 = 0;
  let mut x1508: u32 = 0;
  fiat_p384_mulx_u32(&mut x1507, &mut x1508, x11, (arg1[4]));
  let mut x1509: u32 = 0;
  let mut x1510: u32 = 0;
  fiat_p384_mulx_u32(&mut x1509, &mut x1510, x11, (arg1[3]));
  let mut x1511: u32 = 0;
  let mut x1512: u32 = 0;
  fiat_p384_mulx_u32(&mut x1511, &mut x1512, x11, (arg1[2]));
  let mut x1513: u32 = 0;
  let mut x1514: u32 = 0;
  fiat_p384_mulx_u32(&mut x1513, &mut x1514, x11, (arg1[1]));
  let mut x1515: u32 = 0;
  let mut x1516: u32 = 0;
  fiat_p384_mulx_u32(&mut x1515, &mut x1516, x11, (arg1[0]));
  let mut x1517: u32 = 0;
  let mut x1518: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1517, &mut x1518, 0x0, x1516, x1513);
  let mut x1519: u32 = 0;
  let mut x1520: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1519, &mut x1520, x1518, x1514, x1511);
  let mut x1521: u32 = 0;
  let mut x1522: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1521, &mut x1522, x1520, x1512, x1509);
  let mut x1523: u32 = 0;
  let mut x1524: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1523, &mut x1524, x1522, x1510, x1507);
  let mut x1525: u32 = 0;
  let mut x1526: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1525, &mut x1526, x1524, x1508, x1505);
  let mut x1527: u32 = 0;
  let mut x1528: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1527, &mut x1528, x1526, x1506, x1503);
  let mut x1529: u32 = 0;
  let mut x1530: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1529, &mut x1530, x1528, x1504, x1501);
  let mut x1531: u32 = 0;
  let mut x1532: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1531, &mut x1532, x1530, x1502, x1499);
  let mut x1533: u32 = 0;
  let mut x1534: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1533, &mut x1534, x1532, x1500, x1497);
  let mut x1535: u32 = 0;
  let mut x1536: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1535, &mut x1536, x1534, x1498, x1495);
  let mut x1537: u32 = 0;
  let mut x1538: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1537, &mut x1538, x1536, x1496, x1493);
  let x1539: u32 = ((x1538 as u32) + x1494);
  let mut x1540: u32 = 0;
  let mut x1541: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1540, &mut x1541, 0x0, x1468, x1515);
  let mut x1542: u32 = 0;
  let mut x1543: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1542, &mut x1543, x1541, x1470, x1517);
  let mut x1544: u32 = 0;
  let mut x1545: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1544, &mut x1545, x1543, x1472, x1519);
  let mut x1546: u32 = 0;
  let mut x1547: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1546, &mut x1547, x1545, x1474, x1521);
  let mut x1548: u32 = 0;
  let mut x1549: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1548, &mut x1549, x1547, x1476, x1523);
  let mut x1550: u32 = 0;
  let mut x1551: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1550, &mut x1551, x1549, x1478, x1525);
  let mut x1552: u32 = 0;
  let mut x1553: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1552, &mut x1553, x1551, x1480, x1527);
  let mut x1554: u32 = 0;
  let mut x1555: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1554, &mut x1555, x1553, x1482, x1529);
  let mut x1556: u32 = 0;
  let mut x1557: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1556, &mut x1557, x1555, x1484, x1531);
  let mut x1558: u32 = 0;
  let mut x1559: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1558, &mut x1559, x1557, x1486, x1533);
  let mut x1560: u32 = 0;
  let mut x1561: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1560, &mut x1561, x1559, x1488, x1535);
  let mut x1562: u32 = 0;
  let mut x1563: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1562, &mut x1563, x1561, x1490, x1537);
  let mut x1564: u32 = 0;
  let mut x1565: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1564, &mut x1565, x1563, x1492, x1539);
  let mut x1566: u32 = 0;
  let mut x1567: u32 = 0;
  fiat_p384_mulx_u32(&mut x1566, &mut x1567, x1540, 0xffffffff);
  let mut x1568: u32 = 0;
  let mut x1569: u32 = 0;
  fiat_p384_mulx_u32(&mut x1568, &mut x1569, x1540, 0xffffffff);
  let mut x1570: u32 = 0;
  let mut x1571: u32 = 0;
  fiat_p384_mulx_u32(&mut x1570, &mut x1571, x1540, 0xffffffff);
  let mut x1572: u32 = 0;
  let mut x1573: u32 = 0;
  fiat_p384_mulx_u32(&mut x1572, &mut x1573, x1540, 0xffffffff);
  let mut x1574: u32 = 0;
  let mut x1575: u32 = 0;
  fiat_p384_mulx_u32(&mut x1574, &mut x1575, x1540, 0xffffffff);
  let mut x1576: u32 = 0;
  let mut x1577: u32 = 0;
  fiat_p384_mulx_u32(&mut x1576, &mut x1577, x1540, 0xffffffff);
  let mut x1578: u32 = 0;
  let mut x1579: u32 = 0;
  fiat_p384_mulx_u32(&mut x1578, &mut x1579, x1540, 0xffffffff);
  let mut x1580: u32 = 0;
  let mut x1581: u32 = 0;
  fiat_p384_mulx_u32(&mut x1580, &mut x1581, x1540, 0xfffffffe);
  let mut x1582: u32 = 0;
  let mut x1583: u32 = 0;
  fiat_p384_mulx_u32(&mut x1582, &mut x1583, x1540, 0xffffffff);
  let mut x1584: u32 = 0;
  let mut x1585: u32 = 0;
  fiat_p384_mulx_u32(&mut x1584, &mut x1585, x1540, 0xffffffff);
  let mut x1586: u32 = 0;
  let mut x1587: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1586, &mut x1587, 0x0, x1583, x1580);
  let mut x1588: u32 = 0;
  let mut x1589: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1588, &mut x1589, x1587, x1581, x1578);
  let mut x1590: u32 = 0;
  let mut x1591: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1590, &mut x1591, x1589, x1579, x1576);
  let mut x1592: u32 = 0;
  let mut x1593: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1592, &mut x1593, x1591, x1577, x1574);
  let mut x1594: u32 = 0;
  let mut x1595: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1594, &mut x1595, x1593, x1575, x1572);
  let mut x1596: u32 = 0;
  let mut x1597: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1596, &mut x1597, x1595, x1573, x1570);
  let mut x1598: u32 = 0;
  let mut x1599: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1598, &mut x1599, x1597, x1571, x1568);
  let mut x1600: u32 = 0;
  let mut x1601: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1600, &mut x1601, x1599, x1569, x1566);
  let x1602: u32 = ((x1601 as u32) + x1567);
  let mut x1603: u32 = 0;
  let mut x1604: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1603, &mut x1604, 0x0, x1540, x1584);
  let mut x1605: u32 = 0;
  let mut x1606: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1605, &mut x1606, x1604, x1542, x1585);
  let mut x1607: u32 = 0;
  let mut x1608: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1607, &mut x1608, x1606, x1544, (0x0 as u32));
  let mut x1609: u32 = 0;
  let mut x1610: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1609, &mut x1610, x1608, x1546, x1582);
  let mut x1611: u32 = 0;
  let mut x1612: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1611, &mut x1612, x1610, x1548, x1586);
  let mut x1613: u32 = 0;
  let mut x1614: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1613, &mut x1614, x1612, x1550, x1588);
  let mut x1615: u32 = 0;
  let mut x1616: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1615, &mut x1616, x1614, x1552, x1590);
  let mut x1617: u32 = 0;
  let mut x1618: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1617, &mut x1618, x1616, x1554, x1592);
  let mut x1619: u32 = 0;
  let mut x1620: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1619, &mut x1620, x1618, x1556, x1594);
  let mut x1621: u32 = 0;
  let mut x1622: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1621, &mut x1622, x1620, x1558, x1596);
  let mut x1623: u32 = 0;
  let mut x1624: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1623, &mut x1624, x1622, x1560, x1598);
  let mut x1625: u32 = 0;
  let mut x1626: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1625, &mut x1626, x1624, x1562, x1600);
  let mut x1627: u32 = 0;
  let mut x1628: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1627, &mut x1628, x1626, x1564, x1602);
  let x1629: u32 = ((x1628 as u32) + (x1565 as u32));
  let mut x1630: u32 = 0;
  let mut x1631: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1630, &mut x1631, 0x0, x1605, 0xffffffff);
  let mut x1632: u32 = 0;
  let mut x1633: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1632, &mut x1633, x1631, x1607, (0x0 as u32));
  let mut x1634: u32 = 0;
  let mut x1635: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1634, &mut x1635, x1633, x1609, (0x0 as u32));
  let mut x1636: u32 = 0;
  let mut x1637: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1636, &mut x1637, x1635, x1611, 0xffffffff);
  let mut x1638: u32 = 0;
  let mut x1639: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1638, &mut x1639, x1637, x1613, 0xfffffffe);
  let mut x1640: u32 = 0;
  let mut x1641: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1640, &mut x1641, x1639, x1615, 0xffffffff);
  let mut x1642: u32 = 0;
  let mut x1643: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1642, &mut x1643, x1641, x1617, 0xffffffff);
  let mut x1644: u32 = 0;
  let mut x1645: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1644, &mut x1645, x1643, x1619, 0xffffffff);
  let mut x1646: u32 = 0;
  let mut x1647: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1646, &mut x1647, x1645, x1621, 0xffffffff);
  let mut x1648: u32 = 0;
  let mut x1649: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1648, &mut x1649, x1647, x1623, 0xffffffff);
  let mut x1650: u32 = 0;
  let mut x1651: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1650, &mut x1651, x1649, x1625, 0xffffffff);
  let mut x1652: u32 = 0;
  let mut x1653: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1652, &mut x1653, x1651, x1627, 0xffffffff);
  let mut x1654: u32 = 0;
  let mut x1655: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1654, &mut x1655, x1653, x1629, (0x0 as u32));
  let mut x1656: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1656, x1655, x1630, x1605);
  let mut x1657: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1657, x1655, x1632, x1607);
  let mut x1658: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1658, x1655, x1634, x1609);
  let mut x1659: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1659, x1655, x1636, x1611);
  let mut x1660: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1660, x1655, x1638, x1613);
  let mut x1661: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1661, x1655, x1640, x1615);
  let mut x1662: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1662, x1655, x1642, x1617);
  let mut x1663: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1663, x1655, x1644, x1619);
  let mut x1664: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1664, x1655, x1646, x1621);
  let mut x1665: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1665, x1655, x1648, x1623);
  let mut x1666: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1666, x1655, x1650, x1625);
  let mut x1667: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1667, x1655, x1652, x1627);
  out1[0] = x1656;
  out1[1] = x1657;
  out1[2] = x1658;
  out1[3] = x1659;
  out1[4] = x1660;
  out1[5] = x1661;
  out1[6] = x1662;
  out1[7] = x1663;
  out1[8] = x1664;
  out1[9] = x1665;
  out1[10] = x1666;
  out1[11] = x1667;
}

/// The function fiat_p384_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_add(out1: &mut fiat_p384_montgomery_domain_field_element, arg1: &fiat_p384_montgomery_domain_field_element, arg2: &fiat_p384_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x17, &mut x18, x16, (arg1[8]), (arg2[8]));
  let mut x19: u32 = 0;
  let mut x20: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x19, &mut x20, x18, (arg1[9]), (arg2[9]));
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x21, &mut x22, x20, (arg1[10]), (arg2[10]));
  let mut x23: u32 = 0;
  let mut x24: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x23, &mut x24, x22, (arg1[11]), (arg2[11]));
  let mut x25: u32 = 0;
  let mut x26: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x25, &mut x26, 0x0, x1, 0xffffffff);
  let mut x27: u32 = 0;
  let mut x28: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x27, &mut x28, x26, x3, (0x0 as u32));
  let mut x29: u32 = 0;
  let mut x30: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x29, &mut x30, x28, x5, (0x0 as u32));
  let mut x31: u32 = 0;
  let mut x32: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x31, &mut x32, x30, x7, 0xffffffff);
  let mut x33: u32 = 0;
  let mut x34: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x33, &mut x34, x32, x9, 0xfffffffe);
  let mut x35: u32 = 0;
  let mut x36: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x35, &mut x36, x34, x11, 0xffffffff);
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x37, &mut x38, x36, x13, 0xffffffff);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x39, &mut x40, x38, x15, 0xffffffff);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x41, &mut x42, x40, x17, 0xffffffff);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x43, &mut x44, x42, x19, 0xffffffff);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x45, &mut x46, x44, x21, 0xffffffff);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x47, &mut x48, x46, x23, 0xffffffff);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x49, &mut x50, x48, (x24 as u32), (0x0 as u32));
  let mut x51: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x51, x50, x25, x1);
  let mut x52: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x52, x50, x27, x3);
  let mut x53: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x53, x50, x29, x5);
  let mut x54: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x54, x50, x31, x7);
  let mut x55: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x55, x50, x33, x9);
  let mut x56: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x56, x50, x35, x11);
  let mut x57: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x57, x50, x37, x13);
  let mut x58: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x58, x50, x39, x15);
  let mut x59: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x59, x50, x41, x17);
  let mut x60: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x60, x50, x43, x19);
  let mut x61: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x61, x50, x45, x21);
  let mut x62: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x62, x50, x47, x23);
  out1[0] = x51;
  out1[1] = x52;
  out1[2] = x53;
  out1[3] = x54;
  out1[4] = x55;
  out1[5] = x56;
  out1[6] = x57;
  out1[7] = x58;
  out1[8] = x59;
  out1[9] = x60;
  out1[10] = x61;
  out1[11] = x62;
}

/// The function fiat_p384_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_sub(out1: &mut fiat_p384_montgomery_domain_field_element, arg1: &fiat_p384_montgomery_domain_field_element, arg2: &fiat_p384_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x17, &mut x18, x16, (arg1[8]), (arg2[8]));
  let mut x19: u32 = 0;
  let mut x20: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x19, &mut x20, x18, (arg1[9]), (arg2[9]));
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x21, &mut x22, x20, (arg1[10]), (arg2[10]));
  let mut x23: u32 = 0;
  let mut x24: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x23, &mut x24, x22, (arg1[11]), (arg2[11]));
  let mut x25: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x25, x24, (0x0 as u32), 0xffffffff);
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x26, &mut x27, 0x0, x1, x25);
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x28, &mut x29, x27, x3, (0x0 as u32));
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x30, &mut x31, x29, x5, (0x0 as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x32, &mut x33, x31, x7, x25);
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x34, &mut x35, x33, x9, (x25 & 0xfffffffe));
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x36, &mut x37, x35, x11, x25);
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x38, &mut x39, x37, x13, x25);
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x40, &mut x41, x39, x15, x25);
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x42, &mut x43, x41, x17, x25);
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x44, &mut x45, x43, x19, x25);
  let mut x46: u32 = 0;
  let mut x47: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x46, &mut x47, x45, x21, x25);
  let mut x48: u32 = 0;
  let mut x49: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x48, &mut x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/// The function fiat_p384_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_opp(out1: &mut fiat_p384_montgomery_domain_field_element, arg1: &fiat_p384_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1, &mut x2, 0x0, (0x0 as u32), (arg1[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x3, &mut x4, x2, (0x0 as u32), (arg1[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x5, &mut x6, x4, (0x0 as u32), (arg1[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x7, &mut x8, x6, (0x0 as u32), (arg1[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x9, &mut x10, x8, (0x0 as u32), (arg1[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x11, &mut x12, x10, (0x0 as u32), (arg1[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x13, &mut x14, x12, (0x0 as u32), (arg1[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x15, &mut x16, x14, (0x0 as u32), (arg1[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x17, &mut x18, x16, (0x0 as u32), (arg1[8]));
  let mut x19: u32 = 0;
  let mut x20: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x19, &mut x20, x18, (0x0 as u32), (arg1[9]));
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x21, &mut x22, x20, (0x0 as u32), (arg1[10]));
  let mut x23: u32 = 0;
  let mut x24: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x23, &mut x24, x22, (0x0 as u32), (arg1[11]));
  let mut x25: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x25, x24, (0x0 as u32), 0xffffffff);
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x26, &mut x27, 0x0, x1, x25);
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x28, &mut x29, x27, x3, (0x0 as u32));
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x30, &mut x31, x29, x5, (0x0 as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x32, &mut x33, x31, x7, x25);
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x34, &mut x35, x33, x9, (x25 & 0xfffffffe));
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x36, &mut x37, x35, x11, x25);
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x38, &mut x39, x37, x13, x25);
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x40, &mut x41, x39, x15, x25);
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x42, &mut x43, x41, x17, x25);
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x44, &mut x45, x43, x19, x25);
  let mut x46: u32 = 0;
  let mut x47: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x46, &mut x47, x45, x21, x25);
  let mut x48: u32 = 0;
  let mut x49: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x48, &mut x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/// The function fiat_p384_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_from_montgomery(out1: &mut fiat_p384_non_montgomery_domain_field_element, arg1: &fiat_p384_montgomery_domain_field_element) {
  let x1: u32 = (arg1[0]);
  let mut x2: u32 = 0;
  let mut x3: u32 = 0;
  fiat_p384_mulx_u32(&mut x2, &mut x3, x1, 0xffffffff);
  let mut x4: u32 = 0;
  let mut x5: u32 = 0;
  fiat_p384_mulx_u32(&mut x4, &mut x5, x1, 0xffffffff);
  let mut x6: u32 = 0;
  let mut x7: u32 = 0;
  fiat_p384_mulx_u32(&mut x6, &mut x7, x1, 0xffffffff);
  let mut x8: u32 = 0;
  let mut x9: u32 = 0;
  fiat_p384_mulx_u32(&mut x8, &mut x9, x1, 0xffffffff);
  let mut x10: u32 = 0;
  let mut x11: u32 = 0;
  fiat_p384_mulx_u32(&mut x10, &mut x11, x1, 0xffffffff);
  let mut x12: u32 = 0;
  let mut x13: u32 = 0;
  fiat_p384_mulx_u32(&mut x12, &mut x13, x1, 0xffffffff);
  let mut x14: u32 = 0;
  let mut x15: u32 = 0;
  fiat_p384_mulx_u32(&mut x14, &mut x15, x1, 0xffffffff);
  let mut x16: u32 = 0;
  let mut x17: u32 = 0;
  fiat_p384_mulx_u32(&mut x16, &mut x17, x1, 0xfffffffe);
  let mut x18: u32 = 0;
  let mut x19: u32 = 0;
  fiat_p384_mulx_u32(&mut x18, &mut x19, x1, 0xffffffff);
  let mut x20: u32 = 0;
  let mut x21: u32 = 0;
  fiat_p384_mulx_u32(&mut x20, &mut x21, x1, 0xffffffff);
  let mut x22: u32 = 0;
  let mut x23: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x22, &mut x23, 0x0, x19, x16);
  let mut x24: u32 = 0;
  let mut x25: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x24, &mut x25, x23, x17, x14);
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x26, &mut x27, x25, x15, x12);
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x28, &mut x29, x27, x13, x10);
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x30, &mut x31, x29, x11, x8);
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x32, &mut x33, x31, x9, x6);
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x34, &mut x35, x33, x7, x4);
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x36, &mut x37, x35, x5, x2);
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x38, &mut x39, 0x0, x1, x20);
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x40, &mut x41, 0x0, ((x39 as u32) + x21), (arg1[1]));
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_p384_mulx_u32(&mut x42, &mut x43, x40, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_p384_mulx_u32(&mut x44, &mut x45, x40, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_p384_mulx_u32(&mut x46, &mut x47, x40, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_p384_mulx_u32(&mut x48, &mut x49, x40, 0xffffffff);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_p384_mulx_u32(&mut x50, &mut x51, x40, 0xffffffff);
  let mut x52: u32 = 0;
  let mut x53: u32 = 0;
  fiat_p384_mulx_u32(&mut x52, &mut x53, x40, 0xffffffff);
  let mut x54: u32 = 0;
  let mut x55: u32 = 0;
  fiat_p384_mulx_u32(&mut x54, &mut x55, x40, 0xffffffff);
  let mut x56: u32 = 0;
  let mut x57: u32 = 0;
  fiat_p384_mulx_u32(&mut x56, &mut x57, x40, 0xfffffffe);
  let mut x58: u32 = 0;
  let mut x59: u32 = 0;
  fiat_p384_mulx_u32(&mut x58, &mut x59, x40, 0xffffffff);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_p384_mulx_u32(&mut x60, &mut x61, x40, 0xffffffff);
  let mut x62: u32 = 0;
  let mut x63: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x62, &mut x63, 0x0, x59, x56);
  let mut x64: u32 = 0;
  let mut x65: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x64, &mut x65, x63, x57, x54);
  let mut x66: u32 = 0;
  let mut x67: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x66, &mut x67, x65, x55, x52);
  let mut x68: u32 = 0;
  let mut x69: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x68, &mut x69, x67, x53, x50);
  let mut x70: u32 = 0;
  let mut x71: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x70, &mut x71, x69, x51, x48);
  let mut x72: u32 = 0;
  let mut x73: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x72, &mut x73, x71, x49, x46);
  let mut x74: u32 = 0;
  let mut x75: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x74, &mut x75, x73, x47, x44);
  let mut x76: u32 = 0;
  let mut x77: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x76, &mut x77, x75, x45, x42);
  let mut x78: u32 = 0;
  let mut x79: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x78, &mut x79, 0x0, x40, x60);
  let mut x80: u32 = 0;
  let mut x81: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x80, &mut x81, x79, (x41 as u32), x61);
  let mut x82: u32 = 0;
  let mut x83: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x82, &mut x83, x81, x18, (0x0 as u32));
  let mut x84: u32 = 0;
  let mut x85: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x84, &mut x85, x83, x22, x58);
  let mut x86: u32 = 0;
  let mut x87: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x86, &mut x87, x85, x24, x62);
  let mut x88: u32 = 0;
  let mut x89: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x88, &mut x89, x87, x26, x64);
  let mut x90: u32 = 0;
  let mut x91: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x90, &mut x91, x89, x28, x66);
  let mut x92: u32 = 0;
  let mut x93: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x92, &mut x93, x91, x30, x68);
  let mut x94: u32 = 0;
  let mut x95: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x94, &mut x95, x93, x32, x70);
  let mut x96: u32 = 0;
  let mut x97: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x96, &mut x97, x95, x34, x72);
  let mut x98: u32 = 0;
  let mut x99: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x98, &mut x99, x97, x36, x74);
  let mut x100: u32 = 0;
  let mut x101: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x100, &mut x101, x99, ((x37 as u32) + x3), x76);
  let mut x102: u32 = 0;
  let mut x103: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x102, &mut x103, x101, (0x0 as u32), ((x77 as u32) + x43));
  let mut x104: u32 = 0;
  let mut x105: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x104, &mut x105, 0x0, x80, (arg1[2]));
  let mut x106: u32 = 0;
  let mut x107: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x106, &mut x107, x105, x82, (0x0 as u32));
  let mut x108: u32 = 0;
  let mut x109: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x108, &mut x109, x107, x84, (0x0 as u32));
  let mut x110: u32 = 0;
  let mut x111: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x110, &mut x111, x109, x86, (0x0 as u32));
  let mut x112: u32 = 0;
  let mut x113: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x112, &mut x113, x111, x88, (0x0 as u32));
  let mut x114: u32 = 0;
  let mut x115: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x114, &mut x115, x113, x90, (0x0 as u32));
  let mut x116: u32 = 0;
  let mut x117: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x116, &mut x117, x115, x92, (0x0 as u32));
  let mut x118: u32 = 0;
  let mut x119: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x118, &mut x119, x117, x94, (0x0 as u32));
  let mut x120: u32 = 0;
  let mut x121: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x120, &mut x121, x119, x96, (0x0 as u32));
  let mut x122: u32 = 0;
  let mut x123: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x122, &mut x123, x121, x98, (0x0 as u32));
  let mut x124: u32 = 0;
  let mut x125: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x124, &mut x125, x123, x100, (0x0 as u32));
  let mut x126: u32 = 0;
  let mut x127: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x126, &mut x127, x125, x102, (0x0 as u32));
  let mut x128: u32 = 0;
  let mut x129: u32 = 0;
  fiat_p384_mulx_u32(&mut x128, &mut x129, x104, 0xffffffff);
  let mut x130: u32 = 0;
  let mut x131: u32 = 0;
  fiat_p384_mulx_u32(&mut x130, &mut x131, x104, 0xffffffff);
  let mut x132: u32 = 0;
  let mut x133: u32 = 0;
  fiat_p384_mulx_u32(&mut x132, &mut x133, x104, 0xffffffff);
  let mut x134: u32 = 0;
  let mut x135: u32 = 0;
  fiat_p384_mulx_u32(&mut x134, &mut x135, x104, 0xffffffff);
  let mut x136: u32 = 0;
  let mut x137: u32 = 0;
  fiat_p384_mulx_u32(&mut x136, &mut x137, x104, 0xffffffff);
  let mut x138: u32 = 0;
  let mut x139: u32 = 0;
  fiat_p384_mulx_u32(&mut x138, &mut x139, x104, 0xffffffff);
  let mut x140: u32 = 0;
  let mut x141: u32 = 0;
  fiat_p384_mulx_u32(&mut x140, &mut x141, x104, 0xffffffff);
  let mut x142: u32 = 0;
  let mut x143: u32 = 0;
  fiat_p384_mulx_u32(&mut x142, &mut x143, x104, 0xfffffffe);
  let mut x144: u32 = 0;
  let mut x145: u32 = 0;
  fiat_p384_mulx_u32(&mut x144, &mut x145, x104, 0xffffffff);
  let mut x146: u32 = 0;
  let mut x147: u32 = 0;
  fiat_p384_mulx_u32(&mut x146, &mut x147, x104, 0xffffffff);
  let mut x148: u32 = 0;
  let mut x149: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x148, &mut x149, 0x0, x145, x142);
  let mut x150: u32 = 0;
  let mut x151: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x150, &mut x151, x149, x143, x140);
  let mut x152: u32 = 0;
  let mut x153: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x152, &mut x153, x151, x141, x138);
  let mut x154: u32 = 0;
  let mut x155: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x154, &mut x155, x153, x139, x136);
  let mut x156: u32 = 0;
  let mut x157: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x156, &mut x157, x155, x137, x134);
  let mut x158: u32 = 0;
  let mut x159: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x158, &mut x159, x157, x135, x132);
  let mut x160: u32 = 0;
  let mut x161: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x160, &mut x161, x159, x133, x130);
  let mut x162: u32 = 0;
  let mut x163: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x162, &mut x163, x161, x131, x128);
  let mut x164: u32 = 0;
  let mut x165: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x164, &mut x165, 0x0, x104, x146);
  let mut x166: u32 = 0;
  let mut x167: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x166, &mut x167, x165, x106, x147);
  let mut x168: u32 = 0;
  let mut x169: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x168, &mut x169, x167, x108, (0x0 as u32));
  let mut x170: u32 = 0;
  let mut x171: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x170, &mut x171, x169, x110, x144);
  let mut x172: u32 = 0;
  let mut x173: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x172, &mut x173, x171, x112, x148);
  let mut x174: u32 = 0;
  let mut x175: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x174, &mut x175, x173, x114, x150);
  let mut x176: u32 = 0;
  let mut x177: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x176, &mut x177, x175, x116, x152);
  let mut x178: u32 = 0;
  let mut x179: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x178, &mut x179, x177, x118, x154);
  let mut x180: u32 = 0;
  let mut x181: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x180, &mut x181, x179, x120, x156);
  let mut x182: u32 = 0;
  let mut x183: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x182, &mut x183, x181, x122, x158);
  let mut x184: u32 = 0;
  let mut x185: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x184, &mut x185, x183, x124, x160);
  let mut x186: u32 = 0;
  let mut x187: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x186, &mut x187, x185, x126, x162);
  let mut x188: u32 = 0;
  let mut x189: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x188, &mut x189, x187, ((x127 as u32) + (x103 as u32)), ((x163 as u32) + x129));
  let mut x190: u32 = 0;
  let mut x191: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x190, &mut x191, 0x0, x166, (arg1[3]));
  let mut x192: u32 = 0;
  let mut x193: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x192, &mut x193, x191, x168, (0x0 as u32));
  let mut x194: u32 = 0;
  let mut x195: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x194, &mut x195, x193, x170, (0x0 as u32));
  let mut x196: u32 = 0;
  let mut x197: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x196, &mut x197, x195, x172, (0x0 as u32));
  let mut x198: u32 = 0;
  let mut x199: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x198, &mut x199, x197, x174, (0x0 as u32));
  let mut x200: u32 = 0;
  let mut x201: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x200, &mut x201, x199, x176, (0x0 as u32));
  let mut x202: u32 = 0;
  let mut x203: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x202, &mut x203, x201, x178, (0x0 as u32));
  let mut x204: u32 = 0;
  let mut x205: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x204, &mut x205, x203, x180, (0x0 as u32));
  let mut x206: u32 = 0;
  let mut x207: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x206, &mut x207, x205, x182, (0x0 as u32));
  let mut x208: u32 = 0;
  let mut x209: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x208, &mut x209, x207, x184, (0x0 as u32));
  let mut x210: u32 = 0;
  let mut x211: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x210, &mut x211, x209, x186, (0x0 as u32));
  let mut x212: u32 = 0;
  let mut x213: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x212, &mut x213, x211, x188, (0x0 as u32));
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_p384_mulx_u32(&mut x214, &mut x215, x190, 0xffffffff);
  let mut x216: u32 = 0;
  let mut x217: u32 = 0;
  fiat_p384_mulx_u32(&mut x216, &mut x217, x190, 0xffffffff);
  let mut x218: u32 = 0;
  let mut x219: u32 = 0;
  fiat_p384_mulx_u32(&mut x218, &mut x219, x190, 0xffffffff);
  let mut x220: u32 = 0;
  let mut x221: u32 = 0;
  fiat_p384_mulx_u32(&mut x220, &mut x221, x190, 0xffffffff);
  let mut x222: u32 = 0;
  let mut x223: u32 = 0;
  fiat_p384_mulx_u32(&mut x222, &mut x223, x190, 0xffffffff);
  let mut x224: u32 = 0;
  let mut x225: u32 = 0;
  fiat_p384_mulx_u32(&mut x224, &mut x225, x190, 0xffffffff);
  let mut x226: u32 = 0;
  let mut x227: u32 = 0;
  fiat_p384_mulx_u32(&mut x226, &mut x227, x190, 0xffffffff);
  let mut x228: u32 = 0;
  let mut x229: u32 = 0;
  fiat_p384_mulx_u32(&mut x228, &mut x229, x190, 0xfffffffe);
  let mut x230: u32 = 0;
  let mut x231: u32 = 0;
  fiat_p384_mulx_u32(&mut x230, &mut x231, x190, 0xffffffff);
  let mut x232: u32 = 0;
  let mut x233: u32 = 0;
  fiat_p384_mulx_u32(&mut x232, &mut x233, x190, 0xffffffff);
  let mut x234: u32 = 0;
  let mut x235: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x234, &mut x235, 0x0, x231, x228);
  let mut x236: u32 = 0;
  let mut x237: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x236, &mut x237, x235, x229, x226);
  let mut x238: u32 = 0;
  let mut x239: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x238, &mut x239, x237, x227, x224);
  let mut x240: u32 = 0;
  let mut x241: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x240, &mut x241, x239, x225, x222);
  let mut x242: u32 = 0;
  let mut x243: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x242, &mut x243, x241, x223, x220);
  let mut x244: u32 = 0;
  let mut x245: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x244, &mut x245, x243, x221, x218);
  let mut x246: u32 = 0;
  let mut x247: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x246, &mut x247, x245, x219, x216);
  let mut x248: u32 = 0;
  let mut x249: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x248, &mut x249, x247, x217, x214);
  let mut x250: u32 = 0;
  let mut x251: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x250, &mut x251, 0x0, x190, x232);
  let mut x252: u32 = 0;
  let mut x253: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x252, &mut x253, x251, x192, x233);
  let mut x254: u32 = 0;
  let mut x255: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x254, &mut x255, x253, x194, (0x0 as u32));
  let mut x256: u32 = 0;
  let mut x257: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x256, &mut x257, x255, x196, x230);
  let mut x258: u32 = 0;
  let mut x259: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x258, &mut x259, x257, x198, x234);
  let mut x260: u32 = 0;
  let mut x261: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x260, &mut x261, x259, x200, x236);
  let mut x262: u32 = 0;
  let mut x263: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x262, &mut x263, x261, x202, x238);
  let mut x264: u32 = 0;
  let mut x265: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x264, &mut x265, x263, x204, x240);
  let mut x266: u32 = 0;
  let mut x267: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x266, &mut x267, x265, x206, x242);
  let mut x268: u32 = 0;
  let mut x269: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x268, &mut x269, x267, x208, x244);
  let mut x270: u32 = 0;
  let mut x271: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x270, &mut x271, x269, x210, x246);
  let mut x272: u32 = 0;
  let mut x273: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x272, &mut x273, x271, x212, x248);
  let mut x274: u32 = 0;
  let mut x275: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x274, &mut x275, x273, ((x213 as u32) + (x189 as u32)), ((x249 as u32) + x215));
  let mut x276: u32 = 0;
  let mut x277: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x276, &mut x277, 0x0, x252, (arg1[4]));
  let mut x278: u32 = 0;
  let mut x279: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x278, &mut x279, x277, x254, (0x0 as u32));
  let mut x280: u32 = 0;
  let mut x281: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x280, &mut x281, x279, x256, (0x0 as u32));
  let mut x282: u32 = 0;
  let mut x283: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x282, &mut x283, x281, x258, (0x0 as u32));
  let mut x284: u32 = 0;
  let mut x285: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x284, &mut x285, x283, x260, (0x0 as u32));
  let mut x286: u32 = 0;
  let mut x287: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x286, &mut x287, x285, x262, (0x0 as u32));
  let mut x288: u32 = 0;
  let mut x289: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x288, &mut x289, x287, x264, (0x0 as u32));
  let mut x290: u32 = 0;
  let mut x291: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x290, &mut x291, x289, x266, (0x0 as u32));
  let mut x292: u32 = 0;
  let mut x293: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x292, &mut x293, x291, x268, (0x0 as u32));
  let mut x294: u32 = 0;
  let mut x295: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x294, &mut x295, x293, x270, (0x0 as u32));
  let mut x296: u32 = 0;
  let mut x297: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x296, &mut x297, x295, x272, (0x0 as u32));
  let mut x298: u32 = 0;
  let mut x299: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x298, &mut x299, x297, x274, (0x0 as u32));
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_p384_mulx_u32(&mut x300, &mut x301, x276, 0xffffffff);
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_p384_mulx_u32(&mut x302, &mut x303, x276, 0xffffffff);
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_p384_mulx_u32(&mut x304, &mut x305, x276, 0xffffffff);
  let mut x306: u32 = 0;
  let mut x307: u32 = 0;
  fiat_p384_mulx_u32(&mut x306, &mut x307, x276, 0xffffffff);
  let mut x308: u32 = 0;
  let mut x309: u32 = 0;
  fiat_p384_mulx_u32(&mut x308, &mut x309, x276, 0xffffffff);
  let mut x310: u32 = 0;
  let mut x311: u32 = 0;
  fiat_p384_mulx_u32(&mut x310, &mut x311, x276, 0xffffffff);
  let mut x312: u32 = 0;
  let mut x313: u32 = 0;
  fiat_p384_mulx_u32(&mut x312, &mut x313, x276, 0xffffffff);
  let mut x314: u32 = 0;
  let mut x315: u32 = 0;
  fiat_p384_mulx_u32(&mut x314, &mut x315, x276, 0xfffffffe);
  let mut x316: u32 = 0;
  let mut x317: u32 = 0;
  fiat_p384_mulx_u32(&mut x316, &mut x317, x276, 0xffffffff);
  let mut x318: u32 = 0;
  let mut x319: u32 = 0;
  fiat_p384_mulx_u32(&mut x318, &mut x319, x276, 0xffffffff);
  let mut x320: u32 = 0;
  let mut x321: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x320, &mut x321, 0x0, x317, x314);
  let mut x322: u32 = 0;
  let mut x323: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x322, &mut x323, x321, x315, x312);
  let mut x324: u32 = 0;
  let mut x325: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x324, &mut x325, x323, x313, x310);
  let mut x326: u32 = 0;
  let mut x327: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x326, &mut x327, x325, x311, x308);
  let mut x328: u32 = 0;
  let mut x329: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x328, &mut x329, x327, x309, x306);
  let mut x330: u32 = 0;
  let mut x331: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x330, &mut x331, x329, x307, x304);
  let mut x332: u32 = 0;
  let mut x333: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x332, &mut x333, x331, x305, x302);
  let mut x334: u32 = 0;
  let mut x335: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x334, &mut x335, x333, x303, x300);
  let mut x336: u32 = 0;
  let mut x337: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x336, &mut x337, 0x0, x276, x318);
  let mut x338: u32 = 0;
  let mut x339: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x338, &mut x339, x337, x278, x319);
  let mut x340: u32 = 0;
  let mut x341: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x340, &mut x341, x339, x280, (0x0 as u32));
  let mut x342: u32 = 0;
  let mut x343: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x342, &mut x343, x341, x282, x316);
  let mut x344: u32 = 0;
  let mut x345: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x344, &mut x345, x343, x284, x320);
  let mut x346: u32 = 0;
  let mut x347: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x346, &mut x347, x345, x286, x322);
  let mut x348: u32 = 0;
  let mut x349: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x348, &mut x349, x347, x288, x324);
  let mut x350: u32 = 0;
  let mut x351: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x350, &mut x351, x349, x290, x326);
  let mut x352: u32 = 0;
  let mut x353: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x352, &mut x353, x351, x292, x328);
  let mut x354: u32 = 0;
  let mut x355: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x354, &mut x355, x353, x294, x330);
  let mut x356: u32 = 0;
  let mut x357: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x356, &mut x357, x355, x296, x332);
  let mut x358: u32 = 0;
  let mut x359: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x358, &mut x359, x357, x298, x334);
  let mut x360: u32 = 0;
  let mut x361: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x360, &mut x361, x359, ((x299 as u32) + (x275 as u32)), ((x335 as u32) + x301));
  let mut x362: u32 = 0;
  let mut x363: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x362, &mut x363, 0x0, x338, (arg1[5]));
  let mut x364: u32 = 0;
  let mut x365: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x364, &mut x365, x363, x340, (0x0 as u32));
  let mut x366: u32 = 0;
  let mut x367: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x366, &mut x367, x365, x342, (0x0 as u32));
  let mut x368: u32 = 0;
  let mut x369: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x368, &mut x369, x367, x344, (0x0 as u32));
  let mut x370: u32 = 0;
  let mut x371: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x370, &mut x371, x369, x346, (0x0 as u32));
  let mut x372: u32 = 0;
  let mut x373: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x372, &mut x373, x371, x348, (0x0 as u32));
  let mut x374: u32 = 0;
  let mut x375: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x374, &mut x375, x373, x350, (0x0 as u32));
  let mut x376: u32 = 0;
  let mut x377: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x376, &mut x377, x375, x352, (0x0 as u32));
  let mut x378: u32 = 0;
  let mut x379: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x378, &mut x379, x377, x354, (0x0 as u32));
  let mut x380: u32 = 0;
  let mut x381: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x380, &mut x381, x379, x356, (0x0 as u32));
  let mut x382: u32 = 0;
  let mut x383: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x382, &mut x383, x381, x358, (0x0 as u32));
  let mut x384: u32 = 0;
  let mut x385: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x384, &mut x385, x383, x360, (0x0 as u32));
  let mut x386: u32 = 0;
  let mut x387: u32 = 0;
  fiat_p384_mulx_u32(&mut x386, &mut x387, x362, 0xffffffff);
  let mut x388: u32 = 0;
  let mut x389: u32 = 0;
  fiat_p384_mulx_u32(&mut x388, &mut x389, x362, 0xffffffff);
  let mut x390: u32 = 0;
  let mut x391: u32 = 0;
  fiat_p384_mulx_u32(&mut x390, &mut x391, x362, 0xffffffff);
  let mut x392: u32 = 0;
  let mut x393: u32 = 0;
  fiat_p384_mulx_u32(&mut x392, &mut x393, x362, 0xffffffff);
  let mut x394: u32 = 0;
  let mut x395: u32 = 0;
  fiat_p384_mulx_u32(&mut x394, &mut x395, x362, 0xffffffff);
  let mut x396: u32 = 0;
  let mut x397: u32 = 0;
  fiat_p384_mulx_u32(&mut x396, &mut x397, x362, 0xffffffff);
  let mut x398: u32 = 0;
  let mut x399: u32 = 0;
  fiat_p384_mulx_u32(&mut x398, &mut x399, x362, 0xffffffff);
  let mut x400: u32 = 0;
  let mut x401: u32 = 0;
  fiat_p384_mulx_u32(&mut x400, &mut x401, x362, 0xfffffffe);
  let mut x402: u32 = 0;
  let mut x403: u32 = 0;
  fiat_p384_mulx_u32(&mut x402, &mut x403, x362, 0xffffffff);
  let mut x404: u32 = 0;
  let mut x405: u32 = 0;
  fiat_p384_mulx_u32(&mut x404, &mut x405, x362, 0xffffffff);
  let mut x406: u32 = 0;
  let mut x407: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x406, &mut x407, 0x0, x403, x400);
  let mut x408: u32 = 0;
  let mut x409: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x408, &mut x409, x407, x401, x398);
  let mut x410: u32 = 0;
  let mut x411: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x410, &mut x411, x409, x399, x396);
  let mut x412: u32 = 0;
  let mut x413: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x412, &mut x413, x411, x397, x394);
  let mut x414: u32 = 0;
  let mut x415: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x414, &mut x415, x413, x395, x392);
  let mut x416: u32 = 0;
  let mut x417: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x416, &mut x417, x415, x393, x390);
  let mut x418: u32 = 0;
  let mut x419: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x418, &mut x419, x417, x391, x388);
  let mut x420: u32 = 0;
  let mut x421: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x420, &mut x421, x419, x389, x386);
  let mut x422: u32 = 0;
  let mut x423: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x422, &mut x423, 0x0, x362, x404);
  let mut x424: u32 = 0;
  let mut x425: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x424, &mut x425, x423, x364, x405);
  let mut x426: u32 = 0;
  let mut x427: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x426, &mut x427, x425, x366, (0x0 as u32));
  let mut x428: u32 = 0;
  let mut x429: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x428, &mut x429, x427, x368, x402);
  let mut x430: u32 = 0;
  let mut x431: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x430, &mut x431, x429, x370, x406);
  let mut x432: u32 = 0;
  let mut x433: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x432, &mut x433, x431, x372, x408);
  let mut x434: u32 = 0;
  let mut x435: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x434, &mut x435, x433, x374, x410);
  let mut x436: u32 = 0;
  let mut x437: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x436, &mut x437, x435, x376, x412);
  let mut x438: u32 = 0;
  let mut x439: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x438, &mut x439, x437, x378, x414);
  let mut x440: u32 = 0;
  let mut x441: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x440, &mut x441, x439, x380, x416);
  let mut x442: u32 = 0;
  let mut x443: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x442, &mut x443, x441, x382, x418);
  let mut x444: u32 = 0;
  let mut x445: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x444, &mut x445, x443, x384, x420);
  let mut x446: u32 = 0;
  let mut x447: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x446, &mut x447, x445, ((x385 as u32) + (x361 as u32)), ((x421 as u32) + x387));
  let mut x448: u32 = 0;
  let mut x449: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x448, &mut x449, 0x0, x424, (arg1[6]));
  let mut x450: u32 = 0;
  let mut x451: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x450, &mut x451, x449, x426, (0x0 as u32));
  let mut x452: u32 = 0;
  let mut x453: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x452, &mut x453, x451, x428, (0x0 as u32));
  let mut x454: u32 = 0;
  let mut x455: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x454, &mut x455, x453, x430, (0x0 as u32));
  let mut x456: u32 = 0;
  let mut x457: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x456, &mut x457, x455, x432, (0x0 as u32));
  let mut x458: u32 = 0;
  let mut x459: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x458, &mut x459, x457, x434, (0x0 as u32));
  let mut x460: u32 = 0;
  let mut x461: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x460, &mut x461, x459, x436, (0x0 as u32));
  let mut x462: u32 = 0;
  let mut x463: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x462, &mut x463, x461, x438, (0x0 as u32));
  let mut x464: u32 = 0;
  let mut x465: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x464, &mut x465, x463, x440, (0x0 as u32));
  let mut x466: u32 = 0;
  let mut x467: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x466, &mut x467, x465, x442, (0x0 as u32));
  let mut x468: u32 = 0;
  let mut x469: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x468, &mut x469, x467, x444, (0x0 as u32));
  let mut x470: u32 = 0;
  let mut x471: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x470, &mut x471, x469, x446, (0x0 as u32));
  let mut x472: u32 = 0;
  let mut x473: u32 = 0;
  fiat_p384_mulx_u32(&mut x472, &mut x473, x448, 0xffffffff);
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_p384_mulx_u32(&mut x474, &mut x475, x448, 0xffffffff);
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_p384_mulx_u32(&mut x476, &mut x477, x448, 0xffffffff);
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_p384_mulx_u32(&mut x478, &mut x479, x448, 0xffffffff);
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_p384_mulx_u32(&mut x480, &mut x481, x448, 0xffffffff);
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_p384_mulx_u32(&mut x482, &mut x483, x448, 0xffffffff);
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_p384_mulx_u32(&mut x484, &mut x485, x448, 0xffffffff);
  let mut x486: u32 = 0;
  let mut x487: u32 = 0;
  fiat_p384_mulx_u32(&mut x486, &mut x487, x448, 0xfffffffe);
  let mut x488: u32 = 0;
  let mut x489: u32 = 0;
  fiat_p384_mulx_u32(&mut x488, &mut x489, x448, 0xffffffff);
  let mut x490: u32 = 0;
  let mut x491: u32 = 0;
  fiat_p384_mulx_u32(&mut x490, &mut x491, x448, 0xffffffff);
  let mut x492: u32 = 0;
  let mut x493: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x492, &mut x493, 0x0, x489, x486);
  let mut x494: u32 = 0;
  let mut x495: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x494, &mut x495, x493, x487, x484);
  let mut x496: u32 = 0;
  let mut x497: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x496, &mut x497, x495, x485, x482);
  let mut x498: u32 = 0;
  let mut x499: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x498, &mut x499, x497, x483, x480);
  let mut x500: u32 = 0;
  let mut x501: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x500, &mut x501, x499, x481, x478);
  let mut x502: u32 = 0;
  let mut x503: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x502, &mut x503, x501, x479, x476);
  let mut x504: u32 = 0;
  let mut x505: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x504, &mut x505, x503, x477, x474);
  let mut x506: u32 = 0;
  let mut x507: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x506, &mut x507, x505, x475, x472);
  let mut x508: u32 = 0;
  let mut x509: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x508, &mut x509, 0x0, x448, x490);
  let mut x510: u32 = 0;
  let mut x511: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x510, &mut x511, x509, x450, x491);
  let mut x512: u32 = 0;
  let mut x513: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x512, &mut x513, x511, x452, (0x0 as u32));
  let mut x514: u32 = 0;
  let mut x515: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x514, &mut x515, x513, x454, x488);
  let mut x516: u32 = 0;
  let mut x517: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x516, &mut x517, x515, x456, x492);
  let mut x518: u32 = 0;
  let mut x519: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x518, &mut x519, x517, x458, x494);
  let mut x520: u32 = 0;
  let mut x521: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x520, &mut x521, x519, x460, x496);
  let mut x522: u32 = 0;
  let mut x523: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x522, &mut x523, x521, x462, x498);
  let mut x524: u32 = 0;
  let mut x525: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x524, &mut x525, x523, x464, x500);
  let mut x526: u32 = 0;
  let mut x527: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x526, &mut x527, x525, x466, x502);
  let mut x528: u32 = 0;
  let mut x529: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x528, &mut x529, x527, x468, x504);
  let mut x530: u32 = 0;
  let mut x531: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x530, &mut x531, x529, x470, x506);
  let mut x532: u32 = 0;
  let mut x533: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x532, &mut x533, x531, ((x471 as u32) + (x447 as u32)), ((x507 as u32) + x473));
  let mut x534: u32 = 0;
  let mut x535: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x534, &mut x535, 0x0, x510, (arg1[7]));
  let mut x536: u32 = 0;
  let mut x537: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x536, &mut x537, x535, x512, (0x0 as u32));
  let mut x538: u32 = 0;
  let mut x539: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x538, &mut x539, x537, x514, (0x0 as u32));
  let mut x540: u32 = 0;
  let mut x541: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x540, &mut x541, x539, x516, (0x0 as u32));
  let mut x542: u32 = 0;
  let mut x543: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x542, &mut x543, x541, x518, (0x0 as u32));
  let mut x544: u32 = 0;
  let mut x545: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x544, &mut x545, x543, x520, (0x0 as u32));
  let mut x546: u32 = 0;
  let mut x547: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x546, &mut x547, x545, x522, (0x0 as u32));
  let mut x548: u32 = 0;
  let mut x549: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x548, &mut x549, x547, x524, (0x0 as u32));
  let mut x550: u32 = 0;
  let mut x551: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x550, &mut x551, x549, x526, (0x0 as u32));
  let mut x552: u32 = 0;
  let mut x553: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x552, &mut x553, x551, x528, (0x0 as u32));
  let mut x554: u32 = 0;
  let mut x555: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x554, &mut x555, x553, x530, (0x0 as u32));
  let mut x556: u32 = 0;
  let mut x557: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x556, &mut x557, x555, x532, (0x0 as u32));
  let mut x558: u32 = 0;
  let mut x559: u32 = 0;
  fiat_p384_mulx_u32(&mut x558, &mut x559, x534, 0xffffffff);
  let mut x560: u32 = 0;
  let mut x561: u32 = 0;
  fiat_p384_mulx_u32(&mut x560, &mut x561, x534, 0xffffffff);
  let mut x562: u32 = 0;
  let mut x563: u32 = 0;
  fiat_p384_mulx_u32(&mut x562, &mut x563, x534, 0xffffffff);
  let mut x564: u32 = 0;
  let mut x565: u32 = 0;
  fiat_p384_mulx_u32(&mut x564, &mut x565, x534, 0xffffffff);
  let mut x566: u32 = 0;
  let mut x567: u32 = 0;
  fiat_p384_mulx_u32(&mut x566, &mut x567, x534, 0xffffffff);
  let mut x568: u32 = 0;
  let mut x569: u32 = 0;
  fiat_p384_mulx_u32(&mut x568, &mut x569, x534, 0xffffffff);
  let mut x570: u32 = 0;
  let mut x571: u32 = 0;
  fiat_p384_mulx_u32(&mut x570, &mut x571, x534, 0xffffffff);
  let mut x572: u32 = 0;
  let mut x573: u32 = 0;
  fiat_p384_mulx_u32(&mut x572, &mut x573, x534, 0xfffffffe);
  let mut x574: u32 = 0;
  let mut x575: u32 = 0;
  fiat_p384_mulx_u32(&mut x574, &mut x575, x534, 0xffffffff);
  let mut x576: u32 = 0;
  let mut x577: u32 = 0;
  fiat_p384_mulx_u32(&mut x576, &mut x577, x534, 0xffffffff);
  let mut x578: u32 = 0;
  let mut x579: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x578, &mut x579, 0x0, x575, x572);
  let mut x580: u32 = 0;
  let mut x581: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x580, &mut x581, x579, x573, x570);
  let mut x582: u32 = 0;
  let mut x583: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x582, &mut x583, x581, x571, x568);
  let mut x584: u32 = 0;
  let mut x585: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x584, &mut x585, x583, x569, x566);
  let mut x586: u32 = 0;
  let mut x587: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x586, &mut x587, x585, x567, x564);
  let mut x588: u32 = 0;
  let mut x589: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x588, &mut x589, x587, x565, x562);
  let mut x590: u32 = 0;
  let mut x591: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x590, &mut x591, x589, x563, x560);
  let mut x592: u32 = 0;
  let mut x593: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x592, &mut x593, x591, x561, x558);
  let mut x594: u32 = 0;
  let mut x595: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x594, &mut x595, 0x0, x534, x576);
  let mut x596: u32 = 0;
  let mut x597: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x596, &mut x597, x595, x536, x577);
  let mut x598: u32 = 0;
  let mut x599: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x598, &mut x599, x597, x538, (0x0 as u32));
  let mut x600: u32 = 0;
  let mut x601: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x600, &mut x601, x599, x540, x574);
  let mut x602: u32 = 0;
  let mut x603: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x602, &mut x603, x601, x542, x578);
  let mut x604: u32 = 0;
  let mut x605: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x604, &mut x605, x603, x544, x580);
  let mut x606: u32 = 0;
  let mut x607: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x606, &mut x607, x605, x546, x582);
  let mut x608: u32 = 0;
  let mut x609: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x608, &mut x609, x607, x548, x584);
  let mut x610: u32 = 0;
  let mut x611: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x610, &mut x611, x609, x550, x586);
  let mut x612: u32 = 0;
  let mut x613: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x612, &mut x613, x611, x552, x588);
  let mut x614: u32 = 0;
  let mut x615: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x614, &mut x615, x613, x554, x590);
  let mut x616: u32 = 0;
  let mut x617: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x616, &mut x617, x615, x556, x592);
  let mut x618: u32 = 0;
  let mut x619: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x618, &mut x619, x617, ((x557 as u32) + (x533 as u32)), ((x593 as u32) + x559));
  let mut x620: u32 = 0;
  let mut x621: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x620, &mut x621, 0x0, x596, (arg1[8]));
  let mut x622: u32 = 0;
  let mut x623: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x622, &mut x623, x621, x598, (0x0 as u32));
  let mut x624: u32 = 0;
  let mut x625: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x624, &mut x625, x623, x600, (0x0 as u32));
  let mut x626: u32 = 0;
  let mut x627: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x626, &mut x627, x625, x602, (0x0 as u32));
  let mut x628: u32 = 0;
  let mut x629: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x628, &mut x629, x627, x604, (0x0 as u32));
  let mut x630: u32 = 0;
  let mut x631: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x630, &mut x631, x629, x606, (0x0 as u32));
  let mut x632: u32 = 0;
  let mut x633: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x632, &mut x633, x631, x608, (0x0 as u32));
  let mut x634: u32 = 0;
  let mut x635: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x634, &mut x635, x633, x610, (0x0 as u32));
  let mut x636: u32 = 0;
  let mut x637: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x636, &mut x637, x635, x612, (0x0 as u32));
  let mut x638: u32 = 0;
  let mut x639: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x638, &mut x639, x637, x614, (0x0 as u32));
  let mut x640: u32 = 0;
  let mut x641: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x640, &mut x641, x639, x616, (0x0 as u32));
  let mut x642: u32 = 0;
  let mut x643: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x642, &mut x643, x641, x618, (0x0 as u32));
  let mut x644: u32 = 0;
  let mut x645: u32 = 0;
  fiat_p384_mulx_u32(&mut x644, &mut x645, x620, 0xffffffff);
  let mut x646: u32 = 0;
  let mut x647: u32 = 0;
  fiat_p384_mulx_u32(&mut x646, &mut x647, x620, 0xffffffff);
  let mut x648: u32 = 0;
  let mut x649: u32 = 0;
  fiat_p384_mulx_u32(&mut x648, &mut x649, x620, 0xffffffff);
  let mut x650: u32 = 0;
  let mut x651: u32 = 0;
  fiat_p384_mulx_u32(&mut x650, &mut x651, x620, 0xffffffff);
  let mut x652: u32 = 0;
  let mut x653: u32 = 0;
  fiat_p384_mulx_u32(&mut x652, &mut x653, x620, 0xffffffff);
  let mut x654: u32 = 0;
  let mut x655: u32 = 0;
  fiat_p384_mulx_u32(&mut x654, &mut x655, x620, 0xffffffff);
  let mut x656: u32 = 0;
  let mut x657: u32 = 0;
  fiat_p384_mulx_u32(&mut x656, &mut x657, x620, 0xffffffff);
  let mut x658: u32 = 0;
  let mut x659: u32 = 0;
  fiat_p384_mulx_u32(&mut x658, &mut x659, x620, 0xfffffffe);
  let mut x660: u32 = 0;
  let mut x661: u32 = 0;
  fiat_p384_mulx_u32(&mut x660, &mut x661, x620, 0xffffffff);
  let mut x662: u32 = 0;
  let mut x663: u32 = 0;
  fiat_p384_mulx_u32(&mut x662, &mut x663, x620, 0xffffffff);
  let mut x664: u32 = 0;
  let mut x665: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x664, &mut x665, 0x0, x661, x658);
  let mut x666: u32 = 0;
  let mut x667: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x666, &mut x667, x665, x659, x656);
  let mut x668: u32 = 0;
  let mut x669: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x668, &mut x669, x667, x657, x654);
  let mut x670: u32 = 0;
  let mut x671: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x670, &mut x671, x669, x655, x652);
  let mut x672: u32 = 0;
  let mut x673: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x672, &mut x673, x671, x653, x650);
  let mut x674: u32 = 0;
  let mut x675: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x674, &mut x675, x673, x651, x648);
  let mut x676: u32 = 0;
  let mut x677: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x676, &mut x677, x675, x649, x646);
  let mut x678: u32 = 0;
  let mut x679: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x678, &mut x679, x677, x647, x644);
  let mut x680: u32 = 0;
  let mut x681: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x680, &mut x681, 0x0, x620, x662);
  let mut x682: u32 = 0;
  let mut x683: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x682, &mut x683, x681, x622, x663);
  let mut x684: u32 = 0;
  let mut x685: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x684, &mut x685, x683, x624, (0x0 as u32));
  let mut x686: u32 = 0;
  let mut x687: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x686, &mut x687, x685, x626, x660);
  let mut x688: u32 = 0;
  let mut x689: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x688, &mut x689, x687, x628, x664);
  let mut x690: u32 = 0;
  let mut x691: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x690, &mut x691, x689, x630, x666);
  let mut x692: u32 = 0;
  let mut x693: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x692, &mut x693, x691, x632, x668);
  let mut x694: u32 = 0;
  let mut x695: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x694, &mut x695, x693, x634, x670);
  let mut x696: u32 = 0;
  let mut x697: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x696, &mut x697, x695, x636, x672);
  let mut x698: u32 = 0;
  let mut x699: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x698, &mut x699, x697, x638, x674);
  let mut x700: u32 = 0;
  let mut x701: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x700, &mut x701, x699, x640, x676);
  let mut x702: u32 = 0;
  let mut x703: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x702, &mut x703, x701, x642, x678);
  let mut x704: u32 = 0;
  let mut x705: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x704, &mut x705, x703, ((x643 as u32) + (x619 as u32)), ((x679 as u32) + x645));
  let mut x706: u32 = 0;
  let mut x707: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x706, &mut x707, 0x0, x682, (arg1[9]));
  let mut x708: u32 = 0;
  let mut x709: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x708, &mut x709, x707, x684, (0x0 as u32));
  let mut x710: u32 = 0;
  let mut x711: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x710, &mut x711, x709, x686, (0x0 as u32));
  let mut x712: u32 = 0;
  let mut x713: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x712, &mut x713, x711, x688, (0x0 as u32));
  let mut x714: u32 = 0;
  let mut x715: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x714, &mut x715, x713, x690, (0x0 as u32));
  let mut x716: u32 = 0;
  let mut x717: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x716, &mut x717, x715, x692, (0x0 as u32));
  let mut x718: u32 = 0;
  let mut x719: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x718, &mut x719, x717, x694, (0x0 as u32));
  let mut x720: u32 = 0;
  let mut x721: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x720, &mut x721, x719, x696, (0x0 as u32));
  let mut x722: u32 = 0;
  let mut x723: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x722, &mut x723, x721, x698, (0x0 as u32));
  let mut x724: u32 = 0;
  let mut x725: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x724, &mut x725, x723, x700, (0x0 as u32));
  let mut x726: u32 = 0;
  let mut x727: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x726, &mut x727, x725, x702, (0x0 as u32));
  let mut x728: u32 = 0;
  let mut x729: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x728, &mut x729, x727, x704, (0x0 as u32));
  let mut x730: u32 = 0;
  let mut x731: u32 = 0;
  fiat_p384_mulx_u32(&mut x730, &mut x731, x706, 0xffffffff);
  let mut x732: u32 = 0;
  let mut x733: u32 = 0;
  fiat_p384_mulx_u32(&mut x732, &mut x733, x706, 0xffffffff);
  let mut x734: u32 = 0;
  let mut x735: u32 = 0;
  fiat_p384_mulx_u32(&mut x734, &mut x735, x706, 0xffffffff);
  let mut x736: u32 = 0;
  let mut x737: u32 = 0;
  fiat_p384_mulx_u32(&mut x736, &mut x737, x706, 0xffffffff);
  let mut x738: u32 = 0;
  let mut x739: u32 = 0;
  fiat_p384_mulx_u32(&mut x738, &mut x739, x706, 0xffffffff);
  let mut x740: u32 = 0;
  let mut x741: u32 = 0;
  fiat_p384_mulx_u32(&mut x740, &mut x741, x706, 0xffffffff);
  let mut x742: u32 = 0;
  let mut x743: u32 = 0;
  fiat_p384_mulx_u32(&mut x742, &mut x743, x706, 0xffffffff);
  let mut x744: u32 = 0;
  let mut x745: u32 = 0;
  fiat_p384_mulx_u32(&mut x744, &mut x745, x706, 0xfffffffe);
  let mut x746: u32 = 0;
  let mut x747: u32 = 0;
  fiat_p384_mulx_u32(&mut x746, &mut x747, x706, 0xffffffff);
  let mut x748: u32 = 0;
  let mut x749: u32 = 0;
  fiat_p384_mulx_u32(&mut x748, &mut x749, x706, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x750, &mut x751, 0x0, x747, x744);
  let mut x752: u32 = 0;
  let mut x753: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x752, &mut x753, x751, x745, x742);
  let mut x754: u32 = 0;
  let mut x755: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x754, &mut x755, x753, x743, x740);
  let mut x756: u32 = 0;
  let mut x757: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x756, &mut x757, x755, x741, x738);
  let mut x758: u32 = 0;
  let mut x759: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x758, &mut x759, x757, x739, x736);
  let mut x760: u32 = 0;
  let mut x761: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x760, &mut x761, x759, x737, x734);
  let mut x762: u32 = 0;
  let mut x763: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x762, &mut x763, x761, x735, x732);
  let mut x764: u32 = 0;
  let mut x765: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x764, &mut x765, x763, x733, x730);
  let mut x766: u32 = 0;
  let mut x767: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x766, &mut x767, 0x0, x706, x748);
  let mut x768: u32 = 0;
  let mut x769: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x768, &mut x769, x767, x708, x749);
  let mut x770: u32 = 0;
  let mut x771: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x770, &mut x771, x769, x710, (0x0 as u32));
  let mut x772: u32 = 0;
  let mut x773: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x772, &mut x773, x771, x712, x746);
  let mut x774: u32 = 0;
  let mut x775: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x774, &mut x775, x773, x714, x750);
  let mut x776: u32 = 0;
  let mut x777: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x776, &mut x777, x775, x716, x752);
  let mut x778: u32 = 0;
  let mut x779: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x778, &mut x779, x777, x718, x754);
  let mut x780: u32 = 0;
  let mut x781: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x780, &mut x781, x779, x720, x756);
  let mut x782: u32 = 0;
  let mut x783: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x782, &mut x783, x781, x722, x758);
  let mut x784: u32 = 0;
  let mut x785: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x784, &mut x785, x783, x724, x760);
  let mut x786: u32 = 0;
  let mut x787: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x786, &mut x787, x785, x726, x762);
  let mut x788: u32 = 0;
  let mut x789: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x788, &mut x789, x787, x728, x764);
  let mut x790: u32 = 0;
  let mut x791: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x790, &mut x791, x789, ((x729 as u32) + (x705 as u32)), ((x765 as u32) + x731));
  let mut x792: u32 = 0;
  let mut x793: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x792, &mut x793, 0x0, x768, (arg1[10]));
  let mut x794: u32 = 0;
  let mut x795: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x794, &mut x795, x793, x770, (0x0 as u32));
  let mut x796: u32 = 0;
  let mut x797: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x796, &mut x797, x795, x772, (0x0 as u32));
  let mut x798: u32 = 0;
  let mut x799: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x798, &mut x799, x797, x774, (0x0 as u32));
  let mut x800: u32 = 0;
  let mut x801: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x800, &mut x801, x799, x776, (0x0 as u32));
  let mut x802: u32 = 0;
  let mut x803: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x802, &mut x803, x801, x778, (0x0 as u32));
  let mut x804: u32 = 0;
  let mut x805: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x804, &mut x805, x803, x780, (0x0 as u32));
  let mut x806: u32 = 0;
  let mut x807: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x806, &mut x807, x805, x782, (0x0 as u32));
  let mut x808: u32 = 0;
  let mut x809: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x808, &mut x809, x807, x784, (0x0 as u32));
  let mut x810: u32 = 0;
  let mut x811: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x810, &mut x811, x809, x786, (0x0 as u32));
  let mut x812: u32 = 0;
  let mut x813: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x812, &mut x813, x811, x788, (0x0 as u32));
  let mut x814: u32 = 0;
  let mut x815: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x814, &mut x815, x813, x790, (0x0 as u32));
  let mut x816: u32 = 0;
  let mut x817: u32 = 0;
  fiat_p384_mulx_u32(&mut x816, &mut x817, x792, 0xffffffff);
  let mut x818: u32 = 0;
  let mut x819: u32 = 0;
  fiat_p384_mulx_u32(&mut x818, &mut x819, x792, 0xffffffff);
  let mut x820: u32 = 0;
  let mut x821: u32 = 0;
  fiat_p384_mulx_u32(&mut x820, &mut x821, x792, 0xffffffff);
  let mut x822: u32 = 0;
  let mut x823: u32 = 0;
  fiat_p384_mulx_u32(&mut x822, &mut x823, x792, 0xffffffff);
  let mut x824: u32 = 0;
  let mut x825: u32 = 0;
  fiat_p384_mulx_u32(&mut x824, &mut x825, x792, 0xffffffff);
  let mut x826: u32 = 0;
  let mut x827: u32 = 0;
  fiat_p384_mulx_u32(&mut x826, &mut x827, x792, 0xffffffff);
  let mut x828: u32 = 0;
  let mut x829: u32 = 0;
  fiat_p384_mulx_u32(&mut x828, &mut x829, x792, 0xffffffff);
  let mut x830: u32 = 0;
  let mut x831: u32 = 0;
  fiat_p384_mulx_u32(&mut x830, &mut x831, x792, 0xfffffffe);
  let mut x832: u32 = 0;
  let mut x833: u32 = 0;
  fiat_p384_mulx_u32(&mut x832, &mut x833, x792, 0xffffffff);
  let mut x834: u32 = 0;
  let mut x835: u32 = 0;
  fiat_p384_mulx_u32(&mut x834, &mut x835, x792, 0xffffffff);
  let mut x836: u32 = 0;
  let mut x837: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x836, &mut x837, 0x0, x833, x830);
  let mut x838: u32 = 0;
  let mut x839: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x838, &mut x839, x837, x831, x828);
  let mut x840: u32 = 0;
  let mut x841: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x840, &mut x841, x839, x829, x826);
  let mut x842: u32 = 0;
  let mut x843: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x842, &mut x843, x841, x827, x824);
  let mut x844: u32 = 0;
  let mut x845: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x844, &mut x845, x843, x825, x822);
  let mut x846: u32 = 0;
  let mut x847: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x846, &mut x847, x845, x823, x820);
  let mut x848: u32 = 0;
  let mut x849: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x848, &mut x849, x847, x821, x818);
  let mut x850: u32 = 0;
  let mut x851: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x850, &mut x851, x849, x819, x816);
  let mut x852: u32 = 0;
  let mut x853: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x852, &mut x853, 0x0, x792, x834);
  let mut x854: u32 = 0;
  let mut x855: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x854, &mut x855, x853, x794, x835);
  let mut x856: u32 = 0;
  let mut x857: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x856, &mut x857, x855, x796, (0x0 as u32));
  let mut x858: u32 = 0;
  let mut x859: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x858, &mut x859, x857, x798, x832);
  let mut x860: u32 = 0;
  let mut x861: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x860, &mut x861, x859, x800, x836);
  let mut x862: u32 = 0;
  let mut x863: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x862, &mut x863, x861, x802, x838);
  let mut x864: u32 = 0;
  let mut x865: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x864, &mut x865, x863, x804, x840);
  let mut x866: u32 = 0;
  let mut x867: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x866, &mut x867, x865, x806, x842);
  let mut x868: u32 = 0;
  let mut x869: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x868, &mut x869, x867, x808, x844);
  let mut x870: u32 = 0;
  let mut x871: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x870, &mut x871, x869, x810, x846);
  let mut x872: u32 = 0;
  let mut x873: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x872, &mut x873, x871, x812, x848);
  let mut x874: u32 = 0;
  let mut x875: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x874, &mut x875, x873, x814, x850);
  let mut x876: u32 = 0;
  let mut x877: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x876, &mut x877, x875, ((x815 as u32) + (x791 as u32)), ((x851 as u32) + x817));
  let mut x878: u32 = 0;
  let mut x879: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x878, &mut x879, 0x0, x854, (arg1[11]));
  let mut x880: u32 = 0;
  let mut x881: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x880, &mut x881, x879, x856, (0x0 as u32));
  let mut x882: u32 = 0;
  let mut x883: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x882, &mut x883, x881, x858, (0x0 as u32));
  let mut x884: u32 = 0;
  let mut x885: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x884, &mut x885, x883, x860, (0x0 as u32));
  let mut x886: u32 = 0;
  let mut x887: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x886, &mut x887, x885, x862, (0x0 as u32));
  let mut x888: u32 = 0;
  let mut x889: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x888, &mut x889, x887, x864, (0x0 as u32));
  let mut x890: u32 = 0;
  let mut x891: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x890, &mut x891, x889, x866, (0x0 as u32));
  let mut x892: u32 = 0;
  let mut x893: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x892, &mut x893, x891, x868, (0x0 as u32));
  let mut x894: u32 = 0;
  let mut x895: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x894, &mut x895, x893, x870, (0x0 as u32));
  let mut x896: u32 = 0;
  let mut x897: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x896, &mut x897, x895, x872, (0x0 as u32));
  let mut x898: u32 = 0;
  let mut x899: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x898, &mut x899, x897, x874, (0x0 as u32));
  let mut x900: u32 = 0;
  let mut x901: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x900, &mut x901, x899, x876, (0x0 as u32));
  let mut x902: u32 = 0;
  let mut x903: u32 = 0;
  fiat_p384_mulx_u32(&mut x902, &mut x903, x878, 0xffffffff);
  let mut x904: u32 = 0;
  let mut x905: u32 = 0;
  fiat_p384_mulx_u32(&mut x904, &mut x905, x878, 0xffffffff);
  let mut x906: u32 = 0;
  let mut x907: u32 = 0;
  fiat_p384_mulx_u32(&mut x906, &mut x907, x878, 0xffffffff);
  let mut x908: u32 = 0;
  let mut x909: u32 = 0;
  fiat_p384_mulx_u32(&mut x908, &mut x909, x878, 0xffffffff);
  let mut x910: u32 = 0;
  let mut x911: u32 = 0;
  fiat_p384_mulx_u32(&mut x910, &mut x911, x878, 0xffffffff);
  let mut x912: u32 = 0;
  let mut x913: u32 = 0;
  fiat_p384_mulx_u32(&mut x912, &mut x913, x878, 0xffffffff);
  let mut x914: u32 = 0;
  let mut x915: u32 = 0;
  fiat_p384_mulx_u32(&mut x914, &mut x915, x878, 0xffffffff);
  let mut x916: u32 = 0;
  let mut x917: u32 = 0;
  fiat_p384_mulx_u32(&mut x916, &mut x917, x878, 0xfffffffe);
  let mut x918: u32 = 0;
  let mut x919: u32 = 0;
  fiat_p384_mulx_u32(&mut x918, &mut x919, x878, 0xffffffff);
  let mut x920: u32 = 0;
  let mut x921: u32 = 0;
  fiat_p384_mulx_u32(&mut x920, &mut x921, x878, 0xffffffff);
  let mut x922: u32 = 0;
  let mut x923: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x922, &mut x923, 0x0, x919, x916);
  let mut x924: u32 = 0;
  let mut x925: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x924, &mut x925, x923, x917, x914);
  let mut x926: u32 = 0;
  let mut x927: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x926, &mut x927, x925, x915, x912);
  let mut x928: u32 = 0;
  let mut x929: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x928, &mut x929, x927, x913, x910);
  let mut x930: u32 = 0;
  let mut x931: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x930, &mut x931, x929, x911, x908);
  let mut x932: u32 = 0;
  let mut x933: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x932, &mut x933, x931, x909, x906);
  let mut x934: u32 = 0;
  let mut x935: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x934, &mut x935, x933, x907, x904);
  let mut x936: u32 = 0;
  let mut x937: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x936, &mut x937, x935, x905, x902);
  let mut x938: u32 = 0;
  let mut x939: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x938, &mut x939, 0x0, x878, x920);
  let mut x940: u32 = 0;
  let mut x941: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x940, &mut x941, x939, x880, x921);
  let mut x942: u32 = 0;
  let mut x943: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x942, &mut x943, x941, x882, (0x0 as u32));
  let mut x944: u32 = 0;
  let mut x945: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x944, &mut x945, x943, x884, x918);
  let mut x946: u32 = 0;
  let mut x947: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x946, &mut x947, x945, x886, x922);
  let mut x948: u32 = 0;
  let mut x949: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x948, &mut x949, x947, x888, x924);
  let mut x950: u32 = 0;
  let mut x951: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x950, &mut x951, x949, x890, x926);
  let mut x952: u32 = 0;
  let mut x953: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x952, &mut x953, x951, x892, x928);
  let mut x954: u32 = 0;
  let mut x955: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x954, &mut x955, x953, x894, x930);
  let mut x956: u32 = 0;
  let mut x957: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x956, &mut x957, x955, x896, x932);
  let mut x958: u32 = 0;
  let mut x959: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x958, &mut x959, x957, x898, x934);
  let mut x960: u32 = 0;
  let mut x961: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x960, &mut x961, x959, x900, x936);
  let mut x962: u32 = 0;
  let mut x963: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x962, &mut x963, x961, ((x901 as u32) + (x877 as u32)), ((x937 as u32) + x903));
  let mut x964: u32 = 0;
  let mut x965: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x964, &mut x965, 0x0, x940, 0xffffffff);
  let mut x966: u32 = 0;
  let mut x967: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x966, &mut x967, x965, x942, (0x0 as u32));
  let mut x968: u32 = 0;
  let mut x969: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x968, &mut x969, x967, x944, (0x0 as u32));
  let mut x970: u32 = 0;
  let mut x971: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x970, &mut x971, x969, x946, 0xffffffff);
  let mut x972: u32 = 0;
  let mut x973: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x972, &mut x973, x971, x948, 0xfffffffe);
  let mut x974: u32 = 0;
  let mut x975: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x974, &mut x975, x973, x950, 0xffffffff);
  let mut x976: u32 = 0;
  let mut x977: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x976, &mut x977, x975, x952, 0xffffffff);
  let mut x978: u32 = 0;
  let mut x979: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x978, &mut x979, x977, x954, 0xffffffff);
  let mut x980: u32 = 0;
  let mut x981: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x980, &mut x981, x979, x956, 0xffffffff);
  let mut x982: u32 = 0;
  let mut x983: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x982, &mut x983, x981, x958, 0xffffffff);
  let mut x984: u32 = 0;
  let mut x985: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x984, &mut x985, x983, x960, 0xffffffff);
  let mut x986: u32 = 0;
  let mut x987: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x986, &mut x987, x985, x962, 0xffffffff);
  let mut x988: u32 = 0;
  let mut x989: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x988, &mut x989, x987, (x963 as u32), (0x0 as u32));
  let mut x990: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x990, x989, x964, x940);
  let mut x991: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x991, x989, x966, x942);
  let mut x992: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x992, x989, x968, x944);
  let mut x993: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x993, x989, x970, x946);
  let mut x994: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x994, x989, x972, x948);
  let mut x995: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x995, x989, x974, x950);
  let mut x996: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x996, x989, x976, x952);
  let mut x997: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x997, x989, x978, x954);
  let mut x998: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x998, x989, x980, x956);
  let mut x999: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x999, x989, x982, x958);
  let mut x1000: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1000, x989, x984, x960);
  let mut x1001: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1001, x989, x986, x962);
  out1[0] = x990;
  out1[1] = x991;
  out1[2] = x992;
  out1[3] = x993;
  out1[4] = x994;
  out1[5] = x995;
  out1[6] = x996;
  out1[7] = x997;
  out1[8] = x998;
  out1[9] = x999;
  out1[10] = x1000;
  out1[11] = x1001;
}

/// The function fiat_p384_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_to_montgomery(out1: &mut fiat_p384_montgomery_domain_field_element, arg1: &fiat_p384_non_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[8]);
  let x9: u32 = (arg1[9]);
  let x10: u32 = (arg1[10]);
  let x11: u32 = (arg1[11]);
  let x12: u32 = (arg1[0]);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p384_mulx_u32(&mut x13, &mut x14, x12, 0x2);
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p384_mulx_u32(&mut x15, &mut x16, x12, 0xfffffffe);
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p384_mulx_u32(&mut x17, &mut x18, x12, 0x2);
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p384_mulx_u32(&mut x19, &mut x20, x12, 0xfffffffe);
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x21, &mut x22, 0x0, ((x14 as fiat_p384_u1) as u32), x12);
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p384_mulx_u32(&mut x23, &mut x24, x12, 0xffffffff);
  let mut x25: u32 = 0;
  let mut x26: u32 = 0;
  fiat_p384_mulx_u32(&mut x25, &mut x26, x12, 0xffffffff);
  let mut x27: u32 = 0;
  let mut x28: u32 = 0;
  fiat_p384_mulx_u32(&mut x27, &mut x28, x12, 0xffffffff);
  let mut x29: u32 = 0;
  let mut x30: u32 = 0;
  fiat_p384_mulx_u32(&mut x29, &mut x30, x12, 0xffffffff);
  let mut x31: u32 = 0;
  let mut x32: u32 = 0;
  fiat_p384_mulx_u32(&mut x31, &mut x32, x12, 0xffffffff);
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p384_mulx_u32(&mut x33, &mut x34, x12, 0xffffffff);
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p384_mulx_u32(&mut x35, &mut x36, x12, 0xffffffff);
  let mut x37: u32 = 0;
  let mut x38: u32 = 0;
  fiat_p384_mulx_u32(&mut x37, &mut x38, x12, 0xfffffffe);
  let mut x39: u32 = 0;
  let mut x40: u32 = 0;
  fiat_p384_mulx_u32(&mut x39, &mut x40, x12, 0xffffffff);
  let mut x41: u32 = 0;
  let mut x42: u32 = 0;
  fiat_p384_mulx_u32(&mut x41, &mut x42, x12, 0xffffffff);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x43, &mut x44, 0x0, x40, x37);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x45, &mut x46, x44, x38, x35);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x47, &mut x48, x46, x36, x33);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x49, &mut x50, x48, x34, x31);
  let mut x51: u32 = 0;
  let mut x52: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x51, &mut x52, x50, x32, x29);
  let mut x53: u32 = 0;
  let mut x54: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x53, &mut x54, x52, x30, x27);
  let mut x55: u32 = 0;
  let mut x56: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x55, &mut x56, x54, x28, x25);
  let mut x57: u32 = 0;
  let mut x58: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x57, &mut x58, x56, x26, x23);
  let mut x59: u32 = 0;
  let mut x60: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x59, &mut x60, 0x0, x12, x41);
  let mut x61: u32 = 0;
  let mut x62: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x61, &mut x62, x60, x19, x42);
  let mut x63: u32 = 0;
  let mut x64: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x63, &mut x64, 0x0, x17, x39);
  let mut x65: u32 = 0;
  let mut x66: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x65, &mut x66, x64, ((x18 as fiat_p384_u1) as u32), x43);
  let mut x67: u32 = 0;
  let mut x68: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x67, &mut x68, x66, x15, x45);
  let mut x69: u32 = 0;
  let mut x70: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x69, &mut x70, x68, x16, x47);
  let mut x71: u32 = 0;
  let mut x72: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x71, &mut x72, x70, x13, x49);
  let mut x73: u32 = 0;
  let mut x74: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x73, &mut x74, x72, x21, x51);
  let mut x75: u32 = 0;
  let mut x76: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x75, &mut x76, x74, (x22 as u32), x53);
  let mut x77: u32 = 0;
  let mut x78: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x77, &mut x78, x76, (0x0 as u32), x55);
  let mut x79: u32 = 0;
  let mut x80: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x79, &mut x80, x78, (0x0 as u32), x57);
  let mut x81: u32 = 0;
  let mut x82: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x81, &mut x82, x80, (0x0 as u32), ((x58 as u32) + x24));
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_p384_mulx_u32(&mut x83, &mut x84, x1, 0x2);
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_p384_mulx_u32(&mut x85, &mut x86, x1, 0xfffffffe);
  let mut x87: u32 = 0;
  let mut x88: u32 = 0;
  fiat_p384_mulx_u32(&mut x87, &mut x88, x1, 0x2);
  let mut x89: u32 = 0;
  let mut x90: u32 = 0;
  fiat_p384_mulx_u32(&mut x89, &mut x90, x1, 0xfffffffe);
  let mut x91: u32 = 0;
  let mut x92: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x91, &mut x92, 0x0, ((x84 as fiat_p384_u1) as u32), x1);
  let mut x93: u32 = 0;
  let mut x94: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x93, &mut x94, 0x0, x61, x1);
  let mut x95: u32 = 0;
  let mut x96: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x95, &mut x96, x94, ((x62 as u32) + x20), x89);
  let mut x97: u32 = 0;
  let mut x98: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x97, &mut x98, x96, x63, x90);
  let mut x99: u32 = 0;
  let mut x100: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x99, &mut x100, x98, x65, x87);
  let mut x101: u32 = 0;
  let mut x102: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x101, &mut x102, x100, x67, ((x88 as fiat_p384_u1) as u32));
  let mut x103: u32 = 0;
  let mut x104: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x103, &mut x104, x102, x69, x85);
  let mut x105: u32 = 0;
  let mut x106: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x105, &mut x106, x104, x71, x86);
  let mut x107: u32 = 0;
  let mut x108: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x107, &mut x108, x106, x73, x83);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x109, &mut x110, x108, x75, x91);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x111, &mut x112, x110, x77, (x92 as u32));
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x113, &mut x114, x112, x79, (0x0 as u32));
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x115, &mut x116, x114, x81, (0x0 as u32));
  let mut x117: u32 = 0;
  let mut x118: u32 = 0;
  fiat_p384_mulx_u32(&mut x117, &mut x118, x93, 0xffffffff);
  let mut x119: u32 = 0;
  let mut x120: u32 = 0;
  fiat_p384_mulx_u32(&mut x119, &mut x120, x93, 0xffffffff);
  let mut x121: u32 = 0;
  let mut x122: u32 = 0;
  fiat_p384_mulx_u32(&mut x121, &mut x122, x93, 0xffffffff);
  let mut x123: u32 = 0;
  let mut x124: u32 = 0;
  fiat_p384_mulx_u32(&mut x123, &mut x124, x93, 0xffffffff);
  let mut x125: u32 = 0;
  let mut x126: u32 = 0;
  fiat_p384_mulx_u32(&mut x125, &mut x126, x93, 0xffffffff);
  let mut x127: u32 = 0;
  let mut x128: u32 = 0;
  fiat_p384_mulx_u32(&mut x127, &mut x128, x93, 0xffffffff);
  let mut x129: u32 = 0;
  let mut x130: u32 = 0;
  fiat_p384_mulx_u32(&mut x129, &mut x130, x93, 0xffffffff);
  let mut x131: u32 = 0;
  let mut x132: u32 = 0;
  fiat_p384_mulx_u32(&mut x131, &mut x132, x93, 0xfffffffe);
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_p384_mulx_u32(&mut x133, &mut x134, x93, 0xffffffff);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p384_mulx_u32(&mut x135, &mut x136, x93, 0xffffffff);
  let mut x137: u32 = 0;
  let mut x138: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x137, &mut x138, 0x0, x134, x131);
  let mut x139: u32 = 0;
  let mut x140: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x139, &mut x140, x138, x132, x129);
  let mut x141: u32 = 0;
  let mut x142: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x141, &mut x142, x140, x130, x127);
  let mut x143: u32 = 0;
  let mut x144: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x143, &mut x144, x142, x128, x125);
  let mut x145: u32 = 0;
  let mut x146: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x145, &mut x146, x144, x126, x123);
  let mut x147: u32 = 0;
  let mut x148: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x147, &mut x148, x146, x124, x121);
  let mut x149: u32 = 0;
  let mut x150: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x149, &mut x150, x148, x122, x119);
  let mut x151: u32 = 0;
  let mut x152: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x151, &mut x152, x150, x120, x117);
  let mut x153: u32 = 0;
  let mut x154: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x153, &mut x154, 0x0, x93, x135);
  let mut x155: u32 = 0;
  let mut x156: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x155, &mut x156, x154, x95, x136);
  let mut x157: u32 = 0;
  let mut x158: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x157, &mut x158, x156, x97, (0x0 as u32));
  let mut x159: u32 = 0;
  let mut x160: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x159, &mut x160, x158, x99, x133);
  let mut x161: u32 = 0;
  let mut x162: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x161, &mut x162, x160, x101, x137);
  let mut x163: u32 = 0;
  let mut x164: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x163, &mut x164, x162, x103, x139);
  let mut x165: u32 = 0;
  let mut x166: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x165, &mut x166, x164, x105, x141);
  let mut x167: u32 = 0;
  let mut x168: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x167, &mut x168, x166, x107, x143);
  let mut x169: u32 = 0;
  let mut x170: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x169, &mut x170, x168, x109, x145);
  let mut x171: u32 = 0;
  let mut x172: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x171, &mut x172, x170, x111, x147);
  let mut x173: u32 = 0;
  let mut x174: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x173, &mut x174, x172, x113, x149);
  let mut x175: u32 = 0;
  let mut x176: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x175, &mut x176, x174, x115, x151);
  let mut x177: u32 = 0;
  let mut x178: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x177, &mut x178, x176, ((x116 as u32) + (x82 as u32)), ((x152 as u32) + x118));
  let mut x179: u32 = 0;
  let mut x180: u32 = 0;
  fiat_p384_mulx_u32(&mut x179, &mut x180, x2, 0x2);
  let mut x181: u32 = 0;
  let mut x182: u32 = 0;
  fiat_p384_mulx_u32(&mut x181, &mut x182, x2, 0xfffffffe);
  let mut x183: u32 = 0;
  let mut x184: u32 = 0;
  fiat_p384_mulx_u32(&mut x183, &mut x184, x2, 0x2);
  let mut x185: u32 = 0;
  let mut x186: u32 = 0;
  fiat_p384_mulx_u32(&mut x185, &mut x186, x2, 0xfffffffe);
  let mut x187: u32 = 0;
  let mut x188: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x187, &mut x188, 0x0, ((x180 as fiat_p384_u1) as u32), x2);
  let mut x189: u32 = 0;
  let mut x190: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x189, &mut x190, 0x0, x155, x2);
  let mut x191: u32 = 0;
  let mut x192: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x191, &mut x192, x190, x157, x185);
  let mut x193: u32 = 0;
  let mut x194: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x193, &mut x194, x192, x159, x186);
  let mut x195: u32 = 0;
  let mut x196: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x195, &mut x196, x194, x161, x183);
  let mut x197: u32 = 0;
  let mut x198: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x197, &mut x198, x196, x163, ((x184 as fiat_p384_u1) as u32));
  let mut x199: u32 = 0;
  let mut x200: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x199, &mut x200, x198, x165, x181);
  let mut x201: u32 = 0;
  let mut x202: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x201, &mut x202, x200, x167, x182);
  let mut x203: u32 = 0;
  let mut x204: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x203, &mut x204, x202, x169, x179);
  let mut x205: u32 = 0;
  let mut x206: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x205, &mut x206, x204, x171, x187);
  let mut x207: u32 = 0;
  let mut x208: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x207, &mut x208, x206, x173, (x188 as u32));
  let mut x209: u32 = 0;
  let mut x210: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x209, &mut x210, x208, x175, (0x0 as u32));
  let mut x211: u32 = 0;
  let mut x212: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x211, &mut x212, x210, x177, (0x0 as u32));
  let mut x213: u32 = 0;
  let mut x214: u32 = 0;
  fiat_p384_mulx_u32(&mut x213, &mut x214, x189, 0xffffffff);
  let mut x215: u32 = 0;
  let mut x216: u32 = 0;
  fiat_p384_mulx_u32(&mut x215, &mut x216, x189, 0xffffffff);
  let mut x217: u32 = 0;
  let mut x218: u32 = 0;
  fiat_p384_mulx_u32(&mut x217, &mut x218, x189, 0xffffffff);
  let mut x219: u32 = 0;
  let mut x220: u32 = 0;
  fiat_p384_mulx_u32(&mut x219, &mut x220, x189, 0xffffffff);
  let mut x221: u32 = 0;
  let mut x222: u32 = 0;
  fiat_p384_mulx_u32(&mut x221, &mut x222, x189, 0xffffffff);
  let mut x223: u32 = 0;
  let mut x224: u32 = 0;
  fiat_p384_mulx_u32(&mut x223, &mut x224, x189, 0xffffffff);
  let mut x225: u32 = 0;
  let mut x226: u32 = 0;
  fiat_p384_mulx_u32(&mut x225, &mut x226, x189, 0xffffffff);
  let mut x227: u32 = 0;
  let mut x228: u32 = 0;
  fiat_p384_mulx_u32(&mut x227, &mut x228, x189, 0xfffffffe);
  let mut x229: u32 = 0;
  let mut x230: u32 = 0;
  fiat_p384_mulx_u32(&mut x229, &mut x230, x189, 0xffffffff);
  let mut x231: u32 = 0;
  let mut x232: u32 = 0;
  fiat_p384_mulx_u32(&mut x231, &mut x232, x189, 0xffffffff);
  let mut x233: u32 = 0;
  let mut x234: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x233, &mut x234, 0x0, x230, x227);
  let mut x235: u32 = 0;
  let mut x236: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x235, &mut x236, x234, x228, x225);
  let mut x237: u32 = 0;
  let mut x238: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x237, &mut x238, x236, x226, x223);
  let mut x239: u32 = 0;
  let mut x240: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x239, &mut x240, x238, x224, x221);
  let mut x241: u32 = 0;
  let mut x242: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x241, &mut x242, x240, x222, x219);
  let mut x243: u32 = 0;
  let mut x244: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x243, &mut x244, x242, x220, x217);
  let mut x245: u32 = 0;
  let mut x246: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x245, &mut x246, x244, x218, x215);
  let mut x247: u32 = 0;
  let mut x248: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x247, &mut x248, x246, x216, x213);
  let mut x249: u32 = 0;
  let mut x250: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x249, &mut x250, 0x0, x189, x231);
  let mut x251: u32 = 0;
  let mut x252: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x251, &mut x252, x250, x191, x232);
  let mut x253: u32 = 0;
  let mut x254: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x253, &mut x254, x252, x193, (0x0 as u32));
  let mut x255: u32 = 0;
  let mut x256: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x255, &mut x256, x254, x195, x229);
  let mut x257: u32 = 0;
  let mut x258: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x257, &mut x258, x256, x197, x233);
  let mut x259: u32 = 0;
  let mut x260: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x259, &mut x260, x258, x199, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x261, &mut x262, x260, x201, x237);
  let mut x263: u32 = 0;
  let mut x264: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x263, &mut x264, x262, x203, x239);
  let mut x265: u32 = 0;
  let mut x266: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x265, &mut x266, x264, x205, x241);
  let mut x267: u32 = 0;
  let mut x268: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x267, &mut x268, x266, x207, x243);
  let mut x269: u32 = 0;
  let mut x270: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x269, &mut x270, x268, x209, x245);
  let mut x271: u32 = 0;
  let mut x272: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x271, &mut x272, x270, x211, x247);
  let mut x273: u32 = 0;
  let mut x274: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x273, &mut x274, x272, ((x212 as u32) + (x178 as u32)), ((x248 as u32) + x214));
  let mut x275: u32 = 0;
  let mut x276: u32 = 0;
  fiat_p384_mulx_u32(&mut x275, &mut x276, x3, 0x2);
  let mut x277: u32 = 0;
  let mut x278: u32 = 0;
  fiat_p384_mulx_u32(&mut x277, &mut x278, x3, 0xfffffffe);
  let mut x279: u32 = 0;
  let mut x280: u32 = 0;
  fiat_p384_mulx_u32(&mut x279, &mut x280, x3, 0x2);
  let mut x281: u32 = 0;
  let mut x282: u32 = 0;
  fiat_p384_mulx_u32(&mut x281, &mut x282, x3, 0xfffffffe);
  let mut x283: u32 = 0;
  let mut x284: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x283, &mut x284, 0x0, ((x276 as fiat_p384_u1) as u32), x3);
  let mut x285: u32 = 0;
  let mut x286: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x285, &mut x286, 0x0, x251, x3);
  let mut x287: u32 = 0;
  let mut x288: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x287, &mut x288, x286, x253, x281);
  let mut x289: u32 = 0;
  let mut x290: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x289, &mut x290, x288, x255, x282);
  let mut x291: u32 = 0;
  let mut x292: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x291, &mut x292, x290, x257, x279);
  let mut x293: u32 = 0;
  let mut x294: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x293, &mut x294, x292, x259, ((x280 as fiat_p384_u1) as u32));
  let mut x295: u32 = 0;
  let mut x296: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x295, &mut x296, x294, x261, x277);
  let mut x297: u32 = 0;
  let mut x298: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x297, &mut x298, x296, x263, x278);
  let mut x299: u32 = 0;
  let mut x300: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x299, &mut x300, x298, x265, x275);
  let mut x301: u32 = 0;
  let mut x302: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x301, &mut x302, x300, x267, x283);
  let mut x303: u32 = 0;
  let mut x304: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x303, &mut x304, x302, x269, (x284 as u32));
  let mut x305: u32 = 0;
  let mut x306: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x305, &mut x306, x304, x271, (0x0 as u32));
  let mut x307: u32 = 0;
  let mut x308: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x307, &mut x308, x306, x273, (0x0 as u32));
  let mut x309: u32 = 0;
  let mut x310: u32 = 0;
  fiat_p384_mulx_u32(&mut x309, &mut x310, x285, 0xffffffff);
  let mut x311: u32 = 0;
  let mut x312: u32 = 0;
  fiat_p384_mulx_u32(&mut x311, &mut x312, x285, 0xffffffff);
  let mut x313: u32 = 0;
  let mut x314: u32 = 0;
  fiat_p384_mulx_u32(&mut x313, &mut x314, x285, 0xffffffff);
  let mut x315: u32 = 0;
  let mut x316: u32 = 0;
  fiat_p384_mulx_u32(&mut x315, &mut x316, x285, 0xffffffff);
  let mut x317: u32 = 0;
  let mut x318: u32 = 0;
  fiat_p384_mulx_u32(&mut x317, &mut x318, x285, 0xffffffff);
  let mut x319: u32 = 0;
  let mut x320: u32 = 0;
  fiat_p384_mulx_u32(&mut x319, &mut x320, x285, 0xffffffff);
  let mut x321: u32 = 0;
  let mut x322: u32 = 0;
  fiat_p384_mulx_u32(&mut x321, &mut x322, x285, 0xffffffff);
  let mut x323: u32 = 0;
  let mut x324: u32 = 0;
  fiat_p384_mulx_u32(&mut x323, &mut x324, x285, 0xfffffffe);
  let mut x325: u32 = 0;
  let mut x326: u32 = 0;
  fiat_p384_mulx_u32(&mut x325, &mut x326, x285, 0xffffffff);
  let mut x327: u32 = 0;
  let mut x328: u32 = 0;
  fiat_p384_mulx_u32(&mut x327, &mut x328, x285, 0xffffffff);
  let mut x329: u32 = 0;
  let mut x330: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x329, &mut x330, 0x0, x326, x323);
  let mut x331: u32 = 0;
  let mut x332: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x331, &mut x332, x330, x324, x321);
  let mut x333: u32 = 0;
  let mut x334: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x333, &mut x334, x332, x322, x319);
  let mut x335: u32 = 0;
  let mut x336: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x335, &mut x336, x334, x320, x317);
  let mut x337: u32 = 0;
  let mut x338: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x337, &mut x338, x336, x318, x315);
  let mut x339: u32 = 0;
  let mut x340: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x339, &mut x340, x338, x316, x313);
  let mut x341: u32 = 0;
  let mut x342: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x341, &mut x342, x340, x314, x311);
  let mut x343: u32 = 0;
  let mut x344: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x343, &mut x344, x342, x312, x309);
  let mut x345: u32 = 0;
  let mut x346: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x345, &mut x346, 0x0, x285, x327);
  let mut x347: u32 = 0;
  let mut x348: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x347, &mut x348, x346, x287, x328);
  let mut x349: u32 = 0;
  let mut x350: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x349, &mut x350, x348, x289, (0x0 as u32));
  let mut x351: u32 = 0;
  let mut x352: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x351, &mut x352, x350, x291, x325);
  let mut x353: u32 = 0;
  let mut x354: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x353, &mut x354, x352, x293, x329);
  let mut x355: u32 = 0;
  let mut x356: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x355, &mut x356, x354, x295, x331);
  let mut x357: u32 = 0;
  let mut x358: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x357, &mut x358, x356, x297, x333);
  let mut x359: u32 = 0;
  let mut x360: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x359, &mut x360, x358, x299, x335);
  let mut x361: u32 = 0;
  let mut x362: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x361, &mut x362, x360, x301, x337);
  let mut x363: u32 = 0;
  let mut x364: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x363, &mut x364, x362, x303, x339);
  let mut x365: u32 = 0;
  let mut x366: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x365, &mut x366, x364, x305, x341);
  let mut x367: u32 = 0;
  let mut x368: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x367, &mut x368, x366, x307, x343);
  let mut x369: u32 = 0;
  let mut x370: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x369, &mut x370, x368, ((x308 as u32) + (x274 as u32)), ((x344 as u32) + x310));
  let mut x371: u32 = 0;
  let mut x372: u32 = 0;
  fiat_p384_mulx_u32(&mut x371, &mut x372, x4, 0x2);
  let mut x373: u32 = 0;
  let mut x374: u32 = 0;
  fiat_p384_mulx_u32(&mut x373, &mut x374, x4, 0xfffffffe);
  let mut x375: u32 = 0;
  let mut x376: u32 = 0;
  fiat_p384_mulx_u32(&mut x375, &mut x376, x4, 0x2);
  let mut x377: u32 = 0;
  let mut x378: u32 = 0;
  fiat_p384_mulx_u32(&mut x377, &mut x378, x4, 0xfffffffe);
  let mut x379: u32 = 0;
  let mut x380: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x379, &mut x380, 0x0, ((x372 as fiat_p384_u1) as u32), x4);
  let mut x381: u32 = 0;
  let mut x382: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x381, &mut x382, 0x0, x347, x4);
  let mut x383: u32 = 0;
  let mut x384: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x383, &mut x384, x382, x349, x377);
  let mut x385: u32 = 0;
  let mut x386: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x385, &mut x386, x384, x351, x378);
  let mut x387: u32 = 0;
  let mut x388: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x387, &mut x388, x386, x353, x375);
  let mut x389: u32 = 0;
  let mut x390: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x389, &mut x390, x388, x355, ((x376 as fiat_p384_u1) as u32));
  let mut x391: u32 = 0;
  let mut x392: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x391, &mut x392, x390, x357, x373);
  let mut x393: u32 = 0;
  let mut x394: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x393, &mut x394, x392, x359, x374);
  let mut x395: u32 = 0;
  let mut x396: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x395, &mut x396, x394, x361, x371);
  let mut x397: u32 = 0;
  let mut x398: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x397, &mut x398, x396, x363, x379);
  let mut x399: u32 = 0;
  let mut x400: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x399, &mut x400, x398, x365, (x380 as u32));
  let mut x401: u32 = 0;
  let mut x402: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x401, &mut x402, x400, x367, (0x0 as u32));
  let mut x403: u32 = 0;
  let mut x404: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x403, &mut x404, x402, x369, (0x0 as u32));
  let mut x405: u32 = 0;
  let mut x406: u32 = 0;
  fiat_p384_mulx_u32(&mut x405, &mut x406, x381, 0xffffffff);
  let mut x407: u32 = 0;
  let mut x408: u32 = 0;
  fiat_p384_mulx_u32(&mut x407, &mut x408, x381, 0xffffffff);
  let mut x409: u32 = 0;
  let mut x410: u32 = 0;
  fiat_p384_mulx_u32(&mut x409, &mut x410, x381, 0xffffffff);
  let mut x411: u32 = 0;
  let mut x412: u32 = 0;
  fiat_p384_mulx_u32(&mut x411, &mut x412, x381, 0xffffffff);
  let mut x413: u32 = 0;
  let mut x414: u32 = 0;
  fiat_p384_mulx_u32(&mut x413, &mut x414, x381, 0xffffffff);
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_p384_mulx_u32(&mut x415, &mut x416, x381, 0xffffffff);
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_p384_mulx_u32(&mut x417, &mut x418, x381, 0xffffffff);
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_p384_mulx_u32(&mut x419, &mut x420, x381, 0xfffffffe);
  let mut x421: u32 = 0;
  let mut x422: u32 = 0;
  fiat_p384_mulx_u32(&mut x421, &mut x422, x381, 0xffffffff);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_p384_mulx_u32(&mut x423, &mut x424, x381, 0xffffffff);
  let mut x425: u32 = 0;
  let mut x426: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x425, &mut x426, 0x0, x422, x419);
  let mut x427: u32 = 0;
  let mut x428: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x427, &mut x428, x426, x420, x417);
  let mut x429: u32 = 0;
  let mut x430: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x429, &mut x430, x428, x418, x415);
  let mut x431: u32 = 0;
  let mut x432: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x431, &mut x432, x430, x416, x413);
  let mut x433: u32 = 0;
  let mut x434: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x433, &mut x434, x432, x414, x411);
  let mut x435: u32 = 0;
  let mut x436: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x435, &mut x436, x434, x412, x409);
  let mut x437: u32 = 0;
  let mut x438: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x437, &mut x438, x436, x410, x407);
  let mut x439: u32 = 0;
  let mut x440: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x439, &mut x440, x438, x408, x405);
  let mut x441: u32 = 0;
  let mut x442: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x441, &mut x442, 0x0, x381, x423);
  let mut x443: u32 = 0;
  let mut x444: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x443, &mut x444, x442, x383, x424);
  let mut x445: u32 = 0;
  let mut x446: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x445, &mut x446, x444, x385, (0x0 as u32));
  let mut x447: u32 = 0;
  let mut x448: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x447, &mut x448, x446, x387, x421);
  let mut x449: u32 = 0;
  let mut x450: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x449, &mut x450, x448, x389, x425);
  let mut x451: u32 = 0;
  let mut x452: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x451, &mut x452, x450, x391, x427);
  let mut x453: u32 = 0;
  let mut x454: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x453, &mut x454, x452, x393, x429);
  let mut x455: u32 = 0;
  let mut x456: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x455, &mut x456, x454, x395, x431);
  let mut x457: u32 = 0;
  let mut x458: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x457, &mut x458, x456, x397, x433);
  let mut x459: u32 = 0;
  let mut x460: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x459, &mut x460, x458, x399, x435);
  let mut x461: u32 = 0;
  let mut x462: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x461, &mut x462, x460, x401, x437);
  let mut x463: u32 = 0;
  let mut x464: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x463, &mut x464, x462, x403, x439);
  let mut x465: u32 = 0;
  let mut x466: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x465, &mut x466, x464, ((x404 as u32) + (x370 as u32)), ((x440 as u32) + x406));
  let mut x467: u32 = 0;
  let mut x468: u32 = 0;
  fiat_p384_mulx_u32(&mut x467, &mut x468, x5, 0x2);
  let mut x469: u32 = 0;
  let mut x470: u32 = 0;
  fiat_p384_mulx_u32(&mut x469, &mut x470, x5, 0xfffffffe);
  let mut x471: u32 = 0;
  let mut x472: u32 = 0;
  fiat_p384_mulx_u32(&mut x471, &mut x472, x5, 0x2);
  let mut x473: u32 = 0;
  let mut x474: u32 = 0;
  fiat_p384_mulx_u32(&mut x473, &mut x474, x5, 0xfffffffe);
  let mut x475: u32 = 0;
  let mut x476: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x475, &mut x476, 0x0, ((x468 as fiat_p384_u1) as u32), x5);
  let mut x477: u32 = 0;
  let mut x478: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x477, &mut x478, 0x0, x443, x5);
  let mut x479: u32 = 0;
  let mut x480: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x479, &mut x480, x478, x445, x473);
  let mut x481: u32 = 0;
  let mut x482: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x481, &mut x482, x480, x447, x474);
  let mut x483: u32 = 0;
  let mut x484: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x483, &mut x484, x482, x449, x471);
  let mut x485: u32 = 0;
  let mut x486: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x485, &mut x486, x484, x451, ((x472 as fiat_p384_u1) as u32));
  let mut x487: u32 = 0;
  let mut x488: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x487, &mut x488, x486, x453, x469);
  let mut x489: u32 = 0;
  let mut x490: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x489, &mut x490, x488, x455, x470);
  let mut x491: u32 = 0;
  let mut x492: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x491, &mut x492, x490, x457, x467);
  let mut x493: u32 = 0;
  let mut x494: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x493, &mut x494, x492, x459, x475);
  let mut x495: u32 = 0;
  let mut x496: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x495, &mut x496, x494, x461, (x476 as u32));
  let mut x497: u32 = 0;
  let mut x498: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x497, &mut x498, x496, x463, (0x0 as u32));
  let mut x499: u32 = 0;
  let mut x500: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x499, &mut x500, x498, x465, (0x0 as u32));
  let mut x501: u32 = 0;
  let mut x502: u32 = 0;
  fiat_p384_mulx_u32(&mut x501, &mut x502, x477, 0xffffffff);
  let mut x503: u32 = 0;
  let mut x504: u32 = 0;
  fiat_p384_mulx_u32(&mut x503, &mut x504, x477, 0xffffffff);
  let mut x505: u32 = 0;
  let mut x506: u32 = 0;
  fiat_p384_mulx_u32(&mut x505, &mut x506, x477, 0xffffffff);
  let mut x507: u32 = 0;
  let mut x508: u32 = 0;
  fiat_p384_mulx_u32(&mut x507, &mut x508, x477, 0xffffffff);
  let mut x509: u32 = 0;
  let mut x510: u32 = 0;
  fiat_p384_mulx_u32(&mut x509, &mut x510, x477, 0xffffffff);
  let mut x511: u32 = 0;
  let mut x512: u32 = 0;
  fiat_p384_mulx_u32(&mut x511, &mut x512, x477, 0xffffffff);
  let mut x513: u32 = 0;
  let mut x514: u32 = 0;
  fiat_p384_mulx_u32(&mut x513, &mut x514, x477, 0xffffffff);
  let mut x515: u32 = 0;
  let mut x516: u32 = 0;
  fiat_p384_mulx_u32(&mut x515, &mut x516, x477, 0xfffffffe);
  let mut x517: u32 = 0;
  let mut x518: u32 = 0;
  fiat_p384_mulx_u32(&mut x517, &mut x518, x477, 0xffffffff);
  let mut x519: u32 = 0;
  let mut x520: u32 = 0;
  fiat_p384_mulx_u32(&mut x519, &mut x520, x477, 0xffffffff);
  let mut x521: u32 = 0;
  let mut x522: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x521, &mut x522, 0x0, x518, x515);
  let mut x523: u32 = 0;
  let mut x524: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x523, &mut x524, x522, x516, x513);
  let mut x525: u32 = 0;
  let mut x526: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x525, &mut x526, x524, x514, x511);
  let mut x527: u32 = 0;
  let mut x528: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x527, &mut x528, x526, x512, x509);
  let mut x529: u32 = 0;
  let mut x530: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x529, &mut x530, x528, x510, x507);
  let mut x531: u32 = 0;
  let mut x532: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x531, &mut x532, x530, x508, x505);
  let mut x533: u32 = 0;
  let mut x534: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x533, &mut x534, x532, x506, x503);
  let mut x535: u32 = 0;
  let mut x536: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x535, &mut x536, x534, x504, x501);
  let mut x537: u32 = 0;
  let mut x538: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x537, &mut x538, 0x0, x477, x519);
  let mut x539: u32 = 0;
  let mut x540: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x539, &mut x540, x538, x479, x520);
  let mut x541: u32 = 0;
  let mut x542: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x541, &mut x542, x540, x481, (0x0 as u32));
  let mut x543: u32 = 0;
  let mut x544: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x543, &mut x544, x542, x483, x517);
  let mut x545: u32 = 0;
  let mut x546: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x545, &mut x546, x544, x485, x521);
  let mut x547: u32 = 0;
  let mut x548: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x547, &mut x548, x546, x487, x523);
  let mut x549: u32 = 0;
  let mut x550: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x549, &mut x550, x548, x489, x525);
  let mut x551: u32 = 0;
  let mut x552: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x551, &mut x552, x550, x491, x527);
  let mut x553: u32 = 0;
  let mut x554: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x553, &mut x554, x552, x493, x529);
  let mut x555: u32 = 0;
  let mut x556: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x555, &mut x556, x554, x495, x531);
  let mut x557: u32 = 0;
  let mut x558: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x557, &mut x558, x556, x497, x533);
  let mut x559: u32 = 0;
  let mut x560: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x559, &mut x560, x558, x499, x535);
  let mut x561: u32 = 0;
  let mut x562: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x561, &mut x562, x560, ((x500 as u32) + (x466 as u32)), ((x536 as u32) + x502));
  let mut x563: u32 = 0;
  let mut x564: u32 = 0;
  fiat_p384_mulx_u32(&mut x563, &mut x564, x6, 0x2);
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_p384_mulx_u32(&mut x565, &mut x566, x6, 0xfffffffe);
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_p384_mulx_u32(&mut x567, &mut x568, x6, 0x2);
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_p384_mulx_u32(&mut x569, &mut x570, x6, 0xfffffffe);
  let mut x571: u32 = 0;
  let mut x572: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x571, &mut x572, 0x0, ((x564 as fiat_p384_u1) as u32), x6);
  let mut x573: u32 = 0;
  let mut x574: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x573, &mut x574, 0x0, x539, x6);
  let mut x575: u32 = 0;
  let mut x576: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x575, &mut x576, x574, x541, x569);
  let mut x577: u32 = 0;
  let mut x578: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x577, &mut x578, x576, x543, x570);
  let mut x579: u32 = 0;
  let mut x580: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x579, &mut x580, x578, x545, x567);
  let mut x581: u32 = 0;
  let mut x582: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x581, &mut x582, x580, x547, ((x568 as fiat_p384_u1) as u32));
  let mut x583: u32 = 0;
  let mut x584: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x583, &mut x584, x582, x549, x565);
  let mut x585: u32 = 0;
  let mut x586: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x585, &mut x586, x584, x551, x566);
  let mut x587: u32 = 0;
  let mut x588: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x587, &mut x588, x586, x553, x563);
  let mut x589: u32 = 0;
  let mut x590: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x589, &mut x590, x588, x555, x571);
  let mut x591: u32 = 0;
  let mut x592: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x591, &mut x592, x590, x557, (x572 as u32));
  let mut x593: u32 = 0;
  let mut x594: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x593, &mut x594, x592, x559, (0x0 as u32));
  let mut x595: u32 = 0;
  let mut x596: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x595, &mut x596, x594, x561, (0x0 as u32));
  let mut x597: u32 = 0;
  let mut x598: u32 = 0;
  fiat_p384_mulx_u32(&mut x597, &mut x598, x573, 0xffffffff);
  let mut x599: u32 = 0;
  let mut x600: u32 = 0;
  fiat_p384_mulx_u32(&mut x599, &mut x600, x573, 0xffffffff);
  let mut x601: u32 = 0;
  let mut x602: u32 = 0;
  fiat_p384_mulx_u32(&mut x601, &mut x602, x573, 0xffffffff);
  let mut x603: u32 = 0;
  let mut x604: u32 = 0;
  fiat_p384_mulx_u32(&mut x603, &mut x604, x573, 0xffffffff);
  let mut x605: u32 = 0;
  let mut x606: u32 = 0;
  fiat_p384_mulx_u32(&mut x605, &mut x606, x573, 0xffffffff);
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_p384_mulx_u32(&mut x607, &mut x608, x573, 0xffffffff);
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_p384_mulx_u32(&mut x609, &mut x610, x573, 0xffffffff);
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_p384_mulx_u32(&mut x611, &mut x612, x573, 0xfffffffe);
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_p384_mulx_u32(&mut x613, &mut x614, x573, 0xffffffff);
  let mut x615: u32 = 0;
  let mut x616: u32 = 0;
  fiat_p384_mulx_u32(&mut x615, &mut x616, x573, 0xffffffff);
  let mut x617: u32 = 0;
  let mut x618: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x617, &mut x618, 0x0, x614, x611);
  let mut x619: u32 = 0;
  let mut x620: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x619, &mut x620, x618, x612, x609);
  let mut x621: u32 = 0;
  let mut x622: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x621, &mut x622, x620, x610, x607);
  let mut x623: u32 = 0;
  let mut x624: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x623, &mut x624, x622, x608, x605);
  let mut x625: u32 = 0;
  let mut x626: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x625, &mut x626, x624, x606, x603);
  let mut x627: u32 = 0;
  let mut x628: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x627, &mut x628, x626, x604, x601);
  let mut x629: u32 = 0;
  let mut x630: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x629, &mut x630, x628, x602, x599);
  let mut x631: u32 = 0;
  let mut x632: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x631, &mut x632, x630, x600, x597);
  let mut x633: u32 = 0;
  let mut x634: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x633, &mut x634, 0x0, x573, x615);
  let mut x635: u32 = 0;
  let mut x636: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x635, &mut x636, x634, x575, x616);
  let mut x637: u32 = 0;
  let mut x638: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x637, &mut x638, x636, x577, (0x0 as u32));
  let mut x639: u32 = 0;
  let mut x640: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x639, &mut x640, x638, x579, x613);
  let mut x641: u32 = 0;
  let mut x642: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x641, &mut x642, x640, x581, x617);
  let mut x643: u32 = 0;
  let mut x644: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x643, &mut x644, x642, x583, x619);
  let mut x645: u32 = 0;
  let mut x646: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x645, &mut x646, x644, x585, x621);
  let mut x647: u32 = 0;
  let mut x648: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x647, &mut x648, x646, x587, x623);
  let mut x649: u32 = 0;
  let mut x650: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x649, &mut x650, x648, x589, x625);
  let mut x651: u32 = 0;
  let mut x652: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x651, &mut x652, x650, x591, x627);
  let mut x653: u32 = 0;
  let mut x654: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x653, &mut x654, x652, x593, x629);
  let mut x655: u32 = 0;
  let mut x656: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x655, &mut x656, x654, x595, x631);
  let mut x657: u32 = 0;
  let mut x658: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x657, &mut x658, x656, ((x596 as u32) + (x562 as u32)), ((x632 as u32) + x598));
  let mut x659: u32 = 0;
  let mut x660: u32 = 0;
  fiat_p384_mulx_u32(&mut x659, &mut x660, x7, 0x2);
  let mut x661: u32 = 0;
  let mut x662: u32 = 0;
  fiat_p384_mulx_u32(&mut x661, &mut x662, x7, 0xfffffffe);
  let mut x663: u32 = 0;
  let mut x664: u32 = 0;
  fiat_p384_mulx_u32(&mut x663, &mut x664, x7, 0x2);
  let mut x665: u32 = 0;
  let mut x666: u32 = 0;
  fiat_p384_mulx_u32(&mut x665, &mut x666, x7, 0xfffffffe);
  let mut x667: u32 = 0;
  let mut x668: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x667, &mut x668, 0x0, ((x660 as fiat_p384_u1) as u32), x7);
  let mut x669: u32 = 0;
  let mut x670: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x669, &mut x670, 0x0, x635, x7);
  let mut x671: u32 = 0;
  let mut x672: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x671, &mut x672, x670, x637, x665);
  let mut x673: u32 = 0;
  let mut x674: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x673, &mut x674, x672, x639, x666);
  let mut x675: u32 = 0;
  let mut x676: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x675, &mut x676, x674, x641, x663);
  let mut x677: u32 = 0;
  let mut x678: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x677, &mut x678, x676, x643, ((x664 as fiat_p384_u1) as u32));
  let mut x679: u32 = 0;
  let mut x680: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x679, &mut x680, x678, x645, x661);
  let mut x681: u32 = 0;
  let mut x682: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x681, &mut x682, x680, x647, x662);
  let mut x683: u32 = 0;
  let mut x684: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x683, &mut x684, x682, x649, x659);
  let mut x685: u32 = 0;
  let mut x686: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x685, &mut x686, x684, x651, x667);
  let mut x687: u32 = 0;
  let mut x688: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x687, &mut x688, x686, x653, (x668 as u32));
  let mut x689: u32 = 0;
  let mut x690: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x689, &mut x690, x688, x655, (0x0 as u32));
  let mut x691: u32 = 0;
  let mut x692: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x691, &mut x692, x690, x657, (0x0 as u32));
  let mut x693: u32 = 0;
  let mut x694: u32 = 0;
  fiat_p384_mulx_u32(&mut x693, &mut x694, x669, 0xffffffff);
  let mut x695: u32 = 0;
  let mut x696: u32 = 0;
  fiat_p384_mulx_u32(&mut x695, &mut x696, x669, 0xffffffff);
  let mut x697: u32 = 0;
  let mut x698: u32 = 0;
  fiat_p384_mulx_u32(&mut x697, &mut x698, x669, 0xffffffff);
  let mut x699: u32 = 0;
  let mut x700: u32 = 0;
  fiat_p384_mulx_u32(&mut x699, &mut x700, x669, 0xffffffff);
  let mut x701: u32 = 0;
  let mut x702: u32 = 0;
  fiat_p384_mulx_u32(&mut x701, &mut x702, x669, 0xffffffff);
  let mut x703: u32 = 0;
  let mut x704: u32 = 0;
  fiat_p384_mulx_u32(&mut x703, &mut x704, x669, 0xffffffff);
  let mut x705: u32 = 0;
  let mut x706: u32 = 0;
  fiat_p384_mulx_u32(&mut x705, &mut x706, x669, 0xffffffff);
  let mut x707: u32 = 0;
  let mut x708: u32 = 0;
  fiat_p384_mulx_u32(&mut x707, &mut x708, x669, 0xfffffffe);
  let mut x709: u32 = 0;
  let mut x710: u32 = 0;
  fiat_p384_mulx_u32(&mut x709, &mut x710, x669, 0xffffffff);
  let mut x711: u32 = 0;
  let mut x712: u32 = 0;
  fiat_p384_mulx_u32(&mut x711, &mut x712, x669, 0xffffffff);
  let mut x713: u32 = 0;
  let mut x714: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x713, &mut x714, 0x0, x710, x707);
  let mut x715: u32 = 0;
  let mut x716: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x715, &mut x716, x714, x708, x705);
  let mut x717: u32 = 0;
  let mut x718: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x717, &mut x718, x716, x706, x703);
  let mut x719: u32 = 0;
  let mut x720: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x719, &mut x720, x718, x704, x701);
  let mut x721: u32 = 0;
  let mut x722: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x721, &mut x722, x720, x702, x699);
  let mut x723: u32 = 0;
  let mut x724: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x723, &mut x724, x722, x700, x697);
  let mut x725: u32 = 0;
  let mut x726: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x725, &mut x726, x724, x698, x695);
  let mut x727: u32 = 0;
  let mut x728: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x727, &mut x728, x726, x696, x693);
  let mut x729: u32 = 0;
  let mut x730: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x729, &mut x730, 0x0, x669, x711);
  let mut x731: u32 = 0;
  let mut x732: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x731, &mut x732, x730, x671, x712);
  let mut x733: u32 = 0;
  let mut x734: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x733, &mut x734, x732, x673, (0x0 as u32));
  let mut x735: u32 = 0;
  let mut x736: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x735, &mut x736, x734, x675, x709);
  let mut x737: u32 = 0;
  let mut x738: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x737, &mut x738, x736, x677, x713);
  let mut x739: u32 = 0;
  let mut x740: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x739, &mut x740, x738, x679, x715);
  let mut x741: u32 = 0;
  let mut x742: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x741, &mut x742, x740, x681, x717);
  let mut x743: u32 = 0;
  let mut x744: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x743, &mut x744, x742, x683, x719);
  let mut x745: u32 = 0;
  let mut x746: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x745, &mut x746, x744, x685, x721);
  let mut x747: u32 = 0;
  let mut x748: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x747, &mut x748, x746, x687, x723);
  let mut x749: u32 = 0;
  let mut x750: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x749, &mut x750, x748, x689, x725);
  let mut x751: u32 = 0;
  let mut x752: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x751, &mut x752, x750, x691, x727);
  let mut x753: u32 = 0;
  let mut x754: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x753, &mut x754, x752, ((x692 as u32) + (x658 as u32)), ((x728 as u32) + x694));
  let mut x755: u32 = 0;
  let mut x756: u32 = 0;
  fiat_p384_mulx_u32(&mut x755, &mut x756, x8, 0x2);
  let mut x757: u32 = 0;
  let mut x758: u32 = 0;
  fiat_p384_mulx_u32(&mut x757, &mut x758, x8, 0xfffffffe);
  let mut x759: u32 = 0;
  let mut x760: u32 = 0;
  fiat_p384_mulx_u32(&mut x759, &mut x760, x8, 0x2);
  let mut x761: u32 = 0;
  let mut x762: u32 = 0;
  fiat_p384_mulx_u32(&mut x761, &mut x762, x8, 0xfffffffe);
  let mut x763: u32 = 0;
  let mut x764: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x763, &mut x764, 0x0, ((x756 as fiat_p384_u1) as u32), x8);
  let mut x765: u32 = 0;
  let mut x766: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x765, &mut x766, 0x0, x731, x8);
  let mut x767: u32 = 0;
  let mut x768: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x767, &mut x768, x766, x733, x761);
  let mut x769: u32 = 0;
  let mut x770: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x769, &mut x770, x768, x735, x762);
  let mut x771: u32 = 0;
  let mut x772: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x771, &mut x772, x770, x737, x759);
  let mut x773: u32 = 0;
  let mut x774: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x773, &mut x774, x772, x739, ((x760 as fiat_p384_u1) as u32));
  let mut x775: u32 = 0;
  let mut x776: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x775, &mut x776, x774, x741, x757);
  let mut x777: u32 = 0;
  let mut x778: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x777, &mut x778, x776, x743, x758);
  let mut x779: u32 = 0;
  let mut x780: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x779, &mut x780, x778, x745, x755);
  let mut x781: u32 = 0;
  let mut x782: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x781, &mut x782, x780, x747, x763);
  let mut x783: u32 = 0;
  let mut x784: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x783, &mut x784, x782, x749, (x764 as u32));
  let mut x785: u32 = 0;
  let mut x786: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x785, &mut x786, x784, x751, (0x0 as u32));
  let mut x787: u32 = 0;
  let mut x788: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x787, &mut x788, x786, x753, (0x0 as u32));
  let mut x789: u32 = 0;
  let mut x790: u32 = 0;
  fiat_p384_mulx_u32(&mut x789, &mut x790, x765, 0xffffffff);
  let mut x791: u32 = 0;
  let mut x792: u32 = 0;
  fiat_p384_mulx_u32(&mut x791, &mut x792, x765, 0xffffffff);
  let mut x793: u32 = 0;
  let mut x794: u32 = 0;
  fiat_p384_mulx_u32(&mut x793, &mut x794, x765, 0xffffffff);
  let mut x795: u32 = 0;
  let mut x796: u32 = 0;
  fiat_p384_mulx_u32(&mut x795, &mut x796, x765, 0xffffffff);
  let mut x797: u32 = 0;
  let mut x798: u32 = 0;
  fiat_p384_mulx_u32(&mut x797, &mut x798, x765, 0xffffffff);
  let mut x799: u32 = 0;
  let mut x800: u32 = 0;
  fiat_p384_mulx_u32(&mut x799, &mut x800, x765, 0xffffffff);
  let mut x801: u32 = 0;
  let mut x802: u32 = 0;
  fiat_p384_mulx_u32(&mut x801, &mut x802, x765, 0xffffffff);
  let mut x803: u32 = 0;
  let mut x804: u32 = 0;
  fiat_p384_mulx_u32(&mut x803, &mut x804, x765, 0xfffffffe);
  let mut x805: u32 = 0;
  let mut x806: u32 = 0;
  fiat_p384_mulx_u32(&mut x805, &mut x806, x765, 0xffffffff);
  let mut x807: u32 = 0;
  let mut x808: u32 = 0;
  fiat_p384_mulx_u32(&mut x807, &mut x808, x765, 0xffffffff);
  let mut x809: u32 = 0;
  let mut x810: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x809, &mut x810, 0x0, x806, x803);
  let mut x811: u32 = 0;
  let mut x812: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x811, &mut x812, x810, x804, x801);
  let mut x813: u32 = 0;
  let mut x814: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x813, &mut x814, x812, x802, x799);
  let mut x815: u32 = 0;
  let mut x816: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x815, &mut x816, x814, x800, x797);
  let mut x817: u32 = 0;
  let mut x818: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x817, &mut x818, x816, x798, x795);
  let mut x819: u32 = 0;
  let mut x820: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x819, &mut x820, x818, x796, x793);
  let mut x821: u32 = 0;
  let mut x822: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x821, &mut x822, x820, x794, x791);
  let mut x823: u32 = 0;
  let mut x824: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x823, &mut x824, x822, x792, x789);
  let mut x825: u32 = 0;
  let mut x826: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x825, &mut x826, 0x0, x765, x807);
  let mut x827: u32 = 0;
  let mut x828: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x827, &mut x828, x826, x767, x808);
  let mut x829: u32 = 0;
  let mut x830: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x829, &mut x830, x828, x769, (0x0 as u32));
  let mut x831: u32 = 0;
  let mut x832: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x831, &mut x832, x830, x771, x805);
  let mut x833: u32 = 0;
  let mut x834: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x833, &mut x834, x832, x773, x809);
  let mut x835: u32 = 0;
  let mut x836: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x835, &mut x836, x834, x775, x811);
  let mut x837: u32 = 0;
  let mut x838: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x837, &mut x838, x836, x777, x813);
  let mut x839: u32 = 0;
  let mut x840: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x839, &mut x840, x838, x779, x815);
  let mut x841: u32 = 0;
  let mut x842: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x841, &mut x842, x840, x781, x817);
  let mut x843: u32 = 0;
  let mut x844: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x843, &mut x844, x842, x783, x819);
  let mut x845: u32 = 0;
  let mut x846: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x845, &mut x846, x844, x785, x821);
  let mut x847: u32 = 0;
  let mut x848: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x847, &mut x848, x846, x787, x823);
  let mut x849: u32 = 0;
  let mut x850: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x849, &mut x850, x848, ((x788 as u32) + (x754 as u32)), ((x824 as u32) + x790));
  let mut x851: u32 = 0;
  let mut x852: u32 = 0;
  fiat_p384_mulx_u32(&mut x851, &mut x852, x9, 0x2);
  let mut x853: u32 = 0;
  let mut x854: u32 = 0;
  fiat_p384_mulx_u32(&mut x853, &mut x854, x9, 0xfffffffe);
  let mut x855: u32 = 0;
  let mut x856: u32 = 0;
  fiat_p384_mulx_u32(&mut x855, &mut x856, x9, 0x2);
  let mut x857: u32 = 0;
  let mut x858: u32 = 0;
  fiat_p384_mulx_u32(&mut x857, &mut x858, x9, 0xfffffffe);
  let mut x859: u32 = 0;
  let mut x860: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x859, &mut x860, 0x0, ((x852 as fiat_p384_u1) as u32), x9);
  let mut x861: u32 = 0;
  let mut x862: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x861, &mut x862, 0x0, x827, x9);
  let mut x863: u32 = 0;
  let mut x864: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x863, &mut x864, x862, x829, x857);
  let mut x865: u32 = 0;
  let mut x866: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x865, &mut x866, x864, x831, x858);
  let mut x867: u32 = 0;
  let mut x868: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x867, &mut x868, x866, x833, x855);
  let mut x869: u32 = 0;
  let mut x870: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x869, &mut x870, x868, x835, ((x856 as fiat_p384_u1) as u32));
  let mut x871: u32 = 0;
  let mut x872: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x871, &mut x872, x870, x837, x853);
  let mut x873: u32 = 0;
  let mut x874: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x873, &mut x874, x872, x839, x854);
  let mut x875: u32 = 0;
  let mut x876: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x875, &mut x876, x874, x841, x851);
  let mut x877: u32 = 0;
  let mut x878: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x877, &mut x878, x876, x843, x859);
  let mut x879: u32 = 0;
  let mut x880: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x879, &mut x880, x878, x845, (x860 as u32));
  let mut x881: u32 = 0;
  let mut x882: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x881, &mut x882, x880, x847, (0x0 as u32));
  let mut x883: u32 = 0;
  let mut x884: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x883, &mut x884, x882, x849, (0x0 as u32));
  let mut x885: u32 = 0;
  let mut x886: u32 = 0;
  fiat_p384_mulx_u32(&mut x885, &mut x886, x861, 0xffffffff);
  let mut x887: u32 = 0;
  let mut x888: u32 = 0;
  fiat_p384_mulx_u32(&mut x887, &mut x888, x861, 0xffffffff);
  let mut x889: u32 = 0;
  let mut x890: u32 = 0;
  fiat_p384_mulx_u32(&mut x889, &mut x890, x861, 0xffffffff);
  let mut x891: u32 = 0;
  let mut x892: u32 = 0;
  fiat_p384_mulx_u32(&mut x891, &mut x892, x861, 0xffffffff);
  let mut x893: u32 = 0;
  let mut x894: u32 = 0;
  fiat_p384_mulx_u32(&mut x893, &mut x894, x861, 0xffffffff);
  let mut x895: u32 = 0;
  let mut x896: u32 = 0;
  fiat_p384_mulx_u32(&mut x895, &mut x896, x861, 0xffffffff);
  let mut x897: u32 = 0;
  let mut x898: u32 = 0;
  fiat_p384_mulx_u32(&mut x897, &mut x898, x861, 0xffffffff);
  let mut x899: u32 = 0;
  let mut x900: u32 = 0;
  fiat_p384_mulx_u32(&mut x899, &mut x900, x861, 0xfffffffe);
  let mut x901: u32 = 0;
  let mut x902: u32 = 0;
  fiat_p384_mulx_u32(&mut x901, &mut x902, x861, 0xffffffff);
  let mut x903: u32 = 0;
  let mut x904: u32 = 0;
  fiat_p384_mulx_u32(&mut x903, &mut x904, x861, 0xffffffff);
  let mut x905: u32 = 0;
  let mut x906: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x905, &mut x906, 0x0, x902, x899);
  let mut x907: u32 = 0;
  let mut x908: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x907, &mut x908, x906, x900, x897);
  let mut x909: u32 = 0;
  let mut x910: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x909, &mut x910, x908, x898, x895);
  let mut x911: u32 = 0;
  let mut x912: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x911, &mut x912, x910, x896, x893);
  let mut x913: u32 = 0;
  let mut x914: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x913, &mut x914, x912, x894, x891);
  let mut x915: u32 = 0;
  let mut x916: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x915, &mut x916, x914, x892, x889);
  let mut x917: u32 = 0;
  let mut x918: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x917, &mut x918, x916, x890, x887);
  let mut x919: u32 = 0;
  let mut x920: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x919, &mut x920, x918, x888, x885);
  let mut x921: u32 = 0;
  let mut x922: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x921, &mut x922, 0x0, x861, x903);
  let mut x923: u32 = 0;
  let mut x924: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x923, &mut x924, x922, x863, x904);
  let mut x925: u32 = 0;
  let mut x926: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x925, &mut x926, x924, x865, (0x0 as u32));
  let mut x927: u32 = 0;
  let mut x928: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x927, &mut x928, x926, x867, x901);
  let mut x929: u32 = 0;
  let mut x930: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x929, &mut x930, x928, x869, x905);
  let mut x931: u32 = 0;
  let mut x932: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x931, &mut x932, x930, x871, x907);
  let mut x933: u32 = 0;
  let mut x934: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x933, &mut x934, x932, x873, x909);
  let mut x935: u32 = 0;
  let mut x936: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x935, &mut x936, x934, x875, x911);
  let mut x937: u32 = 0;
  let mut x938: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x937, &mut x938, x936, x877, x913);
  let mut x939: u32 = 0;
  let mut x940: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x939, &mut x940, x938, x879, x915);
  let mut x941: u32 = 0;
  let mut x942: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x941, &mut x942, x940, x881, x917);
  let mut x943: u32 = 0;
  let mut x944: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x943, &mut x944, x942, x883, x919);
  let mut x945: u32 = 0;
  let mut x946: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x945, &mut x946, x944, ((x884 as u32) + (x850 as u32)), ((x920 as u32) + x886));
  let mut x947: u32 = 0;
  let mut x948: u32 = 0;
  fiat_p384_mulx_u32(&mut x947, &mut x948, x10, 0x2);
  let mut x949: u32 = 0;
  let mut x950: u32 = 0;
  fiat_p384_mulx_u32(&mut x949, &mut x950, x10, 0xfffffffe);
  let mut x951: u32 = 0;
  let mut x952: u32 = 0;
  fiat_p384_mulx_u32(&mut x951, &mut x952, x10, 0x2);
  let mut x953: u32 = 0;
  let mut x954: u32 = 0;
  fiat_p384_mulx_u32(&mut x953, &mut x954, x10, 0xfffffffe);
  let mut x955: u32 = 0;
  let mut x956: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x955, &mut x956, 0x0, ((x948 as fiat_p384_u1) as u32), x10);
  let mut x957: u32 = 0;
  let mut x958: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x957, &mut x958, 0x0, x923, x10);
  let mut x959: u32 = 0;
  let mut x960: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x959, &mut x960, x958, x925, x953);
  let mut x961: u32 = 0;
  let mut x962: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x961, &mut x962, x960, x927, x954);
  let mut x963: u32 = 0;
  let mut x964: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x963, &mut x964, x962, x929, x951);
  let mut x965: u32 = 0;
  let mut x966: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x965, &mut x966, x964, x931, ((x952 as fiat_p384_u1) as u32));
  let mut x967: u32 = 0;
  let mut x968: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x967, &mut x968, x966, x933, x949);
  let mut x969: u32 = 0;
  let mut x970: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x969, &mut x970, x968, x935, x950);
  let mut x971: u32 = 0;
  let mut x972: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x971, &mut x972, x970, x937, x947);
  let mut x973: u32 = 0;
  let mut x974: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x973, &mut x974, x972, x939, x955);
  let mut x975: u32 = 0;
  let mut x976: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x975, &mut x976, x974, x941, (x956 as u32));
  let mut x977: u32 = 0;
  let mut x978: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x977, &mut x978, x976, x943, (0x0 as u32));
  let mut x979: u32 = 0;
  let mut x980: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x979, &mut x980, x978, x945, (0x0 as u32));
  let mut x981: u32 = 0;
  let mut x982: u32 = 0;
  fiat_p384_mulx_u32(&mut x981, &mut x982, x957, 0xffffffff);
  let mut x983: u32 = 0;
  let mut x984: u32 = 0;
  fiat_p384_mulx_u32(&mut x983, &mut x984, x957, 0xffffffff);
  let mut x985: u32 = 0;
  let mut x986: u32 = 0;
  fiat_p384_mulx_u32(&mut x985, &mut x986, x957, 0xffffffff);
  let mut x987: u32 = 0;
  let mut x988: u32 = 0;
  fiat_p384_mulx_u32(&mut x987, &mut x988, x957, 0xffffffff);
  let mut x989: u32 = 0;
  let mut x990: u32 = 0;
  fiat_p384_mulx_u32(&mut x989, &mut x990, x957, 0xffffffff);
  let mut x991: u32 = 0;
  let mut x992: u32 = 0;
  fiat_p384_mulx_u32(&mut x991, &mut x992, x957, 0xffffffff);
  let mut x993: u32 = 0;
  let mut x994: u32 = 0;
  fiat_p384_mulx_u32(&mut x993, &mut x994, x957, 0xffffffff);
  let mut x995: u32 = 0;
  let mut x996: u32 = 0;
  fiat_p384_mulx_u32(&mut x995, &mut x996, x957, 0xfffffffe);
  let mut x997: u32 = 0;
  let mut x998: u32 = 0;
  fiat_p384_mulx_u32(&mut x997, &mut x998, x957, 0xffffffff);
  let mut x999: u32 = 0;
  let mut x1000: u32 = 0;
  fiat_p384_mulx_u32(&mut x999, &mut x1000, x957, 0xffffffff);
  let mut x1001: u32 = 0;
  let mut x1002: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1001, &mut x1002, 0x0, x998, x995);
  let mut x1003: u32 = 0;
  let mut x1004: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1003, &mut x1004, x1002, x996, x993);
  let mut x1005: u32 = 0;
  let mut x1006: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1005, &mut x1006, x1004, x994, x991);
  let mut x1007: u32 = 0;
  let mut x1008: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1007, &mut x1008, x1006, x992, x989);
  let mut x1009: u32 = 0;
  let mut x1010: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1009, &mut x1010, x1008, x990, x987);
  let mut x1011: u32 = 0;
  let mut x1012: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1011, &mut x1012, x1010, x988, x985);
  let mut x1013: u32 = 0;
  let mut x1014: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1013, &mut x1014, x1012, x986, x983);
  let mut x1015: u32 = 0;
  let mut x1016: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1015, &mut x1016, x1014, x984, x981);
  let mut x1017: u32 = 0;
  let mut x1018: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1017, &mut x1018, 0x0, x957, x999);
  let mut x1019: u32 = 0;
  let mut x1020: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1019, &mut x1020, x1018, x959, x1000);
  let mut x1021: u32 = 0;
  let mut x1022: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1021, &mut x1022, x1020, x961, (0x0 as u32));
  let mut x1023: u32 = 0;
  let mut x1024: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1023, &mut x1024, x1022, x963, x997);
  let mut x1025: u32 = 0;
  let mut x1026: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1025, &mut x1026, x1024, x965, x1001);
  let mut x1027: u32 = 0;
  let mut x1028: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1027, &mut x1028, x1026, x967, x1003);
  let mut x1029: u32 = 0;
  let mut x1030: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1029, &mut x1030, x1028, x969, x1005);
  let mut x1031: u32 = 0;
  let mut x1032: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1031, &mut x1032, x1030, x971, x1007);
  let mut x1033: u32 = 0;
  let mut x1034: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1033, &mut x1034, x1032, x973, x1009);
  let mut x1035: u32 = 0;
  let mut x1036: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1035, &mut x1036, x1034, x975, x1011);
  let mut x1037: u32 = 0;
  let mut x1038: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1037, &mut x1038, x1036, x977, x1013);
  let mut x1039: u32 = 0;
  let mut x1040: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1039, &mut x1040, x1038, x979, x1015);
  let mut x1041: u32 = 0;
  let mut x1042: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1041, &mut x1042, x1040, ((x980 as u32) + (x946 as u32)), ((x1016 as u32) + x982));
  let mut x1043: u32 = 0;
  let mut x1044: u32 = 0;
  fiat_p384_mulx_u32(&mut x1043, &mut x1044, x11, 0x2);
  let mut x1045: u32 = 0;
  let mut x1046: u32 = 0;
  fiat_p384_mulx_u32(&mut x1045, &mut x1046, x11, 0xfffffffe);
  let mut x1047: u32 = 0;
  let mut x1048: u32 = 0;
  fiat_p384_mulx_u32(&mut x1047, &mut x1048, x11, 0x2);
  let mut x1049: u32 = 0;
  let mut x1050: u32 = 0;
  fiat_p384_mulx_u32(&mut x1049, &mut x1050, x11, 0xfffffffe);
  let mut x1051: u32 = 0;
  let mut x1052: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1051, &mut x1052, 0x0, ((x1044 as fiat_p384_u1) as u32), x11);
  let mut x1053: u32 = 0;
  let mut x1054: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1053, &mut x1054, 0x0, x1019, x11);
  let mut x1055: u32 = 0;
  let mut x1056: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1055, &mut x1056, x1054, x1021, x1049);
  let mut x1057: u32 = 0;
  let mut x1058: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1057, &mut x1058, x1056, x1023, x1050);
  let mut x1059: u32 = 0;
  let mut x1060: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1059, &mut x1060, x1058, x1025, x1047);
  let mut x1061: u32 = 0;
  let mut x1062: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1061, &mut x1062, x1060, x1027, ((x1048 as fiat_p384_u1) as u32));
  let mut x1063: u32 = 0;
  let mut x1064: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1063, &mut x1064, x1062, x1029, x1045);
  let mut x1065: u32 = 0;
  let mut x1066: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1065, &mut x1066, x1064, x1031, x1046);
  let mut x1067: u32 = 0;
  let mut x1068: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1067, &mut x1068, x1066, x1033, x1043);
  let mut x1069: u32 = 0;
  let mut x1070: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1069, &mut x1070, x1068, x1035, x1051);
  let mut x1071: u32 = 0;
  let mut x1072: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1071, &mut x1072, x1070, x1037, (x1052 as u32));
  let mut x1073: u32 = 0;
  let mut x1074: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1073, &mut x1074, x1072, x1039, (0x0 as u32));
  let mut x1075: u32 = 0;
  let mut x1076: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1075, &mut x1076, x1074, x1041, (0x0 as u32));
  let mut x1077: u32 = 0;
  let mut x1078: u32 = 0;
  fiat_p384_mulx_u32(&mut x1077, &mut x1078, x1053, 0xffffffff);
  let mut x1079: u32 = 0;
  let mut x1080: u32 = 0;
  fiat_p384_mulx_u32(&mut x1079, &mut x1080, x1053, 0xffffffff);
  let mut x1081: u32 = 0;
  let mut x1082: u32 = 0;
  fiat_p384_mulx_u32(&mut x1081, &mut x1082, x1053, 0xffffffff);
  let mut x1083: u32 = 0;
  let mut x1084: u32 = 0;
  fiat_p384_mulx_u32(&mut x1083, &mut x1084, x1053, 0xffffffff);
  let mut x1085: u32 = 0;
  let mut x1086: u32 = 0;
  fiat_p384_mulx_u32(&mut x1085, &mut x1086, x1053, 0xffffffff);
  let mut x1087: u32 = 0;
  let mut x1088: u32 = 0;
  fiat_p384_mulx_u32(&mut x1087, &mut x1088, x1053, 0xffffffff);
  let mut x1089: u32 = 0;
  let mut x1090: u32 = 0;
  fiat_p384_mulx_u32(&mut x1089, &mut x1090, x1053, 0xffffffff);
  let mut x1091: u32 = 0;
  let mut x1092: u32 = 0;
  fiat_p384_mulx_u32(&mut x1091, &mut x1092, x1053, 0xfffffffe);
  let mut x1093: u32 = 0;
  let mut x1094: u32 = 0;
  fiat_p384_mulx_u32(&mut x1093, &mut x1094, x1053, 0xffffffff);
  let mut x1095: u32 = 0;
  let mut x1096: u32 = 0;
  fiat_p384_mulx_u32(&mut x1095, &mut x1096, x1053, 0xffffffff);
  let mut x1097: u32 = 0;
  let mut x1098: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1097, &mut x1098, 0x0, x1094, x1091);
  let mut x1099: u32 = 0;
  let mut x1100: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1099, &mut x1100, x1098, x1092, x1089);
  let mut x1101: u32 = 0;
  let mut x1102: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1101, &mut x1102, x1100, x1090, x1087);
  let mut x1103: u32 = 0;
  let mut x1104: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1103, &mut x1104, x1102, x1088, x1085);
  let mut x1105: u32 = 0;
  let mut x1106: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1105, &mut x1106, x1104, x1086, x1083);
  let mut x1107: u32 = 0;
  let mut x1108: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1107, &mut x1108, x1106, x1084, x1081);
  let mut x1109: u32 = 0;
  let mut x1110: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1109, &mut x1110, x1108, x1082, x1079);
  let mut x1111: u32 = 0;
  let mut x1112: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1111, &mut x1112, x1110, x1080, x1077);
  let mut x1113: u32 = 0;
  let mut x1114: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1113, &mut x1114, 0x0, x1053, x1095);
  let mut x1115: u32 = 0;
  let mut x1116: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1115, &mut x1116, x1114, x1055, x1096);
  let mut x1117: u32 = 0;
  let mut x1118: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1117, &mut x1118, x1116, x1057, (0x0 as u32));
  let mut x1119: u32 = 0;
  let mut x1120: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1119, &mut x1120, x1118, x1059, x1093);
  let mut x1121: u32 = 0;
  let mut x1122: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1121, &mut x1122, x1120, x1061, x1097);
  let mut x1123: u32 = 0;
  let mut x1124: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1123, &mut x1124, x1122, x1063, x1099);
  let mut x1125: u32 = 0;
  let mut x1126: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1125, &mut x1126, x1124, x1065, x1101);
  let mut x1127: u32 = 0;
  let mut x1128: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1127, &mut x1128, x1126, x1067, x1103);
  let mut x1129: u32 = 0;
  let mut x1130: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1129, &mut x1130, x1128, x1069, x1105);
  let mut x1131: u32 = 0;
  let mut x1132: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1131, &mut x1132, x1130, x1071, x1107);
  let mut x1133: u32 = 0;
  let mut x1134: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1133, &mut x1134, x1132, x1073, x1109);
  let mut x1135: u32 = 0;
  let mut x1136: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1135, &mut x1136, x1134, x1075, x1111);
  let mut x1137: u32 = 0;
  let mut x1138: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1137, &mut x1138, x1136, ((x1076 as u32) + (x1042 as u32)), ((x1112 as u32) + x1078));
  let mut x1139: u32 = 0;
  let mut x1140: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1139, &mut x1140, 0x0, x1115, 0xffffffff);
  let mut x1141: u32 = 0;
  let mut x1142: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1141, &mut x1142, x1140, x1117, (0x0 as u32));
  let mut x1143: u32 = 0;
  let mut x1144: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1143, &mut x1144, x1142, x1119, (0x0 as u32));
  let mut x1145: u32 = 0;
  let mut x1146: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1145, &mut x1146, x1144, x1121, 0xffffffff);
  let mut x1147: u32 = 0;
  let mut x1148: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1147, &mut x1148, x1146, x1123, 0xfffffffe);
  let mut x1149: u32 = 0;
  let mut x1150: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1149, &mut x1150, x1148, x1125, 0xffffffff);
  let mut x1151: u32 = 0;
  let mut x1152: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1151, &mut x1152, x1150, x1127, 0xffffffff);
  let mut x1153: u32 = 0;
  let mut x1154: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1153, &mut x1154, x1152, x1129, 0xffffffff);
  let mut x1155: u32 = 0;
  let mut x1156: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1155, &mut x1156, x1154, x1131, 0xffffffff);
  let mut x1157: u32 = 0;
  let mut x1158: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1157, &mut x1158, x1156, x1133, 0xffffffff);
  let mut x1159: u32 = 0;
  let mut x1160: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1159, &mut x1160, x1158, x1135, 0xffffffff);
  let mut x1161: u32 = 0;
  let mut x1162: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1161, &mut x1162, x1160, x1137, 0xffffffff);
  let mut x1163: u32 = 0;
  let mut x1164: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x1163, &mut x1164, x1162, (x1138 as u32), (0x0 as u32));
  let mut x1165: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1165, x1164, x1139, x1115);
  let mut x1166: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1166, x1164, x1141, x1117);
  let mut x1167: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1167, x1164, x1143, x1119);
  let mut x1168: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1168, x1164, x1145, x1121);
  let mut x1169: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1169, x1164, x1147, x1123);
  let mut x1170: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1170, x1164, x1149, x1125);
  let mut x1171: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1171, x1164, x1151, x1127);
  let mut x1172: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1172, x1164, x1153, x1129);
  let mut x1173: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1173, x1164, x1155, x1131);
  let mut x1174: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1174, x1164, x1157, x1133);
  let mut x1175: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1175, x1164, x1159, x1135);
  let mut x1176: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1176, x1164, x1161, x1137);
  out1[0] = x1165;
  out1[1] = x1166;
  out1[2] = x1167;
  out1[3] = x1168;
  out1[4] = x1169;
  out1[5] = x1170;
  out1[6] = x1171;
  out1[7] = x1172;
  out1[8] = x1173;
  out1[9] = x1174;
  out1[10] = x1175;
  out1[11] = x1176;
}

/// The function fiat_p384_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p384_nonzero(out1: &mut u32, arg1: &[u32; 12]) {
  let x1: u32 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | ((arg1[7]) | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | (arg1[11]))))))))))));
  *out1 = x1;
}

/// The function fiat_p384_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_selectznz(out1: &mut [u32; 12], arg1: fiat_p384_u1, arg2: &[u32; 12], arg3: &[u32; 12]) {
  let mut x1: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  let mut x9: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x9, arg1, (arg2[8]), (arg3[8]));
  let mut x10: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x10, arg1, (arg2[9]), (arg3[9]));
  let mut x11: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x11, arg1, (arg2[10]), (arg3[10]));
  let mut x12: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x12, arg1, (arg2[11]), (arg3[11]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
}

/// The function fiat_p384_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p384_to_bytes(out1: &mut [u8; 48], arg1: &[u32; 12]) {
  let x1: u32 = (arg1[11]);
  let x2: u32 = (arg1[10]);
  let x3: u32 = (arg1[9]);
  let x4: u32 = (arg1[8]);
  let x5: u32 = (arg1[7]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[5]);
  let x8: u32 = (arg1[4]);
  let x9: u32 = (arg1[3]);
  let x10: u32 = (arg1[2]);
  let x11: u32 = (arg1[1]);
  let x12: u32 = (arg1[0]);
  let x13: u8 = ((x12 & (0xff as u32)) as u8);
  let x14: u32 = (x12 >> 8);
  let x15: u8 = ((x14 & (0xff as u32)) as u8);
  let x16: u32 = (x14 >> 8);
  let x17: u8 = ((x16 & (0xff as u32)) as u8);
  let x18: u8 = ((x16 >> 8) as u8);
  let x19: u8 = ((x11 & (0xff as u32)) as u8);
  let x20: u32 = (x11 >> 8);
  let x21: u8 = ((x20 & (0xff as u32)) as u8);
  let x22: u32 = (x20 >> 8);
  let x23: u8 = ((x22 & (0xff as u32)) as u8);
  let x24: u8 = ((x22 >> 8) as u8);
  let x25: u8 = ((x10 & (0xff as u32)) as u8);
  let x26: u32 = (x10 >> 8);
  let x27: u8 = ((x26 & (0xff as u32)) as u8);
  let x28: u32 = (x26 >> 8);
  let x29: u8 = ((x28 & (0xff as u32)) as u8);
  let x30: u8 = ((x28 >> 8) as u8);
  let x31: u8 = ((x9 & (0xff as u32)) as u8);
  let x32: u32 = (x9 >> 8);
  let x33: u8 = ((x32 & (0xff as u32)) as u8);
  let x34: u32 = (x32 >> 8);
  let x35: u8 = ((x34 & (0xff as u32)) as u8);
  let x36: u8 = ((x34 >> 8) as u8);
  let x37: u8 = ((x8 & (0xff as u32)) as u8);
  let x38: u32 = (x8 >> 8);
  let x39: u8 = ((x38 & (0xff as u32)) as u8);
  let x40: u32 = (x38 >> 8);
  let x41: u8 = ((x40 & (0xff as u32)) as u8);
  let x42: u8 = ((x40 >> 8) as u8);
  let x43: u8 = ((x7 & (0xff as u32)) as u8);
  let x44: u32 = (x7 >> 8);
  let x45: u8 = ((x44 & (0xff as u32)) as u8);
  let x46: u32 = (x44 >> 8);
  let x47: u8 = ((x46 & (0xff as u32)) as u8);
  let x48: u8 = ((x46 >> 8) as u8);
  let x49: u8 = ((x6 & (0xff as u32)) as u8);
  let x50: u32 = (x6 >> 8);
  let x51: u8 = ((x50 & (0xff as u32)) as u8);
  let x52: u32 = (x50 >> 8);
  let x53: u8 = ((x52 & (0xff as u32)) as u8);
  let x54: u8 = ((x52 >> 8) as u8);
  let x55: u8 = ((x5 & (0xff as u32)) as u8);
  let x56: u32 = (x5 >> 8);
  let x57: u8 = ((x56 & (0xff as u32)) as u8);
  let x58: u32 = (x56 >> 8);
  let x59: u8 = ((x58 & (0xff as u32)) as u8);
  let x60: u8 = ((x58 >> 8) as u8);
  let x61: u8 = ((x4 & (0xff as u32)) as u8);
  let x62: u32 = (x4 >> 8);
  let x63: u8 = ((x62 & (0xff as u32)) as u8);
  let x64: u32 = (x62 >> 8);
  let x65: u8 = ((x64 & (0xff as u32)) as u8);
  let x66: u8 = ((x64 >> 8) as u8);
  let x67: u8 = ((x3 & (0xff as u32)) as u8);
  let x68: u32 = (x3 >> 8);
  let x69: u8 = ((x68 & (0xff as u32)) as u8);
  let x70: u32 = (x68 >> 8);
  let x71: u8 = ((x70 & (0xff as u32)) as u8);
  let x72: u8 = ((x70 >> 8) as u8);
  let x73: u8 = ((x2 & (0xff as u32)) as u8);
  let x74: u32 = (x2 >> 8);
  let x75: u8 = ((x74 & (0xff as u32)) as u8);
  let x76: u32 = (x74 >> 8);
  let x77: u8 = ((x76 & (0xff as u32)) as u8);
  let x78: u8 = ((x76 >> 8) as u8);
  let x79: u8 = ((x1 & (0xff as u32)) as u8);
  let x80: u32 = (x1 >> 8);
  let x81: u8 = ((x80 & (0xff as u32)) as u8);
  let x82: u32 = (x80 >> 8);
  let x83: u8 = ((x82 & (0xff as u32)) as u8);
  let x84: u8 = ((x82 >> 8) as u8);
  out1[0] = x13;
  out1[1] = x15;
  out1[2] = x17;
  out1[3] = x18;
  out1[4] = x19;
  out1[5] = x21;
  out1[6] = x23;
  out1[7] = x24;
  out1[8] = x25;
  out1[9] = x27;
  out1[10] = x29;
  out1[11] = x30;
  out1[12] = x31;
  out1[13] = x33;
  out1[14] = x35;
  out1[15] = x36;
  out1[16] = x37;
  out1[17] = x39;
  out1[18] = x41;
  out1[19] = x42;
  out1[20] = x43;
  out1[21] = x45;
  out1[22] = x47;
  out1[23] = x48;
  out1[24] = x49;
  out1[25] = x51;
  out1[26] = x53;
  out1[27] = x54;
  out1[28] = x55;
  out1[29] = x57;
  out1[30] = x59;
  out1[31] = x60;
  out1[32] = x61;
  out1[33] = x63;
  out1[34] = x65;
  out1[35] = x66;
  out1[36] = x67;
  out1[37] = x69;
  out1[38] = x71;
  out1[39] = x72;
  out1[40] = x73;
  out1[41] = x75;
  out1[42] = x77;
  out1[43] = x78;
  out1[44] = x79;
  out1[45] = x81;
  out1[46] = x83;
  out1[47] = x84;
}

/// The function fiat_p384_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_from_bytes(out1: &mut [u32; 12], arg1: &[u8; 48]) {
  let x1: u32 = (((arg1[47]) as u32) << 24);
  let x2: u32 = (((arg1[46]) as u32) << 16);
  let x3: u32 = (((arg1[45]) as u32) << 8);
  let x4: u8 = (arg1[44]);
  let x5: u32 = (((arg1[43]) as u32) << 24);
  let x6: u32 = (((arg1[42]) as u32) << 16);
  let x7: u32 = (((arg1[41]) as u32) << 8);
  let x8: u8 = (arg1[40]);
  let x9: u32 = (((arg1[39]) as u32) << 24);
  let x10: u32 = (((arg1[38]) as u32) << 16);
  let x11: u32 = (((arg1[37]) as u32) << 8);
  let x12: u8 = (arg1[36]);
  let x13: u32 = (((arg1[35]) as u32) << 24);
  let x14: u32 = (((arg1[34]) as u32) << 16);
  let x15: u32 = (((arg1[33]) as u32) << 8);
  let x16: u8 = (arg1[32]);
  let x17: u32 = (((arg1[31]) as u32) << 24);
  let x18: u32 = (((arg1[30]) as u32) << 16);
  let x19: u32 = (((arg1[29]) as u32) << 8);
  let x20: u8 = (arg1[28]);
  let x21: u32 = (((arg1[27]) as u32) << 24);
  let x22: u32 = (((arg1[26]) as u32) << 16);
  let x23: u32 = (((arg1[25]) as u32) << 8);
  let x24: u8 = (arg1[24]);
  let x25: u32 = (((arg1[23]) as u32) << 24);
  let x26: u32 = (((arg1[22]) as u32) << 16);
  let x27: u32 = (((arg1[21]) as u32) << 8);
  let x28: u8 = (arg1[20]);
  let x29: u32 = (((arg1[19]) as u32) << 24);
  let x30: u32 = (((arg1[18]) as u32) << 16);
  let x31: u32 = (((arg1[17]) as u32) << 8);
  let x32: u8 = (arg1[16]);
  let x33: u32 = (((arg1[15]) as u32) << 24);
  let x34: u32 = (((arg1[14]) as u32) << 16);
  let x35: u32 = (((arg1[13]) as u32) << 8);
  let x36: u8 = (arg1[12]);
  let x37: u32 = (((arg1[11]) as u32) << 24);
  let x38: u32 = (((arg1[10]) as u32) << 16);
  let x39: u32 = (((arg1[9]) as u32) << 8);
  let x40: u8 = (arg1[8]);
  let x41: u32 = (((arg1[7]) as u32) << 24);
  let x42: u32 = (((arg1[6]) as u32) << 16);
  let x43: u32 = (((arg1[5]) as u32) << 8);
  let x44: u8 = (arg1[4]);
  let x45: u32 = (((arg1[3]) as u32) << 24);
  let x46: u32 = (((arg1[2]) as u32) << 16);
  let x47: u32 = (((arg1[1]) as u32) << 8);
  let x48: u8 = (arg1[0]);
  let x49: u32 = (x47 + (x48 as u32));
  let x50: u32 = (x46 + x49);
  let x51: u32 = (x45 + x50);
  let x52: u32 = (x43 + (x44 as u32));
  let x53: u32 = (x42 + x52);
  let x54: u32 = (x41 + x53);
  let x55: u32 = (x39 + (x40 as u32));
  let x56: u32 = (x38 + x55);
  let x57: u32 = (x37 + x56);
  let x58: u32 = (x35 + (x36 as u32));
  let x59: u32 = (x34 + x58);
  let x60: u32 = (x33 + x59);
  let x61: u32 = (x31 + (x32 as u32));
  let x62: u32 = (x30 + x61);
  let x63: u32 = (x29 + x62);
  let x64: u32 = (x27 + (x28 as u32));
  let x65: u32 = (x26 + x64);
  let x66: u32 = (x25 + x65);
  let x67: u32 = (x23 + (x24 as u32));
  let x68: u32 = (x22 + x67);
  let x69: u32 = (x21 + x68);
  let x70: u32 = (x19 + (x20 as u32));
  let x71: u32 = (x18 + x70);
  let x72: u32 = (x17 + x71);
  let x73: u32 = (x15 + (x16 as u32));
  let x74: u32 = (x14 + x73);
  let x75: u32 = (x13 + x74);
  let x76: u32 = (x11 + (x12 as u32));
  let x77: u32 = (x10 + x76);
  let x78: u32 = (x9 + x77);
  let x79: u32 = (x7 + (x8 as u32));
  let x80: u32 = (x6 + x79);
  let x81: u32 = (x5 + x80);
  let x82: u32 = (x3 + (x4 as u32));
  let x83: u32 = (x2 + x82);
  let x84: u32 = (x1 + x83);
  out1[0] = x51;
  out1[1] = x54;
  out1[2] = x57;
  out1[3] = x60;
  out1[4] = x63;
  out1[5] = x66;
  out1[6] = x69;
  out1[7] = x72;
  out1[8] = x75;
  out1[9] = x78;
  out1[10] = x81;
  out1[11] = x84;
}

/// The function fiat_p384_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_set_one(out1: &mut fiat_p384_montgomery_domain_field_element) {
  out1[0] = (0x1 as u32);
  out1[1] = 0xffffffff;
  out1[2] = 0xffffffff;
  out1[3] = (0x0 as u32);
  out1[4] = (0x1 as u32);
  out1[5] = (0x0 as u32);
  out1[6] = (0x0 as u32);
  out1[7] = (0x0 as u32);
  out1[8] = (0x0 as u32);
  out1[9] = (0x0 as u32);
  out1[10] = (0x0 as u32);
  out1[11] = (0x0 as u32);
}

/// The function fiat_p384_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_msat(out1: &mut [u32; 13]) {
  out1[0] = 0xffffffff;
  out1[1] = (0x0 as u32);
  out1[2] = (0x0 as u32);
  out1[3] = 0xffffffff;
  out1[4] = 0xfffffffe;
  out1[5] = 0xffffffff;
  out1[6] = 0xffffffff;
  out1[7] = 0xffffffff;
  out1[8] = 0xffffffff;
  out1[9] = 0xffffffff;
  out1[10] = 0xffffffff;
  out1[11] = 0xffffffff;
  out1[12] = (0x0 as u32);
}

/// The function fiat_p384_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_divstep(out1: &mut u32, out2: &mut [u32; 13], out3: &mut [u32; 13], out4: &mut [u32; 12], out5: &mut [u32; 12], arg1: u32, arg2: &[u32; 13], arg3: &[u32; 13], arg4: &[u32; 12], arg5: &[u32; 12]) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u32));
  let x3: fiat_p384_u1 = (((x1 >> 31) as fiat_p384_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p384_u1));
  let mut x4: u32 = 0;
  let mut x5: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u32));
  let mut x6: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x6, x3, arg1, x4);
  let mut x7: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x14, x3, (arg2[7]), (arg3[7]));
  let mut x15: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x15, x3, (arg2[8]), (arg3[8]));
  let mut x16: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x16, x3, (arg2[9]), (arg3[9]));
  let mut x17: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x17, x3, (arg2[10]), (arg3[10]));
  let mut x18: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x18, x3, (arg2[11]), (arg3[11]));
  let mut x19: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x19, x3, (arg2[12]), (arg3[12]));
  let mut x20: u32 = 0;
  let mut x21: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x20, &mut x21, 0x0, (0x1 as u32), (!(arg2[0])));
  let mut x22: u32 = 0;
  let mut x23: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), (!(arg2[1])));
  let mut x24: u32 = 0;
  let mut x25: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), (!(arg2[2])));
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), (!(arg2[3])));
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), (!(arg2[4])));
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), (!(arg2[5])));
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), (!(arg2[6])));
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x34, &mut x35, x33, (0x0 as u32), (!(arg2[7])));
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x36, &mut x37, x35, (0x0 as u32), (!(arg2[8])));
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x38, &mut x39, x37, (0x0 as u32), (!(arg2[9])));
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x40, &mut x41, x39, (0x0 as u32), (!(arg2[10])));
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x42, &mut x43, x41, (0x0 as u32), (!(arg2[11])));
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x44, &mut x45, x43, (0x0 as u32), (!(arg2[12])));
  let mut x46: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x46, x3, (arg3[0]), x20);
  let mut x47: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x47, x3, (arg3[1]), x22);
  let mut x48: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x48, x3, (arg3[2]), x24);
  let mut x49: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x49, x3, (arg3[3]), x26);
  let mut x50: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x50, x3, (arg3[4]), x28);
  let mut x51: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x51, x3, (arg3[5]), x30);
  let mut x52: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x52, x3, (arg3[6]), x32);
  let mut x53: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x53, x3, (arg3[7]), x34);
  let mut x54: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x54, x3, (arg3[8]), x36);
  let mut x55: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x55, x3, (arg3[9]), x38);
  let mut x56: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x56, x3, (arg3[10]), x40);
  let mut x57: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x57, x3, (arg3[11]), x42);
  let mut x58: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x58, x3, (arg3[12]), x44);
  let mut x59: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x59, x3, (arg4[0]), (arg5[0]));
  let mut x60: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x60, x3, (arg4[1]), (arg5[1]));
  let mut x61: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x61, x3, (arg4[2]), (arg5[2]));
  let mut x62: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x62, x3, (arg4[3]), (arg5[3]));
  let mut x63: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x63, x3, (arg4[4]), (arg5[4]));
  let mut x64: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x64, x3, (arg4[5]), (arg5[5]));
  let mut x65: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x65, x3, (arg4[6]), (arg5[6]));
  let mut x66: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x66, x3, (arg4[7]), (arg5[7]));
  let mut x67: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x67, x3, (arg4[8]), (arg5[8]));
  let mut x68: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x68, x3, (arg4[9]), (arg5[9]));
  let mut x69: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x69, x3, (arg4[10]), (arg5[10]));
  let mut x70: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x70, x3, (arg4[11]), (arg5[11]));
  let mut x71: u32 = 0;
  let mut x72: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x71, &mut x72, 0x0, x59, x59);
  let mut x73: u32 = 0;
  let mut x74: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x73, &mut x74, x72, x60, x60);
  let mut x75: u32 = 0;
  let mut x76: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x75, &mut x76, x74, x61, x61);
  let mut x77: u32 = 0;
  let mut x78: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x77, &mut x78, x76, x62, x62);
  let mut x79: u32 = 0;
  let mut x80: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x79, &mut x80, x78, x63, x63);
  let mut x81: u32 = 0;
  let mut x82: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x81, &mut x82, x80, x64, x64);
  let mut x83: u32 = 0;
  let mut x84: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x83, &mut x84, x82, x65, x65);
  let mut x85: u32 = 0;
  let mut x86: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x85, &mut x86, x84, x66, x66);
  let mut x87: u32 = 0;
  let mut x88: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x87, &mut x88, x86, x67, x67);
  let mut x89: u32 = 0;
  let mut x90: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x89, &mut x90, x88, x68, x68);
  let mut x91: u32 = 0;
  let mut x92: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x91, &mut x92, x90, x69, x69);
  let mut x93: u32 = 0;
  let mut x94: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x93, &mut x94, x92, x70, x70);
  let mut x95: u32 = 0;
  let mut x96: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x95, &mut x96, 0x0, x71, 0xffffffff);
  let mut x97: u32 = 0;
  let mut x98: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x97, &mut x98, x96, x73, (0x0 as u32));
  let mut x99: u32 = 0;
  let mut x100: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x99, &mut x100, x98, x75, (0x0 as u32));
  let mut x101: u32 = 0;
  let mut x102: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x101, &mut x102, x100, x77, 0xffffffff);
  let mut x103: u32 = 0;
  let mut x104: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x103, &mut x104, x102, x79, 0xfffffffe);
  let mut x105: u32 = 0;
  let mut x106: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x105, &mut x106, x104, x81, 0xffffffff);
  let mut x107: u32 = 0;
  let mut x108: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x107, &mut x108, x106, x83, 0xffffffff);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x109, &mut x110, x108, x85, 0xffffffff);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x111, &mut x112, x110, x87, 0xffffffff);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x113, &mut x114, x112, x89, 0xffffffff);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x115, &mut x116, x114, x91, 0xffffffff);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x117, &mut x118, x116, x93, 0xffffffff);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x119, &mut x120, x118, (x94 as u32), (0x0 as u32));
  let x121: u32 = (arg4[11]);
  let x122: u32 = (arg4[10]);
  let x123: u32 = (arg4[9]);
  let x124: u32 = (arg4[8]);
  let x125: u32 = (arg4[7]);
  let x126: u32 = (arg4[6]);
  let x127: u32 = (arg4[5]);
  let x128: u32 = (arg4[4]);
  let x129: u32 = (arg4[3]);
  let x130: u32 = (arg4[2]);
  let x131: u32 = (arg4[1]);
  let x132: u32 = (arg4[0]);
  let mut x133: u32 = 0;
  let mut x134: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x133, &mut x134, 0x0, (0x0 as u32), x132);
  let mut x135: u32 = 0;
  let mut x136: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x135, &mut x136, x134, (0x0 as u32), x131);
  let mut x137: u32 = 0;
  let mut x138: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x137, &mut x138, x136, (0x0 as u32), x130);
  let mut x139: u32 = 0;
  let mut x140: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x139, &mut x140, x138, (0x0 as u32), x129);
  let mut x141: u32 = 0;
  let mut x142: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x141, &mut x142, x140, (0x0 as u32), x128);
  let mut x143: u32 = 0;
  let mut x144: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x143, &mut x144, x142, (0x0 as u32), x127);
  let mut x145: u32 = 0;
  let mut x146: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x145, &mut x146, x144, (0x0 as u32), x126);
  let mut x147: u32 = 0;
  let mut x148: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x147, &mut x148, x146, (0x0 as u32), x125);
  let mut x149: u32 = 0;
  let mut x150: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x149, &mut x150, x148, (0x0 as u32), x124);
  let mut x151: u32 = 0;
  let mut x152: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x151, &mut x152, x150, (0x0 as u32), x123);
  let mut x153: u32 = 0;
  let mut x154: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x153, &mut x154, x152, (0x0 as u32), x122);
  let mut x155: u32 = 0;
  let mut x156: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x155, &mut x156, x154, (0x0 as u32), x121);
  let mut x157: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x157, x156, (0x0 as u32), 0xffffffff);
  let mut x158: u32 = 0;
  let mut x159: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x158, &mut x159, 0x0, x133, x157);
  let mut x160: u32 = 0;
  let mut x161: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x160, &mut x161, x159, x135, (0x0 as u32));
  let mut x162: u32 = 0;
  let mut x163: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x162, &mut x163, x161, x137, (0x0 as u32));
  let mut x164: u32 = 0;
  let mut x165: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x164, &mut x165, x163, x139, x157);
  let mut x166: u32 = 0;
  let mut x167: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x166, &mut x167, x165, x141, (x157 & 0xfffffffe));
  let mut x168: u32 = 0;
  let mut x169: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x168, &mut x169, x167, x143, x157);
  let mut x170: u32 = 0;
  let mut x171: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x170, &mut x171, x169, x145, x157);
  let mut x172: u32 = 0;
  let mut x173: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x172, &mut x173, x171, x147, x157);
  let mut x174: u32 = 0;
  let mut x175: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x174, &mut x175, x173, x149, x157);
  let mut x176: u32 = 0;
  let mut x177: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x176, &mut x177, x175, x151, x157);
  let mut x178: u32 = 0;
  let mut x179: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x178, &mut x179, x177, x153, x157);
  let mut x180: u32 = 0;
  let mut x181: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x180, &mut x181, x179, x155, x157);
  let mut x182: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x182, x3, (arg5[0]), x158);
  let mut x183: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x183, x3, (arg5[1]), x160);
  let mut x184: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x184, x3, (arg5[2]), x162);
  let mut x185: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x185, x3, (arg5[3]), x164);
  let mut x186: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x186, x3, (arg5[4]), x166);
  let mut x187: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x187, x3, (arg5[5]), x168);
  let mut x188: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x188, x3, (arg5[6]), x170);
  let mut x189: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x189, x3, (arg5[7]), x172);
  let mut x190: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x190, x3, (arg5[8]), x174);
  let mut x191: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x191, x3, (arg5[9]), x176);
  let mut x192: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x192, x3, (arg5[10]), x178);
  let mut x193: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x193, x3, (arg5[11]), x180);
  let x194: fiat_p384_u1 = ((x46 & (0x1 as u32)) as fiat_p384_u1);
  let mut x195: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x195, x194, (0x0 as u32), x7);
  let mut x196: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x196, x194, (0x0 as u32), x8);
  let mut x197: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x197, x194, (0x0 as u32), x9);
  let mut x198: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x198, x194, (0x0 as u32), x10);
  let mut x199: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x199, x194, (0x0 as u32), x11);
  let mut x200: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x200, x194, (0x0 as u32), x12);
  let mut x201: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x201, x194, (0x0 as u32), x13);
  let mut x202: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x202, x194, (0x0 as u32), x14);
  let mut x203: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x203, x194, (0x0 as u32), x15);
  let mut x204: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x204, x194, (0x0 as u32), x16);
  let mut x205: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x205, x194, (0x0 as u32), x17);
  let mut x206: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x206, x194, (0x0 as u32), x18);
  let mut x207: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x207, x194, (0x0 as u32), x19);
  let mut x208: u32 = 0;
  let mut x209: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x208, &mut x209, 0x0, x46, x195);
  let mut x210: u32 = 0;
  let mut x211: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x210, &mut x211, x209, x47, x196);
  let mut x212: u32 = 0;
  let mut x213: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x212, &mut x213, x211, x48, x197);
  let mut x214: u32 = 0;
  let mut x215: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x214, &mut x215, x213, x49, x198);
  let mut x216: u32 = 0;
  let mut x217: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x216, &mut x217, x215, x50, x199);
  let mut x218: u32 = 0;
  let mut x219: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x218, &mut x219, x217, x51, x200);
  let mut x220: u32 = 0;
  let mut x221: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x220, &mut x221, x219, x52, x201);
  let mut x222: u32 = 0;
  let mut x223: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x222, &mut x223, x221, x53, x202);
  let mut x224: u32 = 0;
  let mut x225: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x224, &mut x225, x223, x54, x203);
  let mut x226: u32 = 0;
  let mut x227: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x226, &mut x227, x225, x55, x204);
  let mut x228: u32 = 0;
  let mut x229: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x228, &mut x229, x227, x56, x205);
  let mut x230: u32 = 0;
  let mut x231: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x230, &mut x231, x229, x57, x206);
  let mut x232: u32 = 0;
  let mut x233: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x232, &mut x233, x231, x58, x207);
  let mut x234: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x234, x194, (0x0 as u32), x59);
  let mut x235: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x235, x194, (0x0 as u32), x60);
  let mut x236: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x236, x194, (0x0 as u32), x61);
  let mut x237: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x237, x194, (0x0 as u32), x62);
  let mut x238: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x238, x194, (0x0 as u32), x63);
  let mut x239: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x239, x194, (0x0 as u32), x64);
  let mut x240: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x240, x194, (0x0 as u32), x65);
  let mut x241: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x241, x194, (0x0 as u32), x66);
  let mut x242: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x242, x194, (0x0 as u32), x67);
  let mut x243: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x243, x194, (0x0 as u32), x68);
  let mut x244: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x244, x194, (0x0 as u32), x69);
  let mut x245: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x245, x194, (0x0 as u32), x70);
  let mut x246: u32 = 0;
  let mut x247: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x246, &mut x247, 0x0, x182, x234);
  let mut x248: u32 = 0;
  let mut x249: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x248, &mut x249, x247, x183, x235);
  let mut x250: u32 = 0;
  let mut x251: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x250, &mut x251, x249, x184, x236);
  let mut x252: u32 = 0;
  let mut x253: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x252, &mut x253, x251, x185, x237);
  let mut x254: u32 = 0;
  let mut x255: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x254, &mut x255, x253, x186, x238);
  let mut x256: u32 = 0;
  let mut x257: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x256, &mut x257, x255, x187, x239);
  let mut x258: u32 = 0;
  let mut x259: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x258, &mut x259, x257, x188, x240);
  let mut x260: u32 = 0;
  let mut x261: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x260, &mut x261, x259, x189, x241);
  let mut x262: u32 = 0;
  let mut x263: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x262, &mut x263, x261, x190, x242);
  let mut x264: u32 = 0;
  let mut x265: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x264, &mut x265, x263, x191, x243);
  let mut x266: u32 = 0;
  let mut x267: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x266, &mut x267, x265, x192, x244);
  let mut x268: u32 = 0;
  let mut x269: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x268, &mut x269, x267, x193, x245);
  let mut x270: u32 = 0;
  let mut x271: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x270, &mut x271, 0x0, x246, 0xffffffff);
  let mut x272: u32 = 0;
  let mut x273: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x272, &mut x273, x271, x248, (0x0 as u32));
  let mut x274: u32 = 0;
  let mut x275: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x274, &mut x275, x273, x250, (0x0 as u32));
  let mut x276: u32 = 0;
  let mut x277: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x276, &mut x277, x275, x252, 0xffffffff);
  let mut x278: u32 = 0;
  let mut x279: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x278, &mut x279, x277, x254, 0xfffffffe);
  let mut x280: u32 = 0;
  let mut x281: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x280, &mut x281, x279, x256, 0xffffffff);
  let mut x282: u32 = 0;
  let mut x283: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x282, &mut x283, x281, x258, 0xffffffff);
  let mut x284: u32 = 0;
  let mut x285: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x284, &mut x285, x283, x260, 0xffffffff);
  let mut x286: u32 = 0;
  let mut x287: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x286, &mut x287, x285, x262, 0xffffffff);
  let mut x288: u32 = 0;
  let mut x289: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x288, &mut x289, x287, x264, 0xffffffff);
  let mut x290: u32 = 0;
  let mut x291: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x290, &mut x291, x289, x266, 0xffffffff);
  let mut x292: u32 = 0;
  let mut x293: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x292, &mut x293, x291, x268, 0xffffffff);
  let mut x294: u32 = 0;
  let mut x295: fiat_p384_u1 = 0;
  fiat_p384_subborrowx_u32(&mut x294, &mut x295, x293, (x269 as u32), (0x0 as u32));
  let mut x296: u32 = 0;
  let mut x297: fiat_p384_u1 = 0;
  fiat_p384_addcarryx_u32(&mut x296, &mut x297, 0x0, x6, (0x1 as u32));
  let x298: u32 = ((x208 >> 1) | ((x210 << 31) & 0xffffffff));
  let x299: u32 = ((x210 >> 1) | ((x212 << 31) & 0xffffffff));
  let x300: u32 = ((x212 >> 1) | ((x214 << 31) & 0xffffffff));
  let x301: u32 = ((x214 >> 1) | ((x216 << 31) & 0xffffffff));
  let x302: u32 = ((x216 >> 1) | ((x218 << 31) & 0xffffffff));
  let x303: u32 = ((x218 >> 1) | ((x220 << 31) & 0xffffffff));
  let x304: u32 = ((x220 >> 1) | ((x222 << 31) & 0xffffffff));
  let x305: u32 = ((x222 >> 1) | ((x224 << 31) & 0xffffffff));
  let x306: u32 = ((x224 >> 1) | ((x226 << 31) & 0xffffffff));
  let x307: u32 = ((x226 >> 1) | ((x228 << 31) & 0xffffffff));
  let x308: u32 = ((x228 >> 1) | ((x230 << 31) & 0xffffffff));
  let x309: u32 = ((x230 >> 1) | ((x232 << 31) & 0xffffffff));
  let x310: u32 = ((x232 & 0x80000000) | (x232 >> 1));
  let mut x311: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x311, x120, x95, x71);
  let mut x312: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x312, x120, x97, x73);
  let mut x313: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x313, x120, x99, x75);
  let mut x314: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x314, x120, x101, x77);
  let mut x315: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x315, x120, x103, x79);
  let mut x316: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x316, x120, x105, x81);
  let mut x317: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x317, x120, x107, x83);
  let mut x318: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x318, x120, x109, x85);
  let mut x319: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x319, x120, x111, x87);
  let mut x320: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x320, x120, x113, x89);
  let mut x321: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x321, x120, x115, x91);
  let mut x322: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x322, x120, x117, x93);
  let mut x323: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x323, x295, x270, x246);
  let mut x324: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x324, x295, x272, x248);
  let mut x325: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x325, x295, x274, x250);
  let mut x326: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x326, x295, x276, x252);
  let mut x327: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x327, x295, x278, x254);
  let mut x328: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x328, x295, x280, x256);
  let mut x329: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x329, x295, x282, x258);
  let mut x330: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x330, x295, x284, x260);
  let mut x331: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x331, x295, x286, x262);
  let mut x332: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x332, x295, x288, x264);
  let mut x333: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x333, x295, x290, x266);
  let mut x334: u32 = 0;
  fiat_p384_cmovznz_u32(&mut x334, x295, x292, x268);
  *out1 = x296;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out2[9] = x16;
  out2[10] = x17;
  out2[11] = x18;
  out2[12] = x19;
  out3[0] = x298;
  out3[1] = x299;
  out3[2] = x300;
  out3[3] = x301;
  out3[4] = x302;
  out3[5] = x303;
  out3[6] = x304;
  out3[7] = x305;
  out3[8] = x306;
  out3[9] = x307;
  out3[10] = x308;
  out3[11] = x309;
  out3[12] = x310;
  out4[0] = x311;
  out4[1] = x312;
  out4[2] = x313;
  out4[3] = x314;
  out4[4] = x315;
  out4[5] = x316;
  out4[6] = x317;
  out4[7] = x318;
  out4[8] = x319;
  out4[9] = x320;
  out4[10] = x321;
  out4[11] = x322;
  out5[0] = x323;
  out5[1] = x324;
  out5[2] = x325;
  out5[3] = x326;
  out5[4] = x327;
  out5[5] = x328;
  out5[6] = x329;
  out5[7] = x330;
  out5[8] = x331;
  out5[9] = x332;
  out5[10] = x333;
  out5[11] = x334;
}

/// The function fiat_p384_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_divstep_precomp(out1: &mut [u32; 12]) {
  out1[0] = 0xfff18fff;
  out1[1] = 0xfff69400;
  out1[2] = 0xffffd3ff;
  out1[3] = 0x2b7fe;
  out1[4] = 0xfffe97ff;
  out1[5] = 0xfffedbff;
  out1[6] = 0x2fff;
  out1[7] = 0x28400;
  out1[8] = 0x50400;
  out1[9] = 0x60400;
  out1[10] = 0x38000;
  out1[11] = 0xfffc4800;
}
