The address of temporary value was taken.

Erroneous code example:

```compile_fail,E0745
fn temp_address() {
    let ptr = &raw const 2; // error!
}
```

In this example, `2` is destroyed right after the assignment, which means that
`ptr` now points to an unavailable location.

To avoid this error, first bind the temporary to a named local variable:

```
fn temp_address() {
    let val = 2;
    let ptr = &raw const val; // ok!
}
```
